<?php
$negociacao = $this->get("negociacao");
$pessoasEnvolvidas = $this->get("pessoasEnvolvidas");
$parcelaSelecionada =  $this->get("parcelaSelecionada");
$parcelaNegociadas = $this->get("listaNegociadas");
$qtdeParcelas = $this->get("qtdeParcelas");
$empreendimentoInfo = $this->get("empreendimentoInfo");
$documento = $this->get("documento");
//cliente
$clienteAcade = $this->get("clienteAcade");
$cliente = $negociacao['nm_pessoa'];
$cpfCliente = $negociacao['cpfCli'];
$cnpjCliente = $negociacao['nr_cnpj'];
$empresa = $negociacao['nm_empreendimento'];
$cidadeCli = $negociacao["cidadeCli"] . "/" . $negociacao["ufCli"];
$loteNum = $negociacao['lote'];
$quadra = $negociacao['quadra'];
$parcNome = array(
    'N' => 'Normal',
    'NE' => 'Normal',
    'C' => 'Chaves',
    'CE' => 'Chaves',
    'I' => 'Intercalada',
    'IE' => 'Intercalada',
    'S' => 'Sinal',
    'SE' => 'Sinal',
    'G' => 'Negociao',
    'Q' => 'Quitada'
);
?>
<?php 
    $posicaoPagina = 8;
    if (count($parcelaSelecionada) > 15)
        $posicaoPagina = 10;
?>
<page backtop=<?= $posicaoPagina."mm" ?> backbottom="8mm">
    <style type="text/css">
        table.bordasimples {
            border-collapse: collapse;
        }

        table.bordasimples thead tr th,
        table.bordasimples tbody tr td {
            border: 1px solid #000000;
            width: 200px;
        }

        .topdiv {
            text-align: left;
            font-size: 20px;
            margin-top: 1px;
        }

        div {
            page-break-inside: always;
        }
    </style>
    <div>
        <?php if($documento != 'word') :?>
            <div class="topdiv">
                <!-- Logomarca Cliente Acade -->
                <?php

                $dsEndLogomarca = $clienteAcade['ds_end_logomarca'];
                $dsEmpreendimentoPathLogo = $empreendimentoInfo['ds_path_logo'];

                if ($dsEmpreendimentoPathLogo && file_exists($dsEmpreendimentoPathLogo)) {
                    echo '<img src="' . $dsEmpreendimentoPathLogo . '" alt="' . $cabecalho['empreendimento'] . '" height="90" />';
                } elseif ($dsEndLogomarca && file_exists($dsEndLogomarca)) {
                    echo '<img src="' . $dsEndLogomarca . '" alt="' . $clienteAcade['nm_fantasia'] . '" height="90">';
                } else {
                    echo '<img style="float: left; " src="' . LOGOMARCA_DEFAULT . '" alt="LogoPadrao" height="90">';
                }

                ?>
            </div>
        <?php endif;?>
        <div style="text-align: right; margin-right: 35px">
            <span>
                <?php
                $mes = array(
                    1 => 'janeiro',
                    2 => 'fevereiro',
                    3 => 'mar&ccedil;o',
                    4 => 'abril',
                    5 => 'maio',
                    6 => 'junho',
                    7 => 'julho',
                    8 => 'agosto',
                    9 => 'setembro',
                    10 => 'outubro',
                    11 => 'novembro',
                    12 => 'dezembro'
                );
                echo $negociacao["cidade"] . ", " . utf8_decode(date("d") . ' de ' . $mes[date("n")] . ' de ' . date("Y") . "."); ?>
            </span>
        </div>
    </div>

    <span style="font-weight: bold">AO(A)<br />
        SR(A). <?= $this->_helper->str2Upper($cliente); ?><br />
        <?= $this->_helper->str2Upper($negociacao['enderecoCli']); ?>
        , <?= $this->_helper->str2Upper($negociacao['bairroCli']); ?><br />
        <?= $this->_helper->str2Upper($cidadeCli); ?><br />
        CEP: <?= $negociacao['nrCepCli']; ?>
    </span><br>

    <span style="font-weight: bold"><?= ($negociacao['tp_operacao'] == 'R' ? 'REFINANCIAMENTO' : 'NEGOCIAO') ?> n <?= str_pad($negociacao['idNegociacao'], 5, '0', STR_PAD_LEFT) . '
            - ' . $negociacao['nm_empreendimento']; ?>
        <?= Helper::exibeAbreviacao(($empreendimentoInfo['ds_subgrupo'] != '') ? $empreendimentoInfo['ds_subgrupo'] : '') ?><?= ' - ' . $negociacao['lote'] ?>
        <?= Helper::exibeAbreviacao(($empreendimentoInfo['ds_grupo'] != '') ? $empreendimentoInfo['ds_grupo'] : '') ?><?= ' - ' . $negociacao['quadra'] ?>
        <?= ' - Contrato: ' . $negociacao['contrato'];
        ?>
    </span><br>

    <span>Prezado(a) Cliente: <b><?= $negociacao['nm_pessoa']; ?> </b></span><br>

    <span>Ref. <?= ($negociacao['tp_operacao'] == 'R' ? 'Refinanciamento' : 'Negociao') ?> nmero: <b><?= str_pad($negociacao['idNegociacao'], 5, '0', STR_PAD_LEFT); ?>,</b>
        realizada em: <b><?= Helper::getDate($negociacao['data']) ?></b></span><br>

    <span>Pela presente solicitamos a cincia de V. Sa.  <?= ($negociacao['tp_operacao'] == 'R' ? 'refinanciamento' : 'negociao') ?> abaixo: </span><br>

    <p>
        Parcelas <?= ($negociacao['tp_operacao'] == 'R' ? 'refinanciadas' : 'em atraso') ?>:
    </p>

    <table>
        <tr>
            <th>Parc.</th>
            <th align="center">Tipo</th>
            <th align='center'>Vencimento</th>
            <th align="right">Valor</th>
            <th align="right">Juros</th>
            <th align="right">Multa</th>
            <th align="right">Desconto</th>
            <th align="right">Acrsc.</th>
            <th align="right">Vl. Final</th>
        </tr>
        <?php
        $totalFinal = 0;
        foreach ($parcelaSelecionada as $parcela) :
            $total = 0;
            $total += ($parcela['vl_parcela']) ? $parcela['vl_parcela'] : 0;
            $total += ($parcela['vl_juros']) ? $parcela['vl_juros'] : 0;
            $total += ($parcela['vl_multa']) ? $parcela['vl_multa'] : 0;
            $total += ($parcela['acrescimo']) ? $parcela['acrescimo'] : 0;
            $total -= ($parcela['desconto']) ? $parcela['desconto'] : 0;
            $totalFinal += $total;
        ?>
            <tr>
                <td width="60"><?= str_pad($parcela['id_parcela'], 2, '0', STR_PAD_LEFT); ?></td>
                <td width="100" align='center'><?= $parcNome[$parcela['tp_parcela']] ?></td>
                <td width="120" align='center'><?= Helper::getDate($parcela['dt_parcela']) ?></td>
                <td width="60" align="right"><?= Helper::getMoney($parcela['vl_parcela']) ?></td>
                <td width="60" align="right"><?= Helper::getMoney($parcela['vl_juros']) ?></td>
                <td width="60" align="right"><?= Helper::getMoney($parcela['vl_multa']) ?></td>
                <td width="75" align="right"><?= Helper::getMoney($parcela['desconto']) ?></td>
                <td width="60" align="right"><?= Helper::getMoney($parcela['acrescimo']) ?></td>
                <td width="60" align="right"><?= Helper::getMoney($total) ?></td>
            </tr>
        <?php endforeach; ?>
        <tr>
            <td align="right" colspan="9" style="padding-top: 5px;"><b>TOTAL:
                    R$ <?= Helper::getMoney($totalFinal); ?></b></td>
        </tr>
    </table>
    <br>
    <br>
    <hr />
    Forma de <?= ($negociacao['tp_operacao'] == 'R' ? 'refinanciamento' : 'negociao') ?>: <br />
    <table>
        <tr>
            <?php if (count($parcelaNegociadas) == 2) : ?>
                <th width="60">Parc.</th>
                <th width="100" align="right">Tipo</th>
                <th width="100" align="right">Vencimento</th>
                <th width="60" align="center">Valor</th>
                <th></th>
                <th align="center" width="60">Parc.</th>
                <th width="100" align="right">Tipo</th>
                <th width="100" align="right">Vencimento</th>
                <th width="60" align="center">Valor</th>
            <?php else : ?>
                <th width="60">Parc.</th>
                <th width="100" align="right">Tipo</th>
                <th width="100" align="right">Vencimento</th>
                <th width="60" align="center">Valor</th>
                <th></th>
                <th align="center" width="60">Parc.</th>
                <th width="100" align="right">Tipo</th>
                <th width="100" align="right">Vencimento</th>
                <th width="60" align="center">Valor</th>
            <?php endif; ?>
        </tr>
        <?php
            $vlParcela = 0;
            $dtPrimeira = Helper::getDate($parcelaNegociadas[0]['dt_parcela']);
            $nrParcelas = count($parcelaNegociadas);
            $i = 1;
            
            foreach ($parcelaNegociadas as $negociada) :
                $vlParcela += $negociada['vl_parcela'];
        ?>
            <?php if ($i % 2 == 0) : ?>
                    <td><b>|</b></td>
                    <td width="60"><?= str_pad($negociada['id_parcela'], 2, '0', STR_PAD_LEFT) . '/' . str_pad($nrParcelas, 2, '0', STR_PAD_LEFT); ?></td>
                    <td width="100" align='left'><?= ($negociacao['tp_operacao'] == 'N' ? 'Negociao' : 'Refinanciamento') ?></td>
                    <td width="100" align='left'><?= Helper::getDate($negociada['dt_parcela']) ?></td>
                    <td width="60" style="padding: 0;"><?= Helper::getMoney($negociada['vl_parcela']) ?></td>
                </tr>
            <?php else:?>
                <tr>
                    <td width="60"><?= str_pad($negociada['id_parcela'], 2, '0', STR_PAD_LEFT) . '/' . str_pad($nrParcelas, 2, '0', STR_PAD_LEFT); ?></td>
                    <td width="100" align='left'><?= ($negociacao['tp_operacao'] == 'N' ? 'Negociao' : 'Refinanciamento') ?></td>
                    <td width="100" align='left'><?= Helper::getDate($negociada['dt_parcela']) ?></td>
                    <td width="60" style="padding: 0;"><?= Helper::getMoney($negociada['vl_parcela']) ?></td>
            <?php endif;
                $i++; ?>

        <?php endforeach; ?>
        <?php if($i%2==0){echo "</tr>";}?>
    </table>
    <br>
    <br>
    <div>
        <p> Total Geral: <b><?= Helper::getMoney($vlParcela) ?></b></p>
        <p>Observaes:<br />
            I&nbsp;&nbsp;&nbsp;- O no pagamento das parcelas de <?= ($negociacao['tp_operacao'] == 'R' ? 'refinanciamento' : 'negociao') ?> dentro do prazo, implicar na resciso
            contratual.<br />
            II&nbsp;&nbsp;- Parcelas em <?= ($negociacao['tp_operacao'] == 'R' ? 'refinanciamento' : 'negociao') ?> no sero refinanciadas.<br />
            <?php if ($negociacao['obs']) : ?>III&nbsp;- <?= $negociacao['obs'];
                                                        endif; ?>
        </p>

        <p>Atenciosamente, Data: _____/_____/_____</p>

        <table style="margin-top:-10px;margin-left:50px;">
            <?php if ($negociacao['fl_assinatura'] == 'PE') : ?>
                <?php
                $assinaturas = $this->get('assinaturas');
                $listaAssinaturas = array_chunk($assinaturas, 2);

                foreach ($listaAssinaturas as $assinaturas) : ?>
                    <tr>
                        <?php foreach ($assinaturas as $ass) : ?>
                            <td style="padding-top: 30px;width:300px;"> ______________________________________________</td>
                        <?php endforeach; ?>
                    </tr>
                    <tr>
                        <?php foreach ($assinaturas as $ass) : ?>
                            <td style="font-size: 10px;width:350px; text-align: center">
                                <?php
                                if ($ass['nr_cpf']) {
                                    echo '<br />' . $ass['nm_pessoa'] . '<br /> CPF/MF:' . $ass['nr_cpf'];
                                } else {
                                    echo '<br />' . $ass['nm_pessoa'] . '<br /> CNPJ/MF:' . $ass['nr_cnpj'];
                                }
                                ?>
                            </td>
                        <?php endforeach; ?>
                    </tr>
                <?php endforeach; ?>
            <?php elseif ($negociacao['fl_assinatura'] == 'E') : ?>
                <tr>
                    <td style="padding-top: 30px;width:350px;">__________________________________________________
                    </td>
                </tr>
                <tr>
                    <td style="font-size: 10px;width:350px; text-align: center">
                        <?= Helper::str2Upper($negociacao['nm_empreendimento']) ?>
                    </td>
                </tr>
            <?php elseif ($negociacao['fl_assinatura'] == 'PI') : ?>
                <?php
                $parceria = $this->get('parceria');
                $listaAssinaturas = array_chunk($parceria, 2);

                foreach ($listaAssinaturas as $parceria) : ?>
                    <tr>
                        <?php foreach ($parceria as $parc) : ?>
                            <td style="padding-top: 30px;width:350px;"> ______________________________________________</td>
                        <?php endforeach; ?>
                    </tr>
                    <tr>
                        <?php foreach ($parceria as $parc) : ?>
                            <td style="font-size: 10px;width:350px; text-align: center">
                                <?php
                                if ($parc['nr_cpf']) {
                                    echo '<br />' . $parc['nm_pessoa'] . '<br /> CPF/MF:' . $parc['nr_cpf'];
                                } else {
                                    echo '<br />' . $parc['nm_pessoa'] . '<br /> CNPJ/MF:' . $parc['nr_cnpj'];
                                }
                                ?>
                            </td>
                        <?php endforeach; ?>
                    </tr>
                <?php endforeach; ?>
            <?php endif; ?>
        </table>
        <table style="margin-top:-10px;margin-left:40px;">
            <tr>
                <td style="padding-top: 30px;width:350px;"> Ciente: _________________________________________</td>
            </tr>
            <?php  if($negociacao['cpfCli']){
                $msgPessoaEnvolvida = 'CPF/MF: ' . $negociacao['cpfCli'];
            }else{
                $msgPessoaEnvolvida = 'CNPJ: ' . $negociacao['cnpjCli'];
            } ?>
            <tr>
                <td style="font-size: 10px;width:350px; text-align: center">
                    <?= '<br>' . Helper::str2Upper($cliente) . '<br> ' . $msgPessoaEnvolvida ?>
                </td>
            </tr>
            <?php foreach ($pessoasEnvolvidas as $pessoaEnvolvida) : ?>
            <?php if($pessoaEnvolvida['nr_cpf']){
                $msgPessoaEnvolvida2 = 'CPF/MF: ' . $pessoaEnvolvida['nr_cpf'];
            }else{
                $msgPessoaEnvolvida2 = 'CNPJ: ' . $pessoaEnvolvida['nr_cnpj'];
            } ?>
                <tr>
                    <td style="padding-top: 30px;width:350px;"> Ciente: _________________________________________</td>
                </tr>
                <tr>
                    <td style="font-size: 10px;width:350px; text-align: center">
                        <?= '<br>' . Helper::str2Upper($pessoaEnvolvida['nm_pessoa']) . '<br> ' . $msgPessoaEnvolvida2 ?>
                    </td>
                </tr>
            <?php endforeach; ?>
        </table>
    </div>

</page>