<?php
require_once 'layout/includes/header.php';
require_once 'layout/includes/menu.php';
//SETS DA VIEW
$contratos = $this->get('contratos');
$emps = $this->get("empreendimentos");
$parcelas = $this->get('parcelas');
$dados = $this->get('dados');
?>
<div class="content">
    <div class="page-heading">
        <?= $this->getHeader('Estorno de ', 'Baixa', 'fa fa-mail-reply'); ?>
    </div>
    <div class="widget">
        <div class="widget-content padding">
            <!-- MENSAGENS -->
            <?php if (count($this->_helper->getMensagens()) > 0)
                foreach ($this->_helper->getMensagens() as $tipo => $message)
                    echo '<div class="alert alert-' . $tipo . ' alert-dismissable">' . $message . '</div>';?>
            <!-- MENSAGENS -->
            <form action="?m=fin&c=estornarParcela&a=index" method="POST">
                <input type="hidden" id="flOpcao" name="opcao" value="B">
                <fieldset>
                    <legend>Informaes da Baixa <span style=" font-size: 10pt">(Campos com <span style=" color: red">*</span> so obrigatrios)</span>
                        <span data-toggle="modal" data-target=".mVisualizarTutorial" style="font-size: 22px;" data-toggle="tooltip" data-placement="top" title="Assista ao tutorial">
                            <svg xmlns="" width="22" height="22" fill="currentColor" class="bi bi-youtube" viewBox="0 0 16 16">
                                <path d="M8.051 1.999h.089c.822.003 4.987.033 6.11.335a2.01 2.01 0 0 1 1.415 1.42c.101.38.172.883.22 1.402l.01.104.022.26.008.104c.065.914.073 1.77.074 1.957v.075c-.001.194-.01 1.108-.082 2.06l-.008.105-.009.104c-.05.572-.124 1.14-.235 1.558a2.01 2.01 0 0 1-1.415 1.42c-1.16.312-5.569.334-6.18.335h-.142c-.309 0-1.587-.006-2.927-.052l-.17-.006-.087-.004-.171-.007-.171-.007c-1.11-.049-2.167-.128-2.654-.26a2.01 2.01 0 0 1-1.415-1.419c-.111-.417-.185-.986-.235-1.558L.09 9.82l-.008-.104A31 31 0 0 1 0 7.68v-.123c.002-.215.01-.958.064-1.778l.007-.103.003-.052.008-.104.022-.26.01-.104c.048-.519.119-1.023.22-1.402a2.01 2.01 0 0 1 1.415-1.42c.487-.13 1.544-.21 2.654-.26l.17-.007.172-.006.086-.003.171-.007A100 100 0 0 1 7.858 2zM6.4 5.209v4.818l4.157-2.408z"></path>
                            </svg>
                        </span>
                    </legend>
                    <ul class="nav nav-tabs">
                        <li class="<?= $this->get('opcao') == 'N'?'active':''?>">
                            <a href="#nrBaixa" class="flTipo" value="N" data-toggle="tab" aria-expanded="true">
                                N&uacute;mero de baixa
                            </a>
                        </li>
                        <li class="<?= $this->get('opcao') == 'B'?'active':''?>">
                            <a href="#buscar" class="flTipo" value="B" data-toggle="tab" aria-expanded="false">
                                Buscar</a>
                        </li>
                    </ul>
                    <div class="tab-content">
                        <div class="tab-pane fade <?= $this->get('opcao') == 'N'?'active':''?> in" id="nrBaixa">
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="form-group col-sm-3 num_baixa">
                                        <label class="control-label" for="nr_parcela">
                                            N&uacute;mero:<span class="require" style="color: red">*</span>
                                            Ex:00006112
                                        </label>
                                        <input id="num_baixa" name="num_baixa" type="text"
                                               class="numeroBaixa form-control"/>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="form-group col-sm-6">
                                        <label class="control-label" for="empreendimento">
                                            Empreendimento:
                                        </label>
                                        <input id="empreendimento_baixa" name="empreendimento_baixa" type="text"
                                               disabled="disabled" value=" "
                                               class="empreendimento_baixa form-control"/>
                                    </div>
                                    <div class="form-group col-sm-6">
                                        <label class="control-label" for="cliente">
                                            Cliente:
                                        </label>
                                        <input id="cliente_estorno" name="cliente_estorno" type="text"
                                               disabled="disabled" value=" " class="cliente_estorno form-control"/>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="form-group col-sm-3">
                                        <label class="control-label" for="lote">
                                            Lote:
                                        </label>
                                        <input id="lote_estorno" name="lote_estorno" type="text"
                                               disabled="disabled" value=" " class="lote_estorno form-control"/>
                                    </div>
                                    <div class="form-group col-sm-3">
                                        <label class="control-label" for="num_contrato_estorno">
                                            Contrato:
                                        </label>
                                        <input id="num_contrato_estorno" name="num_contrato" type="text"
                                               disabled="disabled" value=" "
                                               class="num_contrato_estorno form-control"/>
                                    </div>
                                    <div class="form-group col-sm-3">
                                        <label class="control-label" for="num_parcela">
                                            Parcela:
                                        </label>
                                        <input id="num_parcela_estorno" name="num_parcela_estorno" type="text"
                                               disabled="disabled" value=" "
                                               class="num_parcela_estorno form-control"/>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- / .tab-pane -->
                        <div class="tab-pane fade <?= $this->get('opcao') == 'B'?'active':''?> in" id="buscar">
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="form-group col-sm-6">
                                        <label class="control-label" for="id_empreendimento">
                                            Empreendimento:<span class="require" style="color: red">*</span>
                                        </label>
                                        <select class="form-control select2 empreendimento_estorno"
                                                data-placeholder="Selecione o empreendimento"
                                                id="empreendimento_estorno" required="required" name="idEmpreendimento">
                                            <option value="">Selecione...</option>
                                            <?php foreach ($emps as $emp): ?>
                                                <option value="<?php echo $emp['id']; ?>" <?php if ($emp['id'] == $dados['id_empreendimento']): ?> selected <?php endif; ?>><?php echo $emp['nm_empreendimento']; ?>
                                                </option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                    <div class="form-group col-sm-6">
                                        <label class="control-label">
                                            Tipo :<span class="require" style="color: red">*</span>
                                        </label><br>
                                        <div class="col-sm-3">
                                            <input type="radio" class="form-control icheck status"
                                                   name="tipo" checked value="1"/>
                                            <label for="remembrar">Ativos</label>
                                        </div>
                                        <div class="col-sm-3">
                                            <input type="radio" class="form-control icheck status"
                                                   name="tipo" value="0"/>
                                            <label for="remembrar">Inativos</label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group col-sm-6">
                                <label class="control-label" for="id_contrato">
                                    Contrato:<span class="require" style="color: red">*</span>
                                </label>
                                <select class="form-control select2 contrato_parcela_estorno"
                                        name="idContrato" id="contrato_estorno" required="required"
                                        data-placeholder="Selecione o contrato" style="width: 100%" disabled>
                                    <option value=""></option>
                                </select>
                            </div>
                            <div class="form-group col-sm-3">
                                <label class="control-label" for="id_parcela">
                                    Parcela:<span class="require" style="color: red">*</span>
                                </label>
                                <select class="form-control select2 parcelas_paga_estorno"
                                        name="id_parcela" id="parcela_estorno"
                                        data-placeholder="Selecione a parcela" disabled>
                                    <option value=""></option>
                                </select>
                            </div>
                        </div>
                        <!-- / .tab-pane -->
                    </div>
                    <!-- MODAL -->
                    <div class="modal fade mVisualizar" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel"
                        aria-hidden="true" id="mVisualizar" hidden>
                        <div class="modal-dialog modal-lg ">
                            <div class="modal-content">

                                <div class="modal-header">
                                    <button type="button" class="close" data-dismiss="modal"
                                            aria-hidden="true">&times;</button>
                                    <h2 class="modal-title" id="myModalLabel" align="center"><i class="fa fa-eye"></i>
                                        Visualizar</h2>
                                </div>

                                <div class="modal-body tableFix">
                                    <fieldset>
                                        <legend>O nmero informado pertence a mais de uma parcela</legend>
                                        <div class="num_baixaModal"></div>
                                    </fieldset>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-default" data-dismiss="modal" name="selecionaParcela">
                                        Selecionar
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- MODAL -->
                </fieldset>
                <fieldset>
                    <legend>Opera&ccedil;&otilde;es</legend>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group col-sm-2">
                                <input type="submit" class="btn btn-primary col-sm-12 fDesabilitaBtn" id="gerar" value="Gerar">
                            </div>
                        </div>
                    </div>
                </fieldset>
            </form>

        </div>
    </div>
</div>
<div class="modal fade mVisualizarTutorial" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel"
    aria-hidden="true">
    <div class="modal-dialog modal-lg ">
        <div class="modal-content">

            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal"
                        aria-hidden="true">&times;</button>
                <h2 class="modal-title" id="myModalLabel" align="center"><i class="fa fa-book"></i>
                    Tutorial</h2>
            </div>

            <div class="modal-body tableFix" style="max-height:600px;">
                <fieldset >
                    <legend>Estorno de baixa - Estornar Baixas Realizadas</legend>
                    <div class="row" style="margin-right: 0px;margin-left: 0px;">
                        <iframe width="560" height="500" src="https://www.youtube-nocookie.com/embed/OBDeJoAnma4?si=b_fEgerMcphI0vZ5" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>                        
                    </div>
                    <div></div>
                </fieldset>
            </div>
        </div>
    </div>
</div>
<?php require_once 'layout/includes/footer.php'; ?>
