<?php
$opcao = $this->get('opcao');
$transferencia = $this->get('transferencia');
$cliente = $this->get('cliente');
$confissao = $this->get('confissao');
$parceria = $this->get('parceria');
$lotes = $this->get('lotes');
$contrato = $this->get('contrato');
$empreendimento = $this->get('empreendimento');
$clientePj = $this->get('clientePj');
$pessoas = new Pessoa();

$arrData = explode("-", date('Y-m-d'));
$dia = $arrData[2];
$mes = $arrData[1];
$ano = $arrData[0];

$arrayLetras = array('a)', 'b)', 'c)', 'd)', 'e)', 'f)', 'g)', 'h)');

$arrDataAss = explode("-", $contrato['dt_contrato']);
$diaAss = $arrDataAss[2];
$mesAss = $arrDataAss[1];
$anoAss = $arrDataAss[0];

$cidadeEmpreedimento = array();
if ($cidadeEmpreedimento = Db_Cidade::find($empreendimento['cd_cidade'])) $cidadeEmpreedimento = $cidadeEmpreedimento->toArray();

$contador = 1;

foreach ($parceria as $parc) {

    $pessoa = $pessoas->find($parc['id_pessoa'])->current()->toArray();

    $cidade = array();
    if ($cidade = Db_Cidade::find($pessoa['cd_cidade'])) $cidade = $cidade->toArray();

    $pfs = new Pessoa_Fisica();
    $pjs = new Pessoa_Juridica();

    if ($pessoa['tp_pessoa'] == 'F') {
        $pf = $pfs->fetchRow('id_pessoa = ' . $pessoa['id']);
        $pessoa['nr_cpf'] = $pf->nr_cpf;
    } else {
        $pj = $pjs->fetchRow('id_pessoa = ' . $pessoa['id']);
        $pessoa['nr_cnpj'] = $pj->nr_cnpj;

    }

    $cpfCnpj = ($pessoa['tp_pessoa'] == 'F') ? "CPF/MF sob n {$pessoa['nr_cpf']}" : "CNPJ/MF {$pessoa['nr_cnpj']}";
    $str = '<b> 1.1. CREDOR / OUTORGANTE: </b>' . Helper::str2Upper($pessoa['nm_pessoa']) . ',
            com sede no(a) ' . $pessoa['endereco'] . ' - ' . $pessoa['nm_bairro'] . ' - ' . $cidade['nome'] . ' / ' . $cidade['uf'] . ',
            CEP: ' . $pessoa['nr_cep'] . ', ' . $cpfCnpj . ', neste ato representada pelos seus bastante procuradores, que assinam o presente QUADRO RESUMO, bem como as CLUSULAS GERAIS anexas.';

}

?>
    <style type="text/css">
        div.espaco {
            margin-top: 100px;
        }

        body {
            font-family: arial;
            font-size: 12px;
        }

        div {
            font-size: 12px;
        }

        h2 {
            text-align: center;
            font-size: 12px;
        }

        table tr td.h3 {
            font-size: 12px;
        }

        h4 {
            font-size: 12px;
        }

        table {
            width: 100%;
            font-size: 12px;
        }

        .grid {
            border-collapse: collapse;
            width: 700px;
        }

        .grid tr td {
            border: 2px solid #000000;
        }

        .table_bordas {
            border-collapse: collapse;
            width: 730px;
        }

        .table_bordas tr td {
            border: 1px solid #000000;
            font-size: 12px;
        }

        .header td {
            border: 1px solid #000000;
            font-size: 12px;
            background-color: #cccccc;
            font-weight: bold;
        }

        .header td {
            border: 1px solid #000000;
            font-size: 12px;
        }
    </style>
    <page backtop="10mm" backbottom="10mm">
        <table>
            <tr>
                <td style="width:730px;" align="center">
                    <strong style="font-size:16px;">
                        CONTRATO PARTICULAR DE CONFISSO DE DVIDA
                        <br/></strong>
                    <?php if ($confissao['garantia'] != null) : ?> <strong style="font-size:16px;">COM GARANTIA HIPOTECRIA</strong> <?php endif;?>
                </td>
            </tr>
        </table>
        <table border="1" style="background-color: #CCCCCC; margin-top: 30px;">
            <tr>
                <td style="border:1px solid #000000;width:730px;padding:5px;"><strong style="font-size:12px;"><?= $contador ?>. PARTES</strong></td>

            </tr>
        </table>
        <table class="table_bordas dados" style="margin-top: 5px;">
            <tr>
                <td width="695" style="padding-left: 15px; padding-right: 15px;">
                    <p style="text-align:justify; "><?php echo $str; ?></p>

                    <p style="text-align:justify; ">
                        <?php if ($cliente) : ?>
                            <b>1.2. DEVEDOR/OUTORGANTE: </b><?php echo $cliente['nm_pessoa']; ?>
                            <?php echo ($cliente['nm_nacionalidade']) ? ', ' . $cliente['nm_nacionalidade'] : ''; ?>
                            <?php echo ($cliente['est_civil']) ? ', ' . Db_TabelaAgrupada::find( Db_TabelaAgrupada::TABLE_ESTADO_CIVIL, $cliente['est_civil'])->getDescricao() : ''; ?>
                            <?php echo ($cliente['nm_profissao']) ? ', ' . $cliente['nm_profissao'] . ', ': ''; ?> portador da Cdula de Identidade
                            n <?php echo $cliente['nr_rg']; ?>,
                            CPF: <?php echo $cliente['nr_cpf']; ?>, residente domiciliado em <?php echo $cliente['nome']; ?>
                            / <?php echo $cliente['uf']; ?>,
                            no(a) <?php echo $cliente['endereco']; ?>, <?php echo $cliente['nm_bairro']; ?>,
                            CEP: <?php echo $cliente['nr_cep']; ?>.
                        <?php endif; ?>
                        <?php if ($clientePj) : ?>
                            <b>1.2. DEVEDOR/OUTORGANTE: </b><?php echo $clientePj['nm_pessoa']; ?>
                            CNPJ: <?php echo $clientePj['nr_cnpj']; ?>, com sede em <?php echo $clientePj['nome']; ?>
                            / <?php echo $clientePj['uf']; ?>,
                            no(a) <?php echo $clientePj['endereco']; ?>, <?php echo $clientePj['nm_bairro']; ?>,
                            CEP: <?php echo $clientePj['nr_cep']; ?>.
                        <?php endif; ?>
                    </p>
                </td>
            </tr>
        </table>
        <table class="table_bordas dados" style="margin-top: 5px;">
            <tr>
                <td width="695" style="padding-left: 15px; padding-right: 15px;">
                    <p style="text-align:justify; ">
                        Pelo presente instrumento particular de confisso de dvida, as partes acima identificadas
                        resolvem
                        celebrar o presente CONTRATO PARTICULAR DE CONFISSO DE DVIDA
                        <?php if ($confissao['garantia'] != null) : ?>COM GARANTIA HIPOTECRIA<?php endif;?>
                        , mediante os termos e condies que passam a expor.</p>
                </td>
            </tr>
        </table>
        <table border="1" style="background-color: #CCCCCC; margin-top: 10px;">
            <tr>
                    <td style="border:1px solid #000000;width:730px;padding:5px;"><strong style="font-size:12px;"><?php echo ++$contador ?>. VALOR E ORIGEM DA DVIDA</strong>
                </td>
            </tr>
        </table>
        <table class="table_bordas dados" style="margin-top: 5px;">
            <tr>
                <td width="695" style="padding-left: 15px; padding-right: 15px;">
                    <p style="text-align:justify; ">
                        O DEVEDOR/OUTORGANTE reconhece e confessa ser devedor da quantia de
                        R$ <?php echo Helper::getMoney($confissao['valor']); ?>
                        (<?php echo Helper::valorPorExtenso($confissao['valor']); ?>) valor devido decorrente da
                        celebrao do contrato de compra e venda do(s) seguinte(s) imvel(eis):
                        <?php foreach ($lotes as $k => $lote) {
                            echo "<br />" . $arrayLetras[$k] . " Lote:" . $lote['lote'] . " Quadra: " . $lote['quadra'] . " com rea privativa de " . $lote['area'] . " m Empreendimento: " . $empreendimento['nm_empreendimento'];
                        }
                        ?>
                    </p>

                </td>
            </tr>
        </table>
        <table border="1" style="background-color: #CCCCCC; margin-top: 10px;">
            <tr>
                <td style="border:1px solid #000000;width:730px;padding:5px;"><strong style="font-size:12px;"><?php echo ++$contador ?>. FORMA DE PAGAMENTO</strong></td>
            </tr>
        </table>
        <table class="table_bordas dados" style="margin-top: 5px;">
            <tr>
                <td width="695" style="padding-left: 15px; padding-right: 15px;">
                    <p style="text-align:justify;">O DEVEDOR/OUTORGANTE obriga-se a pagar a dvida confessada da
                        seguinte forma:</p>

                    <p style="text-align:justify;">
                    <table style='text-align: center;border-collapse: collapse;'>
                        <tr class="header">
                            <td width='230'>PARCELA</td>
                            <td width='230'>VALOR</td>
                            <td width='230'>VENCIMENTO</td>
                        </tr>
                        <tr class="lines">
                            <td>1</td>
                            <td><?php echo Helper::getMoney($confissao['valor']); ?></td>
                            <td><?php echo Helper::getDate($confissao['dtVencimento']); ?></td>
                        </tr>
                    </table>

                    </p>
                </td>
            </tr>
        </table>
        <table border="1" style="background-color: #CCCCCC; margin-top: 20px;">
            <tr>
                <td style="border:1px solid #000000;width:730px;padding:5px;"><strong style="font-size:12px;"><?php echo ++$contador ?>. MORA</strong>
                </td>
            </tr>
        </table>
        <table class="table_bordas dados" style="margin-top: 5px;">
            <tr>
                <td width="695" style="padding-left: 15px; padding-right: 15px;">
                    <p style="text-align:justify; ">
                        Ocorrendo atraso no pagamento de alguma das parcelas descritas na clusula anterior,
                        a quitao intempestiva ser acrescida de juros de mora de 1% (um por cento) ao ms,
                        correo monetria com base na variao do IGP-M da Fundao Getlio Vargas e multa
                        contratual de 10% (dez por cento) tudo calculado em proporo diria (pro rata dies)
                        sobre o valor da parcela no paga.
                    </p>
                </td>
            </tr>
        </table>
        <table border="1" style="background-color: #CCCCCC; margin-top: 20px;">
            <tr>
                <td style="border:1px solid #000000;width:730px;padding:5px;"><strong style="font-size:12px;"><?php echo ++$contador ?>. RESCISO ANTECIPADA DA DVIDA</strong>
                </td>
            </tr>
        </table>
        <table class="table_bordas dados" style="margin-top: 5px;">
            <tr>
                <td width="695" style="padding-left: 15px; padding-right: 15px;">
                    <p style="text-align:justify; ">
                        O no pagamento de duas (02) ou mais parcelas, sejam elas sucessivas ou no, torna exigvel o
                        saldo devedor
                        devidamente atualizado, com os acrscimos contratuais independentemente de notificao judicial
                        ou extra-judicial,
                        alm daqueles casos previstos em lei.
                    </p>
                </td>
            </tr>
        </table>
        <!-- GARANTIA HIPOTECRIA -->
        <?php if ($confissao['garantia'] != null) : ?>
            <table border="1" style="background-color: #CCCCCC; margin-top: 8px;">
                <tr>
                    <td style="border:1px solid #000000;width:730px;padding:5px;"><strong style="font-size:12px;"><?php echo ++$contador ?>. GARANTIA HIPOTECRIA</strong>
                    </td>
                </tr>
            </table>
            <table class="table_bordas dados" style="margin-top: 5px;">
                <tr>
                    <td width="695" style="padding-left: 15px; padding-right: 15px;">
                        <p style="text-align:justify; ">
                            <?php echo $confissao['garantia']; ?>
                        </p>
                    </td>
                </tr>
            </table>
        <?php endif;?>

        <?php if ($confissao['garantia'] == false) : ?>
            <table border="1" style="background-color: #CCCCCC; margin-top: 8px;">
                <tr>
                    <td style="border:1px solid #000000;width:730px;padding:5px;"><strong style="font-size:12px;"><?php echo ++$contador ?>. MEDIDAS JUDICIAIS</strong>
                    </td>
                </tr>
            </table>
            <table class="table_bordas dados" style="margin-top: 5px;">
                <tr>
                    <td width="695" style="padding-left: 15px; padding-right: 15px;">
                        <p style="text-align:justify; ">
                            Em sendo necessrias medidas judiciais para execuo da hipoteca, o DEVEDOR/OUTORGANTE arcar
                            com a multa de mora
                            estabelecida e ainda com os honorrios advocatcios a base de 20% (vinte por cento) sobre o
                            valor do dbito
                            atualizado, alem das custas judiciais, de avaliadores, de despachantes, de leiloeiros, e demais
                            despesas inevitveis,
                            devidamente comprovadas, que o CREDOR/OUTORGADO tiver que arcar para haver o valor em cobrana,
                            ressaltando-se que,
                            em sobejando qualquer quantia alm do valor a que faz jus receber o CREDOR/OUTORGADO, receber o
                            DEVEDOR/OUTORGANTE a
                            diferena existente entre o valor apurado do bem e o valor total correspondentes s obrigaes
                            pactuadas, nestas
                            includas as despesas referidas.
                        </p>
                    </td>
                </tr>
            </table>
        <?php endif; ?>

    </page>
    <page backtop="10mm" backbottom="10mm">

    <?php if ($confissao['garantia'] == true) : ?>
        <table border="1" style="background-color: #CCCCCC; margin-top: 8px;">
            <tr>
                <td style="border:1px solid #000000;width:730px;padding:5px;"><strong style="font-size:12px;"><?php echo ++$contador ?>. MEDIDAS JUDICIAIS</strong>
                </td>
            </tr>
        </table>
        <table class="table_bordas dados" style="margin-top: 5px;">
            <tr>
                <td width="695" style="padding-left: 15px; padding-right: 15px;">
                    <p style="text-align:justify; ">
                        Em sendo necessrias medidas judiciais para execuo da hipoteca, o DEVEDOR/OUTORGANTE arcar
                        com a multa de mora
                        estabelecida e ainda com os honorrios advocatcios a base de 20% (vinte por cento) sobre o
                        valor do dbito
                        atualizado, alem das custas judiciais, de avaliadores, de despachantes, de leiloeiros, e demais
                        despesas inevitveis,
                        devidamente comprovadas, que o CREDOR/OUTORGADO tiver que arcar para haver o valor em cobrana,
                        ressaltando-se que,
                        em sobejando qualquer quantia alm do valor a que faz jus receber o CREDOR/OUTORGADO, receber o
                        DEVEDOR/OUTORGANTE a
                        diferena existente entre o valor apurado do bem e o valor total correspondentes s obrigaes
                        pactuadas, nestas
                        includas as despesas referidas.
                    </p>
                </td>
            </tr>
        </table>
    <?php endif; ?>

        <table border="1" style="background-color: #CCCCCC; margin-top: 8px;">
            <tr>
                <td style="border:1px solid #000000;width:730px;padding:5px;"><strong style="font-size:12px;"><?php echo ++$contador ?>. TOLERNCIA</strong>
                </td>
            </tr>
        </table>
        <table class="table_bordas dados" style="margin-top: 5px;">
            <tr>
                <td width="695" style="padding-left: 15px; padding-right: 15px;">
                    <p style="text-align:justify; ">
                        Qualquer tolerncia, por parte do CREDOR/OUTORGADO, pelo no cumprimento de quaisquer das
                        obrigaes decorrentes
                        deste contrato, em especial, no caso de vir a receber parte do pagamento da dvida, ser
                        admitido como ato de
                        liberalidade, no se constituindo em novao ou procedimento invocvel pelo outorgante.
                    </p>
                </td>
            </tr>
        </table>
        <table border="1" style="background-color: #CCCCCC; margin-top: 8px;">
            <tr>
                <td style="border:1px solid #000000;width:730px;padding:5px;"><strong style="font-size:12px;"><?php echo ++$contador ?>. LIQUIDEZ, CERTEZA E EXIBILIDADE DA DVIDA</strong>
                </td>
            </tr>
        </table>
        <table class="table_bordas dados" style="margin-top: 5px;">
            <tr>
                <td width="695" style="padding-left: 15px; padding-right: 15px;">
                    <p style="text-align:justify; ">
                        Ficam expressamente assegurados, a qualquer tempo, a certeza, a liquidez e a exigibilidade da
                        dvida que
                        corresponde ao valor principal acrescido de juros, multa contratual e demais despesas e encargos
                        estabelecidos neste instrumento.
                    </p>
                </td>
            </tr>
        </table>
        <table border="1" style="background-color: #CCCCCC; margin-top: 8px;">
            <tr>
                <td style="border:1px solid #000000;width:730px;padding:5px;"><strong style="font-size:12px;"><?php echo ++$contador ?>. CONDIES GERAIS</strong>
                </td>
            </tr>
        </table>
        <table class="table_bordas dados" style="margin-top: 5px;">
            <tr>
                <td width="695" style="padding-left: 15px; padding-right: 15px;">
                    <p style="text-align:justify;">a) O DEVEDOR/OUTORGANTE confessa e assume integral responsabilidade
                        pelo pagamento da dvida descrita na clusula 2;</p>

                    <p style="text-align:justify;">b) O DEVEDOR/OUTORGANTE renuncia expressamente a qualquer contestao
                        quanto ao valor e procedncia da dvida;</p>

                    <p style="text-align:justify;">c) O presente contrato  celebrado em carter definitivo e
                        irretratvel, no implicando, de modo algum, novao ou transao e vigorar imediatamente.
                    </p>
                </td>
            </tr>
        </table>
        <?php if ($confissao['obs'] == true) :?>
        <table border="1" style="background-color: #CCCCCC; margin-top: 8px;">
            <tr>
                <td style="border:1px solid #000000;width:730px;padding:5px;"><strong style="font-size:12px;"><?php echo ++$contador ?>. CLAUSULAS ESPECIAIS</strong>
                </td>
            </tr>
        </table>
        <table class="table_bordas dados" style="margin-top: 5px;">
            <tr>
                <td width="695" style="padding-left: 15px; padding-right: 15px;">
                   <p> <?php echo ($confissao['obs']);?> </p>
                </td>
            </tr>
        </table>
        <?php endif;?>
        <table border="1" style="background-color: #CCCCCC; margin-top: 8px;">
            <tr>
                <td style="border:1px solid #000000;width:730px;padding:5px;"><strong style="font-size:12px;"><?php echo ++$contador ?>. FORO</strong>
                </td>
            </tr>
        </table>
        <table class="table_bordas dados" style="margin-top: 5px;">
            <tr>
                <td width="695" style="padding-left: 15px; padding-right: 15px;">
                    <p style="text-align:justify; ">
                        <?php echo ($confissao['garantia'] != null) ?  'As partes elegem como foro competente o de localizao do empreendimento ofertado em garantia hipotecria.'
                            : 'As partes elegem como foro competente o de localizao do empreendimento.' ?>
                    </p>
                </td>
            </tr>
        </table>
        <table>
            <tr>
                <td width="695" align="right">
                    <p style="text-align:justify; ">
                        <?php echo $cidadeEmpreedimento['nome'] . ", $dia de " . strtolower(Helper::getMes(str_pad($mes, 2, '0', STR_PAD_LEFT))) . " de $ano."; ?>            </p>
                </td>
            </tr>
        </table>
        <table style="margin-top: 90px;">
            <tr>
                <td style="width:182px;" align="center"></td>
                <td style="width:182px;" align="center"></td>
                <td style="width:182px;" align="center"></td>
                <td style="width:182px;" align="center"></td>
            </tr>
            <tr>
                <td align="center" colspan="2">__________________________________________________</td>
                <td align="center" colspan="2">__________________________________________________</td>
            </tr>
            <tr>
                <td colspan="2" align="center" style="font-size: 10px;"><b>CREDORA/OUTORGADA</b><br/><?php
                    $vendedor = $pessoas->find($parc['id_pessoa'])->current()->toArray();
                    echo Helper::str2Upper($vendedor['nm_pessoa']); ?></td>
                <?php if ($cliente) : ?>
                    <td align="center" colspan="2" style="font-size: 10px;"><b>DEVEDOR/OUTORGANTE</b><br/><?php
                        echo Helper::str2Upper($cliente['nm_pessoa']); ?></td>
                <?php endif; ?>
                <?php if ($clientePj) : ?>
                    <td align="center" colspan="2" style="font-size: 10px;"><b>DEVEDOR/OUTORGANTE</b><br/><?php
                        echo Helper::str2Upper($clientePj['nm_pessoa']); ?></td>
                <?php endif; ?>
            </tr>
            <tr>
                <td colspan="4" align="center"><br/><br/><br/><br/><br/><br/></td>
            </tr>
            <tr>
                <td align="center" colspan="2">__________________________________________________</td>
                <td align="center" colspan="2">__________________________________________________</td>
            </tr>
            <tr>
                <td align="center" colspan="2" style="font-size: 10px;"><b>TESTEMUNHA</b></td>
                <td align="center" colspan="2" style="font-size: 10px;"><b>TESTEMUNHA</b></td>
            </tr>
        </table>
    </page>
<?php ?>