<?php
require_once 'layout/includes/header.php';
require_once 'layout/includes/menu.php';
?>

<?php
$empreendimentos = $this->get("empreendimentos");
$contratos = $this->get('contratos');//no est sendo usado
$parcelas = $this->get('parcelas');
$dados = $this->get('dados');// no est sendo usado
$bancos = $this->get('bancos');// no est sendo usado
$tipoBaixa = $this->get('tipoBaixa');
$permissao = $this->get('alterarDados');
$formaBaixa = $this->get('formaBaixa');
?>
<div class="content">
    <div class="page-heading">
        <?= $this->getHeader('Baixa', 'Parcela', 'fa fa-money'); ?>
    </div>
    <div class="widget">
        <div class="widget-content padding">
            <!-- MENSAGENS -->
            <div class="alert alert-danger alert-dismissable msgErros" hidden></div>
            <div class="alert alert-success alert-dismissable msgSucess" hidden>Operao realizada com sucesso.</div>
            <form action="" method="POST" id="form">
                <input type="hidden" name="opcao" value="B" id="flOpcao">
                <fieldset>
                    <legend>Informaes da Parcela <span style=" font-size: 10pt">(Campos com <span style=" color: red">*</span> so obrigatrios)</span>
                        <span data-toggle="modal" data-target=".mVisualizar" style="font-size: 22px;" data-toggle="tooltip" data-placement="top" title="Assista ao tutorial">
                            <svg xmlns="" width="22" height="22" fill="currentColor" class="bi bi-youtube" viewBox="0 0 16 16">
                                <path d="M8.051 1.999h.089c.822.003 4.987.033 6.11.335a2.01 2.01 0 0 1 1.415 1.42c.101.38.172.883.22 1.402l.01.104.022.26.008.104c.065.914.073 1.77.074 1.957v.075c-.001.194-.01 1.108-.082 2.06l-.008.105-.009.104c-.05.572-.124 1.14-.235 1.558a2.01 2.01 0 0 1-1.415 1.42c-1.16.312-5.569.334-6.18.335h-.142c-.309 0-1.587-.006-2.927-.052l-.17-.006-.087-.004-.171-.007-.171-.007c-1.11-.049-2.167-.128-2.654-.26a2.01 2.01 0 0 1-1.415-1.419c-.111-.417-.185-.986-.235-1.558L.09 9.82l-.008-.104A31 31 0 0 1 0 7.68v-.123c.002-.215.01-.958.064-1.778l.007-.103.003-.052.008-.104.022-.26.01-.104c.048-.519.119-1.023.22-1.402a2.01 2.01 0 0 1 1.415-1.42c.487-.13 1.544-.21 2.654-.26l.17-.007.172-.006.086-.003.171-.007A100 100 0 0 1 7.858 2zM6.4 5.209v4.818l4.157-2.408z"></path>
                            </svg>
                        </span>
                    </legend>
                    <ul class="nav nav-tabs">
                        <li class="<?= $this->get('opcao') == 'N' ? 'active' : '' ?>">
                            <a href="#nrBaixa" class="flTipo" tipo="N" data-toggle="tab" aria-expanded="true">
                                Nmero de baixa
                            </a>
                        </li>
                        <li class="<?= $this->get('opcao') == 'B' ? 'active' : '' ?>">
                            <a href="#buscar" class="flTipo" tipo="B" data-toggle="tab" aria-expanded="false">
                                Buscar
                            </a>
                        </li>
                        <li class="<?= $this->get('opcao') == 'I' ? 'active' : ''; ?>">
                            <a href="#inativo" class="flTipo" tipo="I" data-toggle="tab" aria-expanded="false">
                                Buscar inativos
                            </a>
                        </li>
                    </ul>
                    <div class="tab-content">
                        <div class="tab-pane fade <?= $this->get('opcao') == 'N' ? 'active' : '' ?> in" id="nrBaixa">
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="form-group col-sm-3">
                                        <label class="control-label" for="nr_parcela">
                                            Nmero:<span class="require" style="color: red">*</span>
                                        </label><br>
                                        <input id="nr_parcela" name="nr_baixa" type="text"
                                               value="" class="numeroBaixa form-control" placeholder="Ex: 003784512"/>
                                    </div>
                                    <div class="form-group col-sm-3">
                                        <label class="control-label" for="nr_parcela">
                                            Status:
                                        </label><br>
                                        <input id="status" name="status" class="numeroBaixa form-control" type="text" disabled="disabled"/>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="form-group col-sm-6">
                                        <label class="control-label" for="empreendimento">
                                            Empreendimento:
                                        </label>
                                        <input id="nm_empreendimento" name="nm_empreendimento" type="text"
                                               readonly value=" " class="empreendimento form-control"/>
                                    </div>
                                    <div class="form-group col-sm-6" hidden>
                                        <input id="nm_id_empreendimento" name="nm_id_empreendimento" type="text"
                                               readonly value=" " class="empreendimento form-control"/>
                                    </div>
                                    <div class="form-group col-sm-6" hidden>
                                        <input id="nm_id_contrato" name="nm_id_contrato" type="text"
                                               readonly value=" " class="empreendimento form-control"/>
                                    </div>
                                    <div class="form-group col-sm-6">
                                        <label class="control-label" for="cliente">
                                            Cliente:
                                        </label>
                                        <input id="cliente" name="cliente" type="text"
                                               disabled="disabled" value=" " class="cliente form-control"/>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="form-group col-sm-3">
                                        <label class="control-label" for="lote">
                                            Lote:
                                        </label>
                                        <input id="lote" name="lote" type="text"
                                               disabled="disabled" value=" " class="lote form-control"/>
                                    </div>
                                    <div class="form-group col-sm-3">
                                        <label class="control-label" for="num_contrato">
                                            Contrato:<span class="require" style="color: red">*</span>
                                        </label>
                                        <input id="num_contrato" name="num_contrato" type="text"
                                               disabled="disabled" value=" " class="num_contrato form-control"/>
                                    </div>
                                    <div class="form-group col-sm-3">
                                        <label class="control-label" for="num_parcela">
                                            Parcela:<span class="require" style="color: red">*</span>
                                        </label>
                                        <input id="num_parcela" name="num_parcela" type="text"
                                               disabled="disabled" value=" " class="num_parcela form-control"/>
                                    </div>
                                </div>
                            </div>
                        </div> 
                        <!-- / .tab-pane -->
                        <div class="tab-pane fade <?= $this->get('opcao') == 'B' ? 'active' : '' ?> in" id="buscar">
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="form-group col-sm-6">
                                        <label class="control-label" for="id_empreendimento">
                                            Empreendimento:<span class="require" style="color: red">*</span>
                                        </label>
                                        <select class="form-control select2 empreendimento_baixa_parcela"
                                                data-placeholder="Selecione o empreendimento"
                                                id="id_empreendimento" name="id_empreendimento">
                                            <option value=""></option>
                                            <?php foreach ($empreendimentos as $k => $e) : ?>
                                                <option value="<?= $e['id']; ?>">
                                                    <?= $e['nm_empreendimento']; ?>
                                                </option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group col-sm-6">
                                <label class="control-label" for="id_contrato">
                                    Contrato:<span class="require" style="color: red">*</span>
                                </label>
                                <select class="form-control select2 contrato_baixa_parcela"
                                        name="id_contrato" id="id_contrato"  data-placeholder="Selecione o contrato">
                                    <option value=""></option>
                                </select>
                            </div>
                            <div class="form-group col-sm-3">
                                <label class="control-label" for="id_parcela">
                                    Parcela:<span class="require" style="color: red">*</span>
                                </label>
                                <select class="form-control select2 parcelas_baixa"
                                        name="id_parcela" id="id_parcela" data-placeholder="Selecione a parcela">
                                    <option value=""></option>
                                </select>
                            </div>
                        </div> 
                        <!-- / .tab-pane -->
                        <div class="tab-pane fade <?= $this->get('opcao') == 'I' ? 'active' : '' ?> in" id="inativo">
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="form-group col-sm-6">
                                        <label class="control-label" for="id_empreendimento_aba_inativos">
                                            Empreendimento:<span class="require" style="color: red">*</span>
                                        </label>
                                        <select class="form-control select2 empreendimento_aba_inativos"
                                                data-placeholder="Selecione o empreendimento"
                                                id="id_empreendimento_aba_inativos" name="id_empreendimento_aba_inativos">
                                            <option value=""></option>
                                            <?php foreach ($empreendimentos as $k => $e) : ?>
                                                <option value="<?= $e['id']; ?>">
                                                    <?= $e['nm_empreendimento']; ?>
                                                </option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group col-sm-6">
                                <label class="control-label" for="id_contrato_aba_inativos">
                                    Contrato:<span class="require" style="color: red">*</span>
                                </label>
                                <select class="form-control select2 contrato_aba_inativos"
                                        name="id_contrato_aba_inativos" id="id_contrato_aba_inativos"  data-placeholder="Selecione o contrato">
                                    <option value=""></option>
                                </select>
                            </div>
                            <div class="form-group col-sm-3">
                                <label class="control-label" for="id_parcela_aba_inativos">
                                    Parcela:<span class="require" style="color: red">*</span>
                                </label>
                                <select class="form-control select2 parcela_aba_inativos"
                                        name="id_parcela_aba_inativos" id="id_parcela_aba_inativos" data-placeholder="Selecione a parcela">
                                    <option value=""></option>
                                </select>
                            </div>
                        </div> 
                    </div>
                </fieldset>
                <fieldset>
                    <legend>Informaes do Pagamento</legend>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group col-sm-3">
                                <label class="control-label" for="data_vencimento">
                                    Data de vencimento:
                                </label>
                                <input id="data_vencimento" name="data_vencimento" type="text"
                                       disabled value="" class="form-control"/>
                            </div>
                            <div class="form-group col-sm-3">
                                <label class="control-label" for="valor_do_titulo">
                                    Valor do ttulo:
                                </label>
                                <input id="valor_do_titulo" name="valor_do_titulo" type="text"
                                       disabled value="" class="form-control"/>
                            </div>
                            <div class="form-group col-sm-3">
                                <label class="control-label" for="valor_acrescimo">
                                    Acrscimo:
                                </label>
                                <input id="valor_acrescimo" name="valor_acrescimo" type="text"
                                       disabled value="" class="form-control"/>
                            </div>
                            <div class="form-group col-sm-3">
                                <label class="control-label" for="imprime_recibo">
                                    Imprimir recibo?<span class="require" style="color: red">*</span>
                                </label>
                                <br>
                                <div class="col-sm-12">
                                    <div class="form-group col-sm-6">
                                        <input type="radio" id="reciboS" class="form-control icheck imprime_recibo"
                                               name="recibo" value="1"/>Sim
                                    </div>
                                    <div class="form-group col-sm-6">
                                        <input type="radio" id="reciboN" class="form-control icheck imprime_recibo"
                                               name="recibo" checked value="0"/>No
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group col-sm-3">
                                <label class="control-label" for="multa">
                                    Valor multa:
                                </label>
                                <input id="multa" name="vl_multa" type="text"
                                       value="" class="form-control money"/>
                            </div>
                            <div class="form-group col-sm-3">
                                <label class="control-label" for="juros">
                                    Valor juros:
                                </label>
                                <input id="juros" name="vl_juros" type="text"
                                       value="" class="form-control money"/>
                            </div>
                            <div class="form-group col-sm-3">
                                <label class="control-label" for="Desconto">
                                    Desconto:
                                </label>
                                <input id="Desconto" name="vlDesconto" type="text"
                                       value="" class="form-control money"/>
                            </div>
                            <div class="form-group col-sm-3">
                                <label class="control-label" for="total_baixa_parcela">
                                    Total pago:
                                </label>
                                <input id="total_baixa_parcela" name="total_baixa_parcela" type="text"
                                       disabled value="" class="form-control"/>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group col-sm-3">
                                <label class="control-label" for="tipoBaixa">
                                    Tipo de baixa:<span class="require" style="color: red">*</span>
                                </label>
                                <select class="form-control select2"
                                        data-placeholder="Selecione o tipo de baixa"
                                        id="tipoBaixa" name="tipoBaixa">
                                    <option value=""></option>
                                    <?php foreach ($tipoBaixa as $k => $tipo) : ?>
                                        <option value="<?= $k ?>">
                                            <?= $tipo ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="form-group col-sm-6">
                                <label class="control-label" for="banco">
                                    Banco:
                                </label>

                                <select class="form-control select2 banco"
                                        name="banco" id="banco" data-placeholder="Selecione o banco">
                                    <option value=""></option>
                                </select>
                            </div>
                            <div class="form-group col-sm-3">
                                <label class="control-label" for="formaBaixa">
                                    Forma de baixa:<span class="require" style="color: red">*</span>
                                </label>

                                <select class="form-control select2 formaBaixa"
                                        name="formaBaixa" id="formaBaixa" data-placeholder="Selecione a forma de baixa">
                                    <option value=""></option>
                                    <?php foreach ($formaBaixa as $baixa): ?>
                                        <option value="<?= $baixa['idCampo'] ?>" ><?= $baixa['descricao']; ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group col-sm-3">
                                <label class="control-label" for="dt_credito">
                                    Data do crdito: <span class="require" style="color: red">*</span>
                                </label>
                                <input id="dt_credito" name="dt_credito" type="text"
                                       value="<?= date('d/m/Y') ?>" class="form-control data <?= ($permissao) ? 'datepicker-input' : '' ?>" <?= ($permissao) ? '' : 'readonly' ?>/>
                            </div>
                            <div class="form-group col-sm-3">
                                <label class="control-label" for="dt_pagamento">
                                    Data do pagamento: <span class="require" style="color: red">*</span>
                                </label>
                                <input id="dt_pagamento" name="dt_pagamento" type="text"
                                       value="<?= date('d/m/Y') ?>" class="form-control data <?= ($permissao) ? 'datepicker-input' : '' ?>" <?= ($permissao) ? '' : 'readonly' ?>/>
                            </div>
                            <div class="form-group col-sm-2">
                                <label class="control-label">&nbsp;</label>
                                <input type="button" id="btnRecalcula" class="btn btn-primary col-sm-12"
                                       value="Recalcular">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="col-sm-6 form-group">
                                <label class="control-label" for="obs">
                                    Observaes:
                                </label>
                                        <textarea name="obs" cols="50" class="form-control" id="obs" placeholder="Digite observaes sobre a baixa."
                                                  rows="5"><?= $parcelas['obs']; ?></textarea>
                            </div>
                        </div>
                    </div>
                </fieldset>
                <fieldset>
                    <legend>Operaes</legend>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group col-sm-2">
                                <button type="button" class="btn btn-primary col-sm-12 fDesabilitaBtn" id="gerar"> Gerar</button>
                            </div>
                        </div>
                    </div>
                </fieldset>
            </form>
        </div>
    </div>
</div>
<div class="modal fade mVisualizar " tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel"
    aria-hidden="true">
    <div class="modal-dialog modal-lg ">
        <div class="modal-content">

            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal"
                        aria-hidden="true">&times;</button>
                <h2 class="modal-title" id="myModalLabel" align="center"><i class="fa fa-book"></i>
                    Tutorial</h2>
            </div>

            <div class="modal-body tableFix" style="max-height:600px;">
                <fieldset >
                    <legend>Baixa de parcela manual - Realizao da Baixa de Pagamento das Parcelas</legend>
                    <div class="row" style="margin-right: 0px;margin-left: 0px;">
                        <iframe width="560" height="500" src="https://www.youtube-nocookie.com/embed/ZcShRcUiD1E?si=XQ6oer8mZxixFYkM" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>                        
                    </div>
                    <div></div>
                </fieldset>
            </div>
        </div>
    </div>
</div>
<?php require_once 'layout/includes/footer.php'; ?>