<?php
$empreendimentos = $this->get('empreendimentos');
?>
<?php require_once 'layout/includes/header.php'; ?>
<?php require_once 'layout/includes/menu.php'; ?>
    <div class="content">
        <div class="page-heading">
            <?= $this->getHeader('Alterar', 'Vencimento', 'fa fa-money'); ?>
        </div>
        <div class="widget">
            <div class="widget-content padding">
                <!-- MENSAGENS -->
                <?= ($_GET["msg"] == "success") ? '<div class="alert alert-success alert-dismissable">Operao realizada com sucesso.</div>'
                    : (($_GET['exception'] != '') ? '<div class="alert alert-danger alert-dismissable">' . $_GET['exception'] . '</div>' : '');
                ?>
                <?php if (count($this->_helper->getMensagens()) > 0): ?>
                    <div class="alert alert-danger alert-dismissable">
                        <?php foreach ($this->_helper->getMensagens() as $message): ?>
                            <?= $message ?><br>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
                <form action="" method="POST" id="form">
                    <fieldset>
                        <legend>Informaes da Alterao de Vencimento <span style=" font-size: 10pt;">(Campos com <span style=" color: red">*</span> so obrigatrios)</span>
                            <span data-toggle="modal" data-target=".mVisualizar" style="font-size: 22px;" data-toggle="tooltip" data-placement="top" title="Assista ao tutorial">
                                <svg xmlns="" width="22" height="22" fill="currentColor" class="bi bi-youtube" viewBox="0 0 16 16">
                                    <path d="M8.051 1.999h.089c.822.003 4.987.033 6.11.335a2.01 2.01 0 0 1 1.415 1.42c.101.38.172.883.22 1.402l.01.104.022.26.008.104c.065.914.073 1.77.074 1.957v.075c-.001.194-.01 1.108-.082 2.06l-.008.105-.009.104c-.05.572-.124 1.14-.235 1.558a2.01 2.01 0 0 1-1.415 1.42c-1.16.312-5.569.334-6.18.335h-.142c-.309 0-1.587-.006-2.927-.052l-.17-.006-.087-.004-.171-.007-.171-.007c-1.11-.049-2.167-.128-2.654-.26a2.01 2.01 0 0 1-1.415-1.419c-.111-.417-.185-.986-.235-1.558L.09 9.82l-.008-.104A31 31 0 0 1 0 7.68v-.123c.002-.215.01-.958.064-1.778l.007-.103.003-.052.008-.104.022-.26.01-.104c.048-.519.119-1.023.22-1.402a2.01 2.01 0 0 1 1.415-1.42c.487-.13 1.544-.21 2.654-.26l.17-.007.172-.006.086-.003.171-.007A100 100 0 0 1 7.858 2zM6.4 5.209v4.818l4.157-2.408z"></path>
                                </svg>
                            </span>
                        </legend>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-6">
                                    <label class="control-label" for="empreendimento_vencimento">
                                        Empreendimento:<span class="require" style="color: red">*</span>
                                    </label>
                                    <select class="form-control select2 empreendimento_vencimento"
                                            data-placeholder="Selecione o empreendimento"
                                            id="empreendimento_vencimento" required="required"
                                            name="empreendimento">
                                        <option value=""></option>
                                        <?php foreach ($empreendimentos as $empreendimento) : ?>
                                            <option value="<?= $empreendimento['id']; ?>">
                                                <?= $empreendimento['nm_empreendimento']; ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                                <div class="form-group col-sm-6">
                                    <label class="control-label" for="contrato">
                                        Contrato:<span class="require" style="color: red">*</span>
                                    </label>
                                    <select class="form-control select2 contrato_ano"
                                            name="contrato" id="contrato" required="required" data-placeholder="Selecione o contrato">
                                        <option value=""></option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-3">
                                    <label class="control-label" for="dataNova">
                                        Nova data de vencimento:<span class="require" style="color: red">*</span>
                                    </label>
                                    <input type="text" class="form-control data datepicker-input"
                                           id="dataNova" required="required" placeholder="Digite a data parcela"
                                           name="dataNova" value=""/>
                                </div>
                                <div class="form-group col-sm-3">
                                    <label class="control-label" for="dataVencimento">
                                        Alterar a partir da data:<span class="require" style="color: red">*</span>
                                    </label>
                                    <input type="text" class="form-control data datepicker-input parcela_data"
                                           id="dataVencimento" placeholder="Digite a data parcela"
                                           name="dataVencimento" value=""/>
                                </div>
                                <div class="col-sm-5">
                                    <label for="alteraData">Alterar contrato?</label>
                                    <span class="require" style="color:red; font-size: 9px;">(Altera tambm a data da 1 parcela e de reajuste do contrato)</span><br>
                                    <input id="alteraData" class="form-control icheck"
                                           type="checkbox" name="alteraData" />
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-12">
                                    <label class="control-label" style="float: left">
                                        Tipos de parcela:
                                    </label><br>
                                    <div class="checkbox">
                                        <label><input id="tpParcelaN" class="form-control icheck tipoParcela"
                                                      type="radio" name="tipoParcela[]" value="N" checked/> Normal</label>
                                        <label for="tpParcelaI"><input id="tpParcelaI" class="form-control icheck tipoParcela"
                                                                       type="radio" name="tipoParcela[]" value="I"/> Intercalada</label>

                                        <label for="tpParcelaC"><input id="tpParcelaC" class="form-control icheck tipoParcela"
                                                                       type="radio" name="tipoParcela[]" value="C"/> Chaves</label>
                                        <label for="tpParcelaS"><input id="tpParcelaS" class="form-control icheck tipoParcela"
                                                                       type="radio" name="tipoParcela[]" value="S"/> Sinal</label>
                                        <label for="tpParcelaQ"><input id="tpParcelaQ" class="form-control icheck tipoParcela"
                                                                       type="radio" name="tipoParcela[]" value="Q"/> Quitao</label>
                                        <label for="tpParcelaG"> <input id="tpParcelaG" class="form-control icheck tipoParcela"
                                                                        type="radio" name="tipoParcela[]" value="G"/> Negociada</label>
                                        <label for="tpParcelaA"> <input id="tpParcelaA" class="form-control icheck tipoParcela"
                                                                        type="radio" name="tipoParcela[]" value="A"/> Avulsa</label>
                                    </div>
                                </div>
                            </div>
                        </div><div class="row checkCoincidirInterceladas">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-12">
                                    <label class="control-label" style="float: left">
                                        Coincidir com parcelas intercaladas:
                                    </label><br>
                                    <div class="checkbox">
                                        <label for="coincidirInterceladasS">
                                            <input id="coincidirInterceladasS" class="form-control icheck"
                                                      type="radio" name="coincidirInterceladas" value="S" checked/> Sim</label>
                                        <label for="coincidirInterceladasN">
                                            <input id="coincidirInterceladasN" class="form-control icheck"
                                                                       type="radio" name="coincidirInterceladas" value="N"/> No</label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </fieldset>
                    <fieldset>
                        <legend>Operaes</legend>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-2">
                                    <input type="submit" class="btn btn-primary col-sm-12 fDesabilitaBtn" value="Salvar">
                                </div>
                            </div>
                        </div>
                    </fieldset>
                </form>

            </div>
        </div>
    </div>
<div class="modal fade mVisualizar " tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel"
    aria-hidden="true">
    <div class="modal-dialog modal-lg ">
        <div class="modal-content">

            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal"
                        aria-hidden="true">&times;</button>
                <h2 class="modal-title" id="myModalLabel" align="center"><i class="fa fa-book"></i>
                    Tutorial</h2>
            </div>

            <div class="modal-body tableFix" style="max-height:600px;">
                <fieldset >
                    <legend>Alterao de vencimento - Alterar data de Vencimento das Parcelas</legend>
                    <div class="row" style="margin-right: 0px;margin-left: 0px;">
                        <iframe width="560" height="500" src="https://www.youtube-nocookie.com/embed/NtoHhHVAK58?si=PYRKVI_3Wy_1ilOa" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>                        
                    </div>
                    <div></div>
                </fieldset>
            </div>
        </div>
    </div>
</div>
<?php require_once 'layout/includes/footer.php'; ?>