<?php

class ReciboController extends Controller
{
    protected $tb_pessoa;
    protected $tb_agrupada;
    protected $tb_pessoa_juridica;
    protected $tb_cliente;
    protected $tb_taxas;
    protected $tb_empreendimento;
    protected $tb_recibo;

    public function __construct($request)
    {
        parent::__construct($request);
        $this->tb_pessoa = new Pessoa();
        $this->tb_pessoa_juridica = new Pessoa_Juridica();
        $this->tb_agrupada = new Db_TabelaAgrupada();
        $this->tb_cliente = new Db_Cliente();
        $this->tb_taxas = new TaxaValor();
        $this->tb_empreendimento = new Empreendimento();
        $this->tb_recibo = new Recibo();
    }
    public function indexAction()
    {
        $this->redir(array("modulo" => "fin", "controller" => "recibo", "action" => "listar"));
    }
    public function listarAction()
    {
        if ($this->isAjax()) {
            $listaRecibos = Recibo::getLista($_POST);
            $totalRecibos = Recibo::getLista($_POST, true);
            $lista = array();
            foreach ($listaRecibos as $recibo) {
                $reservado = $recibo['fl_status'] == '0' ? true : false;
                $title = "return confirm('Tem certeza que deseja cancelar este recibo " . $recibo['id_recibo'] . "?')";
                $title = $recibo['fl_status'] == '0' ? '' : $title;
                $href = $recibo['fl_status'] == '0' ? '#' : '?m=fin&c=recibo&a=cancelar&id=' . $recibo['id_recibo'];
                $tooltip = $recibo['fl_status'] == '0' ? 'CANCELADO' : 'CANCELAR';
                $acoes = '<div style="width: 90px"></div><div align="center" style="width: 100%;">';
                $acoes .= '<a target="_blank" href="?m=' . $this->modulo . '&c=' . $this->controller . '&a=gerar&id=' . $recibo['id_recibo'] . '" data-toggle="tooltip" title="IMPRIMIR" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-file-text"></i></a>';
                $acoes .= '<a onclick="' . $title . '"  href="' . $href . '" data-toggle="tooltip" title="' . $tooltip . '" class="btn btn-default btn-sm" style="margin-right:5px" ' . ($reservado ? 'disabled' : '') . '><i class="fa fa-undo"></i></a>';
                $acoes .= '</div>';
                $acoes .= '</div>';

                $cor = '';
                if ($recibo['fl_status'] == 0) {
                    $cor = 'style="color:red;"';
                }

                //Para ordenar por data
                $data = '<div hidden>'
                    . $recibo['dt_recibo']
                    . '</div>'
                    . Helper::getDate($recibo['dt_recibo']);

                $descricao = ($recibo['descricao']) ? $recibo['descricao'] : 'Pagto Parcela';;

                $lista[] = array(
                    'codigo' => $recibo['id_recibo'],
                    'empreendimento' => '<div ' . $cor . ' >' . utf8_encode($recibo['nm_empreendimento']) . '</div>',
                    'pessoa' => '<div ' . $cor . ' >' . utf8_encode($recibo['nm_pessoa']) . '</div>',
                    'taxa' => '<div ' . $cor . ' >' . utf8_encode($descricao) . '</div>',
                    'valor' => '<div ' . $cor . ' >' . Helper::getMoney($recibo['vl_recibo']) . '</div>',
                    'data' => '<div align="center" ' . $cor . '>' . $data . '</div>',
                    'acoes' => utf8_encode($acoes)


                );
            }

            echo json_encode(array(
                'draw' => $_POST['draw'],
                'recordsTotal' => count($totalRecibos),
                'recordsFiltered' => count($totalRecibos),
                'data' => $lista
            ));
        } else {
            $this->display('listar');
        }
    }
    public function adicionarAction()
    {
        $instanceEmpreendimento = new Empreendimento();
        $empreendimento = $instanceEmpreendimento->getDefaultAdapter();

        $empreendimento = $empreendimento->select()
            ->from(array('e' => TB_EMPREENDIMENTO), array('id_empreendimento' => 'id', 'nm_empreendimento'));

        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $empreendimento->where("e.id IN({$id})");
                } else {
                    $empreendimento->where("1");
                }
            } catch (Exception $e) {

            }
        }
        $empreendimento = $empreendimento->group('e.id')->order('nm_empreendimento')->query()->fetchAll();
        $empreendimentos = array("" => "Selecione");
        foreach ($empreendimento as $e) {
            $empreendimentos[$e['id_empreendimento']] = $e['nm_empreendimento'];
        }
        $this->set('empreendimentos', $empreendimentos);

        if ($this->_isPost && $this->validar()) {

            try {
                $transacaoRecibo = $this->tb_recibo->getAdapter()->beginTransaction();
                $vlDesconto = $this->_helper->getInputMoney($_POST['vl_desconto']);
                $vlTaxa = $this->_helper->getInputMoney($_POST['vl_taxa']);
                $vlRecibo = $vlTaxa - $vlDesconto;

                // Inserindo recibo
                $tb_recibo = $this->tb_recibo->createRow();
                $tb_recibo->id_empreendimento = $_POST['idEmpreendimento'];
                $tb_recibo->id_pessoa = $_POST['cliente'];
                $tb_recibo->id_taxa = $_POST['id_taxa'];
                $tb_recibo->vl_recibo = $vlRecibo;
                $tb_recibo->vl_desconto = $vlDesconto ? $vlDesconto : 0;
                $tb_recibo->ds_forma_pagamento = $_POST['ds_forma_pagamento'];
                $tb_recibo->dt_recibo = $this->_helper->getInputDate($_POST["data"]);
                $tb_recibo->fl_status = 1;
                $tb_recibo->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - i');

                $tb_recibo->save();
                $transacaoRecibo->commit();
                $this->redir(array('modulo' => 'fin', 'controller' => 'recibo', 'action' => 'listar'), array('msg' => 'success'));
            } catch (Exception $e) {
                $transacaoRecibo->rollBack();
                $this->_helper->addMensagem("danger", $e->getMessage());
            }
        }
        $this->display("form");
    }
    public function gerarAction()
    {
        $tbClienteAcade = new Db_Cliente();
        $this->set('cliente', $tbClienteAcade->fetchRow()->toArray());
        $recibo = $this->tb_recibo->getAdapter()->select()
            ->from(array('r' => TB_RECIBO), array('vl_recibo', 'ds_forma_pagamento','dt_recibo','ds_info_adicional','id_taxa'))
            ->joinLeft(array('e' => TB_EMPREENDIMENTO), 'r.id_empreendimento = e.id', array('idEmpreendimento' => 'id', 'nm_empreendimento', 'fl_assinatura', 'ds_path_logo'))
            ->joinLeft(array('t' => TB_TAXA_VALOR), 't.id_taxas = r.id_taxa', null)
            ->joinLeft(array('agr' => TB_AGRUPADA), 't.id_tipo_taxa = agr.idCampo AND agr.idTabela = "17" ', array('descricao'))
            ->join(array('p' => TB_PESSOA), 'r.id_pessoa = p.id', array('nm_pessoa'))
            ->joinLeft(array('pf' => TB_PESSOA_FISICA), 'p.id = pf.id_pessoa', 'nr_cpf')
            ->joinLeft(array('pj' => TB_PESSOA_JURIDICA), 'p.id = pj.id_pessoa', 'nr_cnpj')
            ->joinLeft(array("m1" => TB_CIDADE), "p.cd_cidade = m1.id", array("cidadeCli" => "nome", "ufCli" => "uf"))
            ->joinLeft(array("cidEmp" => TB_CIDADE), "e.cd_cidade = cidEmp.id", array("cidEmp" => "nome", "ufEmp" => "uf"))
            ->where('r.id_recibo =' . $_GET['id'])
            ->query()->fetch();

        if ($recibo['idEmpreendimento']) {
            $pessoasEnvolvidas = (new Assinatura())->getAdapter()->select()
                ->from(array('a' => TB_ASSINATURA), array(''))
                ->join(array('p' => TB_PESSOA), 'p.id = a.id_pessoa', 'nm_pessoa')
                ->joinLeft(array('pf' => TB_PESSOA_FISICA), 'p.id = pf.id_pessoa', 'nr_cpf')
                ->joinLeft(array('pj' => TB_PESSOA_JURIDICA), 'p.id = pj.id_pessoa', 'nr_cnpj')
                ->where('id_empreendimento = ' . $recibo['idEmpreendimento'])
                ->query()->fetchAll();

            $pessoasEnvolvidas = array_map(function ($pessoaEnvolvida) {
                $pessoaEnvolvida['nrCpfCnpj'] = ($pessoaEnvolvida['nr_cpf'])?$pessoaEnvolvida['nr_cpf']:$pessoaEnvolvida['nr_cnpj'];
                return $pessoaEnvolvida;
            }, $pessoasEnvolvidas);

            $pessoasInteressadas = (new Parceria())->getAdapter()->select()
                ->from(array('pa' => TB_PARCERIA), array(''))
                ->join(array('p' => TB_PESSOA), 'p.id = pa.id_pessoa', 'nm_pessoa')
                ->joinLeft(array('pf' => TB_PESSOA_FISICA), 'p.id = pf.id_pessoa', 'nr_cpf')
                ->joinLeft(array('pj' => TB_PESSOA_JURIDICA), 'p.id = pj.id_pessoa', 'nr_cnpj')
                ->where('id_empreendimento = ' . $recibo['idEmpreendimento'])
                ->query()->fetchAll();

            $pessoasInteressadas = array_map(function ($pessoasInteressada) {
                $pessoasInteressada['nrCpfCnpj'] = ($pessoasInteressada['nr_cpf'])?$pessoasInteressada['nr_cpf']:$pessoasInteressada['nr_cnpj'];
                return $pessoasInteressada;
            }, $pessoasInteressadas);
        }

        $this->set("recibo", $recibo);
        $this->set("pessoasEnvolvidas", $pessoasEnvolvidas);
        $this->set("pessoasInteressadas", $pessoasInteressadas);

        $this->displayMPDF("recibo" . date("d/m/Y") . ".pdf", true, "P", "A4", array(5, 5, 5, 8));
    }
    public function cancelarAction()
    {
        try {
            $recibo = $this->tb_recibo->fetchRow('id_recibo = ' . $_GET['id']);
            $recibo->fl_status = '0';
            $recibo->save();
            $this->redir(array("modulo" => "fin", "controller" => "recibo"), array("msg" => "OK", "pageID" => $_GET['pageID']));
        } catch (Exception $e) {
            $this->redir(array('modulo' => 'fin', 'controller' => 'recibo', 'action' => 'adicionar'), array('msg' => 'fail', 'exception' => $e->getMessage()));
        }
    }

    public function clienteEmpreendimentoAction()
    {
        $contratos = (new Contrato())->getAdapter()->select()
            ->from(array('L' => TB_LOTES), array('loteId' => 'id', 'lote', 'quadra'))
            ->join(array('C' => TB_CONTRATO), 'C.id_lote = L.id', array('id'))
            ->join(array('P' => TB_PESSOA), 'P.id = C.id_pessoa', array('nm_pessoa', 'idPessoa' => 'id'))
            ->joinLeft(array('ph' => TB_PARCELA), 'ph.id_contrato = C.id')
            ->where('L.id_empreendimento = ?', $_POST['idEmpreendimento'])
            ->where("fl_distrato = '0'")
            ->where("fl_aprovar_contrato = '1'")
            ->distinct()
            ->order(array('nm_pessoa ASC', 'L.quadra ASC', 'L.lote ASC'))
            ->group('L.id')
            ->query()->fetchAll();

        $lista = array_map(function ($contrato) {
            return array( 'id' => $contrato['idPessoa'], 'text' => utf8_encode( $contrato['nm_pessoa'] . ' - Quadra: ' . $contrato['quadra'] . ' - Lote: ' . $contrato['lote'] . ' - Contrato: ' .$contrato['id']));
        }, $contratos);

        echo json_encode($lista);
    }
    public function taxaEmpreendimentoAction()
    {
        $taxas = (new TaxaValor())->getAdapter()->select()
            ->from(array('t' => TB_TAXA_VALOR), array('*'))
            ->join(array('e' => TB_EMPREENDIMENTO), 't.id_empreendimento = e.id', array())
            ->join(array('agr' => TB_AGRUPADA), 't.id_tipo_taxa = agr.idCampo AND agr.idTabela = "17"', array('descricao'))
            ->order('descricao')
            ->where('e.id = ' . $_POST['idEmpreendimento'])
            ->query()->fetchAll();

        $lista = array_map(function ($taxa) {
            return array('id'=> $taxa['id_taxas'], 'text' => utf8_encode($taxa['descricao']));
        }, $taxas);

        echo json_encode($lista);
    }

    /**
     *
     */
    public function findTaxaAction()
    {
        $taxas = new TaxaValor();
        $taxas = $taxas->fetchRow('id_taxas = '.$_POST['idTaxa'])->toArray();
        echo json_encode($taxas);
    }
    public function validar()
    {
        $campos = array(
            'cliente' => 'O campo <b>Cliente</b> � obrigat�rio',
            'idEmpreendimento' => 'O campo <b>Empreendimento</b> � obrigat�rio',
            'ds_forma_pagamento' => 'O campo <b>Forma de Pagamento</b> � obrigat�rio',
            'data' => 'O campo <b>Data de Recibo</b> � obrigat�rio',
        );
        foreach ($campos as $campo => $msg) {
            if ($_POST[$campo] == "") {
                $this->_helper->addMensagem('danger', $msg);
            }
        }
        return !(count($this->_helper->getMensagens()) > 0);
    }
} 