<?php

class ReajusteController extends Controller
{
    private $meses;
    private $tiposParcela;
    private $periodos;
    public function __construct($request)
    {
        parent::__construct($request);
        $this->meses = array(
            '01' => 'Janeiro',
            '02' => 'Fevereiro',
            '03' => 'Maro',
            '04' => 'Abril',
            '05' => 'Maio',
            '06' => 'Junho',
            '07' => 'Julho',
            '08' => 'Agosto',
            '09' => 'Setembro',
            '10' => 'Outubro',
            '11' => 'Novembro',
            '12' => 'Dezembro'
        );
        $this->periodos = array('M' => 1, 'B' => 2, 'T' => 3, 'S' => 6, 'A' => 12, 'AM' => 12);

        $this->TiposParcela = array(
            'T' => 'Todas',
            'N' => 'Normais',
            'I' => 'Intercaladas',
            'C' => 'Chaves'
        );
    }

    public function indexAction()
    {
        $this->redir(array("modulo" => "fin", "controller" => "reajuste", "action" => "listar"));
    }

    public function listarAction()
    {

        if ($this->isAjax()) {
            $listaItem = Parcela::findReajusteParcela($_POST);
            $totalItens = Parcela::findReajusteParcela($_POST,true);
            $lista = array();
            $format = "d/m/Y";
            foreach ($listaItem as $item) {
                $spanForOrder = '<span style="visibility:hidden">'. $item['id'] .'</span>';
                $checkbox = $spanForOrder . '<input type="checkbox" disabled>' ;

                if ( is_null($item['vl_mensal']) && is_null($item['vl_intercalada']) && is_null($item['vl_chave']) && is_null($item['vl_sinal']) ){
                    $acao = '<div align="center">
                    <a onclick="return alert('."'No foi possvel realizar esta ao. Por favor entre em contato com o suporte.'".')" href="#" data-toggle="tooltip" title="DESFAZER" class="btn btn-default btn-sm" style="margin-right:5px">
                    <i class="fa fa-times"></i></a></div>';
                } else {
                    $reajuste = new HistoricoReajuste();
                    $reajuste = $reajuste->getAdapter()->select()
                    ->from(array('h' => TB_HISTORICO_REAJUSTE), array('data'))
                    ->where('idContrato = '. $item['idContrato'])
                    ->order('data DESC')
                    ->limit('1')->query()->fetch();
                    $date1  = \DateTime::createFromFormat($format, Helper::getDate($reajuste['data']));
                    $date2  = \DateTime::createFromFormat($format, Helper::getDate($item['data']));

                    if ($date2 == $date1) {
                        $acao = '<div align="center">
                        <a onclick="delReajuste('.$item['id'].')" href="#" data-toggle="tooltip" title="DESFAZER" class="btn btn-default btn-sm" style="margin-right:5px">
                        <i class="fa fa-times"></i></a></div>';
                        $checkbox = $spanForOrder . '<input type="checkbox" value="' . $item['id'] . '" id="checkDesfazer" onClick="checkBox();">' ;
                    } else {
                        $acao = '<div align="center">
                        <a onclick="return alert('."'Existem reajustes com datas mais recentes que devem ser desfeitos primeiro.'".')" href="#" data-toggle="tooltip" title="DESFAZER" class="btn btn-default btn-sm" style="margin-right:5px">
                        <i class="fa fa-times"></i></a></div>';
                    }
                                     
                }
                switch($item['tp_parcela']){
                    case 'T':
                        $item['tipo'] = 'Todas';
                        break;
                    case 'N':
                        $item['tipo'] = 'Normais';
                        break;
                    case 'I':
                        $item['tipo'] = 'Intercaladas';
                        break;
                    case 'C':
                        $item['tipo'] = 'Chaves';
                        break;
                }

                $data = '<div hidden>' . $item['data'] . '</div>' . Helper::getDate($item['data']);
                $indiceAdc = ($item['fl_periodo_adc'])?number_format((float)$item['indice_adicional'], 2, ',', '') . '% - ' . Helper::getNomePeriodo($item['fl_periodo_adc']):'-';
                $lista[] = array(
                    'checkbox' => $checkbox,
                    'id' => $item['id'],
                    'residuo' => $item['vl_residuo'] ? Helper::getMoney($item['vl_residuo']) : '0,00',
                    'contrato' => '<div align="center">' . $item['idContrato'] . '</div>',
                    'empreendimento' => utf8_encode($item['nm_empreendimento']),
                    'pessoa' => utf8_encode($item['nm_pessoa']),
                    'quadra' => '<div align="center">' . utf8_encode($item['quadra']) . '</div>',
                    'lote' => '<div align="center">' . utf8_encode($item['lote']) . '</div>',
                    'reajuste' => '<div align="center">' . $data . '</div>',
                    'tipo' => '<div align="center">' . $item['tipo'] . '</div>',
                    'indice' => utf8_encode($item['nmIndice']).' - '.utf8_encode(Helper::getNomePeriodo($item['fl_periodo'])),
                    'indiceAdc' => '<div align="center">' . $indiceAdc .'</div>',
                    'porcIndice' => '<div align="center">' . number_format((float)$item['indice'], 2, ',', '') . '% </div>',
                    'usuario' => utf8_encode($item['usuario']),
                    'acao' => utf8_encode($acao)
                );
            }
            echo json_encode(array(
                'draw' => $_POST['draw'],
                'data' => $lista,
                'recordsFiltered' =>$totalItens[0]['contador'],
                'recordsTotal'=>$totalItens[0]['contador']
            ));
        } else {
            $this->display('listar');
        }
    }

    public function reajusteAction()
    {
        set_time_limit(0);
        $this->set("meses", $this->meses);
        $this->set("tiposParcela", $this->TiposParcela);
        $this->set('empreendimentos', Empreendimento::getEmpreendimentos());
        if ($this->_isPost && $this->validar()) {
            $tbContrato = new Contrato();
            $tb_empreendimento = new Empreendimento();
            $tbParcela = new Parcela();
            $empreendimento = $tb_empreendimento->fetchRow("id = {$_POST['idEmpreendimento']}")->toArray();
            // id_indice_empreendimento
            $idIndice = $_POST['idIndice'];
            //Se for manual (individual), pega o indice direto do contrato
            if ($_POST['tpReajuste'] == 'M') {
                if (isset($_POST['idContrato'])) {
                    $contrato = $tbContrato->fetchRow('id = '.$_POST['idContrato']);
                    $idIndice = $contrato['id_indice'];
                }
            }            
            $tbIndiceEmpreendimento = new IndiceEmpreendimento();
            $indiceEmpreendimento = $tbIndiceEmpreendimento->fetchRow('id_indice_empreendimento = '.$idIndice);
            //Testa o intervalo cadastrado
            $indicePeriodo = $indiceEmpreendimento['fl_periodo']?$indiceEmpreendimento['fl_periodo']:$indiceEmpreendimento['fl_periodo_adc'];
            switch ($indicePeriodo) {
                case 'M':
                    $intervalo = '1 MONTH';
                    break;
                case 'B':
                    $intervalo = '2 MONTH';
                    break;
                case 'T':
                    $intervalo = '3 MONTH';
                    break;
                case 'S':
                    $intervalo = '6 MONTH';
                    break;
                default:
                    $intervalo = '1 YEAR';
                    break;
            }
            $mesInicial = $_POST['mes_inicial'];
            $anoInicial = $_POST['ano_inicial'];
            $dataInicial = $_POST['ano_inicial'] . "-" . $_POST['mes_inicial'] . "-01";
            //busca os contratos a serem ajustados no mes e ano especificados
            $listaJoin = $tbContrato->getAdapter()->select()
                ->from(array('c' => TB_CONTRATO), array('id'))
                ->join(array('l' => TB_LOTES), 'l.id = c.id_lote', array(''))
                ->join(array('p' => TB_PARCELA), 'c.id = p.id_contrato', array('min(dt_parcela) as dt_parcela_min'))
                ->join(array('pe' => TB_PESSOA), 'c.id_pessoa = pe.id', array(''))
                ->where('c.id_indice = '.$idIndice)
                ->where('p.dt_parcela >= "'.$dataInicial.'"')
                ->where('l.id_empreendimento = '.$_POST['idEmpreendimento'])
                ->where('p.fl_reajustavel = "1"')
                ->where('p.pago = "0"')
                ->where('tp_parcela NOT IN ("E","NE","SE","CE","IE","Q","G","A")')
                ->where('fl_distrato = "0"');
            // tpReajuste => M = Individual / A = Grupo
            if ($_POST['tpReajuste'] == 'M') {
                $listaJoin = $listaJoin->where('c.id = '.$_POST['idContrato']);
            }
            //Verifica quais as parcelas que sero incluidas no reajuste
            $listaJoin = Helper::tipoReajuste($_POST['tipoParcela'], $listaJoin, $intervalo, $anoInicial, $mesInicial);
            $listaJoin = $listaJoin->group('c.id');
            // Realiza um join com o select acima
            // Melhorando a ordenao das parcelas quanto a sua data inicial em virtude do group by no ordenar bem
            $listaContratos = $tbParcela->getAdapter()->select()
                ->from(array('p' => TB_PARCELA), array('dt_parcela', 'dt_parcela', 'tp_parcela', 'id_parcela'))
                ->join(array('lj' => $listaJoin), 'p.dt_parcela = lj.dt_parcela_min AND p.id_contrato = lj.id', '') 
                ->join(array('c' => TB_CONTRATO), 'c.id = p.id_contrato', array('id','dt_reajuste', 'dt_reajuste_mensal', 'dt_reajuste_intercalada', 'dt_reajuste_chave'))
                ->join(array('l' => TB_LOTES), 'l.id = c.id_lote', array('lote','quadra'))
                ->join(array('pe' => TB_PESSOA), 'c.id_pessoa = pe.id', array('nm_pessoa'))
                ->where('c.id_indice = '.$idIndice)
                ->where('p.dt_parcela >= "'.$dataInicial.'"')
                ->where('l.id_empreendimento = '.$_POST['idEmpreendimento'])
                ->where('p.fl_reajustavel = "1"')
                ->where('p.pago = "0"')
                ->where('tp_parcela NOT IN ("E","NE","SE","CE","IE","Q","G","A")')
                ->where('fl_distrato = "0"')
                ->group('c.id');

            //Verifica quais as parcelas que sero incluidas no reajuste
            $listaContratos = Helper::tipoReajuste($_POST['tipoParcela'], $listaContratos, $intervalo, $anoInicial, $mesInicial);
            $listaContratos = $listaContratos->query()->fetchAll();

            $verificaReajuste = new HistoricoReajuste();
            $tbParcela = new Parcela();

            $mesInicio = (int)$mesInicial;
            $anoInicio = (int)$anoInicial;

            //Estrutura que gera mes e ano de acordo com o periodo de reajuste,
            //caso seja periodo de 12 meses, ele calcula qual sera o mes e ano de 12 meses atras
            $dataFinal = new DateTime($anoInicio . '-' . $mesInicio . '-01');
            // data indice refere-se a 02 meses atrs
            $dataFinalIndices = $dataFinal->modify('-2 month')->format('Ym');
            
            for ($i = 1; $i <= ($this->periodos[$indicePeriodo] + 1); $i++) {
                $mesInicio--;
                if ($mesInicio == 0) {
                    $anoInicio -= 1;
                    $mesInicio = 12;
                }
            }

            $dataInicioIndices = $anoInicio . str_pad($mesInicio, 2, '0', STR_PAD_LEFT);

            if ($indiceEmpreendimento['id_indice'] && $indiceEmpreendimento['id_indice']!=5) {
                $listaIndices = IndiceGeral::getIndices($indiceEmpreendimento['id_indice'], $dataInicioIndices, $dataFinalIndices);
            } else if ($indiceEmpreendimento['fl_periodo_adc']) {
                $listaIndices = [];
                //Gera os meses manualmente se no houver indice cadastrado porem existir periodo adicional
                //Desta forma passa na validao
                $begin = new DateTime(strval(substr($dataInicioIndices, 0, 4) . '-' . substr($dataInicioIndices, 4, 2) . '-01'));
                $end = new DateTime(strval(substr($dataFinalIndices, 0, 4) . '-' . substr($dataFinalIndices, 4, 2) . '-01'));
                $end->modify('first day of next month');
                $interval = DateInterval::createFromDateString('1 month');
                $period = new DatePeriod($begin, $interval, $end);
                foreach ($period as $key => $dt) {
                    $listaIndices[$key]['mes'] = $dt->format("m");
                    $listaIndices[$key]['ano'] = $dt->format("Y");
                    //Adiciona % de ndice apenas na primeira interao evitando assim a sua duplicao
                    if ($key == 0) {
                        $listaIndices[$key]['valor'] = $indiceEmpreendimento['indice_adicional'];
                    } else {
                        $listaIndices[$key]['valor'] = 0;
                    }
                    $listaIndices[$key]['descricao'] = 'ndice Adicional';
                }
            }
            $reajusteForaData = false;
            //Validao de ultimo reajuste
            foreach ($listaContratos as $key => &$contrato) {
                $tb_historicoReajuste = new HistoricoReajuste();
                $_POST['tipoParcela'] == 'T' ? $tParcela = '' :  $tParcela = " && tp_parcela = '" . $_POST['tipoParcela'] . "'";
                $hist = $tb_historicoReajuste->fetchRow('idContrato = '.$contrato['id'] . $tParcela , 'data desc');
                if ($hist) {
                    $hist = $hist->toArray();
                    $dataHistReajuste = explode('-', $hist['data']);
                    $dataHistReajusteMesAno = $dataHistReajuste[0] . '-' . $dataHistReajuste[1] . '-01';

                    $mesDoContrato = $dataHistReajuste[1];
                    //Verifica se o intervalo de meses entre a data do ultimo reajuste e data do reajuste atual
                    // diferente do intervalo de meses selecionada no empreendimento
                    if ($this->dataDiff($dataHistReajusteMesAno, $dataInicial, 'm') != $this->periodos[$indicePeriodo]) {
                        //Verifica reajuste fora do perodo
                        if ($_POST['tpReajuste'] == 'M' && $_POST['acceptReajusteFora']) {
                            $reajusteForaData = true;
                        } else if ($_POST['tpReajuste'] == 'M' && $this->isAjax()) {
                            $dataPrevistaReajuste = (new DateTime($dataHistReajusteMesAno))->modify("+{$this->periodos[$indicePeriodo]} month")->format('d/m/Y');
                            echo json_encode(['result' => $dataPrevistaReajuste]);
                            return;
                        } else {
                            unset($listaContratos[$key]);
                        }
                    }
                } else {
                    $dataDoReajuste = Helper::dataDoReajuste($_POST['tipoParcela'], $contrato);
                    $datatReajContrato = explode('-', $dataDoReajuste);
                    $dataHistReajusteMesAno = $datatReajContrato[0] . '-' . $datatReajContrato[1] . '-01';

                    $mesDoContrato = $datatReajContrato[1];
                    //Verifica se o inervalo de meses entre a data de reajuste do contrato e data do reajuste atual
                    // diferente do intervalo de meses selecionado no empreendimento
                    if ($this->dataDiff($dataHistReajusteMesAno, $dataInicial, 'm') != $this->periodos[$indicePeriodo]) {
                        //Verifica reajuste fora do perodo
                        if ($_POST['tpReajuste'] == 'M' && $_POST['acceptReajusteFora']) {
                            $reajusteForaData = true;
                        } else if ($_POST['tpReajuste'] == 'M' && $this->isAjax()) {
                            $dataPrevistaReajuste = (new DateTime($dataHistReajusteMesAno))->modify("+{$this->periodos[$indicePeriodo]} month")->format('d/m/Y');
                            echo json_encode(['result' => $dataPrevistaReajuste]);
                            return;
                        } else {
                            unset($listaContratos[$key]);
                        }
                    }
                }

                //VERIFICA SE EXISTE PARCELAS A REAJUSTAR OU SE JA FOI FEITO REAJUSTE
                $parcelaInicial = null;

                $parcelas = $tbParcela->select()
                    ->from(TB_PARCELA, array('id_parcela_contrato', 'id_parcela', 'dt_parcela', 'pago', 'tp_parcela','vl_parcela'))
                    ->where('dt_parcela >= "'.$dataInicial.'"')
                    ->where('id_contrato = '.$contrato['id'])
                    ->where('fl_reajustavel = "1"')
                    ->order('dt_parcela');

                if($_POST['tipoParcela'] == 'T'){
                    $parcelas = $parcelas->where('tp_parcela in ("N","I","C")');
                }
                if($_POST['tipoParcela'] == 'N'){
                    $parcelas = $parcelas->where('tp_parcela in ("N")');
                }
                if($_POST['tipoParcela'] == 'I'){
                    $parcelas = $parcelas->where('tp_parcela in ("I")');
                }
                if($_POST['tipoParcela'] == 'C'){
                    $parcelas = $parcelas->where('tp_parcela in ("C")');
                }
                $parcelas = $parcelas->query()->fetchAll();

                if ($parcelas) {
                    $warningParcelasPagas = '';
                    $qtdeTotalParcNaoPagas = 0;

                    foreach ($parcelas as $parcela) {
                        if ($parcela['pago'] == '1') {
                            $warningParcelasPagas = 'O(s) contrato(s) selecionado(s) h parcela(s) paga(s)';
                        } else {
                            $qtdeTotalParcNaoPagas++;
                            if ($parcela['tp_parcela'] == 'N') {
                                if (!isset($parcelaInicial) || $parcelaInicial == null) {
                                    $parcelaInicial = $parcela;
                                }
                            }
                        }
                    }

                    if (!isset($parcelaInicial) || $parcelaInicial == null) {
                        $parcelaInicial = $parcelas[0];
                    }
                    $historicoReajuste = $verificaReajuste->fetchRow('idContrato = '.$contrato['id'].' AND idParcelaInicio = '.$parcelaInicial['id_parcela'].' AND data >= "'.$dataInicial.'"');
                    if ($historicoReajuste) {
                        unset($listaContratos[$key]);
                    }
                } else {
                    unset($listaContratos[$key]);
                }

                // Realiza o resduo
                if ($indiceEmpreendimento['fl_residuo'] == '1' && $qtdeTotalParcNaoPagas > 0) {

                    // Decrementa um ms da data do indice e cria data inicial
                    $mesDtInicialResiduo = (substr($dataInicioIndices, -2) == '12')?'01':substr($dataInicioIndices, -2)+1;
                    $anoDtInicialResiduo = (substr($dataInicioIndices, -2) == '12')?substr($dataInicioIndices, 0,4)+1:substr($dataInicioIndices, 0,4);
                    $dataInicialResiduo = $anoDtInicialResiduo.'-'.$mesDtInicialResiduo.'-01';

                    // Decrementa um ms da data do indice e cria data final
                    $mesDtFinalResiduo = (substr($dataFinalIndices, -2) == '12')?'01':substr($dataFinalIndices, -2)+1;
                    $anoDtFinalResiduo = (substr($dataFinalIndices, -2) == '12')?substr($dataFinalIndices, 0,4)+1:substr($dataFinalIndices, 0,4);
                    $dataFinalResiduo = $anoDtFinalResiduo.'-'.$mesDtFinalResiduo.'-31';

                    $parcelasResiduo = $tbParcela->select()
                        ->from(TB_PARCELA, array('id_parcela_contrato', 'id_parcela', 'dt_parcela', 'pago', 'tp_parcela','vl_parcela'))
                        ->where('dt_parcela >= "'.$dataInicialResiduo.'"')
                        ->where('dt_parcela <= "'.$dataFinalResiduo.'"')
                        ->where('id_contrato = '.$contrato['id'])
                        ->where('fl_reajustavel = "1"')
                        ->where('tp_parcela NOT IN ("G","S","Q","E","A")')
                        ->order('dt_parcela')
                        ->query()->fetchAll();

                    //Cria lista de numero multiplicador de acordo com mes/ano do periodo de parcelas que geraro residuos
                    for ($i = 1; $i <= ($this->periodos[$indicePeriodo]); $i++) {
                        if ($mesDtInicialResiduo > 12) {
                            $anoDtInicialResiduo += 1;
                            $mesDtInicialResiduo = 01;
                        }
                        $mesDtInicialResiduo = ($mesDtInicialResiduo < 10)?'0'.$mesDtInicialResiduo:$mesDtInicialResiduo;
                        $listNrMultiplicador[$anoDtInicialResiduo.$mesDtInicialResiduo] = $i;
                        $mesDtInicialResiduo++;
                    }

                    $contrato['vlResiduo'] = 0;

                    foreach ($parcelasResiduo as $parcResiduo) {
                        // Pega o indice de dois meses anteriores  data da parcela para realizar o calculo do residuo
                        $dtParcela = explode('-', $parcResiduo['dt_parcela']);
                        $mesDtFinal = ($dtParcela[1] <= '01')?12 + ($dtParcela[1] - 1):$dtParcela[1]-1;
                        $mesDtFinal = ($mesDtFinal < 10)?'0'.$mesDtFinal:$mesDtFinal;
                        $anoDtFinal = ($dtParcela[1] <= '01')?$dtParcela[0]-1:$dtParcela[0];
                        $indiceResiduo = Controller::getAdapterAcadeGeral()->select()
                            ->from(array('i' => TB_INDICE_GERAL), array('*'))
                            ->where('agr_descricaoIndice = '.$indiceEmpreendimento['id_indice'].
                            ' AND ano = "'.$anoDtFinal.'" AND mes = "'.$mesDtFinal.'"')
                            ->query()->fetch();

                        //Pega o numero multiplicador de acordo com ano/mes da parcela
                        $nrMultiplicador = $listNrMultiplicador[$dtParcela[0].$dtParcela[1]];

                        // Calculando o valor do residuo com o indice e o numero multiplicador
                        $contrato['vlResiduo'] += (($parcResiduo['vl_parcela']*$indiceResiduo['valor'])/100)*$nrMultiplicador;
                    }

                    $contrato['vlResiduoIndividual'] = ($contrato['vlResiduo'] / $qtdeTotalParcNaoPagas);
                    $contrato['qtdeTotalParcNaoPagas'] = $qtdeTotalParcNaoPagas;

                }

                $contrato['ultimoReajuste'] = Helper::getDate($dataHistReajusteMesAno);
            }
            if ($reajusteForaData) {
                $listaIndices = [
                    [
                        "descricao" => 'Reajuste fora do perodo de programao',
                        "valor" => 0
                    ]
                ];
            }

            if ($mesInicial == $mesDoContrato && $reajusteForaData)
            {
                $msgErro = 'Impossvel realizar o reajuste, pois o ms selecionado  o mesmo do contrato.</br>';
            }

            if (!$listaContratos) {
                $msgErro .= 'No existem parcelas a reajustar nesse perodo.';
            } else {
                if (count($listaIndices) < $this->periodos[$indicePeriodo] && !$reajusteForaData) {
                    $msgErro .= 'No existe ndices suficientes cadastrados para este periodo';
                } else {
                    $infoIndice = array();
                    foreach ($listaIndices as $indice) {
                        $infoIndice['nome'] = $indice['descricao']; //Conta o total de indices por tipo
                        $infoIndice['id'] = $indiceEmpreendimento['id_indice_empreendimento']; //Salva o id do indice
                        $infoIndice['total']++; //Conta o total de indices
                        //soma os valores dos ultimos indices de acordo com a qtde de meses do periodo do empreendimento
                        if ($infoIndice['total'] <= $this->periodos[$indicePeriodo]) {
                            $infoIndice['percReajuste'] += $indice['valor'];
                        }
                        //Se a quantidade de indices for maior que a quantidade de meses do periodo, exibe aviso
                        if ($infoIndice['total'] > $this->periodos[$indicePeriodo]) {
                            $infoIndice['warningIndices'] = 'Os ndices cadastrados ('.$infoIndice['total'].') para <b>'.$indice['descricao'].'</b> excederam o total, foram considerados apenas os '.$this->periodos[$indicePeriodo].' ltimos para o clculo.';
                        }
                    }
                    
                    // Jamais poder os meses adicionais serem maiores que os meses do ndice (se existir porcentagem adicional)
                    if ($indiceEmpreendimento['fl_periodo_adc'] && $indiceEmpreendimento['id_indice']) {
                        if ($this->periodos[$indicePeriodo] >= $this->periodos[$indiceEmpreendimento['fl_periodo_adc']]) {
                            if ($this->periodos[$indicePeriodo] == $this->periodos[$indiceEmpreendimento['fl_periodo_adc']]) {
                                $infoIndice['percReajuste'] += $indiceEmpreendimento['indice_adicional'];
                            } else if ($indicePeriodo == 'A' && $indiceEmpreendimento['fl_periodo_adc'] == 'S') {
                                $infoIndice['percReajuste'] += $indiceEmpreendimento['indice_adicional'];
                            } else {
                                $infoIndice['indiceAdc'] = $indiceEmpreendimento['indice_adicional'];
                            }
                        }
                    }
                    if ($infoIndice['indiceAdc']) {
                        $infoIndice['percReajuste'] += $infoIndice['indiceAdc'];
                    }

                    $infoIndice['fl_periodo_adc'] = $indiceEmpreendimento['fl_periodo_adc'];
                    $infoIndice['id_indice'] = $indiceEmpreendimento['id_indice'];
                    $infoIndice['flPeriodo'] = $indicePeriodo;
                    $infoIndice['fl_residuo'] = $indiceEmpreendimento['fl_residuo'];
                    $infoIndice['indice_adicional'] =  $indiceEmpreendimento['indice_adicional'];
                    $_SESSION['dadosReajuste']['listaContratos'] = $listaContratos;
                    $_SESSION['dadosReajuste']['infoIndice'] = $infoIndice;
                    $_SESSION['dadosReajuste']['empreendimento'] = $empreendimento;
                    $_SESSION['dadosReajuste']['reajusteForaData'] = $reajusteForaData;
                    $_SESSION['dadosReajuste']['post'] = $_POST;
                    $_SESSION['dadosReajuste']['post']['warningParcelasPagas'] = $warningParcelasPagas;
                    $this->redir(array("modulo" => "fin", "controller" => "reajuste", "action" => "reajuste2"));
                }
            }
            
            $this->_helper->addMensagem('erro', $msgErro);
        }
        $this->display("reajuste");
    }

    public function reajuste2Action()
    {        
        set_time_limit(0);
        $dadosReajuste = $_SESSION['dadosReajuste'];

        //Seja $this->periodos[$indicePeriodo] != $this->periodos[$indiceEmpreendimento['fl_periodo_adc']
        $indiceAdc = ($dadosReajuste['infoIndice']['indiceAdc'])?$dadosReajuste['infoIndice']['indiceAdc']:0;
        // ndice sem adicional para adicional separado caso existir
        $vlIndiceSemAdc = floatval(Helper::getInputMoney($_POST['vlIndice'])) - floatval($indiceAdc);
        $tipoDeParcela = Helper::verificaParcelas($dadosReajuste['post']['tipoParcela']);

        $this->set('infoIndice', $dadosReajuste['infoIndice']);
        $this->set('post', $dadosReajuste['post']);
        $this->set('parcelasDados', $tipoDeParcela);
        $this->set("listaContratos", $dadosReajuste['listaContratos']);
        $this->set('dadosReajuste', $dadosReajuste);
        $this->set("meses", $this->meses);
        $this->set("params", $_POST);

        if ($this->_isPost && $this->validar2()) {
            $data = $_POST['ano_reajuste'] . "-" . $_POST['mes_reajuste'] . "-01";

            foreach ($_POST['contratos'] as $contrato) {
                //seleciona as parcelas a serem reajustadas
                $tbParcela = new Parcela();
                $parcelas = $tbParcela->select()->from(TB_PARCELA, array('id_parcela_contrato', 'id_parcela', 'dt_parcela', 'pago', 'tp_parcela', 'vl_parcela'))
                    ->where("dt_parcela >= '$data'")
                    ->where("id_contrato = $contrato")
                    ->where("fl_reajustavel = '1'")
                    ->where("pago = '0'");

                if($tipoDeParcela[0] == 'T'){
                    $parcelasRefazer = $parcelas->where('tp_parcela in ("N","I","C","S")')->query()->fetchAll();
                    $parcelas = $parcelas->where('tp_parcela in ("N","I","C")')->query()->fetchAll();
                } else if($tipoDeParcela[0] == 'N'){
                    $parcelasRefazer = $parcelas->where('tp_parcela in ("N","I","C","S")')->query()->fetchAll();
                    $parcelas = $parcelas->where('tp_parcela in ("N")')->query()->fetchAll();
                } else if($tipoDeParcela[0] == 'I'){
                    $parcelasRefazer = $parcelas->where('tp_parcela in ("N","I","C","S")')->query()->fetchAll();
                    $parcelas = $parcelas->where('tp_parcela in ("I")')->query()->fetchAll();
                } else if($tipoDeParcela[0] == 'C'){
                    $parcelasRefazer = $parcelas->where('tp_parcela in ("N","I","C","S")')->query()->fetchAll();
                    $parcelas = $parcelas->where('tp_parcela in ("C")')->query()->fetchAll();
                }
                
                //Salva a primeira parcela normal como parcelaInicial que vai ser gravada no reajuste
                $parcelaInicial = null;
                foreach ($parcelas as $parcela) {
                    if ($parcela['tp_parcela'] == 'N' && (!isset($parcelaInicial) || $parcelaInicial == null)) {
                        $parcelaInicial = $parcela;
                    }

                }
                //Se nao existe nenhuma parcela do tipo N no array, pega a do tipo que tiver
                if (!isset($parcelaInicial) || $parcelaInicial == null) {
                    $parcelaInicial = $parcelas[0];
                }

                try {
                    $vlResiduo = $this->_helper->filters($_POST['vlResiduo_'.$contrato], 'money');
                    $vlResiduo /= count($parcelas);
                    //Inserindo o Reajuste
                    $tbHistoricoReajuste = new HistoricoReajuste();
                    $transacao = $tbHistoricoReajuste->getAdapter()->beginTransaction();
                    $reajuste = $tbHistoricoReajuste->createRow();
                    $reajuste->idContrato = $contrato;
                    $reajuste->id_indice = $_POST['idIndice'];
                    $reajuste->indice = Helper::getInputMoney($_POST['vlIndice']);
                    $reajuste->indice_pos_entrega = $this->_helper->filters($_POST['vlIndicePosEntrega'], 'money');
                    $reajuste->indice_adicional = $dadosReajuste['infoIndice']['indice_adicional'];
                    $reajuste->idParcelaInicio = $parcelaInicial['id_parcela'];
                    $reajuste->data = $data;
                    $reajuste->vl_residuo = $vlResiduo;
                    $reajuste->usuario = Login::getUsuario()->getLogin();
                    $reajuste->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - i');
                    $reajuste->fl_periodo = $dadosReajuste['infoIndice']['flPeriodo'];
                    $reajuste->tp_parcela = $tipoDeParcela[0];
                    $reajuste->fl_periodo_adc = $dadosReajuste['infoIndice']['fl_periodo_adc'];

                    foreach ($parcelasRefazer as $parcelaR) {
                        switch ($parcelaR['tp_parcela']) {
                            case 'N':
                                $reajuste->vl_mensal = $parcelaR['vl_parcela'];
                                break;
                            case 'I':
                                $reajuste->vl_intercalada = $parcelaR['vl_parcela'];
                                break;
                            case 'C':
                                $reajuste->vl_chave = $parcelaR['vl_parcela'];
                                break;
                            case 'S':
                                $reajuste->vl_sinal = $parcelaR['vl_parcela'];
                                break;
                        }
                    }                                  
                    
                    $reajuste->save();

                    //Aplicando a porcentagem de reajuste nas parcelas e salvando
                    $idParcelas = '';
                    foreach ($parcelas as $parcela) {
                        //so atualiza as nao pagas
                        $parc = $tbParcela->fetchRow('id_parcela_contrato = '.$parcela['id_parcela_contrato']);
                        $percReajuste = str_replace(',','.',$vlIndiceSemAdc);
                        $parc->vl_parcela += (($percReajuste * $parc->vl_parcela) / 100) + $vlResiduo;
                        $parc->dt_reajuste = $data;
                        $parc->vl_indice = $percReajuste;
                        $parc->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - u');
                        $parc->save();
                        //Concatenando o codigo e tipo das parcelas para salvar em Relacionamento
                        if ($idParcelas != '') {
                            $idParcelas .= ', ';
                        }
                        $idParcelas .= $parcela['id_parcela'] . $parcela['tp_parcela'];
                    }
        
                    //Verifica se o tipo de reajuste  Anual+Mensal e faz aplicao do indice mensal percorrendo
                    //as 12 proximas parcelas, aplicando o valor de reajuste e removendo ela da lista para que
                    //no proximo loop a mesma no seja modificada novamente
                    if ($indiceAdc != 0) {
                        $auxparcelas = $parcelas;
                        foreach ($parcelas as $k => $parc) {
                            if ($k <= ($this->periodos[$dadosReajuste['infoIndice']['flPeriodo']] - 1)) {
                                $this->porcAdicional($auxparcelas, $contrato, $dadosReajuste['infoIndice']['indiceAdc']);
                            }
                            unset($auxparcelas[$k]);
                        }
                    }

                    $transacao->commit();
                    //Antes de redirecionar grava o resultado no log dos contatos realizados como Quitao.
                    $tpReajuste = ($dadosReajuste['post']['tpReajuste'] == 'A')?'Automtico':'Manual';
                    $indiceLog = $dadosReajuste['infoIndice']['nome'] . ($dadosReajuste['infoIndice']['flPeriodo']?" - {$dadosReajuste['infoIndice']['flPeriodo']}":'');
                    $indiceAdcPerc = str_replace('.',',',number_format($dadosReajuste['infoIndice']['indice_adicional'], 2)).'%';
                    $indiceAdcLog = $dadosReajuste['infoIndice']['indice_adicional'] != '0'?" + {$indiceAdcPerc} - {$dadosReajuste['infoIndice']['fl_periodo_adc']}":'';
                    $percReajLog = $_POST['vlIndice'] . '%';
                    (new Relacionamento())->saveContato(48, date('Y-m-d'), $contrato, 'Log: Reajuste '.$tpReajuste.' do contrato ' . $dadosReajuste['post']['mes_inicial'] . '/' . $dadosReajuste['post']['ano_inicial'] . ', Tipo '. $indiceLog . $indiceAdcLog . ' com Total '.$percReajLog. ' Parcelas: ' . $idParcelas);
                    $this->redir(array("modulo" => "fin", "controller" => "reajuste", "action" => "listar"),array("msg" => "success"));
                } catch(Exception $e) {
                    $transacao->rollBack();
                    $this->_helper->addMensagem('danger', 'Ocorreu um erro. Entre em contato com Suporte.'.$e->getMessage());
                }
            }
        }
        $this->display("reajuste2");
    }

    public function relatorioAction($validar = false)
    {
        $tbClienteAcade = new Db_Cliente();
        $this->set('clienteAcade', $tbClienteAcade->fetchRow()->toArray());
        $this->set('informacoes', $_POST['informacoes']);

        if ($this->_isPost) {

            $empreendimento = new Empreendimento();
            $empreendimentoInfo = $empreendimento->getAdapter()->select()->from(array('em' => TB_EMPREENDIMENTO), array('id_tipo_loteamento'))
                ->join(array('t' => TB_TIPO_LOTEAMENTO), 'em.id_tipo_loteamento = t.id_tipo_loteamento', array('*'))
                ->where('em.id = ?', $_POST['idEmpreendimento'])
                ->query()->fetch();
            $this->set("empreendimentoInfo", $empreendimentoInfo);

            if ($_POST['tp_relatorio'] == 'R') {
                $tbHistoricoReajuste = new HistoricoReajuste();
                $tbParcela = new Parcela();
                $listaContrato = $tbHistoricoReajuste->getDefaultAdapter()->select()
                    ->from(array('hr' => TB_HISTORICO_REAJUSTE), array('id_primeira_parcela'=>'idParcelaInicio','valorIndice'=>'indice','idReajuste'=>'id','vl_residuo'))
                    ->join(array('c' => TB_CONTRATO), 'c.id = hr.idContrato', array('contrato'=>'id','id_pessoa'))
                    ->join(array('ie' => TB_INDICE_EMPREENDIMENTO), 'ie.id_indice_empreendimento = c.id_indice', array('id_indice', 'fl_periodo', 'indice_adicional', 'fl_periodo_adc'))
                    ->join(array('l' => TB_LOTES), 'l.id = c.id_lote', array('lote', 'quadra'))
                    ->join(array('e' => TB_EMPREENDIMENTO), 'e.id = l.id_empreendimento', array('empreendimento_nome' => 'e.nm_empreendimento'))
                    ->join(array('pe' => TB_PESSOA), 'c.id_pessoa = pe.id', array('*'))
                    ->join(array('cd' => TB_CIDADE), 'pe.cd_cidade = cd.id', array('*'))
                    ->where('MONTH(hr.data) = "' . $_POST['mes_reajuste'].'" AND YEAR(hr.data) = "'.$_POST['ano_inicial'].'"');
                    if ($_POST['idIndice'] != '0')
                        $listaContrato = $listaContrato->where('ie.id_indice_empreendimento = "' .$_POST['idIndice'] .'"');
                    $listaContrato = $listaContrato->where('e.id = '.$_POST['idEmpreendimento'])
                    ->order('nm_pessoa')
                    ->query()->fetchAll();
                
                foreach ($listaContrato as &$lista) {
                    $tbAgrupada = AgrupadaGeral::buscar('12', $lista['id_indice']);
                    $lista['indice'] = $tbAgrupada['descricao'];
                }

                if (!$listaContrato) {
                    $this->_helper->addMensagem('danger', 'Nenhum dado foi econtrado.');
                } else {
                    foreach($listaContrato as &$contrato) {
                        //Busca as parcelas para o relatrio completo
                        if($_POST['informacoes'] == 'C'){
                            $parcelas = $tbParcela->getDefaultAdapter()->select()
                                ->from(array('p' => TB_PARCELA), array('*'))
                                ->where('p.id_contrato = "'.$contrato['contrato'].'"')
                                ->where('p.tp_parcela NOT IN ("SE", "NE", "IE", "CE", "E")')
                                ->where("p.dt_parcela < '" . date('Y-m-d') . "'")
                                ->where("p.pago = '0'")
                                ->query()->fetchAll();

                            $contrato['qtd_parcelas'] = count($parcelas);
                        }
                        //Pesquisando por um reajuste anterior ao atual
                        $ultimoReajuste = $tbHistoricoReajuste->fetchRow('idContrato = '.$contrato['contrato'].' AND id = '.$contrato['idReajuste']);
                        $contrato['ultimoReajuste'] = '';
                        if ($ultimoReajuste) {
                            $contrato['ultimoReajuste'] = Helper::getDate($ultimoReajuste['data']);
                        }
                        //Pesquisando os dados da primeira parcela utilizada no reajuste
                        $primeiraParcela = $tbParcela->fetchRow('id_contrato = '.$contrato['contrato'].' AND id_parcela = '.$contrato['id_primeira_parcela'].' AND tp_parcela IN ("N","I","C")');
                        $contrato['dt_primeira_parcela'] = '';
                        $contrato['tp_primeira_parcela'] = '';
                        if ($primeiraParcela) {
                            $contrato['tp_primeira_parcela'] = $primeiraParcela['tp_parcela'];
                            $contrato['dt_primeira_parcela'] = Helper::getDate($primeiraParcela['dt_parcela']);
                        }
                        $contrato['indice'] = $contrato['indice'].' '.helper::getNomePeriodo($contrato['fl_periodo']);
                    }
                    $this->set('reajustes', $listaContrato);
                }
            } else {
                $tbParcela = new Parcela();
                $tb_empr = new Empreendimento();
                $tbIndiceEmpreendimento = new IndiceEmpreendimento();
                $adapter = $tbParcela->getAdapter();
                $emp = $tb_empr->fetchRow("id = {$_POST['idEmpreendimento']}");
                $listaIndices = $tbIndiceEmpreendimento->fetchAll('id_empreendimento = ' . $emp['id'])->toArray();
                $areajustar = array();
                foreach ($listaIndices as $indice) {
                //Testa o intervalo cadastrado
                    switch ($indice['fl_periodo']) {
                        case 'M':
                            $intervalo = '1 MONTH';
                            break;
                        case 'B':
                            $intervalo = '2 MONTH';
                            break;
                        case 'T':
                            $intervalo = '3 MONTH';
                            break;
                        case 'S':
                            $intervalo = '6 MONTH';
                            break;
                        default:
                            $intervalo = '1 YEAR';
                            break;
                    }
                    //busca os contratos a serem ajustados no mes e ano especificados
                    $data = $_POST['ano_inicial'] . "-" . $_POST['mes_reajuste'] . "-31";
                    $data2 = $_POST['ano_inicial'] . "-" . $_POST['mes_reajuste'] . "-01";

                    $contratos = $adapter->select()->distinct('e.id')
                        ->from(array('e' => TB_EMPREENDIMENTO), array('empreendimento_nome' => 'e.nm_empreendimento', 'empreendimento_id' => 'e.id'))
                        ->join(array('l' => TB_LOTES), 'e.id = l.id_empreendimento', array('lote', 'quadra'))
                        ->join(array('c' => TB_CONTRATO), 'l.id = c.id_lote', array('contrato' => 'id', 'dt_reajuste'))
                        ->join(array('p' => TB_PARCELA), 'c.id = p.id_contrato', array())
                        ->join(array('pe' => TB_PESSOA), 'c.id_pessoa = pe.id', array('nm_pessoa'))
                        ->where('c.id_indice = '.$indice['id_indice_empreendimento'])
                        ->where("c.dt_reajuste + INTERVAL " . $intervalo . " <= '$data'")
                        ->where("id_empreendimento = {$_POST['idEmpreendimento']}")
                        ->where('tp_parcela NOT IN ("E","NE","SE","CE","IE","Q","G")')
                        ->where("fl_distrato = '0'")
                        ->order('nm_pessoa')
                        ->query()->fetchAll();

                    foreach ($contratos as &$lista) {
                        $tbAgrupada = AgrupadaGeral::buscar('12', $indice['id_indice']);
                        $lista['indice'] = $tbAgrupada['descricao'];
                    }

                    //checa se existe reajuste desse contrato
                    $tb_historicoReajuste = new HistoricoReajuste();
                    if (count($contratos)) {
                        $tbParcela = new Parcela();
                        foreach ($contratos as $k => $contrato) {
                            //se o contrato nao tiver parcelas em aberto (encerrado) ele nao sera listado para reajuste
                            $row = $tbParcela->fetchAll('id_contrato = ' . $contrato['contrato'] . ' and dt_parcela >= "' . date('Y-m-d') . '"')->toArray();
                            if (count($row) == 0) {
                                unset($contratos[$k]);
                                continue;
                            }
                            $hist = $tb_historicoReajuste->fetchRow("idContrato = {$contrato['contrato']}", "data desc");
                            if ($hist) {
                                $hist = $hist->toArray();
                                $dataHistReajuste = explode('-', $hist['data']);
                                $dataHistReajusteMesAno = $dataHistReajuste[0] . '-' . $dataHistReajuste[1] . '-01';
                                //Verifica se o intervalo de meses entre a data do ultimo reajuste e data do reajuste atual
                                // diferente do intervalo de meses selecionada no empreendimento
                                if($indice['fl_periodo']){
                                    if ($this->dataDiff($dataHistReajusteMesAno, $data2, 'm') != $this->periodos[$indice['fl_periodo']])
                                    continue;
                                }else{
                                    if ($this->dataDiff($dataHistReajusteMesAno, $data2, 'm') != $this->periodos[$indice['fl_periodo_adc']])
                                    continue;
                                }
                                
                                
                            } else {
                                $datatReajContrato = explode('-', $contrato['dt_reajuste']);
                                $datatReajContratoMesAno = $datatReajContrato[0] . '-' . $datatReajContrato[1] . '-01';
                                //Verifica se o inervalo de meses entre a data de reajuste do contrato e data do reajuste atual
                                // diferente do intervalo de meses selecionado no empreendimento
                                if($indice['fl_periodo']){
                                    if ($this->dataDiff($datatReajContratoMesAno, $data2, 'm') != $this->periodos[$indice['fl_periodo']])
                                    continue;
                                }else{
                                    if ($this->dataDiff($datatReajContratoMesAno, $data2, 'm') != $this->periodos[$indice['fl_periodo_adc']])
                                    continue;
                                }
                               
                            }
                            //seleciona as parcelas a serem reajustadas
                            $parcelas = $tbParcela->findParcelaReajustavel($data2, $contrato['contrato']);
                            //Retira contratos que nao possuam parcelas para reajustar
                            $contrato['ultimoReajuste'] = '-'; 
                            if (count($parcelas) == 0)
                                continue;
                            else {
                                $contrato['indice'] = $contrato['indice'].' - '.Helper::getNomePeriodo($indice['fl_periodo']);
                                $contrato['indice_adicional'] = $indice['indice_adicional'];
                                $contrato['fl_periodo_adc'] = $indice['fl_periodo_adc'];
                                $contrato['id_primeira_parcela'] = $parcelas[0]['id_parcela'];
                                $contrato['tp_primeira_parcela'] = $parcelas[0]['tp_parcela'];
                                $contrato['dt_primeira_parcela'] = Helper::getDate($parcelas[0]['dt_parcela']);
                                if($datatReajContratoMesAno){
                                    $contrato['ultimoReajuste'] = Helper::getDate($datatReajContratoMesAno);
                                }else{
                                    $contrato['ultimoReajuste'] = Helper::getDate($dataHistReajusteMesAno);
                                }
                                $areajustar[] = $contrato;
                            }
                            
                        }
                    }
                }
                if (count($areajustar) == 0) {
                    $this->_helper->addMensagem('danger', 'Nenhum dado foi encontrado.');
                } else {
                    function cmp($a, $b) {
                        return $a['nm_pessoa'] > $b['nm_pessoa'];
                    }
                    usort($areajustar, 'cmp');
                    $this->set('areajustar', $areajustar);
                }
            }
        } else {
            $adapter = Empreendimento::getDefaultAdapter();
            $empreendimentos = $adapter->select()->distinct('e.id')
                ->from(array('e' => TB_EMPREENDIMENTO), array('empreendimento_nome' => 'e.nm_empreendimento', 'empreendimento_id' => 'e.id'))
                ->join(array('l' => TB_LOTES), 'e.id = l.id_empreendimento', array())
                ->join(array('c' => TB_CONTRATO), 'l.id = c.id_lote', array())
                ->join(array('p' => TB_PARCELA), 'c.id = p.id_contrato', array());
            //verifica se o usuario tem o perfil de usuario de empreendimento
            if ($_SESSION['usuario']) {
                try {
                    $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                    $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                    if (count($ids)) {
                        $id = implode(',', $ids);
                        $empreendimentos->where("e.id IN({$id})");
                    } else {
                        $empreendimentos->where("1");
                    }
                } catch (Exception $e) {

                }
            }
            $empreendimentos = $empreendimentos->order('empreendimento_nome')
                ->query()->fetchAll();
            $this->set('empreendimentos', $empreendimentos);
            $this->set("meses", $this->meses);
            if (!$validar) {
                $this->display('reajusteRel');
                exit;
            }
        }
        if (!$validar) {
            set_time_limit(0);
            $this->displayMPdf('rel_reajuste.pdf');
        }
    }

    public function validar($varios = null)
    {
        $erro = false;
        $campos = array(
            'idEmpreendimento' => 'Selecione o empreendimento!',
            'mes_inicial' => 'Selecione ms inicial',
            'ano_inicial' => 'O campo Ano  obrigatrio',
        );
        if ($_POST['tpReajuste'] == 'M') {
            $campos['idContrato'] = 'Selecione o contrato';
        }
        foreach ($campos as $campo => $msg) {
            if ($_POST[$campo] == '') {
                $this->_helper->addMensagem($campo, $msg);
                $erro = true;
            }
        }
        return !($erro);
    }

    public function validar2()
    {
        $this->_helper->removerMensagens();
        $campos = array(
            'mes_reajuste' => 'Selecione ms inicial',
            'ano_reajuste' => 'O campo ano inicial  obrigatrio',
        );

        foreach ($campos as $campo => $msg) {
            if ($_POST[$campo] == '') {
                $this->_helper->addMensagem('data', 'Informe uma data correta');
            }
        }
        return !(count($this->_helper->getMensagens()) > 0);
    }

    public function validar3Action()
    {
        $campos = array(
            'idEmpreendimento' => 'Selecione o Empreendimento',
            'mes_reajuste' => 'Selecione Ms do Reajuste',
            'ano_inicial' => 'O campo ano  obrigatrio',
        );
        foreach ($campos as $campo => $msg) {
            if ($_POST[$campo] == '') {
                $this->_helper->addMensagem($campo, $msg);
            }
        }
        $this->relatorioAction(true);
        //Mensagem de Erros
        if (count($this->_helper->getMensagens()) > 0) {
            $msgErros = '';
            foreach ($this->_helper->getMensagens() as $msg => $a)
                $msgErros .= utf8_encode($a) . '<br>';
            echo json_encode(array('msgErros' => $msgErros));
        } else {
            echo json_encode(true);
        }
    }

    private function dataDiff($data1, $data2, $intervalo)
    {
        switch ($intervalo) {
            case 'm' :
                $q = 2592000;
                break; //mes
            case 'd' :
                $q = 86400;
                break;   //dia
            case 'h' :
                $q = 3600;
                break;    //hora
            case 'n' :
                $q = 60;
                break;      //minuto
            default :
                $q = 1;
                break;       //segundo
        }
        //Transforma as datas em segundos e divide em $q (segundos)
        return round((strtotime($data2) - strtotime($data1)) / $q);
    }

    private function porcAdicional($parcelas = null, $idContrato = null, $percReajuste)
    {
        $vl_parcela_intercalada = 0;
        $pass = true;
        //atualiza as parcelas com base no indice passado
        $tbParcela = new Parcela();
        if ($parcelas && $idContrato) {
            foreach ($parcelas as $parcela) {
                //so atualiza as nao pagas
                $row = $tbParcela->fetchRow("id_parcela_contrato = '{$parcela['id_parcela_contrato']}'");
                if ($row['tp_parcela'] == 'I') {
                    $mesIntercalada = substr($row['dt_parcela'], -5, 2);
                    switch (true) {
                        case ($_POST['mes_reajuste'] == $mesIntercalada):
                            $mesesCount = 12;
                        break;
                        case ($_POST['mes_reajuste'] > $mesIntercalada):
                            $mesesCount = ($_POST['mes_reajuste'] - $mesIntercalada) + 1;
                        break;
                        case ($_POST['mes_reajuste'] < $mesIntercalada):
                            $mesesCount = ($mesIntercalada - $_POST['mes_reajuste']) + 1;
                        break;
                    }
                    if ($pass) {
                        for ($i=0; $i < $mesesCount; $i++) { 
                            $row->vl_parcela += ($percReajuste * $row->vl_parcela) / 100;
                        }
                        $pass = false;
                    }
                } else {
                    $percReajuste = (Helper::formatoReal($percReajuste)) ? number_format(Helper::getInputMoney($percReajuste), 4) : number_format($percReajuste, 4);
                    $row->vl_parcela += ($percReajuste * $row->vl_parcela) / 100;                    
                }
                $row->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - u');
                $row->save();
            }
        }
    }

    public function contratoReajusteParcelasAction()
    {
        $contratos = Contrato::byEmpreendimento($_POST['id_empreendimento'], Contrato::CONTRATO_TODOS, 0, array("nm_pessoa", "lote", "quadra", "id"));
        $listaContrato = array();
        if (count($contratos) > 0) {
            foreach ($contratos as $contrato) {
                $listaContrato[] = array('id' => $contrato['id'], 'text' => utf8_encode( $contrato['nm_pessoa'] . ' - Quadra: ' . $contrato['quadra'] . ' - Lote: ' . $contrato['lote'] . ' - Contrato: ' . $contrato['id']));
            }
            echo json_encode($listaContrato);
        }
    }

    public function getIndiceEmpreendimentoAction()
    {
        $tbIndiceEmprendimento = new IndiceEmpreendimento();
        foreach ($tbIndiceEmprendimento->getIndiceEmpreendimento($_POST['idEmpreendimento']) as $indiceEmpreendimento) {
            $caracterSoma = Helper::getNomePeriodo($indiceEmpreendimento['fl_periodo']) != ''?' +':'';
            $indiceAdicional = ($indiceEmpreendimento['indice_adicional'] != '0')?$caracterSoma.str_replace('.',',',number_format($indiceEmpreendimento['indice_adicional'], 2)).'%':'';
            $residuo = ($indiceEmpreendimento['fl_residuo'] == '1')? ' - Com Resduo' : ' - Sem Resduo';
            $lista[] = array('id' => $indiceEmpreendimento['id_indice_empreendimento'],
                'text' => utf8_encode($indiceEmpreendimento['descricao'] . ' ' . Helper::getNomePeriodo($indiceEmpreendimento['fl_periodo']) . ' ' . $indiceAdicional . ' ' . Helper::getNomePeriodo($indiceEmpreendimento['fl_periodo_adc']) . $residuo)
            );
        }
        echo json_encode($lista);
    }
    
    public function delReajusteAction()
    {
        if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'delReajuste')) {
            echo json_encode('acessoNegado');
            exit;
        }
        
        if ($this->isAjax()) {
            $reajuste = new HistoricoReajuste();
            $dadosReajuste = $reajuste->getHistorico($_POST['id']);

            if($dadosReajuste['tp_parcela'] == 'T'){
                $parcelasReajustar = ' AND tp_parcela in ("N", "I", "C", "S")';
            }else{
                $parcelasReajustar = " AND tp_parcela = " . $dadosReajuste['tp_parcela'];
            }
            $parcelas = new Parcela();
            $dadosParcelas = $parcelas->fetchAll("id_contrato = " . $dadosReajuste['idContrato'] . " AND dt_parcela >= '". $dadosReajuste['data'] . $parcelasReajustar . "' AND pago = '0' AND id_remessa IS NULL")->toArray();
            $conferePagoOuRemessa = $parcelas->fetchAll("id_contrato = " . $dadosReajuste['idContrato'] . " AND dt_parcela >= '". $dadosReajuste['data'] . $parcelasReajustar . "' AND (pago = '1' OR id_remessa IS NOT NULL)")->toArray();
            try {
                foreach ($dadosParcelas as $parcela) {
                    $parcUpdate = $parcelas->fetchRow("id_parcela_contrato = ".$parcela['id_parcela_contrato']);
                    $valorOriginal = $parcUpdate->vl_parcela;
                    switch ($parcela['tp_parcela']) {
                        case 'N':
                            if ($dadosReajuste['vl_mensal'] != "")
                                $valorReajuste = $dadosReajuste['indice'];
                                $valReajuste = 1 + number_format($valorReajuste / 100, 4, '.', '');
                                $diferenca = $valorOriginal / $valReajuste;
                                $parcUpdate->vl_parcela = $diferenca;
                            break;
                        case 'I':
                            if ($dadosReajuste['vl_intercalada'] != "")
                                $valorReajuste = $dadosReajuste['indice'];
                                $valReajuste = 1 + number_format($valorReajuste / 100, 4, '.', '');
                                $diferenca = $valorOriginal / $valReajuste;
                                $parcUpdate->vl_parcela = $diferenca;
                            break;
                        case 'S':
                            if ($dadosReajuste['vl_sinal'] != "")
                                $valorReajuste =$dadosReajuste['indice'];
                                $valReajuste = 1 + number_format($valorReajuste / 100, 4, '.', '');
                                $diferenca = $valorOriginal / $valReajuste;
                                $parcUpdate->vl_parcela = $diferenca;
                            break;
                        case 'C':
                            if ($dadosReajuste['vl_chave'] != "")
                                $valorReajuste = $dadosReajuste['indice'];
                                $valReajuste = 1 + number_format($valorReajuste / 100, 4, '.', '');
                                $diferenca = $valorOriginal / $valReajuste;
                                $parcUpdate->vl_parcela = $diferenca;
                            break;
                    }
                    $parcUpdate->save();
                }      
            } catch (Exception $e) {
                echo json_encode($e);
                exit;
            }

            if ($reajuste->getAdapter()->delete(TB_HISTORICO_REAJUSTE, "id = " . $_POST['id'])) {
                $indiceLog = $dadosReajuste['descricao']?"{$dadosReajuste['descricao']} - {$dadosReajuste['fl_periodo']}":'';
                $indiceAdc = $dadosReajuste['indice_adicional'] != '0'?"+ {$dadosReajuste['indice_adicional']} - {$dadosReajuste['fl_periodo_adc']}":'';
                $log = (new Relacionamento())->saveContato(48, date('Y-m-d'), $dadosReajuste['idContrato'], 'Log: Reajuste desfeito da data: '.Helper::getDate($dadosReajuste['data']).', com ndice: ' . $indiceLog . ' ' .$indiceAdc . ' Com Total: '. $dadosReajuste['indice'] . '% com incio na parcela: ' . $dadosReajuste['idParcelaInicio'] . '.');
                if($log && $conferePagoOuRemessa){
                    echo json_encode('pagoRemessa');
                } else if ($log) {
                    echo json_encode(true);
                }
                else{
                    echo json_encode(false);
                }
            } else {
                echo json_encode(false);
            }
        }
    }

    public function reajusteForaDoPrazoAction() {
        if ($this->isAjax()) {
            echo json_encode("permissionFound");
        }
    }
}
