<?php

class QuitacaoController extends Controller
{
    protected $distrato;
    protected $tb_lote;
    protected $tb_empreendimento;
    protected $tb_cliente;
    protected $pessoasEnvolvidas;
    protected $tb_pessoa;

    public function __construct($request)
    {
        parent::__construct($request);
        $this->tb_pessoa = new Pessoa();
        $this->pessoasEnvolvidas = new ContratoPessoa();
        $this->tb_pessoaFisica = new Pessoa_Fisica();
        $this->tb_pessoaJuridica = new Pessoa_Juridica();
        $this->tb_contratoHistorico = new ContratoHistorico();
        $this->tb_lote = new Lote();
        $this->tb_empreendimento = new Empreendimento();
        $this->tb_parcela = new Parcela();
        $this->tb_parcelahistorico = new ParcelaHistorico();
        $this->tb_parceria = new Parceria();
        $this->tb_contrato = new Contrato();
        $this->tb_cliente = new Db_Cliente();        
    }

    /**
     * Funcao que realiza redicionamento para listar
     */
    public function indexAction()
    {
        $this->redir(array("modulo" => "fin", "controller" => "quitacao", "action" => "listar"));
    }
    /**
     * Funcao que faz a listagem dos contratos
     */
    public function listarAction()
    {        
        $this->display('listar');
    }

    /**
     * Funcao que faz a listagem dos contratos
     */
    public function gerarListaAction()
    {

        $lista = array();
        $listaItem = Contrato::findParcelaQuitacao($_POST);
        
        foreach ($listaItem as $item) {            
            if ($item['id_renegociacao']) {
                $negociacao = Negociacao::getDefaultAdapter()->select()
                    ->from(array('n' => TB_NEGOCIACAO), array('*'))
                    ->where('n.id = ?', $item['id_renegociacao'])
                    ->query()->fetch();                    
            } else {
                $negociacao = null;
            }
            $title = "return confirm('Tem certeza que deseja defazer o contrato " . $item['id'] . " em nome de " . $item['nm_pessoa'] . " do Lote " . $item['lote'] . "?')";
             
            $acoes = '<div></div><div>';
            $acoes .= '<a  target="_blank" href="?m=' . $this->modulo . '&c=' . $this->controller . '&a=gerar&id=' . $item['id'] . '" data-toggle="tooltip" title="IMPRIMIR ANALTICO" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-file-text"></i></a>';
            $acoes .= '<a  target="_blank" href="?m=' . $this->modulo . '&c=' . $this->controller . '&a=gerarSintetico&id=' . $item['id'] . '" data-toggle="tooltip" title="IMPRIMIR SINTTICO" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-file-text"></i></a>';
            $acoes .= '<a onclick="' . $title . '"  href="?m=fin&c=quitacao&a=desfazer&id=' . $item['id']. '&r=' . $item['id_renegociacao'] . '" data-toggle="tooltip" title="CANCELAR" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-times"></i></a>';
            $acoes .= '</div>';
            $acoes .= '</div>';

            //Para ordenar por data
            $data = $negociacao?$negociacao['data']:$item['dt_parcela'];
            $dataBase = $negociacao?$negociacao['dataBase']:'';

            $data = '<div hidden>' . $data . '</div>' . Helper::getDate($data);
            $dataBase = '<div hidden>' . $dataBase . '</div>' . Helper::getDate($negociacao['dataBase']);
            

            $lista[] = array(
                'id' => ($negociacao) ? $negociacao['id'] : '',
                'empreendimento' => '<div ' .  ' >' . utf8_encode($item['nm_empreendimento']) . '</div>',
                'contrato' => '<div ' . ' >' . $item['id'] . '</div>',
                'pessoa' => '<div ' .  ' >' . utf8_encode($item['nm_pessoa']) . '</div>',
                'quadra' => '<div ' . ' >' . utf8_encode($item['quadra']) . '</div>',
                'lote' => '<div ' .  ' >' . utf8_encode($item['lote']) . '</div>',
                'data' => '<div>' . $data . '</div>',
                'dataBase' => '<div>' . $dataBase . '</div>',
                'acoes' => utf8_encode($acoes)
            );
        }
        
        echo json_encode(array(
            'draw' => $_POST['draw'],
            'data' => $lista
        ));
    }
    /**
     * Funcao que realiza a inserncao de um quitamento
     */
    public function adicionarAction()
    {
        $empreendimentos = $this->tb_empreendimento->getDefaultAdapter()->select()
            ->from(array('e' => TB_EMPREENDIMENTO), array('e.nm_empreendimento', 'e.id'));

        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $empreendimentos->where("e.id IN({$id})");
                } else {
                    $empreendimentos->where("1");
                }
            } catch (Exception $e) {

            }
        }

        $empreendimentos = $empreendimentos->order('nm_empreendimento')->query()->fetchAll();

        $this->set('empreendimentos', $empreendimentos);

        $this->display("form");
    }
    
    public function passo2Action() {
        
        $tbEmpreendimento = new Empreendimento();
        $tb_parcela = new Parcela();

        $pessoa = $tbEmpreendimento->getDefaultAdapter()->select()
            ->from(array('p' => TB_PESSOA), 'nm_pessoa')
            ->join(array('c' => TB_CONTRATO), 'p.id = c.id_pessoa', null)
            ->where("c.id = " . $_REQUEST['idContratoQuitacao'])
            ->query()->fetch();
        
        $infoContrato = $this->tb_contrato->getDefaultAdapter()->select()
            ->from(array('c' => TB_CONTRATO), array('c.id', 'c.id_lote', 'c.tx_juros'))
            ->join(array('l' => TB_LOTES), 'l.id = c.id_lote', array('lote', 'quadra'))
            ->where('c.id = ' . $_REQUEST['idContratoQuitacao'])
            ->query()->fetch();

        $contrato["nm_pessoa"] = $pessoa['nm_pessoa'];
        $contrato["quadra"] = $infoContrato['quadra'];
        $contrato["lote"] = $infoContrato['lote'];
        $contrato["tx_juros"] = $infoContrato['tx_juros'];
        $contrato["numero"] = $_POST['idEmpreendimentoQuitacao'];

        $parcelas = $tb_parcela->fetchAll("id_contrato = {$_REQUEST['idContratoQuitacao']} and pago = '0' and (tp_parcela NOT IN ('E', 'NE', 'SE', 'CE', 'IE', 'A'))", 'dt_parcela')->toArray();
        
        $this->set('contrato', $contrato);
        $this->set('parcelas', $parcelas);
        $this->set('tx_juros', $_POST['tx_juros']);

        $this->display("passo2");
    }

    public function passo3Action()
    {

        if (!$_POST['parcelas']){

            $_POST['parcelas'] = $_SESSION['contrato']['idsParcelas'];
            $_POST['dataBase'] = $_SESSION['contrato']['data'];
            $_POST['descontoBoleto'] = $_SESSION['desconto'];
        }

        $adapter = Empreendimento::getDefaultAdapter();
        $ids = '';
        foreach ($_POST['parcelas'] as $p) {
            $ids .= "'$p',";
        }
        $ids = substr($ids, 0, -1);

        //calculo dos juros
        $idParcela = $_POST['parcelas'][0];
        $dataBase = $_POST['dataBase'];

        $taxas = $adapter->select()
            ->from(array('b' => TB_BANCO), array('multa', 'juros', 'tp_juros', 'tp_multa'))
            ->join(array('e' => TB_EMPREENDIMENTO), 'e.id = b.id_empreendimento', null)
            ->join(array('l' => TB_LOTES), 'l.id_empreendimento = e.id', null)
            ->join(array('c' => TB_CONTRATO), 'c.id_lote = l.id', null)
            ->join(array('p' => TB_PARCELA), 'p.id_contrato = c.id', null)
            ->where("id_parcela_contrato = $idParcela")->query()->fetch();

        $parcelas = $adapter->select()
            ->from(array('p' => TB_PARCELA), array('*', 'dif' => '(DATEDIFF("' . Helper::getInputDate($dataBase) . '",dt_parcela))'))
            ->where("id_parcela_contrato in ($ids) ")
            ->order('dt_parcela ASC')
            ->query()->fetchAll();

        $pessoa = $adapter->select()
            ->from(array('p' => TB_PESSOA), 'nm_pessoa')
            ->join(array('c' => TB_CONTRATO), 'p.id = c.id_pessoa', null)
            ->join(array('l' => TB_LOTES), 'l.id = c.id_lote', array('lote', 'quadra'))
            ->where("c.id = " . $parcelas[0]['id_contrato'])
            ->query()->fetch();

        $contrato["nm_pessoa"] = $pessoa['nm_pessoa'];
        $contrato["quadra"] = $pessoa['quadra'];
        $contrato["lote"] = $pessoa['lote'];
        $contrato['numero'] = $parcelas[0]['id_contrato'];
        $contrato["total"] = 0;
        $vlmulta = 0;
        $vljuros = 0;
        $vlparcela = 0;

        foreach ($parcelas as $k => $p) {
            $multa = 0;
            $juros = 0;

            $p['dif'] = ($p['dif'] > 0) ? $p['dif'] : 0;
            //If para calcular o desconto da quitao, caso o cliente escolha calcular no Passo 2, pela Tabela PRICE.

            if($_POST['descontoBoleto'] == 'S'){

                $desconto = 'S';
                if ($taxas['tp_juros'] != 'S') {
                    $juros = ($taxas['tp_juros'] == 'P') ? ($taxas['juros'] / 100) * $p['vl_parcela'] : $taxas['juros'];
                    $juros = $p['dif'] * $juros;
                }

                if ($p['dif'] > 0 && $taxas['tp_multa'] != 'S') {
                    $multa = ($taxas['tp_multa'] == 'P') ? ($taxas['multa'] / 100) * $p['vl_parcela'] : $taxas['multa'];
                }


                $vlparcela += (round($p['vl_parcela'], 2));
                $vljuros += (round($juros, 2));
                $vlmulta += (round($multa, 2));

                $parcelas[$k]['vl_juros'] = Helper::getMoney($juros);
                $parcelas[$k]['vl_multa'] = Helper::getMoney($multa);
                $parcelas[$k]['juros'] = Helper::getMoney($juros);
                $parcelas[$k]['multa'] = Helper::getMoney($multa);
                $parcelas[$k]['dias'] = $p['dif'];
                $parcelas[$k]['dt_parcela'] = $p['dt_parcela'];

                //Aplica o desconto sob a tabela PRICE somente se a parcela no for vencida.
                if(($parcelas[$k]['juros'] > 0)||($parcelas[$k]['vl_multa'] >0 )){
                    $parcelas[$k]['desconto'] = $p['desconto'];
                }else{
                    $dadosParcela = Contrato::descontoQuitacao($_POST['dataBase'],$p['id_parcela_contrato']);
                    $parcelas[$k]['desconto'] = $dadosParcela['desconto'];
                }
                $total = (round($p['vl_parcela'], 2) + round($juros, 2) + round($multa, 2));
                $parcelas[$k]['total'] = Helper::getMoney($total);
                $parcelas[$k]['acrescimo'] = $p['acrescimo'];

                $contrato["total"] += $total;
            }else{
                if ($taxas['tp_juros'] != 'S') {
                    $juros = ($taxas['tp_juros'] == 'P') ? ($taxas['juros'] / 100) * $p['vl_parcela'] : $taxas['juros'];
                    $juros = $p['dif'] * $juros;
                }

                if ($p['dif'] > 0 && $taxas['tp_multa'] != 'S') {
                    $multa = ($taxas['tp_multa'] == 'P') ? ($taxas['multa'] / 100) * $p['vl_parcela'] : $taxas['multa'];
                }

                $total = (round($p['vl_parcela'], 2) + round($juros, 2) + round($multa, 2));
                $vlparcela += (round($p['vl_parcela'], 2));
                $vljuros += (round($juros, 2));
                $vlmulta += (round($multa, 2));

                $parcelas[$k]['vl_juros'] = Helper::getMoney($juros);
                $parcelas[$k]['vl_multa'] = Helper::getMoney($multa);
                $parcelas[$k]['juros'] = Helper::getMoney($juros);
                $parcelas[$k]['multa'] = Helper::getMoney($multa);
                $parcelas[$k]['total'] = Helper::getMoney($total);
                $parcelas[$k]['dias'] = $p['dif'];
                $parcelas[$k]['dt_parcela'] = $p['dt_parcela'];
                $parcelas[$k]['desconto'] = $p['desconto'];
                $parcelas[$k]['acrescimo'] = $p['acrescimo'];

                $contrato["total"] += $total;
            }

        }

        $valoresSomados = array(
            'vl_parcelas' => $vlparcela,
            'vl_juros' =>  $vljuros,
            'vl_multa' => $vlmulta
        );

        $contrato['valoresSomados'] = $valoresSomados;
        $contrato['total'] = Helper::getMoney($contrato["total"]);
        $contrato["data"] = $dataBase;
        $contrato["parcelas"] = $parcelas;
        
        $_SESSION['contrato'] = $contrato;
        $_SESSION['desconto'] = $desconto;

        $this->set("valoresSomados", $valoresSomados);
        $this->set("contrato", $contrato);

        $this->display("passo3");
    }

    public function passo4Action()
    {        
        $contrato = $_SESSION['contrato'];

        $i = 0;
        $total = Helper::getInputMoney($_POST['total']);
        $parcs = explode(':', $_POST['parcelas']);

        $parcelas = $_SESSION['contrato']['parcelas'];

        foreach ($parcs as $p) {
            $parcelas[$i]['acrescimo'] = Helper::getInputMoney($_POST["acrescimo_$p"]);
            $parcelas[$i]['desconto'] = Helper::getInputMoney($_POST["desconto_$p"]);
            $parcelas[$i]['multa'] = Helper::getInputMoney($_POST["multa_$p"]);
            $parcelas[$i]['juros'] = Helper::getInputMoney($_POST["juros_$p"]);
            $i++;
        }
        $valorParcela = (float)$total / (int)$_POST['vezes'];

        $valorRestante = (float)$total;
        for ($i = 1; $i <= $_POST['vezes']; $i++) {
            //Vai diminuindo o valor da parcela do total para setar o restante na ultima parcela
            if ($i == $_POST['vezes']) {
                $valorParcela = $valorRestante;
            } else {
                $valorRestante -= Helper::getInputMoney(Helper::getMoney($valorParcela));
            }
            $inputData = Helper::getInputDate($_POST['dtPrimParc']);
            $novasParcelas[$i]['dt_parcela'] = ($i == 1) ? $_POST['dtPrimParc'] : Helper::getDate(Helper::getNextMonth($inputData, $i - 1));
            $novasParcelas[$i]['vl_parcela'] = Helper::getMoney($valorParcela);
        }

        $contrato['parcelas'] = $parcelas;
        $contrato['parcelasNovas'] = $novasParcelas;
        $contrato['idsParcelas'] = $parcs;
        $contrato['total'] = Helper::getMoney($total);
        
        $_SESSION['contrato']['parcelas'] = $parcelas;
        $_SESSION['contrato']['parcelasNovas'] = $novasParcelas;
        $_SESSION['contrato']['idsParcelas'] = $parcs;
        $_SESSION['contrato']['total'] = Helper::getMoney($total);
        $_SESSION['contrato']['valoresSomados'] = $contrato['valoresSomados'];

        $this->set('contrato', $contrato);

        $this->display("passo4");
    }
    public function salvarAction()
    {
        $_SESSION['contrato']['tipo'] = 'Q';

        $tb_parcNegociada = new ParcelaNegociada();
        $tb_parcela = new Parcela();
        $tb_quitacao = new Negociacao();
        $tbContrato = new Contrato();
        $tbContratoHistorico = new ContratoHistorico();

        $db = Zend_Db_Table::getDefaultAdapter();
        $db->beginTransaction();

        try {
            $parcs = $_SESSION['contrato']['idsParcelas'];

            if (strstr($_SESSION['contrato']['idsParcelas'][0], ':')) {
                $parcs = explode(':', $_SESSION['contrato']['idsParcelas']);
            }
            
            $idContrato = $_SESSION['contrato']['numero'];

            //Passo 1 - Gera linha na tb negociacao
            $quitacao = $tb_quitacao->createRow();
            $quitacao->id_contrato = $idContrato;
            $quitacao->dataBase = Helper::getInputDate($_SESSION['contrato']['data']);
            $quitacao->data = date('Y-m-d');
            $quitacao->obs = $_POST['obs'];
            $quitacao->tp_operacao = $_SESSION['contrato']['tipo'];
            $quitacao->nr_quantidade_parcela = count($_POST['data']);
            $quitacao->vl_desconto = ($_POST['desconto']) ? $_POST['desconto'] : '0';
            $quitacao->vl_acrescimo = ($_POST['acrescimo']) ? $_POST['acrescimo'] : '0';
            $quitacao->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - i');
            $idQuitacao = $quitacao->save();
            $listaParcelasUsadas = '';

            foreach ($parcs as $p) {
                //Parcela negociada que tem os seus valores originais atualizados de acordo com a data base
                $parcela = $tb_parcela->fetchRow('id_parcela_contrato = "' . $p . '"');
                //Pegando o id/tipo das parcelas usadas
                $listaParcelasUsadas .= $parcela->id_parcela . $parcela->tp_parcela . ", ";

                //Passo 2 - Gera parcela
                $parcelaQuitacao = $tb_parcNegociada->createRow();
                $parcelaQuitacao->id_parcela_contrato = $p;
                $parcelaQuitacao->tp_parcela = $parcela->tp_parcela;
                $parcelaQuitacao->acrescimo = ($parcela->acrescimo) ? $parcela->acrescimo : '0';
                $parcelaQuitacao->desconto = ($parcela->desconto) ? $parcela->desconto : '0';
                $parcelaQuitacao->id_negociacao = $idQuitacao;
                $parcelaQuitacao->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - i');
                $parcelaQuitacao->save();

                $parcela->acrescimo = ($_POST['acrescimo_' . $p]) ? $_POST['acrescimo_' . $p] : '0';
                $parcela->desconto = ($_POST['desconto_' . $p]) ? $_POST['desconto_' . $p] : '0';
                $vljuros = Helper::getInputMoney($_POST['juros_' . $p]);
                $vlmulta =  Helper::getInputMoney($_POST['multa_' . $p]);

                //Grava o valor dos juros na tabela somente se houve juros. Corrigindo erro ao gravar valor vazio na tabela PARCELA
                if ($vljuros > 0){
                    $parcela->vl_juros =  $vljuros;
                }
                //Grava o valor da multa na tabela somente se houve multa. Corrigindo erro ao gravar valor vazio na tabela PARCELA
                if ($vlmulta > 0){
                    $parcela->vl_multa = $vlmulta;
                }

                $parcela->id_renegociacao = $idQuitacao;                
                $parcela->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - u');
                $parcela->save();
                
                // Passo 3 - Cria contrato histrico
                $contratoHistorico = $tbContratoHistorico->fetchRow("id = " . $idContrato);
                if (!$contratoHistorico) {
                    $contrato = $tbContrato->fetchRow("id = " . $idContrato)->toArray();
                    $contrato['log'] = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - u');
                    $db->insert(TB_CONTRATO_HISTORICO, $contrato);
                }
                // Passo 4 - Salva as parcelas no historico
                $db->insert(TB_PARCELA_HISTORICO, $parcela->toArray());
                //Passo 5 - deleta a(s) parcela(s)
                $tb_parcela->delete('id_parcela_contrato = ' . $parcela['id_parcela_contrato']);
            }
            //Passo 6 - Cria as novas parcelas na tabela de parcela
            $listaParcelasCriada = '';
            for ($i = 1; $i <= count($_POST['data']); $i++) {
                $parcela = $tb_parcela->createRow();
                $parcela->id_parcela = $i;
                $parcela->id_contrato = $idContrato;
                $parcela->acrescimo = 0;
                $parcela->desconto = 0;
                $parcela->dt_parcela = Helper::getInputDate($_POST['data'][$i - 1]);
                $parcela->vl_parcela = Helper::getInputMoney($_POST['valor'][$i - 1]);
                $parcela->tp_parcela = 'Q';
                $parcela->id_renegociacao = $idQuitacao;
                $parcela->pago = '0';
                $parcela->obs = "Parcela referente a quitacao do contrato {$idContrato}";
                $parcela->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - i');
                $parcela->save();
                $listaParcelasCriada .= $i . 'Q' . ", ";
            }

            $db->commit();
            //Passo 7 - Remove os dados da sessao
            unset($_SESSION['contrato'], $_SESSION['parcelas']);           
            $tipoOperacao = ' Quitao ';
            //Passo 8 - Gera o log
            (new Relacionamento())->saveContato(26, date('Y-m-d'), $idContrato, 'Log: ' . $tipoOperacao . ' gerada. Parcelas Usadas: ' . $listaParcelasUsadas . ' Parcelas Criadas: '  . $listaParcelasCriada);
            // Passo 9 - Redireciona
            $this->redirect(array('m' => 'fin', 'c' => 'quitacao', 'a' => 'listar'), array('success' => 'Operao realizada com sucesso'));
        } catch (Exception $e) {
            $db->rollBack();
            $this->redirect(array('m' => 'fin', 'c' => 'quitacao', 'a' => 'listar'), array('success', 'Houve algum erro, entre em contato com suporte. ' . $e->getMessage()));
        }
    }
    /**
     * Funcao ajax que retorna os valores da parcela
     */
    public function parcelasValorAjaxAction()
    {

        $this->set('sinal', $_POST['sinal']);
        $this->set('parcelas', $_POST['parcelas']);

        $count = (int)$this->get('parcelas');
        $valorTotal = Helper::getInputMoney($this->get('sinal'));

        $this->set('vlParcelas', Helper::getMoney($valorTotal / $count));

        $this->display('vlPagar');
    }

    /**
     * Funcao que realiza acao de desfazer a quitacao
     */
    public function desfazerAction()
    {
        if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'desfazerQuitacao')) {
            $this->redir(array('modulo' => 'fin', 'controller' => 'quitacao', 'action' => 'listar'), array('msgErros' => 'fail', 'danger' => 'Voc no tem permisso para acessar essa funcionalidade.'));
            exit;
        }

        $tb_negociacao = new Negociacao();
        $tb_parcela = new Parcela();
        $tbParcelaHistorico = new ParcelaHistorico();
        $tb_parc2aVia = new Parcela2Via();
        $tb_parcNegociada = new ParcelaNegociada();
        $url = array('m' => 'fin', 'c' => 'quitacao', 'a' => 'listar');
        $idContrato = $_GET['id'];
        $idRenegociacao = $_GET['r'];

        $negociacao = $tb_negociacao->fetchRow("id_contrato =  $idContrato and id = $idRenegociacao");

        if ($negociacao) {
            $negociacao = $negociacao->toArray();
            $_GET['id'] = $negociacao['id'];
            //busca os dados anteriores da tabela negociada
            $parcelasNegociadas = $tbParcelaHistorico->fetchAll('id_renegociacao = ' . $_GET['id'])->toArray();
            //Iniciando transacao, implementando padrao adotado 10/06/2018
            $db = Zend_Db_Table::getDefaultAdapter();
            $db->beginTransaction();

            $idcontrato = $negociacao['id_contrato'];

            try {
                //restaura os valores das parcelas
                foreach ($parcelasNegociadas as $parcNeg) {
                    // Salvamos as parcelas no historico.
                    $db->insert(TB_PARCELA, $parcNeg);
                    $parcNegociada = $tb_parcNegociada->fetchRow('id_parcela_contrato = ' . $parcNeg['id_parcela_contrato']);
                    $parcela = $tb_parcela->fetchRow('id_parcela_contrato = ' . $parcNeg['id_parcela_contrato']);

                    if ($parcela) {
                        $parcela->tp_parcela = $parcNegociada->tp_parcela;
                        $parcela->acrescimo = $parcNegociada->acrescimo;
                        $parcela->desconto = $parcNegociada->desconto;
                        $parcela->vl_juros = null;
                        $parcela->vl_multa = null;
                        $parcela->id_renegociacao = null;
                        $parcela->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - u');
                        $parcela->save();

                        //exclui os registros de backup
                        $parcNegociada->delete();
                    }
                }
                //ternario para escolha de campos!
                $campoNegociacao = 'id_renegociacao';
                $tpNegociacao = 'Quitao';
                //exclui as parcelas negociadas
                $tb_parcNegociada->delete('id_negociacao = ' . $negociacao['id']);
                //exclui a Parcela Historico
                $tbParcelaHistorico->delete($campoNegociacao.' = '. $negociacao['id']);
                //exclui a Parcela
                $tb_parcela->delete($campoNegociacao.' = ' . $negociacao['id']);
                //exclui a Parcela 2 Via
                $tb_parc2aVia->delete($campoNegociacao.' = ' . $negociacao['id']);
                //exclui a negociacao
                //Negociacao e relacionado, primeiro se exclui as parcelas para depois a negociacao!
                $tb_negociacao->delete('id = ' .$negociacao['id']);
                $db->commit();
                //Altera o status do lote para vendido("V")
                $contrato = (new Contrato())->getDefaultAdapter()->select()
                ->from(['c' => TB_CONTRATO], 'id_lote')
                ->where('c.id = ' . $idcontrato)
                ->query()->fetch();

                $statusLote = new Lote();
                $statusLote = $statusLote->fetchRow('id = ' . $contrato['id_lote']);
                $statusLote->status = 'V';
                $statusLote->save();
                //Antes de redirecionar grava o resultado no log dos contatos realizados como Negociacao.
                (new Relacionamento())->saveContato(26, date('Y-m-d'), $idcontrato, 'Log: '.$tpNegociacao.' Cancelada');
                $this->redirect($url, array('success' => 'Operao realizada com sucesso'));
            } catch (Exception $e) {
                $db->rollBack();
                $this->redirect($url, array('danger'=>$e->getMessage()));
                exit;
            }
            
        } else {
            // Vamos iniciar uma transacao com o banco dados.
            $db = Zend_Db_Table::getDefaultAdapter();
            $db->beginTransaction();
            $tb_contratoHistorico = new ContratoHistorico();

            try {

                $table = Zend_Db_Table::getDefaultAdapter();

                $tb_parcelas = new Parcela();
                $parcelasPagas = $tb_parcelas->fetchAll("id_contrato = " . $_GET['id'] . " AND tp_parcela = 'Q'")->toArray();

                if (!$parcelasPagas) {
                    $this->redir(array("modulo" => "fin", "controller" => "quitacao", "action" => "listar"),array('exception'=>'O contrato no possui parcelas de quitao'));
                } else {
                    foreach ($parcelasPagas as $parc) {
                        $tb_parcelas->delete('id_parcela_contrato = ' . $parc['id_parcela_contrato']);
                    }
                    // Pega todas as parcelas deste contrato
                    $tb_parcelasHistorico = new ParcelaHistorico();
                    $parcelas = $tb_parcelasHistorico->fetchAll('id_contrato = ' . $_GET['id']. ' AND fl_quitado = "1"')->toArray();
                    // Salvamos as parcelas.
                    foreach ($parcelas as $parc) {
                        // Setando o log das parcelas para quem de fato esta excluindo.
                        $parc["fl_quitado"] = 0;
                        $parc["log"] = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - i');
                        // Inserindo.
                        $table->insert(TB_PARCELA, $parc);
                    }
                    //exclui as parcelas
                    $parcelasHistocio = new ParcelaHistorico();
                    $existeParcelaHistorico = $parcelasHistocio->fetchAll('id_contrato = '. $_GET['id']);
                    if ($existeParcelaHistorico) {
                        $parcelasHistocio->delete('id_contrato = '. $_GET['id'] .' AND fl_quitado = "1"');
                    }
                    //So pode excluir contrato historico, caso nao exista parcelas na tabela parcela historico!
                    if(!$existeParcelaHistorico)
                        $tb_contratoHistorico->delete('id = ?'. $_GET['id']);

                    $db->commit();
                     //Altera o status do lote para vendido("V")
                    $contrato = (new Contrato())->getDefaultAdapter()->select()
                    ->from(['c' => TB_CONTRATO], 'id_lote')
                    ->where('c.id = ' . $idContrato)
                    ->query()->fetch();

                    $statusLote = new Lote();
                    $statusLote = $statusLote->fetchRow('id = ' . $contrato['id_lote']);
                    $statusLote->status = 'V';
                    $statusLote->save();
                    //Antes de redirecionar grava o resultado no log dos contatos realizados como Quitacao.
                    (new Relacionamento())->saveContato(26, date('Y-m-d'), $_GET['id'], 'Log: Quitao Cancelada.');
                    $this->redirect($url, array('success' => 'Operao realizada com sucesso'));
                }
            } catch (Exception $e) {
                $db->rollBack();
                $this->redirect($url, array('danger' => $e->getMessage()));
            }
        }
    }

    /**
     * Funcao ajax que retorna os contratos por empreendimento
     */
    public function contrato_by_empreendimentoAction()
    {
        $empreedimento = $_POST['id_empreendimento'];
        $contratos = Contrato::byEmpreendimentoParcelasAbertasQuitacao($empreedimento, Contrato::CONTRATO_GERADO, array("nm_pessoa", "lote", "quadra", "id_contrato"));

        $lista[] = array('id'=>'','text'=>'');
        foreach ($contratos as $contrato) {
            if ($contrato['fl_distrato'] == '1')
                $color = 'color: red;';
            else
                $color = null;
            $lista[] = array(
                'id' => $contrato['id'],
                'text' => utf8_encode($contrato['nm_pessoa']) . ' Quadra: ' . utf8_encode($contrato['quadra']) . ' - Lote: ' . utf8_encode($contrato['lote']) . ' - Contrato: ' . $contrato['id'],
                'estilo' => $color
            );
        }
        echo json_encode($lista);
    }

    /**
     * Funcao ajax que retorna os contratos para quitacao
     */
    public function lote_quitacao_by_empreendimentoAction()
    {
        $select = Zend_Db_Table::getDefaultAdapter()->select();
        $contratosEmAberto = $select
            ->from(array('L' => TB_LOTES), '')
            ->join(array('C' => TB_CONTRATO), 'C.id_lote = L.id', array('id'))
            ->join(array('P' => TB_PESSOA), 'P.id = C.id_pessoa', '')
            ->join(array('ph' => TB_PARCELA), 'ph.id_contrato = C.id', '')
            ->where('L.id_empreendimento = ?', $_POST['id_empreendimento'])
            ->where('ph.tp_parcela not in ("E", "NE", "SE", "IE", "CE")')
            ->where('ph.pago = ?', '0')
            ->where('C.fl_gerado = ?', '1')
            ->where("fl_distrato = '0'")
            ->group('C.id')
            ->query()->fetchAll();

        foreach($contratosEmAberto as $contrato) {
            $contratos[] = $contrato['id'];
        }

        $select = Zend_Db_Table::getDefaultAdapter()->select();
        $listaContratos = $select
            ->from(array('L' => TB_LOTES), array('loteId' => 'id', 'lote', 'quadra'))
            ->join(array('C' => TB_CONTRATO), 'C.id_lote = L.id', array('id'))
            ->join(array('P' => TB_PESSOA), 'P.id = C.id_pessoa', array('nm_pessoa'))
            ->join(array('ph' => TB_PARCELA), 'ph.id_contrato = C.id', array())
            ->where('L.id_empreendimento = ?', $_POST['id_empreendimento'])
            ->where('C.id not in ("' . implode('","', $contratos) . '")')
            ->where('ph.tp_parcela not in ("E", "NE", "SE", "IE", "CE")')
            ->where('ph.pago = ?', '1')
            ->where('C.fl_gerado = ?', '1')
            ->where("fl_distrato = '0'")
            ->order('P.nm_pessoa ASC')
            ->order('L.lote ASC')
            ->order('L.quadra ASC')
            ->group('C.id')
            ->query()->fetchAll();

        $lista[] = array('id'=>'','text'=>'');
        foreach ($listaContratos as $contrato) {
            $lista[] = array(
                'id' => $contrato['id'],
                'text' => utf8_encode($contrato['nm_pessoa']) . ' - Quadra: ' . utf8_encode($contrato['quadra']) . ' - Lote: ' . utf8_encode($contrato['lote']) . ' - Contrato: ' . $contrato['id'],
            );
        }
        echo json_encode($lista);
    }

    /**
     * Funcao que gera o termo de quitao
     */
    public function termoDeQuitacaoAction()
    {
        if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'termoDeQuitacao')) {
            $this->redir(array('modulo' => 'fin', 'controller' => 'quitacao', 'action' => 'listar'), array('msgErros' => 'fail', 'danger' => 'Voc no tem permisso para acessar essa funcionalidade.'));
        }

        $tbClienteAcade = new Db_Cliente();
        $this->set('clienteAcade', $tbClienteAcade->fetchRow()->toArray());

        $empreendimentos = $this->tb_empreendimento->getDefaultAdapter()->select()
            ->from(array('e' => TB_EMPREENDIMENTO));

        if ($this->_isPost) {
            if ($this->validarTermo()) {
                $pessoas = new Pessoa();
                $pessoas_fisicas = new Pessoa_Fisica();
                $pessoas_juridicas = new Pessoa_Juridica();
                $lotes = new Lote();
                $contratos = new Contrato();
                $parcerias = new Parceria();
                $empreendimentos = new Empreendimento();
                $itens = new ContratoItens();

                $empreendimento = $empreendimentos->find($_POST['id_empreendimento'])->current()->toArray();
                $assinaturas = Assinatura::findAssinaturaByEmpreendimento($_POST['id_empreendimento']);

                $contrato = $contratos->find($_POST['id_contrato'])->current()->toArray();
                
                $contrato['vl_pago'] = $contratos->getParcelasValorById($_POST['id_contrato'], ($_POST['tp_avulsa'] == 'S')?true:false, $contrato['inclui_sinal_contrato']);

                $contratoItens = $itens->fetchAll('id_contrato = ' . $_POST['id_contrato'])->toArray();

                $lote = $lotes->find($contrato['id_lote'])->current()->toArray();
                $cliente = $pessoas->find($contrato['id_pessoa'])->current()->toArray();
                $parceria = $parcerias->fetchAll($parcerias->select()->where('id_empreendimento = ?', $_POST['id_empreendimento']))->toArray();

                if ($cliente['tp_pessoa'] == 'F') {
                    $pf = $pessoas_fisicas->find($cliente['id'])->current()->toArray();
                    //poderia ser pessoa fisica e corretor
                    unset($pf['tp_pessoa']);
                    $cliente = array_merge($cliente, $pf);
                } elseif ($cliente['tp_pessoa'] == 'J') {
                    $cliente = array_merge($cliente, $pessoas_juridicas->find($cliente['id'])->current()->toArray());
                    $representante = new Representante();
                    $cliente['representantes'] = $representante->listaRepresentantesDaPessoaJuridica($cliente['id']);
                }
                //pessoas envolvidas
                $pessoas_envolvidas = $this->pessoasEnvolvidas->findByContrato($_POST['id_contrato']);
                $outrosCompradores = array();
                $k = 0;
                if ($pessoas_envolvidas) {
                    foreach ($pessoas_envolvidas as $pessoa) {
                        $outrosCompradores[$k] = $this->tb_pessoa->findFisicaById($pessoa['id_pessoa']);
                        $cidade = Db_Cidade::find($outrosCompradores[$k]['cd_cidade']);
                        if ($cidade)
                            $cidade = $cidade->toArray();
                        else {
                            $cidade['nome'] = '';
                            $cidade['uf'] = '';
                        }
                        $outrosCompradores[$k]['nmcidade'] = $cidade['nome'];
                        $outrosCompradores[$k]['ufcidade'] = $cidade['uf'];
                        switch ($outrosCompradores[$k]['est_civil']) {
                            case 'SOL' :
                                $outrosCompradores[$k]['est_civil_nome'] = 'Solteiro(a)';
                                break;
                            case 'CAS' :
                                $outrosCompradores[$k]['est_civil_nome'] = 'Casado(a)';
                                if ($outrosCompradores[$k]['cd_conjuge'])
                                    $outrosCompradores[$k]['conjuge'] = $this->tb_pessoa->findFisicaById($outrosCompradores[$k]['cd_conjuge']);
                                break;
                            case 'SEP' :
                                $outrosCompradores[$k]['est_civil_nome'] = 'Separado(a)';
                                break;
                            case 'VIU' :
                                $outrosCompradores[$k]['est_civil_nome'] = 'Viuvo(a)';
                                break;
                            case 'DIV' :
                                $outrosCompradores[$k]['est_civil_nome'] = 'Divorciado(a)';
                                break;
                            case 'UNE' :
                                $outrosCompradores[$k]['est_civil_nome'] = 'Unio estvel';
                                if ($outrosCompradores[$k]['cd_conjuge'])
                                    $outrosCompradores[$k]['conjuge'] = $this->tb_pessoa->findFisicaById($outrosCompradores[$k]['cd_conjuge']);
                                break;
                        }
                        $k++;
                    }
                    $this->set('pessoas_envolvidas', $outrosCompradores);
                }
                $totalParcelas = count($contratoItens) + $contrato['nr_parcela'];
                
                switch($contrato['fl_fm_pagamento']){
                    case 'PC':
                        $totalParcelas == 1? $tipoPagamento = 'em <b><u>parcela nica</u></b>': $tipoPagamento = 'em <b><u>parcelas mensais</u></b>';
                        break;
                    case 'AV':
                        $tipoPagamento = '<b><u>a vista</u></b>';
                        break;
                    case 'PM':
                        $tipoPagamento = 'em <b><u>permuta</u></b>';
                        break;
                }

                $cliente['cidade'] = ($cidade = Db_Cidade::find($cliente['cd_cidade'])) ? $cidade->toArray() : array();

                $tipoLoteamento = (new TipoLoteamento())->fetchRow('id_tipo_loteamento = '.$empreendimento['id_tipo_loteamento']);
                $empreendimento['dsGrupo'] = ($tipoLoteamento['ds_grupo'])?$tipoLoteamento['ds_grupo']:'';
                $empreendimento['dsSubgrupo'] = ($tipoLoteamento['ds_subgrupo'])?$tipoLoteamento['ds_subgrupo']:'';
                $empreendimento['cidade'] = ($cidade = Db_Cidade::find($empreendimento['cd_cidade'])) ? $cidade->toArray() : array();
                $empreendimento['cidade'] = $empreendimento['cidade']['nome'] . ' - ' . $empreendimento['cidade']['uf'];

                $cliente['obs'] = $_POST['obs'];
                $contratoObsQui = new Contrato();
                $contratoObsQui = $contratoObsQui->fetchRow('id ='.$_POST['id_contrato']);                
                $contratoObsQui->obs_quitacao = $cliente['obs'];
                $contratoObsQui->save();

                //Muda o status do lote para quitado
                $statusLote = new Lote();
                $statusLote = $statusLote->fetchRow('id = ' . $contrato['id_lote']);
                $statusLote->status = 'Q';
                $statusLote->save();

                $this->set('empreendimento', $empreendimento);
                $this->set('lote', $lote);
                $this->set('cliente', $cliente);
                $this->set('parceria', $parceria);
                $this->set('contrato', $contrato);
                $this->set('assinatura', $assinaturas);
                $this->set('tipoPagamento', $tipoPagamento);

                //Grava a operacao no log de contatos realizados ao gerar o termo de quitao
                (new Relacionamento())->saveContato(24, date('Y-m-d'), $_POST['id_contrato'], "Log: Termo de quitao gerado - Data: {$_POST['data']} -  Observao: {$_POST['obs']}");

                $this->displayPDF('Termo_de_quitacao' . time() . '.pdf');
            } else {
                $select = Zend_Db_Table::getDefaultAdapter()->select();
                $rows = $select->from(array('L' => TB_LOTES), array('lote' => '(concat(lote,concat(" - Quadra: ",quadra)))'))
                    ->join(array('C' => TB_CONTRATO), 'C.id_lote = L.id', 'id')
                    ->join(array('P' => TB_PESSOA), 'P.id = C.id_pessoa', 'nm_pessoa')
                    ->join(array('ph' => TB_PARCELA), 'ph.id_contrato = C.id', array())
                    ->where('C.fl_gerado = ?', '1')
                    ->where('L.id_empreendimento = ?', $_POST['id_empreendimento'])
                    ->group('L.id')
                    ->order('L.lote ASC')
                    ->query()->fetchAll();

                $this->set('param', $_POST);
                $this->set('lotes', $rows);
            }
        }

        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $empreendimentos->where("e.id IN({$id})");
                } else {
                    $empreendimentos->where("1");
                }
            } catch (Exception $e) {

            }
        }
        $model = new ModeloArquivo();
        $listaMod = $model->fetchAll('tp_modelo = "Q" and fl_status = "1"');
        $empreendimentos = $empreendimentos->order('nm_empreendimento')->query()->fetchAll();

        $this->set('empreendimentos', $empreendimentos);
        $this->set('listaArquivoWord', $listaMod);
        $this->display('formTermoQuitacao');
    }

    /**
     * Funcao que valida os termo
     */
    private function validarTermo()
    {
        //* O numero de parcelas intercaladas X a frequencia nao pode ultrapassa o numero de parcelas normais;

        $campos = array('data' => 'O campo data  obrigatrio',
            'id_empreendimento' => 'Selecione o empreendimento',
            'id_contrato' => 'Selecione o contrato'
        );
        foreach ($campos as $k => $msg) {
            if ($_POST[$k] == "") {
                $this->_helper->addMensagem($k, $msg);
            }
        }

        if (!(count($this->_helper->getMensagens()) > 0)) {
            $tb_parcelas = new Parcela();
            $parcelas = $tb_parcelas->fetchAll("pago = '0' and id_contrato = {$_POST['id_contrato']} and tp_parcela NOT IN ('E', 'NE', 'SE', 'CE', 'IE')");
            if (count($parcelas) > 0) {
                $this->_helper->addMensagem('abertas', 'O contrato ainda possui parcelas em aberto');
            }
        }

        return !(count($this->_helper->getMensagens()) > 0);
    }

    //Gerar Relatorio Sinttico
    public function gerarSinteticoAction()
    {
        $tbClienteAcade = new Db_Cliente();
        $this->set('clienteAcade', $tbClienteAcade->fetchRow()->toArray());

        $tb_negociacao = new Negociacao();
        $tbParcela = new Parcela();
        $tbParcelaHistorico = new ParcelaHistorico();
        $tbAssinatura = new Assinatura();
        $tbContrato = new Contrato();
        $tbParceria = new Parceria();
        $tbContratoPessoa = new ContratoPessoa();
        $tbPessoa = new Pessoa();

        $negociacao = $tb_negociacao->getAdapter()->select()
            ->from(array('n' => TB_NEGOCIACAO), array('idNegociacao' => 'id','*'))
            ->join(array('c' => TB_CONTRATO), 'c.id = n.id_contrato', array('contrato' => 'id', 'nr_parcela'))
            ->join(array('l' => TB_LOTES), 'l.id = c.id_lote', array('lote', 'quadra'))
            ->join(array('e' => TB_EMPREENDIMENTO), 'e.id = l.id_empreendimento', array('idEmpreendimento' => 'id','nm_empreendimento','fl_assinatura', 'ds_path_logo'))
            ->joinLeft(array('ci' => TB_CIDADE), 'ci.id = e.cd_cidade', array('cidade' => 'nome', 'uf'))
            ->joinLeft(array('r' => TB_REPRESENTANTE), 'r.id_pessoa_juridica = c.id_pessoa AND r.fl_principal = "1"', null)
            ->joinLeft(array('pe' => TB_PESSOA), 'pe.id = r.id_pessoa OR pe.id = c.id_pessoa', array('nm_pessoa', 'nrCepCli' => 'nr_cep', 'enderecoCli' => 'endereco', 'bairroCli' => 'nm_bairro'))
            ->joinLeft(array('pf' => TB_PESSOA_FISICA), 'pf.id_pessoa = pe.id', array('cpfCli' => 'nr_cpf'))
            ->joinLeft(array('ciCli' => TB_CIDADE), 'ciCli.id = pe.cd_cidade', array('cidadeCli' => 'nome', 'ufCli' => 'uf'))
            ->where('n.tp_operacao = "Q"')
            ->where('c.id = ' . $_GET['id'])
            ->order('n.id DESC')
            ->query()->fetch();
        
        if ($negociacao) {

            $qtdeParcelas = $tbParcela->getQtdeParcelas($negociacao['id_contrato']);

            $pessoasEnvolvidas = $tbContratoPessoa->findByContrato($negociacao['id_contrato']);
            $pessoas = [];
            foreach ($pessoasEnvolvidas as $pessoa) {
                array_push($pessoas, $tbPessoa->findPessoaById($pessoa['id_pessoa']));
            }

            //Consulta que tres os dados do contrato
            $contrato = $tbContrato->getDefaultAdapter()->select()
                ->from(array('c' => TB_CONTRATO), array('id', 'id_lote','id_pessoa'))
                ->join(array('l' => TB_LOTES), 'l.id = c.id_lote', array('id_empreendimento'))
                ->where('c.id = ' . $negociacao['id_contrato'])
                ->query()->fetch();

            //Consulta para ser exibido as Assinaturas
            $assinaturas = $tbAssinatura->getAdapter()->select()
                ->from(array('as' => TB_ASSINATURA), '*')
                ->join(array('p' =>TB_PESSOA), 'as.id_pessoa = p.id', array('id','nm_pessoa'))
                ->join(array('e' => TB_EMPREENDIMENTO), 'e.id = as.id_empreendimento', array('id','nm_empreendimento','fl_assinatura'))
                ->joinLeft(array('pf' => TB_PESSOA_FISICA), 'pf.id_pessoa = p.id', array('nr_cpf'))
                ->joinLeft(array('pj' => TB_PESSOA_JURIDICA), 'pj.id_pessoa = p.id',array('nr_cnpj'))
                ->joinLeft(array('pa' => TB_PARCERIA), 'e.id = pa.id_empreendimento', array('*'))
                ->where('as.id_empreendimento = ' . $contrato['id_empreendimento'])
                ->group('p.nm_pessoa')
                ->query()->fetchAll();

            //Consulta para trazer o Tipo do Loteamento
            $empreendimentoInfo = Zend_Db_Table::getDefaultAdapter()->select()
                ->from(array('em' => TB_EMPREENDIMENTO), array('id_tipo_loteamento'))
                ->join(array('t' => TB_TIPO_LOTEAMENTO), 'em.id_tipo_loteamento = t.id_tipo_loteamento', array('*'))
                ->where('em.id = '.$negociacao['idEmpreendimento'])
                ->query()->fetch();
            $this->set("empreendimentoInfo", $empreendimentoInfo);

            //Consulta para ser exibido as Parcerias
            $parceria = $tbParceria->getAdapter()->select()
                ->from(array('pa' => TB_PARCERIA), '*')
                ->join(array('p' =>TB_PESSOA), 'pa.id_pessoa = p.id', array('id','nm_pessoa'))
                ->join(array('e' => TB_EMPREENDIMENTO), 'e.id = pa.id_empreendimento', array('id','nm_empreendimento','fl_assinatura'))
                ->joinLeft(array('pf' => TB_PESSOA_FISICA), 'pf.id_pessoa = p.id', array('nr_cpf'))
                ->joinLeft(array('pj' => TB_PESSOA_JURIDICA), 'pj.id_pessoa = p.id',array('nr_cnpj'))
                ->where('pa.id_empreendimento = ' . $contrato['id_empreendimento'])
                ->group('p.nm_pessoa')
                ->query()->fetchAll();

            $parcelaSelecionada = $tbParcelaHistorico->fetchAll("id_renegociacao = " . $negociacao['idNegociacao'], 'dt_parcela')->toArray();
            $listaNegociadas = $tbParcela->fetchAll("id_renegociacao = " . $negociacao['idNegociacao'], 'dt_parcela')->toArray();

            $this->set('negociacao', $negociacao);
            $this->set('parcelaSelecionada', $parcelaSelecionada);
            $this->set('listaNegociadas', $listaNegociadas);
            $this->set('qtdeParcelas', $qtdeParcelas);
            $this->set('assinaturas', $assinaturas);
            $this->set('parceria', $parceria);
            $this->set('pessoasEnvolvidas', $pessoas);
            $this->displayPDF("gerarRelatorio.pdf");
        } else {
            // Gera relatrio modelo antigo atribuido ao mtodo 
            $this->redirect(array('m' => 'fin', 'c' => 'quitacao', 'a' => 'gerar', 'id' => $_GET['id']));
        }
    }
    /**
     * Funcao que gera relatrio analtico
     */
    public function gerarAction()
    {
        if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'gerarQuitacao')) {
            $this->redir(array('modulo' => 'fin', 'controller' => 'quitacao', 'action' => 'listar'), array('msgErros' => 'fail', 'danger' => 'Voc no tem permisso para acessar essa funcionalidade.'));
        }

        $tbClienteAcade = new Db_Cliente();
        $this->set('clienteAcade', $tbClienteAcade->fetchRow()->toArray());

        $tb_negociacao = new Negociacao();
        $tbParcela = new Parcela();
        $tbParcelaHistorico = new ParcelaHistorico();
        $tbAssinatura = new Assinatura();
        $tbContrato = new Contrato();
        $tbParceria = new Parceria();
        $tbContratoPessoa = new ContratoPessoa();
        $tbPessoa = new Pessoa();

        $negociacao = $tb_negociacao->getAdapter()->select()
            ->from(array('n' => TB_NEGOCIACAO), array('idNegociacao' => 'id','*'))
            ->join(array('c' => TB_CONTRATO), 'c.id = n.id_contrato', array('contrato' => 'id', 'nr_parcela'))
            ->join(array('l' => TB_LOTES), 'l.id = c.id_lote', array('lote', 'quadra'))
            ->join(array('e' => TB_EMPREENDIMENTO), 'e.id = l.id_empreendimento', array('idEmpreendimento' => 'id','nm_empreendimento','fl_assinatura', 'ds_path_logo'))
            ->joinLeft(array('ci' => TB_CIDADE), 'ci.id = e.cd_cidade', array('cidade' => 'nome', 'uf'))
            ->joinLeft(array('r' => TB_REPRESENTANTE), 'r.id_pessoa_juridica = c.id_pessoa AND r.fl_principal = "1"', null)
            ->joinLeft(array('pe' => TB_PESSOA), 'pe.id = r.id_pessoa OR pe.id = c.id_pessoa', array('nm_pessoa', 'nrCepCli' => 'nr_cep', 'enderecoCli' => 'endereco', 'bairroCli' => 'nm_bairro'))
            ->joinLeft(array('pf' => TB_PESSOA_FISICA), 'pf.id_pessoa = pe.id', array('cpfCli' => 'nr_cpf'))
            ->joinLeft(array('ciCli' => TB_CIDADE), 'ciCli.id = pe.cd_cidade', array('cidadeCli' => 'nome', 'ufCli' => 'uf'))
            ->where('n.tp_operacao = "Q"')
            ->where('c.id = ' . $_GET['id'])
            ->order('n.id DESC')
            ->query()->fetch();
        
        // Caso seja modelo de quitacao novo
        if ($negociacao) {
            $qtdeParcelas = $tbParcela->getQtdeParcelas($negociacao['id_contrato']);                
            $pessoasEnvolvidas = $tbContratoPessoa->findByContrato($negociacao['id_contrato']);
            $pessoas = [];
            foreach ($pessoasEnvolvidas as $pessoa) {
                array_push($pessoas, $tbPessoa->findPessoaById($pessoa['id_pessoa']));
            }
    
            //Consulta que tres os dados do contrato
            $contrato = $tbContrato->getDefaultAdapter()->select()
                ->from(array('c' => TB_CONTRATO), array('id', 'id_lote','id_pessoa'))
                ->join(array('l' => TB_LOTES), 'l.id = c.id_lote', array('id_empreendimento'))
                ->where('c.id = ' . $negociacao['id_contrato'])
                ->query()->fetch();
    
            //Consulta para ser exibido as Assinaturas
            $assinaturas = $tbAssinatura->getAdapter()->select()
                ->from(array('as' => TB_ASSINATURA), '*')
                ->join(array('p' =>TB_PESSOA), 'as.id_pessoa = p.id', array('id','nm_pessoa'))
                ->join(array('e' => TB_EMPREENDIMENTO), 'e.id = as.id_empreendimento', array('id','nm_empreendimento','fl_assinatura'))
                ->joinLeft(array('pf' => TB_PESSOA_FISICA), 'pf.id_pessoa = p.id', array('nr_cpf'))
                ->joinLeft(array('pj' => TB_PESSOA_JURIDICA), 'pj.id_pessoa = p.id', array('nr_cnpj'))
                ->joinLeft(array('pa' => TB_PARCERIA), 'e.id = pa.id_empreendimento', array('*'))
                ->where('as.id_empreendimento = ' . $contrato['id_empreendimento'])
                ->group('p.nm_pessoa')
                ->query()->fetchAll();
    
            //Consulta para trazer o Tipo do Loteamento
            $empreendimentoInfo = Zend_Db_Table::getDefaultAdapter()->select()
                ->from(array('em' => TB_EMPREENDIMENTO), array('id_tipo_loteamento'))
                ->join(array('t' => TB_TIPO_LOTEAMENTO), 'em.id_tipo_loteamento = t.id_tipo_loteamento', array('*'))
                ->where('em.id = '.$negociacao['idEmpreendimento'])
                ->query()->fetch();
            $this->set("empreendimentoInfo", $empreendimentoInfo);
    
            //Consulta para ser exibido as Parcerias
            $parceria = $tbParceria->getAdapter()->select()
                ->from(array('pa' => TB_PARCERIA), '*')
                ->join(array('p' =>TB_PESSOA), 'pa.id_pessoa = p.id', array('id','nm_pessoa'))
                ->join(array('e' => TB_EMPREENDIMENTO), 'e.id = pa.id_empreendimento', array('id','nm_empreendimento','fl_assinatura'))
                ->joinLeft(array('pf' => TB_PESSOA_FISICA), 'pf.id_pessoa = p.id', array('nr_cpf'))
                ->joinLeft(array('pj' => TB_PESSOA_JURIDICA), 'pj.id_pessoa = p.id', array('nr_cnpj'))
                ->where('pa.id_empreendimento = ' . $contrato['id_empreendimento'])
                ->group('p.nm_pessoa')
                ->query()->fetchAll();
    
            $parcelaSelecionada = $tbParcelaHistorico->fetchAll("id_renegociacao = " . $negociacao['idNegociacao'], 'dt_parcela')->toArray();
            $listaNegociadas = $tbParcela->fetchAll("id_renegociacao = " . $negociacao['idNegociacao'], 'dt_parcela')->toArray();
    
            $this->set('negociacao', $negociacao);
            $this->set('parcelaSelecionada', $parcelaSelecionada);
            $this->set('listaNegociadas', $listaNegociadas);
            $this->set('qtdeParcelas', $qtdeParcelas);
            $this->set('assinaturas', $assinaturas);
            $this->set('parceria', $parceria);
            $this->set('pessoasEnvolvidas', $pessoas);
            $this->displayPDF("quitacao.pdf");
        } 
        // Modelo de quitao antigo
        else 
        {
            //valores a serem incrementados
            $total_pago = 0;
            $total_a_pagar = 0;
            $total_negociada["total"] = 0;
            $adapter = Pessoa::getDefaultAdapter();
            //quitacao
            $total_quitacao = $adapter->select()->from(TB_PARCELA, array('total' => 'count(*)'))->where("tp_parcela = 'Q'")->where('id_contrato = ?', $_GET['id'])->query()->fetch();
            //Redireciona para tela de listagem, caso nao tenha parcelas de quitacao
            if ($total_quitacao['total'] <= 0) {
                $this->redir(array("modulo" => "fin", "controller" => "quitacao", "action" => "listar"),array('exception'=>'O contrato no possui parcelas de quitaco'));
            } else {

                //sinal
                $total_sinal = $adapter->select()->from(TB_PARCELA, array('total' => 'count(*)'))->where("tp_parcela = 'S'")->where('id_contrato = ?', $_GET['id'])->query()->fetch();
                //intercalada
                $total_intercalada = $adapter->select()->from(TB_PARCELA, array('total' => 'count(*)'))->where("tp_parcela = 'I'")->where('id_contrato = ?', $_GET['id'])->query()->fetch();
                //chaves
                $total_chave = $adapter->select()->from(TB_PARCELA, array('total' => 'count(*)'))->where("tp_parcela = 'C'")->where('id_contrato = ?', $_GET['id'])->query()->fetch();

                $contrato = $this->tb_contrato->getDefaultAdapter()->select()
                    ->from(array('c' => TB_CONTRATO))
                    ->join(array('p' => TB_PESSOA), 'c.id_pessoa = p.id', 'p.nm_pessoa')
                    ->join(array('l' => TB_LOTES), 'c.id_lote = l.id', array('l.lote', 'l.quadra'))
                    ->join(array('e' => TB_EMPREENDIMENTO), 'l.id_empreendimento = e.id', array('e.nm_empreendimento', 'e.ds_path_logo'))
                    ->join(array('ph' => TB_PARCELA), 'ph.id_contrato = c.id', array('id_parcela', 'pago', 'tp_parcela', 'fl_quitado', 'SomaVlParcela' => 'sum(ph.vl_parcela)'))
                    ->where('c.id = ?', $_GET['id'])
                    ->where('ph.tp_parcela = ?', 'Q')
                    ->query()->fetch();
                $this->set('contrato', $contrato);

                $contratos = $this->tb_contrato->getDefaultAdapter()->select()
                    ->from(array('c' => TB_CONTRATO), array('*'))
                    ->join(array('p' => TB_PESSOA), 'c.id_pessoa = p.id', 'p.nm_pessoa')
                    ->join(array('l' => TB_LOTES), 'c.id_lote = l.id', array('l.lote', 'l.quadra'))
                    ->join(array('e' => TB_EMPREENDIMENTO), 'l.id_empreendimento = e.id', 'e.nm_empreendimento')
                    ->join(array('ph' => TB_PARCELA), 'ph.id_contrato = c.id', array('id_parcela', 'dt_parcela', 'pago', 'tp_parcela', 'ph.fl_quitado', 'vl_parcela', 'vl_total_pago'))
                    ->where('c.id = ?', $_GET['id'])
                    ->where('ph.tp_parcela = ?', 'Q')
                    ->query()->fetchAll();
                $this->set('contratos', $contratos); 

                $parcelaHistorico = $this->tb_parcelahistorico->getDefaultAdapter()->select()
                    ->from(array('phi' => TB_PARCELA_HISTORICO), array('id_contrato', 'pago', 'tp_parcela', 'fl_quitado', 'SomaVlParcelaHistorico' => 'sum(phi.vl_parcela)'))
                    ->join(array('c' => TB_CONTRATO), 'phi.id_contrato = c.id', array('*'))
                    ->where('phi.pago = ?', '0')
                    ->where('phi.fl_quitado = ?', '1')
                    ->where('phi.tp_parcela NOT IN ("E","NE","SE","IE","CE")')
                    ->where('c.id = ?', $_GET['id'])
                    ->query()->fetch();
                $this->set('parcelaHistorico', $parcelaHistorico);

                $rsItens = $this->tb_parcela->getDefaultAdapter()->select()
                    ->from(array('p' => TB_PARCELA), array('*'))
                    ->where('id_contrato = ?', $_GET['id'])
                    ->query()->fetchAll();

                $itens = array();
                foreach ($rsItens as $item) {

                    if ($item['tp_parcela'] == 'S' && $contrato['inclui_sinal_contrato'] == 0) {
                        continue;
                    }

                    switch ($item['tp_parcela']) {
                        case 'S':
                            $item['id_parcela'] = $item['id_parcela'] . "/" . $total_sinal["total"];
                            break;
                        case 'C':
                            $item['id_parcela'] = $item['id_parcela'] . "/" . $total_chave["total"];
                            break;
                        case 'I':
                            $item['id_parcela'] = $item['id_parcela'] . "/" . $total_intercalada["total"];
                            break;
                        case 'G':
                            $total_negociada = $adapter->select()->
                            from(TB_PARCELA, array('total' => 'count(*)'))->
                            where("tp_parcela = 'G'")->
                            where('id_contrato = ?', $_GET['id'])->
                            where("id_negociacao = {$item['id_negociacao']}")->
                            query()->fetch();
                            $item['id_parcela'] = $item['id_parcela'] . "/" . $total_negociada["total"];
                            break;
                        default:
                            $item['id_parcela'] = $item['id_parcela'] . "/" . $contrato["nr_parcela"];
                            break;
                        case 'Q':
                            $item['id_parcela'] = $item['id_parcela'] . "/" . $total_quitacao["total"];
                            break;
                    }

                    if (!$item["vl_parcela"])
                        $item["vl_parcela"] = 0.00;
                    if (!$item["acrescimo"])
                        $item["acrescimo"] = 0.00;
                    if (!$item["vl_juros"])
                        $item["vl_juros"] = 0.00;
                    if (!$item["vl_multa"])
                        $item["vl_multa"] = 0.00;
                    if (!$item["desconto"])
                        $item["desconto"] = 0.00;

                    if (($item['pago'] == 1) && ($item['tp_parcela'] != 'E' || $item['tp_parcela'] != 'SE' || $item['tp_parcela'] != 'NE' || $item['tp_parcela'] != 'IE' || $item['tp_parcela'] != 'CE')) {
                        $total_pago += $item['vl_parcela'];
                    } else if ($item['tp_parcela'] != 'E' || $item['tp_parcela'] != 'SE' || $item['tp_parcela'] != 'NE' || $item['tp_parcela'] != 'IE' || $item['tp_parcela'] != 'CE') {
                        $total_a_pagar += $item['vl_parcela'];
                    }

                    $itens[] = $item;
                }

                // testa se o valor e nulo para nao ter problemas com as operacoes
                if ($contrato['nr_parcela'] == null) {
                    $contrato['nr_parcela'] = 0.00;
                }
                if ($contrato['nr_parcela_sinal'] == null) {
                    $contrato['nr_parcela_sinal'] = 0.00;
                }
                if ($contrato['nr_parcela_entrega'] == null) {
                    $contrato['nr_parcela_entrega'] = 0.00;
                }
                if ($contrato['nr_intercalada'] == null) {
                    $contrato['nr_intercalada'] = 0.00;
                }
                if ($contrato['vl_parcela'] == null) {
                    $contrato['vl_parcela'] = 0.00;
                }
                if ($contrato['vl_parcela_sinal'] == null) {
                    $contrato['vl_parcela_sinal'] = 0.00;
                }
                if ($contrato['vl_parcela_entrega'] == null) {
                    $contrato['vl_parcela_entrega'] = 0.00;
                }
                if ($contrato['vl_intercalada'] == null) {
                    $contrato['vl_intercalada'] = 0.00;
                }
                $valor_inicial = $contrato['nr_parcela'] * $contrato['vl_parcela']
                    + $contrato['nr_intercalada'] * $contrato['vl_intercalada']
                    + $contrato['nr_parcela_entrega'] * $contrato['vl_parcela_entrega'];
                if ($contrato['inclui_sinal_contrato'] == 1) {
                    $valor_inicial += +$contrato['vl_sinal'];
                }
                //dados da empresa
                $tabAgrup = Db_TabelaAgrupada::findByField("idTabela", Db_TabelaAgrupada::TABLE_CLIENTE, "descricao");

                foreach ($tabAgrup as $tab) {
                    $header[$tab->getIdCampo()] = $tab->getDescricao();
                }

                $header['vl_inicial'] = number_format($valor_inicial, 2, ',', '.');
                $header['vl_pago'] = number_format($total_pago, 2, ',', '.');

                $total_quitado = 0;
                if ($contrato['tp_parcela'] == 'Q') {
                    $total_quitado += $contrato['SomaVlParcela'];
                }

                $total_devedor = 0;

                if ($parcelaHistorico['pago'] == '0' && $parcelaHistorico['fl_quitado'] == '1') {
                    $total_devedor += $parcelaHistorico['SomaVlParcelaHistorico'];
                }
                if ($total_quitado < $valor_inicial){
                    $descontoQuitacao = $total_devedor - $total_quitado;
                }

                $valorAcrescimo = 0;
                if ($valor_inicial < $total_quitado ){
                    $valorAcrescimo = $total_quitado - $valor_inicial;
                }

                $this->set("descontoQuitacao", $descontoQuitacao);
                $this->set("cabecalho", $header);
                $this->set("valores", $itens);
                $this->set("valorAcrescimo", $valorAcrescimo);

                $cliente = $this->tb_cliente->getAdapter()->select()
                    ->from(array('c' => TB_CLIENTE), array('cd_cliente', 'cd_municipio', 'nm_razao_social', 'ds_end_logomarca'))
                    ->joinLeft(array('m' => TB_CIDADE), 'm.id = c.cd_municipio', array('nome'))
                    ->query()->fetch();
                $this->set('cliente', $cliente);

                $this->set("data", ", " . date("d") . " de " . strtolower(Helper::getMes(date("m"))) . " de " . date("Y"));
                $this->displayPDF('Quitacao' . time() . '.pdf', true, 'P');
            }
        }
    }
    
    public function getObsQuitacaoAction(){

        if ($this->isAjax()) {
            $tb_contrato = new Contrato();
            $contrato = $tb_contrato->getAdapter()->select()
                ->from(array('c' => TB_CONTRATO), array('obsqui' => 'obs_quitacao'))
                ->where("c.id = ?", $_POST['contrato'])
                ->query()->fetch();
            
            echo json_encode($contrato);
        } else {
            return false;
        }

    }
    
    /**
     * Gera o word recebendo o modelo
     */
    
    public function gerarWordAction()
    {
        //Grava a operacao no log de contatos
        $tbModeloArquivo = new ModeloArquivo();
        $tipoModelo = $tbModeloArquivo->fetchRow("ds_path_modelo = '{$_POST['cdArquivo']}'");
        (new Relacionamento())->saveContato(13, date('Y-m-d'), $_POST['id_contrato'], "Log: Impresso quitao Word modelo: {$tipoModelo->nm_titulo}.");
        
        $templateProcessor = new \PhpOffice\PhpWord\TemplateProcessor(__ROOT__ . '/' . $_POST['cdArquivo']);
        
        $variaveis = $this->adicionarValoresTemplate($_POST['id_contrato'], $templateProcessor);
        
        $filename = 'emissaoQuitacao' . $_POST['id_contrato'] . '.docx';
        
        $variaveis['templateProcessor']->saveAs($filename);

        //gera o download automatico
        header('Content-Description: File Transfer');
        header('Content-Type: application/octet-stream');
        header('Content-Disposition: attachment; filename='.$filename);
        header('Content-Transfer-Encoding: binary');
        header('Expires: 0');
        header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
        header('Pragma: public');
        header('Content-Length: ' . filesize($filename));
        flush();
        //remove os arquivos temporarios
        readfile($filename);
        unlink($filename);
    }

}