<?php

class PesquisaTituloController extends Controller
{

    public function  __construct($request)
    {
        parent::__construct($request);
        $this->set('action', $this->_helper->getLink(array('m' => 'fin', 'c' => 'pesquisaTitulo')));
    }

    public function indexAction()
    {
        $this->redirect(array('m' => 'fin', 'c' => 'pesquisaTitulo', 'a' => 'pesquisar'));
    }

    public function pesquisarAction()
    {
        //Exibir contratos migrados
        $migradas = Db_Cliente::getCliente();
        $migradas = $migradas['fl_parcelas_migradas'];

        $this->set('flMigracao', $migradas);
        $this->display('pesquisar');
    }

    public function pesquisaTituloAction()
    {
        $parcelas = Parcela::getTitulos($_POST['numero'], $_POST['migradas']);
        
        $dados = array();
        
        if ($parcelas) {
            foreach($parcelas as $parcela) {
                $dados[] = array(
                    'numero' => $_POST['numero'],
                    'situacao' => utf8_encode($parcela['situacao']),
                    'empreendimento' => utf8_encode($parcela['nm_empreendimento']),
                    'idEmpreendimento' => $parcela['id'],
                    'cliente' => utf8_encode($parcela['nm_pessoa']),
                    'pago' => $parcela['pago'],
                    'lote' => utf8_encode($parcela['lote']),
                    'quadra' => utf8_encode($parcela['quadra']),
                    'num_contrato' => utf8_encode($parcela['id_contrato']),
                    'parcela' => utf8_encode($parcela['id_parcela']) . ' / ' . utf8_encode($parcela['nr_parcela']) . ' ' . utf8_encode($parcela['tp_parcela']),
                    'data' => Helper::getDate(utf8_encode($parcela['dt_parcela'])),
                    'valor' => utf8_encode($parcela['vl_parcela']),
                    'conta' => $parcela['conta_corrente'] . '-' . $parcela['conta_corrente_dv'],
                    'agencia' => $parcela['agencia'] . '-' .$parcela['agencia_dv'],
                    'nm_banco' => utf8_encode($parcela['descricao'])
                );
            } 
        }
        
        echo json_encode($dados);
    }
}