<?php

class ParcelaController extends Controller
{
    private $parcela;
    private $contrato;
    private $empreendimento;

    public function __construct($request)
    {
        parent::__construct($request);

        $this->parcela = new Parcela();
        $this->contrato = new Contrato();
        $this->empreendimento = new Empreendimento();
    }

    public function indexAction()
    {
        $this->redir(array('modulo' => 'fin', 'controller' => 'parcela', 'action' => 'gerarParcela'));
    }

    public function gerarParcelaAction()
    {
        $empreendimentos = $this->empreendimento->getDefaultAdapter()->select()
            ->from(array('e' => TB_EMPREENDIMENTO), array('e.nm_empreendimento', 'e.id'));

        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $empreendimentos->where("e.id IN({$id})");
                } else {
                    $empreendimentos->where("1");
                }
            } catch (Exception $e) {

            }
        }
        $empreendimentos = $empreendimentos->order('nm_empreendimento')->query()->fetchAll();

        $this->set('empreendimentos', $empreendimentos);

        if ($this->_isPost && $this->validar()) {
            $empreendimento = $_POST['empreendimento_gerar_parcela'];
            $contrato = $_POST['contrato_gerar_parcela'];

            if ($empreendimento)
                if ($empreendimento != '*')
                    $empreendimentos = array($this->empreendimento->fetchRow('id = ' . $empreendimento)->toArray());
                else
                    $empreendimentos = $this->empreendimento->fetchAll()->toArray();

            if ($contrato)
                if ($contrato != '*') {
                    $cont = Contrato::findById($contrato);
                    if ($cont['fl_aprovar_contrato'] == 1)
                        $contratos = array($cont);
                    else
                        $this->_helper->addMensagem('danger', 'Contrato no aprovado.');
                } else {
                    $contratos = array();
                    foreach ($empreendimentos as $emp)
                        $contratos = array_merge($contratos, Contrato::byEmpreendimento($emp['id'], Contrato::CONTRATO_NAO_GERADO, 2, null, true));
                }

            //No possui nenhuma parcela para gerar
            if (!isset($contratos) || count($contratos) == 0)
                $this->_helper->addMensagem('danger', 'No h parcelas a gerar.');
            else {
                foreach ($contratos as $cont)
                    Contrato::gerarParcela($cont['id']);
                $this->_helper->addMensagem('success', 'Parcelas geradas com sucesso!');
            }
        }
        $this->display();
    }

    // para gerar parcela
    public function contrato_by_empreendimentoAction()
    {
        $contratos = Contrato::byEmpreendimento($_POST['id_empreendimento'], Contrato::CONTRATO_NAO_GERADO, 2, array("nm_pessoa", "lote", "quadra", "id"), true);
        $lista = false;

        foreach ($contratos as $contrato) {
            $lista[] = array('id' => $contrato['id'], 'text' => utf8_encode($contrato['nm_pessoa']) . ' Quadra: ' . utf8_encode($contrato['quadra']) . ' - Lote: ' . utf8_encode($contrato['lote']));
        }
        echo json_encode($lista);
    }

    private function validar()
    {
        $campos = array("empreendimento_gerar_parcela", "contrato_gerar_parcela");

        $msg = '';
        $exibeMsg = false;

        foreach ($campos as $cp) {
            if ($_POST [$cp] == "") {
                switch ($cp) {
                    case "empreendimento_gerar_parcela" :
                        $msg .= "Selecione o Empreendimento.<br>";
                        break;
                    case "contrato_gerar_parcela" :
                        $msg .= "Selecione o Contrato.<br>";
                        break;
                }
                $exibeMsg = true;
            }
        }

        if ($exibeMsg)
            $this->_helper->addMensagem('danger', $msg);

        return !(count($this->_helper->getMensagens()) > 0);
    }
}
