<?php

class ParcelaAvulsaExclusaoController extends Controller
{

    protected $tbParcela;
    protected $tbContrato;
    protected $tbParcelaHistorico;

    public function __construct($request)
    {
        parent::__construct($request);
        $this->tbParcela = new Parcela();
        $this->tbContrato = new Contrato();
        $this->tbParcelaHistorico = new ParcelaHistorico();
    }

    public function indexAction()
    {
        $empreendimento = new Empreendimento();

        $empreendimentos = $empreendimento->getEmpreendimentos();

        $this->set('empreendimentos', $empreendimentos);

        $this->display('index');
    }

    public function removerAction()
    {
        try {
            $parcela = (new Parcela)->parcelaById($_POST['idParcelaAvulsa']);
            $contrato = (new Contrato)->getContrato($parcela['id_contrato']);

            $contratoHistorico = new ContratoHistorico();
            $contratoHistorico = $contratoHistorico->getDefaultAdapter()->select()
                ->from(array('c' => TB_CONTRATO_HISTORICO), 'id')
                ->where('c.id = ' . $parcela['id_contrato'])
                ->query()->fetch();
            
            if (!$contratoHistorico)
            {
                //inicia transao com o banco de dados para salvar o contrato no contrato historico.
                $tableContratoHistorico = Zend_Db_Table::getDefaultAdapter();
                $tableContratoHistorico->insert(TB_CONTRATO_HISTORICO, $contrato);
            }

            $parcela['dt_parcela'] = Helper::dataParaAmericano($parcela['dt_parcela']);
            
            $salvaParcelaNoHistorico = $this->tbParcelaHistorico->createRow();
            $salvaParcelaNoHistorico->id_parcela_contrato = $parcela['id_parcela_contrato'];
            $salvaParcelaNoHistorico->id_parcela = $parcela['id_parcela'];
            $salvaParcelaNoHistorico->id_contrato = $parcela['id_contrato'];
            $salvaParcelaNoHistorico->id_banco = $parcela['id_banco'];
            $salvaParcelaNoHistorico->id_banco_boleto = $parcela['id_banco_boleto'];
            $salvaParcelaNoHistorico->id_remessa = $parcela['id_remessa'];
            $salvaParcelaNoHistorico->id_negociacao = $parcela['id_negociacao'];
            $salvaParcelaNoHistorico->id_renegociacao = $parcela['id_renegociacao'];
            $salvaParcelaNoHistorico->id_parcela_contrato_antigo = $parcela['id_parcela_contrato_antigo'];
            $salvaParcelaNoHistorico->id_taxa = $parcela['id_taxa'];
            $salvaParcelaNoHistorico->nr_boleto = $parcela['nr_boleto'];
            $salvaParcelaNoHistorico->increment_id = $parcela['increment_id'];
            $salvaParcelaNoHistorico->acrescimo = $parcela['acrescimo'];
            $salvaParcelaNoHistorico->desconto = $parcela['desconto'];
            $salvaParcelaNoHistorico->dt_parcela = $parcela['dt_parcela'] = Helper::dataParaAmericano($parcela['dt_parcela']);
            $salvaParcelaNoHistorico->dt_pagamento = $parcela['dt_pagamento'];
            $salvaParcelaNoHistorico->dt_credito = $parcela['dt_credito'];
            $salvaParcelaNoHistorico->dt_parcela_2avia = $parcela['dt_parcela_2avia'];
            $salvaParcelaNoHistorico->vl_parcela = $parcela['vl_parcela'];
            $salvaParcelaNoHistorico->vl_parcela_2avia = $parcela['vl_parcela_2avia'];
            $salvaParcelaNoHistorico->vl_juros = $parcela['vl_juros'];
            $salvaParcelaNoHistorico->vl_multa = $parcela['vl_multa'];
            $salvaParcelaNoHistorico->vl_total_pago = $parcela['vl_total_pago'];
            $salvaParcelaNoHistorico->tp_parcela = $parcela['tp_parcela'];
            $salvaParcelaNoHistorico->fl_envio = $parcela['fl_envio'];
            $salvaParcelaNoHistorico->pago = $parcela['pago'];
            $salvaParcelaNoHistorico->tp_baixa = $parcela['tp_baixa'] ? $parcela['tp_baixa'] : null;
            $salvaParcelaNoHistorico->fl_quitado = $parcela['fl_quitado'];
            $salvaParcelaNoHistorico->fl_reajustavel = $parcela['fl_reajustavel'];
            $salvaParcelaNoHistorico->log = $parcela['log'];
            $salvaParcelaNoHistorico->obs = $parcela['obs'];
            $salvaParcelaNoHistorico->obs_baixa = $parcela['obs_baixa'];
            $salvaParcelaNoHistorico->save();
            //Antes de redirecionar grava o resultado no log dos contatos realizados como excluso de parcela avulsa.
            (new Relacionamento())->saveContato(141, date('Y-m-d'), $parcela['id_contrato'], 'Log: Excluda parcela avulsa de vencimento: ' . Helper::dataParaBrasil($parcela['dt_parcela']). ' no valor de R$' . $parcela['vl_parcela']);
            //remove a parcela, que foi salva anterior mente no histrico.
            $removeParcela = $this->tbParcela->delete($this->tbParcela->getAdapter()->quoteInto('id_parcela_contrato = ?', $parcela['id_parcela_contrato']));

            if ($salvaParcelaNoHistorico && $removeParcela)
            {
                echo json_encode(true);
            }

        } catch (Exception $e) {
            echo json_encode(false);
        }
        
    }

    public function parcelaAvulsaByContratoAction()
    {
        $parcelas = $this->tbParcela->getAdapter()->select()
            ->from(array('p' => TB_PARCELA), array('id_parcela_contrato', 'id_parcela', 'tp_parcela', 'dt_parcela',
            'acrescimo', 'desconto', 'vl_parcela', 'dt_pagamento', 'dt_credito', 'vl_juros', 'vl_multa',
            'vl_total_pago', 'tp_baixa', 'id_negociacao', 'id_banco','obs_baixa','dt_parcela_2avia'))
            ->where('p.id_contrato = ?', $_POST['idContrato'])
            ->where('p.tp_parcela = "A"' )
            ->where('p.pago = "0"')
            ->query()->fetchAll();

        $lista = array();

        foreach ($parcelas as $parcela)
        {
            $lista[] = array('id' => $parcela['id_parcela_contrato'], 'text' => 'Parcela: ' . $parcela['id_parcela'].''.$parcela['tp_parcela'].' - Data de Venc.: '. Helper::dataParaBrasil($parcela['dt_parcela']));
        }

        echo json_encode($lista);
    }

    //Busca os contrato com parcelas avulsas de acordo com o id do empreendimento.
    public function buscarContratoPorEmpreendimentoAction () {

        $contratos = $this->tbContrato->getDefaultAdapter()->select()
        ->from(array('c' => TB_CONTRATO), array('c.id as id', 'c.id_pessoa', 'c.fl_distrato', 'id_banco'))
        ->join(array('pa' => TB_PARCELA), 'c.id = pa.id_contrato', array('id_parcela_contrato'))
        ->join(array('l' => TB_LOTES), 'c.id_lote = l.id', array('l.id as id_lote', 'quadra', 'lote'))
        ->join(array('e' => TB_EMPREENDIMENTO), 'l.id_empreendimento = e.id', array('e.id as id_empreendimento'))
        ->join(array('p' => TB_PESSOA), 'p.id = c.id_pessoa', array('p.nm_pessoa'))
        ->where('e.id = "' . $_POST['id_empreendimento'] . '"')
        ->where('pa.tp_parcela = "A"')
        ->where('pa.pago = "0"')
        ->query()->fetchAll();

        foreach ($contratos as $contrato) {
            $lista[] = array('id' => $contrato['id'], 'text' => utf8_encode($contrato['nm_pessoa']) . ' - Quadra: ' . utf8_encode($contrato['quadra']) . ' - Lote: ' . utf8_encode($contrato['lote']) . ' - Contrato: ' . utf8_encode($contrato['id']));
        }

        echo json_encode($lista);
    }
}