<?php

class ParcelaAvulsaController extends Controller
{
    public function indexAction()
    {
        $this->redir(array("modulo" => "fin", "controller" => "parcelaAvulsa", "action" => "gerar"));
    }

    public function gerarAction()
    {
        $empreendimentos = new Empreendimento();
        $empreendimentos = $empreendimentos->getEmpreendimentos();
        $this->set('empreendimentos', $empreendimentos);
        $this->set('taxas', (new Taxa())->fetchAll());

        if ($this->_isPost && $this->validar()) {
            try {
                //Verifica se possui todos contratos selecionado
                $todosContratos = false;
                foreach ($_POST['idContrato'] as $c) {
                    if ($c == '*') {
                        $todosContratos = true;
                    }
                }
                //Busca lista de contratos
                if ($todosContratos) {
                    $contratos = (new Contrato())->byEmpreendimento($_POST['idEmpreendimento'], 3, 0, 'nm_pessoa', 1);
                } else {
                    $contratos = (new Contrato())->fetchAll('id IN ("'.implode('","',$_POST['idContrato']).'")');
                }
                $taxa = (new Taxa())->fetchRow('id_taxa = '.$_POST['idTaxa']);
                //Criando as parcelas avulsas para cada contrato
                foreach ($contratos as $c) {
                    $dtParcela = explode('-', Helper::getInputDate($_POST['dtVencimento']));
                    $year = $dtParcela[0];
                    $month = $dtParcela[1];
                    $day = $dtParcela[2];
                    $nmParcela = '';
                    //Salvando todas parcelas em cada contrato
                    for ($i = 1; $i <= $_POST['qtdeParcela']; $i++) {
                        //Buscando a data do prximo ms para utilizar em cada parcela
                        if ($i != 1) {
                            $dtParcela = explode('-', $dtParcela);
                            $year = $dtParcela[0];
                            $month = $dtParcela[1];
                            $dtParcela = Helper::getNextMonth($year.'-'.$month.'-'.$day);
                        } else {
                            $dtParcela = $year.'-'.$month.'-'.$day;
                        }
                        $nmParcela .= $i.'A ';
                        $parcela = new Parcela();
                        $parcela = $parcela->createRow();
                        $parcela->id_parcela = $i;
                        $parcela->id_contrato = $c['id'];
                        $parcela->id_taxa = $_POST['idTaxa'];
                        $parcela->vl_parcela = Helper::getInputMoney($_POST['vlParcela']);
                        $parcela->vl_parcela_2avia = null;
                        $parcela->dt_parcela = $dtParcela;
                        $parcela->tp_parcela = 'A';
                        $parcela->fl_reajustavel = '0';
                        $parcela->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - i');
                        $parcela->obs = $taxa['ds_taxa'].' no valor de '.$_POST['vlParcela'];
                        $parcela->save();
                    }
                    (new Relacionamento())->saveContato(64, date('Y-m-d'), $c['id'], 'Log: Criado Parcela Avulsa de '.$taxa['ds_taxa'].' com Vencimento Inicial '.$_POST['dtVencimento']. ' de Valor '.$_POST['vlParcela'].' Parcelas: '.$nmParcela);
                }
                //Antes de redirecionar grava o resultado no log dos contatos realizados como Baixa de parcela.
                echo json_encode(array('msgSucess' => true, 'msgErros' => ''));
            } catch (Exception $e) {
                echo json_encode(array('msgSucess' => false, 'msgErros' => utf8_encode($e->getMessage())));
                exit;
            }
        } else {
            $this->display();
        }
    }

    public function findContratoTaxaAction()
    {
        //Busca lista de contratos
        $contratos = (new Contrato())->byEmpreendimento($_POST['idEmpreendimento'], '1', '0', 'nm_pessoa', '1');
        $listaContrato[] = array('id' => '*', 'text' => 'Todos');
        foreach ($contratos as $c) {
            $listaContrato[] = array('id' => $c['id'], 'text' => utf8_encode($c['nm_pessoa']) . ' - Qd: ' . utf8_encode($c['quadra']) . ' - Lt: ' . utf8_encode($c['lote']) . ' Contrato: ' . $c['id']);
        }

        //formato para funcao preencher
        $listaGeral[] = array('receptor'=>'idContrato', 'lista'=>$listaContrato);

        echo json_encode($listaGeral);
    }

    public function findValorTaxaAction()
    {
        //Busca lista de contratos
        $taxa = (new TaxaValor())->fetchRow('id_taxas = '.$_POST['idTaxa'])->toArray();
        $taxa['vl_taxa'] = Helper::getMoney($taxa['vl_taxa']);
        echo json_encode($taxa);
    }

    public function validar()
    {
        $campos = array("idEmpreendimento", "idTaxa", "idContrato", 'dtVencimento', 'vlParcela');
        foreach ($campos as $cp) {
            if ($_POST [$cp] == "") {
                $msg = '';
                switch ($cp) {
                    case "idEmpreendimento" :
                        $msg = "O campo <b>Empreendimento</b>  obrigatrio";
                        break;
                    case "idTaxa" :
                        $msg = "O campo <b>Tipo de Taxa</b>  obrigatrio";
                        break;
                    case 'idContrato':
                        $msg = "O campo <b>Contrato</b>  obrigatrio";
                        break;
                    case 'dtVencimento':
                        $msg = "O campo <b>Data de Vencimento</b>  obrigatrio";
                        break;
                    case 'vlParcela':
                        $msg = "O campo <b>Valor do Ttulo</b>  obrigatrio";
                        break;
                }
                $this->_helper->addMensagem($cp, $msg);
            }
        }
        //Alterada validao, para verificar as informaes agora pelo AJAX
        if (count($this->_helper->getMensagens()) > 0) {
            $msgErros = '';
            foreach ($this->_helper->getMensagens() as $msg => $a)
                $msgErros .= utf8_encode($a) . '<br>';
            echo json_encode(array('msgErros' => $msgErros));
            exit;
        } else {
            return true;
        }
    }
}