<?php

class NegociacaoController extends Controller
{
    public function __construct($request)
    {

        parent::__construct($request);
        $this->empreendimento = new Empreendimento();
        $this->contrato = new Contrato();
        $this->lote = new Lote();

    }

    public function indexAction()
    {
        $this->redir(array("modulo" => "fin", "controller" => "negociacao", "action" => "listar"));
    }

    public function listarAction()
    {
        if ($this->isAjax()) {
            $listaItem = Negociacao::findLista($_POST);
            $totalItens = Negociacao::findLista($_POST, true);

            $lista = array();
            foreach ($listaItem as $item) {
                $acoes = '<div style="width: 90px"></div><div align="center" style="width: 100%;">';
                $acoes .= '<button type="button" onClick="gerarPago(' . $item['id'] . ')" value="' . $item['id'] . '" data-target=".modalGerarPago" data-toggle="modal" title="GERAR" class="btn btn-default btn-sm btn-gerar-pago" style="margin-right:5px"><i data-toggle="tooltip" title="GERAR" class="fa fa-file-o"></i>
                </button></span>';
                $title = "return confirm('Tem certeza que deseja excluir a negociao " . $item['id'] . " em nome de " . $item['nm_pessoa'] . " do Contrato " . $item['id_contrato'] . "?')";
                $acoes .= '<a onclick="' . $title . '"  href="index.php?m=' . $this->modulo . '&c=' . $this->controller . '&a=desfazer&id=' . $item['id'] . '" data-toggle="tooltip" title="DESFAZER" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-times"></i></a>';
                $acoes .= '</div>';
                $acoes .= '</div>';

                //Defini o valor de tipo, para exibir na tela!
                $tipo = "NEG.";
                if ($item['tp_operacao'] == 'R'){
                    $tipo = "REF.";
                }

                //Para ordenar por data
                $data = '<div hidden>' . $item['data'] . '</div>' . Helper::getDate($item['data']);
                $dataBase = '<div hidden>' . $item['dataBase'] . '</div>' . Helper::getDate($item['dataBase']);

                $lista[] = array(
                    'codigo' => utf8_encode($item['id']),
                    'empreendimento' => utf8_encode($item['nm_empreendimento']),
                    'quadra' => utf8_encode($item['quadra']),
                    'lote' => utf8_encode($item['lote']),
                    'cliente' => utf8_encode($item['nm_pessoa']),
                    'contrato' => utf8_encode($item['id_contrato']),
                    'tipo' => utf8_encode($tipo),
                    'data' => $data,
                    'dt_calculo' => $dataBase,
                    'acoes' => utf8_encode($acoes)
                );
            }
            echo json_encode(array(
                'draw' => $_POST['draw'],
                'recordsTotal' => count($totalItens),
                'recordsFiltered' => count($totalItens),
                'data' => $lista
            ));

        } else {
            $this->display('listar');
        }
    }

    public function adicionarAction()
    {
        $this->redir(array("modulo" => "fin", "controller" => "negociacao", "action" => "passo1"));
    }

    public function passo1Action()
    {
        if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'adicionarNegociacao')) {
            $this->redir(array('modulo' => 'fin', 'controller' => 'negociacao', 'action' => 'listar'), array('msgErros' => 'fail', 'danger' => 'Voc no tem permisso para acessar essa funcionalidade.'));
        }

        //instancia necessarias
        $tbEmpreendimento = new Empreendimento();
        $tb_parcela = new Parcela();
        $tbComissao = new ComissaoLancamento();

        if ($_GET['idContrato'] != null && $_GET['idEmpreendimento'] != null) {

            $contratos = Contrato::byEmpreendimento($_GET['idEmpreendimento'], Contrato::CONTRATO_GERADO, 0, array("nm_pessoa", "lote", "quadra", "id"), true);

            $lista = array();
            foreach ($contratos as $contrato) {
                //Metodo encontrado para gerar um cor no nome do valor na lista do select2!
                if ($contrato['fl_distrato'] == '1')
                    $color = 'color: red;';
                else
                    $color = null;

                $lista[] = array('id' => $contrato['id'], 'text' => $contrato['nm_pessoa'] . ' Quadra: ' . $contrato['quadra'] . ' - Lote: ' . $contrato['lote'] . ' - Contrato: ' . $contrato['id'], 'estilo' => $color);
            }

            $this->set('contratos', $lista);

        }

        $this->set('empreendimentos', $tbEmpreendimento->getEmpreendimentos());

        if ($this->_isPost && $this->validar(1)) {
            $hoje = date('Y-m-d');
            //busca as parcelas atrasadas
            if ($_POST['tipo'] == 'N' && $_POST['tipos'] == 'A' && $_POST['sinal'] == 'N') {
                $parcelas = $tb_parcela->fetchAll("id_contrato = {$_POST['negociacao_contrato']} and dt_parcela < '$hoje' and pago = '0' and (tp_parcela NOT IN ('E', 'NE', 'SE', 'CE', 'IE', 'A', 'S'))", 'dt_parcela')->toArray();
            } 
            elseif ($_POST['tipo'] == 'N' && $_POST['tipos'] == 'A' && $_POST['sinal'] == 'S') {
                $parcelas = $tb_parcela->fetchAll("id_contrato = {$_POST['negociacao_contrato']} and dt_parcela < '$hoje' and pago = '0' and (tp_parcela NOT IN ('E', 'NE', 'SE', 'CE', 'IE', 'A'))", 'dt_parcela')->toArray();
            } 
            elseif($_POST['tipo'] == 'N' && $_POST['tipos'] == 'T' && $_POST['sinal'] == 'N') {
                
                $parcelas = $tb_parcela->fetchAll("id_contrato = {$_POST['negociacao_contrato']} and pago = '0' and (tp_parcela NOT IN ('E', 'NE', 'SE', 'CE', 'IE', 'A', 'S'))", 'dt_parcela')->toArray();
            } else{
                $parcelas = $tb_parcela->fetchAll("id_contrato = {$_POST['negociacao_contrato']} and pago = '0' and (tp_parcela NOT IN ('E', 'NE', 'SE', 'CE', 'IE', 'A'))", 'dt_parcela')->toArray();
            }
            if ($_POST['tipo'] == 'N' && $_POST['tipos'] == 'T'){
                $nrParcelas = $tb_parcela->fetchAll("id_contrato = {$_POST['negociacao_contrato']} and pago = '0' and (tp_parcela NOT IN ('E', 'NE', 'SE', 'CE', 'IE', 'A', 'S'))", 'dt_parcela')->toArray();
            }
            if (!$parcelas && !$nrParcelas) {
                $this->_helper->addMensagem('danger', 'No existem parcelas atrasadas para esse contrato');
            } else {
                //busca os contratos a serem ajustados no mes e ano especificados
                $pessoa = $tbEmpreendimento->getDefaultAdapter()->select()
                    ->from(array('p' => TB_PESSOA), 'nm_pessoa')
                    ->join(array('c' => TB_CONTRATO), 'p.id = c.id_pessoa', null)
                    ->where("c.id = " . $_POST['negociacao_contrato'])
                    ->query()->fetch();

                //Busca informacoes adicionais para tela.
                $infoContrato = $this->contrato->getDefaultAdapter()->select()
                    ->from(array('c' => TB_CONTRATO), array('c.id', 'c.id_lote'))
                    ->join(array('l' => TB_LOTES), 'l.id = c.id_lote', array('lote', 'quadra'))
                    ->where('c.id = ' . $_POST['negociacao_contrato'])
                    ->query()->fetch();

                //Consulta para pegar o numero maximo de parcelas!
                $nr_parcela_empredimento = $tbEmpreendimento->fetchRow('id = '.$_POST['negociacao_empreendimento'])->toArray();

                //Salva os dados e repassa adiante, para a proxima tela!
                $contrato["nm_pessoa"] = $pessoa['nm_pessoa'];
                $contrato["quadra"] = $infoContrato['quadra'];
                $contrato["lote"] = $infoContrato['lote'];
                $contrato["numero"] = $_POST['negociacao_contrato'];
                $contrato["tipo"] = $_POST['tipo'];
                $contrato["tipos"] = $_POST['tipos'];
                $contrato["maxParcelasEmp"] = $nr_parcela_empredimento['max_parcela'];
                
                $_SESSION['contrato'] = $contrato;
                $_SESSION['parcelas'] = $parcelas;
                
                // Verifica cadastro de comisso parcela no Vendas e despeja um "ateno"
                $warning = [];
                $comissaoVendas = $tbComissao->getDefaultAdapter()->select()
                    ->from(['c' => TB_COMISSAO_LANCAMENTO], '')
                    ->join(['cp' => TB_COMISSAO_PAGAMENTO], 'cp.id_comissao_lanc = c.id', ['id_parcela'])
                    ->where("id_contrato = {$_POST['negociacao_contrato']}")->query()->fetch();

                if ($comissaoVendas) {
                    $warning = ['warning' => 'H parcelas de comisso no Acade Vendas vinculada a este contrato. Favor refazer a comisso logo aps finalizar este procedimento.'];
                }
                $this->redirect(array('m' => 'fin', 'c' => 'negociacao', 'a' => 'passo2'), $warning);
            }
        } else {
            if (isset($_GET['formExpired'])) {
                $this->_helper->addMensagem('warning', 'Inicie todo o processo novamente!');
            }
        }        
        $this->display('passo1');
    }

    public function passo2Action()
    {
        //instancia as classes necessarias
        $adapter = Empreendimento::getDefaultAdapter();
        $contrato = $_SESSION['contrato'];
        
        if (!$contrato) {
            $this->redirect(array('m' => 'fin', 'c' => 'negociacao', 'a' => 'passo1'), array('formExpired' => 'Inicie todo processo novamente!'));
        } elseif ($this->_isPost) {
            
            if ($this->validar(2)) {
                $ids = '';
                foreach ($_POST['parcelas'] as $p) {
                    $ids .= "'$p',";
                }
                $ids = substr($ids, 0, -1);

                //calculo dos juros
                $idParcela = $_POST['parcelas'][0];
                $dataBase = $_POST['dataBase'];

                $taxas = $adapter->select()
                    ->from(['p' => TB_PARCELA], '')
                    ->join(['c' => TB_CONTRATO], 'p.id_contrato = c.id', '')
                    ->join(['l' => TB_LOTES], 'c.id_lote = l.id', '')
                    ->join(['e' => TB_EMPREENDIMENTO], 'l.id_empreendimento = e.id', '')
                    ->join(['b' => TB_BANCO], 'c.id_banco = b.id', ['b.juros', 'b.multa', 'tp_juros', 'tp_multa'])
                    ->join(['b2' => TB_BANCO], 'b2.id_empreendimento = e.id', '')
                    ->where('p.id_parcela_contrato = ' . $idParcela)
                    ->query()->fetch();
                
                $parcelas = $adapter->select()
                    ->from(array('p' => TB_PARCELA), array('*', 'dif' => '(DATEDIFF("' . Helper::getInputDate($dataBase) . '",dt_parcela))'))
                    ->where("id_parcela_contrato in ($ids) ")
                    ->order('dt_parcela ASC')
                    ->query()->fetchAll();

                $contrato["total"] = 0;
                $vlmulta = 0;
                $vljuros = 0;
                $vlparcela = 0;

                foreach ($parcelas as $k => $p) {
                    
                    $multa = 0;
                    $juros = 0;

                    $p['dif'] = ($p['dif'] > 0) ? $p['dif'] : 0;

                    if ($taxas['tp_juros'] != 'S') {
                        $juros = ($taxas['tp_juros'] == 'P') ? ($taxas['juros'] / 100) * $p['vl_parcela'] : $taxas['juros'];
                        $juros = $p['dif'] * $juros;
                    }

                    if ($p['dif'] > 0 && $taxas['tp_multa'] != 'S') {
                        $multa = ($taxas['tp_multa'] == 'P') ? ($taxas['multa'] / 100) * $p['vl_parcela'] : $taxas['multa'];
                    }
                    
                    $total = (round($p['vl_parcela'], 2) + round($juros, 2) + round($multa, 2));
                    $vlparcela += (round($p['vl_parcela'], 2));
                    $vljuros += (round($juros, 2));
                    $vlmulta += (round($multa, 2));

                    $parcelas[$k]['vl_juros'] = Helper::getMoney($juros);
                    $parcelas[$k]['vl_multa'] = Helper::getMoney($multa);
                    $parcelas[$k]['juros'] = Helper::getMoney($juros);
                    $parcelas[$k]['multa'] = Helper::getMoney($multa);
                    $parcelas[$k]['total'] = Helper::getMoney($total);
                    $parcelas[$k]['dias'] = $p['dif'];
                    $parcelas[$k]['dt_parcela'] = $p['dt_parcela'];
                    $parcelas[$k]['desconto'] = $p['desconto'] != null ? $p['desconto'] : '0,00';
                    $parcelas[$k]['acrescimo'] = $p['acrescimo'] != null ? $p['acrescimo'] : '0,00';

                    $contrato["total"] += $total;
                }
                
                $valoresSomados = array(
                    'vl_parcelas' => $vlparcela,
                    'vl_juros' =>  $vljuros,
                    'vl_multa' => $vlmulta
                );
                //Salva os dados e repassa adiante, para a proxima tela!
                $_SESSION['contrato']['valoresSomados'] = $valoresSomados;
                $_SESSION['contrato']['total'] = Helper::getMoney($contrato["total"]);
                $_SESSION['contrato']["data"] = $dataBase;
                $_SESSION['contrato']["parcelas"] = $parcelas;
                $_SESSION['contrato']["descontoBoleto"] = $_POST['descontoBoleto'];

                $this->redirect(array('m' => 'fin', 'c' => 'negociacao', 'a' => 'passo3'));
            }
        }
        
        $txJuros = (new Contrato())->getTabelaPrice($contrato['numero']);
        //Essa varivel e o for serven para verificar se dentre todas as parcelas, existe pelo menos uma com a data superior  data atual,
        //caso sim a opo de usar o desconto da tabela price aparece para o cliente.
        $possuiDesconto = false;
        foreach ($_SESSION['parcelas'] as $parcela) {
            if (strtotime($parcela['dt_parcela']) > strtotime(date('Y-m-d'))) {
                $possuiDesconto = true;
                break;
            }
        }

        $this->set('valoresSomados', $_SESSION['valoresSomados']);
        $this->set('contrato', $_SESSION['contrato']);
        $this->set('parcelas', $_SESSION['parcelas']);
        $this->set('txJuros', $txJuros);
        $this->set('possuiDesconto', $possuiDesconto);
        $this->display('passo2');
    }

    public function passo3Action()
    {
        $contrato = $_SESSION['contrato'];

        if (!$contrato) {
            $this->redirect(array('m' => 'fin', 'c' => 'negociacao', 'a' => 'passo1'), array('formExpired' => 'Inicie todo processo novamente!'));
        } elseif ($this->_isPost) {
            if ($this->validar(3)) {
                $i = 0;
                //$total = $_SESSION['contrato']["descontoBoleto"] == 'S' ? Helper::getInputMoney2($_POST['total']) : Helper::getInputMoney($_POST['total']);
                $total = Helper::getInputMoney($_POST['total']);
                $parcs = explode(':', $_POST['parcelas']);

                $parcelas = $_SESSION['contrato']['parcelas'];
 
                foreach ($parcs as $p) {
                    $parcelas[$i]['acrescimo'] = Helper::getInputMoney($_POST["acrescimo_$p"]);
                    $parcelas[$i]['desconto'] = Helper::getInputMoney($_POST["desconto_$p"]);
                    $parcelas[$i]['multa'] = Helper::getInputMoney($_POST["multa_$p"]);
                    $parcelas[$i]['juros'] = Helper::getInputMoney($_POST["juros_$p"]);
                    $i++;
                }
                
                $valorParcela = (float)$total / (int)$_POST['vezes'];

                $valorRestante = (float)$total;
                for ($i = 1; $i <= $_POST['vezes']; $i++) {
                    //Vai diminuindo o valor da parcela do total para setar o restante na ultima parcela
                    if ($i == $_POST['vezes']) {
                        $valorParcela = $valorRestante;
                    } else {
                        $valorRestante -= Helper::getInputMoney(Helper::getMoney($valorParcela));
                    }
                    $inputData = Helper::getInputDate($_POST['dtPrimParc']);
                    $novasParcelas[$i]['dt_parcela'] = ($i == 1) ? $_POST['dtPrimParc'] : Helper::getDate(Helper::getNextMonth($inputData, $i-1));
                    $novasParcelas[$i]['vl_parcela'] = Helper::getMoney($valorParcela);
                }
                //Salva os dados e repassa adiante, para a proxima tela!
                $_SESSION['contrato']['parcelas'] = $parcelas;
                $_SESSION['contrato']['parcelasNovas'] = $novasParcelas;
                $_SESSION['contrato']['idsParcelas'] = $parcs;
                $_SESSION['contrato']['total'] = Helper::getMoney($total);
                $_SESSION['contrato']['valoresSomados'] = $contrato['valoresSomados'];

                $this->redirect(array('m' => 'fin', 'c' => 'negociacao', 'a' => 'passo4'));
            }
        }
        //remover a condio para verificar se  super usurio aps a atualizao
        if ($_SESSION['contrato']["descontoBoleto"] == 'S' && $_SESSION['contrato']['tipo'] == 'N') {
            
            $contrato["total"] = 0;
            $vlmulta = 0;
            $vljuros = 0;
            $vlparcela = 0;

            $adapter = Empreendimento::getDefaultAdapter();
            
            $taxas = $adapter->select()
                ->from(array('b' => TB_BANCO), array('multa', 'juros', 'tp_juros', 'tp_multa'))
                ->join(array('e' => TB_EMPREENDIMENTO), 'e.id = b.id_empreendimento', null)
                ->join(array('l' => TB_LOTES), 'l.id_empreendimento = e.id', null)
                ->join(array('c' => TB_CONTRATO), 'c.id_lote = l.id', null)
                ->join(array('p' => TB_PARCELA), 'p.id_contrato = c.id', null)
                ->where("id_parcela_contrato = " . $_SESSION['contrato']['parcelas'][0]['id_parcela_contrato'])->query()->fetch();
                
            foreach ($contrato['parcelas'] as $k => $p) {
                
                $multa = 0;
                $juros = 0;

                $p['dif'] = ($p['dif'] > 0) ? $p['dif'] : 0;
                //If para calcular o desconto da quitao, caso o cliente escolha calcular no Passo 2, pela Tabela PRICE.
                if ($taxas['tp_juros'] != 'S') {
                    $juros = ($taxas['tp_juros'] == 'P') ? ($taxas['juros'] / 100) * $p['vl_parcela'] : $taxas['juros'];
                    $juros = $p['dif'] * $juros;
                }

                if ($p['dif'] > 0 && $taxas['tp_multa'] != 'S') {
                    $multa = ($taxas['tp_multa'] == 'P') ? ($taxas['multa'] / 100) * $p['vl_parcela'] : $taxas['multa'];
                }
                
                $vlparcela += (round($p['vl_parcela'], 2));
                $vljuros += (round($juros, 2));
                $vlmulta += (round($multa, 2));

                $contrato['parcelas'][$k]['vl_juros'] = Helper::getMoney($juros);
                $contrato['parcelas'][$k]['vl_multa'] = Helper::getMoney($multa);
                $contrato['parcelas'][$k]['juros'] = Helper::getMoney($juros);
                $contrato['parcelas'][$k]['multa'] = Helper::getMoney($multa);
                $contrato['parcelas'][$k]['dias'] = $p['dif'];
                $contrato['parcelas'][$k]['dt_parcela'] = $p['dt_parcela'];

                //Aplica o desconto sob a tabela PRICE somente se a parcela no for vencida.
                if(($contrato['parcelas'][$k]['juros'] > 0)||($contrato['parcelas'][$k]['vl_multa'] > 0 )){
                    $contrato['parcelas'][$k]['desconto'] = $p['desconto'];
                }else{
                    $dadosParcela = Contrato::descontoQuitacao($_SESSION['contrato']['data'],$p['id_parcela_contrato']);
                    $contrato['parcelas'][$k]['desconto'] = $dadosParcela['desconto'];
                }
                $total = (round($p['vl_parcela'], 2) - round($contrato['parcelas'][$k]['desconto'], 2) + round($p['acrescimo'], 2) + round($juros, 2) + round($multa, 2));
                //$contrato['parcelas'][$k]['total'] = Helper::getMoney($total); 
                $contrato['parcelas'][$k]['acrescimo'] = $p['acrescimo'];
                
                $contrato["total"] += $total;
            }
        }
        
        $this->set('valoresSomados', $_SESSION['valoresSomados']);
        $this->set('contrato', $contrato);
        $this->display('passo3');
    }


    public function passo4Action()
    {
        //instancia as classes necessarias
        $tb_parcNegociada = new ParcelaNegociada();

        $contrato = $_SESSION['contrato'];

        if (!$contrato) {
            $this->redirect(array('m' => 'fin', 'c' => 'negociacao', 'a' => 'passo1'), array('formExpired' => ''));
        } elseif ($this->_isPost) {
            if ($this->validar(4)) {
                $tb_parcela = new Parcela();
                $tb_negociacao = new Negociacao();
                $tbContrato = new Contrato();
                $tbContratoHistorico = new ContratoHistorico();

                $db = Zend_Db_Table::getDefaultAdapter();
                $db->beginTransaction();

                try {
                    $parcs = $_SESSION['contrato']['idsParcelas'];
                    if (strstr($_SESSION['contrato']['idsParcelas'][0], ':'))
                        $parcs = explode(':', $_SESSION['contrato']['idsParcelas']);
                    $idContrato = $_SESSION['contrato']['numero'];

                    //cria a negociacao
                    $negociacao = $tb_negociacao->createRow();
                    $negociacao->id_contrato = $idContrato;
                    $negociacao->dataBase = Helper::getInputDate($_SESSION['contrato']['data']);
                    $negociacao->data = date('Y-m-d');
                    $negociacao->obs = $_POST['obs'];
                    $negociacao->tp_operacao = $_SESSION['contrato']['tipo'];
                    $negociacao->nr_quantidade_parcela = count($_POST['data']);
                    $negociacao->vl_desconto = ($_POST['desconto'])?$_POST['desconto']:null;
                    $negociacao->vl_acrescimo = ($_POST['acrescimo'])?$_POST['acrescimo']:null;
                    $negociacao->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - i');
                    $idNegociacao = $negociacao->save();
                    $listaParcelasUsadas = '';
                    foreach ($parcs as $p) {

                        $tb_comunicacao = new Comunicacao();
                        //parcela negociada que tem os seus valores originais atualizados de acordo com a data base
                        $parcela = $tb_parcela->fetchRow('id_parcela_contrato = "' . $p . '"');
                        $nrParcel = explode('/',$parcela->nr_tipo_parcela);
                        $nrParcel = explode(' ',$nrParcel[1]);
                        //Pegando o id/tipo das parcelas usadas
                        $listaParcelasUsadas .= $parcela->id_parcela . $parcela->tp_parcela . ", ";
                        $parcelaNegociada = $tb_parcNegociada->createRow();
                        $parcelaNegociada->id_parcela_contrato = $p;
                        $parcelaNegociada->tp_parcela = $parcela->tp_parcela;
                        $parcelaNegociada->acrescimo = ($parcela->acrescimo)?$parcela->acrescimo:null;
                        $parcelaNegociada->desconto = ($parcela->desconto)?$parcela->desconto:null;
                        $parcelaNegociada->id_negociacao = $idNegociacao;
                        $parcelaNegociada->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - i');
                        $parcelaNegociada->save();
                        $tb_comunicacao->deleteParcela($p);
                        
                        //Se for negociacao, altera a parcela existente na tabela de parcela
                        if ($_SESSION['contrato']['tipo'] == 'N') {
                            switch ($parcela->tp_parcela) {
                                case('N'):
                                    $parcela->tp_parcela = 'NE';
                                    break;
                                case('C'):
                                    $parcela->tp_parcela = 'CE';
                                    break;
                                case('S'):
                                    $parcela->tp_parcela = 'SE';
                                    break;
                                case('I'):
                                    $parcela->tp_parcela = 'IE';
                                    break;
                                default:
                                    $parcela->tp_parcela = 'E';
                                    break;
                            }
                        }
                        $parcela->acrescimo = ($_POST['acrescimo_' . $p])?$_POST['acrescimo_' . $p]:null;
                        $parcela->desconto = ($_POST['desconto_' . $p])?$_POST['desconto_' . $p]:null;
                        $parcela->vl_juros = Helper::getInputMoney($_POST['juros_' . $p]);
                        $parcela->vl_multa = Helper::getInputMoney($_POST['multa_' . $p]);
                        $nrParcel[0]?  $nrParcela = "/".$nrParcel[0] : $nrParcela = "";
                        $parcela->nr_tipo_parcela = $parcela->id_parcela."/".$nrParcel[0]." ".$parcela->tp_parcela;
                        if ($_SESSION['contrato']['tipo'] == 'N') {
                            $parcela->id_negociacao = $idNegociacao;
                        } else {
                            $parcela->id_renegociacao = $idNegociacao;
                        }
                        $parcela->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - u');
                        $parcela->save();
                        //cria as parcelas da negociacao, baseadas pelo tipo(R ou N)!
                        if ($_SESSION['contrato']['tipo'] == 'R') {
                            $contratoHistorico = $tbContratoHistorico->fetchRow("id = " . $idContrato);
                            if (!$contratoHistorico) {
                                $contrato = $tbContrato->fetchRow("id = " . $idContrato)->toArray();
                                $contrato['log'] = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - u');
                                try {
                                    $db->insert(TB_CONTRATO_HISTORICO, $contrato);
                                } catch (Exception $e) {
                                    print_r('Contate o suporte => ' . $e->getMessage());
                                }
                            }
                            try {
                                // Salvamos as parcelas no historico.
                                $db->insert(TB_PARCELA_HISTORICO, $parcela->toArray());                            
                            } catch (Exception $e) {
                                print_r('Contate o suporte => ' . $e->getMessage());
                            }
                            try {
                                //deleta a(s) parcela(s)
                                $tb_parcela->delete('id_parcela_contrato = ' . $parcela["id_parcela_contrato"] . ' AND id_contrato = ' . $parcela["id_contrato"]);     
                            } catch (Exception $e) {
                                print_r('Contate o suporte => ' . $e->getMessage());
                            }
                        }
                    }
                    
                    //Cria as novas parcelas na tabela de parcela
                    $listaParcelasCriada = '';
                    for ($i = 1; $i <= count($_POST['data']); $i++) {
                        $parcela = $tb_parcela->createRow();
                        $parcela->id_parcela = $i;
                        $parcela->id_contrato = $idContrato;
                        $parcela->acrescimo = 0;
                        $parcela->desconto = 0;
                        $parcela->dt_parcela = Helper::getInputDate($_POST['data'][$i - 1]);
                        $parcela->vl_parcela = Helper::getInputMoney($_POST['valor'][$i - 1]);
                        $parcela->obs_parcela =$_POST['obsParcela'];

                        if ($_SESSION['contrato']['tipo'] == 'N') {
                            $tipoParcela = 'G';
                        }else{
                            $tipoParcela = 'N';
                        }
                        $parcela->tp_parcela = $tipoParcela;
                        if ($_SESSION['contrato']['tipo'] == 'N') {
                            $parcela->id_negociacao = $idNegociacao;
                        } else {
                            $parcela->id_renegociacao = $idNegociacao;
                        }
                        $parcela->pago = '0';
                        $parcela->obs = "Parcela referente a negociacao do contrato {$idContrato}";
                        $parcela->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - i');
                        $parcela->nr_tipo_parcela = $parcela->id_parcela."/".count($_POST['data'])." ".$parcela->tp_parcela ;
                        $parcela->save();
                        $listaParcelasCriada .= $i . $tipoParcela . ", ";
                    }

                    $db->commit();
                    //remove os dados da sessao
                    unset($_SESSION['contrato'], $_SESSION['parcelas']);

                    //Antes de redirecionar grava o resultado no log dos contatos realizados como Negociacao.
                    if ($negociacao['tp_operacao'] == 'N')
                        $tipoOperacao = ' Negociao ';
                    else
                        $tipoOperacao = ' Renegociao ';

                    (new Relacionamento())->saveContato(22, date('Y-m-d'), $idContrato, 'Log: ' . $tipoOperacao . ' gerada. Parcelas Usadas: ' . $listaParcelasUsadas . ' Parcelas Criadas: '  . $listaParcelasCriada);

                    $this->redirect(array('m' => 'fin', 'c' => 'negociacao', 'a' => 'listar'), array('success' => 'Operao realizada com sucesso'));
                } catch (Exception $e) {
                    $db->rollBack();
                    $this->_helper->addMensagem('danger', 'Houve algum erro, entre em contato com suporte. '.$e->getMessage());
                }
            }
        }
        $this->set('contrato', $contrato);
        $this->display('passo4');
    }

    //Gerar o pdf de negociacao
    public function emitirAction()
    {
        $tbClienteAcade = new Db_Cliente();
        $this->set('clienteAcade', $tbClienteAcade->fetchRow()->toArray());

        $tb_negociacao = new Negociacao();
        $tbParcela = new Parcela();
        $tbParcelaHistorico = new ParcelaHistorico();
        $tbAssinatura = new Assinatura();
        $tbContrato = new Contrato();
        $tbParceria = new Parceria();
        $tbContratoPessoa = new ContratoPessoa();
        $tbPessoa = new Pessoa();

        $negociacao = $tb_negociacao->getAdapter()->select()
            ->from(array('n' => TB_NEGOCIACAO), array('idNegociacao' => 'id','*'))
            ->join(array('c' => TB_CONTRATO), 'c.id = n.id_contrato', array('contrato' => 'id', 'nr_parcela'))
            ->join(array('l' => TB_LOTES), 'l.id = c.id_lote', array('lote', 'quadra'))
            ->join(array('e' => TB_EMPREENDIMENTO), 'e.id = l.id_empreendimento', array('idEmpreendimento' => 'id','nm_empreendimento','fl_assinatura'))
            ->joinLeft(array('ci' => TB_CIDADE), 'ci.id = e.cd_cidade', array('cidade' => 'nome', 'uf'))
            // ->joinLeft(array('r' => TB_REPRESENTANTE), 'r.id_pessoa_juridica = c.id_pessoa AND r.fl_principal = "1"', null)
            ->joinLeft(array('pe' => TB_PESSOA), 'pe.id = c.id_pessoa', array('nm_pessoa', 'nrCepCli' => 'nr_cep', 'enderecoCli' => 'endereco', 'bairroCli' => 'nm_bairro'))
            ->joinLeft(array('pf' => TB_PESSOA_FISICA), 'pf.id_pessoa = pe.id', array('cpfCli' => 'nr_cpf'))
            ->joinLeft(array('pj' => TB_PESSOA_JURIDICA), 'pj.id_pessoa = pe.id', array('cnpjCli' => 'nr_cnpj'))
            ->joinLeft(array('ciCli' => TB_CIDADE), 'ciCli.id = pe.cd_cidade', array('cidadeCli' => 'nome', 'ufCli' => 'uf'))
            ->where('n.id = ' . $_GET['id'])
            ->query()->fetch();

        $qtdeParcelas = $tbParcela->getQtdeParcelas($negociacao['id_contrato']);

        $pessoasEnvolvidas = $tbContratoPessoa->findByContrato($negociacao['id_contrato']);
        $pessoas = [];
        foreach ($pessoasEnvolvidas as $pessoa) {
            array_push($pessoas, $tbPessoa->findPessoaById($pessoa['id_pessoa']));
        }

        //Consulta que tres os dados do contrato
        $contrato = $tbContrato->getDefaultAdapter()->select()
            ->from(array('c' => TB_CONTRATO), array('id', 'id_lote','id_pessoa'))
            ->join(array('l' => TB_LOTES), 'l.id = c.id_lote', array('id_empreendimento'))
            ->where('c.id = ' . $negociacao['id_contrato'])
            ->query()->fetch();

        //Consulta para ser exibido as Assinaturas
        $assinaturas = $tbAssinatura->getAdapter()->select()
            ->from(array('as' => TB_ASSINATURA), '*')
            ->join(array('p' =>TB_PESSOA), 'as.id_pessoa = p.id', array('id','nm_pessoa'))
            ->join(array('e' => TB_EMPREENDIMENTO), 'e.id = as.id_empreendimento', array('id','nm_empreendimento','fl_assinatura'))
            ->joinLeft(array('pf' => TB_PESSOA_FISICA), 'pf.id_pessoa = p.id', array('nr_cpf'))
            ->joinLeft(array('pj' => TB_PESSOA_JURIDICA), 'pj.id_pessoa = p.id', array('nr_cnpj'))
            ->joinLeft(array('pa' => TB_PARCERIA), 'e.id = pa.id_empreendimento', array('*'))
            ->where('as.id_empreendimento = ' . $contrato['id_empreendimento'])
            ->group('p.nm_pessoa')
            ->query()->fetchAll();

        //Consulta para trazer o Tipo do Loteamento
        $empreendimentoInfo = Zend_Db_Table::getDefaultAdapter()->select()
            ->from(array('em' => TB_EMPREENDIMENTO), array('id_tipo_loteamento', 'ds_path_logo'))
            ->join(array('t' => TB_TIPO_LOTEAMENTO), 'em.id_tipo_loteamento = t.id_tipo_loteamento', array('*'))
            ->where('em.id = '.$negociacao['idEmpreendimento'])
            ->query()->fetch();
        $this->set("empreendimentoInfo", $empreendimentoInfo);

        //Consulta para ser exibido as Parcerias
        $parceria = $tbParceria->getAdapter()->select()
            ->from(array('pa' => TB_PARCERIA), '*')
            ->join(array('p' =>TB_PESSOA), 'pa.id_pessoa = p.id', array('id','nm_pessoa'))
            ->join(array('e' => TB_EMPREENDIMENTO), 'e.id = pa.id_empreendimento', array('id','nm_empreendimento','fl_assinatura'))
            ->joinLeft(array('pf' => TB_PESSOA_FISICA), 'pf.id_pessoa = p.id', array('nr_cpf'))
            ->joinLeft(array('pj' => TB_PESSOA_JURIDICA), 'pj.id_pessoa = p.id', array('nr_cnpj'))
            ->where('pa.id_empreendimento = ' . $contrato['id_empreendimento'])
            ->group('p.nm_pessoa')
            ->query()->fetchAll();



        if($negociacao['tp_operacao'] == 'R'){
            $parcelaSelecionada = $tbParcelaHistorico->fetchAll("id_renegociacao = " . $negociacao['idNegociacao'], 'dt_parcela')->toArray();
            $listaNegociadas = $tbParcela->fetchAll("id_renegociacao = " . $negociacao['idNegociacao'], 'dt_parcela')->toArray();
        }
        else {
            $parcelas = $tbParcela->getAdapter()->select()
                ->from(array('p' => TB_PARCELA), '*')
                ->joinLeft(array('pn' => TB_PARCELA_NEGOCIADA), 'pn.id_parcela_contrato = p.id_parcela_contrato', array('tipo' => 'tp_parcela'))
                ->where('p.id_negociacao = ' . $_GET['id'])
                ->order('dt_parcela')->query()->fetchAll();
            //Criando as variaveis para enviar para emitir!
            $parcelaSelecionada = array();
            $listaNegociadas = array();

            foreach ($parcelas as $parcela){
                if($parcela['tp_parcela'] == 'G'){
                    $listaNegociadas[] = $parcela;
                }else{
                    $parcelaSelecionada[] = $parcela;
                }
            }
        }
        if($_GET['tp'] == 'DOCX'){
            $_SESSION['tipoDoc'] = 'word';
        }
        $this->set('documento', $_SESSION['tipoDoc']);
        $this->set('negociacao', $negociacao);
        $this->set('parcelaSelecionada', $parcelaSelecionada);
        $this->set('listaNegociadas', $listaNegociadas);
        $this->set('qtdeParcelas', $qtdeParcelas);
        $this->set('assinaturas', $assinaturas);
        $this->set('parceria', $parceria);
        $this->set('pessoasEnvolvidas', $pessoas);
        $this->displayPDF('negociacao_de_parcelas.pdf');
    }

    //Gerar Relatorio Sintetico
    public function gerarRelatorioAction()
    {
        $tbClienteAcade = new Db_Cliente();
        $this->set('clienteAcade', $tbClienteAcade->fetchRow()->toArray());

        $tb_negociacao = new Negociacao();
        $tbParcela = new Parcela();
        $tbParcelaHistorico = new ParcelaHistorico();
        $tbAssinatura = new Assinatura();
        $tbContrato = new Contrato();
        $tbParceria = new Parceria();
        $tbContratoPessoa = new ContratoPessoa();
        $tbPessoa = new Pessoa();

        $negociacao = $tb_negociacao->getAdapter()->select()
            ->from(array('n' => TB_NEGOCIACAO), array('idNegociacao' => 'id','*'))
            ->join(array('c' => TB_CONTRATO), 'c.id = n.id_contrato', array('contrato' => 'id', 'nr_parcela'))
            ->join(array('l' => TB_LOTES), 'l.id = c.id_lote', array('lote', 'quadra'))
            ->join(array('e' => TB_EMPREENDIMENTO), 'e.id = l.id_empreendimento', array('idEmpreendimento' => 'id','nm_empreendimento','fl_assinatura'))
            ->joinLeft(array('ci' => TB_CIDADE), 'ci.id = e.cd_cidade', array('cidade' => 'nome', 'uf'))
            // ->joinLeft(array('r' => TB_REPRESENTANTE), 'r.id_pessoa_juridica = c.id_pessoa AND r.fl_principal = "1"', null)
            ->joinLeft(array('pe' => TB_PESSOA), 'pe.id = c.id_pessoa', array('nm_pessoa', 'nrCepCli' => 'nr_cep', 'enderecoCli' => 'endereco', 'bairroCli' => 'nm_bairro'))
            ->joinLeft(array('pf' => TB_PESSOA_FISICA), 'pf.id_pessoa = pe.id', array('cpfCli' => 'nr_cpf'))
            ->joinLeft(array('pj' => TB_PESSOA_JURIDICA), 'pj.id_pessoa = pe.id', array('cnpjCli' => 'nr_cnpj'))
            ->joinLeft(array('ciCli' => TB_CIDADE), 'ciCli.id = pe.cd_cidade', array('cidadeCli' => 'nome', 'ufCli' => 'uf'))
            ->where('n.id = ' . $_GET['id'])
            ->query()->fetch();

        $qtdeParcelas = $tbParcela->getQtdeParcelas($negociacao['id_contrato']);

        $pessoasEnvolvidas = $tbContratoPessoa->findByContrato($negociacao['id_contrato']);
        $pessoas = [];
        foreach ($pessoasEnvolvidas as $pessoa) {
            array_push($pessoas, $tbPessoa->findPessoaById($pessoa['id_pessoa']));
        }

        //Consulta que tres os dados do contrato
        $contrato = $tbContrato->getDefaultAdapter()->select()
            ->from(array('c' => TB_CONTRATO), array('id', 'id_lote','id_pessoa'))
            ->join(array('l' => TB_LOTES), 'l.id = c.id_lote', array('id_empreendimento'))
            ->where('c.id = ' . $negociacao['id_contrato'])
            ->query()->fetch();

        //Consulta para ser exibido as Assinaturas
        $assinaturas = $tbAssinatura->getAdapter()->select()
            ->from(array('as' => TB_ASSINATURA), '*')
            ->join(array('p' =>TB_PESSOA), 'as.id_pessoa = p.id', array('id','nm_pessoa'))
            ->join(array('e' => TB_EMPREENDIMENTO), 'e.id = as.id_empreendimento', array('id','nm_empreendimento','fl_assinatura'))
            ->joinLeft(array('pf' => TB_PESSOA_FISICA), 'pf.id_pessoa = p.id', array('nr_cpf'))
            ->joinLeft(array('pj' => TB_PESSOA_JURIDICA), 'pj.id_pessoa = p.id',array('nr_cnpj'))
            ->joinLeft(array('pa' => TB_PARCERIA), 'e.id = pa.id_empreendimento', array('*'))
            ->where('as.id_empreendimento = ' . $contrato['id_empreendimento'])
            ->group('p.nm_pessoa')
            ->query()->fetchAll();

        //Consulta para trazer o Tipo do Loteamento
        $empreendimentoInfo = Zend_Db_Table::getDefaultAdapter()->select()
            ->from(array('em' => TB_EMPREENDIMENTO), array('id_tipo_loteamento', 'ds_path_logo'))
            ->join(array('t' => TB_TIPO_LOTEAMENTO), 'em.id_tipo_loteamento = t.id_tipo_loteamento', array('*'))
            ->where('em.id = '.$negociacao['idEmpreendimento'])
            ->query()->fetch();
        $this->set("empreendimentoInfo", $empreendimentoInfo);

        //Consulta para ser exibido as Parcerias
        $parceria = $tbParceria->getAdapter()->select()
            ->from(array('pa' => TB_PARCERIA), '*')
            ->join(array('p' =>TB_PESSOA), 'pa.id_pessoa = p.id', array('id','nm_pessoa'))
            ->join(array('e' => TB_EMPREENDIMENTO), 'e.id = pa.id_empreendimento', array('id','nm_empreendimento','fl_assinatura'))
            ->joinLeft(array('pf' => TB_PESSOA_FISICA), 'pf.id_pessoa = p.id', array('nr_cpf'))
            ->joinLeft(array('pj' => TB_PESSOA_JURIDICA), 'pj.id_pessoa = p.id',array('nr_cnpj'))
            ->where('pa.id_empreendimento = ' . $contrato['id_empreendimento'])
            ->group('p.nm_pessoa')
            ->query()->fetchAll();

        if($negociacao['tp_operacao'] == 'R'){
            $parcelaSelecionada = $tbParcelaHistorico->fetchAll("id_renegociacao = " . $negociacao['idNegociacao'], 'dt_parcela')->toArray();
            $listaNegociadas = $tbParcela->fetchAll("id_renegociacao = " . $negociacao['idNegociacao'], 'dt_parcela')->toArray();
        }
        else {
            $parcelas = $tbParcela->getAdapter()->select()
                ->from(array('p' => TB_PARCELA), '*')
                ->joinLeft(array('pn' => TB_PARCELA_NEGOCIADA), 'pn.id_parcela_contrato = p.id_parcela_contrato', array('tipo' => 'tp_parcela'))
                ->where('p.id_negociacao = ' . $_GET['id'])
                ->order('dt_parcela')->query()->fetchAll();
            //Criando as variaveis para enviar para emitir!
            $parcelaSelecionada = array();
            $listaNegociadas = array();

            foreach ($parcelas as $parcela){
                if($parcela['tp_parcela'] == 'G'){
                    $listaNegociadas[] = $parcela;
                }else{
                    $parcelaSelecionada[] = $parcela;
                }
            }
        }

        if($_GET['tp'] == 'DOCX'){
            $_SESSION['tipoDoc'] = 'word';
        }
        $this->set('documento', $_SESSION['tipoDoc']);
        $this->set('negociacao', $negociacao);
        $this->set('parcelaSelecionada', $parcelaSelecionada);
        $this->set('listaNegociadas', $listaNegociadas);
        $this->set('qtdeParcelas', $qtdeParcelas);
        $this->set('assinaturas', $assinaturas);
        $this->set('parceria', $parceria);
        $this->set('pessoasEnvolvidas', $pessoas);
        $this->displayPDF('gerarRelatorio.pdf');
        
    }

    //Excluir a negociacao
    public function desfazerAction()
    {
        $tb_negociacao = new Negociacao();
        $tb_parcela = new Parcela();
        $tbParcelaHistorico = new ParcelaHistorico();
        $tb_parc2aVia = new Parcela2Via();
        $tb_parcNegociada = new ParcelaNegociada();
        $url = array('m' => 'fin', 'c' => 'negociacao', 'a' => 'listar');
        if(isset($_GET['urlquery'])){
            $url = array();
            parse_str($_GET['urlquery'],$url);
        }
        elseif (isset($_GET['flag'])) {
            $url = array('m' => 'cobranca', 'c' => 'cobranca', 'a' => 'iniciar', 'id' => $_GET['flag']);
        }

        $negociacao = $tb_negociacao->fetchRow('id = ' . $_GET['id'])->toArray();
        $histNegociacao = $tb_negociacao->fetchAll('id_contrato = ' . $negociacao['id_contrato'])->toArray();
        
        foreach($histNegociacao as $hist){
            if($hist['id'] > $negociacao['id']){
                $this->redirect($url, array('danger' => 'No pode ser excluida pois existe uma negociao mais recente'));exit;
            }
        }
        //busca os dados anteriores da tabela negociada
        if($negociacao['tp_operacao'] == 'N'){
            $parcelasNegociadasPagas = $tb_parcela->fetchAll('id_negociacao = ' . $_GET['id'] . ' AND tp_parcela = "G" AND pago = "1" ')->toArray();
            $parcelasNegociadas = $tb_parcela->fetchAll('id_negociacao = ' . $_GET['id'] . ' AND tp_parcela LIKE "%E"')->toArray();
        } else {
            $parcelasNegociadasPagas = $tb_parcela->fetchAll('id_renegociacao = ' . $_GET['id'].' AND pago = "1" ')->toArray();
            $parcelasNegociadas = $tbParcelaHistorico->fetchAll('id_renegociacao = ' . $_GET['id'])->toArray();
        }
        
        //verifica se existe alguma parcela ja paga
        if ($parcelasNegociadasPagas){
            $this->redirect($url, array('danger' => 'No pode ser excluida pois j tem parcelas da negociao pagas'));
        } else{

            //Iniciando transacao, implementando padrao adotado 10/06/2018
            $db = Zend_Db_Table::getDefaultAdapter();
            $db->beginTransaction();

            $idcontrato = $negociacao['id_contrato'];

            try {
                //restaura os valores das parcelas
                foreach ($parcelasNegociadas as $parcNeg) {
                    if($negociacao['tp_operacao'] == 'R') {
                        // Salvamos as parcelas no historico.
                        $db->insert(TB_PARCELA, $parcNeg);
                    }
                    $parcNegociada = $tb_parcNegociada->fetchRow('id_parcela_contrato = ' . $parcNeg['id_parcela_contrato']);
                    $parcela = $tb_parcela->fetchRow('id_parcela_contrato = ' . $parcNeg['id_parcela_contrato']);
                    $qtdeParcela = $tbParcelaHistorico->getAdapter()->select()
                        ->from(array('p' => TB_PARCELA_HISTORICO), array('id_parcela', 'nr_tipo_parcela', 'tp_parcela'))
                        ->where('p.tp_parcela = ?', $parcNegociada->tp_parcela)
                        ->where('p.id_contrato = ?', $parcela->id_contrato)
                        ->order('p.id_parcela DESC')
                        ->query()->fetchAll();
                    
                    if ($parcela) {

                        if ($parcNegociada->tp_parcela) {

                            $parcela->tp_parcela = $parcNegociada->tp_parcela;
                            $parcela->acrescimo = $parcNegociada->acrescimo;
                            $parcela->desconto = $parcNegociada->desconto;
                            $parcela->vl_juros = null;
                            $parcela->vl_multa = null;

                            if($negociacao['tp_operacao'] == 'R') {
                                $parcela->id_renegociacao = null;
                            } else {
                                $parcela->id_negociacao = null;
                            }
                            if($qtdeParcela[0]['nr_tipo_parcela']){
                                $nr_tp_parc = explode( '/', $qtdeParcela[0]['nr_tipo_parcela']);
                                $parcela->nr_tipo_parcela = $parcela->id_parcela."/". $nr_tp_parc[1];
                            }else{
                                $parcela->nr_tipo_parcela = $parcela->id_parcela." ".$parcela->tp_parcela ;
                            }
                            $parcela->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - u');
                            $parcela->save();
    
                            //exclui os registros de backup
                            $parcNegociada->delete();
                        }
                    }
                }
                //ternario para escolha de campos!
                $campoNegociacao = ($negociacao['tp_operacao'] == 'R'?'id_renegociacao':'id_negociacao');
                $tpNegociacao = ($negociacao['tp_operacao'] == 'R'?'Renegociao':'Negociao');
                //exclui as parcelas negociadas
                $tb_parcNegociada->delete('id_negociacao = ' . $negociacao['id']);
                //exclui a Parcela Historico
                $tbParcelaHistorico->delete($campoNegociacao.' = '. $negociacao['id']);
                //exclui a Parcela
                $tb_parcela->delete($campoNegociacao.' = ' . $negociacao['id']);
                //exclui a Parcela 2 Via
                $tb_parc2aVia->delete($campoNegociacao.' = ' . $negociacao['id']);
                //exclui a negociacao
                //Negociacao e relacionado, primeiro se exclui as parcelas para depois a negociacao!
                $tb_negociacao->delete('id = ' .$negociacao['id']);
                $db->commit();
                //Antes de redirecionar grava o resultado no log dos contatos realizados como Negociacao.
                (new Relacionamento())->saveContato(22, date('Y-m-d'), $idcontrato, 'Log: '.$tpNegociacao.' Cancelada');
                $this->redirect($url, array('success' => 'Operao realizada com sucesso'));
            } catch (Exception $e) {
                $db->rollBack();
                $this->redirect($url, array('danger'=>$e->getMessage()));
                exit;
            }
        }
    }

    /**
     *funcao que valida o formulario
     * Padrao:
     * k: Success - Para validar positivo ou k: Danger - Para validar negativo e o
     * v: Mensagem a ser exibida
     */

    public function validar($passo)
    {
        switch ($_POST['passo']) {
            case 1:
                $campos = array(
                    'negociacao_contrato' => 'Selecione o contrato!<br>',
                    'negociacao_empreendimento' => 'Selecione o Empreendimento!<br>',
                );
                break;
            case 2:
                $campos = array(
                    'dataBase' => 'O campo data base  obrigatorio!<br>',
                    'parcelas' => 'Selecione pelo menos uma parcela para prosseguir!<br>',
                );
                break;
            case 3:
                $campos = array(
                    'vezes' => 'O campo dividir valor em  obrigatrio!<br>',
                    'dtPrimParc' => 'O campo data da primeira parcela  obrigatrio!<br>',
                );
                break;
            case 4:
                if (is_array($_POST['valor'])) {
                    $valor = 0;
                    foreach ($_POST['valor'] as $v) {
                        $valor += str_replace(',', '.', $v);
                    }
                    $valorTotal = $_POST['valorTotal'] - 0.12;
                    if ($valor < $valorTotal) {
                        $this->_helper->addMensagem('danger', 'os valores no conferem.');
                    }
                } else {
                    $this->_helper->addMensagem('danger', 'os valores no conferem');
                }

                return !(count($this->_helper->getMensagens()) > 0);
            default:
                break;
        }

        //Alterado para seguir novo padrao!
        $valor = '';
        foreach ($campos as $campo => $msg) {
            if ($_POST[$campo] == '') {
                $valor .= $msg;
                $this->_helper->addMensagem('danger', $valor);
            }
        }
        return !(count($this->_helper->getMensagens()) > 0);
    }

//Metodo AJAX para listar contrato na View!
    public function contratoByEmpreendimentoAction()
    {
        $contratos = Contrato::byEmpreendimento($_POST['idEmpreendimento'], Contrato::CONTRATO_GERADO, 0, array("nm_pessoa", "lote", "quadra", "id"), true);

        $lista = array();
        foreach ($contratos as $contrato) {
            //Metodo encontrado para gerar um cor no nome do valor na lista do select2!
            if ($contrato['fl_distrato'] == '1')
                $color = 'color: red;';
            else
                $color = null;

            $lista[] = array('id' => $contrato['id'], 'text' => utf8_encode($contrato['nm_pessoa']) . ' Quadra: ' . utf8_encode($contrato['quadra']) . ' - Lote: ' . utf8_encode($contrato['lote']) . ' - Contrato: ' . $contrato['id'], 'estilo' => $color);
        }

        echo json_encode($lista);
    }
}

?>
