<?php

class EstornarParcelaController extends Controller
{
    public function __construct($request)
    {
        parent::__construct($request);
    }

    public function indexAction()
    {
        $this->set('opcao', 'B');

        $empreendimentos = new Empreendimento();
        $empreendimentos = $empreendimentos->getDefaultAdapter()->select()
            ->from(array('e' => TB_EMPREENDIMENTO), array('e.nm_empreendimento', 'e.id'));

        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $empreendimentos->where("e.id IN({$id})");
                } else {
                    $empreendimentos->where("1");
                }
            } catch (Exception $e) {

            }
        }

        $empreendimentos = $empreendimentos->order('nm_empreendimento')->query()->fetchAll();
        $this->set('empreendimentos', $empreendimentos);

        if ($this->_isPost) {
            if ($this->validar()) {
                $parcelas = new Parcela();
                $parcelasHistorico = new ParcelaHistorico();
                $idParcela = ($_POST['opcao'] == 'B') ? $_POST['id_parcela'] : $_POST['num_baixa'];
                if ($_POST['tipo'] == '1') {
                    $parcela = $parcelas->fetchRow('id_parcela_contrato = ' . $idParcela);
                } else {
                    $parcela = $parcelasHistorico->fetchRow('id_parcela_contrato = ' . $idParcela);
                }

                if ($idParcela) {
                    $empreendimento = Parcela::getIntegracaoEmpreendimento($parcela->id_parcela_contrato);
                    if ($empreendimento) {
                        //Criando uma nova linha para insercao no acadefinan
                        $adapter = $this->getAdapterIntegracao();                        
                        $adapter->beginTransaction();
                        $parcelaBackup = $parcela->toArray();
                        $contrato = Contrato::findContrato($parcelaBackup['id_contrato']); 
                        try {
                            $data = explode('-', $parcelaBackup['dt_credito']);
                            $contaDados = array(
                                'cd_plano_conta' => $empreendimento['cd_conta_debito'],
                                'cd_centro_custo' => $empreendimento['cd_centro_custo'],
                                'nr_mes_competencia' => $data[1],
                                'nr_ano_competencia' => $data[0],
                                'dt_documento' => $parcelaBackup['dt_pagamento'],
                                'nr_parcelas' => 1,
                                'vl_total' => $parcelaBackup['vl_total_pago'],
                                'tp_conta_pagar_receber' => 'P',
                                'ds_observacao' => "Estorno parcela: {$parcelaBackup['id_parcela']}/{$parcelaBackup['tp_parcela']}, Lt: $contrato->lote - Qd: $contrato->quadra, Contrato {$parcelaBackup['id_contrato']}, Cliente: $contrato->nm_pessoa",
                                'log' => (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - u')
                            );
                            $adapter->insert('afn006', $contaDados);
                            $idConta = $adapter->lastInsertId('afn006');
    
                            //Insercao na tabela de Parcelas de Contas a Pagar
                            $parcelaDados = array(
                                'cd_conta_pagar_receber' => $idConta,
                                'cd_forma_pagamento' => 1,
                                'cd_local_pagamento' => $empreendimento['id_finan'],
                                'nr_parcela' => 1,
                                'vl_parcela' => $parcelaBackup['vl_total_pago'],
                                'dt_vencimento' => $parcelaBackup['dt_parcela'],
                                'dt_pagamento' => $parcelaBackup['dt_pagamento'],
                                'dt_debito' => $parcelaBackup['dt_credito'],
                                'tp_situacao' => 'P'
                            );
                            $adapter->insert('afn007', $parcelaDados);

                        } catch (Exception $e) {
                            $adapter->rollBack();
                        }
                        $adapter->commit();
                    }
                }

                $parcela->vl_multa = null;
                $parcela->vl_juros = null;
                $parcela->vl_total_pago = null;
                $parcela->dt_pagamento = null;
                $parcela->tp_baixa = null;
                $parcela->fm_baixa = null;
                $parcela->dt_credito = null;
                $parcela->pago = 0;
                $parcela->desconto = null;
                $parcela->id_banco = null;
                $parcela->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - u');
                $lastId = $parcela->save();
                //Antes de redirecionar grava o resultado no log dos contatos realizados como Estorno de parcela.
                if ($lastId) {
                    (new Relacionamento())->saveContato(42, date('Y-m-d'), $parcela['id_contrato'], 'Log: Parcela Estornada '. $parcela['tp_parcela']. '-' .  $parcela['id_parcela']);
                    $this->_helper->addMensagem('success', 'Estorno de Baixa feito com sucesso!');
                } else {
                    $this->_helper->addMensagem('danger', 'Estorno de Baixa no realizado!');
                }
                $this->set('opcao', $_POST['opcao']);
            } else {
                $this->set('dados', $_POST);
                $this->set('opcao', $_POST['opcao']);
            }
        }
        $this->display('index');
    }

    //Validao
    private function validar()
    {
        $campos = array("idEmpreendimento", "idContrato", 'id_parcela');

        if ($_POST['opcao'] == 'N' && $_POST['num_baixa'] == '') {
            $this->_helper->addMensagem("danger", "O campo numero deve ser preenchido.");
        } elseif ($_POST['opcao'] == 'B') {
            $msg = '';
            $exibeMsg = false;
            foreach ($campos as $cp) {
                if ($_POST [$cp] == "") {
                    switch ($cp) {
                        case "idEmpreendimento" :
                            $msg .= "Selecione o empreendimento.<br>";
                            break;
                        case "idContrato" :
                            $msg .= "Selecione o contrato.<br>";
                            break;
                        case 'id_parcela':
                            $msg .= "Selecione o nmero da parcela.<br>";
                            break;
                    }
                    $exibeMsg = true;
                }
            }
            if ($exibeMsg)
                $this->_helper->addMensagem('danger', $msg);
        }
        return !(count($this->_helper->getMensagens()) > 0);
    }

    //Traz uma lista dos empreendimentos
    public function contratoByEmpreendimentoAction()
    {
        $distratado = null;
        if ($_POST['tipo'] == "1") {
            $distratado = true;
        }
        $contratos = Contrato::byEmpreendimentoextrato($_POST['idEmpreendimento'], Contrato::CONTRATO_GERADO, $distratado, array("nm_pessoa", "lote", "quadra", "id"));
        $lista = array();
        foreach ($contratos as $contrato) {
            $lista[] = array('id' => $contrato['id'], 'text' => utf8_encode($contrato['nm_pessoa']) . ' Quadra: ' . utf8_encode($contrato['quadra']) . ' - Lote: ' . utf8_encode($contrato['lote']) . ' - Contrato: ' . utf8_encode($contrato['id']));
        }
        echo json_encode($lista);
    }

    //Traz os as parcelas pagas para serem estornadas
    public function contrato_parcela_pagaAction()
    {
        $contrato = $_POST['contrato'];
        $listaParcela = array();

        if ($_POST['tipoParcela'] == 1) {
            $tb_parcela = new Parcela();
            $listaParcela = $tb_parcela->fetchAll("id_contrato = {$contrato} AND pago = '1'","dt_parcela ASC")->toArray();
        } else {
            $tb_parcelaH = new ParcelaHistorico();
            $listaParcela = $tb_parcelaH->fetchAll("id_contrato = {$contrato} AND pago = '1'","dt_parcela ASC")->toArray();
        }

        if ($listaParcela) {
            $lista = array();
            foreach ($listaParcela as $parcela) {
                $lista[] = array('id' => $parcela['id_parcela_contrato'], 'text' => utf8_encode(
                    'Parcela '.$parcela['id_parcela'].$parcela['tp_parcela'].' - Vencimento:'.
                         Helper::getDate($parcela['dt_parcela'])));
            }
        }
        echo json_encode($lista);
    }

    //Exibi os titulos na aba Buscar do site!
    public function exibirTitulosAction()
    {
        $titulos = Parcela::getTitulos($_POST['numero']);
        $lista = false;
        //Passando parametro idParcelaContrato, para fins de testes do cliente!
        if($titulos) {
            foreach ($titulos as $titulo) {
                $lista[] = array(
                    'idParcelaContrato' => utf8_encode($_POST['numero']),
                    'empreendimento' => utf8_encode($titulo['nm_empreendimento']),
                    'idEmpreendimento' => $titulo['id_empreendimento'],
                    'cliente' => utf8_encode($titulo['nm_pessoa']),
                    'pago' => $titulo['pago'],
                    'lote' => utf8_encode($titulo['lote']),
                    'quadra' => utf8_encode($titulo['quadra']),
                    'num_contrato' => utf8_encode($titulo['id_contrato']),
                    'parcela' => utf8_encode($titulo['id_parcela']) . ' / ' . utf8_encode($titulo['nr_parcela']) . ' ' . utf8_encode($titulo['tp_parcela']),
                    'data' => Helper::getDate(utf8_encode($titulo['dt_parcela'])),
                    'valor' => utf8_encode($titulo['vl_parcela']),
                    'id_parcela_contrato' => $titulo['id_parcela_contrato'],
                    'banco' => utf8_encode($titulo['descricao'])
                );
            }
        }

        echo json_encode($lista);
    }
}