<?php

class ConfissaoController extends Controller
{

    public function indexAction()
    {
        $this->redir(array("modulo" => "fin", "controller" => "confissao", "action" => "listar"));
    }

    public function listarAction()
    {
        if ($this->isAjax()) {
            $clientes = Confissao::findConfissao($_POST);
            $listaTotal = Confissao::findConfissao($_POST, true);
            $lista = array();
            $disabled = 'disabled';
            foreach ($clientes as $confissao) {
                $acoes = '<div style="width: 90px"></div><div align="center" style="width: 100%;">';
                $acoes .= '<a href="?m=fin&c=confissao&a=pagamento&id=' . $confissao['idConfissao'] . '"<button type="button" value="' . (!$confissao['dtPagamento']  ?  : '') . '" id="btnPagamento" data-toggle="tooltip" title="PAGAMENTO" class="btn btn-default btn-sm '. ($confissao['dtPagamento'] != '' && $confissao['dtPagamento'] != '' ? $disabled  : '') . '" style="margin-right:5px"><i class="fa fa-usd"></i> </button></span>';
                $acoes .= '<a href="?m=fin&c=confissao&a=imprime&id=' . $confissao['idConfissao'] . '" target="_blank" data-toggle="tooltip" title="EMITIR" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-file-o"></i></a>';
                $title = "return confirm('Tem certeza que deseja excluir " . $confissao['descricao'] . "?')";
                $acoes .= '<a onclick="' . $title . '"  href="?m=' . $this->modulo . '&c=' . $this->controller . '&a=excluir&id=' . $confissao['idConfissao'] . '" data-toggle="tooltip" title="EXCLUIR" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-times"></i></a>';
                $acoes .= '</div>';
                $lista[] = array(
                    'contrato' => $confissao['idContrato'],
                    'cliente' => utf8_encode($confissao['nm_pessoa']),
                    'quadra' => utf8_encode($confissao['quadra']),
                    'lote' => utf8_encode($confissao['lote']),
                    'vencimento' => Helper::getDate($confissao['dtVencimento']),
                    'pagamento' => Helper::getDate($confissao['dtPagamento']),
                    'acoes' => utf8_encode($acoes)
                );
            }
            echo json_encode(array(
                'draw' => $_POST['draw'],
                'recordsTotal' => count($listaTotal),
                'recordsFiltered' => count($listaTotal),
                'data' => $lista
            ));
        } else {
            $this->display('listar');
        }
    }

    public function adicionarAction()
    {
        if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'adicionarConfissao')) {
            $this->redir(array('modulo' => 'fin', 'controller' => 'confissao', 'action' => 'listar'), array('msgErros' => 'fail', 'exception' => 'Voc no tem permisso para acessar essa funcionalidade.'));
        }

        $this->set("subtitulo", "Confiss�es de D�vida");
        $empreendimentos = new Empreendimento();
        if ($this->_isPost && $this->validar()) {
            $tb_confissao = new Confissao();
            $tb_confissaoLote = new ConfissaoLote();

            $confissao = $tb_confissao->createRow();
            $confissao->valor = Helper::getInputMoney($_POST['valor']);
            $confissao->dtVencimento = Helper::getInputDate($_POST['dtVencimento']);
            $confissao->garantia = $_POST['garantia'];
            $confissao->obs = $_POST['obs'];
            $confissao->dtPagamento = null;
            $id = $confissao->save();
            if ($id) {
                foreach ($_POST['lotes'] as $lote) {
                    $confisslote = $tb_confissaoLote->createRow();
                    $confisslote->idLote = $lote;
                    $confisslote->idConfissao = $id;
                    $confisslote->save();

                    //Antes de redirecionar grava o resultado no log dos contatos realizados como confissao de divida.
                    (new Relacionamento())->saveContato(25, date('Y-m-d'), Contrato::getIdByLote($lote), 'Log: Confiss�o Gerada');
                }
            }
            $this->redir(array("modulo" => "fin", "controller" => "confissao", "action" => "listar"), array("msg" => "success"));
        } else {
            $confissao = $_POST;
        }
        $empreendimentos = $empreendimentos->getDefaultAdapter()->select()
            ->from(array('e' => TB_EMPREENDIMENTO), array('e.nm_empreendimento', 'e.id'));

        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $empreendimentos->where("e.id IN({$id})");
                } else {
                    $empreendimentos->where("1");
                }
            } catch (Exception $e) {

            }
        }
        $empreendimentos = $empreendimentos->order('nm_empreendimento')->query()->fetchAll();

        $this->set('confissao', $confissao);
        $this->set('empreendimentos', $empreendimentos);
        $this->display("form");
    }

    public function pagamentoAction()
    {
        if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'pagamentoConfissao')) {
            $this->redir(array('modulo' => 'fin', 'controller' => 'confissao', 'action' => 'listar'), array('msgErros' => 'fail', 'exception' => 'Voc no tem permisso para acessar essa funcionalidade.'));
        }

        $tb_confissao = new Confissao();
        $idConfissao =  $_GET['id'];

        $confissao = $tb_confissao->getAdapter()->select()->from(array('c' => TB_CONFISSAO), array('*', 'idConfissao' => 'id'))
            ->join(array('cl' => TB_CONFISSAO_LOTE), 'cl.idConfissao = c.id', null)
            ->join(array('l' => TB_LOTES), 'cl.idLote = l.id', array('lote', 'quadra', 'area'))
            ->join(array('e' => TB_EMPREENDIMENTO), 'e.id = l.id_empreendimento', array('empreendimento' => 'nm_empreendimento'))
            ->join(array('cont' => TB_CONTRATO), 'cont.id_lote = cl.idLote', null)
            ->join(array('p' => TB_PESSOA), 'p.id = cont.id_pessoa', array('cliente' => 'nm_pessoa'))
            ->where('c.id = ' . $idConfissao)
            ->query()->fetchAll();

        $dados['empreendimento'] = $confissao['0']['empreendimento'];
        $dados['cliente'] = $confissao['0']['cliente'];
        $dados['obs'] = $confissao['0']['obs'];
        $dados['id'] = $confissao['0']['id'];
        $dados['valor'] = $confissao['0']['valor'];

        foreach ($confissao as $conf) {
            $dados['lotes'] .= "Lt: " . $conf['lote'] . " Qdr: " . $conf['quadra'] . ", ";
        }
        if ($this->_isPost) {
            $dados = array(
                'dtPagamento' => ($_POST['dtPagamento']) ? Helper::getInputDate($_POST['dtPagamento']) : null,
                'obs' => $_POST['obs']
            );
            if ($tb_confissao->update($dados, 'id = ' . $idConfissao)) {
                $this->redir(array("modulo" => "fin", "controller" => "confissao", "action" => "listar"), array("msg" => "success"));
            }
        }
        $dados['lotes'] = substr($dados['lotes'], 0, -2);
        $this->set('confissao', $dados);
        $this->display();
    }

    public function imprimeAction()
    {

        $contratos = new Contrato();
        $parcerias = new Parceria();
        $pessoas = new Pessoa();
        $empreendimentos = new Empreendimento();
        $confissoes = new Confissao();
        $confissaoLotes = new ConfissaoLote();
        $lotes = new Lote();

        //confissao
        $confissao = $confissoes->getAdapter()->select()
            ->from(array('c' => TB_CONFISSAO), array('*', 'idConfissao' => 'id'))
            ->joinLeft(array('cl' => TB_CONFISSAO_LOTE), 'cl.idConfissao = c.id', null)
            ->join(array('l' => TB_LOTES), 'l.id = cl.idLote', '')
            ->join(array('cont' => TB_CONTRATO), 'cont.id_lote = cl.idLote', array('idContrato' => 'cont.id', 'cont.id_pessoa', 'cont.fl_distrato'))
            ->join(array('p' => TB_PESSOA), 'p.id = cont.id_pessoa', 'nm_pessoa')
            ->where("c.id = ?", $_GET['id'])
            ->where("cont.fl_distrato = '0'")
            ->query()->fetch();

        //lotes da confisso
        $lotes = $confissaoLotes->getAdapter()->select()->from(array('cl' => TB_CONFISSAO_LOTE), null)
            ->join(array('l' => TB_LOTES), 'l.id = cl.idLote', '*')
            ->join(array('c' => TB_CONTRATO), 'c.id_lote = l.id', array('idContrato' => 'id', 'id_pessoa'))
            ->where('idConfissao = ' . $confissao['idConfissao'])
            ->where("c.fl_distrato = '0'")
            ->query()->fetchAll();

        //empreendimento
        $empreendimento = $empreendimentos->fetchRow('id = ' . $lotes[0]['id_empreendimento'])->toArray();

        //receptor
        $cliente = $pessoas->getAdapter()->select()->from(array('p' => TB_PESSOA), array('*'))
            ->join(array('pf' => TB_PESSOA_FISICA), 'p.id = pf.id_pessoa', '*')
            ->join(array('c' => TB_CIDADE), 'c.id = p.cd_cidade', '*')
            ->where('p.id = ' . $lotes[0]['id_pessoa'])->query()->fetch();

        $clientePj = $pessoas->getAdapter()->select()->from(array('p' => TB_PESSOA), array('*'))
            ->join(array('pf' => TB_PESSOA_JURIDICA), 'p.id = pf.id_pessoa', '*')
            ->join(array('c' => TB_CIDADE), 'c.id = p.cd_cidade', '*')
            ->where('p.id = ' . $lotes[0]['id_pessoa'])->query()->fetch();

        $parceria = $parcerias->fetchAll($parcerias->select()->where('id_empreendimento = ?', $lotes[0]['id_empreendimento']))->toArray();

        $opcao = $_POST['opcao'];

        $this->set('opcao', $opcao);
        $this->set('lotes', $lotes);
        $this->set('cedente', $cedente);
        $this->set('cliente', $cliente);
        $this->set('parceria', $parceria);
        $this->set('empreendimento', $empreendimento);
        $this->set('confissao', $confissao);
        $this->set('clientePj', $clientePj);
        $this->displayPDF("confissao" . time() . ".pdf");
    }

    public function excluirAction()
    {
        if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'excluirConfissao')) {
            $this->redir(array('modulo' => 'fin', 'controller' => 'confissao', 'action' => 'listar'), array('msgErros' => 'fail', 'exception' => 'Voc no tem permisso para acessar essa funcionalidade.'));
            exit;
        }

        $loteConfissao = new ConfissaoLote;
        $confissao = new Confissao();
        try {
            //apaga os registro da tabela confissao lote
            $loteConfissao->delete('idConfissao = ' . $_GET['id']);
            $confissao->delete('id = ' . $_GET['id']);
            $this->redir(array("modulo" => "fin", "controller" => "confissao", "action" => "listar"), array("msg" => "success"));
        } catch (Exception $e) {
            $this->redir(array("modulo" => "fin", "controller" => "confissao"), array("msg" => "FAIL"));
        }
    }

    private function validar()
    {

        $campos = array("valor", "dtVencimento", "id_empreendimento");

        foreach ($campos as $cp) {
            if ($_POST [$cp] == "") {
                $this->_helper->addMensagem('erro', 'Todos os campos obrigat�rios devem ser preenchidos.');
            }
        }
        return !(count($this->_helper->getMensagens()) > 0);
    }

    public function clienteEmpreendimentoAction()
    {
        $select = Zend_Db_Table::getDefaultAdapter()->select();
        $clientes = $select->from(array('L' => TB_LOTES), array('lote', 'quadra','idLote' => 'id'))
            ->join(array('C' => TB_CONTRATO), 'C.id_lote = L.id', array('idContrato' => 'C.id' ))
            ->join(array('P' => TB_PESSOA), 'P.id = C.id_pessoa', array('nm_pessoa', 'id'))
            ->where('C.fl_gerado = ?', '1')
            ->where('L.id_empreendimento = ?', $_POST['id_empreendimento'])
            ->where('fl_distrato = "0"')
            ->order('P.nm_pessoa ASC')
            ->distinct()->query()->fetchAll();
        $this->set('clientes', $clientes);

        $lista[] = array('id'=>'','text'=>'');
        foreach ($clientes as $cliente) {
            $lista[] = array(
                'id' => $cliente['idLote'],
                'text' => utf8_encode($cliente['nm_pessoa']) . ' Quadra: ' . utf8_encode($cliente['quadra']) . ' - Lote: ' . utf8_encode($cliente['lote']) . ' - Contrato: ' . $cliente['idContrato'],
            );
        }
        echo json_encode($lista);
    }

}