<?php

class CartaCobrancaController extends Controller
{
    private $tb_pessoaFisica;
    private $tb_pessoaJuridica;
    private $contrato;
    private $tb_lote;
    private $tb_empreendimento;
    private $tb_parcela;
    private $tb_parcelaHistorico;
    private $tb_contrato;
    private $tb_carta;
    private $tb_carta_historico;
    private $tb_assinatura;
    private $tb_parceria;
    private $tb_representante;
    private $tb_pessoa;

    public function __construct($request)
    {
        parent::__construct($request);

        $this->tb_pessoaFisica = new Pessoa_Fisica();
        $this->tb_pessoaJuridica = new Pessoa_Juridica();
        $this->contrato = new Contrato();
        $this->tb_lote = new Lote();
        $this->tb_empreendimento = new Empreendimento();
        $this->tb_parcela = new Parcela();
        $this->tb_parcelaHistorico = new ParcelaHistorico();
        $this->tb_contrato = new Contrato();
        $this->tb_carta = new Modelo();
        $this->tb_carta_historico = new CartaHistorico();
        $this->tb_assinatura = new Assinatura();
        $this->tb_parceria = new Parceria();
        $this->tb_representante = new Representante();
        $this->tb_pessoa = new Pessoa();
    }

    public function indexAction()
    {
        $this->redir(array("modulo" => "fin", "controller" => "cartaCobranca", "action" => "listar"));
    }

    public function listarAction()
    {
        if ($this->isAjax()) {
            $listaItem = Carta_Cobranca::findLista($_POST);
            $totalItens = Carta_Cobranca::findLista($_POST, true);

            //Busca os tipos de cartas cadastrados
            $loCartaCobranca = new Modelo();
            $loCartaCobrancaWord = new ModeloArquivo();
            $cartas[0] = $loCartaCobranca->getAdapter()->select()
                ->from(array('co' => TB_MODELO))
                ->where('co.tp_modelo = "CC"')
                ->order('co.cd_modelo')
                ->query()->fetchAll();
            $cartas[1] = $loCartaCobrancaWord->getAdapter()->select()
                ->from(array('ca' => TB_MODELO_ARQUIVO))
                ->where('ca.tp_modelo = "CC"')
                ->order('ca.cd_modelo')
                ->query()->fetchAll();

            $lista = array();
            foreach ($listaItem as $item) {
                $termos = '<div class="input-group"><select id="termo_' . $item['id'] . '" class="cartaCobranca" onchange="cartaCobranca(' . $item['id'] . ')"> ';
                $termos .= '<option value="">Selecione...</option>';
                foreach ($cartas as $cart) {
                    foreach($cart as $carta){
                        $termos .= '<option value="' . $carta['cd_modelo'] . '_' . $carta['fl_status'] . '">' . $carta['nm_titulo'] . '</option>';
                    }
                }
                $termos .= '</select>';

                $acoes = '<span class="input-group-btn"><a target="_blank" id="link_' . $item['id'] . '" href="index.php?m=' . $this->modulo . '&c=' . $this->controller . '&a=imprime' . '&id=' . $item['id'] . '" data-toggle="tooltip" title="IMPRIMIR" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-file-o"></i></a>';

                $acoes .= '<button type="button" onClick="alteraRemetente(' . $item['id'] . ')" value="' . $item['id'] . '" data-target=".modalAlteraRemetente" data-toggle="modal" title="ALTERA REMETENTE" 
                    class="btn btn-default btn-sm btn-altera-remetente" style="margin-right:5px"><i class="fa fa-file-text"></i>
                    </button></span>';

                //Para ordenar por data
                $data = '<div hidden>' . $item['dt_contrato'] . '</div>' . Helper::getDate($item['dt_contrato']);

                $lista[] = array(
                    'contrato' => $item['id'],
                    'empreendimento' => utf8_encode($item['nm_empreendimento']),
                    'quadra' => '<div align="center">' . utf8_encode($item['quadra']) . '</div>',
                    'lote' => '<div align="center">' . utf8_encode($item['lote']) . '</div>',
                    'pessoa' => utf8_encode($item['nm_pessoa']),
                    'data' => '<div align="center">' . utf8_encode($data) . '</div>',
                    'termos' => '<div align="center">' . utf8_encode($termos) . '</div>',
                    'acoes' => utf8_encode($acoes)
                );
            }
            echo json_encode(array(
                'draw' => $_POST['draw'],
                'recordsTotal' => count($totalItens),
                'recordsFiltered' => count($totalItens),
                'data' => $lista
            ));
        } else {
            $this->display('listar');
        }
    }

    public function imprimeAction()
    {
        if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'imprimeCartaCobranca')) {
            $this->redir(array('modulo' => 'fin', 'controller' => 'cartaCobranca', 'action' => 'listar'), array('msgErros' => 'fail', 'exception' => 'Voc no tem permisso para acessar essa funcionalidade.'));
        }

        if ($_GET['tpcarta']) {
            $carta = explode('_',$_GET['tpcarta']);
            if($carta[1] != ''){
                try {
                    $loCartaCobrancaWord = new ModeloArquivo();
                    $path = $loCartaCobrancaWord->getAdapter()->select()
                    ->from(['mw' => TB_MODELO_ARQUIVO], '*')
                    ->where('mw.cd_modelo = ?', $carta[0])
                    ->query()->fetch();

                    $templateProcessor = new \PhpOffice\PhpWord\TemplateProcessor(__ROOT__ . '/' . $path['ds_path_modelo']);
                    $variaveis = $this->adicionarValoresTemplate($_GET['id'], $templateProcessor);
                    $filename = 'cartaCobranca' . $_GET['id'] . '.docx';
                    $variaveis['templateProcessor']->saveAs($filename);

                    header('Content-Description: File Transfer');
                    header('Content-Type: application/octet-stream');
                    header('Content-Disposition: attachment; filename='.$filename);
                    header('Content-Transfer-Encoding: binary');
                    header('Expires: 0');
                    header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
                    header('Pragma: public');
                    header('Content-Length: ' . filesize($filename));
                    flush();

                    readfile($filename);
                    unlink($filename);
                } catch (Exception $e) {
                    $this->redir(array("modulo" => "fin", "controller" => "cartaCobranca", "action" => "listar"), array("exception" => 'Erro ao gerar o arquivo Word, contate o suporte.'));
                }
            }else{
                $clienteAcade = new Db_Cliente();
                $cidade = new Db_Cidade();
    
                $clienteAcadeone = $clienteAcade->fetchRow();
                $this->set("clienteAcadeone", $clienteAcadeone);
                $clienteAcadeoneCidade = $cidade->find($clienteAcadeone['cd_municipio']);
                $this->set("clienteAcadeoneCidade", $clienteAcadeoneCidade);
    
                $contrato = $this->contrato->find($_GET['id'])->current();
    
                $lote = $this->tb_lote->fetchRow("id = {$contrato->id_lote}");
    
                $empreendimento = $this->tb_empreendimento->fetchRow("id = {$lote->id_empreendimento}");
    
                $adapter = $this->tb_pessoaFisica->getAdapter();
    
                $cliente = $adapter->select()->from(array("p" => TB_PESSOA), "*")
                    ->joinLeft(array("pf" => TB_PESSOA_FISICA), "p.id = pf.id_pessoa", "*")
                    ->joinLeft(array("pj" => TB_PESSOA_JURIDICA), "p.id = pj.id_pessoa", "*")
                    ->where("id = {$contrato->id_pessoa}")->query()->fetchObject();
    
    
                if ($empreendimento['fl_assinatura'] == 'PE' || $empreendimento['fl_assinatura'] == 'PI') {
                    if ($_GET['codAssinatura'] != "") {
                        $codAssinatura = $_GET['codAssinatura'];
        
                        $assinaturaPessoa = $this->tb_pessoa->findPessoaById($codAssinatura);
                        $assinatura = $assinaturaPessoa['nm_pessoa'];
                    }
    
                    if ($_GET['codRem'] != "") {
                        $codRemetente = $_GET['codRem'];
                        
                        $remetente = $adapter->select()->from(array("p" => TB_PESSOA), "*")
                            ->joinLeft(array("pf" => TB_PESSOA_FISICA), "p.id = pf.id_pessoa", "*")
                            ->joinLeft(array("pj" => TB_PESSOA_JURIDICA), "p.id = pj.id_pessoa", "*")
                            ->where("id = {$codRemetente}")->query()->fetchObject();
    
                        $remetenteCidade = $cidade->find($remetente->cd_cidade);
    
                        if (!isset($remetente->endereco)) {
                            $this->redir(array("modulo" => "fin", "controller" => "cartaCobranca", "action" => "listar"), array("exception" => 'Este remetente no possui endereo cadastrado.'));
                            exit();
                        }
                    }
                } else {
                    if ($_GET['codAssinatura'] != "")
                        $assinatura = $empreendimento['nm_empreendimento'];
                    
                    if ($_GET['codRem'] != "") {
                        $remetente = $empreendimento;
                        $remetenteCidade = $cidade->find($remetente->cd_cidade);
    
                        if (!isset($remetenteCidade)) {
                            $this->redir(array("modulo" => "fin", "controller" => "cartaCobranca", "action" => "listar"), array("exception" => 'Este remetente no possui endereo cadastrado.'));
                            exit();
                        }
                    }
                }
    
                $emp = Db_Cliente::getCliente();
    
                $parcelas = new Parcela();
                $parcelasAtraso = $parcelas->fetchAll("dt_parcela < NOW() AND id_contrato = {$_GET["id"]} AND pago = '0' AND tp_parcela NOT IN ('E', 'NE', 'SE', 'CE', 'IE')");
    
                if (!$parcelasAtraso->toArray()) {
                    $this->redir(array("modulo" => "fin", "controller" => "cartaCobranca", "action" => "listar"), array("exception" => 'Este contrato no possui parcelas atrasadas.'));
                }
    
                $pj = $adapter->select()->from(array(TB_PESSOA), "PESSOA.nm_pessoa")
                    ->join(array(TB_REPRESENTANTE), "REPRESENTANTE.id_pessoa_juridica = PESSOA.id", "*")
                    ->join(array(TB_PARCERIA), "PARCERIA.id_pessoa = REPRESENTANTE.id_pessoa", "*")
                    ->where("id_empreendimento = {$lote->id_empreendimento}")
                    ->query()->fetch();
    
                // busca se alguma carta do mesmo tipo j? foi gerada mas nao foi enviada
                $idCartaCobranca = $carta[0];
    
                // Inserindo Logo
                $tbClienteAcade = (new Db_Cliente())->fetchRow()->toArray();
                $this->set('clienteAcade', $tbClienteAcade);
    
                /*
                 * Cria o string com as parcelas no formato id/tipo (Ex: 2/S)
                 */
                $auxParcelas = '';
                $primeira = '';
                foreach ($parcelasAtraso as $parcela) {
                    $auxParcelas .= $primeira . $parcela->id_parcela . '/' . $parcela->tp_parcela;
                    $primeira = ', ';
                }
    
                $cartaEnviada = $this->tb_carta_historico->fetchRow("id_contrato = '" . $_GET["id"] . "' AND id_carta_cobranca = '" . $idCartaCobranca . "'");
                if ($cartaEnviada) {
                    $idCarta = $cartaEnviada->id_carta_historico;
                } else {
                    $historicoCartas = new CartaHistorico();
                    $novoHistorico = $historicoCartas->createRow();
                    $novoHistorico->id_contrato = $_GET["id"];
                    $novoHistorico->id_carta_cobranca = $idCartaCobranca;
                    $novoHistorico->dt_carta_gerada = date('Y-m-d');
                    $novoHistorico->ds_parcela_contrato = $auxParcelas;
                    $novoHistorico->ds_log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - i');
                    $idCarta = $novoHistorico->save();
                }
    
                //Verifica o tipo da carta para poder registrar como o devido contato realizado
                if ($_GET['tpcarta']) {
                    $cartaCobranca = new Modelo();
                    $cartaCobranca = $cartaCobranca->fetchRow('cd_modelo = ' . $carta[0])->toArray();
    
                    $tipoCarta = $cartaCobranca['tp_modelo'];
                    $nmTitulo = $cartaCobranca['nm_titulo'];
                }
                $this->set('nmTitulo', $nmTitulo);
    
    
                //Grava a operao no log de contatos realizados com o lote e quadra do contrato
                (new Relacionamento())->saveContato(53, date('Y-m-d'), $_GET["id"], 'Log: Carta Cobrana: ' . $tipoCarta . ' - ' . $nmTitulo . ' - Parcelas: ' . $auxParcelas);
    
                $this->set("remetente", $remetente);
                $this->set("assinatura", $assinatura);
                $this->set("remetenteCidade", $remetenteCidade);
                $this->set("idCarta", $idCarta);
                $this->set("cartaCobranca", $cartaCobranca);
                $this->set("empresa", $emp);
                $this->set("empreendimento", $empreendimento);
                $this->set("cliente", $cliente);
                $this->set("nomeEmpresa", $pj[0]["nm_pessoa"]);
                $this->set("lote", $lote);
                $this->set("parcelas", $parcelasAtraso);
                $this->displayPDF("carta_de_cobranca.pdf");
            }
        } else {
            $this->redir(array("modulo" => "fin", "controller" => "cartaCobranca", "action" => "listar"), array("exception" => 'Selecione o tipo de carta.'));
        }
    }

    public function contratoByEmpreendimentoAction()
    {
        $contratos = Contrato::byEmpreendimentoParcelasAbertas($_POST['id_empreendimento'], Contrato::CONTRATO_TODOS, array("nm_pessoa", "lote", "quadra", "id"), false,true);

        $lista = array();
        foreach ($contratos as $contrato) {
            $lista[] = array('id' => $contrato['id'], 'text' => utf8_encode($contrato['nm_pessoa']) . ' Quadra: ' . utf8_encode($contrato['quadra']) . ' - Lote: ' . utf8_encode($contrato['lote']) . ' - Contrato: ' . utf8_encode($contrato['id']));
        }

        echo json_encode($lista);
    }

    public function adicionarVariasAction()
    {
        $this->set("subtitulo", "Carta Cobrana");
        $this->set('nomeTela', 'Enviar Vrias');
        $this->set('back', $this->_helper->getLink());
        $instanceEmpreedimento = new Empreendimento();

        $empreendimentos = $instanceEmpreedimento->getDefaultAdapter()->select()
            ->distinct('e.id')->from(array('e' => TB_EMPREENDIMENTO), array('empreendimento_nome' => 'e.nm_empreendimento', 'empreendimento_id' => 'e.id'))
            ->join(array('l' => TB_LOTES), 'e.id = l.id_empreendimento', array())
            ->join(array('c' => TB_CONTRATO), 'l.id = c.id_lote', array())
            ->join(array('p' => TB_PARCELA), 'c.id = p.id_contrato', array());

        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $empreendimentos->where("e.id IN({$id})");
                } else {
                    $empreendimentos->where("1");
                }
            } catch (Exception $e) {
            }
        }

        $empreendimentos = $empreendimentos->order('nm_empreendimento')->query()->fetchAll();

        $this->set('empreendimentos', $empreendimentos);

        $CartaCobranca = new Modelo();
        $listaCartaCobranca = $CartaCobranca->getAdapter()->select()
            ->from(array('co' => TB_MODELO))
            ->where('co.tp_modelo = "CC"')
            ->order('co.nm_titulo')
            ->query()->fetchAll();

        $this->set('tipoCarta', $listaCartaCobranca);

        if ($this->_isPost) {
            $hitoricoCartas = new CartaHistorico();
            $empreendimento = Empreendimento::findEmpreendimento($_POST['cartaCobrancaEmpreendimento']);
            $contratos = array();
            $clienteAcade = new Db_Cliente();
            $cidade = new Db_Cidade();

            $empresa = Db_Cliente::getCliente();

            $loCartaCobranca = new Modelo();
            $cartaCobranca = $loCartaCobranca->find($_POST['cartaCobrancaTipo'])->current();
            $this->set("cartaCobranca", $cartaCobranca);

            $clienteAcadeone = $clienteAcade->fetchRow();
            $this->set("clienteAcadeone", $clienteAcadeone);

            $clienteAcadeoneCidade = $cidade->find($clienteAcadeone['cd_municipio']);
            $this->set("clienteAcadeoneCidade", $clienteAcadeoneCidade);

            //Controi array dos contratos dos clientes a serem exibidos
            $cartaCobrancaClientes = $_POST['cartaCobrancaClientes'];
            if($cartaCobrancaClientes[0]=="-1"){
                $contratosEmpreendimento = Contrato::byEmpreendimentoParcelasAbertas($_POST['cartaCobrancaEmpreendimento'], Contrato::CONTRATO_TODOS, array("nm_pessoa", "lote", "quadra", "id"), false,true);
                $cartaCobrancaClientes = array();
                foreach ($contratosEmpreendimento as $contrato) {
                    $cartaCobrancaClientes[] = $contrato['id'];
                }
            }

            $emitirJuridico = ($_POST['emitirJuridico'] == 'S') ? true : false;
            
            foreach ($cartaCobrancaClientes as $cliente) {

                try {
                    //Monta os dados da carta
                    $contratos[$cliente] = Contrato::findContratoById($cliente, null, $emitirJuridico);
                    if($emitirJuridico == false){
                        if(!$emitirJuridico){
                            if($contratos[$cliente]['id_juridico']){
                                unset($contratos[$cliente]);
                                continue;
                            }
                        }
                    }
                    $contratos[$cliente]['lote'] = Lote::loteById($contratos[$cliente]['id_lote']);
                    $contratos[$cliente]['cliente'] = Pessoa::findById($contratos[$cliente]['idPessoa']);
                } catch (Exception $e) {
                    $this->_helper->addMensagem('cartaCobrancaTipo', 'Erro! Favor contactar o suporte da Acade.');
                }

                $parcelas = new Parcela();
                $contratos[$cliente]['parcelas'] = $parcelas->fetchAll("dt_parcela < NOW() AND id_contrato = {$cliente} AND pago = '0' AND tp_parcela NOT IN ('E', 'NE', 'SE', 'CE', 'IE')");
                if(isset($_POST['parcelaFinal']) &&$_POST['parcelaFinal']&& isset($_POST['parcelaInicial'])&&$_POST['parcelaInicial']){
                    if(count($contratos[$cliente]['parcelas'])<$_POST['parcelaInicial']||count($contratos[$cliente]['parcelas'])>$_POST['parcelaFinal']){
                        unset($contratos[$cliente]);
                        continue;
                    }                    
                }
                $contratos[$cliente]['pj'] = Pessoa::getDefaultAdapter()->select()->from(array(TB_PESSOA), "PESSOA.nm_pessoa")
                    ->join(array(TB_REPRESENTANTE), "REPRESENTANTE.id_pessoa_juridica = PESSOA.id", "*")
                    ->join(array(TB_PARCERIA), "PARCERIA.id_pessoa = REPRESENTANTE.id_pessoa", "*")
                    ->where("id_empreendimento = {$_POST['cartaCobrancaEmpreendimento']}")->query()->fetch();

                //Cria o string com as parcelas no formato id/tipo (Ex: 2/S)
                $auxParcelas = '';
                $primeira = '';
                foreach ($contratos[$cliente]['parcelas'] as $parcela) {
                    $auxParcelas .= $primeira . $parcela->id_parcela . '/' . $parcela->tp_parcela;
                    $primeira = ', ';
                }

                // Busca se alguma carta do mesmo tipo j foi gerada mas nao foi enviada
                $cartaEnviada = $hitoricoCartas->fetchRow("id_contrato = '" . $cliente . "' AND id_carta_cobranca = '" . $_POST['cartaCobrancaTipo'] . "'");
                if ($cartaEnviada) {
                    $idCarta = $cartaEnviada->id_carta_historico;
                } else {
                    $hitoricoCartas = new CartaHistorico();
                    $novoHistorico = $hitoricoCartas->createRow();
                    $novoHistorico->id_contrato = $cliente;
                    $novoHistorico->id_carta_cobranca = $_POST['cartaCobrancaTipo'];
                    $novoHistorico->dt_carta_gerada = date('Y-m-d');
                    $novoHistorico->ds_parcela_contrato = $auxParcelas;
                    $novoHistorico->ds_log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - i');
                    $idCarta = $novoHistorico->save();
                }

                $contratos[$cliente]['cartaEnviada'] = $idCarta;

                //Verifica o tipo da carta para poder registrar como o devido contato realizado
                $cartaCobranca = new Modelo();
                $cartaCobranca = $cartaCobranca->fetchRow('cd_modelo = ' . $_POST['cartaCobrancaTipo']);
                if ($cartaCobranca) {
                    $cartaCobranca = $cartaCobranca->toArray();
                    $tipoCarta = $cartaCobranca['tp_modelo'];
                    $nmTitulo = $cartaCobranca['nm_titulo'];
                } else {
                    $tipoCarta = $_POST["cartaCobrancaTipo"];
                    switch ($tipoCarta) {
                        case '30':
                            $nmTitulo = '1 (Cobrana)';
                            break;
                        case '60':
                            $nmTitulo = '2 (Notif. SPC/SER.)';
                            break;
                        case '3C':
                            $nmTitulo = '3 (Aviso - Set. Jur.)';
                            break;
                        case '5C':
                            $nmTitulo = '5 (Reneg. / Canc.)';
                            break;
                        case '6C':
                            $nmTitulo = '9 (Cancelamento)';
                            break;
                        default:
                            $nmTitulo = '1 (Cobrana)';
                            break;
                    }
                }

                $this->set('nmTitulo', $nmTitulo);

                //Grava a operao no log de contatos realizados com o lote e quadra do contrato
                (new Relacionamento())->saveContato(53, date('Y-m-d'), $cliente, 'Log: Carta Cobrana: ' . $tipoCarta . ' - ' . $nmTitulo . ' - Parcelas: ' . $auxParcelas);
            }

            if ($empreendimento->fl_assinatura == 'PE' || $empreendimento->fl_assinatura == 'PI') {
                if ($_POST['campoRemetente'] == 'E') {
                    $remetente = $this->tb_pessoa->getAdapter()->select()
                        ->from(array('p' => TB_PESSOA), array('nm_pessoa', 'endereco', 'nr_endereco', 'ds_complemento', 'nm_bairro', 'nr_cep'))
                        ->join(array('ci' => TB_CIDADE), 'p.cd_cidade = ci.id', array('nomeCidade' => 'nome', 'uf'))
                        ->where('p.id = ' . $_POST['cartaCobrancaRemetentes'][0])
                        ->query()->fetch();
                }

                if ($_POST['campoAssinatura'] == 'E') {
                    $assinaturaPessoa = $this->tb_pessoa->getAdapter()->select()
                        ->from(array('p' => TB_PESSOA), array('nm_pessoa', 'endereco', 'nr_endereco', 'ds_complemento', 'nm_bairro', 'nr_cep'))
                        ->join(array('ci' => TB_CIDADE), 'p.cd_cidade = ci.id', array('nomeCidade' => 'nome', 'uf'))
                        ->where('p.id = ' . $_POST['cartaCobrancaAssinatura'][0])
                        ->query()->fetch();
                    $assinatura = $assinaturaPessoa['nm_pessoa'];
                }
            } else {
                if ($_POST['campoAssinatura'] == 'E')
                    $assinatura = $empreendimento->nm_empreendimento;
                
                if ($_POST['campoRemetente'] == 'E') {
                    $remetente = $empreendimento;
                    $remetenteCidade = $cidade->find($remetente->cd_cidade);

                    if (!isset($remetenteCidade)) {
                        $this->redir(array("modulo" => "fin", "controller" => "cartaCobranca", "action" => "listar"), array("exception" => 'Este remetente no possui endereo cadastrado.'));
                        exit();
                    }
                }
            }

            $this->set('remetente', $remetente);
            $this->set('assinatura', $assinatura);
            $this->set('remetenteCidade', $remetenteCidade);
            $this->set('tipoCarta', $_POST["cartaCobrancaTipo"]);
            $this->set('contratos', $contratos);
            $this->set("empresa", $empresa);
            $this->set("empreendimento", $empreendimento);
            $this->set("cliente", $cliente);

            $this->display('imprime');
            $this->displayPDF("carta_de_cobranca.pdf");
        }

        $this->display('adicionarVarias');
    }

    public function validarAction()
    {
        if(!$_POST['cartaCobrancaClientes'][0]=="-1"){
            $parcelas = new Parcela();
            $atrasadas = $parcelas->fetchAll("dt_parcela < NOW() AND id_contrato = {$_POST['cartaCobrancaClientes'][0]} AND pago = '0' AND tp_parcela NOT IN ('E', 'NE', 'SE', 'CE', 'IE')")->toArray();
            //verifica se o contrato no possui parcelas atrasadas.
            if (!$atrasadas) {
                $this->_helper->addMensagem('', 'O contrato ' . $_POST['cartaCobrancaClientes'][0] . ', no possui parcelas atrasadas.');
            }
        }
        else{
            $contratosEmpreendimento = Contrato::byEmpreendimentoParcelasAbertas($_POST['cartaCobrancaEmpreendimento'], Contrato::CONTRATO_TODOS, array("nm_pessoa", "lote", "quadra", "id"), false,true);
            if(!count($contratosEmpreendimento)){
                $this->_helper->addMensagem('', 'Nenhum contrato possui parcelas atrasadas.');
            }
        }
        $campos = array('cartaCobrancaTipo', 'cartaCobrancaEmpreendimento', 'cartaCobrancaClientes');

        foreach ($campos as $ind => $campo) {
            if ($_POST[$campo] == '') {
                switch ($campo) {
                    case 'cartaCobrancaEmpreendimento':
                        $msg = "O campo empreendimento  obrigatrio.";
                        $this->_helper->addMensagem($campo, $msg);
                        break;
                    case 'cartaCobrancaTipo':
                        $msg = "O campo Tipo de Carta  obrigatrio.";
                        $this->_helper->addMensagem($campo, $msg);
                        break;
                    case 'cartaCobrancaClientes':
                        $msg = "O campo de Contratos  Obrigatrio.";
                        $this->_helper->addMensagem($campo, $msg);
                        break;
                }
            }
        }

        $empreendimento = Empreendimento::findEmpreendimento($_POST['cartaCobrancaEmpreendimento']);

        if ($empreendimento->fl_assinatura == 'PE' || $empreendimento->fl_assinatura == 'PI' || $empreendimento->fl_assinatura == 'E') {
            if ($_POST['campoRemetente'] == 'E' && $_POST['cartaCobrancaRemetentes'][0] == '') {
                $msg = "O campo de Remetente  obrigatrio.";
                $this->_helper->addMensagem('campoRemetente', $msg);
            }
            if ($_POST['classAssinatura'] == 'E' && $_POST['cartaCobrancaAssinatura'][0] == '') {
                $msg = "O campo de assinatura  obrigatrio.";
                $this->_helper->addMensagem('campoAssinatura', $msg);
            }
        }

        //Mensagem de Erros
        if (count($this->_helper->getMensagens()) > 0) {
            $msgErros = '';
            foreach ($this->_helper->getMensagens() as $msg => $a)
                $msgErros .= utf8_encode($a) . '<br>';
            echo json_encode(array('msgErros' => $msgErros));
        } else {
            echo json_encode(true);
        }
    }

    public function remetenteByEmpreedimentoAction()
    {

        $empreendimento = Empreendimento::findEmpreendimento($_POST['id_empreendimento']);

        if ($empreendimento->fl_assinatura == 'PE') {

            $parceiros = $this->tb_assinatura->getAdapter()->select()
                ->from(array("a" => TB_ASSINATURA), '')
                ->join(array("p" => TB_PESSOA), 'p.id = a.id_pessoa', array('nmPessoa' => 'nm_pessoa', 'id'))
                ->join(array("pf" => TB_PESSOA_FISICA), 'pf.id_pessoa = p.id', array('nrCpfRepresentante' => 'nr_cpf'))
                ->where('a.id_empreendimento = ' . $empreendimento->id)
                ->query()->fetchAll();
        } else if ($empreendimento->fl_assinatura == 'PI') {

            $parceiros = $this->tb_parceria->getAdapter()->select()
                ->from(array("pa" => TB_PARCERIA), '')
                ->join(array("pe" => TB_PESSOA), 'pa.id_pessoa = pe.id', array('id', 'nmPessoa' => 'nm_pessoa', 'tp_pessoa'))
                ->joinLeft(array("pf" => TB_PESSOA_FISICA), 'pe.id = pf.id_pessoa', array('nr_cpf'))
                ->joinLeft(array("pj" => TB_PESSOA_JURIDICA), 'pe.id = pj.id_pessoa', array('nr_cnpj'))
                ->where('pa.id_empreendimento = ' . $empreendimento->id)
                ->query()->fetchAll();
        }

        $lista = array();

        if ($empreendimento->fl_assinatura == 'E') {
            $lista[] = array('id' => 'emp', 'text' => utf8_encode($empreendimento->nm_empreendimento));
        } else {
            foreach ($parceiros as $parceiro) {
                $lista[] = array('id' => $parceiro['id'], 'text' => utf8_encode($parceiro['nmPessoa']));
            }
        }
        
        echo json_encode($lista);
    }

    public function alteraRemetenteAction()
    {
        $id_contrato = $_POST['id'];

        if (isset($id_contrato) && $this->isAjax()) {

            $modelo_dados = new Modelo();
            $contratoDetalhes = $modelo_dados->getAdapter()->select()
                ->from(
                    array('co' => TB_CONTRATO),
                    array(
                        'contratoId' => 'co.id', 'clienteNome' => 'pe.nm_pessoa', 'quadra' => 'lo.quadra', 'lote' => 'lo.lote', 'em.*'
                    )
                )
                ->join(array('pe' => TB_PESSOA), 'pe.id = co.id_pessoa')
                ->join(array('lo' => TB_LOTES), 'co.id_lote = lo.id')
                ->join(array('em' => TB_EMPREENDIMENTO), 'lo.id_empreendimento = em.id')
                ->where('co.id = ?', $id_contrato)
                ->query()->fetchAll();
            
            switch ($contratoDetalhes[0]['fl_assinatura']) {
                case 'PE':
                case 'PI':
                    try {
                        $teste_modelo = new Modelo();
                        $parcerias = $teste_modelo->getAdapter()->select()
                            ->from(array('pa' => TB_PARCERIA), '*')
                            ->where("pa.id_empreendimento = ?", $contratoDetalhes[0]['id_empreendimento'])
                            ->query()->fetchAll();


                        $pessoas_id = array();
                        foreach ($parcerias as $parceria) {
                            $pessoas_id[] = $parceria['id_pessoa'];
                        }
                        $remetentes = $teste_modelo->getAdapter()->select()
                            ->from(array('pe' => TB_PESSOA), '*')
                            ->where("pe.id IN(?)", $pessoas_id)
                            ->query()->fetchAll();

                        $loCartaCobranca = new Modelo();
                        $cartas = $loCartaCobranca->getAdapter()->select()
                            ->from(array('co' => TB_MODELO))
                            ->where('co.tp_modelo = "CC"')
                            ->order('co.cd_modelo')
                            ->query()->fetchAll();

                        $retorno['detalhes'][] = array(
                            'contratoId' => $contratoDetalhes[0]['contratoId'], 'contratoNome' => utf8_encode($contratoDetalhes[0]['clienteNome']), 'quadra' => utf8_encode($contratoDetalhes[0]['quadra']), 'lote' => utf8_encode($contratoDetalhes[0]['lote']), 'empreendimentoNome' => utf8_encode($contratoDetalhes[0]['nm_empreendimento'])
                        );

                        foreach ($remetentes as $remetente) {
                            $retorno['remetentes'][] = array(
                                'value' => $remetente['id'], 'text' => utf8_encode($remetente['nm_pessoa'])
                            );
                        }

                        foreach ($cartas as $carta) {
                            $retorno['cartas'][] = array(
                                'codModelo' => $carta['cd_modelo'], 'nomTitulo' => utf8_encode($carta['nm_titulo'])
                            );
                        }

                        header('Content-Type: application/json');
    
                        echo (json_encode($retorno));
                    } catch (Exception $e) {
                        die();                        
                    }
                    break;
                case 'E':
                    try {                        
                        $loCartaCobranca = new Modelo();
                        $cartas = $loCartaCobranca->getAdapter()->select()
                            ->from(array('co' => TB_MODELO))
                            ->where('co.tp_modelo = "CC"')
                            ->order('co.cd_modelo')
                            ->query()->fetchAll();

                        $retorno['detalhes'][] = array(
                            'contratoId' => $contratoDetalhes[0]['contratoId'],
                            'contratoNome' => utf8_encode($contratoDetalhes[0]['clienteNome']),
                            'fl_assinatura' => utf8_encode($contratoDetalhes[0]['fl_assinatura']),
                            'quadra' => utf8_encode($contratoDetalhes[0]['quadra']),
                            'lote' => utf8_encode($contratoDetalhes[0]['lote']),
                            'empreendimentoNome' => utf8_encode($contratoDetalhes[0]['nm_empreendimento']
                            )
                        );

                        $retorno['remetentes'][] = array(
                            'value' => 'emp', 'text' => utf8_encode($contratoDetalhes[0]['nm_empreendimento'])
                        );

                        foreach ($cartas as $carta) {
                            $retorno['cartas'][] = array(
                                'codModelo' => $carta['cd_modelo'], 'nomTitulo' => utf8_encode($carta['nm_titulo'])
                            );
                        }

                        header('Content-Type: application/json');
    
                        echo (json_encode($retorno));
                    } catch (Exception $e) {
                        die();
                    }
                    break;
            }
        }
    }
}
