<?php

class CarneController extends Controller
{

    protected $parcela;
    protected $empreendimentos;

    public function __construct($request)
    {
        parent::__construct($request);
        $this->parcela = new Parcela();
        $this->empreendimentos = new Empreendimento();
    }

    public function indexAction()
    {
        $this->redir(array('modulo' => 'fin', 'controller' => 'carne', 'action' => 'gerar'));
    }

    public function gerarAction()
    {
        $empreendimentos = $this->empreendimentos->getDefaultAdapter()->select()
            ->from(array('e' => TB_EMPREENDIMENTO), array('e.nm_empreendimento', 'e.id'));

        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $empreendimentos->where("e.id IN({$id})");
                } else {
                    $empreendimentos->where("1");
                }
            } catch (Exception $e) {

            }
        }

        $empreendimentos = $empreendimentos->order('nm_empreendimento')->query()->fetchAll();

        $this->set('empreendimentos', $empreendimentos);

        if ($this->_isPost) {
            // var_dump($_POST['tipodocumento']);exit;

            //Organizas as variaveis a serem usadas
            $tpDocumento = $_POST['tipodocumento'];
            $dataA = Helper::getInputDate($_POST['dtInicioDuplicata']);
            $dataB = Helper::getInputDate($_POST['dtFinalDuplicata']);
            $contrato = $_POST['duplicata_contrato'];
            $empreendimento = $_POST['duplicata_empreendedimento'];

            $tipos = '(';
            foreach ($_POST['tipos'] as $tipo) {
                $tipos .= "'$tipo',";
            }
            $tipos = substr($tipos, 0, -1) . ")";

            $parcelas = $this->parcela->getAdapter()->select()
                ->from(array('p' => TB_PARCELA), array('id_parcela', 'id_contrato', 'acrescimo', 'desconto',
                    'dt_parcela', 'vl_parcela', 'tp_parcela', 'id_parcela_contrato'))
                ->join(array('c' => TB_CONTRATO), 'c.id = p.id_contrato', array('nr_parcela', 'nr_parcela_sinal', 'nr_intercalada',
                    'nr_parcela_entrega'))
                ->join(array('pe' => TB_PESSOA), 'pe.id = c.id_pessoa', array('*'))
                ->joinLeft(array('pf' => TB_PESSOA_FISICA), 'pe.id = pf.id_pessoa', array('nr_cpf'))
                ->join(array('l' => TB_LOTES), 'l.id = c.id_lote', array('lote', 'quadra'))
                ->join(array('b' => TB_BANCO), 'b.id = c.id_banco', array('nm_cedente', 'cnpj_cedente', 'cpf_cedente', 'multa', 'juros'))
                ->join(array('e' => TB_EMPREENDIMENTO), 'e.id = l.id_empreendimento', array('nm_empreendimento'))
                ->join(array('cd' => TB_CIDADE), 'cd.id = pe.cd_cidade', array('nome', 'uf'))
                ->join(array('ci' => TB_CIDADE), 'ci.id = e.cd_cidade', array('cdempreendimento'=>'nome','ufempreendimento'=> 'uf'))
                ->where('e.id = ?', $empreendimento)
                ->where('id_contrato = ?', $contrato)
                ->where("dt_parcela BETWEEN '" . $dataA . "' AND '" . $dataB . "'")
                ->where("tp_parcela IN $tipos")
                ->where('p.pago = "0"')
                ->query()->fetchAll();

            //Validao para verificar se parcelas esta vindo!!!
            if (!$parcelas) {
                $this->_helper->addMensagem(null, 'No h parcelas nesse periodo de datas.');
                $this->display('gerar');
                return $this->_helper->getMensagens();
            }

            $contatoParcelas = array();
            foreach ($parcelas as &$parcela) {
                switch ($parcela['tp_parcela']) {
                    case 'N':
                        $parcela['nrParcela'] = $parcela['id_parcela'] . '/' . $parcela['nr_parcela'] . 'N';
                        break;
                    case 'I':
                        $parcela['nrParcela'] = $parcela['id_parcela'] . '/' . $parcela['nr_intercalada'] . 'I';
                        break;
                    case 'S':
                        $parcela['nrParcela'] = $parcela['id_parcela'] . '/' . $parcela['nr_parcela_sinal'] . 'S';
                        break;
                    case 'C':
                        $parcela['nrParcela'] = $parcela['id_parcela'] . '/' . $parcela['nr_parcela_entrega'] . 'C';
                        break;
                    case 'Q':
                        $parcela['nrParcela'] = $parcela['id_parcela'] . 'Q';
                        break;
                    case 'G':
                        $parcela['nrParcela'] = $parcela['id_parcela'] . 'G';
                        break;
                    case 'A':
                        $parcela['nrParcela'] = $parcela['id_parcela'] . 'A';
                        break;
                }
                $parcela['juros'] = $this->_helper->getMoney($parcela['juros'] * 0.01 * $parcela['vl_parcela']);
                $parcela['multa'] = $this->_helper->getMoney($parcela['multa'] * 0.01 * $parcela['vl_parcela']);

                $contatoParcelas[] = $parcela['id_parcela'] . '-' . $parcela['tp_parcela'];
            }

            $dados['parcelas'] = $parcelas;

            $this->set("dados", $dados);
            //Antes de redirecionar grava o resultado no log dos contatos realizados como Duplicata.
            if($tpDocumento == '1') {//Duplicata
                (new Relacionamento())->saveContato(42, date('Y-m-d'), $contrato, 'Log: Gerado Duplicatas: ' . implode(',', $contatoParcelas));
                //Forma de redirecionar antes para gerar o pdf.
                $this->action = 'duplicata'; 
                $this->displayMPDF("recibo" . date("d/m/Y") . ".pdf", true, "P", "A4", array(1, 1, 1, 1));
            }
            else{ //Nota promissria
                (new Relacionamento())->saveContato(42, date('Y-m-d'), $contrato, 'Log: Gerado Nota Promissria: ' . implode(',', $contatoParcelas));
                $this->action = 'notaPromissoria'; 
                $this->displayMPDF("recibo" . date("d/m/Y") . ".pdf", true, "P", "A4", array(1, 1, 1, 1));
            }
        }

        $this->display('gerar');
    }

    public function validarAction()
    {
        //Nova validao para verificar pelos Tipos, caso seja vazio
        if (count($_POST["tipos"]) == 0) {
            $this->_helper->addMensagem('tipos', 'Selecione pelo menos um tipo de parcela');
        }
        $campos = array('dtInicioDuplicata' => 'Informe a data de incio.',
            'dtFinalDuplicata' => 'Informe a data de fim.',
            'duplicata_empreendedimento' => 'Selecione o empreendimento.',
            'duplicata_contrato' => 'Selecione o contrato.');

        foreach ($campos AS $k => $msg) {
            if ($_POST[$k] == '') {
                $this->_helper->addMensagem($k, $msg);
            }
        }
        if ($this->_isPost && count($this->_helper->getMensagens()) == 0){
            $dataA = Helper::getInputDate($_POST['dtInicioDuplicata']);
            $dataB = Helper::getInputDate($_POST['dtFinalDuplicata']);
            $contrato = $_POST['duplicata_contrato'];
            $empreendimento = $_POST['duplicata_empreendedimento'];

            $tipos = '(';
            foreach ($_POST['tipos'] as $tipo) {
                $tipos .= "'$tipo',";
            }
            $tipos = substr($tipos, 0, -1) . ")";

            $parcelas = $this->parcela->getAdapter()->select()
                ->from(array('p' => TB_PARCELA), array('id_parcela', 'id_contrato', 'acrescimo', 'desconto',
                    'dt_parcela', 'vl_parcela', 'tp_parcela', 'id_parcela_contrato'))
                ->join(array('c' => TB_CONTRATO), 'c.id = p.id_contrato', array('nr_parcela', 'nr_parcela_sinal', 'nr_intercalada',
                    'nr_parcela_entrega'))
                ->join(array('pe' => TB_PESSOA), 'pe.id = c.id_pessoa', array('nm_pessoa'))
                ->joinLeft(array('pf' => TB_PESSOA_FISICA), 'pe.id = pf.id_pessoa', array('nr_cpf'))
                ->join(array('l' => TB_LOTES), 'l.id = c.id_lote', array('lote', 'quadra'))
                ->join(array('b' => TB_BANCO), 'b.id = c.id_banco', array('nm_cedente', 'cnpj_cedente', 'cpf_cedente', 'multa', 'juros'))
                ->join(array('e' => TB_EMPREENDIMENTO), 'e.id = l.id_empreendimento', array('nm_empreendimento'))
                ->where('e.id = ?', $empreendimento)
                ->where('id_contrato = ?', $contrato)
                ->where("dt_parcela BETWEEN '" . $dataA . "' AND '" . $dataB . "'")
                ->where("tp_parcela IN $tipos")
                ->where('p.pago = "0"')
                ->query()->fetchAll();

            if (!$parcelas) {
                $msg = "No h parcelas nesse periodo de datas.";
                $this->_helper->addMensagem('danger', $msg);
            }
        }
        //Mensagem de Erros
        if (count($this->_helper->getMensagens()) > 0) {
            $msgErros = '';
            foreach ($this->_helper->getMensagens() as $msg => $a)
                $msgErros .= utf8_encode($a) . '<br>';
            echo json_encode(array('msgErros' => $msgErros));
        } else {
            echo json_encode(true);
        }
    }

    //Action para gerar lista por AJAX do empreendimento.
    public function contratoByEmpreendimentoAction()
    {
        $contratos = Contrato::byEmpreendimento($_POST['id_empreendimento'], Contrato::CONTRATO_TODOS, 2, array("nm_pessoa", "lote", "quadra", "id"), true);

        $lista = array();
        foreach ($contratos as $contrato) {
            $lista[] = array('id' => $contrato['id'], 'text' => utf8_encode($contrato['nm_pessoa']) . ' Quadra: ' . utf8_encode($contrato['quadra']) . ' - Lote: ' . utf8_encode($contrato['lote']) . ' - Contrato: ' . utf8_encode($contrato['id']));
        }

        echo json_encode($lista);
    }
}

?>
