<?php

class BaixaParcelaController extends Controller
{

    public function __construct($request)
    {
        parent::__construct($request);
    }

    public function indexAction()
    {   
        $empreendimentos = new Empreendimento();
        $empreendimentos = $empreendimentos->getDefaultAdapter()->select()->from(array('e' => TB_EMPREENDIMENTO));
        $this->set('opcao', 'B');

        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $empreendimentos->where("e.id IN({$id})");
                } else {
                    $empreendimentos->where("1");
                }
            } catch (Exception $e) {

            }
        }
        $empreendimentos = $empreendimentos->order('nm_empreendimento')->query()->fetchAll();

        //Criada condicao para verificar se perfil tem permissao
        $alterarDados = (Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'alterarDatasBaixaManual') || Login::getUsuario()->getSuper() == 1);
        $this->set('alterarDados', $alterarDados);

        $this->set('empreendimentos', $empreendimentos);
        $this->set('tipoBaixa', array('B' => 'Banco', 'T' => 'Tesouraria', 'O' => 'Outros'));
        $this->set('formaBaixa', (new TabelaAgrupada)->fetchAll('idTabela = "28"')->toArray());

        if ($this->_isPost && $this->validar()) {
            $tb_agrupada = new TabelaAgrupada();
            $tb = $tb_agrupada->getAdapter()
                ->select()
                ->from(['a' => TB_AGRUPADA], '*')
                ->where('idTabela = ?', '28')
                ->where('idCampo = ?', $_POST['formaBaixa'])->query()->fetch();

            $formaBaixaDesc = $tb['descricao'];


            if ($_POST['opcao'] == 'B' && $_POST['id_parcela'])
                $idParcela = $_POST['id_parcela'];
            elseif ($_POST['opcao'] == 'N' && $_POST['nr_baixa'])
                $idParcela = $_POST['nr_baixa'];
            elseif ($_POST['opcao'] == 'I' && $_POST['id_parcela_aba_inativos'])
                $idParcela = $_POST['id_parcela_aba_inativos'];
            else {
                $this->redirect(array(
                    'modulo' => 'fin',
                    'controller' => 'alteraParcela',
                    'action' => 'index'),
                    array(
                        "exception" => "Opo Invlida."
                    ));
                exit;
            }

            try {
                $parcela = $_POST['opcao'] != 'I' ? new Parcela() : new ParcelaHistorico();

                $parcela = $parcela->fetchRow('id_parcela_contrato = ' . $idParcela);
                $parcela->vl_multa = $this->_helper->filters(Helper::getInputMoney($_POST['vl_multa'],'money'));
                $parcela->vl_juros = $this->_helper->filters(Helper::getInputMoney($_POST['vl_juros'],'money'));
                $parcela->desconto = $this->_helper->filters(Helper::getInputMoney($_POST['vlDesconto'],'money'));
                $parcela->vl_total_pago = ((float)$parcela->vl_parcela + (float)$parcela->acrescimo
                    + $parcela->vl_multa + $parcela->vl_juros - $parcela->desconto);
                $parcela->dt_pagamento = Helper::getInputDate($_POST["dt_pagamento"]);
                $parcela->obs_baixa = utf8_decode($_POST["obs"]);
                $parcela->tp_baixa = $_POST['tipoBaixa'];
                $parcela->fm_baixa = $_POST['formaBaixa'];  
                if ($_POST['banco'])
                    $parcela->id_banco = $_POST['banco'];
                $parcela->dt_credito = Helper::getInputDate($_POST["dt_credito"]);
                $parcela->pago = 1;
                $parcela->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - u');
                
                $idParcela = $parcela->save();
            } catch (Exception $e) {
                $this->redirect(array('modulo' => 'fin', 'controller' => 'alteraParcela', 'action' => 'index'), array("exception" => "No foi possvel realizar a operao. Erro: " . $e->getCode()));
                exit;
            }

            //Antes de redirecionar grava o resultado no log dos contatos realizados como Baixa de parcela.
            (new Relacionamento())->saveContato(42, date('Y-m-d'), $parcela->id_contrato, 'Log: Parcela Baixada - ' . $parcela->tp_parcela . '-' . $parcela->id_parcela);

            if ($idParcela && $_POST['tipoBaixa'] != 'O') {
                
                $empreendimento = Parcela::getIntegracaoEmpreendimento($parcela->id_parcela_contrato, ($_POST['tipoBaixa'] == 'T') ? true : false );
                
                if ($empreendimento) {
                    //Criando uma nova linha para insercao no acadefinan
                    $adapter = $this->getAdapterIntegracao();
                    $adapter->beginTransaction();
                    $parcelaBackup = $parcela->toArray();
                    $contrato = Contrato::findContrato($parcelaBackup['id_contrato']); 
                    try {
                        $data = explode('-', $parcelaBackup['dt_credito']);
                        $contaDados = array(
                            'cd_plano_conta' => $empreendimento['cd_conta_credito'],
                            'cd_centro_custo' => $empreendimento['cd_centro_custo'],
                            'nr_mes_competencia' => $data[1],
                            'nr_ano_competencia' => $data[0],
                            'dt_documento' => $parcelaBackup['dt_credito'],
                            'nr_parcelas' => 1,
                            'vl_total' => $parcelaBackup['vl_total_pago'],
                            'tp_conta_pagar_receber' => 'R',
                            'ds_observacao' => 'Baixa manual - Loteamento: ' . $empreendimento['nm_empreendimento'] . ' - ' . $contrato->nm_pessoa . ' Quadra: ' . $contrato->quadra . ' Lote: ' .$contrato->lote . " - Parcela {$parcelaBackup['id_parcela']}/{$parcelaBackup['tp_parcela']}",
                            'log' => (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - u')
                        );
                        $adapter->insert('afn006', $contaDados);
                        $idConta = $adapter->lastInsertId('afn006');

                        //Insercao na tabela de Parcelas de Contas a Pagar
                        $parcelaDados = array(
                            'cd_conta_pagar_receber' => $idConta,
                            'cd_forma_pagamento' => 1,
                            'cd_local_pagamento' => $empreendimento['id_finan'],
                            'nr_parcela' => 1,
                            'vl_parcela' => $parcelaBackup['vl_total_pago'],
                            'dt_vencimento' => $parcelaBackup['dt_credito'],
                            'dt_pagamento' => $parcelaBackup['dt_credito'],
                            'dt_debito' => $parcelaBackup['dt_credito'],
                            'tp_situacao' => 'P'
                        );
                        if ($_POST['tipoBaixa'] == 'T')
                            $parcelaDados['cd_local_pagamento'] = $empreendimento['cd_conta_tesouraria'];
                        $adapter->insert('afn007', $parcelaDados);
                    } catch (Exception $e) {
                        $adapter->rollBack();
                        $this->redir(array('modulo' => 'fin',
                            "controller" => "baixaParcela",
                            "action" => "index"), array("warning" => "No foi possvel gravar as contas pela integrao com Finan."));
                    }
                    $adapter->commit();
                }
            }
            //Geracao de comprovante de recibo
            $idRecibo = '';
            if ($_POST['recibo'] == '1') {

                if (isset($_POST['id_empreendimento']) && $_POST['id_empreendimento']!= '')
                {
                    $idEmpreendimento = ($_POST['id_empreendimento'])?$_POST['id_empreendimento']:$_POST['empreendimento'];
                } else if(isset($_POST['nm_id_empreendimento']) && $_POST['nm_id_empreendimento']!= '') {
                    $idEmpreendimento = ($_POST['nm_id_empreendimento'])?$_POST['nm_id_empreendimento']:$_POST['empreendimento'];
                } else {
                    $idEmpreendimento = ($_POST['id_empreendimento_aba_inativos'])?$_POST['id_empreendimento_aba_inativos']:$_POST['empreendimento'];
                }

                //Procurando informacao da cidade para enviar nome da cidade.
                $empreendimentos = new Empreendimento();
                $empreendimento = $empreendimentos->getAdapter()->select()
                    ->from(array('e' => TB_EMPREENDIMENTO), array('nm_empreendimento'))
                    ->joinLeft(array("m" => TB_CIDADE), "e.cd_cidade = m.id", array("cidadeEmp" => "nome", "ufEmp" => "uf"))
                    ->joinLeft(array('tp' => TB_TIPO_LOTEAMENTO), "e.id_tipo_loteamento = tp.id_tipo_loteamento", array('ds_grupo', 'ds_subgrupo'))
                    ->where('e.id = ?', $idEmpreendimento)
                    ->query()->fetch();

                $cidade = $empreendimento['cidadeEmp'].' - '.$empreendimento['ufEmp'];

                //Pegando o id da pessoa, pelo contrato.
                $contrato = New Contrato();
                $lote = new Lote();

                if (isset($_POST['id_contrato']) && $_POST['id_contrato'] != '')
                {
                    $idContrato = $_POST['id_contrato'];
                } else if(isset($_POST['nm_id_contrato']) && $_POST['nm_id_contrato'] != '') {
                    $idContrato = $_POST['nm_id_contrato'];
                } else {
                    $idContrato = $_POST['id_contrato_aba_inativos'];
                }

                $contratoPessoa = $contrato->fetchRow('id = ' . $idContrato);
                $loteInfo = $lote->fetchRow('id= ' . $contratoPessoa['id_lote']);

                //Inserindo na tabela Recibo.
                $recibo = New Recibo();
                $novoRecibo = $recibo->createRow();
                $novoRecibo->id_pessoa = $contratoPessoa['id_pessoa'];
                $novoRecibo->id_empreendimento = $idEmpreendimento;
                $novoRecibo->id_taxa = null;
                $novoRecibo->vl_recibo = $parcela->vl_total_pago;
                $novoRecibo->vl_desconto = null;

                //Condicao para inserir valor de multa, juros, acrescimo e desconto no recibo.
                $vlMulta = ($_POST['vl_multa'] > 0) ? ' - Multa: R$' . $_POST['vl_multa'] : '';
                $vlJuros = ($_POST['vl_juros'] > 0) ? ' - Juros: R$' . $_POST['vl_juros'] : '';
                $vlAcrescimo = ($parcela->acrescimo > 0) ? ' - Acrescimo: R$' . Helper::getMoney($parcela->acrescimo) : '';
                $vlDesconto = ($_POST['vlDesconto'] > 0) ? ' - Desconto: R$' . $_POST['vlDesconto'] : '';
                $novoRecibo->ds_forma_pagamento = $formaBaixaDesc . $vlMulta . $vlJuros . $vlAcrescimo . $vlDesconto;

                $novoRecibo->ds_info_adicional = $parcela->id_parcela . $parcela->tp_parcela . ' - Venc. ' . Helper::getDate($parcela->dt_parcela).' - '. $empreendimento['ds_grupo'].': '.$loteInfo['quadra'].' - ' . $empreendimento['ds_subgrupo'].': '.$loteInfo['lote'].' - Ct: '.$idContrato.'$'.$cidade;
                $novoRecibo->dt_recibo = Helper::getInputDate($parcela->dt_pagamento);
                $novoRecibo->fl_status = 1;
                $novoRecibo->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - u');
                $idRecibo = $novoRecibo->save();
            }

            echo json_encode(array('msgSucess' => true, 'msgErros' => '','idRecibo'=>$idRecibo));
        } else {
            $this->display();
        }
    }

    /*
     * Funcao que valida o formulario
     */
    private function validar()
    {
        $campos = array("id_empreendimento", "tipoBaixa", "id_contrato", 'id_parcela', 'dt_pagamento', 'dt_credito', 'formaBaixa');

        if ($_POST['opcao'] == 'N') {
            if ($_POST['nr_baixa'] == '') {
                $this->_helper->addMensagem("nr_baixa", "O campo numero deve ser preenchido.");
            }
        } elseif ($_POST['opcao'] == 'B') {
            foreach ($campos as $cp) {
                if ($_POST [$cp] == "") {
                    $msg = '';
                    switch ($cp) {
                        case "id_empreendimento" :
                            $msg = "Selecione o <b>Empreendimento</b>";
                            break;
                        case "id_contrato" :
                            $msg = "Selecione o <b>Contrato</b>";
                            break;
                        case 'id_parcela':
                            $msg = "Selecione a <b>Parcela</b>";
                            break;
                        case 'dt_pagamento':
                            $msg = "Preencha a <b>Data do Pagamento</b>";
                            break;
                        case 'dt_credito':
                            $msg = "Preencha a <b>Data de Crdito</b>";
                            break;
                        case 'formaBaixa':
                            $msg = "Selecione a forma da baixa</b>";
                            break;
                    }
                    $this->_helper->addMensagem($cp, $msg);
                }
            }
        }

        if ($_POST['tipoBaixa'] == '') {
            $this->_helper->addMensagem("tipoBaixa", "Selecione o <b>Tipo de Baixa</b>");
        }

        if ($_POST['tipoBaixa'] == 'B') {
            if ($_POST['banco'] == '') {
                $this->_helper->addMensagem("banco", "Selecione o <b>Banco</b>");
            }
        }

        if ($_POST['dt_pagamento'] != '' && $_POST['dt_credito'] != '') {
            $dt_pagamento = new DateTime(Helper::getInputDate($_POST['dt_pagamento']));
            $dt_credito = new DateTime(Helper::getInputDate($_POST['dt_credito']));
            
            $verificarData = explode('/', $_POST['dt_pagamento']);
            if($verificarData[2] < 1900){
                $msg = "A data de pagamento no pode ser inferior a 1900";
                $this->_helper->addMensagem('dt_pagamento_dt_credito', $msg);
            }
            if (date_diff($dt_pagamento, $dt_credito)->format('%R%a') < 0) {
                $msg = "A data de pagamento tem que ser antes ou igual a Data de Crdito.";
                $this->_helper->addMensagem('dt_pagamento_dt_credito', $msg);
            }
        }
        //Alterada validacao, para verificar as informacoes agora pelo AJAX
        if (count($this->_helper->getMensagens()) > 0) {
            $msgErros = '';
            foreach ($this->_helper->getMensagens() as $msg => $a)
                $msgErros .= utf8_encode($a) . '<br>';
            echo json_encode(array('msgErros' => $msgErros));
            exit;
        } else {
            return true;
        }
    }

    /**
     * para gerar boleto e remessa
     */
    public function bancoEmpreendimentoAction()
    {
        $empreendimento_id = isset($_POST['id_empreendimento']) ? $_POST['id_empreendimento'] : $_POST['id_empreendimento_aba_inativos'];
        $bancos = Banco::findByEmpreendimento($empreendimento_id, true, true);
        
        $response[] = array('id'=>'','text'=>'');
        
        foreach ($bancos as $banco) {
            $response[] = array(
                'id' => $banco['id'],
                'text' => utf8_encode(Banco::findBancoNome($banco['cd_banco'])) . ' Ag.: ' . $banco['agencia'] . '-'
                    . $banco['agencia_dv'] . ' - Cc.: ' . $banco['conta_corrente'] . '-' . $banco['conta_corrente_dv']
            );
        }

        echo json_encode($response);
    }

    /**
     *Pega informacoes da parcela e calcula valor total.
     */
    public function calculaValorTotalAction()
    {
        if (isset($_POST['numero']))
        {
            $parcela = Parcela::getParcelaCompletaById($_POST['numero']);
        } else {
            $parcela = Parcela::getParcelaHistoricoCompletaById($_POST['numeroAbaInativos']);
        }

        $dtParcela = explode('/', $parcela['dt_parcela']);
        $dtParcela = $dtParcela[2].'-'.$dtParcela[1].'-'.$dtParcela[0];
        //este if serve para caso o valor do desconto de $parcela seja nulo.
        //neste caso este if ir pesquisar na tabela de contrato, pelos valores contidos em vl_desc_normal ou
        //vl_desc_sinal ou vl_desc_intercalada ou vl_desc_chave.
        if (($parcela['desconto'] < 1 && $dtParcela > date('Y-m-d')) || ($parcela['desconto'] == null && $dtParcela > date('Y-m-d'))) {
            $contratos = new Contrato();
            $contrato = $contratos->getAdapter()->select()
                ->from(array('c' => TB_CONTRATO), array('fl_desc_normal', 'vl_desc_normal', 'fl_desc_intercalada',
                    'vl_desc_intercalada', 'fl_desc_chave', 'vl_desc_chave', 'fl_desc_sinal', 'vl_desc_sinal'))
                ->where('c.id = '.$parcela['id_contrato'])
                ->query()->fetch();

            if ($contrato) {

                if ($parcela['tp_parcela'] == 'N') {
                    if ($contrato['fl_desc_normal'] == 'P') {
                        $parcela['desconto'] = $parcela['vl_parcela'] / 100 * $contrato['vl_desc_normal'];
                    } elseif ($contrato['fl_desc_normal'] == 'V') {
                        $parcela['desconto'] = $contrato['vl_desc_normal'];
                    }
                }

                elseif ($parcela['tp_parcela'] == 'I') {
                    if ($contrato['fl_desc_intercalada'] == 'P') {
                        $parcela['desconto'] = $parcela['vl_parcela'] / 100 * $contrato['vl_desc_intercalada'];
                    } elseif ($contrato['fl_desc_intercalada'] == 'V') {
                        $parcela['desconto'] = $contrato['vl_desc_intercalada'];
                    }
                }

                elseif ($parcela['tp_parcela'] == 'C') {
                    if($contrato['fl_desc_chave'] == 'P') {
                        $parcela['desconto'] = $parcela['vl_parcela'] / 100 * $contrato['vl_desc_chave'];
                    } elseif ($contrato['fl_desc_chave'] == 'V') {
                        $parcela['desconto'] = $contrato['vl_desc_chave'];
                    }
                }

                elseif ($parcela['tp_parcela'] == 'S') {
                    if($contrato['fl_desc_sinal'] == 'P') {
                        $parcela['desconto'] = $parcela['vl_parcela'] / 100 * $contrato['vl_desc_sinal'];
                    } elseif ($contrato['fl_desc_sinal'] == 'V') {
                        $parcela['desconto'] = $contrato['vl_desc_sinal'];
                    }
                }
            }
        }

        $dataBase = (isset($_POST['dataPagamento'])) ? $_POST['dataPagamento'] : date("d/m/Y");
        $atraso = Helper::date_diff(Helper::getInputDate($parcela["dt_parcela"]), Helper::getInputDate($dataBase));
        $multa = 0;
        $juros = 0;

        if ($atraso > 0) {
            if ($parcela['tp_juros'] != 'S') {
                $juros = ($parcela['tp_juros'] == 'P') ? Helper::parseFloat($parcela['juros'] / 100) * $parcela['vl_parcela'] : Helper::parseFloat($parcela['juros']);
                $juros = $juros*$atraso;
            }
            if ($parcela['tp_multa'] != 'S') {
                $multa = ($parcela['tp_multa'] == 'P') ? Helper::parseFloat($parcela['multa'] / 100) * $parcela['vl_parcela'] : Helper::parseFloat($parcela['multa']);
            }
        }

        $total = Helper::parseFloat($parcela['vl_parcela']) + $juros + $multa + $parcela['acrescimo'] - $parcela['desconto'];
        echo json_encode(array(
            'valor' => $parcela['vl_parcela'],
            'dt_vencimento' => $parcela['dt_parcela'],
            'acrescimo' => $parcela['acrescimo'],
            'desconto' => $parcela['desconto'],
            'juros' => $juros,
            'multa' => $multa,
            'total' => $total
        ));
    }

    /**
     * Pega as informacoes da parcela e as converte.
     */
    public function parcelaDadosAction()
    {
        $dados = Parcela::getParcela($_POST['numero']);

        if($dados){
            $data['nm_empreendimento'] = utf8_encode($dados['nm_empreendimento']);
            $data['nm_pessoa'] = utf8_encode($dados['nm_pessoa']);
            $data['quadra'] = utf8_encode($dados['quadra']);
            $data['lote'] = utf8_encode($dados['lote']);
            $data['dt_parcela'] = Helper::getDate($dados['dt_parcela']);
            $data['id_contrato'] = $dados['id_contrato'];
            $data['id_parcela'] = $dados['id_parcela'];
            $data['tp_parcela'] = $dados['tp_parcela'];
            $data['status'] = $dados['pago'] == '1'? $data['status'] = 'Pago' : $data['status'] = 'Aberto' ;
            $data['pago'] = $dados['pago'];
            $data['id_empreendimento'] = $dados['id_empreendimento'];
        }
        
        echo json_encode($data);
    }

    /**
     * Apartir do id de empreedimentos, busca informacoes do contrato.
     */
    public function contratoAtivoEmpreendimentoAction()
    {
        if (isset($_POST['id_empreendimento']))
        {
            $contratos = Contrato::byEmpreendimentoParcelasAbertas($_POST['id_empreendimento'], Contrato::CONTRATO_GERADO, array("nm_pessoa", "lote", "quadra", "id_contrato"), false);
        } else {
            $contratos = Contrato::byEmpreendimentoContratosDistratados($_POST['id_empreendimento_aba_inativos'], Contrato::CONTRATO_GERADO, array("nm_pessoa", "lote", "quadra", "id_contrato"), true);
        }

        $response = array();
        
        if (count($contratos))
        {
            foreach ($contratos as $contrato) 
            {                
                $response[] = array(
                    'id' => $contrato['id_contrato'],
                    'text' => utf8_encode($contrato['nm_pessoa']) . ' - Quadra: '
                            . utf8_encode($contrato['quadra']) . ' - Lote: ' . utf8_encode($contrato['lote']) . ' - Contrato: ' . $contrato['id_contrato']
                );
            }
        }
            
        echo json_encode($response);
    }

    /**
     * Apartir do contrato, pega parcelas nao pagas.
     */
    public function parcelaNPagaContratoAction()
    {
        if (isset($_POST['contrato']))
        {
            $parcelas = Parcela::findParcelasNPagasById($_POST['contrato']);
        } else {
            $parcelas = Parcela::findParcelasPorContratoDistratado($_POST['contratoInativo']);
        }
        
        $response = array();

        if (count($parcelas))
        {
            foreach ($parcelas as $parcela) 
            {
                $response[] = array(
                    'id' => $parcela['id_parcela_contrato'],
                    'text' => 'Parcela ' . $parcela['id_parcela'] . $parcela['tp_parcela'] . ' - Vencimento: '
                        . $parcela['dt_parcela']
                );
            }
        }

        echo json_encode($response);
    }

    /**
     * Calcula Multas e Juros, apartir dos dados da parcela.
     */
    public function calculaMultaJurosParcelaAction()
    {
        $instanceParcela = new Parcela();
        $select = $instanceParcela->getAdapter()->select();
        $parcelas = $select->from(array('p' => TB_PARCELA),
            array('id_parcela_contrato',
                'id_parcela',
                'id_negociacao',
                'tp_parcela',
                'dt_parcela',
                'vl_parcela',
                'acrescimo',
                'desconto',
                'pago',
                'tp_baixa',
                'id_remessa'))
            ->join(array('c' => TB_CONTRATO), 'p.id_contrato = c.id', array('nr_parcela', 'idDoContrato' => 'id'))
            ->where('id_parcela_contrato = ?', $_POST['parcela'])->query()->fetch();

        echo json_encode(array(
            'pago' => $parcelas['pago'],
            'remessa' => (isset($parcelas['id_remessa']) || $parcelas['id_remessa'] != ''),
            'valorParcela' => number_format($parcelas["vl_parcela"], 2, ',', '.'),
            'acrescimo' => number_format($parcelas['acrescimo'], 2, ',', '.'),
            'desconto' => number_format($parcelas['desconto'], 2, ',', '.'),
            'dt_vencimento' => Helper::getDate($parcelas['dt_parcela']),
            'valor' => number_format($parcelas["vl_parcela"], 2, ',', '.'),
            'tipoBaixa' => $parcelas['tp_baixa']
        ));
    }
}