<?php

class AlteracaoVencimentoController extends Controller
{

    public function indexAction()
    {
        $this->redirect(array('modulo' => 'fin', 'controller' => 'alteracaoVencimento', 'action' => 'alterarParcela'));
    }

    public function alterarParcelaAction()
    {
        $empreendimentos = (new Empreendimento())->getDefaultAdapter()->select()
            ->from(array('e' => TB_EMPREENDIMENTO), array('e.nm_empreendimento', 'e.id'));

        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $empreendimentos->where("e.id IN({$id})");
                } else {
                    $empreendimentos->where("1");
                }
            } catch (Exception $e) {

            }
        }
        $empreendimentos = $empreendimentos->order('nm_empreendimento')->query()->fetchAll();
        $this->set('empreendimentos', $empreendimentos);

        if ($this->_isPost && $this->validar($_POST['contrato'], $_POST['tipoParcela'])) {

            foreach ($_POST['tipoParcela'] as $tpParcela) {
                //Variaveis das datas
                $dataParcelaAtual = Helper::getInputDate($_POST['dataVencimento']);
                $novo_vencimento = explode('/', $_POST['dataNova']);

                $mes_inicial = $novo_vencimento[1];
                $dia_inicial = $novo_vencimento[0];
                $ano_inicial = $novo_vencimento[2];
                $controle_dia = $novo_vencimento[0];
                $valores = array();
                $i = 0;

                $tbParcela = new Parcela();
                if ($tpParcela == 'N') {
                    $consultaI = $tbParcela->getDefaultAdapter()->select()->from(array(TB_PARCELA))
                        ->where('id_contrato = ' . $_POST['contrato'])
                        ->where("dt_parcela >= '$dataParcelaAtual'")
                        ->where("pago = '0' and tp_parcela = 'I' ")
                        ->query()->fetchAll();
                    $consultaN = $tbParcela->getDefaultAdapter()->select()
                        ->from(array(TB_PARCELA))
                        ->where('id_contrato = ' . $_POST['contrato'])
                        ->where("tp_parcela = 'N' ")
                        ->order('dt_parcela')
                        ->query()->fetchAll();
                    $mesesIntercaladas= [];
                    foreach($consultaI as $intercalada){
                        $data = explode("-",$intercalada['dt_parcela']);
                        $mesesIntercaladas[]=$data[0]."-".$data[1];
                    }
                    if ($consultaN[0]['pago'] == '0' && isset($_POST['alteraData'])) {
                        $tbContrato = new Contrato();
                        $contrato = $tbContrato->fetchRow('id = ' . $_POST['contrato']);
                        $contrato->dt_primeira_parcela = Helper::getInputDate($_POST['dataNova']);
                        $contrato->dt_reajuste = Helper::getInputDate($_POST['dataNova']);
                        $contrato->save();
                    }

                    if ($consultaN[0]['pago'] == 1 && isset($_POST['alteraData'])) {
                        $this->redirect(array('modulo' => 'fin', 'controller' => 'alteracaoVencimento', 'action' => 'alterarParcela'), array("exception" => "No  possvel <strong>Alterar Contrato</strong>, pois a primeira parcela j foi paga."));
                        exit;
                    } else {
                        foreach ($consultaN as $c) {
                            $ano = $ano_inicial;

                            if ($c['pago'] == 1)
                                continue;

                            if (strtotime($c['dt_parcela']) < strtotime($dataParcelaAtual))
                                continue;

                            if ($i == 0) {
                                $data = $dia_inicial . '-' . $mes_inicial . '-' . $ano;
                            } else {
                                if (isset($dataNova)) {
                                    $data = explode('-', $dataNova);
                                    $mes_inicial = $data[1];
                                    $dia_inicial = $data[2];
                                    $ano = $data[0];

                                    $data = $dia_inicial . '-' . $mes_inicial . '-' . $ano;
                                }
                            }
                            $tbContrato = new Contrato();
                            $contrat = $tbContrato->fetchRow('id = ' . $_POST['contrato']);
                            $frequencia = $contrat['fl_frequencia'];
                            

                            if ($mes_inicial == 02 && $dia_inicial > 28) {
                                if($frequencia == 'S'){
                                    $dataNova2 = date('Y-m-d', strtotime("+0 months", strtotime($data)));
                                }else{
                                    $data2 = '28' . '-' . $mes_inicial . '-' . $ano;
                                    $dataNova2 = date('Y-m-d', strtotime("+0 months", strtotime($data2)));
                                }
                                $arrayDataNova = explode("-",$dataNova2);
                                while(isset($_POST['coincidirInterceladas']) && $_POST['coincidirInterceladas']=="N" && in_array($arrayDataNova[0]."-".$arrayDataNova[1],$mesesIntercaladas)){
                                    $dataNova2 = Contrato::getNextMonth($dataNova2);
                                    $arrayDataNova = explode("-",$dataNova2);
                                    $data2 = $arrayDataNova[2].'-'.$arrayDataNova[1].'-'.$arrayDataNova[0];
                                }
                                $tb_parcela = new Parcela();
                                $parcela = $tb_parcela->fetchRow("id_parcela_contrato = {$c['id_parcela_contrato']}");
                                $parcela->dt_parcela = $dataNova2;
                                $parcela->id_remessa = null;
                                $parcela->dt_parcela_2avia = null;
                                $parcela->vl_parcela_2avia = null;
                                $parcela->fl_envio = 0;
                                $parcela->save();
                                $valores[] = $dataNova2;
                                $dataNova = $this->endCycle($data, 1, $frequencia);
                            } else {
                                $dataNova = date('Y-m-d', strtotime("+0 months", strtotime($data)));
                                $arrayDataNova = explode("-",$dataNova);
                                while(isset($_POST['coincidirInterceladas']) && $_POST['coincidirInterceladas']=="N" && in_array($arrayDataNova[0]."-".$arrayDataNova[1],$mesesIntercaladas)){
                                    $dataNova = Contrato::getNextMonth($dataNova);
                                    $arrayDataNova = explode("-",$dataNova);
                                    $data = $arrayDataNova[2].'-'.$arrayDataNova[1].'-'.$arrayDataNova[0];
                                }
                                $tb_parcela = new Parcela();
                                $parcela = $tb_parcela->fetchRow("id_parcela_contrato = {$c['id_parcela_contrato']}");
                                $parcela->dt_parcela = $dataNova;
                                $parcela->id_remessa = null;
                                $parcela->dt_parcela_2avia = null;
                                $parcela->vl_parcela_2avia = null;
                                $parcela->fl_envio = 0;
                                $parcela->save();

                                $mesesComFinal30 = array("02", "04", "06", "09", "11");    
                                if($frequencia == 'M'){
                                    if (isset($flag) && $flag == 1 && !in_array($mes_inicial, $mesesComFinal30)) {
                                        $data = $controle_dia . '-' . $mes_inicial . '-' . $ano;
                                        $flag = 0;
                                    }
                                    if ($mes_inicial == 01 && $dia_inicial > 28) {
                                        $dataNova = $ano . '-' . '02' . '-' . '28';
                                        $flag = 1;
                                    } else {
                                        $dataNova = $this->endCycle($data, 1, $frequencia);
                                    }
                                }   
                                else{
                                    $dataNova = $this->endCycle($data, 1, $frequencia);
                                }                      
                                
                                
                                if (substr($dataNova, 5, 2) == 03 && $controle_dia > 28) {
                                    $dataNova = $ano . "-" . '03' . "-" . $controle_dia;
                                }
                                if (in_array(substr($dataNova, 5, 2) - 1, $mesesComFinal30) && $controle_dia > 30) {
                                    $dataNova = $ano . "-" .substr($dataNova, 5, 2). "-" . $controle_dia;
                                }
                            }
                            $i++;
                        }
                    }
                }

                if ($tpParcela == 'S') {
                    $consultaS = $tbParcela->getDefaultAdapter()->select()->from(array(TB_PARCELA))
                        ->where('id_contrato = ' . $_POST['contrato'])
                        ->where("dt_parcela >= '$dataParcelaAtual'")
                        ->where("pago = '0' and tp_parcela = 'S' ")
                        ->query()->fetchAll();

                    foreach ($consultaS as $c) {
                        $ano = $ano_inicial;

                        if ($i == 0) {
                            $data = $dia_inicial . '-' . $mes_inicial . '-' . $ano;
                        } else {
                            $data = explode('-', $dataNova);
                            $mes_inicial = $data[1];
                            $dia_inicial = $data[2];
                            $ano = $data[0];

                            $data = $dia_inicial . '-' . $mes_inicial . '-' . $ano;
                        }

                        if ($mes_inicial == 02 && $dia_inicial > 28) {
                            $data2 = '28' . '-' . $mes_inicial . '-' . $ano;
                            $dataNova2 = date('Y-m-d', strtotime("+0 months", strtotime($data2)));

                            $tb_parcela = new Parcela();
                            $parcela = $tb_parcela->fetchRow("id_parcela_contrato = {$c['id_parcela_contrato']}");
                            $parcela->dt_parcela = $dataNova2;
                            $parcela->id_remessa = null;
                            $parcela->dt_parcela_2avia = null;
                            $parcela->vl_parcela_2avia = null;
                            $parcela->fl_envio = 0;
                            $valores[] = $dataNova2;
                            $dataNova = $this->endCycle($data, 1);
                        } else {
                            $dataNova = date('Y-m-d', strtotime("+0 months", strtotime($data)));

                            $tb_parcela = new Parcela();
                            $parcela = $tb_parcela->fetchRow("id_parcela_contrato = {$c['id_parcela_contrato']}");
                            $parcela->dt_parcela = $dataNova;
                            $parcela->id_remessa = null;
                            $parcela->dt_parcela_2avia = null;
                            $parcela->vl_parcela_2avia = null;
                            $parcela->fl_envio = 0;
                            $parcela->save();

                            $mesesComFinal30 = array("02", "04", "06", "09", "11");

                            if ($flag == 1 && !in_array($mes_inicial, $mesesComFinal30)) {
                                $data = $controle_dia . '-' . $mes_inicial . '-' . $ano;
                                $flag = 0;
                            }

                            if ($mes_inicial == 01 && $dia_inicial > 28) {
                                $dataNova = $ano . '-' . '02' . '-' . '28';
                                $flag = 1;
                            } else
                                $dataNova = $this->endCycle($data, 1);

                            if (substr($dataNova, 5, 2) == 03 && $controle_dia > 28)
                                $dataNova = $ano . "-" . '03' . "-" . $controle_dia;

                            if (in_array(substr($dataNova, 5, 2) - 1, $mesesComFinal30) && $controle_dia > 30) {
                                $dataNova = $ano . "-" .substr($dataNova, 5, 2). "-" . $controle_dia;
                            }
                        }
                        $i++;
                    }
                }

                if ($tpParcela == 'I') {
                    $consultaI = $tbParcela->getDefaultAdapter()->select()->from(array(TB_PARCELA))
                        ->where('id_contrato = ' . $_POST['contrato'])
                        ->where("dt_parcela >= '$dataParcelaAtual'")
                        ->where("pago = '0' and tp_parcela = 'I' ")
                        ->query()->fetchAll();

                    $this->contrato = new Contrato();
                    $contrato = $this->contrato->getAdapter()->select()->from(array(TB_CONTRATO))
                        ->where('id = ' . $_POST['contrato'])
                        ->query()->fetch();

                    $dt_parcela = $this->_helper->getInputDate($_POST['dataNova']);

                    if ($contrato['fr_intercalada'] == 0) {
                        foreach ($consultaI as $i => $c) {
                            $ano = $ano_inicial;

                            if ($i == 0) {
                                $data = $dia_inicial . '-' . $mes_inicial . '-' . $ano;
                            } else {
                                $data = explode('-', $dataNova);
                                $mes_inicial = $data[1];
                                $dia_inicial = $data[2];
                                $ano = $data[0];

                                $data = $dia_inicial . '-' . $mes_inicial . '-' . $ano;
                            }

                            if ($mes_inicial == 02 && $dia_inicial > 28) {
                                $data2 = '28' . '-' . $mes_inicial . '-' . $ano;

                                $tb_parcela = new Parcela();
                                $parcela = $tb_parcela->fetchRow("id_parcela_contrato = {$c['id_parcela_contrato']}");
                                $dataNova2 = date('Y-m-d', strtotime("+0 months", strtotime($data2)));

                                $parcela->dt_parcela = $dataNova2;
                                $parcela->id_remessa = null;
                                $parcela->dt_parcela_2avia = null;
                                $parcela->vl_parcela_2avia = null;
                                $parcela->fl_envio = 0;
                                $valores[] = $dataNova2;
                                $dataNova = $this->endCycle($data, 1);
                            } else {
                                $dataNova = date('Y-m-d', strtotime("+0 months", strtotime($data)));

                                $tb_parcela = new Parcela();
                                $parcela = $tb_parcela->fetchRow("id_parcela_contrato = {$c['id_parcela_contrato']}");
                                $parcela->dt_parcela = $dataNova;
                                $parcela->id_remessa = null;
                                $parcela->dt_parcela_2avia = null;
                                $parcela->vl_parcela_2avia = null;
                                $parcela->fl_envio = 0;
                                $parcela->save();

                                $mesesComFinal30 = array("02", "04", "06", "09", "11");  

                                if ($flag == 1 && !in_array($mes_inicial, $mesesComFinal30)) {
                                    $data = $controle_dia . '-' . $mes_inicial . '-' . $ano;
                                    $flag = 0;
                                }
                                if ($mes_inicial == 01 && $dia_inicial > 28) {
                                    $dataNova = $ano . '-' . '02' . '-' . '28';
                                    $flag = 1;
                                } else
                                    $dataNova = $this->endCycle($data, 1);

                                if (substr($dataNova, 5, 2) == 03 && $controle_dia > 28)
                                    $dataNova = $ano . "-" . '03' . "-" . $controle_dia;

                                if (in_array(substr($dataNova, 5, 2) - 1, $mesesComFinal30) && $controle_dia > 30) {
                                    $dataNova = $ano . "-" .substr($dataNova, 5, 2). "-" . $controle_dia;
                                }
                            }
                            $i++;
                        }
                    } else {
                        $tb_parcela = new Parcela();

                        foreach ($consultaI as $i => $c) {
                            if ($i != 0)
                                $dt_parcela = Contrato::getNextMonth($dt_parcela, $contrato['fr_intercalada']);
                            $parcela = $tb_parcela->fetchRow("id_parcela_contrato = " . $c['id_parcela_contrato']);
                            $parcela->dt_parcela = $dt_parcela;
                            $parcela->id_remessa = null;
                            $parcela->dt_parcela_2avia = null;
                            $parcela->vl_parcela_2avia = null;
                            $parcela->fl_envio = 0;
                            try {
                                $parcela->save();
                                $parcelasIntercaladas[] = $parcela->toArray();
                            } catch (Exception $e) {
                                die($e->getMessage());
                            }
                        }
                        if ($contrato['fl_coinc_intercalada'] == '0') {
                            $parcelasQnt = $tbParcela->getDefaultAdapter()->select()->from(array(TB_PARCELA))
                                ->where('id_contrato = ' . $_POST['contrato'])
                                ->where("dt_parcela >= '$dataParcelaAtual'")
                                ->where("pago = '0' and tp_parcela = 'N' ")
                                ->query()->fetchAll();

                            $in = 0;
                            $primeira_dt_normal = $parcelasQnt[0]['dt_parcela'];

                            foreach ($parcelasQnt as $parcelaNormal) {
                                $next_dt_normal = Contrato::getNextMonth($primeira_dt_normal, $in);
                                $next_dt_normal_info = Contrato::isDateCoincident($parcelasIntercaladas, $primeira_dt_normal, $next_dt_normal, $in);
                                $next_dt_normal = $next_dt_normal_info["dt"];
                                $in = $next_dt_normal_info["in"];
                                $parcela = $tb_parcela->fetchRow("id_parcela_contrato = {$parcelaNormal['id_parcela_contrato']}");
                                $parcela->dt_parcela = $next_dt_normal;
                                try {
                                    $parcela->save();
                                } catch (Exception $e) {
                                    die($e->getMessage());
                                }
                                $in++;
                            }
                        }
                    }
                }

                if ($tpParcela == 'C') {
                    $consultaC = $tbParcela->getDefaultAdapter()->select()->from(array(TB_PARCELA))
                        ->where('id_contrato = ' . $_POST['contrato'])
                        ->where("dt_parcela >= '$dataParcelaAtual'")
                        ->where("pago = '0' and tp_parcela = 'C' ")
                        ->query()->fetchAll();

                    foreach ($consultaC as $c) {
                        $ano = $ano_inicial;

                        if ($i == 0) {
                            $data = $dia_inicial . '-' . $mes_inicial . '-' . $ano;
                        } else {
                            $data = explode('-', $dataNova);
                            $mes_inicial = $data[1];
                            $dia_inicial = $data[2];
                            $ano = $data[0];

                            $data = $dia_inicial . '-' . $mes_inicial . '-' . $ano;
                        }
                        if ($mes_inicial == 02 && $dia_inicial > 28) {
                            $data2 = '28' . '-' . $mes_inicial . '-' . $ano;

                            $tb_parcela = new Parcela();
                            $parcela = $tb_parcela->fetchRow("id_parcela_contrato = {$c['id_parcela_contrato']}");

                            $dataNova2 = date('Y-m-d', strtotime("+0 months", strtotime($data2)));

                            $parcela->dt_parcela = $dataNova2;
                            $parcela->id_remessa = null;
                            $parcela->dt_parcela_2avia = null;
                            $parcela->vl_parcela_2avia = null;
                            $parcela->fl_envio = 0;
                            $valores[] = $dataNova2;
                            $dataNova = $this->endCycle($data, 1);
                        } else {
                            $dataNova = date('Y-m-d', strtotime("+0 months", strtotime($data)));

                            $tb_parcela = new Parcela();
                            $parcela = $tb_parcela->fetchRow("id_parcela_contrato = {$c['id_parcela_contrato']}");
                            $parcela->dt_parcela = $dataNova;
                            $parcela->id_remessa = null;
                            $parcela->dt_parcela_2avia = null;
                            $parcela->vl_parcela_2avia = null;
                            $parcela->fl_envio = 0;
                            $parcela->save();

                            $mesesComFinal30 = array("02", "04", "06", "09", "11"); 

                            if ($flag == 1 && !in_array($mes_inicial, $mesesComFinal30)) {
                                $data = $controle_dia . '-' . $mes_inicial . '-' . $ano;
                                $flag = 0;
                            }

                            if ($mes_inicial == 01 && $dia_inicial > 28) {
                                $dataNova = $ano . '-' . '02' . '-' . '28';
                                $flag = 1;
                            } else
                                $dataNova = $this->endCycle($data, 1);

                            if (substr($dataNova, 5, 2) == 03 && $controle_dia > 28)
                                $dataNova = $ano . "-" . '03' . "-" . $controle_dia;

                            if (in_array(substr($dataNova, 5, 2) - 1, $mesesComFinal30) && $controle_dia > 30) {
                                $dataNova = $ano . "-" .substr($dataNova, 5, 2). "-" . $controle_dia;
                            }
                        }
                        $i++;
                    }
                }

                if ($tpParcela == 'E') {
                    //Consulta as parcelas Negociadas
                    $consultaE = $tbParcela->getDefaultAdapter()->select()->from(array(TB_PARCELA))
                        ->where('id_contrato = ' . $_POST['contrato'])
                        ->where("dt_parcela >= '$dataParcelaAtual'")
                        ->where("pago = '0' and tp_parcela IN ('E', 'NE', 'SE', 'CE', 'IE')")
                        ->query()->fetchAll();

                    foreach ($consultaE as $c) {
                        $ano = $ano_inicial;

                        if ($i == 0) {
                            $data = $dia_inicial . '-' . $mes_inicial . '-' . $ano;
                        } else {
                            $data = explode('-', $dataNova);
                            $mes_inicial = $data[1];
                            $dia_inicial = $data[2];
                            $ano = $data[0];

                            $data = $dia_inicial . '-' . $mes_inicial . '-' . $ano;
                        }
                        if ($mes_inicial == 02 && $dia_inicial > 28) {
                            $data2 = '28' . '-' . $mes_inicial . '-' . $ano;
                            $dataNova2 = date('Y-m-d', strtotime("+0 months", strtotime($data2)));

                            $tb_parcela = new Parcela();
                            $parcela = $tb_parcela->fetchRow("id_parcela_contrato = {$c['id_parcela_contrato']}");
                            $parcela->dt_parcela = $dataNova2;
                            $parcela->id_remessa = null;
                            $parcela->dt_parcela_2avia = null;
                            $parcela->vl_parcela_2avia = null;
                            $parcela->fl_envio = 0;
                            $valores[] = $dataNova2;
                            $dataNova = $this->endCycle($data, 1);
                        } else {
                            $dataNova = date('Y-m-d', strtotime("+0 months", strtotime($data)));

                            $tb_parcela = new Parcela();
                            $parcela = $tb_parcela->fetchRow("id_parcela_contrato = {$c['id_parcela_contrato']}");
                            $parcela->dt_parcela = $dataNova;
                            $parcela->id_remessa = null;
                            $parcela->dt_parcela_2avia = null;
                            $parcela->vl_parcela_2avia = null;
                            $parcela->fl_envio = 0;
                            $parcela->save();

                            $mesesComFinal30 = array("02", "04", "06", "09", "11");                                

                            if ($flag == 1 && !in_array($mes_inicial, $mesesComFinal30)) {
                                $data = $controle_dia . '-' . $mes_inicial . '-' . $ano;
                                $flag = 0;
                            }

                            if ($mes_inicial == 01 && $dia_inicial > 28) {
                                $dataNova = $ano . '-' . '02' . '-' . '28';
                                $flag = 1;
                            } else
                                $dataNova = $this->endCycle($data, 1);

                            if (substr($dataNova, 5, 2) == 03 && $controle_dia > 28)
                                $dataNova = $ano . "-" . '03' . "-" . $controle_dia;

                            if (in_array(substr($dataNova, 5, 2) - 1, $mesesComFinal30) && $controle_dia > 30) {
                                $dataNova = $ano . "-" .substr($dataNova, 5, 2). "-" . $controle_dia;
                            }
                        }
                        $i++;
                    }
                }

                if ($tpParcela == 'G') {
                    $consultaG = $tbParcela->getDefaultAdapter()->select()->from(array(TB_PARCELA))
                        ->where('id_contrato = ' . $_POST['contrato'])
                        ->where("dt_parcela >= '$dataParcelaAtual'")
                        ->where("pago = '0' and tp_parcela = 'G' ")
                        ->query()->fetchAll();

                    foreach ($consultaG as $c) {
                        $ano = $ano_inicial;

                        if ($i == 0) {
                            $data = $dia_inicial . '-' . $mes_inicial . '-' . $ano;
                        } else {
                            $data = explode('-', $dataNova);
                            $mes_inicial = $data[1];
                            $dia_inicial = $data[2];
                            $ano = $data[0];
                            $data = $dia_inicial . '-' . $mes_inicial . '-' . $ano;
                        }
                        if ($mes_inicial == 02 && $dia_inicial > 28) {
                            $data2 = '28' . '-' . $mes_inicial . '-' . $ano;
                            $dataNova2 = date('Y-m-d', strtotime("+0 months", strtotime($data2)));

                            $tb_parcela = new Parcela();
                            $parcela = $tb_parcela->fetchRow("id_parcela_contrato = {$c['id_parcela_contrato']}");
                            $parcela->dt_parcela = $dataNova2;
                            $parcela->id_remessa = null;
                            $parcela->dt_parcela_2avia = null;
                            $parcela->vl_parcela_2avia = null;
                            $parcela->fl_envio = 0;
                            $valores[] = $dataNova2;
                            $dataNova = $this->endCycle($data, 1);
                        } else {
                            $dataNova = date('Y-m-d', strtotime("+0 months", strtotime($data)));

                            $tb_parcela = new Parcela();
                            $parcela = $tb_parcela->fetchRow("id_parcela_contrato = {$c['id_parcela_contrato']}");
                            $parcela->dt_parcela = $dataNova;
                            $parcela->id_remessa = null;
                            $parcela->dt_parcela_2avia = null;
                            $parcela->vl_parcela_2avia = null;
                            $parcela->fl_envio = 0;
                            $parcela->save();

                            $mesesComFinal30 = array("02", "04", "06", "09", "11");                                

                            if ($flag == 1 && !in_array($mes_inicial, $mesesComFinal30)) {
                                $data = $controle_dia . '-' . $mes_inicial . '-' . $ano;
                                $flag = 0;
                            }

                            if ($mes_inicial == 01 && $dia_inicial > 28) {
                                $dataNova = $ano . '-' . '02' . '-' . '28';
                                $flag = 1;
                            } else
                                $dataNova = $this->endCycle($data, 1);

                            if (substr($dataNova, 5, 2) == 03 && $controle_dia > 28)
                                $dataNova = $ano . "-" . '03' . "-" . $controle_dia;

                            if (in_array(substr($dataNova, 5, 2) - 1, $mesesComFinal30) && $controle_dia > 30) {
                                $dataNova = $ano . "-" .substr($dataNova, 5, 2). "-" . $controle_dia;
                            }
                        }
                        $i++;
                    }
                }

                if ($tpParcela == 'A') {
                    $consultaA = $tbParcela->getDefaultAdapter()->select()->from(array(TB_PARCELA))
                        ->where('id_contrato = ' . $_POST['contrato'])
                        ->where("dt_parcela >= '$dataParcelaAtual'")
                        ->where("pago = '0' and tp_parcela = 'A' ")
                        ->query()->fetchAll();

                    foreach ($consultaA as $c) {
                        $ano = $ano_inicial;

                        if ($i == 0) {
                            $data = $dia_inicial . '-' . $mes_inicial . '-' . $ano;
                        } else {
                            $data = explode('-', $dataNova);
                            $mes_inicial = $data[1];
                            $dia_inicial = $data[2];
                            $ano = $data[0];
                            $data = $dia_inicial . '-' . $mes_inicial . '-' . $ano;
                        }
                        if ($mes_inicial == 02 && $dia_inicial > 28) {
                            $data2 = '28' . '-' . $mes_inicial . '-' . $ano;
                            $dataNova2 = date('Y-m-d', strtotime("+0 months", strtotime($data2)));

                            $tb_parcela = new Parcela();
                            $parcela = $tb_parcela->fetchRow("id_parcela_contrato = {$c['id_parcela_contrato']}");
                            $parcela->dt_parcela = $dataNova2;
                            $parcela->id_remessa = null;
                            $parcela->dt_parcela_2avia = null;
                            $parcela->vl_parcela_2avia = null;
                            $parcela->fl_envio = 0;
                            $valores[] = $dataNova2;
                            $dataNova = $this->endCycle($data, 1);
                        } else {
                            $dataNova = date('Y-m-d', strtotime("+0 months", strtotime($data)));

                            $tb_parcela = new Parcela();
                            $parcela = $tb_parcela->fetchRow("id_parcela_contrato = {$c['id_parcela_contrato']}");
                            $parcela->dt_parcela = $dataNova;
                            $parcela->id_remessa = null;
                            $parcela->dt_parcela_2avia = null;
                            $parcela->vl_parcela_2avia = null;
                            $parcela->fl_envio = 0;
                            $parcela->save();

                            $mesesComFinal30 = array("02", "04", "06", "09", "11");       

                            if ($flag == 1 && !in_array($mes_inicial, $mesesComFinal30)) {
                                $data = $controle_dia . '-' . $mes_inicial . '-' . $ano;
                                $flag = 0;
                            }
                            if ($mes_inicial == 01 && $dia_inicial > 28) {
                                $dataNova = $ano . '-' . '02' . '-' . '28';
                                $flag = 1;
                            } else
                                $dataNova = $this->endCycle($data, 1);
                            if (substr($dataNova, 5, 2) == 03 && $controle_dia > 28)
                                $dataNova = $ano . "-" . '03' . "-" . $controle_dia;
                            if (in_array(substr($dataNova, 5, 2) - 1, $mesesComFinal30) && $controle_dia > 30) {
                                $dataNova = $ano . "-" .substr($dataNova, 5, 2). "-" . $controle_dia;
                            }
                        }
                        $i++;
                    }
                }
            }
            //Antes de redirecionar grava o resultado no log dos contatos realizados como Quitao.
            (new Relacionamento())->saveContato(47, date('Y-m-d'), $_POST['contrato'], 'Log: Alterao de Vencimento realizada. Com a nova data: ' . $_POST['dataNova'] . '  partir da data: ' . $_POST['dataVencimento']);
            $this->redirect(array('modulo' => 'fin', 'controller' => 'alteracaoVencimento', 'action' => 'alterarParcela'), array("msg" => "success"));
        }

        $this->display();
    }
    private function add_months($months, DateTime $dateObject)
    {
        $next = new DateTime($dateObject->format('Y-m-d'));
        $next->modify('last day of +'.$months.' month');

        if ($dateObject->format('d') > $next->format('d')) {
            return $dateObject->diff($next);
        } else {
            return new DateInterval('P'.$months.'M');
        }
    }

    private function endCycle($d1, $months, $type = 'M')
    {
        $date = new DateTime($d1);
        
        if($type == 'M'){
            // call second function to add the months
            $newDate = $date->add($this->add_months($months, $date));
        }else{
            // add the days
            $newDate = $date->add(new DateInterval('P7D'));
        }

        //formats final date to Y-m-d form
        $dateReturned = $newDate->format('Y-m-d');

        return $dateReturned;
    }
    private function validar($idContrato, $tipoParcela)
    {
        if (count($_POST['tipoParcela']) == 0) {
            $this->_helper->addMensagem('tipoParcela', ' obrigatrio escolher no mnimo um Tipo Parcela.');
        } else {
            $consulta = (new Parcela())->getDefaultAdapter()->select()->from(array(TB_PARCELA))
                ->where('id_contrato = ' . $idContrato)
                ->where('pago = "0"')
                ->where('dt_parcela >= "' . Helper::getInputDate($_POST['dataVencimento']) . '"')
                ->where("tp_parcela in ('" . implode("','", $tipoParcela) . "') ")
                ->query()->fetchAll();

            foreach ($consulta as $parcela) {
                if ($parcela['id_remessa']) {
                    $parcelasRemessa[] = $parcela['id_parcela'] . '-' . $parcela['tp_parcela'];
                }
            }

            if (count($consulta) == 0)
                $this->_helper->addMensagem('tipoParcela', 'No foram encontradas parcelas com os filtros selecionados.');

            if (isset($parcelasRemessa))
                $this->_helper->addMensagem('empreendimento', 'A(s) Parcela(s):' . implode(', ', $parcelasRemessa) . ' j foram enviadas e no podem ser alteradas.');

        }


        $campos = array("empreendimento", "contrato", "dataNova", "dataVencimento");
        foreach ($campos as $cp) {
            if ($_POST[$cp] == "") {
                switch ($cp) {
                    case "empreendimento" :
                        $msg = "O campo Empreendimento  obrigatrio.";
                        break;
                    case "contrato" :
                        $msg = "O campo Contrato  obrigatrio.";
                        break;
                    case "dataNova" :
                        $msg = "O campo Nova Data  obrigatrio.";
                        break;
                    case "dataVencimento" :
                        $msg = "O campo  partir da data  obrigatrio.";
                        break;
                }
                $this->_helper->addMensagem($cp, $msg);

            }
        }
        return !(count($this->_helper->getMensagens()) > 0);
    }

}