<?php

class AlteraParcelaController extends Controller
{
    private $empreendimento;

    public function  __construct($request)
    {
        parent::__construct($request);
        $this->empreendimento = new Empreendimento();
    }

    public function indexAction()
    {
        $empreendimentos = $this->empreendimento->getDefaultAdapter()->select()
            ->distinct('e.id')
            ->from(array('e' => TB_EMPREENDIMENTO), array('*'))
            ->join(array('l' => TB_LOTES), 'e.id = l.id_empreendimento', array())
            ->join(array('c' => TB_CONTRATO), 'l.id = c.id_lote', array())
            ->join(array('p' => TB_PARCELA), 'c.id = p.id_contrato', array());

        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $empreendimentos->where("e.id IN({$id})");
                } else {
                    $empreendimentos->where("1");
                }
            } catch (Exception $e) {
            }
        }

        $empreendimentos = $empreendimentos->order('nm_empreendimento')->query()->fetchAll();

        $this->set('empreendimentos', $empreendimentos);

        if ($this->_isPost) {
            $alterarParcela['empreendimento'] = $_POST['empreendimento_alterar_parcela'];
            $alterarParcela['contrato'] = $_POST['contrato_alterar_parcela'];
            //Opo Todos
            if (in_array('T', $_POST['parcela_alterar_parcela'])) {
                $_POST['parcela_alterar_parcela'] = [];
                $_POST['parcela_alterar_parcela'][0] = 'T';
            }

            if ($this->validar()) {
                $instanceParcela = new Parcela();
                foreach ($_POST['parcela_alterar_parcela'] as $parcela) {
                    
                    if ($parcela == 'T') {
                        $whereTpParcela = $_POST['tipoParcela'] == '*' ? '' : "tp_parcela = '{$_POST['tipoParcela']}' AND";
                        $parcelasAlteracao = $instanceParcela->fetchAll("
                            id_contrato = {$alterarParcela['contrato']} AND
                            {$whereTpParcela}
                            pago = '0' AND
                            id_remessa IS NULL AND
                            tp_parcela NOT IN ('E','NE','SE','CE','IE')
                            ");
                        foreach ($parcelasAlteracao as $parcelaAltera) {
                            try {
                                $parcelaAltera->vl_parcela = Helper::getInputMoney($_POST['parcela_valor']);
                                $parcelaAltera->acrescimo = $_POST['parcela_acrescimo'] ? Helper::getInputMoney($_POST['parcela_acrescimo']) : null;
                                $parcelaAltera->desconto = $_POST['parcela_desconto'] ? Helper::getInputMoney($_POST['parcela_desconto']) : null;
                                $parcelaAltera->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - u');
                                $parcelaAltera->id_remessa = null;
                                $parcelaAltera->save();
                            } catch (Zend_Exception $e) {
                                $this->redirect(array('modulo' => 'fin', 'controller' => 'alteraParcela', 'action' => 'index'), array("exception" => $e->getMessage()));
                            }
                        }
                        $logTipoParcela = $_POST['tipoParcela'] == '*' ? "Todas" : $_POST['tipoParcela'];
                        $log = "Alterao de TODAS as parcelas em aberto do tipo: {$logTipoParcela}, para valor: R$ {$_POST['parcela_valor']}, com acrscimo de: R$ {$_POST['parcela_acrescimo']}, e desconto de: R$ {$_POST['parcela_desconto']}.";
                    } else {
                        try {
                            $resultParcela = $instanceParcela->fetchRow("id_parcela_contrato = {$parcela}");
                            $resultParcela->vl_parcela = Helper::getInputMoney($_POST['parcela_valor']);
                            $resultParcela->acrescimo = $_POST['parcela_acrescimo'] ? Helper::getInputMoney($_POST['parcela_acrescimo']) : null;
                            $resultParcela->desconto = $_POST['parcela_desconto'] ? Helper::getInputMoney($_POST['parcela_desconto']) : null;
                            if (isset($_POST['parcela_data'])) {
                                $resultParcela->dt_parcela = Helper::getInputDate($_POST['parcela_data']);
                                $data = ", na data de: {$_POST['parcela_data']}";
                            }
                            $resultParcela->log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - u');
                            $resultParcela->id_remessa = null;
                            $resultParcela->save();
                            $log[] = "Parcela Nmero: {$resultParcela->id_parcela}, Tipo: {$resultParcela->tp_parcela}, para valor: R$ {$_POST['parcela_valor']}, acrscimo de: R$ {$_POST['parcela_acrescimo']}, desconto de: R$ {$_POST['parcela_desconto']}{$data}";
                        } catch (Zend_Exception $e) {
                            $this->redirect(array('modulo' => 'fin', 'controller' => 'alteraParcela', 'action' => 'index'), array("exception" => $e->getMessage()));
                        }
                    }
                }
                if (is_array($log)) {
                    $log = implode(". ", $log);
                    $log = "Alterao de parcela(s) em aberto: {$log}.";
                }
                //Grava a operao no log de contatos realizados com o lote e quadra do contrato
                (new Relacionamento())->saveContato(51, date('Y-m-d'), $_POST['contrato_alterar_parcela'], "Log: {$log}");

                $this->redirect(array('modulo' => 'fin', 'controller' => 'alteraParcela', 'action' => 'index'), array("msg" => "success"));
            }
        }
        $this->display();
    }

    public function validar()
    {
        $campos = array('empreendimento_alterar_parcela', 'contrato_alterar_parcela', 'parcela_alterar_parcela','parcela_valor', 'parcela_data');
        foreach ($campos AS $ind => $campo) {
            if ($_POST[$campo] == '') {
                switch ($campo) {
                    case 'empreendimento_alterar_parcela':
                        $msg = "Selecione algum empreendimento.";
                        $this->_helper->addMensagem($campo, $msg);
                        break;
                    case 'contrato_alterar_parcela':
                        $msg = "Selecione algum contrato.";
                        $this->_helper->addMensagem($campo, $msg);
                        break;
                    case 'parcela_alterar_parcela':
                        $msg = "Selecione alguma parcela.";
                        $this->_helper->addMensagem($campo, $msg);
                        break;
                    case 'parcela_valor':
                        $msg = "O valor da parcela deve ser preenchido.";
                        $this->_helper->addMensagem($campo, $msg);
                        break;
                    case 'parcela_data':
                        if (sizeof($_POST['parcela_alterar_parcela']) <= 1 && !in_array('T', $_POST['parcela_alterar_parcela'])) {
                            $msg = "A data da parcela deve ser preenchida.";
                            $this->_helper->addMensagem($campo, $msg);
                        }
                        break;
                }
            }
        }
        if ($_POST['validaHidden'] == '1') {
            $campos = array('parcela_valor', 'parcela_data');
            foreach ($campos AS $ind => $campo) {
                if ($_POST[$campo] == '') {
                    switch ($campo) {
                        case 'parcela_valor':
                            $msg = "O valor da parcela deve ser preenchido.";
                            $this->_helper->addMensagem($campo, $msg);
                            break;
                        case 'parcela_data':
                            $msg = "A data da parcela deve ser preenchido.";
                            $this->_helper->addMensagem($campo, $msg);
                            break;
                    }
                }
            }
            if ($_POST['parcela_valor'] == '0,00') {
                $msg = "O valor da parcela deve ser maior que 0,00.";
                $this->_helper->addMensagem('parcela_valor', $msg);
            }
        }
        return !(count($this->_helper->getMensagens()) > 0);
    }

    /**
     * Calcula Multas e Juros, apartir dos dados da parcela.
     */
    public function calculaMultaJurosParcelaAction()
    {
        $instanceParcela = new Parcela();
        $select = $instanceParcela->getAdapter()->select();
        $parcelas = $select->from(array('p' => TB_PARCELA), array('id_parcela_contrato', 'id_parcela', 'id_negociacao', 'tp_parcela', 'dt_parcela', 'vl_parcela', 'acrescimo', 'desconto', 'pago', 'tp_baixa', 'id_remessa'))
            ->join(array('c' => TB_CONTRATO), 'p.id_contrato = c.id', array('nr_parcela', 'idDoContrato' => 'id'))
            ->where('id_parcela_contrato = ?', $_POST['parcela'])
            ->query()->fetch();

        echo json_encode(array(
            'pago' => $parcelas['pago'],
            'remessa' => (isset($parcelas['id_remessa']) || $parcelas['id_remessa'] != ''),
            'valorParcela' => number_format($parcelas["vl_parcela"], 2, ',', '.'),
            'acrescimo' => number_format($parcelas['acrescimo'], 2, ',', '.'),
            'desconto' => number_format($parcelas['desconto'], 2, ',', '.'),
            'dt_vencimento' => Helper::getDate($parcelas['dt_parcela']),
            'valor' => number_format($parcelas["vl_parcela"], 2, ',', '.'),
            'tipoBaixa' => $parcelas['tp_baixa']
        ));
    }

}