<?php
require_once 'layout/includes/header.php';
require_once 'layout/includes/menu.php';
$listaEmpreendimentos = $this->get('listaEmpreendimentos');
$infoDadosContabeis = $this->get('infoDadosContabeis');
$vlPorcDeclarada = $this->get('vlPorcDeclarada');
$operacao = $this->get('operacao');
$unidade = $this->get('unidade');
$filiais = $this->get('listaFiliais');
$pessoaResponsavelRFB = $this->get('pessoaResponsavelRFB');
?>
    <div class="content">
    <div class="page-heading">
        <?= $this->getHeader('Adicionar', 'Dados Contbeis'); ?>
    </div>
    <div class="widget">
        <div class="widget-content padding">
            <?= ($_GET['exception'] != '') ? '<div class="alert alert-danger alert-dismissable">' . $_GET['exception'] . '</div>' : ''?>
            <!-- MENSAGENS -->
            <div class="alert alert-danger alert-dismissable msgErros" hidden></div>
            <div class="alert alert-success alert-dismissable msgSucess" hidden>Operao realizada com sucesso.</div>
            <form action="" method="POST" id="form">
                <fieldset>
                    <legend>Representante e Contador <span style=" font-size: 10pt">(Campos com <span style=" color: red">*</span> so obrigatrios)</span>
                        <span data-toggle="modal" data-target=".mVisualizar" style="font-size: 22px;" data-toggle="tooltip" data-placement="top" title="Assista ao tutorial">
                            <svg xmlns="" width="22" height="22" fill="currentColor" class="bi bi-youtube" viewBox="0 0 16 16">
                                <path d="M8.051 1.999h.089c.822.003 4.987.033 6.11.335a2.01 2.01 0 0 1 1.415 1.42c.101.38.172.883.22 1.402l.01.104.022.26.008.104c.065.914.073 1.77.074 1.957v.075c-.001.194-.01 1.108-.082 2.06l-.008.105-.009.104c-.05.572-.124 1.14-.235 1.558a2.01 2.01 0 0 1-1.415 1.42c-1.16.312-5.569.334-6.18.335h-.142c-.309 0-1.587-.006-2.927-.052l-.17-.006-.087-.004-.171-.007-.171-.007c-1.11-.049-2.167-.128-2.654-.26a2.01 2.01 0 0 1-1.415-1.419c-.111-.417-.185-.986-.235-1.558L.09 9.82l-.008-.104A31 31 0 0 1 0 7.68v-.123c.002-.215.01-.958.064-1.778l.007-.103.003-.052.008-.104.022-.26.01-.104c.048-.519.119-1.023.22-1.402a2.01 2.01 0 0 1 1.415-1.42c.487-.13 1.544-.21 2.654-.26l.17-.007.172-.006.086-.003.171-.007A100 100 0 0 1 7.858 2zM6.4 5.209v4.818l4.157-2.408z"></path>
                            </svg>
                        </span>
                    </legend>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group col-sm-6">
                                <label class="control-label">
                                    Empreendimento:<span class="require" style="color: red">*</span>
                                </label>
                                <select class="form-control select2 empreendimentoSped"
                                        required="required"
                                        id="empreendimento" name="empreendimento"
                                        data-placeholder="Selecione o empreendimento" <?= ($infoDadosContabeis['id_empreendimento'])?'disabled':''?>>
                                    <option value=""></option>
                                    <?php foreach ($this->get("listaEmpreendimentos") as $emp):?>
                                        <option value="<?php echo $emp["id"]; ?>" <?= ($infoDadosContabeis['id_empreendimento'] == $emp['id'])?'selected':''?>><?php echo $emp["nm_empreendimento"]; ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="form-group col-sm-6">
                                <label class="control-label" for="dtInicio">
                                    Nome empresarial da pessoa juridica:<span class="require" style="color: red">*</span>
                                </label>
                                <input type="hidden" id="hiddenIdPessoaJuridica"  name="hiddenIdPessoaJuridica" value="<?= $infoDadosContabeis['idPessoaJuridica']?>"/>
                                <select class="form-control select2 idPessoaJuridica"
                                        required="required"
                                        id="idPessoaJuridica" name="idPessoaJuridica"
                                        data-placeholder="Digite o nome da pessoa juridica">
                                    <option value=""></option>
                                    <?= ($infoDadosContabeis['idPessoaJuridica'])?'<option value="'.$infoDadosContabeis['idPessoaJuridica'].'" selected>'.$infoDadosContabeis['nmPessoaJuridica'].'</option>':''?>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group col-sm-6">
                                <label class="control-label">
                                    Contador:<span class="require" style="color: red">*</span>
                                </label>
                                <input type="hidden" id="hiddenIdContador"  name="hiddenIdContador" value="<?= $infoDadosContabeis['idContador']?>"/>
                                <select class="form-control select2 idContador"
                                        required="required"
                                        id="idContador" name="idContador"
                                        data-placeholder="Digite o nome do contador">
                                    <option value=""></option>
                                    <?= ($infoDadosContabeis['idContador'])?'<option value="'.$infoDadosContabeis['idContador'].'" selected>'.$infoDadosContabeis['nmContador'].'</option>':''?>
                                </select>
                            </div>
                            <div class="form-group col-sm-6">
                                <label class="control-label" for="dtInicio">
                                    Escritrio de contabilidade:
                                </label>
                                <select class="form-control select2"
                                        required="required"
                                        id="idContabilidade" name="idContabilidade"
                                        data-placeholder="Digite o nome do escritrio de contabilidade">
                                    <option value=""></option>
                                    <?= ($infoDadosContabeis['idContabilidade'])?'<option value="'.$infoDadosContabeis['idContabilidade'].'" selected>'.$infoDadosContabeis['nmContabilidade'].'</option>':''?>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group col-sm-6">
                                <label class="control-label" for="dtInicio">
                                    Filial (campo 35):
                                </label>
                                <select class="form-control select2 idFilial"
                                        required="required"
                                        id="idFilial" name="idFilial"
                                        data-placeholder="Digite o nome da pessoa juridica">
                                    <option value=""></option>
                                    <?php foreach ($filiais->toArray() as $filial) : ?>
                                        <?= '<option value="'.$filial['id_pessoa'].'" '.($filial['id_pessoa']==$infoDadosContabeis['id_filial']?"selected":"").'>'.$filial['nm_fantasia'].'</option>'?>
                                    <?php endforeach; ?>
                                </select>
                            </div>

                            <div class="form-group col-sm-6">
                                <label class="control-label" for="dtInicio">
                                    Pessoa responsvel pela empresa junto a RFB:
                                </label>
                                <select class="form-control select2 idPessoaRFB"
                                        required="required"
                                        id="idPessoaRFB" name="idPessoaRFB"
                                        data-placeholder="Digite o nome da pessoa responsvel junto a RFB">
                                    <option value=""></option>
                                    <?php foreach ($pessoaResponsavelRFB->toArray() as $pessoaRFB) : ?>
                                        <?= ($infoDadosContabeis['idContador'] == $pessoaRFB['id'])?'<option value="'.$infoDadosContabeis['id_pessoa_fisica_RFB'].'" selected>'.$infoDadosContabeis['nmPessoaRFB'].'</option>':
                                        '<option value="' . $pessoaRFB['id'] . '">' . $pessoaRFB['nm_pessoa'] . '</option>'  ?>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group col-sm-3">
                                <label class="control-label">
                                    CRC:<span class="require" style="color: red">*</span>
                                </label>
                                <input type="text" class="form-control" id="dsCrc"
                                       name="dsCrc" placeholder="Digite o cdigo do conselho regional de contabilidade"
                                       value="<?= $infoDadosContabeis['nr_crc'] ?>">
                            </div>
                            <div class="form-group col-sm-3">
                                <label class="control-label">
                                    Porc. declarada (%): <span style="color: red; font-size: 8px;" id="spanPorcDeclarada" <?= ($vlPorcDeclarada)?'':'hidden'?>>(Total porc.: <span id="spanValorPorcDeclarada"><?= ($vlPorcDeclarada)?$vlPorcDeclarada:'0,00'?>%</span>)</span>
                                </label>
                                <input type="hidden" id="hiddenVlTotalPorcDeclarada" value="<?= ($vlPorcDeclarada)?$vlPorcDeclarada-100:'0'?>"/>
                                <input type="hidden" id="hiddenVlAtualPorcDeclarada" value="<?= ($infoDadosContabeis['vl_porc_declarada'])?$infoDadosContabeis['vl_porc_declarada']:'0'?>"/>
                                <input type="text" class="form-control porcentagemDeclarada" id="vlPorcDeclarada" <?= ($infoDadosContabeis)?'':'disabled'?>
                                       name="vlPorcDeclarada" placeholder="Digite o valor da porcentagem"
                                       value="<?= ($infoDadosContabeis['vl_porc_declarada'])?Helper::getMoney($infoDadosContabeis['vl_porc_declarada'], 4):'' ?>">
                            </div>
                            <div class="form-group col-sm-3">
                                <label class="control-label">
                                    Valor PIS (%):<span class="require" style="color: red">*</span>
                                </label>
                                <input type="text" class="form-control porcentagem" id="vlAliquotaPisPasep"
                                       name="vlAliquotaPisPasep" placeholder="Digite o valor do PIS"
                                       value="<?= ($infoDadosContabeis['vl_aliquota_pis_pasep'])?Helper::getMoney($infoDadosContabeis['vl_aliquota_pis_pasep'], 4):'0,0000' ?>">
                            </div>
                            <div class="form-group col-sm-3">
                                <label class="control-label">
                                    Valor COFINS (%):<span class="require" style="color: red">*</span>
                                </label>
                                <input type="text" class="form-control porcentagem" id="vlAliquotaCofins"
                                       name="vlAliquotaCofins" placeholder="Digite o valor do COFINS"
                                       value="<?= ($infoDadosContabeis['vl_aliquota_cofins'])?Helper::getMoney($infoDadosContabeis['vl_aliquota_cofins'], 4):'0,0000' ?>">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group col-sm-6">
                                <label class="control-label">
                                    Indicador tipo da operao:<span style="color: red;">*</span>
                                </label>
                                <select class="form-control select2" id="tpOperacao" name="tpOperacao"
                                        data-placeholder="Selecione o tipo da operao" required>
                                    <?php foreach ($operacao as $op): ?>
                                        <?php if ($infoDadosContabeis['ind_oper']): ?>
                                            <option value ="<?= $op['idCampo']; ?>" <?= ($op['idCampo'] == $infoDadosContabeis['ind_oper']) ? 'selected' : '' ?>>
                                                <?= $op['idCampo'].' - '.$op['descricao']; ?>
                                            </option>
                                        <?php else: ?>
                                            <option value ="<?= $op['idCampo']; ?>" <?= ($op['idCampo'] == '05') ? 'selected' : '' ?>>
                                                <?= $op['idCampo'].' - '.$op['descricao']; ?>
                                            </option>
                                        <?php endif; ?>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="form-group col-sm-6">
                                <label class="control-label">
                                    Indicador tipo de unidade vendida:<span style="color: red;">*</span>
                                </label>
                                <select class="form-control select2" id="tpUnidade" name="tpUnidade"
                                        data-placeholder="Selecione o tipo da unidade" required>
                                    <?php foreach ($unidade as $un): ?>
                                        <?php if ($infoDadosContabeis['unid_imob']): ?>
                                            <option value ="<?= $un['idCampo']; ?>" <?= ($un['idCampo'] == $infoDadosContabeis['unid_imob']) ? 'selected' : '' ?>>
                                                <?= $un['idCampo'].' - '.$un['descricao']; ?>
                                            </option>
                                        <?php else: ?>
                                            <option value ="<?= $un['idCampo']; ?>" <?= ($un['idCampo'] == '02') ? 'selected' : '' ?>>
                                                <?= $un['idCampo'].' - '.$un['descricao']; ?>
                                            </option>
                                        <?php endif; ?>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                    </div>
                    <legend>Plano de Conta Contbeis <span style=" font-size: 10pt; color:red;">(Ao preencher um dos campos, todos outros sero obrigatrios tambm)</span></legend>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group col-sm-3">
                                <label class="control-label">
                                    Data de incluso de conta:
                                </label>
                                <input type="text" class="form-control data datepicker-input" id="dtInclusaoConta"
                                       name="dtInclusaoConta" placeholder="Digite o cdigo do conselho regional de contabilidade"
                                       value="<?= Helper::getDate($infoDadosContabeis['dt_inclusao_conta']) ?>">
                            </div>
                            <div class="form-group col-sm-3">
                                <label class="control-label" for="dtInicio">
                                    Natureza de conta:
                                </label>
                                <select class="form-control select2"
                                        id="flNaturezaConta" name="flNaturezaConta"
                                        data-placeholder="Selecione a natureza da conta">
                                    <option value=""></option>
                                    <?php
                                    $listaNaturezaConta = array(
                                        '01' => 'Contas de ativo',
                                        '02' => 'Contas de passivo',
                                        '03' => 'Patrimnio lquido',
                                        '04' => 'Contas de resultado',
                                        '05' => 'Contas de compensao',
                                        '09' => 'Outras'
                                    );
                                    ?>
                                    <?php foreach($listaNaturezaConta as $codigo => $naturezaConta): ?>
                                        <option value="<?= $codigo?>" <?= ($codigo == $infoDadosContabeis['fl_natureza_conta'])?'selected':''?>><?= $naturezaConta?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="form-group col-sm-6">
                                <label class="control-label">
                                    Tipo da conta:
                                </label><br>
                                <div class="checkbox">
                                    <label for="flTipoContaS">
                                        <input type="radio" class="form-control icheck" name="flTipoConta" id="flTipoContaS" value="S" <?= ($infoDadosContabeis['fl_tipo_conta'] == 'S')?'checked':''?>/>
                                        Sinttica (grupo de contas)</label>
                                    <label for="flTipoContaA">
                                        <input type="radio" class="form-control icheck " name="flTipoConta" id="flTipoContaA" value="A" <?= ($infoDadosContabeis['fl_tipo_conta'] != 'S')?'checked':''?>/>
                                        Analtica (conta)</label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group col-sm-3">
                                <label class="control-label">
                                    Nvel da conta:
                                </label>
                                <input type="number" min="0" class="form-control soNumero" id="nrNivelConta"
                                       name="nrNivelConta" placeholder="Digite o Nvel da Conta" maxlength="5"
                                       value="<?= $infoDadosContabeis['nr_nivel_conta'] ?>">
                            </div>
                            <div class="form-group col-sm-3">
                                <label class="control-label">
                                    Cdigo da conta:
                                </label>
                                <input type="number" min="0" class="form-control soNumero" id="nrCodigoConta"
                                       name="nrCodigoConta" placeholder="Digite o cdigo da conta"  maxlength="255"
                                       value="<?= $infoDadosContabeis['nr_codigo_conta'] ?>">
                            </div>
                            <div class="form-group col-sm-3">
                                <label class="control-label">
                                    Nome da conta:
                                </label>
                                <input type="text" class="form-control" id="dsNomeConta" maxlength="60"
                                       name="dsNomeConta" placeholder="Digite o nome da conta"
                                       value="<?= $infoDadosContabeis['ds_nome_conta'] ?>">
                            </div>
                            <div class="form-group col-sm-3">
                                <label class="control-label">
                                    N da conta na receita:
                                </label>
                                <input type="text" class="form-control" id="nrContaReceita" maxlength="60"
                                       name="nrContaReceita" placeholder="Digite o N da conta na receita"
                                       value="<?= $infoDadosContabeis['nr_conta_receita'] ?>">
                            </div>
                        </div>
                    </div>
                    <legend>Operaes</legend>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group col-sm-2">
                                <input type="button" class="btn btn-primary col-sm-12 fDesabilitaBtn gerar" id="gerar" value="Salvar">
                            </div>
                            <div class="form-group col-sm-2">
                                <a href="?m=<?= $_GET['m'] ?>&c=<?= $_GET['c'] ?>&a=listar"
                                   class="btn btn-danger col-sm-12">Cancelar </a>
                            </div>
                        </div>
                    </div>
                </fieldset>
            </form>
        </div>
    </div>
    <div class="modal fade mVisualizar " tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-lg ">
            <div class="modal-content">

                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal"
                            aria-hidden="true">&times;</button>
                    <h2 class="modal-title" id="myModalLabel" align="center"><i class="fa fa-book"></i>
                        Tutorial</h2>
                </div>

                <div class="modal-body tableFix" style="max-height:600px;">
                    <fieldset >
                        <legend>Dados contbeis - Cadastrar os dados Contbeis para gerao do Dimob e Sped</legend>
                        <div class="row" style="margin-right: 0px;margin-left: 0px;">
                            <iframe width="560" height="500" src="https://www.youtube-nocookie.com/embed/-OETTSjoKeA?si=8BpCr9-NQfm8-yHe" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>
                        </div>
                        <div></div>
                    </fieldset>
                </div>
            </div>
        </div>
    </div>
<?php require_once 'layout/includes/footer.php'; ?>