<?php
require_once 'layout/includes/header.php';
require_once 'layout/includes/menu.php';

$listaEmpreendimentos = $this->get('listaEmpreendimentos');
?>
<div class="content">
    <div class="page-heading">
        <?= $this->getHeader('Adicionar', 'Arquivo Sped', 'fa fa-plus'); ?>
    </div>
    <div class="widget">
        <div class="widget-content padding">
            <?= ($_GET['exception'] != '') ? '<div class="alert alert-danger alert-dismissable">' . $_GET['exception'] . '</div>' : '' ?>
            <!-- MENSAGENS -->
            <div class="alert alert-danger alert-dismissable msgErros" hidden></div>
            <div class="alert alert-success alert-dismissable msgSucess" hidden>Operao realizada com sucesso.</div>

            <?php if ($this->_helper->getMensagem("erro")) : ?>
                <div style="width:580px" class="alert alert-error alert-dismissable"><?= $this->_helper->getMensagem("erro"); ?></div>
            <?php endif; ?>
            <form action="" method="POST" target="_blank" id="form">
                <input type="hidden" value="1" name="gerarRelatorio" id="gerarRelatorio">
                <fieldset>
                    <legend>Informaes do Sped <span style=" font-size: 10pt">(Campos com <span style=" color: red">*</span> so obrigatrios)</span>
                        <span data-toggle="modal" data-target=".mVisualizar" style="font-size: 22px;" data-toggle="tooltip" data-placement="top" title="Assista ao tutorial">
                            <svg xmlns="" width="22" height="22" fill="currentColor" class="bi bi-youtube" viewBox="0 0 16 16">
                                <path d="M8.051 1.999h.089c.822.003 4.987.033 6.11.335a2.01 2.01 0 0 1 1.415 1.42c.101.38.172.883.22 1.402l.01.104.022.26.008.104c.065.914.073 1.77.074 1.957v.075c-.001.194-.01 1.108-.082 2.06l-.008.105-.009.104c-.05.572-.124 1.14-.235 1.558a2.01 2.01 0 0 1-1.415 1.42c-1.16.312-5.569.334-6.18.335h-.142c-.309 0-1.587-.006-2.927-.052l-.17-.006-.087-.004-.171-.007-.171-.007c-1.11-.049-2.167-.128-2.654-.26a2.01 2.01 0 0 1-1.415-1.419c-.111-.417-.185-.986-.235-1.558L.09 9.82l-.008-.104A31 31 0 0 1 0 7.68v-.123c.002-.215.01-.958.064-1.778l.007-.103.003-.052.008-.104.022-.26.01-.104c.048-.519.119-1.023.22-1.402a2.01 2.01 0 0 1 1.415-1.42c.487-.13 1.544-.21 2.654-.26l.17-.007.172-.006.086-.003.171-.007A100 100 0 0 1 7.858 2zM6.4 5.209v4.818l4.157-2.408z"></path>
                            </svg>
                        </span>
                    </legend>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group col-sm-6">
                                <label class="control-label">Gerar Por:</label><br>
                                <div class="checkbox">
                                    <label><input type="radio" name="tipoGeracao" class="form-control icheck" value="P" checked> Pessoa jurdica responsvel</label>
                                    <label><input type="radio" name="tipoGeracao" class="form-control icheck" value="E"> Empreendimento</label>
                                </div>
                            </div>
                            <div class="form-group col-sm-6" id="divEmpreendimento" hidden>
                                <label class="control-label">
                                    Empreendimento:<span class="require" style="color: red">*</span>
                                </label>
                                <select class="form-control select2 empreendimentoSped" id="empreendimento" name="empreendimento" data-placeholder="Escolha o empreendimento">
                                    <option value=""></option>
                                    <?php foreach ($this->get("listaEmpreendimentos") as $emp) :
                                        $respJuridico = ($emp['nmRespJuridico']) ? ' - ' . $emp['nmRespJuridico'] . ' - ' . $emp['vl_porc_declarada'] . '%' : '';
                                    ?>
                                        <option value="<?= $emp["id"] . '_' . $emp["id_pessoa_juridica"] ?>"><?= $emp["nm_empreendimento"] . $respJuridico ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="form-group col-sm-6" id="divRespJuridico">
                                <label class="control-label">
                                    Responsvel jurdico:<span class="require" style="color: red">*</span>
                                </label>
                                <select class="form-control select2" id="idRespJuridico" name="idRespJuridico" data-placeholder="Escolha o responsvel jurdico">
                                    <option value=""></option>
                                    <?php foreach ($this->get("listaRespJuridicos") as $i => $emp) : ?>
                                        <option value="<?= $emp["id"]; ?>" <?= (count($this->get("listaRespJuridicos")) == 1) ? 'selected' : '' ?>><?= $emp["nm_pessoa"]; ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group col-sm-6">
                                <label class="control-label" for="dtInicio">
                                    Data inicial:<span class="require" style="color: red">*</span>
                                </label>
                                <input type="text" class="form-control data datepicker-input" name="dtInicial" value="" placeholder="Data inicial" />
                            </div>
                            <div class="form-group col-sm-6">
                                <label class="control-label" for="dtFim">
                                    Data final:<span class="require" style="color: red">*</span>
                                </label>
                                <input type="text" class="form-control data datepicker-input" name="dtFinal" value="" placeholder="Data final" />
                            </div>
                            <div class="form-group col-sm-6" id="divPorcRelatorio" hidden>
                                <label class="control-label">
                                    Utilizar porcentagem em relatrio?:<span class="require" style="color: red">*</span>
                                </label><br>
                                <div class="checkbox">
                                    <label for="checkSim"><input type="radio" class="form-control icheck" name="checkPorcRelatorio" id="checkSim" value="1" checked /> Sim</label>
                                    <label for="checkNao"><input type="radio" class="form-control icheck " name="checkPorcRelatorio" id="checkNao" value="0" /> No</label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group col-sm-4">
                                <label class="control-label">
                                    Filtrar por data de:<span class="require" style="color: red">*</span>
                                </label><br>
                                <div class="checkbox">
                                    <label for="filtroDP">
                                        <input type="radio" class="form-control icheck" name="filtroData" id="filtroDP" value="DP" checked />
                                        Pagamento</label>
                                    <label for="filtroDC">
                                        <input type="radio" class="form-control icheck " name="filtroData" id="filtroDC" value="DC" />
                                        Crdito</label>
                                </div>
                            </div>
                            <div class="form-group col-sm-4" <label class="control-label">
                                Ordenar por:<span class="require" style="color: red">*</span>
                                </label><br>
                                <div class="checkbox">
                                    <label for="cliente"><input type="radio" class="form-control icheck" name="ordem" id="cliente" value="N" checked />
                                        Cliente</label>
                                    <label for="quadra"><input type="radio" class="form-control icheck " name="ordem" id="quadra" value="Q" />
                                        Quadra</label>
                                </div>
                            </div>
                            <div class="form-group col-sm-4" <label class="control-label">
                                Incluir parcelas da filial:<span class="require" style="color: red">*</span>
                                </label><br>
                                <div class="checkbox">
                                    <label for="filialSim"><input type="radio" class="form-control icheck" name="parcelasFilial" id="filialSim" value="S" checked />
                                        Sim</label>
                                    <label for="FilialNao"><input type="radio" class="form-control icheck " name="parcelasFilial" id="FilialNao" value="N" />
                                        No</label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group col-sm-6">
                                <label class="control-label">
                                    Tipo de baixa:<span class="require" style="color: red">*</span>
                                </label><br>
                                <div class="checkbox">
                                    <label for="tpBanco"><input type="checkbox" class="form-control icheck" name="tpBanco" id="tpBanco" value="B" checked />
                                        Banco</label>
                                    <label for="tpTesouraria"><input type="checkbox" class="form-control icheck " name="tpTesouraria" id="tpTesouraria" value="T" checked />
                                        Tesouraria</label>
                                    <label for="tpOutros"><input type="checkbox" class="form-control icheck " name="tpOutros" id="tpOutros" value="O" />
                                        Outros</label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row" id="divSinal">
                        <div class="col-sm-12">
                            <div class="form-group col-sm-6">
                                <label class="control-label">
                                    Exibir parcelas de sinal?
                                </label><br>
                                <div class="checkbox">
                                    <label for="sinalS"><input class="form-control icheck" id="sinalS" style="margin-left: 20px;" type="radio" name="incluirSinal" value="1" checked> Sim</label>
                                    <label for="sinalN"><input class="form-control icheck" id="sinalN" style="margin-left: 20px;" type="radio" name="incluirSinal" value="0"> No</label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group col-sm-6" id="tipoImpressao" hidden>
                                <label class="control-label" for="tipoRelatorio">
                                    Tipo de relatrio
                                </label><br>
                                <div class="checkbox">
                                    <label><input checked type="radio" class="form-control icheck tipo" name="tipoRelatorio" id="tipoRelatorio" value="pdf" /> PDF</label>
                                    <label><input type="radio" class="form-control icheck icheck tipo" name="tipoRelatorio" id="tipoRelatorioExcel" value="xls" /> Excel</label>
                                </div>
                            </div>
                        </div>
                    </div>
                </fieldset>
                <fieldset>
                    <legend>Operaes</legend>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group col-sm-2" id="divGerar" hidden>
                                <input type="button" class="btn btn-primary col-sm-12 fDesabilitaBtn gerar" id="gerar" value="Gerar Relatrio">
                            </div>
                            <div class="form-group col-sm-2">
                                <input type="button" class="btn btn-default col-sm-12 gerar" id="gerarArquivo" value="Gerar Arquivo SPED">
                            </div>
                            <div class="form-group col-sm-2">
                                <a href="?m=<?= $_GET['m'] ?>&c=<?= $_GET['c'] ?>&a=listar" class="btn btn-danger col-sm-12">Cancelar </a>
                            </div>
                        </div>
                    </div>
                </fieldset>
            </form>
        </div>
    </div>
    <div class="modal fade mVisualizar " tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-lg ">
            <div class="modal-content">

                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal"
                            aria-hidden="true">&times;</button>
                    <h2 class="modal-title" id="myModalLabel" align="center"><i class="fa fa-book"></i>
                        Tutorial</h2>
                </div>

                <div class="modal-body tableFix" style="max-height:600px;">
                    <fieldset >
                        <legend>Arquivo Sped - Gerar o Arquivo EFD (Escriturao Fiscal Digital)</legend>
                        <div class="row" style="margin-right: 0px;margin-left: 0px;">
                            <iframe width="560" height="500" src="https://www.youtube-nocookie.com/embed/ih_95hAlu1k?si=1UNhe3e_i2rIQGtm" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>                            
                        </div>
                        <div></div>
                    </fieldset>
                </div>
            </div>
        </div>
    </div>
<?php require_once 'layout/includes/footer.php'; ?>