<?php

class DadosContabeisController extends Controller
{
    public function indexAction()
    {
        $this->redir(array("modulo" => "contabil", "controller" => "dadosContabeis", "action" => "listar"));
    }
    public function listarAction()
    {
        if ($this->isAjax()) {
            $listaItem = EmpreendimentoContabeis::findLista($_POST);
            $totalItens = EmpreendimentoContabeis::findLista($_POST, true);
            $lista = array();
            foreach ($listaItem as $item) {
                $acoes = '<div style="width: 90px"></div><div align="center" style="width: 100%;">';
                //Editar
                $acoes .= '<a href="?m=' . $this->modulo . '&c=' . $this->controller . '&a=editar&id=' . $item['id_empreendimento'] .'_'. $item['id_pessoa_juridica'] .'_'. $item['id_contador'] . '" data-toggle="tooltip" title="EDITAR" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-edit"></i></a>';
                $acoes .= '</div>';
                //Quebra caminho de arquivo para pegar ultima posio (nome do arquivo)
                $lista[] = array(
                    'idEmpreendimento' => '<div align="center">'.$item['id_empreendimento'].'</div>',
                    'nmEmpreendimento' => utf8_encode($item['nm_empreendimento']),
                    'nmContador' => utf8_encode($item['nmContador']),
                    'nmPessoaJuridica' => utf8_encode($item['nmPessoaJuridica']),
                    'acoes' => utf8_encode($acoes),
                );
            }
            echo json_encode(array(
                'draw' => $_POST['draw'],
                'recordsTotal' => count($totalItens),
                'recordsFiltered' => count($totalItens),
                'data' => $lista
            ));

        } else {
            $this->display('listar');
        }
    }
    public function adicionarAction()
    {
        if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'adicionarDadosContabeis')) {
            $this->redir(array('modulo' => 'contabil', 'controller' => 'dadosContabeis', 'action' => 'listar'), array('msgErros' => 'fail', 'exception' => 'Voc no tem permisso para acessar essa funcionalidade.'));
        }

        $this->set('listaEmpreendimentos', (new Empreendimento)->getEmpreendimentos());
        $this->set('operacao', (new TabelaAgrupada)->findTabelaById('24'));
        $this->set('unidade', (new TabelaAgrupada)->findTabelaById('25'));
        $this->set('listaFiliais', (new Pessoa_Juridica)->fetchAll());
        $this->set('pessoaResponsavelRFB', (new Pessoa())->fetchAll('tp_pessoa = "F"'));

        if ($this->_isPost) {
            try {
                $db = Zend_Db_Table::getDefaultAdapter();
                $db->beginTransaction();
                //Salvando SPED
                $tbEmpreendimentoContabeis = new EmpreendimentoContabeis();
                $empreendimentoContabeis = $tbEmpreendimentoContabeis->createRow();
                $empreendimentoContabeis->id_empreendimento = $_POST['empreendimento'];
                $empreendimentoContabeis->id_pessoa_juridica = $_POST['idPessoaJuridica'];
                $empreendimentoContabeis->id_contador = $_POST['idContador'];
                if ($_POST['idContabilidade']) {
                    $empreendimentoContabeis->id_contabilidade = $_POST['idContabilidade'];
                }
                $empreendimentoContabeis->nr_crc = $_POST['dsCrc'];
                //campos referentes ao, Plano de Conta Contbeis
                $empreendimentoContabeis->dt_inclusao_conta = $_POST['dtInclusaoConta'] ? Helper::getInputDate($_POST['dtInclusaoConta']) : null;
                $empreendimentoContabeis->fl_natureza_conta = $_POST['flNaturezaConta'] ? $_POST['flNaturezaConta'] : null;
                $empreendimentoContabeis->fl_tipo_conta = $_POST['flTipoConta'] ? $_POST['flTipoConta'] : null;
                $empreendimentoContabeis->nr_nivel_conta = $_POST['nrNivelConta'] ? $_POST['nrNivelConta'] : null;
                $empreendimentoContabeis->nr_codigo_conta = $_POST['nrCodigoConta'] ? $_POST['nrCodigoConta'] : null;
                $empreendimentoContabeis->ds_nome_conta = $_POST['dsNomeConta'] ? $_POST['dsNomeConta'] : null;
                $empreendimentoContabeis->nr_conta_receita = $_POST['nrContaReceita'] ? $_POST['nrContaReceita'] : null;

                $empreendimentoContabeis->vl_aliquota_pis_pasep = Helper::getInputMoney($_POST['vlAliquotaPisPasep']);
                $empreendimentoContabeis->vl_aliquota_cofins = Helper::getInputMoney($_POST['vlAliquotaCofins']);
                $empreendimentoContabeis->vl_porc_declarada = Helper::getInputMoney($_POST['vlPorcDeclarada']);
                $empreendimentoContabeis->ind_oper = $_POST['tpOperacao'];
                $empreendimentoContabeis->unid_imob = $_POST['tpUnidade'];
                $empreendimentoContabeis->id_filial = $_POST['idFilial'] ? $_POST['idFilial'] : null;
                $empreendimentoContabeis->id_pessoa_fisica_RFB = $_POST['idPessoaRFB'] ? $_POST['idPessoaRFB'] : null;
                $empreendimentoContabeis->ds_log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - i');
                $empreendimentoContabeis->save();
                $db->commit();
                $this->redir(array('modulo' => 'contabil', "controller" => "dadosContabeis", "action" => 'listar'), array("msg" => "success"));
            } catch (Exception $e) {
                $db->rollBack();
                $this->redir(array('modulo' => 'contabil', "controller" => "dadosContabeis", "action" => 'adicionar'), array("exception" => $e->getMessage()));
            }
        }
        $this->display('form');
    }
    public function editarAction()
    {
        if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'editarDadosContabeis')) {
            $this->redir(array('modulo' => 'contabil', 'controller' => 'dadosContabeis', 'action' => 'listar'), array('msgErros' => 'fail', 'exception' => 'Voc no tem permisso para acessar essa funcionalidade.'));
        }

        //Separando apenas id do empreendimento
        $ids = explode('_',$_GET['id']);
        $idEmpreendimento = $ids[0];
        $idRespJuridico = $ids[1];
        $idContador = $ids[2];

        if ($this->_isPost) {
            try {
                $db = Zend_Db_Table::getDefaultAdapter();
                $db->beginTransaction();
                //Salvando SPED
                $tbEmpreendimentoContabeis = new EmpreendimentoContabeis();

                $empreendimentoContabeis = $tbEmpreendimentoContabeis->fetchRow('id_empreendimento = '.$idEmpreendimento. ' AND id_pessoa_juridica = ' . $idRespJuridico. ' AND id_contador = ' .$idContador);

                $empreendimentoContabeis->id_pessoa_juridica = $_POST['idPessoaJuridica'];
                $empreendimentoContabeis->id_contador = $_POST['idContador'];

                if ($_POST['idContabilidade']) {
                    $empreendimentoContabeis->id_contabilidade = $_POST['idContabilidade'];
                }
                $empreendimentoContabeis->nr_crc = $_POST['dsCrc'];
                //campos referentes ao, Plano de Conta Contbeis
                $empreendimentoContabeis->dt_inclusao_conta = $_POST['dtInclusaoConta'] ? Helper::getInputDate($_POST['dtInclusaoConta']) : null;
                $empreendimentoContabeis->fl_natureza_conta = $_POST['flNaturezaConta'] ? $_POST['flNaturezaConta'] : null;
                $empreendimentoContabeis->fl_tipo_conta = $_POST['flTipoConta'] ? $_POST['flTipoConta'] : null;
                $empreendimentoContabeis->nr_nivel_conta = $_POST['nrNivelConta'] ? $_POST['nrNivelConta'] : null;
                $empreendimentoContabeis->nr_codigo_conta = $_POST['nrCodigoConta'] ? $_POST['nrCodigoConta'] : null;
                $empreendimentoContabeis->ds_nome_conta = $_POST['dsNomeConta'] ? $_POST['dsNomeConta'] : null;
                $empreendimentoContabeis->nr_conta_receita = $_POST['nrContaReceita'] ? $_POST['nrContaReceita'] : null;
                
                $empreendimentoContabeis->vl_aliquota_pis_pasep = Helper::getInputMoney($_POST['vlAliquotaPisPasep']);
                $empreendimentoContabeis->vl_aliquota_cofins = Helper::getInputMoney($_POST['vlAliquotaCofins']);
                $empreendimentoContabeis->vl_porc_declarada = Helper::getInputMoney($_POST['vlPorcDeclarada']);
                $empreendimentoContabeis->ind_oper = $_POST['tpOperacao'];
                $empreendimentoContabeis->unid_imob = $_POST['tpUnidade'];
                $empreendimentoContabeis->id_filial = $_POST['idFilial'] ? $_POST['idFilial'] : null;
                $empreendimentoContabeis->id_pessoa_fisica_RFB = $_POST['idPessoaRFB'] ? $_POST['idPessoaRFB'] : null;
                $empreendimentoContabeis->ds_log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - u');

                $empreendimentoContabeis->save();
                $db->commit();

                $this->redir(array('modulo' => 'contabil', "controller" => "dadosContabeis", "action" => 'listar'), array("msg" => "success"));
            } catch (Exception $e) {
                $db->rollBack();
                $this->redir(array('modulo' => 'contabil', "controller" => "dadosContabeis", "action" => 'editar'), array('id'=>$idEmpreendimento,"exception" => $e->getMessage()));
            }
        } else {
            $this->set('listaEmpreendimentos', (new Empreendimento)->getEmpreendimentos());
            $this->set('infoDadosContabeis', (new EmpreendimentoContabeis())->getDadosContabeis($idEmpreendimento,$idRespJuridico,$idContador));
            $this->set('vlPorcDeclarada', EmpreendimentoContabeis::findPorcentagemDeclarada($idEmpreendimento));
            $this->set('listaFiliais', (new Pessoa_Juridica)->fetchAll());
            $this->set('pessoaResponsavelRFB', (new Pessoa())->fetchAll('tp_pessoa = "F"'));
        }

        $this->set('operacao', (new TabelaAgrupada)->findTabelaById('24'));
        $this->set('unidade', (new TabelaAgrupada)->findTabelaById('25'));

        $this->display('form');
    }
    public function validarAction()
    {
        $campos = array(
            'idPessoaJuridica' => 'O <b>Nome Empresarial da Pessoa Juridica</b>  obrigatrio.',
            'idContador' => 'O <b>Corretor</b>  obrigatrio',
            'dsCrc' => 'O <b>CRC</b>  obrigatrio',
            'vlAliquotaPisPasep' => 'O <b>PIS</b>  obrigatrio',
            'vlAliquotaCofins' => 'O <b>COFINS</b>  obrigatrio',
            'tpOperacao' => 'O <b>INDICADOR TIPO DA OPERAO</b>  obrigatrio',
            'tpUnidade' => 'O <b>INDICADOR TIPO DE UNIDADE VENDIDA</b>  obrigatrio',
        );
        
        if ($_GET['a'] == 'adicionar') {
            $campos['idEmpreendimento'] = 'O <b>Empreendimento</b>  obrigatrio.';
        }
        foreach ($campos as $campo => $msg) {
            if ($_POST[$campo] == "") {
                $this->_helper->addMensagem($campo, $msg);
            }
        }

        //Mensagem de Erros
        if (count($this->_helper->getMensagens()) > 0) {
            $msgErros = '';
            foreach ($this->_helper->getMensagens() as $msg => $a)
                $msgErros .= utf8_encode($a) . '<br>';
            echo json_encode(array('msgErros' => $msgErros));
        } else {
            echo json_encode(true);
        }
    }
    /*
     * Busca e exibe em formato json os dados necessarios para o modal de informacoes de lotes
     */
    public function findPessoasByNomeAction()
    {
        $dados = array();

        //Buscando a lista de lotes para exibir na tela
        $lista = Pessoa::findPessoaByNome(utf8_decode($_GET['term']));

        if ($lista) foreach ($lista as $pessoa) {
            $nrCpfCnpj = ($pessoa['nr_cnpj']) ? $pessoa['nr_cnpj'] : $pessoa['nr_cpf'];
            $dados[] = array('text' => utf8_encode($pessoa['nm_pessoa']) . ' (' . $nrCpfCnpj . ')', 'value' => $pessoa['idPessoa']);
        }
        echo json_encode($dados);
    }
    /*
     * Busca por nome as pessoas fisicas
     */
    public function findPessoaJuridicaByNomeAction()
    {
        $dados = array();

        //Buscando a lista de lotes para exibir na tela
        $lista = Pessoa::findPessoaJuridicaByNome(utf8_decode($_GET['term']));

        if ($lista) foreach ($lista as $pessoa) {
            $dados[] = array('text' => utf8_encode($pessoa['nm_pessoa']).' ('.utf8_encode($pessoa['nr_cnpj']).')', 'value' => $pessoa['idPessoa']);
        }
        echo json_encode($dados);
    }
    /*
     * Busca por nome as pessoas fisicas
     */
    public function findPessoaFisicaByNomeAction()
    {
        $dados = array();

        //Buscando a lista de lotes para exibir na tela
        $lista = Pessoa::findPessoaFisicaByNome(utf8_decode($_GET['term']));

        if ($lista) foreach ($lista as $pessoa) {
            $dados[] = array('text' => utf8_encode($pessoa['nm_pessoa']).' ('.utf8_encode($pessoa['nr_cpf']).')', 'value' => $pessoa['idPessoa']);
        }
        echo json_encode($dados);
    }
    /*
     * Busca por nome as pessoas fisicas
     */
    public function findPorcentagemDeclaradaAction()
    {
        echo json_encode(EmpreendimentoContabeis::findPorcentagemDeclarada($_POST['idEmpreendimento']));
    }
    /*
     * Busca por nome as pessoas fisicas
     */
    public function findPjResponsavelCorretorAction()
    {
        echo json_encode(EmpreendimentoContabeis::findPjResponsavelCorretor($_POST['idRespJuridico'],$_POST['idEmpreendimento'],$_POST['idContador']));
    }
}