<?php

class ArquivoSpedController extends Controller
{
    public function indexAction()
    {
        $this->redir(array("modulo" => "contabil", "controller" => "arquivoSped", "action" => "listar"));
    }

    public function listarAction()
    {
        if ($this->isAjax()) {
            $listaItem = Sped::findLista($_POST);
            $totalItens = Sped::findLista($_POST, true);
            $lista = array();
            foreach ($listaItem as $item) {
                $acoes = '<div style="width: 90px"></div><div align="center" style="width: 100%;">';
                //Boto Visualizar
                $acoes .= '<span data-toggle="modal" data-target=".modalVisualizar"><button type="button" value="' . $item['id_sped'] . '" data-toggle="tooltip" title="VISUALIZAR" class="btn btn-default btn-sm btn-visualizar" style="margin-right:5px"><i class="fa fa-eye"></i> </button></span>';
                //Boto Baixar
                $acoes .= '<a onClick="baixarArquivo('.$item['id_sped'].')" href="' . $item['ds_arquivo'] . '" target="_blank" download data-toggle="tooltip" title="BAIXAR" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-download"></i></a>';
                //Gerar
                $acoes .= '<a target="_blank" href="index.php?m='.$this->modulo. '&c=' . $this->controller. '&a=gerarPdf&id='. $item['id_sped']. '" data-toggle="tooltip" title="GERAR" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-file-text"></i></a>';
                $acoes .= '</div>';
                //Quebra caminho de arquivo para pegar ultima posio (nome do arquivo)
                $dsArquivo = explode('/', $item['ds_arquivo']);
                $dsArquivo = end($dsArquivo);
                $incluirSinal = ($item['incluir_sinal'] == '1') ? '<a onclick="" class="btn construcao label label-success">Sim</a>' : '<a onclick="" class="btn construcao label label-danger">No</a>';
                $lista[] = array(
                    'idSped' => '<div align="center">'.$item['id_sped'].'</div>',
                    'nmEmpreendimento' => utf8_encode($item['nm_empreendimento']),
                    'dtGeracao' => '<div hidden>' . $item['dt_geracao'] . '</div><div align="center">' . Helper::getDate($item['dt_geracao']).'</div>',
                    'dsPeriodo' => utf8_encode($item['ds_periodo']),
                    'sinal' => '<div align="center">'. utf8_encode($incluirSinal).'</div>',
                    'dsArquivo' => utf8_encode($dsArquivo),
                    'acoes' => utf8_encode($acoes)
                );
            }
            echo json_encode(array(
                'draw' => $_POST['draw'],
                'recordsTotal' => count($totalItens),
                'recordsFiltered' => count($totalItens),
                'data' => $lista
            ));

        } else {
            $this->display('listar');
        }
    }

    public function gerarAction()
    {
        if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'gerarArquivoSped')) {
            $this->redir(array('modulo' => 'contabil', 'controller' => 'arquivoSped', 'action' => 'listar'), array('msgErros' => 'fail', 'exception' => 'Voc no tem permisso para acessar essa funcionalidade.'));
        }

        $this->set('listaEmpreendimentos', (new Empreendimento)->getEmpreendimentos(true));
        $this->set('listaRespJuridicos', (new EmpreendimentoContabeis())->getRespJuridicos());

        if ($this->_isPost) {
            // o empreendimento escolhido.
            $dtInicial = Helper::getInputDate($_POST['dtInicial']);
            $dtFinal = Helper::getInputDate($_POST['dtFinal']);

            if ($_POST['tipoGeracao'] == 'E') {

                $postEmpreedimento = explode('_',$_POST['empreendimento']);
                $empreendimento = $postEmpreedimento[0];
                $idRespJuridico = $postEmpreedimento[1];

                //Consulta para trazer o Tipo do Loteamento
                $empreendimentoInfo = Zend_Db_Table::getDefaultAdapter()->select()
                    ->from(array('em' => TB_EMPREENDIMENTO), array('id_tipo_loteamento', 'ds_path_logo'))
                    ->join(array('t' => TB_TIPO_LOTEAMENTO), 'em.id_tipo_loteamento = t.id_tipo_loteamento', array('*'))
                    ->where('em.id = '.$empreendimento)
                    ->query()->fetch();

                $this->set("empreendimentoInfo", $empreendimentoInfo);
            } else {
                $idRespJuridico = $_POST['idRespJuridico'];

                $listaEmpreendimento = Zend_Db_Table::getDefaultAdapter()->select()
                    ->from(array('ec' => TB_EMPREENDIMENTO_CONTABEIS), array('id_empreendimento'))
                    ->where('id_pessoa_juridica = ' . $idRespJuridico)
                    ->query()->fetchAll();

                foreach ($listaEmpreendimento as $emp) {
                    $empreendimento[] = $emp['id_empreendimento'];
                }

                $empreendimento = implode('","', $empreendimento);
            }

            $ordem = ($_POST['ordem'] == 'Q') ? array('quadra', 'lote') : 'nm_pessoa';

            $contratosPF = Zend_Db_Table::getDefaultAdapter()->select()
                ->from(array('l' => TB_LOTES), array('lote', 'quadra'))
                ->join(array('c' => TB_CONTRATO), 'l.id = c.id_lote', array('id_contrato' => 'id', 'nr_parcela',
                    'vl_parcela', 'nr_parcela_sinal', 'vl_sinal', 'nr_intercalada', 'vl_intercalada',
                    'nr_parcela_entrega', 'vl_parcela_entrega', 'dt_contrato', 'inclui_sinal_contrato', 'fl_distrato', 'fl_itens_contrato', 'porcentagem_participacao_contrato'))
                ->join(array('pe' => TB_PESSOA), 'pe.id = c.id_pessoa', array('idPessoa' => 'id', 'nm_pessoa'))
                ->join(array('pf' => TB_PESSOA_FISICA), 'pe.id = pf.id_pessoa', array('cpf_cnpj' => 'nr_cpf'))
                ->join(array('e' => TB_EMPREENDIMENTO), 'e.id = l.id_empreendimento', array('nm_empreendimento','idEmpreendimento'=>'id'));

            if ($idRespJuridico) {
                $contratosPF->joinLeft(array('ec' => TB_EMPREENDIMENTO_CONTABEIS), 'ec.id_empreendimento = e.id', array('vl_porc_declarada'))
                    ->where('id_pessoa_juridica = '.$idRespJuridico);
            }

            $contratosPF = $contratosPF->where('e.id IN ("' . $empreendimento.'")')
                ->group('c.id')->order($ordem)->query()->fetchAll();

            $contratosPJ = Zend_Db_Table::getDefaultAdapter()->select()
                ->from(array('l' => TB_LOTES), array('lote', 'quadra'))
                ->join(array('c' => TB_CONTRATO), 'l.id = c.id_lote', array('id_contrato' => 'id', 'nr_parcela', 'vl_parcela', 'nr_parcela_sinal', 'vl_sinal', 'nr_intercalada', 
                    'vl_intercalada', 'nr_parcela_entrega', 'vl_parcela_entrega', 'dt_contrato', 'inclui_sinal_contrato', 'fl_distrato', 'fl_itens_contrato', 'porcentagem_participacao_contrato'))
                ->join(array('pe' => TB_PESSOA), 'pe.id = c.id_pessoa', array('idPessoa' => 'id', 'nm_pessoa'))
                ->join(array('pj' => TB_PESSOA_JURIDICA), 'pe.id = pj.id_pessoa', array('cpf_cnpj' => 'nr_cnpj'))
                ->join(array('e' => TB_EMPREENDIMENTO), 'e.id = l.id_empreendimento', array('nm_empreendimento','idEmpreendimento'=>'id'));

            if ($idRespJuridico) {
                $contratosPJ->joinLeft(array('ec' => TB_EMPREENDIMENTO_CONTABEIS), 'ec.id_empreendimento = e.id', array('vl_porc_declarada'))
                    ->where('id_pessoa_juridica = '.$idRespJuridico);
            }

            $contratosPJ = $contratosPJ->where('e.id IN ("' . $empreendimento.'")')
                ->group('c.id')->order($ordem)->query()->fetchAll();

            $contratos = array_merge($contratosPF, $contratosPJ);
            
            foreach ($contratos as $contrato) {

                if ($contrato['porcentagem_participacao_contrato'] != null && $contrato['porcentagem_participacao_contrato'] < 100) {
                    $outrosContratos[] = $contrato['id_contrato'];
                }
            }

            if ($outrosContratos) {
                $outrosContratos = (new Contrato)->buscaOutrosCompradoresSped($outrosContratos, $idRespJuridico);
                $contratos = array_merge($contratos, $outrosContratos);
            }
            
            // Verifica se tem registros, caso n?o tenha nem chama o relat?rio.
            if (count($contratos) == 0) {
                $this->_helper->addMensagem('danger', 'Informaes no encontradas!');
                $this->display('gerar');
                exit;
            }
            //Verifica o checkbox de outros para excluir ou no o tipo de baixa
            $tpBaixas = false;
            if (isset($_POST['tpBanco'])) {
                $tpBaixas[] = $_POST['tpBanco'];
            }
            if (isset($_POST['tpTesouraria'])) {
                $tpBaixas[] = $_POST['tpTesouraria'];
            }
            if (isset($_POST['tpOutros'])) {
                $tpBaixas[] = $_POST['tpOutros'];
            }
            if ($tpBaixas) {
                $tpBaixas = implode('","',$tpBaixas);
            }

            $aux = array();
            $i = 0;

            $filtroData = ($_POST['filtroData'] == 'DP') ? 'dt_pagamento' : 'dt_credito';

            $tbEmpreendimento = new Empreendimento;
            $adapter = $tbEmpreendimento->getAdapter();

            foreach ($contratos as $contrato) {

                if($contrato['inclui_sinal_contrato'] == '0' || $_POST['incluirSinal'] == '0'){
                    $parcSinal = "S";
                }else{
                    $parcSinal = null;
                }
                //Busca as parcelas do contrato, excluindo o tipo de baixa 'O' de acordo com o checkbox do formulario.
                $valores = Parcela::valorParcelasPagasByContrato($contrato['id_contrato'], $dtInicial, $dtFinal, $tpBaixas, $_POST['filtroData'], $parcSinal);
                
                $valoresHistorico = Parcela::valorParcelasPagasHistoricoByContrato($contrato['id_contrato'], $dtInicial, $dtFinal, $tpBaixas, $_POST['filtroData']);
                
                if (is_null($valores['valorParcela']) && is_null($valoresHistorico['valorParcela'])) {
                    unset($aux[$i]);
                    continue;
                }

                $aux[$i]['lote'] = $contrato['lote'];
                $aux[$i]['idEmpreendimento'] = $contrato['idEmpreendimento'];
                $aux[$i]['nm_empreendimento'] = $contrato['nm_empreendimento'];
                $aux[$i]['quadra'] = $contrato['quadra'];
                $aux[$i]['cliente'] = $contrato['nm_pessoa'];
                $aux[$i]['contrato'] = $contrato['id_contrato'];
                $aux[$i]['idPessoa'] = $contrato['idPessoa'];
                $aux[$i]['desconto'] = $valores['desconto'] + $valoresHistorico['desconto'];
                $aux[$i]['acrescimo'] = $valores['acrescimo'] + $valoresHistorico['acrescimo'];
                $aux[$i]['valorDaParcela'] = ($valores['valorParcela'] + $valoresHistorico['valorParcela'])-$aux[$i]['desconto']+$aux[$i]['acrescimo'];
                $aux[$i]['vl_juros'] = $valores['valorJuros'] + $valoresHistorico['valorJuros'];
                $aux[$i]['vl_multa'] = $valores['valorMulta'] + $valoresHistorico['valorMulta'];
                $aux[$i]['vl_total_pago'] = $valores['valorTotal'] + $valoresHistorico['valorTotal'];
                $aux[$i]['porcentagem_participacao_contrato'] = $contrato['porcentagem_participacao_contrato'];
                
                //Verifica se o contrato possui mais de um comprador, se sim, a porcentagem de participao  usado para calcular o valor da atividade valorDaParcela e vl_juros.
                if ($aux[$i]['porcentagem_participacao_contrato']) {
                    $aux[$i]['valorDaParcela'] = ($aux[$i]['valorDaParcela'] / 100) * $aux[$i]['porcentagem_participacao_contrato'];
                    $aux[$i]['vl_juros'] = ($aux[$i]['vl_juros'] / 100) * $aux[$i]['porcentagem_participacao_contrato'];
                    $aux[$i]['vl_multa'] = ($aux[$i]['vl_multa'] / 100) * $aux[$i]['porcentagem_participacao_contrato'];
                }

                if ($_POST['gerarRelatorio'] == '0' || ($_POST['gerarRelatorio'] == '1' && $_POST['checkPorcRelatorio'] == 1)) {
                    //Multiplica o valor total pago pela porcentagem declarada em Dados Contabeis para este empreendimento
                    if ($contrato['vl_porc_declarada'] > 0 && $contrato['vl_porc_declarada'] < 100) {
                        $aux[$i]['vl_total_pago'] = $aux[$i]['vl_total_pago']*($contrato['vl_porc_declarada']/100);
                    }
                }

                //Verifica se o contrato possui mais de um comprador, se sim, a porcentagem de participao  usado para calcular o valor da atividade vl_total_pago.
                if ($aux[$i]['porcentagem_participacao_contrato']) {
                    $aux[$i]['vl_total_pago'] = ($aux[$i]['vl_total_pago'] / 100) * (float)$aux[$i]['porcentagem_participacao_contrato'];
                }

                $dt = explode('-', $contrato['dt_contrato']);
                $dataContrato = $dt[2] . '/' . $dt[1] . '/' . $dt[0];
                $aux[$i]['dt_contrato'] = $dataContrato;
                $aux[$i]['cpf_cnpj'] = $contrato['cpf_cnpj'];
                $aux[$i]['vlVenda'] = ($contrato['vl_parcela'] * $contrato['nr_parcela']) + ($contrato['vl_intercalada'] * $contrato['nr_intercalada']) + ($contrato['vl_parcela_entrega'] * $contrato['nr_parcela_entrega']);
                if ($contrato['inclui_sinal_contrato'] == 1) {
                    $aux[$i]['vlVenda'] += $contrato['vl_sinal'];
                }
                //Busca os valores dos itens adicionais se existirem
                if ($contrato['fl_itens_contrato'] == '1') {
                    $itensContrato = ContratoItens::findByContrato($contrato['id_contrato']);

                    if (count($itensContrato) > 0)
                        foreach ($itensContrato as $item) {
                            $aux[$i]['vlVenda'] += $item['vl_parcela'] * $item['qt_parcelas'];
                        }
                }

                //Verifica se o contrato possui mais de um comprador, se sim, a porcentagem de participao  usado para calcular o valor da atividade vlVenda.
                if ($aux[$i]['porcentagem_participacao_contrato']) {
                    $aux[$i]['vlVenda'] = ($aux[$i]['vlVenda'] / 100) * $aux[$i]['porcentagem_participacao_contrato'];
                }

                if($contrato['inclui_sinal_contrato'] == '0' || $_POST['incluirSinal'] == '0'){
                    $parcSinal = "S";
                }else{
                    $parcSinal = null;
                }

                if ($contrato['fl_distrato'] != '1') {
                    $parciais = $adapter->select()
                        ->from(array('p' => TB_PARCELA), array('valorRecebido' => new Zend_Db_Expr('sum(vl_total_pago)')))
                        ->where("id_contrato = " . $contrato['id_contrato'])
                        ->where($filtroData . " < '{$dtInicial}'")
                        ->where('tp_baixa IN ("' . $tpBaixas . '")')
                        ->where("pago = '1'")
                        ->where('tp_parcela != "'. $parcSinal . '"')
                        ->query()->fetch();
                } else {
                    $parciais = $adapter->select()
                        ->from(array('p' => TB_PARCELA_HISTORICO), array('valorRecebido' => new Zend_Db_Expr('sum(vl_total_pago)')))
                        ->where("id_contrato = " . $contrato['id_contrato'])
                        ->where($filtroData . " < '{$dtInicial}'")
                        ->where('tp_baixa IN ("' . $tpBaixas . '")')
                        ->where("pago = '1'")
                        ->where('tp_parcela != "'. $parcSinal . '"')
                        ->query()->fetch();
                }
                $aux[$i]['valorRecebido'] = $parciais['valorRecebido'];
                
                //Verifica se o contrato possui mais de um comprador, se sim, a porcentagem de participao  usado para calcular o valor da atividade vlVenda.
                if ($aux[$i]['porcentagem_participacao_contrato']) {
                    $aux[$i]['valorRecebido'] = ($aux[$i]['valorRecebido'] / 100) * $aux[$i]['porcentagem_participacao_contrato'];
                }

                $i++;
            }
            
            //Ordenando array por Empreendimento, quadra e lote
            function cmp($a, $b)
            {
                return strcmp($a["nm_empreendimento"].$a["quadra"].$a["lote"], $b["nm_empreendimento"].$b["quadra"].$b["lote"]);
            }
            usort($aux, 'cmp');

            if ($_POST['gerarRelatorio'] == '1' && $_POST['tipoRelatorio'] == 'pdf') {
                $clienteAcade = (new Db_Cliente())->fetchRow()->toArray();
                $this->set('clienteAcade', $clienteAcade);
                $this->set('filtros', array('empreendimento' => $aux[0]['nm_empreendimento'],
                    'dtInicial' => $_POST['dtInicial'],
                    'dtFinal' => $_POST['dtFinal'],
                    'sinal' => $_POST['incluirSinal'],
                    'outros' => $_POST['outros'],
                    'filtroData' => $_POST['filtroData'],
                    'checkExibirPorc' => $_POST['checkPorcRelatorio']
                ));
                
                $this->set('clientes', $aux);
                $this->display('relatorioSped');
                $this->displayMPDF("sped" . date("d/m/Y") . ".pdf", true, "L", "A4", array(1, 1, 1, 1));
            } else if($_POST['gerarRelatorio'] == '1' && $_POST['tipoRelatorio'] == 'xls') {
                $colunas = [
                    'Contrato', 
                    'Cliente', 
                    'CPF/CNPJ', 
                    'Data do Contrato', 
                    'Qdr', 
                    'Lt', 
                    'Valor Total do Imvel',
                    'Total Recebido Acumulado',
                    'Vl Parcelas',
                    'Vl Desconto',
                    'Vl Juros',
                    'Vl Multa',
                    'Total Pago'
                ];
                foreach ($aux as $item) {
                    $linhas[] = [
                        $item['contrato'],
                        $item['cliente'],
                        $item['cpf_cnpj'],
                        $item['dt_contrato'],
                        $item['quadra'],
                        $item['lote'],
                        $item['vlVenda'],
                        $item['valorRecebido'],
                        $item['valorDaParcela'],
                        $item['desconto'],
                        $item['vl_juros'],
                        $item['vl_multa'],
                        $item['vl_total_pago']
                    ];
                }
                $this->geraExcel($colunas, $linhas);

            } else {
                //Infor do empreendimento para SPED
                $infoEmpreendimento = Zend_Db_Table::getDefaultAdapter()->select()
                    ->from(array('e' => TB_EMPREENDIMENTO), array('nm_empreendimento'))
                    ->joinLeft(array('ec' => TB_EMPREENDIMENTO_CONTABEIS), 'ec.id_empreendimento = e.id', array('*'))
                    ->joinLeft(array('pjResponsavel' => TB_PESSOA), 'pjResponsavel.id = ec.id_pessoa_juridica', array('nmPjResponsavel'=>'nm_pessoa'))
                    ->joinLeft(array('pcontador' => TB_PESSOA), 'pcontador.id = ec.id_contador', array(
                        'nmContador'=>'nm_pessoa','nrCepContador'=>'nr_cep','enderecoContador'=>'endereco',
                        'nrEnderecoContador'=>'nr_endereco','dsComplementoContador'=>'ds_complemento',
                        'nmBairroContador'=>'nm_bairro', 'nrTelefoneContador'=>'nr_telefone',
                        'nrCelularContador'=>'nr_celular', 'emailContador'=>'email','cdCidadeContador'=>'cd_cidade'
                    ))
                    ->joinLeft(array('pfcontador' => TB_PESSOA_FISICA), 'pfcontador.id_pessoa = pcontador.id', array(
                        'cpfContador'=>'nr_cpf'
                    ))
                    ->joinLeft(array('pcontabilidade' => TB_PESSOA), 'pcontabilidade.id = ec.id_contabilidade', array(
                        'nmContabilidade'=>'nm_pessoa','nrCepContabilidade'=>'nr_cep','enderecoContabilidade'=>'endereco',
                        'nrEnderecoContabilidade'=>'nr_endereco','dsComplementoContabilidade'=>'ds_complemento',
                        'nmBairroContabilidade'=>'nm_bairro', 'nrTelefoneContabilidade'=>'nr_telefone',
                        'nrCelularContabilidade'=>'nr_celular', 'emailContabilidade'=>'email',
                        'cdCidadeContabilidade'=>'cd_cidade'
                    ))
                    ->joinLeft(array('pjcontabilidade' => TB_PESSOA_JURIDICA), 'pjcontabilidade.id_pessoa = pcontabilidade.id', array('cnpjContabilidade'=>'nr_cnpj'))
                    ->joinLeft(array('pJuridica' => TB_PESSOA_JURIDICA), 'pJuridica.id_pessoa = pjResponsavel.id', array('cnpJuridica'=>'nr_cnpj','nr_inscricao_municipal','nr_inscricao_estadual'))
                    ->joinLeft(array('pfFilial' => TB_PESSOA_JURIDICA), 'pfFilial.id_pessoa = ec.id_filial', array(
                        'cnpjFilial'=>'nr_cnpj', 'nmFilial' => 'nm_fantasia'))
                    ->where('e.id IN ("' . $empreendimento.'")')
                    ->where('ec.id_pessoa_juridica = ' . $idRespJuridico)
                    ->query()->fetchAll();

                $infoCliente = Zend_Db_Table::getDefaultAdapter()->select()
                    ->from(array('cli' => TB_CLIENTE), array('*'))
                    ->joinLeft(array('cid' => TB_CIDADE), 'cid.id = cli.cd_municipio', array('cidadeCliente'=>'nome','ufCliente'=>'uf'))
                    ->query()->fetch();
                $filial = [];
                foreach($infoEmpreendimento as $emp){
                    if($emp['id_filial'] && $emp['cnpjFilial']){
                        array_push($filial,$emp['id_empreendimento']);
                    }
                }
                $auxSemFilial = [];
                if($_POST['parcelasFilial']=="N"){
                    foreach($aux as $key=>$parcela){    
                        if(!in_array($parcela['idEmpreendimento'],$filial)){
                            array_push($auxSemFilial,$parcela);
                        }
                    }
                }
                else{
                    $auxSemFilial = $aux;
                }
                $dados = array(
                    'listaParcelas' => $auxSemFilial,
                    'infoCliente' => $infoCliente,
                    'post' => $_POST,
                    'infoEmpreendimento' => $infoEmpreendimento,
                    'filial' => $filial,
                    'parcelasFilial' => $_POST['parcelasFilial']
                );

                //Gera arquivo SPED
                $aquivo = (new ArquivoSped())->gerarSped($dados);

                //Verifica se houve algum erro
                if ($aquivo['erro']) {
                    $this->redir(array('modulo' => 'contabil', "controller" => "arquivoSped", "action" => 'gerar'), array("exception" => $aquivo['msgErro']));
                } else {
                    try {
                        $db = Zend_Db_Table::getDefaultAdapter();
                        $db->beginTransaction();
                        //Salvando SPED
                        $arquivoSped = (new ArquivoSped())->createRow();
                        if ($_POST['tipoGeracao'] == 'E') {
                            $arquivoSped->id_empreendimento = $empreendimento;
                        }
                        $arquivoSped->dt_geracao = date('Y-m-d');
                        $arquivoSped->ds_periodo = $_POST['dtInicial'].' at '.$_POST['dtFinal'];
                        $arquivoSped->incluir_sinal = $_POST['incluirSinal'];
                        $arquivoSped->ds_arquivo = $aquivo['path'];
                        $arquivoSped->ds_log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - i');
                        $idSped = $arquivoSped->save();
                        //Salvando os itens do SPED
                        
                        foreach ($auxSemFilial as $cont) {
                            $arquivoSpedItens = (new ArquivoSpedItens())->createRow();
                            $arquivoSpedItens->id_sped = $idSped;
                            $arquivoSpedItens->id_contrato = $cont['contrato'];
                            $arquivoSpedItens->id_pessoa = $cont['idPessoa'];
                            $arquivoSpedItens->id_empreendimento = $cont['idEmpreendimento'];
                            $arquivoSpedItens->vl_total_pago = $cont['vl_total_pago'];
                            $arquivoSpedItens->vl_pis = ($cont['vl_total_pago']*$infoEmpreendimento[0]['vl_aliquota_pis_pasep'])/100;
                            $arquivoSpedItens->vl_cofins = ($cont['vl_total_pago']*$infoEmpreendimento[0]['vl_aliquota_cofins'])/100;
                            $arquivoSpedItens->ds_log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - i');
                            $arquivoSpedItens->save();
                        }
                        $db->commit();
                        $this->redir(array('modulo' => 'contabil', "controller" => "arquivoSped", "action" => 'listar'), array("msg" => "success"));
                    } catch (Exception $e) {
                        $db->rollBack();
                        $this->redir(array('modulo' => 'contabil', "controller" => "arquivoSped", "action" => 'gerar'), array("exception" => $e->getMessage()));
                    }
                }
            }
        }

        $this->display();
    }

    public function gerarPdfAction()
    {
        $cliente = (new Db_Cliente())->fetchRow()->toArray();
        $listaSpedItens = Zend_Db_Table::getDefaultAdapter()->select()
            ->from(array('si' => TB_SPED_ITENS), array('*'))
            ->join(array('s' => TB_SPED), 's.id_sped = si.id_sped', '*')
            ->joinLeft(array('e' => TB_EMPREENDIMENTO), 'e.id = s.id_empreendimento', array('nmEmpSped'=>'nm_empreendimento', 'idEmpreendimento'=>'id'))
            ->joinLeft(array('eSi' => TB_EMPREENDIMENTO), 'eSi.id = si.id_empreendimento', array('nmEmpSpedItens'=>'nm_empreendimento', 'idEmpSpedItens'=>'id'))
            ->join(array('c' => TB_CONTRATO), 'c.id = si.id_contrato', null)
            ->join(array('l' => TB_LOTES), 'l.id = c.id_lote', array('quadra','lote'))
            ->joinLeft(array('p' => TB_PESSOA), 'p.id = si.id_pessoa', array('nm_pessoa'))
            ->joinLeft(array('p2' => TB_PESSOA), 'p2.id = si.id_pessoa', array('nm_outro_comprador' => 'nm_pessoa'))
            ->where('si.id_sped = ' . $_GET['id'])
            ->order('e.nm_empreendimento')
            ->order('eSi.nm_empreendimento')
            ->order('l.quadra')
            ->order('l.lote')
            ->query()->fetchAll();

        $this->set('listaSpedItens',$listaSpedItens);
        $this->set('infoCliente', $cliente);

        $empreendimentoInfo = [];

        if ($listaSpedItens[0]['idEmpreendimento']) {
            //Consulta para trazer o Tipo do Loteamento
            $empreendimentoInfo = Zend_Db_Table::getDefaultAdapter()->select()
                ->from(array('em' => TB_EMPREENDIMENTO), array('id_tipo_loteamento', 'ds_path_logo'))
                ->join(array('t' => TB_TIPO_LOTEAMENTO), 'em.id_tipo_loteamento = t.id_tipo_loteamento', array('*'))
                ->where('em.id = '.$listaSpedItens[0]['idEmpreendimento'])
                ->query()->fetch();
        }
        $this->set("empreendimentoInfo", $empreendimentoInfo);

        $this->display('gerarPdf');
        $this->displayMPDF('sped_'.$_GET['id'] .'_'. date("d/m/y_His") . ".pdf");
    }

    public function validarAction()
    {
        $campos = array('dtInicial' => 'A <b>Data Inicial</b>  obrigatria', 'dtFinal' => 'A <b>Data Final</b>  obrigatria');
        foreach ($campos as $campo => $msg) {
            if ($_POST[$campo] == "") {
                $this->_helper->addMensagem('danger', $msg);
            }
        }

        $postEmpreedimento = explode('_',$_POST['empreendimento']);
        $idEmpreendimento = $postEmpreedimento[0];

        if ($_POST['tipoGeracao'] == 'E' && !$idEmpreendimento) {
            $this->_helper->addMensagem('danger', 'O <b>Empreendimento</b>  obrigatrio');
        }
        // Verifica se tem registros.
        if ($this->_isPost && count($this->_helper->getMensagens()) == 0) {
            $empreendimento = $_POST['empreendimento'];
            $dtInicial = Helper::getInputDate($_POST['dtInicial']);
            $dtFinal = Helper::getInputDate($_POST['dtFinal']);

            if ($idEmpreendimento) {
                $empreendimento = $idEmpreendimento;
            } else {
                $listaEmpreendimento = Zend_Db_Table::getDefaultAdapter()->select()
                    ->from(array('ec' => TB_EMPREENDIMENTO_CONTABEIS), array('id_empreendimento'))
                    ->where('id_pessoa_juridica = ' . $_POST['idRespJuridico'])
                    ->query()->fetchAll();
                $empreendimento = [];
                foreach ($listaEmpreendimento as $emp) {
                    $empreendimento[] = $emp['id_empreendimento'];
                }
                $empreendimento = implode('","', $empreendimento);
            }

            $ordem = ($_POST['ordem'] == 'Q') ? array('quadra', 'lote') : 'nm_pessoa';

            $contratosPF = Zend_Db_Table::getDefaultAdapter()->select()
                ->from(array('l' => TB_LOTES), array('lote', 'quadra'))
                ->join(array('c' => TB_CONTRATO), 'l.id = c.id_lote', array('id_contrato' => 'id', 'nr_parcela', 'vl_parcela', 'nr_parcela_sinal', 'vl_sinal', 'nr_intercalada', 'vl_intercalada', 'nr_parcela_entrega', 'vl_parcela_entrega', 'dt_contrato', 'inclui_sinal_contrato', 'fl_distrato', 'fl_itens_contrato'))
                ->join(array('pe' => TB_PESSOA), 'pe.id = c.id_pessoa', array('nm_pessoa'))
                ->join(array('pf' => TB_PESSOA_FISICA), 'pe.id = pf.id_pessoa', array('cpf_cnpj' => 'nr_cpf'))
                ->where('id_empreendimento IN ("' . $empreendimento.'")')
                ->group('c.id')
                ->order($ordem)
                ->query()->fetchAll();

            $contratosPJ = Zend_Db_Table::getDefaultAdapter()->select()
                ->from(array('l' => TB_LOTES), array('lote', 'quadra'))
                ->join(array('c' => TB_CONTRATO), 'l.id = c.id_lote', array('id_contrato' => 'id', 'nr_parcela', 'vl_parcela', 'nr_parcela_sinal', 'vl_sinal', 'nr_intercalada', 'vl_intercalada', 'nr_parcela_entrega', 'vl_parcela_entrega', 'dt_contrato', 'inclui_sinal_contrato', 'fl_distrato', 'fl_itens_contrato'))
                ->join(array('pe' => TB_PESSOA), 'pe.id = c.id_pessoa', array('nm_pessoa'))
                ->join(array('pj' => TB_PESSOA_JURIDICA), 'pe.id = pj.id_pessoa', array('cpf_cnpj' => 'nr_cnpj'))
                ->where('id_empreendimento IN ("' . $empreendimento.'")')
                ->group('c.id')
                ->order($ordem)
                ->query()->fetchAll();


            $contratos = array_merge($contratosPF, $contratosPJ);

            $tpBaixas = false;
            if (isset($_POST['tpBanco'])) {
                $tpBaixas[] = $_POST['tpBanco'];
            }
            if (isset($_POST['tpTesouraria'])) {
                $tpBaixas[] = $_POST['tpTesouraria'];
            }
            if (isset($_POST['tpOutros'])) {
                $tpBaixas[] = $_POST['tpOutros'];
            }
            if ($tpBaixas) {
                $tpBaixas = implode('","',$tpBaixas);
            }

            foreach ($contratos as $k => &$contrato) {
                //Busca as parcelas do contrato, excluindo o tipo de baixa 'O' de acordo com o checkbox do formulario.
                $valores = Parcela::valorParcelasPagasByContrato($contrato['id_contrato'], $dtInicial, $dtFinal, $tpBaixas, $_POST['filtroData']);
                $valoresHistorico = Parcela::valorParcelasPagasHistoricoByContrato($contrato['id_contrato'], $dtInicial, $dtFinal, $tpBaixas, $_POST['filtroData']);

                if (is_null($valores['valorParcela']) && is_null($valoresHistorico['valorParcela'])) {
                    unset($contratos[$k]);
                    continue;
                }
            }

            if (!$contratos) {
                $msg = "Nenhum resultado foi encontrado.";
                $this->_helper->addMensagem('danger', $msg);
            }

            $dadosContabeis = (new EmpreendimentoContabeis())->fetchRow('id_empreendimento IN ("' . $empreendimento.'")');

            if (!$dadosContabeis && $_POST['gerarRelatorio'] == '0') {
                $msg = " preciso cadastrar os Dados Contabeis para poder gerar o Arquivo SPED";
                $this->_helper->addMensagem('danger', $msg);
            }
        }
        //Mensagem de Erros
        if (count($this->_helper->getMensagens()) > 0) {
            $msgErros = '';
            foreach ($this->_helper->getMensagens() as $msg => $a)
                $msgErros .= utf8_encode($a) . '<br>';
            echo json_encode(array('msgErros' => $msgErros));
        } else {
            echo json_encode(true);
        }
    }

    public function visualizarAction()
    {
        header("Content-type: text/html; charset=UTF-8");
        $listaSpedItens = Zend_Db_Table::getDefaultAdapter()->select()
            ->from(array('si' => TB_SPED_ITENS), array('*'))
            ->join(array('s' => TB_SPED), 's.id_sped = si.id_sped', '*')
            ->joinLeft(array('e' => TB_EMPREENDIMENTO), 'e.id = s.id_empreendimento', array('nmEmpSped'=>'nm_empreendimento'))
            ->joinLeft(array('eSi' => TB_EMPREENDIMENTO), 'eSi.id = si.id_empreendimento', array('nmEmpSpedItens'=>'nm_empreendimento'))
            ->join(array('c' => TB_CONTRATO), 'c.id = si.id_contrato', null)
            ->join(array('l' => TB_LOTES), 'l.id = c.id_lote', array('quadra','lote'))
            ->joinLeft(array('p' => TB_PESSOA), 'p.id = si.id_pessoa', array('nm_pessoa'))
            ->where('si.id_sped = ' . $_POST['id'])
            ->order('e.nm_empreendimento')
            ->order('eSi.nm_empreendimento')
            ->order('l.quadra')
            ->order('l.lote')
            ->query()->fetchAll();
        $this->set('listaSpedItens',$listaSpedItens);
        $this->display('visualizar');
    }
}