<?php
/**
 * Created by PhpStorm.
 * User: usuario
 * Date: 23/10/19
 * Time: 15:23
 */

class ArquivoDimobController extends Controller
{
    protected $tb_empreendimento;

    public function __construct($request)
    {
        parent::__construct($request);
        $this->tb_empreendimento = new Empreendimento();
    }

    public function indexAction()
    {
        $this->redir(array('modulo' => 'contabil', 'controller' => 'arquivoDimob', 'action' => 'listar'));
    }

    public function listarAction()
    {
        if ($this->isAjax()) {
            $listaItem = Dimob::findLista($_POST);
            $totalItens = Dimob::findLista($_POST, true);
            $lista = array();

            foreach ($listaItem as $item) {

                $acoes = '<div style="width: 90px;"></div><div align="center" style="width: 100%">';
                //Boto visualizar
                $acoes .= '<span data-toggle="modal" data-target=".modalVisualizar"><button type="button" value="'.$item['id_dimob'].'" data-toggle="tooltip" title="VISUALIZAR" class="btn btn-default btn-sm btn-visualizar" style="margin-right:5px"><i class="fa fa-eye"></i></button></span>';
                //Boto Baixar
                $acoes .= '<a href="'.$item['ds_arquivo'].'" target="_blank" download data-toggle="tooltip" title="BAIXAR" class="btn btn-default btn-sm" style="margin-right:5px;"><i class="fa fa-download"></i></a>';
                //Gerar
                $acoes .= '<a target="_blank" href="index.php?m='.$this->modulo.'&c='.$this->controller.'&a=gerarPdf&id='.$item['id_dimob'].'" data-toggle="tooltip" title="GERAR" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-file-text"></i></a>';
                $acoes .= '</div>';
                //Quebra caminho de arquivo para pegar ultima posio (nome do arquivo)
                $dsArquivo = explode('/', $item['ds_arquivo']);
                $dsArquivo = end($dsArquivo);

                $incluirSinal = ($item['incluir_sinal'] == '1') ? '<a onclick="" class="btn construcao label label-success">Sim</a>' : '<a onclick="" class="btn construcao label label-danger">No</a>';
                $lista[] = array(
                    'idDimob' => '<div align="center">'.$item['id_dimob'].'</div>',
                    'nmEmpreendimento' => utf8_encode($item['nm_empreendimento']),
                    'dtGeracao' => '<div hidden>'.$item['dt_geracao'].'</div><div align="center">'.Helper::getDate($item['dt_geracao']).'</div>',
                    'anoContrato' => '<div align="center">'.$item['ano_contrato'].'</div>',
                    'anoRecebimento' => '<div align="center">'.$item['ano_recebimento'].'</div>',
                    'sinal' => '<div align="center">'. utf8_encode($incluirSinal).'</div>',
                    'dsArquivo' => utf8_encode($dsArquivo),
                    'acoes' => '<div align="center">' .utf8_encode($acoes). '</div>'
                );
            }

            echo json_encode(array(
                'draw' => $_POST['draw'],
                'recordsTotal' => count($totalItens),
                'recordsFiltered' => count($totalItens),
                'data' => $lista
            ));
        } else {
            $this->display('listar');
        }
    }

    public function gerarAction()
    {
        $this->set('listaEmpreendimentos', (new Empreendimento)->getEmpreendimentos(true));
        $this->set('listaRespJuridicos', (new EmpreendimentoContabeis())->getRespJuridicos());

        if ($this->_isPost) {

            if ($_POST['tipoGeracao'] == 'E') {
                $postEmpreendimento = explode('_', $_POST['empreendimento']);
                $empreendimento = $postEmpreendimento[0];
                $idRespJuridico = $postEmpreendimento[1];

                //Consulta para trazer o tipo do loteamento
                $empreendimentoInfo = Zend_Db_Table::getDefaultAdapter()->select()
                    ->from(array('em' => TB_EMPREENDIMENTO), array('id_tipo_loteamento', 'ds_path_logo'))
                    ->join(array('t' => TB_TIPO_LOTEAMENTO), 'em.id_tipo_loteamento = t.id_tipo_loteamento', array('*'))
                    ->where('em.id = '.$empreendimento)
                    ->query()->fetch();
                $this->set('empreendimentoInfo', $empreendimentoInfo);
            } else {
                $idRespJuridico = $_POST['idRespJuridico'];

                $listaEmpreendimento = Zend_Db_Table::getDefaultAdapter()->select()
                    ->from(array('ec' => TB_EMPREENDIMENTO_CONTABEIS), array('id_empreendimento'))
                    ->where('id_pessoa_juridica = ' . $idRespJuridico)
                    ->query()->fetchAll();

                foreach ($listaEmpreendimento as $emp) {
                    $empreendimento[] = $emp['id_empreendimento'];
                }

                $empreendimento = implode('","', $empreendimento);
            }

            $data = ($_POST['filtroData'] == 'dp')?'dt_pagamento':'dt_credito';

            $contratos = $this->tb_empreendimento->getAdapter()->select()
                ->from(array('l' => TB_LOTES), array('lote', 'quadra'))
                ->join(array('c' => TB_CONTRATO), 'l.id = c.id_lote', array('id_contrato' => 'id', 'nr_parcela',
                    'vl_parcela', 'nr_parcela_sinal', 'vl_sinal', 'nr_intercalada', 'vl_intercalada',
                    'nr_parcela_entrega', 'vl_parcela_entrega', 'dt_contrato', 'inclui_sinal_contrato', 'fl_distrato', 'fl_itens_contrato', 'porcentagem_participacao_contrato'))
                ->join(array('pe' => TB_PESSOA), 'pe.id = c.id_pessoa', array('idPessoa' => 'id', 'nm_pessoa', 'tp_pessoa'))
                ->joinLeft(array('pf' => TB_PESSOA_FISICA), 'pe.id = pf.id_pessoa', array('nr_cpf'))
                ->joinLeft(array('pj' => TB_PESSOA_JURIDICA), 'pe.id = pj.id_pessoa', array('nr_cnpj'))
                ->joinLeft(array('p' => TB_PARCELA), 'p.id_contrato = c.id', array('tp_baixa','vlTotalPagoParcela' => 'vl_total_pago','tp_parcela', 'pago', 'dt_pagamento', 'dt_credito'))
                ->joinLeft(array('ph' => TB_PARCELA_HISTORICO), 'ph.id_contrato = c.id', array('tp_baixa','vlTotalPagoParcelaHistorico' => 'vl_total_pago','tp_parcela', 'pago', 'dt_pagamento', 'dt_credito'))
                ->join(array('e' => TB_EMPREENDIMENTO), 'e.id = l.id_empreendimento', array('nm_empreendimento','idEmpreendimento'=>'id', 'nr_cep'))
                ->joinLeft(['sc' => TB_CIDADE], 'e.cd_cidade = sc.id', ['cdIbge' => 'sc.cd_ibge', 'ufIbge' => 'sc.uf']);
                
            if ($idRespJuridico) {
                $contratos->joinLeft(array('ec' => TB_EMPREENDIMENTO_CONTABEIS), 'ec.id_empreendimento = e.id', array('vl_porc_declarada'))
                    ->where('id_pessoa_juridica = '.$idRespJuridico);
            }

            if ($_POST['tipoGeracao'] == 'E') {
                $contratos = $contratos->where('e.id = ' . $empreendimento)
                    ->where("p.tp_parcela != 'A' or ph.tp_parcela != 'A'");
            } else {
                $contratos = $contratos->where('e.id IN (' . '"'.$empreendimento.'")')
                    ->where("p.tp_parcela != 'A' or ph.tp_parcela != 'A'");
            }

            if ($_POST['pagamento'] == 'nao') {

                if ($_POST['anoContrato']) {
                    $contratos->where("p.pago = '1' or ph.pago = '1'")
                        ->where("YEAR(c.dt_contrato) = '{$_POST['anoContrato']}'")
                        ->where("YEAR(p.".$data.") = {$_POST['anoRecebimento']} or YEAR(ph.".$data.") = {$_POST['anoRecebimento']}");
                } else {
                    $contratos->where("p.pago = '1' or ph.pago = '1'")
                        ->where("YEAR(p.".$data.") = {$_POST['anoRecebimento']} or YEAR(ph.".$data.") = {$_POST['anoRecebimento']}");
                }
            } else {

                if ($_POST['anoContrato']) {
                    $contratos->where("YEAR(c.dt_contrato) = '{$_POST['anoContrato']}'")
                        ->where("YEAR(p.".$data.") = '{$_POST['anoRecebimento']}' or p.dt_pagamento is null or p.dt_credito is null or
                                      YEAR(ph.".$data.") = '{$_POST['anoRecebimento']}' or ph.dt_pagamento is null or ph.dt_credito is null");
                } else {
                    $contratos->where("YEAR(p.".$data.") = '{$_POST['anoRecebimento']}' or p.dt_pagamento is null or p.dt_credito is null or
                                            YEAR(ph.".$data.") = '{$_POST['anoRecebimento']}' or ph.dt_pagamento is null or ph.dt_credito is null");
                }
            }

            if ($_POST['outros'] == '0') {
                $contratos->where("p.tp_baixa = 'T' or p.tp_baixa = 'B' or p.tp_baixa is null or
                                        ph.tp_baixa = 'T' or ph.tp_baixa = 'B' or ph.tp_baixa is null")
                    ->group("c.id");
            } else {
                $contratos->where("p.tp_baixa = 'T' or p.tp_baixa = 'B' or p.tp_baixa = 'O' or p.tp_baixa is null or
                                        ph.tp_baixa = 'T' or ph.tp_baixa = 'B' or ph.tp_baixa = 'O' or ph.tp_baixa is null")
                    ->group("c.id");
            }

            if($_POST['incluirSinal'] == '0'){
                $contratos->where("p.tp_parcela != 'S' or ph.tp_parcela != 'S'");
            } 

            $contratos = $contratos->query()->fetchAll();

            //Verifica se tem registros, caso no tenha nem chama o relatrio.
            if (count($contratos) == 0) {
                $this->_helper->addMensagem('danger', 'Informaes no encontradas!');
                $this->display('gerar');
                exit;
            }
            //Verifica o checkbox de outros para excluir ou no o tipo de baixa
            $tpBaixas = "O";
            if ($_POST['outros'] == '1') {
                $tpBaixas = null;
            }

            $aux = array();
            $i = 0;

            //Cria uma lista dos contratos que possuem outros compradores
            foreach ($contratos as $contrato)
            {
                if ($contrato['porcentagem_participacao_contrato'] != null && $contrato['porcentagem_participacao_contrato'] < 100)
                {
                    $listaOutrosCompradores[] = $contrato['id_contrato'];
                }
            }

            //Busca lista de outros compradores
            // $outrosCompradores = (new Contrato)->buscaOutrosCompradoresDimob($listaOutrosCompradores, $idRespJuridico, $empreendimento, $_POST['tipoGeracao'], $_POST['pagamento'], $_POST['anoContrato'], $_POST['anoRecebimento'], $_POST['outros'], $data);
            $outrosCompradores = (new Contrato)->buscaOutrosCompradoresDimobNovo($listaOutrosCompradores, $idRespJuridico);
            
            $contratos = array_merge($contratos, $outrosCompradores);
            
            $tbEmpreendimento = new Empreendimento;
            $adapter = $tbEmpreendimento->getAdapter();
            foreach ($contratos as $key => $contrato) {

                $aux[$i]['lote'] = $contrato['lote'];
                $aux[$i]['idEmpreendimento'] = $contrato['idEmpreendimento'];
                $aux[$i]['nm_empreendimento'] = $contrato['nm_empreendimento'];
                $aux[$i]['nr_cep'] = $contrato['nr_cep'];
                $aux[$i]['quadra'] = $contrato['quadra'];
                $aux[$i]['cliente'] = $contrato['nm_pessoa'];
                $aux[$i]['idPessoa'] = $contrato['idPessoa'];
                $aux[$i]['contrato'] = $contrato['id_contrato'];
                $aux[$i]['cdIbge'] = $contrato['cdIbge'];
                $aux[$i]['ufIbge'] = $contrato['ufIbge'];
                $aux[$i]['vl_total_pago'] = ($contrato['vlTotalPagoParcela'] != null) ? $contrato['vlTotalPagoParcela'] : $contrato['vlTotalPagoParcelaHistorico'];

                $dt = explode('-', $contrato['dt_contrato']);
                $dataContrato = $dt[2] . '/' . $dt[1] . '/' . $dt[0];
                $aux[$i]['dt_contrato'] = $dataContrato;
                $aux[$i]['nrCpf_nrCnpj'] = ($contrato['tp_pessoa'] == 'F') ? $contrato['nr_cpf'] : $contrato['nr_cnpj'];

                //valor da operao
                $aux[$i]['vlVenda'] = ($contrato['vl_parcela'] * $contrato['nr_parcela']) + ($contrato['vl_intercalada'] * $contrato['nr_intercalada']) + 
                                        ($contrato['vl_parcela_entrega'] * $contrato['nr_parcela_entrega']);

                //verifica a porcentagem de cada comprador do contrato, caso o mesmo tenha mais de um comprador
                if ($contrato['porcentagem_participacao_contrato'] != null && $contrato['porcentagem_participacao_contrato'] < 100)
                {
                    $aux[$i]['vlVenda'] = ($aux[$i]['vlVenda'] / 100) * (float)$contrato['porcentagem_participacao_contrato'];
                }

                if ($contrato['inclui_sinal_contrato'] == '1') {
                    
                    if ($contrato['porcentagem_participacao_contrato'] != null && $contrato['porcentagem_participacao_contrato'] < 100) {
                        $sinal = $contrato['vl_sinal'] / (count(ContratoPessoa::findByContrato($contrato['id_contrato'])) + 1);
                        $aux[$i]['vlVenda'] += $sinal;
                        $aux[$i]['vlVendas'] += $sinal;
                    } else {
                        $aux[$i]['vlVenda'] += $contrato['vl_sinal'];
                        $aux[$i]['vlVendas'] += $contrato['vl_sinal'];
                    }
                }
                //Busca os valores dos itens adicionais se existirem
                if ($contrato['fl_itens_contrato'] == '1') {
                    $itensContrato = ContratoItens::findByContrato($contrato['id_contrato']);

                    if (count($itensContrato) > 0) {
                        foreach ($itensContrato as $item) {
                            $aux[$i]['vlVenda'] += $item['vl_parcela'] * $item['qt_parcelas'];
                        }
                    }
                }
                
                if ($_POST['gerarRelatorio'] == '0' || ($_POST['gerarRelatorio'] == '1' && $_POST['checkPorcRelatorio'] == 1)) {
                    //Multiplica o valor total pago pela porcentagem declarada em Dados Contabeis para este empreendimento
                    if ($contrato['vl_porc_declarada'] > 0 && $contrato['vl_porc_declarada'] < 100) {
                        $aux[$i]['vl_total_pago'] = $aux[$i]['vl_total_pago']*($contrato['vl_porc_declarada']/100);
                        $aux[$i]['vlVenda'] = $aux[$i]['vl_total_pago'];
                    }
                }
                if($contrato['inclui_sinal_contrato'] == '0' || $_POST['incluirSinal'] == '0'){
                    $parcSinal = "S";
                }else{
                    $parcSinal = null;
                }

                if ($contrato['fl_distrato'] != '1') {
                    $parciais = $adapter->select()
                        ->from(TB_PARCELA, array(
                            'valorParcela' => 'SUM(vl_parcela)',
                            'valorJuros' => 'SUM(vl_juros)',
                            'valorMulta' => 'SUM(vl_multa)',
                            'valorTotal' => 'SUM(vl_total_pago)',
                            'desconto' => 'SUM(desconto)',
                            'acrescimo' => 'SUM(acrescimo)',
                            'dt_pagamento' => 'YEAR(dt_pagamento)',
                            'dt_credito' => 'YEAR(dt_credito)'
                        ))
                        ->where("id_contrato = '{$contrato['id_contrato']}'")
                        ->where('tp_baixa != "'.$tpBaixas.'"')
                        ->where("tp_parcela != 'A'")
                        ->where('tp_parcela != "'. $parcSinal . '"');

                    if ($_POST['pagamento'] == 'nao') {
                        $parciais->where("pago = '1'")
                            ->where("YEAR(".$data.") = '{$_POST['anoRecebimento']}' or dt_pagamento is null or dt_credito is null");
                    } else {
                        $parciais->where("YEAR(".$data.") = '{$_POST['anoRecebimento']}' or dt_pagamento is null or dt_credito is null");
                    }

                    $parciais = $parciais->query()->fetch();

                } else {
                    $parciais = $adapter->select()
                        ->from(TB_PARCELA_HISTORICO, array(
                            'valorParcela' => 'SUM(vl_parcela)',
                            'valorJuros' => 'SUM(vl_juros)',
                            'valorMulta' => 'SUM(vl_multa)',
                            'valorTotal' => 'SUM(vl_total_pago)',
                            'desconto' => 'SUM(desconto)',
                            'acrescimo' => 'SUM(acrescimo)',
                            'dt_pagamento' => 'YEAR(dt_pagamento)',
                            'dt_credito' => 'YEAR(dt_credito)'
                        ))
                        ->where("id_contrato = '{$contrato['id_contrato']}'")
                        ->where('tp_baixa != "'.$tpBaixas.'"')
                        ->where("tp_parcela != 'A'")
                        ->where('tp_parcela != "'. $parcSinal . '"');

                    if ($_POST['pagamento'] == 'nao') {
                        $parciais->where("pago = '1'")
                            ->where("YEAR(".$data.") = '{$_POST['anoRecebimento']}' or dt_pagamento is null or dt_credito is null");
                    } else {
                        $parciais->where("YEAR(".$data.") = '{$_POST['anoRecebimento']}' or dt_pagamento is null or dt_credito is null");
                    }

                    $parciais = $parciais->query()->fetch();
                }

                $aux[$i]['vl_total_pago'] = $parciais['valorTotal'] ? $parciais['valorTotal'] : 0;

                //soma do valor total das parcelas pagas por ano
                if ($parciais['dt_pagamento'] == $_POST['anoRecebimento'] || $parciais['dt_credito'] == $_POST['anoRecebimento']) {
                    $aux[$i]['vl_total_pago_por_ano'] = $parciais['valorParcela'] + $parciais['valorJuros'] + $parciais['valorMulta'] + $parciais['acrescimo'] - $parciais['desconto'];
                }

                //verifica a porcentagem de cada comprador do contrato, caso o mesmo tenha mais de um comprador
                if ($contrato['porcentagem_participacao_contrato'] != null && $contrato['porcentagem_participacao_contrato'] < 100) {
                    $aux[$i]['vl_total_pago_por_ano'] = ($aux[$i]['vl_total_pago_por_ano'] / 100) * $contrato['porcentagem_participacao_contrato'];
                }

                if ($_POST['gerarRelatorio'] == '0' || ($_POST['gerarRelatorio'] == '1' && $_POST['checkPorcRelatorio'] == 1)) {
                    //Multiplica o valor total pago pela porcentagem declarada em Dados Contbeis para este empreendimento
                    if ($contrato['vl_porc_declarada'] > 0 && $contrato['vl_porc_declarada'] < 100) {
                        $aux[$i]['vl_total_pago'] = $aux[$i]['vl_total_pago'] * ($contrato['vl_porc_declarada'] / 100);
                    }
                }
                
                //verifica a porcentagem de cada comprador do contrato, caso o mesmo tenha mais de um comprador
                if ($contrato['porcentagem_participacao_contrato'] != null && $contrato['porcentagem_participacao_contrato'] < 100) {
                    $aux[$i]['vl_total_pago'] = ($aux[$i]['vl_total_pago'] / 100) * $contrato['porcentagem_participacao_contrato'];
                }

                $parciais['valorParcela'] = ($parciais['valorParcela'] != null) ? $parciais['valorParcela'] : 0;
                $parciais['valorJuros'] = ($parciais['valorJuros'] != null) ? $parciais['valorJuros'] : 0;
                $parciais['valorMulta'] = ($parciais['valorMulta'] != null) ? $parciais['valorMulta'] : 0;
                $parciais['valorTotal'] = ($parciais['valorTotal'] != null) ? $parciais['valorTotal'] : 0;
                $parciais['desconto'] = ($parciais['desconto'] != null) ? $parciais['desconto'] : 0;
                $parciais['acrescimo'] = ($parciais['acrescimo'] != null) ? $parciais['acrescimo'] : 0;

                $aux[$i]['vlParcelas'] = $parciais['valorParcela'] - $parciais['desconto'] + $parciais['acrescimo'];

                if ($contrato['porcentagem_participacao_contrato'] != null && $contrato['porcentagem_participacao_contrato'] < 100) {
                    $aux[$i]['vlParcelas'] = ($aux[$i]['vlParcelas'] / 100) * $contrato['porcentagem_participacao_contrato'];
                }

                $aux[$i]['vlJuros'] = $parciais['valorJuros'];
                $aux[$i]['vlMulta'] = $parciais['valorMulta'];
                $aux[$i]['vlPago'] = $parciais['valorTotal'];
                $aux[$i]['desconto'] = $parciais['desconto'];
                $aux[$i]['acrescimo'] = $parciais['acrescimo'];

                //caso o contrato seja distrato e o valor total pago seja zera, o mesmo  removido da lista de contratos,
                //pois um contrato distratado e com valor total pago = 0, no deve aparecer no relatrio.
                if ($aux[$i]['vlPago'] == 0 && $contrato['fl_distrato'] == '1')
                    unset($aux[$key]);

                $i++;
            }

            //remove as parcelas zeradas da lista caso o usurio selecione opo de no exibir as parcelas zeradas.
            if ($_POST['pagamento'] == 'nao') {
                foreach ($aux as $key => $value) {
                    if ($value['vlPago'] == 0)
                        unset($aux[$key]);
                }
            }
            //Ordena array por Empreendimento, quadra e lote
            function cmp($a, $b)
            {
                if ($_POST['ordena'] == 'Q')
                    return strcmp($a['nm_empreendimento'].$a['quadra'].$a['lote'], $b['nm_empreendimento'].$b['quadra'].$b['lote']);
                else if ($_POST['ordena'] == 'C')
                    return strcmp($a['dt_contrato'], $b['dt_contrato']);
                else
                    return strcmp($a['cliente'], $b['cliente']);
            }

            usort($aux, 'cmp');

            if ($_POST['gerarRelatorio'] == '1') {
                $clienteAcade = (new Db_Cliente())->fetchRow()->toArray();
                $this->set('clienteAcade', $clienteAcade);
                $this->set('filtros', array('empreendimento' => $aux[0]['nm_empreendimento'],
                    'anoContrato' => $_POST['anoContrato'],
                    'anoRecebimento' => $_POST['anoRecebimento'],
                    'sinal' => $_POST['incluirSinal'],
                    'outros' => $_POST['outros'],
                    'filtroData' => $_POST['filtroData'],
                    'checkExibirPorc' => $_POST['checkPorcRelatorio']
                ));

                $this->set('cliente', $aux);
                $this->display('relatorioDimob');
                $this->displayMPDF('dimob' . date('d/m/Y') . '.pdf', true, 'L', 'A4', array(1, 1, 1, 1));
            } else {
                //Info do empreendimento para DIMOB
                $infoEmpreendimento = Zend_Db_Table::getDefaultAdapter()->select()
                    ->from(array('e' => TB_EMPREENDIMENTO), array('nm_empreendimento'))
                    ->joinLeft(array('pa' => TB_PARCERIA), 'e.id = pa.id_empreendimento', '')
                    ->joinLeft(array('p' => TB_PESSOA), 'p.id = pa.id_pessoa', array('nomeEmpresarial' => 'nm_pessoa',
                        'enderecoContribuinte' => 'endereco', 'bairroContribuinte' => 'nm_bairro',
                        'endNumeroContribuinte' => 'nr_endereco', 'complementoContribuinte' => 'ds_complemento'))
                    ->joinLeft(array('pj' => TB_PESSOA_JURIDICA), 'p.id = pj.id_pessoa', array('nrCnpjPessoaJuridica' => 'nr_cnpj'))
                    ->joinLeft(array('ec' => TB_EMPREENDIMENTO_CONTABEIS), 'ec.id_empreendimento = e.id', '')
                    ->joinLeft(array('pRFB' => TB_PESSOA_FISICA), 'ec.id_pessoa_fisica_RFB = pRFB.id_pessoa', array('cpfPessoaResponsavelRFB' => 'nr_cpf'))
                    ->joinLeft(array('r' => TB_REPRESENTANTE), 'pj.id_pessoa = r.id_pessoa_juridica', '')
                    ->joinLeft(array('pfcontador' => TB_PESSOA_FISICA), 'pfcontador.id_pessoa = r.id_pessoa OR pfcontador.id_pessoa = p.id', array(
                        'cpfContador' => 'nr_cpf'
                    ))
                    ->joinLeft(array('sc' => TB_CIDADE), 'e.cd_cidade = sc.id', array('cd_ibge as codMunicipio', 'uf as ufEmpreendimento'))
                    ->joinLeft(['sc2' => TB_CIDADE], 'p.cd_cidade = sc2.id', ['cdIbgePJ' => 'sc2.cd_ibge', 'ufIbgePJ' => 'sc2.uf']);

                    if ($_POST['tipoGeracao'] == 'E')
                    {
                       $infoEmpreendimento = $infoEmpreendimento->where('e.id = ' . $empreendimento);
                    } elseif ($_POST['tipoGeracao'] == 'P') {
                        $infoEmpreendimento = $infoEmpreendimento->where('ec.id_pessoa_juridica = ' . $idRespJuridico);
                    }

                    $infoEmpreendimento = $infoEmpreendimento->query()->fetchAll();

                $dados = array(
                    'listaParcelas' => $aux,
                    'post' => $_POST,
                    'infoEmpreendimento' => $infoEmpreendimento
                );

                //entra em gerarDimob(), monta o arquivo e gera as pastas e o arquivo .txt
                $arquivo = (new ArquivoDimob())->gerarDimob($dados);

                //Verifica se houver algum erro
                if ($arquivo['erro']) {
                    $this->redir(array('modulo' => 'contabil', 'controller' => 'arquivoDimob', 'action' => 'gerar'), array('exception' => $arquivo['msgErro']));
                } else {
                    try {
                        $db = Zend_Db_Table::getDefaultAdapter();
                        $db->beginTransaction();
                        //Salvando DIMOB
                        $arquivoDimob = (new ArquivoDimob())->createRow();

                        if ($_POST['tipoGeracao'] == 'E') {
                            $arquivoDimob->id_empreendimento = $empreendimento;
                        }

                        $arquivoDimob->dt_geracao = date('Y-m-d');
                        $arquivoDimob->ano_contrato = $_POST['anoContrato'] ? $_POST['anoContrato'] : null;
                        $arquivoDimob->ano_recebimento = $_POST['anoRecebimento'];
                        $arquivoDimob->incluir_sinal = $_POST['incluirSinal'];
                        $arquivoDimob->ds_arquivo = $arquivo['path'];
                        $arquivoDimob->ds_log = (Login::getUsuario()->getLogin() . ' - ' .date('d/m/Y H:i:s') . ' - i');
                        $idDimob = $arquivoDimob->save();
                        
                        //Salvando os itens no DIMOB
                        foreach ($aux as $cont) {
                            $arquivoDimobItens = (new ArquivoDimobItens())->createRow();
                            $arquivoDimobItens->id_dimob = $idDimob;
                            $arquivoDimobItens->id_contrato = $cont['contrato'];
                            $arquivoDimobItens->id_pessoa = $cont['idPessoa'];
                            $arquivoDimobItens->id_empreendimento = $cont['idEmpreendimento'];
                            $arquivoDimobItens->vl_total_pago = $cont['vl_total_pago'];
                            $arquivoDimobItens->ds_log = (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:i:s') . ' - i');
                            $arquivoDimobItens->save();
                        }
                        
                        $db->commit();
                        $this->redir(array('modulo' => 'contabil', 'controller' => 'arquivoDimob', 'action' => 'listar'), array('msg' => 'success'));
                    } catch (Exception $e) {
                        $db->rollBack();
                        $this->redir(array('modulo' => 'contabil', 'controller' => 'arquivoDimob', 'action' => 'gerar'), array('exception' => $e->getMessage()));
                    }
                }
            }
        }

        $this->display();
    }

    public function gerarPdfAction()
    {
        $cliente = (new Db_Cliente())->fetchRow()->toArray();

        $listaDimobItens = Zend_Db_Table::getDefaultAdapter()->select()
            ->from(array('di' => TB_DIMOB_ITENS), '*')
            ->join(array('d' => TB_DIMOB),'d.id_dimob = di.id_dimob', '*')
            ->joinLeft(array('e' => TB_EMPREENDIMENTO), 'e.id = d.id_empreendimento', array('nmEmpSped'=>'nm_empreendimento', 'idEmpreendimento'=>'id'))
            ->joinLeft(array('edi' => TB_EMPREENDIMENTO), 'edi.id = di.id_empreendimento', array('nmEmpSpedItens'=>'nm_empreendimento', 'idEmpSpedItens'=>'id'))
            ->join(array('c' => TB_CONTRATO), 'c.id = di.id_contrato', null)
            ->join(array('l' => TB_LOTES), 'l.id = c.id_lote', array('quadra','lote'))
            ->joinLeft(array('p' => TB_PESSOA), 'p.id = di.id_pessoa', array('nm_pessoa'))
            ->where('di.id_dimob = ' . $_GET['id'])
            ->order('e.nm_empreendimento')
            ->order('edi.nm_empreendimento')
            ->order('l.quadra')
            ->order('l.lote')
            ->query()->fetchAll();

        $this->set('listaDimobItens', $listaDimobItens);
        $this->set('infoCliente', $cliente);

        $empreendimentoInfo = [];

        if ($listaDimobItens[0]['idEmpreendimento']) {
            //Consulta para trazer o Tipo do Loteamento
            $empreendimentoInfo = Zend_Db_Table::getDefaultAdapter()->select()
                ->from(array('em' => TB_EMPREENDIMENTO), array('id_tipo_loteamento','ds_path_logo'))
                ->join(array('t' => TB_TIPO_LOTEAMENTO), 'em.id_tipo_loteamento = t.id_tipo_loteamento', array('*'))
                ->where('em.id = '.$listaDimobItens[0]['idEmpreendimento'])
                ->query()->fetch();
        }
        $this->set('empreendimentoInfo', $empreendimentoInfo);

        $this->display('gerarPdf');
        $this->displayMPDF('dimob_'.$_GET['id'].'_'.date('d/m/y_His').'.pdf');
    }

    public function validarAction()
    {
        $campos = array("anoRecebimento" => "A Data de Recebimento  obrigatria");
        foreach ($campos as $campo => $msg) {
            if ($_POST[$campo] == '') {
                $this->_helper->addMensagem('danger', $msg);
            }
        }

        $postEmpreendimento = explode('_', $_POST['empreendimento']);
        $idEmpreendimento = $postEmpreendimento[0];

        if ($_POST['tipoGeracao'] == 'E' && !$idEmpreendimento) {
            $this->_helper->addMensagem("danger", "O Empreendimento  obrigatrio");
        }

        if ($_POST['tipoGeracao'] == 'P' && !$_POST['idRespJuridico']) {
            $this->_helper->addMensagem("danger", "O Responsvel jurdico  obrigatrio");
        }

        //Verifica se tem registros.
        if ($this->_isPost && count($this->_helper->getMensagens()) == 0) {
            $idEmpreendimento = $_POST['empreendimento'];

            if ($idEmpreendimento) {
                $empreendimento = explode('_', $idEmpreendimento);
                $idRespJuridico = $empreendimento[1];
            } else {
                $listaEmpreendimento = Zend_Db_Table::getDefaultAdapter()->select()
                    ->from(array('ec' => TB_EMPREENDIMENTO_CONTABEIS), array('id_empreendimento'))
                    ->where('id_pessoa_juridica = ' . $_POST['idRespJuridico'])
                    ->query()->fetchAll();

                $empreendimento = [];

                foreach ($listaEmpreendimento as $emp) {
                    $empreendimento[] = $emp['id_empreendimento'];
                }

                $empreendimento = implode('","', $empreendimento);
                $idRespJuridico = $_POST['idRespJuridico'];
            }

            $data = ($_POST['filtroData'] == 'dp')?'dt_pagamento':'dt_credito';

            $contratos = $this->tb_empreendimento->getAdapter()->select()
                ->from(array('l' => TB_LOTES), array('lote', 'quadra'))
                ->join(array('c' => TB_CONTRATO), 'l.id = c.id_lote', array('id_contrato' => 'id', 'nr_parcela',
                    'vl_parcela', 'nr_parcela_sinal', 'vl_sinal', 'nr_intercalada', 'vl_intercalada',
                    'nr_parcela_entrega', 'vl_parcela_entrega', 'dt_contrato', 'inclui_sinal_contrato', 'fl_distrato', 'fl_itens_contrato'))
                ->join(array('pe' => TB_PESSOA), 'pe.id = c.id_pessoa', array('nm_pessoa'))
                ->joinLeft(array('pf' => TB_PESSOA_FISICA), 'pe.id = pf.id_pessoa', array('nr_cpf'))
                ->joinLeft(array('pj' => TB_PESSOA_JURIDICA), 'pe.id = pj.id_pessoa', array('nr_cnpj'))
                ->joinLeft(array('p' => TB_PARCELA), 'p.id_contrato = c.id', array('tp_baixa','vl_total_pago','tp_parcela', 'pago', 'dt_pagamento', 'dt_credito'))
                ->joinLeft(array('ph' => TB_PARCELA_HISTORICO), 'ph.id_contrato = c.id', array('tp_baixa','vl_total_pago','tp_parcela', 'pago', 'dt_pagamento', 'dt_credito'))
                ->join(array('e' => TB_EMPREENDIMENTO), 'e.id = l.id_empreendimento', array('nm_empreendimento','idEmpreendimento'=>'id', 'nr_cep'));
            if ($idRespJuridico) {
                $contratos->joinLeft(array('ec' => TB_EMPREENDIMENTO_CONTABEIS), 'ec.id_empreendimento = e.id', array('vl_porc_declarada'))
                    ->where('id_pessoa_juridica = '.$idRespJuridico);
            }
            
            if ($idEmpreendimento)
            {
                $contratos = $contratos->where('e.id = ' . $empreendimento[0])
                    ->where("p.tp_parcela != 'A' or ph.tp_parcela != 'A'");
            } else {
                $contratos = $contratos->where('e.id IN ("' . $empreendimento . '")')
                    ->where("p.tp_parcela != 'A' or ph.tp_parcela != 'A'");
            }

            if ($_POST['pagamento'] == 'nao') {

                if ($_POST['anoContrato']) {
                    $contratos->where("p.pago = '1' or ph.pago = '1'")
                        ->where("YEAR(c.dt_contrato) = '{$_POST['anoContrato']}'")
                        ->where("YEAR(p.".$data.") = {$_POST['anoRecebimento']} or YEAR(ph.".$data.") = {$_POST['anoRecebimento']}");
                } else {
                    $contratos->where("p.pago = '1' or ph.pago = '1'")
                        ->where("YEAR(p.".$data.") = {$_POST['anoRecebimento']} or YEAR(ph.".$data.") = {$_POST['anoRecebimento']}");
                }
            } else {

                if ($_POST['anoContrato']) {
                    $contratos->where("YEAR(c.dt_contrato) = '{$_POST['anoContrato']}'")
                        ->where("YEAR(p.".$data.") = '{$_POST['anoRecebimento']}' or p.dt_pagamento is null or p.dt_credito is null or
                                      YEAR(ph.".$data.") = '{$_POST['anoRecebimento']}' or ph.dt_pagamento is null or ph.dt_credito is null");
                } else {
                    $contratos->where("YEAR(p.".$data.") = '{$_POST['anoRecebimento']}' or p.dt_pagamento is null or p.dt_credito is null or
                                            YEAR(ph.".$data.") = '{$_POST['anoRecebimento']}' or ph.dt_pagamento is null or ph.dt_credito is null");
                }
            }

            if ($_POST['outros'] == '0') {
                $contratos->where("p.tp_baixa = 'T' or p.tp_baixa = 'B' or p.tp_baixa is null or
                                        ph.tp_baixa = 'T' or ph.tp_baixa = 'B' or ph.tp_baixa is null")
                    ->group("c.id");
            } else {
                $contratos->where("p.tp_baixa = 'T' or p.tp_baixa = 'B' or p.tp_baixa = 'O' or p.tp_baixa is null or
                                        ph.tp_baixa = 'T' or ph.tp_baixa = 'B' or ph.tp_baixa = 'O' or ph.tp_baixa is null")
                    ->group("c.id");
            }

            $contratos = $contratos->query()->fetchAll();

            if (!$contratos) {
                $msg = "Nenhum resultado foi encontrato";
                $this->_helper->addMensagem('danger', $msg);
            }
            $dadosContabeis = (new EmpreendimentoContabeis())->fetchRow('id_empreendimento IN (' . '"'.$empreendimento.'")');
            //verifica se o usurio tem Dados Contbeis
            if (!$dadosContabeis && $_POST['gerarArquivo'] == '0') {
                $msg = " preciso cadastrar os Dados Contabeis para poder gerar o Arquivo DIMOB";
                $this->_helper->addMensagem('danger', $msg);
            }
        }
        //Mensagem de Erros
        if (count($this->_helper->getMensagens()) > 0) {
            $msgErros = "";
            foreach ($this->_helper->getMensagens() as $msg => $a)
                $msgErros = utf8_encode($a);
            echo json_encode(array("msgErros" => $msgErros));
        } else {
            echo json_encode(true);
        }
    }

    public function visualizarAction()
    {
        header('Content-type: text/html; charset=UTF-8');
        $listDimobItens = Zend_Db_Table::getDefaultAdapter()->select()
            ->from(array('di' => TB_DIMOB_ITENS), array('*'))
            ->join(array('d' => TB_DIMOB), 'd.id_dimob = di.id_dimob', '*')
            ->joinLeft(array('e' => TB_EMPREENDIMENTO), 'e.id = d.id_empreendimento', array('nmEmpDimob' => 'nm_empreendimento'))
            ->joinLeft(array('eDi' => TB_EMPREENDIMENTO), 'eDi.id = di.id_empreendimento', array('nmEmpDimobItens' => 'nm_empreendimento'))
            ->join(array('c' => TB_CONTRATO), 'c.id = di.id_contrato', '')
            ->join(array('l' => TB_LOTES), 'l.id = c.id_lote', array('quadra', 'lote'))
            ->joinLeft(array('p' => TB_PESSOA), 'p.id = di.id_pessoa', array('nm_pessoa'))
            ->where('di.id_dimob = ' . $_POST['id'])
            ->order('e.nm_empreendimento')
            ->order('eDi.nm_empreendimento')
            ->order('l.quadra')
            ->order('l.lote')
            ->query()->fetchAll();

        $this->set('listaDimobItens', $listDimobItens);
        $this->display('visualizar');
    }
}