<?php require_once 'layout/includes/header.php'; ?>
<?php require_once 'layout/includes/menu.php'; ?>
<?php $valor = $this->get('valores'); ?>
<div class="content">
    <div class="page-heading">
        <?= $this->getHeader('', 'Agendamento'); ?>
    </div>

    <div class="widget">
        <div class="widget-content padding">
            <form onsubmit="return validar(event)" action="" method="POST">
                <fieldset>
                    <legend>
                        Informaes do Agendamento
                        <span style=" font-size: 10pt">(Campos com <span style=" color: red">*</span> so obrigatrios)</span>
                    </legend>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group col-sm-6">
                                <label class="control-label" for="empreendimento">
                                    Empreendimento: <span class="require" style="color: red">*</span>
                                </label>
                                <select name="id_empreendimento" id="empreendimento" class="form-controle select2" data-placeholder="Selecione o empreendimento" required disabled>
                                    <option value="<?= $valor['id_empreendimento'] ?>" selected>
                                        <?= $valor['nm_empreendimento'] ?>
                                    </option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group col-sm-6">
                                <label for="contrato" class="control-label">
                                    Contrato: <span class="require" style="color: red">*</span>
                                </label>
                                <select name="contrato" id="contrato" class="form-controle select2" data-placeholder="Selecione o contrato" required disabled>
                                    <option value=""></option>
                                    <option value="<?= $valor['id_contrato'] ?>" selected>
                                        <?= $valor['nm_pessoa'] . " - Quadra: {$valor['quadra']} - Lote: {$valor['lote']} - Contrato: {$valor['id_contrato']}" ?>
                                    </option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group col-sm-6">
                                <label class="control-label" for="setor">
                                    Setor: <span class="require" style="color: red">*</span>
                                </label>
                                <select name="setor" id="setor" class="form-controle select2" data-placeholder="Selecione o setor" disabled required>
                                    <option value="<?= $valor['setor'] ?>" selected>
                                        <?= $valor['setorDescricao'] ?>
                                    </option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group col-sm-3">
                                <label for="data" class="control-label">
                                    Data de agendamento:<span class="require" style="color: red">*</span>
                                </label>
                                <input type="text" class="form-control data datepicker-input" id="data" value="<?= Helper::dataParaBrasil($valor['dt_agendamento']) ?>" name="dataAgendamento" maxlength="10" autocomplete="off" required><br>
                            </div>
                        </div>
                    </div>
                    <input type="hidden" name="id" value="<?= $valor['id'] ?>">
                </fieldset>
                <fieldset>
                    <legend>Operaes</legend>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group col-sm-2">
                                <input type="submit" class="btn btn-primary col-sm-12 fDesabilitaBtn" value="Salvar">
                            </div>
                            <div class="form-group col-sm-2">
                                <a href="?m=comunicacao&c=agendamento&a=listar" class="btn btn-danger col-sm-12">Cancelar</a>
                            </div>
                        </div>
                    </div>
                </fieldset>
            </form>
        </div>
    </div>
</div>

<?php require_once 'layout/includes/footer.php'; ?>