<?php


class CadastroEmailController extends Controller
{
    private $tb_agrupada;
    private $tb_comunicacao_email;
    private $tb_comunicacao;
    private $tb_modelo;
    private $cliente;
    public function __construct($request)
    {
        parent::__construct($request);
        $this->tb_agrupada = new TabelaAgrupada();
        $this->tb_comunicacao = new Comunicacao();
        $this->tb_comunicacao_email = new ComunicacaoEmail();
        $this->tb_modelo = new Modelo();
        $tb_cliente = new Db_Cliente();
        $this->cliente = $tb_cliente->fetchRow();
        if($this->cliente->fl_comunicacao=='0'){
            header("Location: ?m=&c=admin&a=index");
        }
    }

    public function indexAction()
    {
        $this->redirect(['modulo' => 'comunicacao', 'controller' => 'cadastroEmail', 'action' => 'listar']);
    }

    public function listarAction()
    {
        $this->display('listar');
    }

    public function adicionarAction()
    {
        $dados = $this->tb_comunicacao_email->getLista();
        if ($this->_isPost) {
            if ($this->tb_comunicacao_email->adicionar($_POST['email'], $_POST['diasEnvio'], $_POST['setor'], $_POST['porta'], $_POST['host'], $_POST['senha'],$_POST['assunto'])) {
                $this->redir(array('modulo' => 'comunicacao', 'controller' => 'cadastroEmail', 'action' => 'listar'), array('msg' => 'success'));
            } else {
                $this->redir(array('modulo' => 'comunicacao', 'controller' => 'cadastroEmail', 'action' => 'listar'), array('msg' => 'fail', 'exception' => "No foi possvel adicionar"));
            }
        } else {
            $this->display('form');
        }
    }

    public function editarAction()
    {
        $dados = $this->tb_comunicacao_email->fetchRow("id = '{$_GET['id']}'")->toArray();

        if ($this->_isPost) {
            
            if ($this->tb_comunicacao_email->atualizar($_POST['id'], $_POST['email'], $_POST['diasEnvio'], $_POST['setor'], $_POST['porta'], $_POST['host'], $_POST['senha'],$_POST['assunto'])) {
                $this->redir(array('modulo' => 'comunicacao', 'controller' => 'cadastroEmail', 'action' => 'listar'), array('msg' => 'success'));
            } else {
                $this->redir(array('modulo' => 'comunicacao', 'controller' => 'cadastroEmail', 'action' => 'listar'), array('msg' => 'fail', 'exception' => "No foi possvel editar"));
            }
        } else {
            $this->set('valores', $dados);
            $this->display('form');
        }
    }

    public function deletarAction()
    {
        if ($dados = $this->tb_comunicacao_email->fetchRow("id = '{$_GET['id']}'")) {
            if ($this->tb_comunicacao_email->delete("id = '{$_GET['id']}'")) {
                $this->redir(array('modulo' => 'comunicacao', 'controller' => 'cadastroEmail', 'action' => 'listar'), array('msg' => 'success'));
            } else {
                $this->redir(array('modulo' => 'comunicacao', 'controller' => 'cadastroEmail', 'action' => 'listar'), array('msg' => 'fail', 'exception' => "No foi possvel deletar"));
            }
        } else {
            $this->redir(array('modulo' => 'comunicacao', 'controller' => 'cadastroEmail', 'action' => 'listar'), array('msg' => 'fail', 'exception' => "No foi possvel deletar"));
        }
    }

    public function getListaAction()
    {
        if ($this->isAjax()) {
            $data = [];
            $dados = $this->tb_comunicacao_email->getLista();

            foreach ($dados as $dado) {
                $data[] = [
                    'nome' => utf8_encode($dado['nome']),
                    'email' => utf8_encode($dado['email']),
                    'setor' => utf8_encode($dado['setor']),
                    'id' => $dado['id']
                ];
            }

            echo json_encode(['data' => $data]);
        }
    }
    public function getListaTudoAction(){
        echo json_encode($this->tb_comunicacao_email->getListaTudo());
    }
    public function getListaEmpreendimentoAction(){
        echo json_encode($this->tb_comunicacao_email->getListaEmpreendimento($_GET['id']));
    }
}