<?php
class AgendamentoController extends Controller
{
    private $tb_comunicacao_email;
    private $tb_comunicacao_modelo;
    private $tb_comunicacao;
    private $tb_parcela;
    private $tb_contrato;
    private $cliente;

    public function __construct($request)
    {
        parent::__construct($request);
        $this->tb_comunicacao = new Comunicacao();
        $this->tb_comunicacao_email = new ComunicacaoEmail();
        $this->tb_comunicacao_modelo = new ComunicacaoModelo();
        $this->tb_parcela = new Parcela();
        $this->tb_contrato = new Contrato();
        $tb_cliente = new Db_Cliente();
        $this->cliente = $tb_cliente->fetchRow();
        if($this->cliente->fl_comunicacao=='0'){
            if($_GET['a']=="cron"){
                echo "-";
                die;
            }
            header("Location: ?m=&c=admin&a=index");
        }
    }

    public function indexAction()
    {
        $this->redirect(['modulo' => 'comunicacao', 'controller' => 'agendamento', 'action' => 'listar']);
    }

    public function listarAction()
    {
        $this->display('listar');
    }

    public function getListaAction()
    {
        if ($this->isAjax()) {
            $data = []; 
            $dados = $this->tb_comunicacao->getLista($_GET['length'],$_GET['start'],$_GET['search']['value'],$_GET['tipo']);
            foreach ($dados['data'] as $dado) {
                $status = '';
                $dataAE = '';
                $enviado = "";
                if ($dado['enviado']) {
                    $status = 'Enviado';
                }
                elseif ($dado['statusAgendamento']==-1) { 
                    $status = 'Falha ao enviar';
                } else if ($dado['agendado']) {
                    $dado['enviado']="";
                    $status = 'Agendado';
                } elseif ($dado['statusAgendamento']==1) { 
                    $status = 'No Enviado';
                } 
                $tipo = "Cobrana";
                if($dado['id_parcela_contrato']){
                    $tipo = "Boleto";
                } 
                $data[] = [
                    'idContrato' => $dado['id_contrato'],
                    'nomeDestinatario' =>utf8_encode($dado['nomeDestinatario']),
                    'cliente' => utf8_encode($dado['emailDestinatario']),
                    'empreendimento' => utf8_encode($dado['nm_empreendimento']),
                    'id_parcela' => $dado['id_parcela']."/".utf8_encode($dado['tp_parcela']),
                    'dataEnviado' => ($dado['enviado']) ? Helper::dataParaBrasil($dado['enviado']) : '',
                    'dataAgendado' => ($dado['agendado']) ? Helper::dataParaBrasil($dado['agendado']) : '',
                    'statusAgendamento' => $dado['statusAgendamento'],
                    'tipo'=>utf8_encode($tipo),
                    'id' => $dado['id'],
                    'status' => array('id'=>$dado['id'],'status'=>utf8_encode($status))
                ];
                
            }

            echo json_encode(['data' => $data,'draw'=>$_GET['draw'],'recordsTotal'=>$dados['recordsTotal'],'recordsFiltered'=> $dados['recordsFiltered']]);
        }
    }

    public function editarAction()
    {
        $dados = $this->tb_comunicacao->getInfo($_GET['id']);
        if ($dados['status'] != 'A')
            $this->redir(array('modulo' => 'comunicacao', 'controller' => 'agendamento', 'action' => 'listar'), array('msg' => 'fail', 'exception' => "Apenas  possvel editar agendamentos com status Agendado"));

        if ($this->_isPost) {
            if ($this->tb_comunicacao->atualizar($_POST['id'],0,false,false, Helper::dataParaAmericano($_POST['dataAgendamento']))) {
                $dadosAtt = $this->tb_comunicacao->fetchRow("id = {$_GET['id']}");

                if ($dados['dt_agendamento'] != $dadosAtt->dt_agendamento) {
                    $dados['dt_agendamento'] = Helper::dataParaBrasil($dados['dt_agendamento']);
                    $dadosAtt->dt_agendamento = Helper::dataParaBrasil($dadosAtt->dt_agendamento);
                    (new Relacionamento())->saveContato(82, date('Y-m-d'), $dados['id_contrato'], "Log: Comunicao Agendamento Editada. Data de agendamento de {$dados['dt_agendamento']} para {$dadosAtt->dt_agendamento}");
                }
                $this->redir(array('modulo' => 'comunicacao', 'controller' => 'agendamento', 'action' => 'listar'), array('msg' => 'success'));
            } else {
                $this->redir(array('modulo' => 'comunicacao', 'controller' => 'agendamento', 'action' => 'listar'), array('msg' => 'fail', 'exception' => "No foi possvel editar"));
            }
        } else {
            $this->set('valores', $dados);
            $this->display('form');
        }
    }

    public function deletarAction()
    {
        if ($this->_isPost) {
            if ($dados = $this->tb_comunicacao->fetchRow("id = '{$_POST['id']}'")) {
                if ($dados['enviado']) {
                    $status = 'Enviado';
                } else if ($dados['agendado']) {
                    $status = 'Agendado';
                } else {
                    $status = 'No Enviado';
                }
                if ($this->tb_comunicacao->delete($_POST['id'])) {
                    $logParcela ="";
                    if ($dados->id_parcela_contrato) {
                        $logParcela = ", NumParcela: {$dados->id_parcela_contrato}";
                    }
                    $dados->agendado = Helper::dataParaBrasil($dados->agendado);
                    $dados->enviado = Helper::dataParaBrasil($dados->enviado);
                    (new Relacionamento())->saveContato(82, date('Y-m-d'), $dados->id_contrato, "Log: Comunicao Agendamento Deletada. Status: {$status}, Data Agendamento: {$dados->agendado}, Data envio: {$dados->enviado}, Log: {$logParcela}.");
                    unlink(getcwd().$dados->arquivoEmail);
                    echo 'Successo';
                } else {
                    echo "No foi possvel deletar";
                }
                
            } else {
                echo "No foi possvel deletar";
            }
        }
    }

    public function visualizarAction()
    {
        header("Content-type: text/html; charset=ISO-8859-1");
        $dados = $this->tb_comunicacao->getInfo($_POST['id']);
        $status = '';
        if ($dados['enviado']) {
            $status = 'Enviado';
        }  elseif ($dados['statusAgendamento']==-1) { 
            $status = 'Falha ao enviar';
        }else if ($dados['agendado']) {
            $status = 'Agendado';
        } else {
            $status = 'No Enviado';
        }
        $dados['status'] = $status;
        $primeiro_acesso =[2022,02,8];
        $dados['primeiro_acesso'] = $primeiro_acesso[1];
        $ultimo_acesso = [2022,02,8];
        $dados['ultimo_acesso'] = $ultimo_acesso[1];
        $this->set('dados', $dados);
        $this->display();
    }
    function getFileUTF8Action() { 
        //header("Content-type: text/html; charset=ISO-8859-1");
        $content = file_get_contents(getcwd().$_GET['url']); 
        
        if((strpos($_GET['url'], 'whatsapp') !== false) ){
            echo  str_replace("", 'meta http-equiv="Content-Type" content="text/html; charset=utf-8">', "<pre>".$content."</pre>");
        }
        /*echo mb_convert_encoding($content, 'ISO-8859-1', 
            mb_detect_encoding($content, 'UTF-8, ISO-8859-1', true)); */
        else{
            echo  str_replace("", 'meta http-equiv="Content-Type" content="text/html; charset=utf-8">', $content);
        }
   } 
    public function cronGeralAction(){
        $clientes = Controller::getAdapterAcadeGeral()->fetchAll("SELECT * FROM cliente");
        foreach($clientes as $cliente){
            
            $curl = curl_init();

            curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://'.$cliente["nm_dominio"].'.acadeone.com.br/acadelotear/?m=comunicacao&c=agendamento&a=cron',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            ));

            $response = curl_exec($curl);

            curl_close($curl);
            echo $cliente["nm_dominio"].":<br>".$response."<br><br>";
        }
    }

    public function cronAction(){
        $agendados = $this->tb_comunicacao->getPendentes();
        echo count($agendados);
        foreach($agendados as $email){
            echo "id ".$email['id'].": ";
            $this->emailAction($email['id']);
        }
    }

    public function whatsAppPendenteAction(){
        $agendados = $this->tb_comunicacao->getPendentes();
        $retorno = [];
        foreach($agendados as $key=>$agendado){
            $resultado =  $this->tb_comunicacao->getInfo($agendado['id']);
            if(!$resultado["email"]&&$resultado&&$resultado["statusAgendamento"]==0){
                $resultado['conteudo']=( file_get_contents(getcwd().$resultado["arquivoEmail"]));
                foreach($resultado as $keyResultado=>$valor){
                    $resultado[$keyResultado] = utf8_encode($valor);
                }
                $retorno[] =$resultado;
            }
        }
        echo json_encode($retorno);die;
    }
    public function checarParcelaAction(){
        echo $this->tb_comunicacao->verificaExistencia(null,$_GET['id_parcela_contrato']);
    }
    public function agendarParcelaAction(){
        $modelo = $this->tb_comunicacao_modelo->getInfo(1);
        $modeloWhatsapp = $this->tb_comunicacao_modelo->getInfo(3);
        $config_email = $this->tb_comunicacao_email->getById(1);
        $config_whatsapp = $this->tb_comunicacao_email->getById(3);
        $segundaVia = false;
        if(isset($_POST['segundaVia'])){
            $segundaVia = true;
        }
        $nmDominio = "";
        $url = explode('.', $_SERVER['HTTP_HOST']);
        if ($url[0] == 'www') {
            $nmDominio = $url[1];
        } else {
            $nmDominio = $url[0];
        }
        $id_parcela_contrato = $_POST['id_parcela'];
        $parcela = $this->tb_parcela->getParcelasById($id_parcela_contrato);
        $contrato = $this->tb_contrato->findContratoById($parcela[0]['id_contrato'],null,false,true);

        $cnpj = (new Helper)->cnpjMask(preg_replace('/[^0-9]/', '', $this->cliente->nr_cnpj));
        $telefone = "(".$this->cliente->nr_uf_telefone.") ".$this->cliente->nr_telefone;
        if($contrato['telefoneContato']){
            $telefone = $contrato['telefoneContato'];
        }
        if(count($parcela)){
            $parcela[0]['idContrato']=$parcela[0]['id_contrato'];
            $banco = false;
            if($parcela[0]['id_banco_boleto']){
                //Banco multi
                $banco = new Banco();
                $banco = $banco->getAdapter()->select()
                    ->from(array('b' => TB_BANCO), array('id_banco' => 'id', 'cd_banco','multa','juros','msg_boleto','msg_adicional','agencia','agencia_dv','conta_corrente','conta_corrente_dv','cd_cedente','cnpj_cedente','cpf_cedente','nm_cedente','carteira','especie_documento','carteira_variacao','tp_juros','tp_multa', 'id_banco_conta'))
                    ->join(array('ta' => TB_AGRUPADA), 'ta.idTabela = 9 AND ta.idCampo = b.cd_banco', array('nmBanco'=>'descricao'))
                    ->where("id_banco_conta = {$parcela[0]['id_banco_boleto']}")->query()->fetch();

                if(!$banco){
                    $banco = new Banco();
                    $banco = $banco->getAdapter()->select()
                    ->from(array('b' => TB_BANCO), array('id_banco' => 'id', 'cd_banco','multa','juros','msg_boleto','msg_adicional','agencia','agencia_dv','conta_corrente','conta_corrente_dv','cd_cedente','cnpj_cedente','cpf_cedente','nm_cedente','carteira','especie_documento','carteira_variacao','tp_juros','tp_multa', 'id_banco_conta'))
                    ->join(array('ta' => TB_AGRUPADA), 'ta.idTabela = 9 AND ta.idCampo = b.cd_banco', array('nmBanco'=>'descricao'))
                    ->where("id = {$parcela[0]['id_banco_boleto']}")->query()->fetch();
                }
            }
            elseif($contrato['id_banco']){
                //Banco multi
                $banco = new Banco();
                $banco = $banco->getAdapter()->select()
                ->from(array('b' => TB_BANCO), array('id_banco' => 'id', 'cd_banco','multa','juros','msg_boleto','msg_adicional','agencia','agencia_dv','conta_corrente','conta_corrente_dv','cd_cedente','cnpj_cedente','cpf_cedente','nm_cedente','carteira','especie_documento','carteira_variacao','tp_juros','tp_multa', 'id_banco_conta'))
                ->join(array('ta' => TB_AGRUPADA), 'ta.idTabela = 9 AND ta.idCampo = b.cd_banco', array('nmBanco'=>'descricao'))
                ->where("id = {$contrato['id_banco']}")->query()->fetch();
            }
            elseif($_POST['banco']){
                $banco = new Banco();
                $banco = $banco->getAdapter()->select()
                ->from(array('b' => TB_BANCO), array('id_banco' => 'id', 'cd_banco','multa','juros','msg_boleto','msg_adicional','agencia','agencia_dv','conta_corrente','conta_corrente_dv','cd_cedente','cnpj_cedente','cpf_cedente','nm_cedente','carteira','especie_documento','carteira_variacao','tp_juros','tp_multa', 'id_banco_conta'))
                ->join(array('ta' => TB_AGRUPADA), 'ta.idTabela = 9 AND ta.idCampo = b.cd_banco', array('nmBanco'=>'descricao'))
                ->where("id = {$_POST['banco']}")->query()->fetch();
            }
            $bancoColumns = array('id_banco', 'cd_banco','multa','juros','msg_boleto','msg_adicional','agencia','agencia_dv','conta_corrente','conta_corrente_dv','cd_cedente','cnpj_cedente','cpf_cedente','nm_cedente','carteira','especie_documento','carteira_variacao','tp_juros','tp_multa', 'id_banco_conta', 'nmBanco');
            foreach ($bancoColumns as $coluna) {
                $parcela[0][$coluna] = $banco[$coluna];
            }
            $data = implode("-",array_reverse(explode("/",$_POST['data'])));
            $diretorioEmail = getcwd()."/upload/cliente/".$nmDominio."/emails";
            $diretorioWhatsApp = getcwd()."/upload/cliente/".$nmDominio."/whatsapp";
            if (!is_dir($diretorioEmail)) {
                mkdir($diretorioEmail, 0777, true);
            }
            if (!is_dir($diretorioWhatsApp)) {
                mkdir($diretorioWhatsApp, 0777, true);
            }
            $diretorioEmail = $diretorioEmail . "/parcela".$id_parcela_contrato.".".time().".html";
            $diretorioWhatsApp = $diretorioWhatsApp . "/parcela".$id_parcela_contrato.".".time().".html";
            $diretorioEmailRelativo = "/upload/cliente/".$nmDominio."/emails/parcela".$id_parcela_contrato.".".time().".html";
            $diretorioWhatsAppRelativo = "/upload/cliente/".$nmDominio."/whatsapp/parcela".$id_parcela_contrato.".".time().".html";
            $id_parcela_modelo = $parcela[0]['id_parcela'];
            if($parcela[0]['nr_tipo_parcela']){
                $id_parcela_modelo = $parcela[0]['nr_tipo_parcela'];
            }
            else if($parcela[0]['nr_boleto']){
                $id_parcela_modelo = $parcela[0]['nr_boleto'];
            }
            $cnpj = (new Helper)->cnpjMask(preg_replace('/[^0-9]/', '',$this->cliente->nr_cnpj));
            if($banco && $banco['cnpj_cedente']){
                $cnpj = (new Helper)->cnpjMask(preg_replace('/[^0-9]/', '',$banco['cnpj_cedente']));
            }
            if($contrato['cnpjContato']){
                $cnpj = (new Helper)->cnpjMask(preg_replace('/[^0-9]/', '',$contrato['cnpjContato']));
            }
            $templateEmail = array(
                "quadra"=>($contrato['quadra']),
                "nm_empreendimento"=>($contrato['nm_empreendimento']),
                "cnpj"=>$cnpj,
                "telefone"=>$telefone,
                "email"=>$contrato['emailContato'],
                "telefoneLimpo"=>preg_replace('/[^0-9]/', '',$telefone),
                "lote"=>($contrato['lote']),
                "grupo"=>($contrato['ds_grupo']),
                "subgrupo"=>($contrato['ds_subgrupo']),
                "nomeDestinatario"=>($contrato['nm_pessoa']),
                "id_parcela"=>$id_parcela_modelo,
                "link"=>"https://".$nmDominio.".acadeone.com.br/acadelotear/?m=bo&c=emissao&a=boleto&idParcela=".$_POST["id_parcela"]."&idContrato=".$parcela[0]['id_contrato'],
                "visualizarEmail"=>'<img src="https://'.$nmDominio.'.acadeone.com.br/acadelotear/index.php?m=bo&c=emissao&a=visualizarEmail&idParcela='.$id_parcela_contrato.'&idContrato='.$parcela[0]['id_contrato'].'" style="display:none">'
            );
            $limite="";
            $qtdAgendado = $this->tb_comunicacao->verificaAgendado($data);
            
            if($qtdAgendado&&$this->cliente->qtd_envio_email&&$qtdAgendado['quantidade']>=$this->cliente->qtd_envio_email){
                $limite="Limite dirio de envio da data ".$_POST['data']." foi atingindo, entre em contato com o suporte";
                //echo "{\"id_parcela\":\"".$id_parcela_contrato."\",\"status\":\"".$limite."\",\"id\":"."0".",\"limite\":\"".$limite."\"}";
            }
            $retornoAgendamento['status']="No Agendado";
            $retornoAgendamentoWhatsapp['status']="No Agendado";
            if($_POST["idEmail"]&&$parcela[0]['email']){
                $retornoAgendamento=$this->tb_comunicacao->adicionar($_POST["idEmail"],$parcela[0]['id_contrato'],$parcela[0]['nm_pessoa'],$parcela[0]['email'],$config_email['assunto'],$diretorioEmailRelativo,$data,$_POST['id_parcela'],$_POST['banco'],$segundaVia);
                if($retornoAgendamento['status']=="Agendado"){
                    file_put_contents($diretorioEmail, $this->renderEmail(getcwd().$modelo['diretorio'],$templateEmail,false));
                }
            }
            if($_POST["idWhatsApp"]&&($parcela[0]['nr_celular']||$parcela[0]['nr_telefone'])){
                $retornoAgendamentoWhatsapp=$this->tb_comunicacao->adicionar($_POST["idWhatsApp"],$parcela[0]['id_contrato'],$parcela[0]['nm_pessoa'],preg_replace('/[^\d+]/', '', $parcela[0]['nr_celular']?$parcela[0]['nr_celular']:$parcela[0]['nr_telefone']),$config_whatsapp['assunto'],$diretorioWhatsAppRelativo,$data,$_POST['id_parcela'],$_POST['banco'],$segundaVia);
                if($retornoAgendamentoWhatsapp['status']=="Agendado"){
                    file_put_contents($diretorioWhatsApp, $this->renderEmail(getcwd().$modeloWhatsapp['diretorio'],$templateEmail,false));
                }
            }
            echo "{\"id_parcela\":\"".$id_parcela_contrato."\",\"status\":\"Email:".$retornoAgendamento['status'].", WhatsApp:".$retornoAgendamentoWhatsapp['status']."\",\"id\":\"".$retornoAgendamento['id'].",".$retornoAgendamentoWhatsapp['id']."\",\"limite\":\"".$limite."\"}";
        }
    }

    public function agendarCobrancaAction(){
        $data = date("Y-m-d H:i:s");
        $idContrato = $_POST['idContrato'];
        $modelo = $this->tb_comunicacao_modelo->getInfo(2);
        $modeloWhatsapp = $this->tb_comunicacao_modelo->getInfo(4);
        
        $nmDominio = "";
        $url = explode('.', $_SERVER['HTTP_HOST']);
        if ($url[0] == 'www') {
            $nmDominio = $url[1];
        } else {
            $nmDominio = $url[0];
        }
        $contrato = $this->tb_contrato->findContratoById($idContrato,null,false,true);

        $cnpj = (new Helper)->cnpjMask(preg_replace('/[^0-9]/', '',$this->cliente->nr_cnpj));
        $banco = new Banco();
        if($contrato['id_banco']){
            //Banco multi
            $banco = $banco->getAdapter()->select()
                ->from(array('b' => TB_BANCO), array('id_banco' => 'id', 'cd_banco','multa','juros','msg_boleto','msg_adicional','agencia','agencia_dv','conta_corrente','conta_corrente_dv','cd_cedente','cnpj_cedente','cpf_cedente','nm_cedente','carteira','especie_documento','carteira_variacao','tp_juros','tp_multa', 'id_banco_conta'))
                ->join(array('ta' => TB_AGRUPADA), 'ta.idTabela = 9 AND ta.idCampo = b.cd_banco', array('nmBanco'=>'descricao'))
                ->where("id = {$contrato['id_banco']}")->query()->fetch();

            if(!$banco){
                $banco = new Banco();
                $banco = $banco->getAdapter()->select()
                ->from(array('b' => TB_BANCO), array('id_banco' => 'id', 'cd_banco','multa','juros','msg_boleto','msg_adicional','agencia','agencia_dv','conta_corrente','conta_corrente_dv','cd_cedente','cnpj_cedente','cpf_cedente','nm_cedente','carteira','especie_documento','carteira_variacao','tp_juros','tp_multa', 'id_banco_conta'))
                ->join(array('ta' => TB_AGRUPADA), 'ta.idTabela = 9 AND ta.idCampo = b.cd_banco', array('nmBanco'=>'descricao'))
                ->where("id_banco_conta = {$contrato['id_banco']}")->query()->fetch();
            }
        }
        if($banco['cnpj_cedente']){
            $cnpj = (new Helper)->cnpjMask(preg_replace('/[^0-9]/', '',$banco['cnpj_cedente']));
        }
        $diretorioEmail = getcwd()."/upload/cliente/".$nmDominio."/emails";
        if (!is_dir($diretorioEmail)) {
            mkdir($diretorioEmail, 0777, true);
        }
        $diretorioEmail = $diretorioEmail . "/cobranca".$idContrato.".".time().".html";
        $diretorioEmailRelativo = "/upload/cliente/".$nmDominio."/emails/cobranca".$idContrato.".".time().".html";


        $diretorioWhatsApp = getcwd()."/upload/cliente/".$nmDominio."/whatsapp";
        if (!is_dir($diretorioWhatsApp)) {
            mkdir($diretorioWhatsApp, 0777, true);
        }
        $diretorioWhatsApp = $diretorioWhatsApp . "/cobranca".$idContrato.".".time().".html";
        $diretorioWhatsAppRelativo = "/upload/cliente/".$nmDominio."/whatsapp/cobranca".$idContrato.".".time().".html";

        $cnpj = (new Helper)->cnpjMask(preg_replace('/[^0-9]/', '', $this->cliente->nr_cnpj));
        if($contrato['cnpjContato']){
            $cnpj = (new Helper)->cnpjMask(preg_replace('/[^0-9]/', '',$contrato['cnpjContato']));
        }
        $telefone = "(".$this->cliente->nr_uf_telefone.") ".$this->cliente->nr_telefone;
        if($contrato['telefoneContato']){
            $telefone = $contrato['telefoneContato'];
        }
        $templateEmail = array(
            "quadra"=>($contrato['quadra']),
            "nm_empreendimento"=>($contrato['nm_empreendimento']),
            "cnpj"=>$cnpj,
            "email"=>$contrato['emailContato'],
            "email_empreendimento"=>$this->cliente->ds_email,
            "telefone"=>$telefone,
            "telefoneLimpo"=>preg_replace('/[^0-9]/', '',$telefone),
            "lote"=>($contrato['lote']),
            "grupo"=>($contrato['ds_grupo']),
            "subgrupo"=>($contrato['ds_subgrupo']),
            "nomeDestinatario"=>($contrato['nm_pessoa']),
        );
        $limite="";
        $qtdAgendado = $this->tb_comunicacao->verificaAgendado($data);
        if($qtdAgendado&&$this->cliente->qtd_envio_email&&$qtdAgendado['quantidade']>=$this->cliente->qtd_envio_email){
            $limite="Limite dirio de envio da data ".$_POST['data']." foi atingindo, entre em contato com o suporte";
            //echo "{\"status\":\"".$limite."\",\"id\":"."0".",\"limite\":\"".$limite."\"}";
        }
        $statusEmail = "No agendado";
        if($_POST['email']){
            $retornoAgendamento=$this->tb_comunicacao->adicionar($_POST['email'],$idContrato,$contrato['nm_pessoa'],$contrato['email'],($this->cliente->nm_fantasia?$this->cliente->nm_fantasia:$this->cliente->nm_razao_social). " - Cobrana",$diretorioEmailRelativo,$data);
            
            $statusEmail = $retornoAgendamento['status'];
            if($retornoAgendamento['status']=="Agendado"){
                file_put_contents($diretorioEmail, $this->renderEmail(getcwd().$modelo['diretorio'],$templateEmail,false));
            }
        }
        $statusWhatsapp = "No agendado";
        if($_POST['whatsapp']){
            $retornoAgendamentoWhatsApp=$this->tb_comunicacao->adicionar($_POST['whatsapp'],$idContrato,$contrato['nm_pessoa'],$contrato['nr_celular']?preg_replace('/[^\d+]/', '',$contrato['nr_celular']):preg_replace('/[^0-9]/', '',$contrato['nr_telefone']),($this->cliente->nm_fantasia?$this->cliente->nm_fantasia:$this->cliente->nm_razao_social). " - Cobrana",$diretorioWhatsAppRelativo,$data);
            
            $statusWhatsapp = $retornoAgendamentoWhatsApp['status'];
            if($retornoAgendamentoWhatsApp['status']=="Agendado"){
                file_put_contents($diretorioWhatsApp, $this->renderEmail(getcwd().$modeloWhatsapp['diretorio'],$templateEmail,false));
            }
        }
        echo "{\"status\":\"email:".$statusEmail.", whatsApp:".$statusWhatsapp."\",\"limite\":\"".$limite."\"}";
    }

    public function emailAction($id = null)
    {
        $nmDominio = "";
        $url = explode('.', $_SERVER['HTTP_HOST']);
        if ($url[0] == 'www') {
            $nmDominio = $url[1];
        } else {
            $nmDominio = $url[0];
        }
        $qtdEnviado = $this->tb_comunicacao->verificaEnviado(date("Y-m-d"));
        if($qtdEnviado&&$this->cliente->qtd_envio_email&&$qtdEnviado['quantidade']>=$this->cliente->qtd_envio_email){
            echo "Limite dirio de envio atingindo";
            die;
        }
        if (isset($_POST['id'])) {
            $id=$_POST['id'];
        }
        if (isset($id)) {

            $agendamento = $this->tb_comunicacao->getInfo($id);
            if ($agendamento) {
                if (is_null($agendamento['enviado'])) {
                    
                    if($agendamento["email"]){
                        $mailMessage = $this->enviarEmail($agendamento["email"],$agendamento["senha"],$agendamento["host"],$agendamento["porta"], $agendamento["nm_empreendimento"], $agendamento["emailDestinatario"], "", $agendamento["assunto"], str_replace("charset=utf-8","charset=iso-8859-1",file_get_contents(getcwd().$agendamento["arquivoEmail"])));

                        if ($mailMessage == "E-mail enviado com sucesso!") {
                            $dt_envio = date('Y-m-d H:i:s');
                            $this->tb_comunicacao->atualizar($id,1, $dt_envio);
                            (new Relacionamento())->saveContato(300, date('Y-m-d'), $agendamento['id_contrato'], "Log: Envio de email {$id}, com retorno: {$mailMessage}, email destinatrio: {$agendamento['emailDestinatario']}");
                        } 
                        echo $mailMessage;
                    }
                    else{
                        
                        $this->tb_comunicacao->atualizar($id,0, false,false,date('Y-m-d'));
                        echo 'Agendamento adicionado na lista de envio do whatsapp';
                        (new Relacionamento())->saveContato(300, date('Y-m-d'), $agendamento['id_contrato'], "Log: Alterado data de envio no agendamento {$_POST['idAgendamento']}, de: {$agendamento['agendado']}, para: {$_POST['dataAgendamento']}");
                    }
                } else {
                    echo "E-mail j enviado";
                }
            } else {
                echo 'Agendamento no encontrado';
            }
        } else {
            echo 'Agendamento no encontrado';
        }
    }
    function alterarAgendamentoAction(){
        if($_POST['idAgendamento']&&$_POST['dataAgendamento']){
            $agendamento = $this->tb_comunicacao->getInfo($_POST['idAgendamento']);
            $this->tb_comunicacao->atualizar($_POST['idAgendamento'],0, false,false,$_POST['dataAgendamento']);
            (new Relacionamento())->saveContato(300, date('Y-m-d'), $agendamento['id_contrato'], "Log: Alterado data de envio no agendamento {$_POST['idAgendamento']}, de: {$agendamento['agendado']}, para: {$_POST['dataAgendamento']}");
            echo "Agendamento atualizado com sucesso!";
        }
        else{
            echo "Falha ao atualizar agendamento.";
        }
    }
    function renderEmail($modelo,$parametros = [], $utf=true){
        $html = file_get_contents($modelo);
        foreach($parametros as $index=>$p){
            if($utf){
                $html = str_replace('${'.$index.'}',utf8_decode($p),$html);
            }
            else{
                $html = str_replace('${'.$index.'}',$p,$html);
            }
        }
        return $html;
    }
}