<?php
require_once 'layout/includes/header.php';
require_once 'layout/includes/menu.php';

$empreendimentos = $this->get('empreendimentos');
$dados = $this->get("dados");
$responsaveis = $this->get("responsaveis");
?>
<div id="show" class="content">
    <div class="page-heading">
        <?= $this->getHeader('Relatrio', 'de Cobranas', 'fa fa-file-o'); ?>
    </div>
    <div class="widget">
        <form action="<?= $this->_helper->getLink(array("m" => "cobranca", "c" => "relatorioCobranca", "a" => 'relatorio')); ?>" method="POST" id="form" target="receiver">
            <div class="widget-content padding">
                <!-- MENSAGENS -->
                <div class="alert alert-danger alert-dismissable msgErros" hidden></div>
                <div class="alert alert-success alert-dismissable msgSucess" hidden>Operao realizada com sucesso.</div>
                <?php if ($_GET['msg'] == 'fail') : ?>
                    <div class="alert alert-danger alert-dismissable">
                        <?= $_GET['exception'] ?><br>
                    </div>
                <?php endif; ?>
                <legend>Relatrio de Cobranas <span style=" font-size: 10pt">(Campos com <span style=" color: red">*</span> so obrigatrios)</span>
                    <span data-toggle="modal" data-target=".mVisualizar" style="font-size: 22px;" data-toggle="tooltip" data-placement="top" title="Assista ao tutorial">
                        <svg xmlns="" width="22" height="22" fill="currentColor" class="bi bi-youtube" viewBox="0 0 16 16">
                            <path d="M8.051 1.999h.089c.822.003 4.987.033 6.11.335a2.01 2.01 0 0 1 1.415 1.42c.101.38.172.883.22 1.402l.01.104.022.26.008.104c.065.914.073 1.77.074 1.957v.075c-.001.194-.01 1.108-.082 2.06l-.008.105-.009.104c-.05.572-.124 1.14-.235 1.558a2.01 2.01 0 0 1-1.415 1.42c-1.16.312-5.569.334-6.18.335h-.142c-.309 0-1.587-.006-2.927-.052l-.17-.006-.087-.004-.171-.007-.171-.007c-1.11-.049-2.167-.128-2.654-.26a2.01 2.01 0 0 1-1.415-1.419c-.111-.417-.185-.986-.235-1.558L.09 9.82l-.008-.104A31 31 0 0 1 0 7.68v-.123c.002-.215.01-.958.064-1.778l.007-.103.003-.052.008-.104.022-.26.01-.104c.048-.519.119-1.023.22-1.402a2.01 2.01 0 0 1 1.415-1.42c.487-.13 1.544-.21 2.654-.26l.17-.007.172-.006.086-.003.171-.007A100 100 0 0 1 7.858 2zM6.4 5.209v4.818l4.157-2.408z"></path>
                        </svg>
                    </span>
                </legend>
                <div class="row">
                    <div class="col-sm-12">
                        <div class="form-group col-sm-6">
                            <label class="control-label">
                                Empreendimento:<span class="require" style="color: red">*</span>
                            </label>
                            <select class="form-control select2 empreendimentoRelatorioCobranca" id="empreendimentoRelatorioCobranca" name="empreendimentoRelatorioCobranca" required="required" data-placeholder="Selecione o empreendimento">
                                <option value="">Selecione ...</option>
                                <?php foreach ($empreendimentos as $empreendimento): ?>
                                    <option value="<?= $empreendimento['id'] ?>">
                                        <?= $empreendimento['nm_empreendimento']; ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="form-group col-sm-6">
                            <label class="control-label">
                                Clientes:<span class="require" style="color: red">*</span>
                            </label>
                            <select class="form-control select2 clienteRelatorioCobranca" name="clienteRelatorioCobranca" data-placeholder="Selecione o cliente" id="clienteRelatorioCobranca" required="required">
                                <option value="">Escolha o cliente</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-12">
                        <div class="form-group col-sm-6">
                            <label class="control-label">
                                Quadra/Lote:<span class="require" style="color: red">*</span>
                            </label>
                            <select class="form-control select2 quadraRelatorioCobranca" name="quadraRelatorioCobranca" data-placeholder="Selecione quadra/lote" id="quadraRelatorioCobranca" required="required">
                                <option value="">Escolha a quadra/lote</option>
                            </select>
                            </select>
                        </div>
                        <div class="form-group col-sm-6">
                            <label class="control-label">
                                Banco:<span class="require" style="color: red">*</span>
                            </label>
                            <select class="form-control select2 bancoRelatorioCobranca" name="bancoRelatorioCobranca" id="bancoRelatorioCobranca" data-placeholder="Selecione o banco" required="required">
                                <option value="">Escolha o banco</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-12">
                        <div class="form-group col-sm-3">
                            <label class="control-label" for="dtPagamentoInicial">
                                Data pagamento inicial:<span class="require" style="color: red">*</span>
                            </label>
                            <input type="text" class="form-control data datepicker-input" id="dtPagamentoInicial" placeholder="Selecione a data inicial" name="dtPagamentoInicial" />
                        </div>
                        <div class="form-group col-sm-3">
                            <label class="control-label" for="dtPagamentoFinal">
                                Data final:<span class="require" style="color: red">*</span> <span style=" font-size: 9pt"><span style="color: red" class="span120dias" hidden>Mximo 120 dias</span></span>
                            </label>
                            <input type="text" class="form-control data datepicker-input" id="dtPagamentoFinal" placeholder="Selecione a data final" name="dtPagamentoFinal" />
                        </div>
                        <div class="form-group col-sm-3">
                            <label class="control-label" for="dtCreditoInicial">
                                Data crdito inicial:<span class="require" style="color: red">*</span>
                            </label>
                            <input type="text" class="form-control data datepicker-input" id="dtCreditoInicial" placeholder="Selecione a data inicial" name="dtCreditoInicial" />
                        </div>
                        <div class="form-group col-sm-3">
                            <label class="control-label" for="dtCreditoFinal">
                                Data final:<span class="require" style="color: red">*</span>
                                <span style="font-size: 9pt">
                                    <span style="color: red" class="span120dias" hidden>
                                        Mximo 120 dias
                                    </span>
                                </span>
                            </label>
                            <input type="text" class="form-control data datepicker-input" id="dtCreditoFinal" placeholder="Selecione a data final" name="dtCreditoFinal" />
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-12">
                        <div class="form-group col-sm-3">
                            <label for="responsavel" class="control-label">Responsvel:<span class="require" style="color: red">*</span></label>
                            <select name="responsavel" id="responsavel" class="form-control select2" data-placeholder="Selecione o responsvel">
                                <option value="*">Todos</option>
                                <?php foreach ($responsaveis as $responsavel): ?>
                                    <option value="<?= $responsavel['id'] .'_'. $responsavel['login'] ?>">
                                        <?= $responsavel['nm_pessoa']; ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="form-group col-sm-5">
                            <label class="control-label" style="margin-top: 20px;">Ranquear responsvel:
                                <input type="radio" class="form-control icheck" name="ranquearResponsavel" value="S" checked="checked">
                                <label class="control-label">Sim</label>
                                <input type="radio" class="form-control icheck" name="ranquearResponsavel" value="N">
                                <label class="control-label">No</label>
                            </label>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-12">
                        <div class="form-group col-sm-8">
                            <label class="control-label">Perodo de recuperao:</label></br>
                            <div class="checkbox">
                                <label><input type="checkbox" name="recuperacao[]" class="icheck" value="todos" checked>Todos os perodos</label>
                                <label><input type="checkbox" name="recuperacao[]" class="icheck" value="ate30">At 30 dias</label>
                                <label><input type="checkbox" name="recuperacao[]" class="icheck" value="trintaEumSessenta">31 a 60 dias</label>
                                <label><input type="checkbox" name="recuperacao[]" class="icheck" value="sessentaEumNoventa">61 a 90 dias</label>
                                <label><input type="checkbox" name="recuperacao[]" class="icheck" value="noventaEumCentoEvinte">91 a 120 dias</label>
                                <label><input type="checkbox" name="recuperacao[]" class="icheck" value="mais120">Mais que 120 dias</label>
                            </div>
                        </div>  
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-12">
                        <div class="form-group col-sm-6">
                            <label class="control-label">Situao:</label></br>
                            <div class="checkbox">
                                <label><input type="checkbox" class="icheck" name="situacao[]" value="S" checked>Sucesso</label>
                                <label><input type="checkbox" class="icheck" name="situacao[]" value="F" checked>Fracasso</label>
                                <label><input type="checkbox" class="icheck" name="situacao[]" value="SC" checked>Sem cobrana</label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="middle" style="display:block">     
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group col-sm-6">
                                <label class="control-label">Tipos de parcelas:</label><br>
                                <div class="checkbox">
                                    <label><input type="checkbox" name="tpParcela[]" class="icheck" value="N" checked>Normal</label>
                                    <label><input type="checkbox" name="tpParcela[]" class="icheck" value="S" checked>Sinal</label>
                                    <label><input type="checkbox" name="tpParcela[]" class="icheck" value="C" checked>Chave</label>
                                    <label><input type="checkbox" name="tpParcela[]" class="icheck" value="G" checked>Negociada</label>
                                    <label><input type="checkbox" name="tpParcela[]" class="icheck" value="Q" checked>Quitao</label>
                                    <label><input type="checkbox" name="tpParcela[]" class="icheck" value="I" checked>Intercalada</label>
                                    <label><input type="checkbox" name="tpParcela[]" class="icheck" value="A" checked>Avulsa</label>
                                </div>
                            </div>  

                            <div class="form-group col-sm-5">
                                <label>Tipos de pagamentos:</label><br>
                                <div class="checkbox">
                                    <label><input type="checkbox" name="tpPagamento[]" id="Banco" class="icheck" value="B" checked> Banco</label>
                                    <label><input type="checkbox" name="tpPagamento[]" id="Tesouraria" class="icheck" value="T" checked> Tesouraria</label>
                                    <label><input type="checkbox" name="tpPagamento[]" id="Outros" class="icheck" value="O"> Outros</label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group col-sm-6">
                                <label class="control-label" for="ordem">Ordenar por:<span class="require" style="color: red">*</span></label><br>
                                <div class="checkbox">
                                    <label><input type="radio" id="ordemD" class="form-control icheck tipo col-sm-3" name="ordem" value="D" checked />Data pagamento</label>
                                    <label><input type="radio" id="ordemQ" class="form-control icheck tipo col-sm-3" name="ordem" value="Q" />Quadra/Lote</label>
                                    <label><input type="radio" id="ordemP" class="form-control icheck tipo col-sm-3" name="ordem" value="P" />Cliente</label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group col-sm-3" style="display:none">
                                <label class="control-label">Gerar em:</label><br>
                                <div class="checkbox">
                                    <label><input type="radio" id="tipoRelatorioPdf" class="form-control icheck tipo col-sm-3" name="tipoRelatorio" checked value="pdf" />PDF</label>
                                    <label><input type="radio" id="tipoRelatorioHtml" class="form-control icheck tipo col-sm-3" name="tipoRelatorio" value="html" />HTML</label>
                                    <label><input type="radio" id="tipoRelatorioExcel" class="form-control icheck tipo col-sm-3" name="tipoRelatorio" value="xls" />Excel</label>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <input id="visualizarInput" name="visualizar" value="false" style="display: none">
                <div style="display:flex; justify-content:center; align-items:center">
                        <p id="hide-content" class="expandirMenu centralizador" style="display:none; cursor:pointer"><i class="fa fa-chevron-down"></i></p>
                </div>
                <legend>Operaes:</legend>
                <div class="row">
                    <div class="col-sm-12">                     
                        <div class="form-group col-sm-2">
                            <span id="pesquisar" class="btn btn-primary col-sm-12 fDesabilitaBtn" style="color:white; border-radius:5px"><i class="fa fa-search" aria-hidden="true"></i> Buscar</span>
                        </div>
                        <div class="form-group col-sm-2">
                            <button id="pdf" class="btn btn-danger col-sm-12 fDesabilitaBtn" style="color:white; border-radius:5px"><i class="fa fa-file-pdf-o" aria-hidden="true"></i> PDF</button>
                        </div>
                        <div class="form-group col-sm-2">
                            <button id="xls" class="btn btn-success col-sm-12 fDesabilitaBtn" style="color:white; border-radius:5px"><i class="fa fa-file-excel-o" aria-hidden="true"></i> Excel</button>
                        </div>                     
                        <div name="receiver" overflow="auto" id="receiver" seamless="seamless" ></div>
                    </div>
                </div>                                      
                <br>
            </div>
        </form>
    </div>
</div>
</div>
<div class="modal fade mVisualizar " tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel"
    aria-hidden="true">
    <div class="modal-dialog modal-lg ">
        <div class="modal-content">

            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal"
                        aria-hidden="true">&times;</button>
                <h2 class="modal-title" id="myModalLabel" align="center"><i class="fa fa-book"></i>
                    Tutorial</h2>
            </div>

            <div class="modal-body tableFix" style="max-height:600px;">
                <fieldset >
                    <legend>Relatrio de Cobrana - Verificar as Cobranas Realizadas e seus Retornos</legend>
                    <div class="row" style="margin-right: 0px;margin-left: 0px;">
                        <iframe width="560" height="500" src="https://www.youtube-nocookie.com/embed/-YWOH8Zk4OI?si=8JOhKmJJZ94qsng4" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>
                    </div>
                    <div></div>
                </fieldset>
            </div>
        </div>
    </div>
</div>
<?php require_once 'layout/includes/footer.php'; ?>