<?php
require_once 'layout/includes/header.php';
require_once 'layout/includes/menu.php';

$infoCliente = $this->get('infoCliente');
$infoParcelas = $this->get('infoParcelas');
$infoResumo = $this->get('infoResumo');
$reajuste = $this->get('reajuste');
$negociacao = $this->get('negociacao');
$historicos = $this->get('historicos');
$situacao = $this->get('status');
$valorTotal = $this->get('valorTotalParcelas');
$contratosCliente = $this->get('contratos');
$parcelasAtrasadas = $this->get('parcelasAtrasadas');
$extratoCliente = $this->get('extratoCliente');
$idsParcelasAtrasadas = '';
$url = '?m=cobranca&c=cobranca&a=editar&idPessoa='.$infoCliente['id_pessoa'].'&idContrato='.$infoCliente['id'];

if (isset($_GET['individual']))
{
    $idsParcelas = array_map(function ($parcela) {
        return $parcela['id_parcela_contrato'];
    }, $infoParcelas);
    $idsParcelas = implode(',', $idsParcelas);
} else {
    $idsParcelas = array_map(function ($parcela) {
        return $parcela['id_parcela'];
    }, $infoParcelas);
    $idsParcelas = implode(',', $idsParcelas);
}
?>

<div class="content">
    <div class="page-heading">
        <!-- altera o texto de cabealho da pgina -->
        <?= $this->getHeader('Cobrana', 'Geral', 'fa fa-money'); ?>
    </div>
    <div class="widget">
        <div class="widget-content padding">
            <!-- MENSAGENS -->
            <div class="alert alert-danger alert-dismissable msgErros" hidden></div>
            <div class="alert alert-success alert-dismissable msgSucess" hidden>Operao realizada com sucesso.</div>
            <?php
            if(isset($_GET['danger'])){
                echo '<div class="alert alert-danger alert-dismissable">' . $_GET['danger'] . '</div>';
            }
            elseif(isset($_GET['success'])){
                echo '<div class="alert alert-success alert-dismissable">' . $_GET['success'] . '</div>';
            }
            ?>
            <input type="hidden" name="opcao" value="B" id="flOpcao">
            <input type="hidden" name="idBanco" value="<?= $infoCliente['id_banco']?>" id="idBanco">
            <fieldset>
                <legend>Informaes do Cliente <span style=" font-size: 10pt; color: red;">(Clique nas informaes para editar)</span></legend>
                <div class="row">
                    <div class="form-group col-sm-3">
                        <label for="empreendimento" class="control-label">Empreendimento:
                            <strong><span id="nm_empreendimento"><?= $infoCliente['nm_empreendimento'] ?></span></strong>
                        </label>
                    </div>
                    <div class="form-group col-sm-3">
                        <label for="endereco" class="controller-label">Endereo:
                            <a href="#" id="nmEndereco" data-name="nmEndereco" data-emptytext="Endereo no informado" data-placeholder="Informe o endereo" data-type="text" data-pk="1" data-url="<?= $url.'&valAntigo='.$infoCliente['endereco']; ?>">
                                <strong><span><?= $infoCliente['endereco'].' '; ?></span></strong><span class="glyphicon glyphicon-edit"></span>
                            </a>
                        </label>
                    </div>
                    <div class="form-group col-sm-3">
                        <label for="numero" class="controller-label">N:
                            <a href="#" id="nrEndereco" data-name="nrEndereco" data-emptytext="N no informado" data-placeholder="Informe o n" data-type="text" data-pk="1" data-url="<?= $url.'&valAntigo='.$infoCliente['nr_endereco']; ?>">
                                <strong><span><?= $infoCliente['nr_endereco'].' ' ?></span></strong><span class="glyphicon glyphicon-edit"></span>
                            </a>
                        </label>
                    </div>
                    <div class="form-group col-sm-3">
                        <label for="telefone1" class="controle-label">Telefone 1:
                            <a href="#" id="nrTelefone" data-name="nrTelefone" data-emptytext="Telefone 1 no informado" data-placeholder="Informe o telefone 1" data-type="text" data-pk="1" data-url="<?= $url.'&valAntigo='.$infoCliente['nr_telefone']; ?>">
                                <strong><span><?= $infoCliente['nr_telefone'].' '; ?></span></strong><span class="glyphicon glyphicon-edit"></span>
                            </a>
                        </label>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-3">
                        <div class="form-inline">
                            <label for="contrato">Contrato:</label>
                            <?php if (count($contratosCliente) > 1): ?>
                                <select class="form-control" name="contratos" id="idSelectContrato">
                                    <?php if ($_GET['idSelectContrato']): ?>
                                        <option value="<?= $_GET['idSelectContrato']?>"><?= $_GET['idSelectContrato'] ?></option>
                                    <?php endif; ?>
                                        <?php foreach ($contratosCliente as $contrato): ?>
                                            <?php if ($contrato != $_GET['idSelectContrato']): ?>
                                                <option value="<?= $contrato ?>">
                                                    <strong><?= $contrato; ?></strong>
                                                </option>
                                            <?php endif; ?>
                                        <?php endforeach; ?>
                                </select>
                            <?php else: ?>
                                <?php if(isset($_GET['idSelectContrato'])): ?>
                                        <?php if (count($contratosCliente) > 1): ?>
                                            <strong><span id="idContrato"><?= $contrato; ?></span></strong> 
                                        <?php else: ?>
                                            <strong><span id="idContrato"><?= $infoCliente['id']; ?></span></strong> 
                                        <?php endif; ?>
                                <?php else: ?>      
                                    <strong><span id="idContrato"><?= $infoCliente['id']; ?></span></strong>
                                <?php endif; ?>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="form-group col-sm-3">
                        <label for="complemento" class="controller-label">Complemento:
                            <a href="#" id="dsComplemento" data-name="dsComplemento" data-emptytext="Complemento no informado" data-placeholder="Informe o complemento" data-type="text" data-pk="1" data-url="<?= $url.'&valAntigo='.$infoCliente['ds_complemento']; ?>">
                                <strong><span><?= $infoCliente['ds_complemento'].' '; ?></span></strong><span class="glyphicon glyphicon-edit"></span>
                            </a>
                        </label>
                    </div>
                    <div class="form-group col-sm-3">
                        <label for="bairro" class="controller-label">Bairro:
                            <a href="#" id="nmBairro" data-name="nmBairro" data-emptytext="Bairro no informado" data-placeholder="Informe o bairro" data-type="text" data-pk="1" data-url="<?= $url.'&valAntigo='.$infoCliente['nm_bairro']; ?>">
                                <strong><span class="nmBairro"><?= $infoCliente['nm_bairro'].' '; ?></span></strong><span class="glyphicon glyphicon-edit"></span>
                            </a>
                        </label>
                    </div>
                    <div class="form-group col-sm-3">
                        <label for="telefone2" class="controller-label">Telefone 2:
                            <a href="#" id="nrCelular" data-name="nrCelular" data-emptytext="Telefone 2 no informado" data-placeholder="Informe o telefone 2" data-type="text" data-pk="1" data-url="<?= $url.'&valAntigo='.$infoCliente['nr_celular']; ?>">
                                <strong><span id="nr_celular_cliente"><?= $infoCliente['nr_celular']; ?></span></strong> <span class="glyphicon glyphicon-edit"></span>
                            </a>
                        </label>
                    </div>
                </div>
                <div class="row">
                    <div class="form-group col-sm-3">
                        <label for="quadraLote" class="controller-label">Quadra/Lote:
                            <strong><span id="quadra"><?= $infoCliente['quadra']?></span> / <span id="lote"><?=$infoCliente['lote'] ?></span></strong>
                        </label>
                    </div>
                    <div class="form-group col-sm-3">
                        <label for="cep" class="controller-label">CEP:
                            <a href="#" id="nrCep" data-name="nrCep" data-emptytext="CEP no informado" data-placeholder="Informe o CEP" data-type="text" data-pk="1" data-url="<?= $url.'&valAntigo='.$infoCliente['nr_cep']; ?>">
                                <strong><span><?= $infoCliente['nr_cep'].' '; ?></span></strong><span class="glyphicon glyphicon-edit"></span>
                            </a>
                        </label>
                    </div>
                    <div class="col-sm-3 form-group">
                        <label class="control-label" for="cdCidade">
                            Cidade:
                        </label>
                        <a class="editable-click-select" idPessoa="<?= htmlentities(utf8_decode($infoCliente['id_pessoa'])); ?>" idContrato="<?= $infoCliente['id']; ?>" ciAnterior="<?= $infoCliente['nome'].' - '.$infoCliente['uf'] ?>" id="linkCidade" style="cursor:pointer;"><?= $infoCliente['nome'].' - '.$infoCliente['uf'] ?> <span class="glyphicon glyphicon-edit"></span></a>
                        <div id="divCidade" hidden>
                            <select class="form-control" name="cdCidade" id="cdCidade">
                                <?php if (isset($infoCliente['cd_cidade'])): ?>
                                    <option value="<?= $infoCliente['cd_cidade']; ?>">
                                        <?= Cidade::getNomeById($infoCliente['cd_cidade']); ?>
                                    </option>
                                <?php endif; ?>
                            </select>
                        </div>
                    </div>
                    <div class="form-group col-sm-3">
                        <label for="telefone3" class="controller-label">Telefone 3:
                            <a href="#" id="nrRecado" data-name="nrRecado" data-emptytext="Telefone 3 no informado" data-placeholder="Informe o telefone 3" data-type="text" data-pk="1" data-url="<?= $url.'&valAntigo='.$infoCliente['nr_recado']; ?>">
                                <strong><span><?= $infoCliente['nr_recado'].' '; ?></span></strong><span class="glyphicon glyphicon-edit"></span>
                            </a>
                        </label>
                    </div>
                </div>
                <div class="row">
                    <div class="form-group col-sm-3">
                        <label for="cliente" class="control-label">Cliente:
                            <strong><span id="nm_pessoa"><?= $infoCliente['nm_pessoa'] ?></span></strong>
                        </label>
                    </div>
                    <?php if($infoCliente['nr_cpf']): ?>
                    <div class="form-group col-sm-3">
                        <label for="cpf" class="controller-label">CPF:
                            <strong><span id="nr_cpf"><?= $infoCliente['nr_cpf'] ?></span></strong>
                        </label>
                    </div>
                    <?php else: ?>
                        <div class="form-group col-sm-3">
                        <label for="cpf" class="controller-label">CNPJ:
                            <strong><span id="nr_cpf"><?= $infoCliente['nr_cnpj'] ?></span></strong>
                        </label>
                    </div>
                    <?php endif; ?>
                    <div class="form-group col-sm-3">
                        <?php if ($infoCliente['juridico']['descricao'] || $infoCliente['fl_construcao'] == '1'): ?>
                            <label for="juridico" class="control-label" style="color:orangered;">
                                <strong>OBS:</strong>
                                <strong><span><?= $infoCliente['juridico']['descricao'] ?></span></strong>
                                
                                <?php if ($infoCliente['juridico']['descricao'] && $infoCliente['fl_construcao'] == '1'): ?>
                                    -
                                <?php endif; ?>

                                <strong><span><?= ($infoCliente['fl_construcao'] == '1') ? 'Com construo' : ''; ?></span></strong>
                            </label>
                        <?php endif; ?>
                    </div>
                    <div class="form-group col-sm-3">
                        <label for="email" class="controller-label">E-mail:
                            <a href="#" id="email" data-name="email" data-emptytext="E-mail no informado" data-placeholder="Informe o e-mail" data-type="text" data-pk="1" data-url="<?= $url.'&valAntigo='.$infoCliente['email']; ?>">
                                <strong><span id="email_cliente"><?= $infoCliente['email']; ?></span></strong> <span class="glyphicon glyphicon-edit"></span>
                            </a>
                        </label>
                    </div>
                    <?php if ($negociacao[0]['fl_fm_pagamento'] == 'PM') : ?>
                        <div class="fomr-group col-sm-3">
                            <label class="control-label" style="color:orangered;">
                                <strong>Forma de pagamento do contrato: Permuta</sstrong><p>
                            </label>
                        </div>
                    <?php endif; ?>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="col-sm-12">
                                <label class="control-label" for="obs_cobranca">
                                    Observao:
                                </label>
                                    <textarea class="form-control" id="obs_cobranca" maxlength="300"
                                                name="obs_cobranca"><?= $infoCliente['obs_cobranca'] ?></textarea>
                            </div>
                        </div>
                    </div></br>
                </div>
                <ul class="nav nav-tabs">
                    <li class="<?= $this->get('opcao') == '' ? 'active' : '' ?>">
                        <a href="#parcelaAtraso" class="flTipo" tipo="P" data-toggle="tab" aria-expanded="true">
                            Parcelas em atraso
                        </a>
                    </li>
                    <li class="<?= $this->get('opcao') == 'R' ? 'active' : '' ?>">
                        <a href="#resumoContrato" class="flTipo" tipo="R" data-toggle="tab" aria-expanded="false">
                            Resumo do contrato
                        </a>
                    </li>
                    <li class="<?= $this->get('opcao') == 'EX' ? 'active' : '' ?>">
                        <a href="#extratoContrato" class="flTipo" tipo="EX" data-toggle="tab" aria-expanded="false">
                            Extrato do contrato
                        </a>
                    </li>
                    <li class="<?= $this->get('opcao') == 'B' ? 'active' : '' ?>">
                        <a href="#boleto" class="flTipo" tipo="B" data-toggle="tab" aria-expanded="false">
                            Boleto
                        </a>
                    </li>
                    <li class="<?= $this->get('opcao') == 'B2' ? 'active' : '' ?>">
                        <a href="#boleto2Via" class="flTipo" tipo="B2" data-toggle="tab" aria-expanded="false">
                            Boleto 2 via
                        </a>
                    </li>
                    <li class="<?= $this->get('opcao') == 'N' ? 'active' : '' ?>">
                        <a href="#negociacao" class="flTipo" tipo="N" data-toggle="tab" aria-expanded="false">
                            Negociao
                        </a>
                    </li>
                    <li class="<?= $this->get('opcao') == 'RE' ? 'active' : '' ?>">
                        <a href="#relacionamento" class="flTipo" tipo="RE" data-toggle="tab" aria-expanded="false">
                            Relacionamento
                        </a>
                    </li>
                    <li class="<?= $this->get('opcao') == 'COM' ? 'active' : '' ?>">
                        <a href="#comunicacao" class="flTipo" tipo="COM" data-toggle="tab" aria-expanded="false">
                            Comunicao
                        </a>
                    </li>
                    <li class="<?= $this->get('opcao') == 'E' ? 'active' : '' ?>">
                        <a href="#encerramento" class="flTipo" tipo="E" data-toggle="tab" aria-expanded="false">
                            Encerramento
                        </a>
                    </li>
                </ul>
                <div class="tab-content" id="TabelaIniciar">
                    <div class="tab-pane fade <?= $this->get('opcao') == '' ? 'active' : '' ?> in" id="parcelaAtraso">
                        <legend>Parcelas em atraso</legend>
                        <div class="table-responsive tableFix">
                            <table id="TabelaParcelasAtraso"
                                   class="table table-hover table-condensed order column"
                                   cellspacing="0" width="100%">
                                <thead>
                                <tr>
                                    <th width="60px" class="text-center"><strong>Data vencimento</strong></th>
                                    <th width="60px" class="text-center"><strong>Parcela</strong></th>
                                    <th width="60px" class="text-center"><strong>Data parcela 2 via</strong></th>
                                    <th width="60px" class="text-right"><strong>Dias em atraso</strong></th>
                                    <th width="60px" class="text-right"><strong>Valor</strong></th>
                                    <th width="60px" class="text-right"><strong>Juros</strong></th>
                                    <th width="60px" class="text-right"><strong>Multa</strong></th>
                                    <th width="100px" class="text-right"><strong>Valor  pagar</strong></th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php if ($_GET['individual'] == false): ?>
                                    <!--Cobrana Coletiva-->
                                    <?php foreach ($parcelasAtrasadas as $parcela): ?>
                                        <?php $atraso = Helper::date_diff(Helper::dataParaAmericano($parcela["dt_parcela"]), date('Y-m-d')); ?>
                                        <?php $atraso = ($atraso >= 0) ? number_format($atraso, 0) : "0"; ?>
                                        <tr>
                                            <td class="text-center"><?= Helper::getDate($parcela['dt_parcela']); ?></td>
                                            <td class="text-center"><?= $parcela['nr_parcela']. '' .$parcela['tp_parcela']; ?></td>
                                            <td class="text-center"><?= Helper::getDate($parcela['dt_2avia']); ?> </td>
                                            <td class="text-right"><?= $atraso ?></td>
                                            <td class="text-right"><?= Helper::getMoney($parcela['vl_parcela']); ?></td>
                                            <td class="text-right"><?= Helper::getMoney($parcela['juros']); ?></td>
                                            <td class="text-right"><?= Helper::getMoney($parcela['multa']); ?></td>
                                            <td class="text-right"><?= Helper::getMoney($parcela['vl_parcela'] + $parcela['juros'] + $parcela['multa']); ?></td>
                                        </tr>
                                    <?php endforeach; ?>
                                    <tr>
                                        <td width="100px"><strong>Total</strong></td>
                                        <td width="100px" class="text-center"><strong><?= count($parcelasAtrasadas); ?></strong></td>
                                        <td width="100px"></td>
                                        <td width="100px"></td>
                                        <td width="100px" class="text-right"><strong><?= Helper::getMoney($valorTotal['total']); ?></strong></td>
                                        <td width="100px" class="text-right"><strong><?= Helper::getMoney($valorTotal['totalJuros']); ?></strong></td>
                                        <td width="100px" class="text-right"><strong><?= Helper::getMoney($valorTotal['totalMulta']); ?></strong></td>
                                        <td width="100px" class="text-right"><strong><?= Helper::getMoney($valorTotal['totalComAcrescimos']); ?></strong></td>
                                    </tr>
                                <?php else: ?>
                                    <!--Cobrana Individual-->
                                    <?php foreach ($parcelasAtrasadas as $parcela): ?>
                                        <?php $idsParcelasAtrasadas .= $parcela['id_parcela_contrato'] . ', '; ?>
                                        <?php $atraso = Helper::date_diff(Helper::dataParaAmericano($parcela["dt_parcela"]), date('Y-m-d')); ?>
                                        <?php $atraso = ($atraso >= 0) ? number_format($atraso, 0) : "0"; ?>
                                        <tr>
                                            <td class="text-center"><?= Helper::getDate($parcela['dt_parcela']); ?></td>
                                            <td class="text-center"><?= $parcela['id_parcela']. '' .$parcela['tp_parcela']; ?></td>
                                            <td class="text-center"><?= Helper::getDate($parcela['dt_parcela_2avia']); ?></td>
                                            <td class="text-right"><?= $atraso ?></td>
                                            <td class="text-right"><?= Helper::getMoney($parcela['vl_parcela']); ?></td>
                                            <td class="text-right"><?= Helper::getMoney($parcela['juros']); ?></td>
                                            <td class="text-right"><?= Helper::getMoney($parcela['multa']); ?></td>
                                            <td class="text-right"><?= Helper::getMoney($parcela['valor'] + $parcela['juros'] + $parcela['multa']); ?></td>
                                        </tr>
                                    <?php endforeach; ?>
                                    <!--Junta os ids das parcelas atrasadas em uma string para ser repassado para a funo de encerrar cobrana individual.-->
                                    <span hidden id="idsParcelasAtrasadas"><?= $idsParcelasAtrasadas; ?></span>
                                    <tr>
                                        <td width="100px"><strong>Total</strong></td>
                                        <td width="100px" class="text-center"><strong><?= count($parcelasAtrasadas); ?></strong></td>
                                        <td width="100px"></td>
                                        <td width="100px"></td>
                                        <td width="100px" class="text-right"><strong><?= Helper::getMoney($valorTotal['total']); ?></strong></td>
                                        <td width="100px" class="text-right"><strong><?= Helper::getMoney($valorTotal['totalJuros']); ?></strong></td>
                                        <td width="100px" class="text-right"><strong><?= Helper::getMoney($valorTotal['totalMulta']); ?></strong></td>
                                        <td width="100px" class="text-right"><strong><?= Helper::getMoney($valorTotal['totalComAcrescimos']); ?></strong></td>
                                    </tr>
                                <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div> <!-- / .tab-pane -->
                    <div class="tab-pane fade <?= $this->get('opcao') == 'R' ? 'active' : '' ?> in" id="resumoContrato">
                        <legend>Resumo do Contrato</legend>
                        <div class="table-responsive">
                            <table id="TabelaResumoContrato"
                                   class="table table-hover table-condensed order column"
                                   cellspacing="0" width="100%">
                                <thead>
                                <tr>
                                    <th colspan="1" width="40px"></th>
                                    <th colspan="2" width="120px" class="text-center"><strong>Total</strong></th>
                                    <th colspan="3" width="120px" class="text-center"><strong>Pagas</strong></th>
                                    <th colspan="3" width="120px" class="text-center" style="color: red;"><strong>Em atraso</strong></th>
                                    <th colspan="3" width="120px" class="text-center"><strong> vencer</strong></th>
                                </tr>
                                <tr>
                                    <th></th>
                                    <th width="40px" class="text-right">Valor</th>
                                    <th width="40px" class="text-right">Parcelas</th>
                                    <th width="40px" class="text-right">Valor</th>
                                    <th width="40px" class="text-right">Parcelas</th>
                                    <th width="40px" class="text-right">%</th>
                                    <th width="40px" class="text-right" style="color: red;">Valor</th>
                                    <th width="40px" class="text-right" style="color: red;">Parcelas</th>
                                    <th width="40px" class="text-right" style="color: red;">%</th>
                                    <th width="40px" class="text-right">Valor</th>
                                    <th width="40px" class="text-right">Parcelas</th>
                                    <th width="40px" class="text-right">%</th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php if ($infoResumo['qtdTotalN'] > 0): ?>
                                    <tr>
                                        <td width="40px"><strong>Normais (N)</strong></td>
                                        <td width="40px" class="text-right"><?= Helper::getMoney($infoResumo['valorTotalN'])?></td>
                                        <td width="40px" class="text-right"><?= $infoResumo['qtdTotalN'] ?></td>
                                        <td width="40px" class="text-right"><?= Helper::getMoney($infoResumo['pagoTotalN']) ?></td>
                                        <td width="40px" class="text-right"><?= $infoResumo['pagoQtdN'] ?></td>
                                        <td width="40px" class="text-right"><?= Helper::getMoney($infoResumo['porcentagemPagoN']) ?></td>
                                        <td width="40px" class="text-right" style="color: red;"><?= Helper::getMoney($infoResumo['atrasoTotalN']) ?></td>
                                        <td width="40px" class="text-right" style="color: red;"><?= $infoResumo['atrasoQtdN'] ?></td>
                                        <td width="40px" class="text-right" style="color: red;"><?= Helper::getMoney($infoResumo['porcentagemAtrasoN']) ?></td>
                                        <td width="40px" class="text-right"><?= Helper::getMoney($infoResumo['pagarTotalN']) ?></td>
                                        <td width="40px" class="text-right"><?= $infoResumo['pagarQtdN'] ?></td>
                                        <td width="40px" class="text-right"><?= Helper::getMoney($infoResumo['porcentagemPagarN']) ?></td>
                                    </tr>
                                <?php endif; ?>
                                <?php if ($infoResumo['qtdTotalS'] > 0): ?>
                                    <tr>
                                        <td width="40px"><strong>Sinais (S)</strong></td>
                                        <td width="40px" class="text-right"><?= Helper::getMoney($infoResumo['valorTotalS'])?></td>
                                        <td width="40px" class="text-right"><?= $infoResumo['qtdTotalS'] ?></td>
                                        <td width="40px" class="text-right"><?= Helper::getMoney($infoResumo['pagoTotalS']) ?></td>
                                        <td width="40px" class="text-right"><?= $infoResumo['pagoQtdS'] ?></td>
                                        <td width="40px" class="text-right"><?= Helper::getMoney($infoResumo['porcentagemPagoS']) ?></td>
                                        <td width="40px" class="text-right" style="color: red;"><?= Helper::getMoney($infoResumo['atrasoTotalS']) ?></td>
                                        <td width="40px" class="text-right" style="color: red;"><?= $infoResumo['atrasoQtdS'] ?></td>
                                        <td width="40px" class="text-right" style="color: red;"><?= Helper::getMoney($infoResumo['porcentagemAtrasoS']) ?></td>
                                        <td width="40px" class="text-right"><?= Helper::getMoney($infoResumo['pagarTotalS']) ?></td>
                                        <td width="40px" class="text-right"><?= $infoResumo['pagarQtdS'] ?></td>
                                        <td width="40px" class="text-right"><?= Helper::getMoney($infoResumo['porcentagemPagarS']) ?></td>
                                    </tr>
                                <?php endif; ?>
                                <?php if ($infoResumo['qtdTotalI'] > 0): ?>
                                    <tr>
                                        <td width="40px"><strong>Intercaladas (I)</strong></td>
                                        <td width="40px" class="text-right"><?= Helper::getMoney($infoResumo['valorTotalI']) ?></td>
                                        <td width="40px" class="text-right"><?= $infoResumo['qtdTotalI'] ?></td>
                                        <td width="40px" class="text-right"><?= Helper::getMoney($infoResumo['pagoTotalI']) ?></td>
                                        <td width="40px" class="text-right"><?= $infoResumo['pagoQtdI'] ?></td>
                                        <td width="40px" class="text-right"><?= Helper::getMoney($infoResumo['porcentagemPagoI']) ?></td>
                                        <td width="40px" class="text-right" style="color: red;"><?= Helper::getMoney($infoResumo['atrasoTotalI']) ?></td>
                                        <td width="40px" class="text-right" style="color: red;"><?= $infoResumo['atrasoQtdI'] ?></td>
                                        <td width="40px" class="text-right" style="color: red;"><?= Helper::getMoney($infoResumo['porcentagemAtrasoI']) ?></td>
                                        <td width="40px" class="text-right"><?= Helper::getMoney($infoResumo['pagarTotalI']) ?></td>
                                        <td width="40px" class="text-right"><?= $infoResumo['pagarQtdI'] ?></td>
                                        <td width="40px" class="text-right"><?= Helper::getMoney($infoResumo['porcentagemPagarI']) ?></td>
                                    </tr>
                                <?php endif; ?>
                                <?php if ($infoResumo['qtdTotalC'] > 0): ?>
                                    <tr>
                                        <td width="40px"><strong>Chave (C)</strong></td>
                                        <td width="40px" class="text-right"><?= Helper::getMoney($infoResumo['valorTotalC']) ?></td>
                                        <td width="40px" class="text-right"><?= $infoResumo['qtdTotalC'] ?></td>
                                        <td width="40px" class="text-right"><?= Helper::getMoney($infoResumo['pagoTotalC']) ?></td>
                                        <td width="40px" class="text-right"><?= $infoResumo['pagoQtdC'] ?></td>
                                        <td width="40px" class="text-right"><?= Helper::getMoney($infoResumo['porcentagemPagoC']) ?></td>
                                        <td width="40px" class="text-right" style="color: red;"><?= Helper::getMoney($infoResumo['atrasoTotalC']) ?></td>
                                        <td width="40px" class="text-right" style="color: red;"><?= $infoResumo['atrasoQtdC'] ?></td>
                                        <td width="40px" class="text-right" style="color: red;"><?= Helper::getMoney($infoResumo['porcentagemAtrasoC']) ?></td>
                                        <td width="40px" class="text-right"><?= Helper::getMoney($infoResumo['pagarTotalC']) ?></td>
                                        <td width="40px" class="text-right"><?= $infoResumo['pagarQtdC'] ?></td>
                                        <td width="40px" class="text-right"><?= Helper::getMoney($infoResumo['porcentagemPagarC']) ?></td>
                                    </tr>
                                <?php endif; ?>
                                <?php if ($infoResumo['qtdTotalQ'] > 0): ?>
                                    <tr>
                                        <td width="40px"><strong>Quitadas (Q)</strong></td>
                                        <td width="40px" class="text-right"><?= Helper::getMoney($infoResumo['valorTotalQ']) ?></td>
                                        <td width="40px" class="text-right"><?= $infoResumo['qtdTotalQ'] ?></td>
                                        <td width="40px" class="text-right"><?= Helper::getMoney($infoResumo['pagoTotalQ']) ?></td>
                                        <td width="40px" class="text-right"><?= $infoResumo['pagoQtdQ'] ?></td>
                                        <td width="40px" class="text-right"><?= Helper::getMoney($infoResumo['porcentagemPagoQ']) ?></td>
                                        <td width="40px" class="text-right" style="color: red;"><?= Helper::getMoney($infoResumo['atrasoTotalQ']) ?></td>
                                        <td width="40px" class="text-right" style="color: red;"><?= $infoResumo['atrasoQtdQ'] ?></td>
                                        <td width="40px" class="text-right" style="color: red;"><?= Helper::getMoney($infoResumo['porcentagemAtrasoQ']) ?></td>
                                        <td width="40px" class="text-right"><?= Helper::getMoney($infoResumo['pagarTotalQ']) ?></td>
                                        <td width="40px" class="text-right"><?= $infoResumo['pagarQtdQ'] ?></td>
                                        <td width="40px" class="text-right"><?= Helper::getMoney($infoResumo['porcentagemPagarQ']) ?></td>
                                    </tr>
                                <?php endif; ?>
                                <?php if ($infoResumo['qtdTotalG'] > 0): ?>
                                    <tr>
                                        <td width="40px"><strong>Negociadas (G)</strong></td>
                                        <td width="40px" class="text-right"><?= Helper::getMoney($infoResumo['valorTotalG']) ?></td>
                                        <td width="40px" class="text-right"><?= $infoResumo['qtdTotalG'] ?></td>
                                        <td width="40px" class="text-right"><?= Helper::getMoney($infoResumo['pagoTotalG']) ?></td>
                                        <td width="40px" class="text-right"><?= $infoResumo['pagoQtdG'] ?></td>
                                        <td width="40px" class="text-right"><?= Helper::getMoney($infoResumo['porcentagemPagoG']) ?></td>
                                        <td width="40px" class="text-right" style="color: red;"><?= Helper::getMoney($infoResumo['atrasoTotalG']) ?></td>
                                        <td width="40px" class="text-right" style="color: red;"><?= $infoResumo['atrasoQtdG'] ?></td>
                                        <td width="40px" class="text-right" style="color: red;"><?= Helper::getMoney($infoResumo['porcentagemAtrasoG']) ?></td>
                                        <td width="40px" class="text-right"><?= Helper::getMoney($infoResumo['pagarTotalG']) ?></td>
                                        <td width="40px" class="text-right"><?= $infoResumo['pagarQtdG'] ?></td>
                                        <td width="40px" class="text-right"><?= Helper::getMoney($infoResumo['porcentagemPagarG']) ?></td>
                                    </tr>
                                <?php endif; ?>
                                <?php if ($infoResumo['qtdTotalA'] > 0): ?>
                                    <tr>
                                        <td width="60px"><strong>Avulsas (A)</strong></td>
                                        <td width="40px" class="text-right"><?= Helper::getMoney($infoResumo['valorTotalA']) ?></td>
                                        <td width="40px" class="text-right"><?= $infoResumo['qtdTotalA'] ?></td>
                                        <td width="40px" class="text-right"><?= Helper::getMoney($infoResumo['pagoTotalA']) ?></td>
                                        <td width="40px" class="text-right"><?= $infoResumo['pagoQtdA'] ?></td>
                                        <td width="40px" class="text-right"><?= Helper::getMoney($infoResumo['porcentagemPagoA']) ?></td>
                                        <td width="40px" class="text-right" style="color: red;"><?= Helper::getMoney($infoResumo['atrasoTotalA']) ?></td>
                                        <td width="40px" class="text-right" style="color: red;"><?= $infoResumo['atrasoQtdA'] ?></td>
                                        <td width="40px" class="text-right" style="color: red;"><?= Helper::getMoney($infoResumo['porcentagemAtrasoA']) ?></td>
                                        <td width="40px" class="text-right"><?= Helper::getMoney($infoResumo['pagarTotalA']) ?></td>
                                        <td width="40px" class="text-right"><?= $infoResumo['pagarQtdA'] ?></td>
                                        <td width="40px" class="text-right"><?= Helper::getMoney($infoResumo['porcentagemPagarA']) ?></td>
                                    </tr>
                                <?php endif; ?>
                                <tr>
                                    <td width="40px"><strong>Total geral</strong></td>
                                    <td width="40px" class="text-right"><strong><?= Helper::getMoney($infoResumo['valorTotalGeral']) ?></strong></td>
                                    <td width="40px" class="text-right"><strong><?= $infoResumo['qtdTotalGeral'] ?></strong></td>
                                    <td width="40px" class="text-right"><strong><?= Helper::getMoney($infoResumo['valorTotalPagas']) ?></strong></td>
                                    <td width="40px" class="text-right"><strong><?= $infoResumo['qtdTotalPagas'] ?></strong></td>
                                    <td width="40px" class="text-right"><strong><?= Helper::getMoney($infoResumo['porcentagemTotalPagas']) ?></strong></td>
                                    <td width="40px" class="text-right" style="color: red;"><strong><strong><?= Helper::getMoney($infoResumo['valorTotalAtrasos']) ?></strong></td>
                                    <td width="40px" class="text-right" style="color: red;"><strong><?= $infoResumo['qtdTotalAtrasos'] ?></strong></td>
                                    <td width="40px" class="text-right" style="color: red;"><strong><?= Helper::getMoney($infoResumo['porcentagemTotalAtrasos']) ?></strong></td>
                                    <td width="40px" class="text-right"><strong><?= Helper::getMoney($infoResumo['valorTotalPagar']) ?></strong></td>
                                    <td width="40px" class="text-right"><strong><?= $infoResumo['qtdTotalPagar'] ?></strong></td>
                                    <td width="40px" class="text-right"><strong><?= Helper::getMoney($infoResumo['porcentagemTotalPagar']) ?></strong></td>
                                </tr>
                                </tbody>
                            </table>
                        </div>
                        <div class="form-group col-sm-3" style="margin-top: 15px;">
                            <label for="banco" class="controller-label">Banco boleto:
                                <strong><span id="descricao"><?= $infoCliente['descricao']; ?></span></strong>
                            </label>
                        </div>
                        <div class="form-group col-sm-3" style="margin-top: 15px;">
                            <label for="indiceReajuste" class="controller-label">ndice reajuste: 
                                <strong><span id="indiceReajuste"><?= $reajuste['descricao'] ?></span></strong>
                            </label>
                        </div>
                        <div class="form-group col-sm-3" style="margin-top: 15px;">
                            <label for="ultimoReajuste" class="controller-label">ltimo reajuste:
                                <strong><span id="dtReajuste"><?= $reajuste['data'] ? Helper::getDate($reajuste['data']).' - '.str_replace('.', ',', $reajuste['indice']).'%' : ''; ?></span></strong>
                            </label>
                        </div>
                    </div>
                    <!--Extrato do cliente-->
                    <div class="tab-pane fade <?= $this->get('opcao') == 'EX' ? 'active' : '' ?> in" id="extratoContrato">
                        <legend>Extrato do Contrato</legend>
                        <div class="table-responsive tableFix">
                            <table class="table table-hover table-condensed order column" cellspacing="0" width="100%">
                                <thead>
                                    <tr>
                                        <th class="text-center">Parcela</th>
                                        <th class="text-center">Vencimento</th>
                                        <th class="text-right">Valor</th>
                                        <th class="text-right">Desconto</th>
                                        <th class="text-right">Acrsc.</th>
                                        <th class="text-right">Data pgto</th>
                                        <th class="text-right">Multa</th>
                                        <th class="text-right">Juros</th>
                                        <th class="text-right">Pago</th>
                                        <th class="text-right">Tipo BX</th>
                                        <th class="text-right">Forma BX</th>
                                        <th class="text-right">Saldo devedor</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($extratoCliente['itens'] as $extrato): ?>
                                        <tr>
                                            <td class="text-center"><?= $extrato['id_parcela'] . '' . $extrato['tp_parcela']; ?></td>
                                            <td class="text-center"><?= $extrato['dt_parcela']; ?></td>
                                            <td class="text-right"><?php echo number_format($extrato['vl_parcela'], 2, ',', '.'); ?></td>
                                            <td class="text-right"><?php echo number_format($extrato['desconto'], 2, ',', '.'); ?></td>
                                            <td class="text-right"><?php echo number_format($extrato['acrescimo'], 2, ',', '.'); ?></td>
                                            <td class="text-right"><?= $extrato['dt_pagamento'] ?></td>
                                            <td class="text-right"><?php echo number_format($extrato['vl_multa'], 2, ',', '.'); ?></td>
                                            <td class="text-right"><?php echo number_format($extrato['vl_juros'], 2, ',', '.'); ?></td>
                                            <td class="text-right"><?php echo number_format($extrato['vl_total_pago'], 2, ',', '.'); ?></td>
                                            <td class="text-right"><?= $extrato['tp_baixa']; ?></td>
                                            <td class="text-right"><?= $extrato['descricao']; ?></td>
                                            <td class="text-right"><?php echo number_format($extrato['saldo'], 2, ',', '.'); ?></td>
                                        </tr>
                                    <?php endforeach; ?>
                                    <tr class="">
                                        <td class=""><strong>Totais</strong></td>
                                        <td class=""></td>
                                        <td class="text-right"><strong class=""><?= $extratoCliente['totais']['total_pagar'] ?></strong></td>
                                        <td class="text-right"><strong class=""><?= $extratoCliente['totais']['total_desconto'] ?></strong></td>
                                        <td class="text-right"><strong class=""><?= $extratoCliente['totais']['total_acrescimo'] ?></strong></td>
                                        <td class="text-right" colspan="2"><strong class=""><?= $extratoCliente['totais']['total_multa'] ?></strong></td>
                                        <td class="text-right"><strong class=""><?= $extratoCliente['totais']['total_juros'] ?></strong></td>
                                        <td class="text-right"><strong class=""><?= $extratoCliente['totais']['total_pago'] ?></strong></td>
                                        <td class=""></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <!-- / .tab-pane -->
                    <div class="tab-pane fade <?= $this->get('opcao') == 'B' ?> in" id="boleto">
                        <legend>Boleto</legend>
                        <div class="col-sm-12">
                            <div class="form-group col-sm-6">
                                <label class="control-label" for="parcelas">
                                    Parcelas:<span class="require" style="color: red">*</span>
                                </label>
                                <select class="form-control select2" name="parcelas[]" required="required" data-placeholder="Selecionar..."
                                        id="parcelas" multiple="multiple" idContrato="<?= $infoCliente['id']; ?>">
                                    <?php if (isset($infoParcelas)): ?>
                                        <option value="<?= $idsParcelas; ?>">Todas parcelas</option>
                                        <?php foreach ($infoParcelas as $parcela) : ?>
                                            <option value="<?= $parcela['id_unico_parcela']; ?>">
                                                <?= 'Parcela: '.$parcela['nr_parcela'].''.$parcela['tp_parcela'].' - Data de Vencimento: '.Helper::getDate($parcela['dt_parcela']); ?>
                                            </option>
                                        <?php endforeach; ?>
                                    <?php endif; ?>
                                </select>
                            </div>
                        </div>
                        <legend>Comunicao</legend>
                        <div class="row" <?php if($this->cliente->fl_comunicacao=='0'){echo 'style="display:none;"';} ?>>
                            <div class="col-sm-6">
                                <div class="form-group col-sm-12">
                                    <label for="contratoDigital" class="control-label">
                                        Enviar E-mail:
                                    </label></br>
                                    <div class="col-sm-3">
                                        <label for="emailSimParcela" class="control-label">Sim </label>
                                        <input type="radio" id="emailSimParcela" class="form-control icheck" name="emailParcela" value="2" />
                                    </div>
                                    <div class="col-sm-3">
                                        <label for="emailNaoParcela" class="control-label">No </label>
                                        <input type="radio" id="emailNao"  class="form-control icheck" name="emailParcela" value="0" checked/>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-group col-sm-12">
                                    <label for="contratoDigital" class="control-label">
                                        Enviar WhatsApp:
                                    </label></br>
                                    <div class="col-sm-3">
                                        <label for="whatsappSimParcela" class="control-label">Sim </label>
                                        <input type="radio" id="whatsappSimParcela" class="form-control icheck" name="whatsappParcela" value="4" />
                                    </div>
                                    <div class="col-sm-3">
                                        <label for="whatsappNaoParcela" class="control-label">No </label>
                                        <input type="radio" id="whatsappNaoParcela"  class="form-control icheck" name="whatsappParcela" value="0" checked/>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-2">
                                    <input type="submit" class="btn btn-primary col-sm-12" id="btnGerar" value="Gerar">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane fade <?= $this->get('opcao') == 'N' ?> in" id="negociacao">
                        <legend>Negociao</legend>
                        <?php if ($negociacao): ?>
                            <div class="table-responsive">
                                <table id="TabelaNegociacao" class="table  table-hover table-condensed order-column"
                                       cellspacing="0" width="100%">
                                    <thead>
                                    <tr>
                                        <th width="60px" class="text-center"><strong>Cdigo</strong></th>
                                        <th width="60px" class="text-center"><strong>Cliente</strong></th>
                                        <th width="60px" class="text-center"><strong>Contrato</strong></th>
                                        <th width="60px" class="text-center"><strong>Tipo</strong></th>
                                        <th width="60px" class="text-center"><strong>Data</strong></th>
                                        <th width="60px" class="text-center"><strong>Data de clculo</strong></th>
                                        <th width="60px" class="text-center"><strong>Aes</strong></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php foreach ($negociacao as $dados): ?>
                                        <tr>
                                            <td class="text-center"><?= $dados['id']; ?></td>
                                            <td class="text-left"><?= $dados['nm_pessoa']; ?></td>
                                            <td class="text-center"><?= $dados['id_contrato']; ?></td>
                                            <td class="text-center"><?= $dados['tp_operacao'] == 'N' ? 'NEGOCIAO' : 'RENEGOCIAO'; ?></td>
                                            <td class="text-center"><?= Helper::getDate($dados['data']); ?></td>
                                            <td class="text-center"><?= Helper::getDate($dados['dataBase']); ?></td>
                                            <td class="text-center">
                                                <a target="_blank" href="index.php?m=fin&c=negociacao&a=emitir&id=<?= $dados['id'] ?>" data-toggle="tooltip" title="IMPRIMIR ANALITICO" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-file-o"></i></a>
                                                <a target="_blank" href="index.php?m=fin&c=negociacao&a=gerarRelatorio&id=<?= $dados['id'] ?>" data-toggle="tooltip" title="IMPRIMIR SINTETICO" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-file-o"></i></a>
                                                <?php $mensagem = "return confirm('Tem certeza que deseja desfazer a negociao " . $dados['id'] . " ?')"; ?>
                                                <a onclick="<?= $mensagem; ?>" href="index.php?m=fin&c=negociacao&a=desfazer&urlquery=<?=urlencode($_SERVER['QUERY_STRING'])?>&flag=<?= $_GET['id'] ?>&id=<?= $dados['id'] ?>" data-toggle="tooltip" title="DESFAZER" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-times"></i></a>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php else: ?>
                            <div><p><strong style="color:red; font-size: 15px;">Nenhuma negociao at o momento.</strong></p></div>
                        <?php endif; ?>
                        <legend>Operao</legend>
                            <button id="btnCobrancaNegociacao" class="btn btn-success">Ir para negociao</button>
                    </div>
                    <div class="tab-pane fade <?= $this->get('opcao') == 'RE' ?> in" id="relacionamento">
                        <legend>Relacionamento <span style=" font-size: 10pt;">(Campos com <span style=" font-size: 10pt; color: red;">*</span> so obrigatrios)</span></legend>
                        <div class="col-sm-12">
                            <div class="form-group col-sm-3">
                                <label class="control-label" for="situacao">
                                    Situao:<span class="require" style="color: #FF0000;">*</span>
                                </label>
                                <select class="form-control select2" id="situacao" name="situacao" required="required" data-placeholder="Escolha a Situao">
                                    <option value=""></option>
                                    <?php foreach ($situacao as $status): ?>
                                        <option value="<?= $status->getIdCampo() ?>">
                                            <?= $status->getDescricao(); ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="form-group col-sm-3">
                                <label class="control-label" for="data">Data:</label>
                                <input type="text" class="form-control data datepicker-input" id="data" name="data" value="<?= Helper::dataParaBrasil(date('Y-m-d')); ?>">
                                <input type="hidden" id="idContratoRelacionamento" value="<?= $infoCliente['id'] ?>">
                            </div>
                            <div class="form-group col-sm-3">
                                <label class="control-label" for="dataRetorno">Data retorno:</label>
                                <input type="text" class="form-control data datepicker-input" id="dataRetorno" name="dataRetorno">
                            </div>
                        </div>
                        <div class="col-sm-12">
                            <div class="form-group col-sm-12">
                                <div class="row">
                                    <div class="col-sm-12">
                                        <label class="control-label" for="assunto">Assunto:<span style="color: #FF0000">*</span></label>
                                        <textarea class="form-control" id="assunto" name="assunto" placeholder="Escreva o assunto do relacionamento aqui" rows="7"></textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <legend>Operaes</legend>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-2">
                                    <a href="#" type="button" id="btnSalvarRelacionamento" class="btn btn-primary col-sm-12 fDesabilitaBtn">Salvar</a>
                                </div>
                                <div class="form-group col-sm-2">
                                    <button href="#" type="button" id="btnCancelarRalacionamento" class="btn btn-danger col-sm-12 fDesabilitaBtn">Cancelar</button>
                                </div>
                            </div>
                        </div>
                        <legend id="legendHistorico">Histrico</legend>
                        <fieldset id="lista_historico" class="contatoIndividual tableFix">
                            <?php
                            if (!is_array($historicos))
                                $historicos = array();

                            foreach ($historicos as $historico):
                                $user = null;
                                if ($historico['usuario'])
                                    $user = Db_Pessoa::find($historico['usuario']);
                                ?>
                                <div class="historico">
                                    Data: <?= Helper::getDate($historico['data']); ?><br>
                                    Assunto: <?= $historico['assunto']; ?><br>
                                    Usuario: <?= (isset($user)) ? $user->getNome() : '' ?>
                                </div>
                                <br/>
                            <?php endforeach; ?>
                        </fieldset>
                    </div>
                    <div class="tab-pane fade <?= $this->get('opcao') == 'COM' ?> in" id="comunicacao">
                        <legend>Comunicao</legend>
                        <div class="row" <?php if($this->cliente->fl_comunicacao=='0'){echo 'style="display:none;"';} ?>>
                            <div class="col-sm-6">
                                <div class="form-group col-sm-12">
                                    <label for="contratoDigital" class="control-label">
                                        Enviar E-mail:
                                    </label></br>
                                    <div class="col-sm-3">
                                        <label for="emailSim" class="control-label">Sim </label>
                                        <input type="radio" id="emailSim" class="form-control icheck" name="email" value="2" />
                                    </div>
                                    <div class="col-sm-3">
                                        <label for="emailNao" class="control-label">No </label>
                                        <input type="radio" id="emailNao"  class="form-control icheck" name="email" value="0" checked/>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="form-group col-sm-12">
                                    <label for="contratoDigital" class="control-label">
                                        Enviar WhatsApp:
                                    </label></br>
                                    <div class="col-sm-3">
                                        <label for="whatsappSim" class="control-label">Sim </label>
                                        <input type="radio" id="whatsappSim" class="form-control icheck" name="whatsapp" value="4" />
                                    </div>
                                    <div class="col-sm-3">
                                        <label for="whatsappNao" class="control-label">No </label>
                                        <input type="radio" id="whatsappNao"  class="form-control icheck" name="whatsapp" value="0" checked/>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <legend>Operaes</legend>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-2">
                                    <input type="button" id="btnEnviar" onclick="enviar()" class="btn btn-success col-sm-12" value="Agendar o envio">
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane fade <?= $this->get('opcao') == 'RE' ?> in" id="encerramento">
                        <legend>Encerramento</legend>
                        <div class="col-sm-12">
                            <div class="checkbox">
                                <div class="form-group col-sm-12">
                                    <label class="control-label">
                                        <input type="radio" class="form-control icheck" name="opcaoEncerramento" id="sucesso" value="S"/>
                                        Realizado com sucesso
                                    </label>
                                </div>
                                <div class="form-group col-sm-12">
                                    <label class="control-label">
                                        <input type="radio" class="form-control icheck" name="opcaoEncerramento" id="fracasso" value="F"/>
                                        No realizado/Sem contato
                                    </label>
                                </div>
                                <div class="form-group col-sm-12">
                                    <label class="control-label">
                                        <input type="radio" class="form-control icheck" name="opcaoEncerramento" id="retomar" value="" checked/>
                                        Retomar contato
                                    </label>
                                </div>
                            </div>
                        </div>
                        <legend>Operaes</legend>
                        <!--Botes do Cobrana Coletiva-->
                        <?php if (!isset($_GET['individual'])): ?>
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="form-group col-sm-2">
                                        <input type="button" id="btnProsseguir" class="btn btn-success col-sm-12 fDesabilitaBtn" value="Prosseguir cobrana">
                                    </div>
                                    <div class="form-group col-sm-2">
                                        <a href="?m=cobranca&c=cobranca&a=listar" type="button" id="btnVoltar" class="btn btn-primary col-sm-12 fDesabilitaBtn">Voltar para a tela inicial</a>
                                    </div>
                                </div>
                            </div>
                        <!--Botes do Cobrana Individual-->
                        <?php else: ?>
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="form-group col-sm-2">
                                        <input type="button" id="finalizarCobranca" class="btn btn-success col-sm-12" value="Finalizar Cobrana">
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                    <!-- / .tab-pane -->
                    <div class="tab-pane fade <?= $this->get('opcao') == 'B2' ?> in" id="boleto2Via">
                        <legend>Dados do boleto</legend>
                        <div class="col-sm-12">
                            <div class="form-group col-sm-4">
                                <label class="control-label" for="boleto">
                                    Parcelas:<span class="require" style="color: red">*</span>
                                </label>
                                <select class="form-control select2 parcelas"
                                        id="parcela2via" name="parcela2via" required="required"
                                        data-placeholder="Selecione a parcela..." idContrato="<?= $infoCliente['id']; ?>">
                                    <option></option>
                                    <?php if (isset($infoParcelas)): ?>
                                        <?php foreach ($infoParcelas as $parcela) : ?>
                                            <option value="<?= $parcela['id_unico_parcela']; ?>">
                                                <?= 'Parcela: '.$parcela['nr_parcela'].''.$parcela['tp_parcela'].' - Data de vencimento: '.Helper::getDate($parcela['dt_parcela']); ?>
                                            </option>
                                        <?php endforeach; ?>
                                    <?php endif; ?>
                                </select>
                            </div>
                            <div class="form-group col-sm-4" id="divValidaBoleto" hidden>
                                <label class="control-label" for="validadeBoleto" style="color: red">
                                    Ateno este boleto ainda est na validade junto ao banco.</br>
                                    Deseja realmente emitir uma segunda via desse boleto valido?
                                </label><br>
                                <div class="form-group col-sm-1" style="width: 100px;">
                                    <label for="sim">Sim</label>
                                    <input type="radio" class="form-control icheck modelo" name="gerarBoleto" id="sim" value="S"/>
                                    <input type="hidden" id="tx_juros" name="tx_juros">
                                </div>
                                <div class="form-group col-sm-1" style="width: 100px;">
                                    <label for="nao">No</label>
                                    <input type="radio" class="form-control icheck modelo" name="gerarBoleto" id="nao" value="N" checked/>
                                </div>
                            </div>
                            <div class="form-group col-sm-3" id="divDescontoBoleto" hidden>
                                <label class="control-label" for="validadeBoleto" style="color: red">
                                    Este contrato possui taxas de juros. Deseja calcular
                                    desconto de antecipao?
                                </label><br/>
                                <div class="form-group col-sm-1" style="width: 100px;">
                                    <label for="sim">Sim</label>
                                    <input type="radio" class="form-control icheck modelo" name="descontoBoleto" id="sim" value="S"/>
                                </div>
                                <div class="form-group col-sm-1" style="width: 100px;">
                                    <label for="nao">No</label>
                                    <input type="radio" class="form-control icheck modelo" name="descontoBoleto" id="nao" value="N" checked/>
                                </div>
                            </div>
                        </div>

                        </div>
                        <div class="col-sm-12">
                            <div class="form-group col-sm-12">
                                <div class="row">
                                    <div class="col-sm-12">
                                        <div class="form-group col-sm-8 reimprimir" hidden>
                                            <label class="control-label" style="color: red">
                                                J existe uma 2 via gerada para a data <b><span id="data2aVia"></span></b>, deseja imprimir novamente? <a href="#" id="link" target="_blank">Imprimir</a>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                    <div id="divBoleto2ViaCobranca" hidden>
                                        <div class="row">
                                            <div class="form-group col-sm-3 " >
                                                <label for="dataNovoVencimento" class="control-label">Data do novo vencimento:
                                                    <span class="require" style="color: red;">*</span>
                                                </label>
                                                <input type="text" class="form-control data datepicker-input" id="dtNovoVencimento" required
                                                    name="dataNovoVencimento"/>
                                            </div>
                                            <div class="form-group col-sm-3">
                                                <label for="valorTitulo" class="control-label">Valor do ttulo:</label>
                                                <input type="text" class="form-control" id="vlTitulo" name="valorTitulo" disabled>
                                                <input type="hidden" id="dataParcelaOriginal">
                                                <input type="hidden" id="tpMulta_vlMulta">
                                                <input type="hidden" id="tpJuros_vlJuros">
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="form-group col-sm-3">
                                                <label for="valorAcrescimo" class="control-label">Acrescimo:</label>
                                                <input type="text" class="form-control money" id="vlAcrescimo"
                                                    name="valorAcrescimo"/>
                                            </div>
                                            <div class="form-group col-sm-3">
                                                <label for="valorDesconto" class="control-label">Desconto:</label>
                                                <input type="text" class="form-control money" id="valor_desconto"
                                                    name="valorDesconto"/>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="form-group col-sm-3">
                                                <label for="valorMulta" class="control-label">Valor da multa:</label>
                                                <input type="text" class="form-control money" id="vlMulta"
                                                    name="valorMulta"/>
                                            </div>
                                            <div class="form-group col-sm-3">
                                                <label for="valorJuros" class="control-label">Juros:</label>
                                                <input type="text" class="form-control money" id="vlJuros">
                                            </div>
                                            <div class="form-group col-sm-3">
                                                <label for="valorAtualParcela" class="control-label">Valor atual da parcela:</label>
                                                <input type="text" class="form-control vlAtualParcela" disabled value="" id="vlAtualDisplay"/>
                                                <input type="hidden" name="vlAtualParcela" id="vlAtualParcela" value="0"/>

                                            </div>
                                        </div>
                                        <legend>Comunicao</legend>
                                        <div class="row" <?php if($this->cliente->fl_comunicacao=='0'){echo 'style="display:none;"';} ?>>
                                            <div class="col-sm-6">
                                                <div class="form-group col-sm-12">
                                                    <label for="contratoDigital" class="control-label">
                                                        Enviar E-mail:
                                                    </label></br>
                                                    <div class="col-sm-3">
                                                        <label for="emailSimSegundaVia" class="control-label">Sim </label>
                                                        <input type="radio" id="emailSimSegundaVia" class="form-control icheck" name="emailSegundaVia" value="2" />
                                                    </div>
                                                    <div class="col-sm-3">
                                                        <label for="emailNaoSegundaVia" class="control-label">No </label>
                                                        <input type="radio" id="emailNao"  class="form-control icheck" name="emailSegundaVia" value="0" checked/>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-sm-6">
                                                <div class="form-group col-sm-12">
                                                    <label for="contratoDigital" class="control-label">
                                                        Enviar WhatsApp:
                                                    </label></br>
                                                    <div class="col-sm-3">
                                                        <label for="whatsappSimSegundaVia" class="control-label">Sim </label>
                                                        <input type="radio" id="whatsappSimSegundaVia" class="form-control icheck" name="whatsappSegundaVia" value="4" />
                                                    </div>
                                                    <div class="col-sm-3">
                                                        <label for="whatsappNaoSegundaVia" class="control-label">No </label>
                                                        <input type="radio" id="whatsappNaoSegundaVia"  class="form-control icheck" name="whatsappSegundaVia" value="0" checked/>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <fieldset>
                                            <legend>Operaes</legend>
                                            <div class="row">
                                                <div class="col-sm-12">
                                                    <div class="form-group col-sm-2">
                                                        <input type="button" id="btnGerar2Via" class="btn btn-primary col-sm-12 fDesabilitaBtn" value="Gerar">
                                                    </div>
                                                </div>
                                            </div>
                                        </fieldset>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </fieldset>
        </div>
    </div>
</div>
<script>
    var dataEnvio = "<?=date('Y-m-d')?>";
</script>
<?php require_once 'layout/includes/footer.php'; ?>
