<?php
class RelatorioCobrancaController extends Controller
{
    protected $tbCobrancaParcela;
    protected $tbParcela;
    protected $tbContrato;
    protected $tbUsuario;

    public function __construct($request)
    {
        parent::__construct($request);

        $this->tbCobrancaParcela = new CobrancaParcelas();
        $this->tbParcela = new Parcela();
        $this->tbContrato = new Contrato();
        $this->tbUsuario = new Db_Usuario();
    }

    public function indexAction()
    {
        $empreendimentos = (new Empreendimento)->getEmpreendimentos();
        //Busca somente os usurios que tem acesso ao cobrana
        $responsaveis = $this->tbUsuario->getDefaultAdapter()->select()
            ->from(array('u' => TB_USUARIO), array('id', 'login'))
            ->join(array('p' => TB_PESSOA), 'u.id = p.id', 'nm_pessoa')
            ->join(array('s' => TB_ACL), 'u.perfilId = s.perfilId', '')
            ->join(array('a' => TB_ACTION), 's.actionId = a.id', '')
            ->where('a.id = "348"')
            ->order('login')
            ->query()->fetchAll();
        
        $this->set('empreendimentos', $empreendimentos);
        $this->set('responsaveis', $responsaveis);

        $this->display('form');
    }

    //Retorna os dados a serem exibidos no relatrio de cobrana.
    public function relatorioAction()
    {
        if ($this->validarRelatorioCobranca())
        {
            $contratos = $this->tbContrato->getDefaultAdapter()->select()
                ->from(array('c' => TB_CONTRATO), 'id')
                ->join(array('l' => TB_LOTES), 'c.id_lote = l.id', '')
                ->join(array('e' => TB_EMPREENDIMENTO), 'l.id_empreendimento = e.id', '');

            if ($_POST['bancoRelatorioCobranca'] != '*')
            {
                $contratos = $contratos->join(array('b' => TB_BANCO), 'c.id_banco = b.id', '')
                    ->where('b.id = ' . $_POST['bancoRelatorioCobranca']);
            }
    
            if ($_POST['clienteRelatorioCobranca'] != '*')
            {
                $contratos = $contratos->where('c.id_pessoa = ' . $_POST['clienteRelatorioCobranca']);
            }
                
            $contratos = $contratos->where('e.id = ' . $_POST['empreendimentoRelatorioCobranca'])->query()->fetchAll();     

            foreach ($contratos as $contrato)
            {
                $idContratos[] = $contrato['id'];
            }
            
            $contratos = implode('","', $idContratos);
            $tpParcelas = implode('","', $_POST['tpParcela']);
            $tpPagamento = implode('","', $_POST['tpPagamento']);

            $parcelas = $this->tbParcela->getDefaultAdapter()->select()
                ->from(array('p' => TB_PARCELA), array('id_parcela_contrato', 'id_contrato', 'id_parcela', 'tp_parcela', 'tp_baixa', 'dt_parcela', 
                            'dt_pagamento', 'dt_credito', 'vl_parcela', 'desconto', 'vl_juros', 'vl_multa', 'pago', 'vl_total_pago', 'obs_baixa','nr_tipo_parcela'))
                ->join(array('cp' => TB_COBRANCA_PARCELAS), 'p.id_parcela_contrato = cp.id_parcela', array('tp_status', 'ds_log', 'id_responsavel', 'dt_cobracao', 'id_cobranca'))
                ->join(array('c' => TB_CONTRATO), 'p.id_contrato = c.id', '')
                ->join(array('pe' => TB_PESSOA), 'c.id_pessoa = pe.id', array('nm_pessoa'))
                ->join(array('l' => TB_LOTES), 'c.id_lote = l.id', array('quadra', 'lote'));

            if($_POST['bancoRelatorioCobranca'] != '*')
            {
                $parcelas = $parcelas->join(array('b' => TB_BANCO), 'c.id_banco = b.id', '')
                            ->where('b.id = ' . $_POST['bancoRelatorioCobranca']);
            }

            $parcelas = $parcelas->where('p.pago = "1"')
                ->where('p.id_contrato IN ("' . $contratos . '")')
                ->where('p.tp_parcela IN ("' . $tpParcelas . '")')
                ->where('p.tp_baixa IN ("' . $tpPagamento . '")');

            // if ($_POST['situacao'])
            // {
            //     $semCobranca = '';
            //     //caso o usuario marque a opcao de situao 'Sem cobrana', a opo  removida do array,
            //     //pois no tem como colocar 'null' na clusula IN do sql.
            //     //E a varivel $semCobranca, serve para indicar que o usurio selecionou a opo 'Sem cobrana'.
            //     foreach ($_POST['situacao'] as $k => $situacao)
            //     {
            //         if ($situacao == 'SC')
            //         {
            //             unset($_POST['situacao'][$k]);
            //             $semCobranca = ' OR tp_status is null';
            //         }
            //     }

            //     $situacao = implode('","', $_POST['situacao']);
            //     $parcelas = $parcelas->where('cp.tp_status IN ("' . $situacao . '")' . $semCobranca);
            //                 // ->where('MAX(cp.id_cobranca)');
            // }

            if ($_POST['quadraRelatorioCobranca'] != '*')
            {
                $parcelas = $parcelas->where('l.id = ' . $_POST['quadraRelatorioCobranca']);
            }

            if ($_POST['dtPagamentoInicial'] && $_POST['dtCreditoInicial'])
            {
                //busca as parcelas de acordo com as datas de pagamento e crdito informadas
                $parcelas = $parcelas->where('p.dt_pagamento BETWEEN "' . Helper::getInputDate($_POST['dtPagamentoInicial']) . '" AND "' . Helper::getInputDate($_POST['dtPagamentoFinal']) . '" AND ' .
                    'p.dt_credito BETWEEN "' . Helper::getInputDate($_POST['dtCreditoInicial']) . '" AND "' . Helper::getInputDate($_POST['dtCreditoFinal']) . '"');
            } elseif ($_POST['dtCreditoInicial'] && $_POST['dtCreditoFinal']) {
                //busca as parcelas de acordo com as datas de crdito informadas
                $parcelas = $parcelas->where('p.dt_credito BETWEEN "' . Helper::getInputDate($_POST['dtCreditoInicial']) . '" AND "' . Helper::getInputDate($_POST['dtCreditoFinal']) . '"');
            } else {
                //busca as parcelas de acordo com as datas de pagamento informadas
                $parcelas = $parcelas->where('p.dt_pagamento BETWEEN "' . Helper::getInputDate($_POST['dtPagamentoInicial']) . '" AND "' . Helper::getInputDate($_POST['dtPagamentoFinal']) . '"');
            }
            
            switch ($_POST['ordem'])
            {
                case 'Q':
                    $parcelas = $parcelas->order(array('quadra', 'lote'));
                    break;
                case 'D':
                    $parcelas = $parcelas->order('dt_pagamento');
                    break;
                case 'P':
                    $parcelas = $parcelas->order('nm_pessoa');
                    break;
            }

            $parcelas = $parcelas->query()->fetchAll();

            if ($parcelas)
            {
                $empreendimento = (new Empreendimento())->fetchRow('id = ' . $_POST['empreendimentoRelatorioCobranca']);
                $dadosCliente = new Db_Cliente();
                $dadosCliente = $dadosCliente->fetchRow()->toArray();
                $dadosCliente['parcerias'] = ParceriaComissao::findByEmpreendimento($_POST['empreendimentoRelatorioCobranca']);

                if ($_POST['dtPagamentoInicial'] && $_POST['dtCreditoInicial'])
                {
                    $dadosCliente['periodoPagamento'] = Helper::dataParaBrasil($_POST['dtPagamentoInicial']) . ' at ' . Helper::dataParaBrasil($_POST['dtPagamentoFinal']);
                    $dadosCliente['periodoCredito'] = Helper::dataParaBrasil($_POST['dtCreditoInicial']) . ' at ' . Helper::dataParaBrasil($_POST['dtCreditoFinal']);
                } elseif ($_POST['dtPagamentoInicial']) {
                    $dadosCliente['periodoPagamento'] = Helper::dataParaBrasil($_POST['dtPagamentoInicial']) . ' at ' . Helper::dataParaBrasil($_POST['dtPagamentoFinal']);
                } else {
                    $dadosCliente['periodoCredito'] = Helper::dataParaBrasil($_POST['dtCreditoInicial']) . ' at ' . Helper::dataParaBrasil($_POST['dtCreditoFinal']);
                }

                if ($_POST['bancoRelatorioCobranca'] != '*') {
                    $dadosCliente['banco'] = Banco::findBanco($_POST['bancoRelatorioCobranca'])->descricao;
                }

                //foreach para realizar um group by nas parcelas.
                foreach ($parcelas as $key => $item) {
                    $keyParcelas[$item['id_parcela_contrato']][$key] = $item;
                }

                $cobrancaRecente = $keyParcelas[array_keys($keyParcelas)[0]][0];

                foreach ($keyParcelas as $k => $chave)
                {
                    foreach ($chave as $y => $item)
                    {
                        if ($cobrancaRecente['id_parcela_contrato'] == $item['id_parcela_contrato'])
                        {
                            // if (strtotime($cobrancaRecente['dt_cobracao']) > strtotime($item['dt_cobracao']))
                            if ($cobrancaRecente['id_cobranca'] > $item['id_cobranca'])
                            {
                                if ($keyParcelas[$k][$y])
                                {
                                    unset($keyParcelas[$k][$y]);
                                }
                            } else {
                                $cobrancaRecente = $item;
                                $keyParcelas[$k] = $item;
                                unset($keyParcelas[$k][$y]);
                            }
                        } else {
                            $cobrancaRecente = $item;
                        }
                    }
                }

                $parcelas = array();

                foreach ($keyParcelas as $parcela)
                {
                    if (count($parcela) < 22)
                    {
                       foreach ($parcela as $item)
                       {
                            $parcelas[] = $item;
                       }
                    } else {
                        $parcelas[] = $parcela;
                    }
                }
 
                foreach ($parcelas as $k => $item)
                {
                    $keyParcelas[$item['id_parcela_contrato']][$k] = $item;
                }

                $_POST['responsavel'] = explode('_', $_POST['responsavel']);

                foreach ($parcelas as $k => $parcela)
                {
                    if ($parcela['id_responsavel'])
                    {
                        $pessoa = (new Pessoa())->fetchRow('id = ' . $parcela['id_responsavel']);

                        if ($_POST['responsavel'][0] == '*' || $_POST['responsavel'][0] == $pessoa['id'])
                        {
                            $parcelas[$k]['ds_log'] = $pessoa['nm_pessoa'];
                        } else {
                            unset($parcelas[$k]);
                        }
                    } else {
                        $aux = explode('-', $parcela['ds_log']);
                        $aux = trim($aux[0]);

                        if ($_POST['responsavel'][0] == '*' || $_POST['responsavel'][1] == $aux)
                        {
                            $parcelas[$k]['ds_log'] = $aux;
                        } else {
                            unset($parcelas[$k]);
                        }
                    }
                }
                //exibe apenas as parcelas com as situaes, selecionadas pelo cliente.
                foreach ($parcelas as $k => $parcela)
                {
                    if ($parcela['tp_status'] == null)
                        $parcela['tp_status'] = 'SC';
                    
                    if (!in_array($parcela['tp_status'], $_POST['situacao']))
                    {   
                        unset($parcelas[$k]);
                    }
                }
                //verifica se foi feita alguma cobranca pelo responsvel selecionado antes de enviar as informaes para o usurio.
                if (!$parcelas)
                {
                    echo json_encode(array('msgErros' => utf8_encode('No existem cobranas para o responsvel selecionado')));
                    exit();
                }

                //foreach para contar os responsveis e o total de cada uma
                foreach ($parcelas as $key => $item) {
                    $keyResponsavel[$item['ds_log']][$key] = $item;
                }

                foreach (array_keys($keyResponsavel) as $responsavel)
                {                    
                    if($_POST['recuperacao'][0] != 'todos')
                    {
                        $valorMinimo = 0;
                        $valorMaximo = 0;

                        foreach ($_POST['recuperacao'] as $recuperacao)
                        {
                            switch ($recuperacao)
                            {
                                case 'ate30':
                                    $valorMinimo = 1;
                                    $valorMaximo = 30;
                                    break;

                                case 'trintaEumSessenta':
                                    $valorMinimo = ($valorMinimo == 0) ? $valorMinimo = 31 : $valorMinimo = $valorMinimo;
                                    $valorMaximo = ($valorMaximo >= 0) ? $valorMaximo = 60 : $valorMaximo = $valorMaximo;
                                    break;
                                
                                case 'sessentaEumNoventa':
                                    $valorMinimo = ($valorMinimo == 0) ? $valorMinimo = 61 : $valorMinimo = $valorMinimo;
                                    $valorMaximo = ($valorMaximo >= 0) ? $valorMaximo = 90 : $valorMaximo = $valorMaximo;
                                    break;

                                case 'noventaEumCentoEvinte':
                                    $valorMinimo = ($valorMinimo == 0) ? $valorMinimo = 91 : $valorMinimo = $valorMinimo;
                                    $valorMaximo = ($valorMaximo >= 0) ? $valorMaximo = 120 : $valorMaximo = $valorMaximo;
                                    break;
                                
                                case 'mais120':
                                    $valorMaximo = 121;
                            }
                        }

                        foreach ($parcelas as $k => $parcela)
                        {
                            $diferencaDatas = strtotime($parcela['dt_pagamento']) - strtotime($parcela['dt_parcela']);
                            $diferencaDatas = round($diferencaDatas / (60 * 60 * 24));

                            if ($valorMaximo < 121)
                            {
                                if ($diferencaDatas >= $valorMaximo || $diferencaDatas <= $valorMinimo)
                                {
                                    unset($parcelas[$k]);
                                }
                            } else {
                                if ($diferencaDatas < $valorMinimo)
                                {
                                    unset($parcelas[$k]);
                                }
                            }
                            
                        }
                    }

                    $vlTotal = 0;
                    $vlTotalSucesso = 0;
                    $qtdSucesso = 0;
                    $vlTotalFracasso = 0;
                    $qtdFracasso = 0;
                    $vlTotalSemCobranca = 0;
                    $qtdSemCobranca = 0;
                    $qtd = 0;

                    foreach ($parcelas as $parcela)
                    {
                        
                        if ($responsavel == $parcela['ds_log'])
                        {
                            switch ($parcela['tp_status'])
                            {
                                case 'S':
                                    $vlTotalSucesso += $parcela['vl_parcela'] + $parcela['vl_juros'] + $parcela['vl_multa'];
                                    $qtdSucesso++;
                                    break;
                                case 'F':
                                    $vlTotalFracasso += $parcela['vl_parcela'] + $parcela['vl_juros'] + $parcela['vl_multa'];
                                    $qtdFracasso++;
                                    break;
                                default:
                                    $vlTotalSemCobranca += $parcela['vl_parcela'] + $parcela['vl_juros'] + $parcela['vl_multa'];
                                    $qtdSemCobranca++;
                                    break;
                            }

                            $vlTotal += $parcela['vl_parcela'] + $parcela['vl_juros'] + $parcela['vl_multa'];
                            $qtd++;
                        }
                    }

                    $totalResponsaveis[] = [
                        'vlTotalSucesso' => $vlTotalSucesso, 
                        'qtdSucesso' => $qtdSucesso,
                        'vlTotalFracasso' => $vlTotalFracasso,
                        'qtdFracasso' => $qtdFracasso,
                        'vlTotalSemCobranca' => $vlTotalSemCobranca,
                        'qtdSemCobranca' => $qtdSemCobranca,
                        'nmResponsavel' => $responsavel, 
                        'vlTotal' => $vlTotal, 
                        'qtdReponsavel' => $qtd,
                        'qtdTotalParcelas' => $qtdSucesso + $qtdFracasso + $qtdSemCobranca];
                }

                //ordena o array pelo valor total cobrando por cada usurio.
                $desc = array_column($totalResponsaveis, 'vlTotal');
                array_multisort($desc, SORT_DESC, $totalResponsaveis);

                $this->set('totalResponsaveis', $totalResponsaveis);
                $this->set('empreendimento', $empreendimento);
                $this->set('clienteAcade', $dadosCliente);
                $this->set('parcelas', $parcelas);
        
                if ($_POST['tipoRelatorio'] == 'pdf')
                {
                    $this->set('tipo', 'pdf');
                    $this->displayMPDF('Relatorio_' . time() . '.pdf');
                } elseif ($_POST['tipoRelatorio'] == 'xls') {
                    
                    foreach ($parcelas as $parcela)
                    {
                        $colunas = [
                            'Cliente',
                            'Quadra',
                            'Lote',
                            'Contrato',
                            'Parcela',
                            'Vencimento',
                            'Data Pagamento',
                            'Valor',
                            'Desconto',
                            'Multa',
                            'Juros',
                            'Responsvel',
                            'Total',
                            'Situao'
                        ];
            
                        if ($parcela['tp_status'] == 'S')
                            $situacao = 'Sucesso';
                        elseif ($parcela['tp_status'] == 'F')
                            $situacao = 'Fracasso';
                        else
                            $situacao = '';
            
                        $linhas[] = [
                            $parcela['nm_pessoa'],
                            $parcela['quadra'],
                            $parcela['lote'],
                            $parcela['id_contrato'],
                            $parcela['nr_tipo_parcela']?$parcela['nr_tipo_parcela']:$parcela['id_parcela'] . '' . $parcela['tp_parcela'],
                            Helper::getDate($parcela['dt_parcela']),
                            Helper::getDate($parcela['dt_pagamento']),
                            Helper::getMoney($parcela['vl_parcela']),
                            Helper::getMoney($parcela['desconto']),
                            Helper::getMoney($parcela['vl_multa']),
                            Helper::getMoney($parcela['vl_juros']),
                            $parcela['ds_log'],
                            Helper::getMoney($parcela['vl_parcela'] + $parcela['vl_multa'] + $parcela['vl_juros']),
                            $situacao
                        ];
                    }
        
                    $this->geraExcel($colunas, $linhas);
                } else {
                    $this->set('tipo', 'html');
                    echo $this->display('relatorio');
                }
            } else {
                echo json_encode(array('msgErros' => utf8_encode('No existem parcelas no perodo informado')));
            }
        }
    }

    public function validarRelatorioCobranca()
    {
        $campos = array('empreendimentoRelatorioCobranca', 'clienteRelatorioCobranca', 'quadraRelatorioCobranca', 'bancoRelatorioCobranca', );

        foreach ($campos as $campo)
        {
            if ($_POST[$campo] == '' || $_POST[$campo] == null)
            {
                switch ($campo)
                {
                    case 'empreendimentoRelatorioCobranca':
                        $msg = 'Selecione o empreendimento.';
                        $this->_helper->addMensagem('data', $msg);
                        break;        
                    case 'clienteRelatorioCobranca':
                        $msg = 'Selecione o cliente.';
                        $this->_helper->addMensagem('data', $msg);
                        break;
                    case 'quadraRelatorioCobranca':
                        $msg = 'Selecione a quadra/lote.';
                        $this->_helper->addMensagem('data', $msg);
                        break;
                    case 'bancoRelatorioCobranca':
                        $msg = 'Selecione o banco.';
                        $this->_helper->addMensagem('data', $msg);
                        break;                    
                }

                $this->_helper->addMensagem($campo, $msg);
            }
        }

        if (count($_POST['tpPagamento']) == 0)
            $this->_helper->addMensagem('tpPagamento', 'Selecione pelo menos um tipo de pagamento.');

        if (count($_POST['tpParcela']) == 0)
            $this->_helper->addMensagem('tpParcela', 'Selecione pelo menos um tipo de parcela.');

        //Testa as datas de pagamento e de credito
        if ($_POST['dtPagamentoInicial'] == '' || $_POST['dtPagamentoFinal'] == '') {
            if ($_POST['dtCreditoInicial'] == '' || $_POST['dtCreditoFinal'] == '') {
                $msg = 'Ao menos um perodo deve ser preenchido.';
                $this->_helper->addMensagem('data', $msg);
            } elseif (strtotime(Helper::getInputDate($_POST['dtCreditoInicial']) . '+4 month') <= strtotime(Helper::getInputDate($_POST['dtCreditoFinal'])) && $_POST['clienteRelatorioCobranca'] == '*') {
                $msg = 'O perodo precisa ser de no mximo 120 dias.';
                $this->_helper->addMensagem('data', $msg);
            }
        } elseif ($_POST['dtCreditoInicial'] == '' || $_POST['dtCreditoFinal'] == '') {
            if ($_POST['dtPagamentoInicial'] == '' || $_POST['dtPagamentoFinal'] == '') {
                $msg = 'Ao menos um perodo deve ser preenchido.';
                $this->_helper->addMensagem('data', $msg);
            } elseif (strtotime(Helper::getInputDate($_POST['dtPagamentoInicial']) . '+4 month') <= strtotime(Helper::getInputDate($_POST['dtPagamentoFinal'])) && $_POST['clienteRelatorioCobranca'] == '*') {
                $msg = 'O perodo precisa ser de no mximo 120 dias.';
                $this->_helper->addMensagem('data', $msg);
            }
        } elseif (strtotime(Helper::getInputDate($_POST['dtPagamentoInicial']) . '+4 month') <= strtotime(Helper::getInputDate($_POST['dtPagamentoFinal'])) && $_POST['clienteRelatorioCobranca'] == '*') {
            $msg = 'O perodo precisa ser de no mximo 120 dias.';
            $this->_helper->addMensagem('data', $msg);
        } elseif (strtotime(Helper::getInputDate($_POST['dtCreditoInicial']) . '+4 month') <= strtotime(Helper::getInputDate($_POST['dtCreditoInicial'])) && $_POST['clienteRelatorioCobranca'] == '*') {
            $msg = 'O perodo precisa ser de no mximo 120 dias.';
            $this->_helper->addMensagem('data', $msg);
        }
        
        //Mensagem de Erros
        if (count($this->_helper->getMensagens()) > 0)  {
            $msgErros = '';
            foreach ($this->_helper->getMensagens() as $msg => $a)
                $msgErros .= utf8_encode($a) . '<br>';
            echo json_encode(array('msgErros' => $msgErros));
        } else {
            return !(count($this->_helper->getMensagens()) > 0);
        }
    }
}