<?php

class CobrancaIndividualController extends Controller {

    private $tb_empreendimento;
    private $tb_parcelas;
    private $tb_cobrancaParcelas;
    public $cliente;

    public function __construct($request) {

        parent::__construct($request);

        $this->tb_empreendimento = new Empreendimento();
        $this->tb_parcelas = new Parcela();
        $this->tb_cobrancaParcelas = new CobrancaParcelas();
        $tb_cliente = new Db_Cliente();
        $this->cliente = $tb_cliente->fetchRow();
    }

    public function indexAction() {
        $this->redir(array('modulo' => 'cobranca', 'controller' => 'cobrancaIndividual', 'action' => 'iniciar'));
    }

    public function iniciarAction() {
        
        $listaItem = $this->tb_empreendimento->getAdapter()->select()
                ->from(array('e' => TB_EMPREENDIMENTO), array('e.nm_empreendimento', 'e.id'));
        //Exibe apenas os empreendimentos os quais o usuario tem acesso
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $listaItem->where("e.id IN({$id})");
                } else {
                    $listaItem->where("1");
                }
            } catch (Exception $e) {
            }
        }
        $listaItem = $listaItem->order('e.nm_empreendimento')
            ->query()->fetchAll();

        $this->set('cliente', $this->cliente);
        $this->set('empreendimentos', $listaItem);
        $this->display('form');
    }

    public function contratoInadimplenteByEmpreendimentoAction() {
        
        $lista = null;

        $contratos = Contrato::byEmpreendimento($_POST['id_empreendimento'], Contrato::CONTRATO_TODOS, 0, array("nm_pessoa", "lote", "quadra", "id"), true);

        foreach ($contratos as $contrato) {
            $lista[] = array('id' => $contrato['id'], 
            'text' => utf8_encode($contrato['nm_pessoa']) . ' Lt: ' . utf8_encode($contrato['lote']). 
            ' Qdr: ' . utf8_encode($contrato['quadra']) . ' - Contrato: ' . $contrato['id']);
        }

        echo json_encode($lista);
    }
    //A cobrana individual s pode ser realizada se o contrato selecionado tiver parcelas na tabela PARCELA.
    public function verificaContratoAction () {

        $contrato = $this->tb_parcelas->getAdapter()->select()
        ->from(array('p' => TB_PARCELA), 'id_contrato')
        ->where('p.id_contrato = ' . $_POST['idContratoIndividual'])
        ->query()->fetch();
        
        echo json_encode($contrato['id_contrato']);
    }

    public function encerramentoCobrancaAction () 
    {
        $idParcelas = str_replace(' ', '', $_POST['idsParcelasAtrasadas']);
        $idParcelas = explode(',', $idParcelas);
        $idParcelas = implode('","', $idParcelas);
        
        $parcelas = $this->tb_parcelas->getDefaultAdapter()->select()
            ->from(['p' => TB_PARCELA], ['id_parcela_contrato', 'id_contrato', 'id_parcela', 'tp_parcela', 'vl_parcela', 'acrescimo', 
                                        'desconto', 'vl_multa', 'vl_juros', 'dt_parcela', 'dt_parcela_2avia', 'nr_tipo_parcela'])
            ->where('p.id_parcela_contrato in ("' . $idParcelas . '")')
            ->query()->fetchAll();

        if ($parcelas)
        {
            foreach ($parcelas as $parcela)
            {
                $parcelaCobranca = (new CobrancaParcelas())->createRow();

                $parcelaCobranca->id_parcela = $parcela['id_parcela_contrato'];
                $parcelaCobranca->id_cobranca = null;
                $parcelaCobranca->id_contrato = $parcela['id_contrato'];
                $parcelaCobranca->nr_parcela = $parcela['id_parcela'];
                $parcelaCobranca->tp_parcela = $parcela['tp_parcela'];
                $parcelaCobranca->vl_parcela = $parcela['vl_parcela'];
                $parcelaCobranca->vl_acrescimo = $parcela['acrescimo'];
                $parcelaCobranca->vl_desconto = $parcela['desconto'];
                $parcelaCobranca->vl_multa = $parcela['vl_multa'];
                $parcelaCobranca->vl_juros = $parcela['vl_juros'];
                $parcelaCobranca->dt_parcela = $parcela['dt_parcela'];
                $parcelaCobranca->dt_cobracao = date('Y-m-d');
                $parcelaCobranca->tp_status = $_POST['opcaoEncerramento'] != '' ? $_POST['opcaoEncerramento'] : null;
                $parcelaCobranca->nr_tipo_parcela = $parcela['nr_tipo_parcela'];
                $parcelaCobranca->dt_parcela_2avia = $parcela['dt_parcela_2avia'] ? $parcela['dt_parcela_2avia'] : null;
                $parcelaCobranca->id_responsavel = Login::getUsuario()->getId();
                $parcelaCobranca->ds_log = Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:i:s') . ' - i';
                $parcelaCobranca->tp_cobranca = 'CI';

                $parcelaCobranca->save();
            }
        }

        echo json_encode(true);
    }
}