<?php

class CobrancaController extends Controller
{
    protected $tb_cobranca;
    protected $tb_empreendimento;
    protected $tb_parcela;
    protected $tb_reajuste;
    protected $tb_contrato;
    protected $tb_negociacao;
    protected $tb_contato;
    protected $tb_cobrancaParcela;
    public $cliente;

    public function __construct($request)
    {
        parent::__construct($request);

        $this->tb_cobranca = new Cobranca();
        $this->tb_empreendimento = new Empreendimento();
        $this->tb_parcela = new Parcela();
        $this->tb_reajuste = new HistoricoReajuste();
        $this->tb_contrato = new Contrato();
        $this->tb_negociacao = new Negociacao();
        $this->tb_contato = new Relacionamento();
        $this->tb_cobrancaParcela = new CobrancaParcelas();
        $tb_cliente = new Db_Cliente();
        $this->cliente = $tb_cliente->fetchRow();
    }

    public function indexAction()
    {
        $this->redir(array("modulo" => "cobranca", "controller" => "cobranca", "action" => "listar"));
    }

    public function listarAction() 
    {
        if ($this->isAjax()) 
        {            
            $listaItem = $this->tb_cobranca->getAdapter()->select()
                ->from(array('c' => TB_COBRANCA), array('c.id_cobranca', 'c.dt_abertura', 'c.dt_encerramento', 'c.tp_ordenacao', 'c.fl_status'))
                ->join(array('e' => TB_EMPREENDIMENTO), 'e.id = c.id_empreendimento', 'e.nm_empreendimento');
            //Exibe apenas os empreendimentos os quais o usuario tem acesso
            if ($_SESSION['usuario']) 
            {
                try {
                    $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                    $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                    if (count($ids)) 
                    {
                        $id = implode(',', $ids);
                        $listaItem->where("e.id IN({$id})");
                    } else {
                        $listaItem->where("1");
                    }
                } catch (Exception $e) {
                }
            }
            $listaItem = $listaItem->order('c.dt_abertura DESC')
                ->query()->fetchAll();

            $lista = array();
            foreach ($listaItem as $item) 
            {
                $acoes = '<div style="width: 90px"></div><div align="center" style="width: 100%;">';
                //Botao Visualizar
                $acoes .= '<span data-toggle="modal" data-target=".mVisualizar"><button type="button" value="' . $item['id_cobranca'] . '" data-toggle="tooltip" title="VISUALIZAR" class="btn btn-default btn-sm btnVisualizar" style="margin-right:5px"><i class="fa fa-eye"></i> </button></span>';

                if ($item['fl_status'] == '0') 
                {
                    $acoes .= '<a disabled data-toggle="tooltip" title="CONTINUAR" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-rotate-right"></i></a>';
                    $acoes .= '<a disabled data-toggle="tooltip" title="ENCERRAR" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-times"></i></a>';
                    $status = '<div class="encerrado label label-danger">Encerrado</div>';
                } else {
                    $acoes .= '<a target="_blank" href="?m=cobranca&c=cobranca&a=iniciar&id=' . $item['id_cobranca'] . '" data-toggle="tooltip" title="CONTINUAR" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-rotate-right"></i></a>';
                    $mensagem = "return confirm('Tem certeza que deseja encerrar a cobrana " . $item['id_cobranca'] . " ?')";
                    $acoes .= '<a onclick="' . $mensagem . '"  href="index.php?m=cobranca&c=cobranca&a=encerrar&id=' . $item['id_cobranca'] . '" data-toggle="tooltip" title="ENCERRAR" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-times"></i></a>';
                    $status = '<div class="emAndamento label label-success">Em andamento</div>';
                }

                switch ($item['tp_ordenacao']) 
                {
                    case 'A':
                        $item['tp_ordenacao'] = 'Aleatrio';
                        break;
                    case 'C':
                        $item['tp_ordenacao'] = 'Cliente';
                        break;
                    case 'Q':
                        $item['tp_ordenacao'] = 'Quadra/Lote';
                        break;
                    case 'M':
                        $item['tp_ordenacao'] = 'Vencimento';
                        break;
                    case 'P':
                        $item['tp_ordenacao'] = 'Crescente de parcelas';
                        break;

                    case 'D':
                        $item['tp_ordenacao'] = 'Decrescente de parcelas';
                        break;    
                }

                switch ($item['fl_status']) 
                {
                    case '1':
                        $status = '<div class="label label-success">Em andamento</div>';
                        break;
                    case '0':
                        $status = '<div class="label label-danger">Encerrado</div>';
                        break;
                }

                $acoes .= '</div>';
                $acoes .= '</div>';

                $lista[] = array(
                    'cobranca' => $item['id_cobranca'],
                    'empreendimento' => utf8_encode($item["nm_empreendimento"]),
                    'abertura' => Helper::getDate($item['dt_abertura']),
                    'encerramento' => Helper::getDate($item['dt_encerramento']),
                    'ordem' => utf8_encode($item['tp_ordenacao']),
                    'status' => utf8_encode($status),
                    'acoes' => utf8_encode($acoes)
                );
            }

            echo json_encode(array(
                'draw' => $_POST['draw'],
                'data' => $lista
            ));

        } else {
            $this->display('listar');
        }
    }

    public function visualizarAction()
    {
        if ($this->isAjax()) 
        {
            $item = $this->tb_cobranca->getCobrancas($_POST['cdItem']);
            echo json_encode($item);
        }
    }

    public function encerrarAction() 
    {
        if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'encerrarCobranca')) {
            $this->redir(array('modulo' => 'cobranca', 'controller' => 'cobranca', 'action' => 'listar'), array('msgErros' => 'fail', 'exception' => 'Voc no tem permisso para acessar essa funcionalidade.'));
            exit;
        }

        if ($_GET['id']) 
        {            
            $cobranca = (new Cobranca())->fetchRow('id_cobranca = '.$_GET['id']);
            
            if ($cobranca) 
            {                
                $cobranca->fl_status = 0;
                $cobranca->dt_encerramento = date('Y-m-d');
                $cobranca->save();
                
                (new RelEmpreendimento())->saveContato(25, date('Y-m-d'), $cobranca['id_empreendimento'], 
                'Log: Cobranca Excluida - Id Cobrana: ' . $cobranca['id_cobranca']. ' - Tipo Ordenao: ' . $cobranca['tp_ordenacao']);
    
                $this->redir(array("modulo" => "cobranca", "controller" => "cobranca", "action" => "listar"), array('success' => 'Cobrana encerrada com sucesso!'));
            } else {
                $this->redir(array("modulo" => "cobranca", "controller" => "cobranca", "action" => "listar"), array('fail' => 'No foi possvel remover a cobrana.'));    
            }
        } else {
            $this->redir(array("modulo" => "cobranca", "controller" => "cobranca", "action" => "listar"), array('fail' => 'No foi possvel realizar esta operao.'));
        }
    }

    public function negociacaoAction() 
    {
        $negociacao = $this->tb_contrato->getAdapter()->select()
            ->from(array('c' => TB_CONTRATO), array('id as idContrato'))
            ->join(array('l' => TB_LOTES), 'c.id_lote = l.id', '')
            ->join(array('e' => TB_EMPREENDIMENTO), 'l.id_empreendimento = e.id', 'id as idEmpreendimento')
            ->where('c.id = '.$_GET['idContrato'])
            ->query()->fetch();

        echo json_encode($negociacao);
    }

    public function adicionarAction()
    {
        if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'novaCobranca')) {
            $this->redir(array('modulo' => 'cobranca', 'controller' => 'cobranca', 'action' => 'listar'), array('msgErros' => 'fail', 'exception' => 'Voc no tem permisso para acessar essa funcionalidade.'));
        }

        if ($this->_isPost) 
        {
            $validaCobranca = $this->tb_cobranca->getAdapter()->select()
                ->from(array('c' => TB_COBRANCA), 'fl_status')
                ->where('c.id_empreendimento = "'.$_POST['id_empreendimento'].'"')
                ->where('c.fl_status = "1"')
                ->query()->fetch();
                //se o usuario clicar em iniciar duas vezes a cobrana  cadastrada duas vezes no banco, este if serve para evitar esse problema.
                
            if ($validaCobranca == null) 
            {
                try {
                    $cobranca = (new Cobranca())->createRow();
                    
                    $cobranca->id_empreendimento = $_POST['id_empreendimento'];
                    $cobranca->id_usuario = Login::getUsuario()->getId();
                    $cobranca->dt_abertura = date('Y-m-d');
                    $cobranca->tp_ordenacao = $_POST['ordenacao_status'];
                    $cobranca->fl_status = '1';
                    $cobranca->ds_log = Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:i:s') . ' - i';
                    $idCobranca = $cobranca->save();
                    
                    (new RelEmpreendimento())->saveContato(24, date('Y-m-d'), $_POST['id_empreendimento'], 
                        'Log: Cobranca Cadastrada - Id Cobrana: ' . $idCobranca. ' - Tipo Ordenao: ' . $_POST['ordenacao_status']);

                    //adiciona as parcelas na tabela COBRANCA_PARCELAS
                    $this->adicionarParcelas($idCobranca, $_POST['id_empreendimento']);

                    $this->redir(array("modulo" => "cobranca", "controller" => "cobranca", "action" => "iniciar"), array("id" => $idCobranca, "ordenacao" => $_POST['ordenacao_status'], "email" => $_POST['email'], "whatsapp" => $_POST['whatsapp']));
                } catch (Exception $e) {
                    $this->redir(array("modulo" => "cobranca", "controller" => "cobranca", "action" => "listar"), array("msg" => "fail", "exception" => $e->getMessage()));
                }
            }
        }

        $empreendimentos = $this->tb_empreendimento->getAdapter()->select()
            ->from(array('e' => TB_EMPREENDIMENTO), array('*'));
        //exibe apenas os empreendimentos os quais o usurio tem acesso
        if ($_SESSION['usuario']) 
        {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);

                if (count($ids)) 
                {
                    $id = implode(',', $ids);
                    $empreendimentos->where("e.id IN({$id})");
                } else {
                    $empreendimentos->where("1");
                }
            } catch (Exception $e) {
            }
        }

        $empreendimentos = $empreendimentos->order('e.nm_empreendimento')->query()->fetchAll();

        $this->set('cliente', $this->cliente);
        $this->set('empreendimentos', $empreendimentos);
        $this->display('form');
    }

    //mtodo para avisar ao usuario que o empreendimento selecionado, j possui cobrana ativa
    public function validaAction() 
    {
        //consulta para verificar se o empreendimento possui contratos inadimplentes
        $parcelas = $this->tb_parcela->getAdapter()->select()
            ->from(array('e' => TB_EMPREENDIMENTO), '')
            ->join(array('l' => TB_LOTES), 'e.id = l.id_empreendimento', '')
            ->join(array('c' => TB_CONTRATO), 'c.id_lote = l.id', array('id'))
            ->join(array('p' => TB_PARCELA), 'c.id = p.id_contrato', array('id_parcela', 'tp_parcela', 'vl_parcela', 'dt_parcela', 'acrescimo', 'desconto', 'vl_juros', 'vl_multa'))
            ->where('p.tp_parcela in ("N", "S", "I", "C", "Q", "A", "G")')
            ->where('p.pago = "0"')
            ->where('p.dt_parcela < "' .date('Y-m-d').'"')
            ->where('e.id = "'.$_POST['id_empreendimento'].'"')
            ->query()->fetch();

        if ($parcelas) 
        {
            //verifica o status da cobrana
            $status = $this->tb_cobranca->getAdapter()->select()
                ->from(array('c' => TB_COBRANCA), 'fl_status')
                ->join(array('e' => TB_EMPREENDIMENTO), 'c.id_empreendimento = e.id', '')
                ->where('e.id = '.$_POST['id_empreendimento'])
                ->where('c.fl_status = "1"')
                ->query()->fetch();

            if ($status['fl_status'] == '1') 
            {
                echo json_encode(array('status' => '1', 'msg' => utf8_encode('O empreendimento j possui uma cobrana ativa, primeiro deve ser finalizada a mesma para poder iniciar outra.')));
            } else {
                echo json_encode(array('status' => '0'));
            }
        } else {
            echo json_encode(array('status' => '1', 'msg' => utf8_encode('O Empreendimento no possui contratos inadimplentes at o momento.')));
        }
    }

    public function iniciarAction() 
    {
        if (!isset($_GET['individual'])) {
            if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'continuarCobranca')) {
                $this->redir(array('modulo' => 'cobranca', 'controller' => 'cobranca', 'action' => 'listar'), array('msgErros' => 'fail', 'exception' => 'Voc no tem permisso para acessar essa funcionalidade.'));
            }
        }

        //busca a cobranca, baseando-se pelo id, que foi informado na url.
        if (isset($_GET['id'])) 
        {
            $cobranca = $this->tb_cobranca->fetchRow('id_cobranca = '.$this->_helper->filters($_GET['id'].' AND fl_status = "1"'));
        }

        //verifica se a cobranca existe, ou se o usurio est fazendo uma cobrana individual.
        if ($cobranca || $_GET['individual'] == 'true') 
        {
            //if para verificar se o usurio esta iniciando pela cobranca individual ou coletiva
            if (!isset($_GET['individual'])) 
            {
                /*
                 cria a lista de contratos referentes a cobrana selecionada.
                 * esse if serve para resetar a lista de contratos, caso o usurio no faa a cobrana de todos os contratos de uma cobrana, e logo em seguida, mude para outra cobrana.*/
                if($_SESSION['idCobranca'] != $_GET['id']) 
                {
                    
                    /*cria a lista de contratos, caso a lista esteja vazia. Este caso s ir ocorrer, em caso
                      da cobrana ser recm criada, ou, caso o usurio clique no boto "Continuar".*/
                    $_SESSION['listaDeContratos'] = $this->criarListaDeContratos($cobranca['id_cobranca'], $cobranca['tp_ordenacao']);
                    $_SESSION['idCobranca'] = $_GET['id'];
                }
            }
            //se o usurio estiver fazendo uma cobrana individual, o idContrato, recebe o id do contrato selecionado
            if ($_GET['idSelectContrato']) 
            {                
                $idContrato = $_GET['idSelectContrato'];

                if ($_SESSION['listaDeContratos'] == null) 
                {
                    $_SESSION['listaDeContratos'] = $this->criarListaDeContratos($idContrato, null);
                }

            } else {
                //idContrato recebe o id da lista de contratos.
                $idContrato = $_SESSION['listaDeContratos'][0];
            }
            //verifica se a cobrana  individual.
            if (isset($_GET['individual'])) 
            {
                //busca todas as parcelas, do contrato.
                $cobrancaParcela = $this->tb_parcela->getAdapter()->select()
                    ->from(array('p' => TB_PARCELA), array('*', 'id_parcela as nr_parcela', 'id_parcela_contrato as id_unico_parcela'))
                    ->join(array('c' => TB_CONTRATO), 'p.id_contrato = c.id', '')
                    ->join(array('l' => TB_LOTES), 'c.id_lote = l.id', array('quadra', 'lote'))
                    ->join(array('pe' => TB_PESSOA), 'c.id_pessoa = pe.id', array('pe.nm_pessoa'))
                    ->join(array('b' => TB_BANCO), 'c.id_banco = b.id', array('conta_corrente', 'agencia', 'tp_multa', 'tp_juros', 'juros', 'multa'))
                    ->where('p.tp_parcela in ("N", "S", "I", "C", "Q", "A", "G")')
                    ->where('c.id = '.$idContrato)
                    ->order('p.dt_parcela')->query()->fetchAll();
                //busca informaes referentes as parcelas atrasadas do contrato atual aba: "Parcelas em atraso" do cobrana individual
                $cobrancaParcelasAtrasadas = $this->tb_parcela->getAdapter()->select()
                    ->from(array('p' => TB_PARCELA), '*')
                    ->join(array('c' => TB_CONTRATO), 'p.id_contrato = c.id', '')
                    ->join(array('l' => TB_LOTES), 'c.id_lote = l.id', array('quadra', 'lote'))
                    ->join(array('pe' => TB_PESSOA), 'c.id_pessoa = pe.id', array('pe.nm_pessoa'))
                    ->join(array('b' => TB_BANCO), 'c.id_banco = b.id', array('conta_corrente', 'agencia', 'tp_multa', 'tp_juros', 'juros', 'multa'))
                    ->where('c.id = '.$idContrato)
                    ->where('p.tp_parcela in ("N", "S", "I", "C", "Q", "A", "G")')
                    ->where('p.pago = "0"')
                    ->where('p.dt_parcela < "' . date('Y-m-d').'"')
                    ->order('p.dt_parcela')->query()->fetchAll();
            } else {
                
                if ($idContrato)
                {
                    //atualiza as parcelas da tabela COBRANCA_PARCELAS
                    $this->atualizarParcelasCobrancaColetiva($idContrato);
                    //$idContrato, recebe o valor da lista novamente, para caso o valor da posicao 0 tenha sido removido, na atualizao (atualizarParcelasCobrancaColetiva())
                    if (!isset($_GET['idSelectContrato']))
                    {
                        $idContrato = $_SESSION['listaDeContratos'][0];
                    }

                    if($idContrato)
                    {
                        //busca informaes referentes as parcelas atrasadas do contrato atual aba: "Parcelas em atraso" do cobrana coletiva
                        $cobrancaParcela = $this->tb_parcela->getAdapter()->select()
                            ->from(array('cp' => TB_COBRANCA_PARCELAS), array('*', 'id_unico_parcela' => 'id_parcela'))
                            ->joinLeft(array('p' => TB_PARCELA), 'cp.id_parcela = p.id_parcela_contrato', 'dt_parcela_2avia as dt_2avia')
                            ->join(array('c' => TB_CONTRATO), 'cp.id_contrato = c.id', '')
                            ->join(array('l' => TB_LOTES), 'c.id_lote = l.id', array('quadra', 'lote'))
                            ->join(array('pe' => TB_PESSOA), 'c.id_pessoa = pe.id', array('pe.nm_pessoa'))
                            ->join(array('b' => TB_BANCO), 'c.id_banco = b.id', array('conta_corrente', 'agencia', 'tp_multa', 'tp_juros', 'juros', 'multa'))
                            ->where('cp.id_cobranca = "'.$this->_helper->filters($_GET['id']).'"')
                            ->where('c.id = '.$idContrato)
                            ->where('tp_status is null')
                            ->order('cp.dt_parcela')->query()->fetchAll();
                    }
                }

            }  
            //verifica se a cobrana possui contratos as serem cobrados.
            if ($cobrancaParcela) 
            {
                //busca informaes do cliente do contrato atual. "Informaes do cliente".
                $infoCliente = $this->tb_contrato->getAdapter()->select()
                    ->from(array('c' => TB_CONTRATO), array('id','id_pessoa','id_banco', 'obs_cobranca'))
                    ->joinLeft(array('l' => TB_LOTES), 'l.id = c.id_lote', array('quadra', 'lote', 'fl_construcao'))
                    //o id do empreendimento est sendo buscado pois o mesmo  enviado para negociao.
                    ->joinLeft(array('e' => TB_EMPREENDIMENTO), 'l.id_empreendimento = e.id', array('nm_empreendimento', 'id as id_empreendimento'))
                    ->joinLeft(array('pe' => TB_PESSOA), 'pe.id = c.id_pessoa', array('cd_cidade', 'nm_pessoa', 'nr_telefone', 'nr_celular', 'nr_recado', 'nr_cep', 'nr_endereco', 'endereco', 'nm_bairro', 'ds_complemento', 'email'))
                    ->joinLeft(array('pf' => TB_PESSOA_FISICA), 'pe.id = pf.id_pessoa', array('nr_cpf'))
                    ->joinLeft(array('pj' => TB_PESSOA_JURIDICA), 'pe.id = pj.id_pessoa', array('nr_cnpj'))
                    ->joinLeft(array('ci' => TB_CIDADE), 'pe.cd_cidade = ci.id', array('nome','uf'))
                    ->joinLeft(array('b' => TB_BANCO), 'b.id = c.id_banco', '')
                    ->joinLeft(array('ta' => TB_AGRUPADA), 'b.cd_banco = ta.idCampo AND idTabela = "9"', array('descricao'))
                    ->where('c.id = '.$idContrato)
                    ->query()->fetch();

                $infoCliente['juridico'] = Juridico::getJuridicoPeloIdContrato($idContrato);
                
                $total = 0;
                $juros = 0;
                $multa = 0;
                $valor = 0;
                $qtdPagas = 0;
                $qtdEmAtraso = 0;
                $qtdAPagar = 0;
                $totalMulta = 0;
                $totalJuros = 0;

                //busca as parcelas do contrato atual.
                $listaParc = $this->tb_parcela->getAdapter()->select()
                    ->from(array('p' => TB_PARCELA), array('id_parcela', 'vl_parcela', 'tp_parcela', 'pago', 'dt_parcela', 'id_contrato'))
                    ->where('p.tp_parcela in ("N", "S", "I", "C", "Q", "A", "G")')
                    ->where('p.id_contrato = "'.$idContrato.'"')
                    ->query()->fetchAll();
                    
                if ($cobrancaParcela) 
                {                    
                    if (isset($_GET['individual'])) 
                    {
                        $parcelasAtrasadas = $cobrancaParcelasAtrasadas;
                    } else {
                        $parcelasAtrasadas = $cobrancaParcela;
                    }

                    //informaes das parcelas a serem exibidas na aba "Parcelas em atraso"
                    foreach ($parcelasAtrasadas as $k => &$p) 
                    {
                        $atraso = Helper::date_diff($p["dt_parcela"], date('Y-m-d'));
                        $p["atraso"] = ($atraso >= 0) ? number_format($atraso, 0) : "0";

                        //Realiza os clculos da multa e juros das parcelas, esse clculo  o mesmo utilizado no relatrio de inadimplentes
                        if ($p['atraso'] > 0) 
                        {                            
                            if ($p['tp_juros'] != 'S') 
                            {
                                $juros = ($p['tp_juros'] == 'P') ? $p['vl_parcela'] * ($p['juros'] / 100) : $p['juros'];
                                $juros *= (int)$atraso;
                            } else {
                                $juros = '0';
                            }
    
                            if ($p['tp_multa'] != 'S') 
                            {
                                $multa = ($p['tp_multa'] == 'P') ? $p['vl_parcela'] * ($p['multa'] / 100) : $p['multa'];
                                $multa = number_format($multa, 2);
                            } else {
                                $multa = '0';
                            }
    
                        } else {
                            $juros = '0';
                            $multa = '0';
                        }
    
                        $valor = $p['vl_parcela'];
                        $total += $p['vl_parcela'];
                        $p['valor'] = $valor;
                        $p['juros'] = $juros;
                        $p['multa'] = $multa;
                        $totalJuros += $juros;
                        $totalMulta += $multa;
    
                        if ($p['pago'] == '1') 
                        {
                            $qtdPagas += $p['vl_parcela'];
                            $p['qtdPagas'] = $qtdAPagar;
                        } 
                        else if ($p['pago'] == '0' && $p['dt_parcela'] < date('Y-m-d')) 
                        {
                            $qtdEmAtraso += $p['vl_parcela'];
                            $p['qtdEmAtraso'] = $qtdEmAtraso;
                        } 
                        else if ($p['pago'] == '0') 
                        {
                            $qtdAPagar += $p['vl_parcela'];
                            $p['qtdAPagar'] = $qtdAPagar;
                        }
                    }
                }

                $valorTotal = array('total' => $total, 'totalComAcrescimos' => $total + $totalJuros + $totalMulta, 'totalMulta' => $totalMulta, 'totalJuros' => $totalJuros);

                $valores = $this->resumoContrato($listaParc);

                //busca a data do ltimo reajuste, para ser exibido na aba, "Resumo de Contrato"
                $reajuste = $this->tb_reajuste->getAdapter()->select()
                    ->from(array('r' => TB_HISTORICO_REAJUSTE), array('data' => 'MAX(data)'))
                    ->join(array('c' => TB_CONTRATO), 'r.idContrato = c.id', '')
                    ->join(array('ie' => TB_INDICE_EMPREENDIMENTO), 'c.id_indice = ie.id_indice_empreendimento', '')
                    ->join(array('ag' => TB_AGRUPADA), 'ag.idCampo = ie.id_indice', 'descricao')
                    ->where('r.idContrato = ' . $idContrato)
                    ->where('ag.idTabela = "12"')
                    ->query()->fetch();

                $indice = $this->tb_reajuste->getAdapter()->select()
                    ->from(array('r' => TB_HISTORICO_REAJUSTE), array('indice'))
                    ->where('r.idContrato = ' . $idContrato)
                    ->order('data DESC')
                    ->query()->fetch();

                $reajuste['indice'] = $indice['indice'];
                
                //busca as negociaes do contrato atual.
                $negociacao = $this->tb_negociacao->getAdapter()->select()
                    ->from(array('n' => TB_NEGOCIACAO), array('id', 'id_contrato', 'tp_operacao', 'data', 'dataBase'))
                    ->join(array('c' => TB_CONTRATO), 'c.id = n.id_contrato', array('fl_fm_pagamento'))
                    ->join(array('p' => TB_PESSOA), 'p.id = c.id_pessoa', array('nm_pessoa'))
                    ->where('n.id_contrato = "'.$idContrato.'"')
                    ->query()->fetchAll();
                    
                //verifica se possui a coluna "pago", somente a consulta da cobrana individual tem esse campo
                //pois busca os dados da tabela PARCELA.
                if (isset($cobrancaParcela[0]['pago'])) 
                {                    
                    foreach ($cobrancaParcela as $parcela) 
                    {    
                        if ($parcela['pago'] == '0') 
                        {
                            $parcelasAPagar[] = $parcela;
                        }
                    }
                } else {
                    $cobrancaParcela = $this->tb_parcela->getAdapter()->select()
                        ->from(array('p' => TB_PARCELA), array('*', 'id_unico_parcela' => 'id_parcela_contrato', 'nr_parcela' => 'id_parcela'))
                        ->join(array('c' => TB_CONTRATO), 'p.id_contrato = c.id', '')
                        ->join(array('l' => TB_LOTES), 'c.id_lote = l.id', array('quadra', 'lote'))
                        ->join(array('pe' => TB_PESSOA), 'c.id_pessoa = pe.id', array('pe.nm_pessoa'))
                        ->join(array('b' => TB_BANCO), 'c.id_banco = b.id', array('conta_corrente', 'agencia', 'tp_multa', 'tp_juros', 'juros', 'multa'))
                        ->where('c.id = '.$idContrato)
                        ->where('p.tp_parcela in ("N", "S", "I", "C", "Q", "A", "G")')
                        ->where('p.pago = "0"')
                        ->order('p.dt_parcela')->query()->fetchAll();
                }
                if(Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'HistoricoCobranca')){
                    $historico = $this->tb_contato->getAdapter()->select()
                        ->from(array('r' => TB_RELACIONAMENTO), array('*'))
                        ->where("r.idContrato = '".$idContrato."'")
                        ->where("r.agr_idStatus = 27")
                        ->order('id DESC','data DESC')->query()->fetchAll();
                        
                    
                }else{
                    $historico = $this->tb_contato->fetchAll("idContrato = '".$idContrato."'", array("data DESC", "id DESC"))->toArray();
                }
                $this->set('contratos', $this->buscaOutrosContratos($infoCliente['id_pessoa'], $infoCliente['id_empreendimento']));
                $this->set('negociacao', $negociacao);
                $this->set('reajuste', $reajuste);
                $this->set('infoResumo', $valores);
                $this->set('infoParcelas', $parcelasAPagar ? $parcelasAPagar : $cobrancaParcela);
                $this->set('infoCliente', $infoCliente);
                $this->set('historicos', $historico);
                $this->set('valorTotalParcelas', $valorTotal);
                //dados do campo Situao da aba Relacionamento.
                $this->set("status", Db_TabelaAgrupada::findByField("idTabela", Db_TabelaAgrupada::TABLE_STATUS_CONTATO, "descricao"));
                $this->set('parcelasAtrasadas', $parcelasAtrasadas);
                $this->set('extratoCliente', $this->extratoCliente($idContrato));

                $this->display('iniciar');
            } else {

                if ($_SESSION['listaDeContratos'] == null)
                {
                    //encerra a cobrana
                    $cobranca = new Cobranca();
                    $status = $cobranca->fetchRow($cobranca->select()
                    ->where('id_cobranca = ?', $_GET['id']));
                    
                    $status->fl_status = '0';
                    $status->dt_encerramento = date('Y-m-d');
                    $status->save();
                }

                $this->redir(array('modulo' => 'cobranca', 'controller' => 'cobranca', 'action' => 'listar'), array('msgErros' => 'fail', 'exception' => 'A cobrana '.$_GET['id'].', no possui contratos inadimplentes.'));
            }
        }
    }

    public function editarAction()
    {
        header("Content-type: text/html; charset=ISO-8859-1");
        $pessoa = (new Pessoa())->fetchRow('id = '.$this->_helper->filters($_GET['idPessoa']));

        $valAntigo = $_GET['valAntigo'];
        $valNovo = $_POST['value'];

        if ($_GET['cdCidade']) 
        {
            $pessoa->cd_cidade = $this->_helper->filters($_GET['cdCidade']);

            $nmCampo = 'Cidade';

            $valAntigo = $_GET['valAntigo'];
            $valNovo = $_GET['valNovo'];
        }

        switch ($_POST['name']) 
        {
            case 'nrTelefone':
                $pessoa->nr_telefone = $this->_helper->filters(utf8_decode($_POST['value']));
                $nmCampo = 'Telefone 1';
                break;
            case 'nrCep':
                $pessoa->nr_cep = $this->_helper->filters(utf8_decode($_POST['value']));
                $nmCampo = 'CEP';
                break;
            case 'nrCelular':
                $pessoa->nr_celular = $this->_helper->filters(utf8_decode($_POST['value']));
                $nmCampo = 'Celular';
                break;
            case 'nmBairro':
                $pessoa->nm_bairro = $this->_helper->filters(utf8_decode($_POST['value']));
                $nmCampo = 'Bairro';
                break;
            case 'nrRecado':
                $pessoa->nr_recado = $this->_helper->filters(utf8_decode($_POST['value']));
                $nmCampo = 'Telefone 3';
                break;
            case 'nmEndereco':
                $pessoa->endereco = $this->_helper->filters(utf8_decode($_POST['value']));
                $nmCampo = 'Endereo';
                break;
            case 'nrEndereco':
                $pessoa->nr_endereco = $this->_helper->filters(utf8_decode($_POST['value']));
                $nmCampo = 'N';
                break;
            case 'dsComplemento':
                $pessoa->ds_complemento = $this->_helper->filters(utf8_decode($_POST['value']));
                $nmCampo = 'Complemento';
                break;
            case 'email':
                $pessoa->email = $this->_helper->filters(utf8_decode($_POST['value']));
                $nmCampo = 'E-mail';
                break;
        }

        (new Relacionamento())->saveContato(67, date('Y-m-d'), $_GET['idContrato'],
            'Log: Alterado '.$nmCampo. ' de '.trim($valAntigo).' para '.utf8_decode($valNovo));

        $pessoa->save();
    }

    public function gerarBoletoAction() 
    {
        $idContrato = $_GET['idContrato'];
        //if idsParcelas == '*', remover todas as parcelas que podem estar no campo, para no duplicar,
        //buscar por todas as parcelas onde o idContrato == $idContrato.
        $idsParcelas = explode(',', $_GET['parcelas']);
        $idsParcelas = implode('","', $idsParcelas);
  
        $parcelas = $this->tb_parcela->getAdapter()->select()
        ->from(array('p' => TB_PARCELA), '*')
        ->where('id_contrato = "'.$idContrato.'"');

        if ($_GET['parcelas'] == '*') 
        {
            $parcelas = $parcelas->where('p.id_parcela_contrato IN ("' . $idsParcelas . '")')->query()->fetchAll();
        } else {
            $parcelas = $parcelas->where('p.id_parcela_contrato IN ("' . $idsParcelas . '")')
                ->query()->fetchAll();
        }

        if ($parcelas == null) 
        {
            $erro = 'Selecione pelo menos uma parcela.';
        }

        $parcelas = array_map(function ($parcela){
            return $parcela['id_parcela_contrato'];
        }, $parcelas);

        $parcelas = implode(',', $parcelas);

        echo json_encode($parcelas);
    }

    public function parcelas2ViaAction() 
    {
        $idContrato = $_GET['idContrato'];
        
        if ($_GET['individual'] == 'null')
        {
            $parcela = $this->tb_cobrancaParcela->getAdapter()->select()
                ->from(array('cp' => TB_PARCELA), array('id_parcela_contrato', 'id_parcela', 
                    'tp_parcela', 'dt_parcela', 'vl_parcela', 'dt_parcela_2avia', 'acrescimo', 'desconto'))
                ->join(array('c' => TB_CONTRATO), 'cp.id_contrato = c.id', array('tx_juros'))
                ->join(array('b' => TB_BANCO), 'c.id_banco = b.id', array('juros', 'multa', 'tp_juros', 'tp_multa'))
                ->where('cp.id_contrato = "'.$idContrato.'"')
                ->where('cp.id_parcela_contrato = "'.$_GET['parcelas'].'"')
                ->query()->fetch();
            
            //busca o campo fl_envio da tabela PARCELA, para verificar se o boleto foi gerado ou no
            $flEnvio = $this->tb_parcela->fetchRow($this->tb_parcela->select()
                ->from(array('par' => TB_PARCELA), array('fl_envio'))
                ->where('id_contrato = ?', $idContrato)
                ->where('id_parcela = ?', $parcela['id_parcela'])
                ->where('tp_parcela = ?', $parcela['tp_parcela']));
            
            $parcela['fl_envio'] = $flEnvio['fl_envio'];
        } else {
            //ao gerar parcela via cobranca, o id da parcela que fica no select de segunda via, no  atualizado,
            //esta consulta serve para atualizar a mesma caso o usurio gere o boleto da parcela pelo cobrana.
            $parcela2Via = new Parcela2Via();
            $parcela2Via = $parcela2Via->getAdapter()->select()
                ->from(array('p2' => TB_PARCELA_2VIA), array('id_parcela', 'id_negociacao', 'tp_parcela'))
                ->where('p2.id_contrato = ' . $idContrato)
                ->where('p2.id_parcela_contrato = ' . $_GET['parcelas'])
                ->query()->fetch();

            $parcela = $this->tb_parcela->getAdapter()->select()
            ->from(array('p' => TB_PARCELA), array('id_parcela_contrato', 'dt_parcela', 'vl_parcela', 'fl_envio', 'dt_parcela_2avia', 'acrescimo as vl_acrescimo', 'desconto as vl_desconto'))
            ->join(array('c' => TB_CONTRATO), 'p.id_contrato = c.id', array('tx_juros'))
            ->join(array('b' => TB_BANCO), 'c.id_banco = b.id', array('juros', 'multa', 'tp_juros', 'tp_multa'))
            ->where('p.id_contrato = "'.$idContrato.'"');

            if (!$parcela2Via)
            {
                $parcela = $parcela->where('p.id_parcela_contrato = ' . $_GET['parcelas']);
            } else {
                $parcela = $parcela->where('p.id_parcela = ' . $parcela2Via['id_parcela'])
                                   ->where('p.tp_parcela = ' . $parcela2Via['tp_parcela'])
                                   ->where('p.id_negociacao = ' . $parcela2Via['id_negociacao'])
                                   ->where('p.id_contrato = ' . $parcela2Via['id_contrato']);
            }

            $parcela = $parcela->query()->fetch();           
        }

        if (!$parcela)
        {
            $erros = utf8_encode('Este Contrato no possui parcelas, a serem pagas.');
        } elseif ($parcela['fl_envio'] == '0') {
            //Testa se as parcelas para segunda via j foram impressas na primeira via
            $erros = utf8_encode('No  permitido emitir segunda via sem que a primeira tenha sido impressa anteriormente.');
        }

        echo json_encode(['msgErros' => $erros,'parcela' => $parcela]);
    }

    public function gerarBoleto2ViaAction() 
    {
        if ($this->_isPost) 
        {
            $idContrato = $_GET['idContrato'];
            $idParcela = $_GET['parcela'];
            
            if ($_GET['individual'] == 'null')
            {
                $parcelaId = $this->tb_cobrancaParcela->getAdapter()->select()
                    ->from(array('cp' => TB_PARCELA), array('id_parcela_contrato', 'dt_parcela_2avia'))
                    ->where('cp.id_contrato = "'.$idContrato.'"')
                    ->where('cp.id_parcela_contrato = "'.$idParcela.'"')
                    ->query()->fetch();
            } else {
                $parcelaId = $this->tb_parcela->getAdapter()->select()
                    ->from(array('p' => TB_PARCELA), array('id_parcela_contrato', 'dt_parcela_2avia'))
                    ->where('p.id_contrato = "'.$idContrato.'"')
                    ->where('p.id_parcela_contrato = "'.$idParcela.'"')
                    ->query()->fetch();
            }

            $dataVencimento = Helper::getInputDate($_GET['dataVencimento']);
            //Alterado condio de data verificao, para ser feita at a data atual do servidor!
            if (!$idParcela) 
            {
                $erros = 'Selecione uma parcela.';
            } elseif (!$parcelaId) 
            {
                $erros = utf8_encode('Este contrato no possui parcelas, a serem pagas');
            } elseif (strtotime($dataVencimento) < strtotime(date("Y-m-d"))) 
            {
                $erros = utf8_encode('A nova data de vencimento no pode ser inferior a data atual');
            }

            echo json_encode(['msgErros' => $erros,'parcela' => $parcelaId]);

        } elseif ($this->_isGet) 
        {
            $this->indexAction();
        }
    }

    public function adicionarParcelas($idCobranca, $idEmpreendimento = null) 
    {
        $parcelas = $this->tb_empreendimento->getAdapter()->select()
            ->from(array('e' => TB_EMPREENDIMENTO), '')
            ->join(array('l' => TB_LOTES), 'e.id = l.id_empreendimento', '')
            ->join(array('c' => TB_CONTRATO), 'c.id_lote = l.id', array('id'))
            ->join(array('p' => TB_PARCELA), 'c.id = p.id_contrato', array('id_parcela_contrato', 'id_parcela', 'tp_parcela', 'vl_parcela', 'dt_parcela', 'dt_parcela_2avia', 'acrescimo', 'desconto', 'vl_juros', 'vl_multa','nr_tipo_parcela'))
            ->where('p.tp_parcela in ("N", "S", "I", "C", "Q", "A", "G")')
            ->where('p.pago = "0"')
            ->where('p.dt_parcela < "' .date('Y-m-d').'"')
            ->where('e.id = "'.$idEmpreendimento.'"')
            ->query()->fetchAll();

        foreach ($parcelas as $p) 
        {
            //salva todas as parcelas de todos os contratos inadimplentes
            $cobrancaParcela = (new CobrancaParcelas())->createRow();

            $cobrancaParcela->id_parcela = $p['id_parcela_contrato'];
            $cobrancaParcela->id_cobranca = $idCobranca;
            $cobrancaParcela->id_contrato = $p['id'];
            $cobrancaParcela->nr_parcela = $p['id_parcela'];
            $cobrancaParcela->tp_parcela = $p['tp_parcela'];
            $cobrancaParcela->vl_parcela = $p['vl_parcela'];
            $cobrancaParcela->vl_acrescimo = $p['acrescimo'];
            $cobrancaParcela->vl_desconto = $p['desconto'];
            $cobrancaParcela->vl_multa = $p['vl_multa'];
            $cobrancaParcela->vl_juros = $p['vl_juros'];
            $cobrancaParcela->dt_parcela = $p['dt_parcela'];
            $cobrancaParcela->nr_tipo_parcela = $p['nr_tipo_parcela'];
            $cobrancaParcela->dt_parcela_2avia = $p['dt_parcela_2avia'] ? $p['dt_parcela_2avia'] : null;
            $cobrancaParcela->ds_log = Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:i:s') . ' - i';
            $cobrancaParcela->save();
        }
    }

    public function resumoContrato($resumoContrato)
    {
        $valores = array();

        foreach ($resumoContrato as &$resumo) 
        {
            switch ($resumo['tp_parcela']) 
            {
                case 'N':
                    $valores['valorTotalN'] += $resumo['vl_parcela'];
                    $valores['qtdTotalN'] += 1;

                    if ($resumo['pago'] == '1') {
                        $valores['pagoTotalN'] += $resumo['vl_parcela'];
                        $valores['pagoQtdN'] += 1;

                    } else if ($resumo['dt_parcela'] < date('Y-m-d')) {
                        $valores['atrasoTotalN'] += $resumo['vl_parcela'];
                        $valores['atrasoQtdN'] += 1;

                    } else if ($resumo['dt_parcela'] >= date('Y-m-d')) {
                        $valores['pagarTotalN'] += $resumo['vl_parcela'];
                        $valores['pagarQtdN'] += 1;
                    }
                    break;
                case 'S':
                    $valores['valorTotalS'] += $resumo['vl_parcela'];
                    $valores['qtdTotalS'] += 1;

                    if ($resumo['pago'] == '1') {
                        $valores['pagoTotalS'] += $resumo['vl_parcela'];
                        $valores['pagoQtdS'] += 1;

                    } else if ($resumo['dt_parcela'] < date('Y-m-d')) {
                        $valores['atrasoTotalS'] += $resumo['vl_parcela'];
                        $valores['atrasoQtdS'] += 1;

                    } else if ($resumo['dt_parcela'] >= date('Y-m-d')) {
                        $valores['pagarTotalS'] += $resumo['vl_parcela'];
                        $valores['pagarQtdS'] += 1;
                    }
                    break;
                case 'I':
                    $valores['valorTotalI'] += $resumo['vl_parcela'];
                    $valores['qtdTotalI'] += 1;

                    if ($resumo['pago'] == '1') {
                        $valores['pagoTotalI'] += $resumo['vl_parcela'];
                        $valores['pagoQtdI'] += 1;

                    } else if ($resumo['dt_parcela'] < date('Y-m-d')) {
                        $valores['atrasoTotalI'] += $resumo['vl_parcela'];
                        $valores['atrasoQtdI'] += 1;

                    } else if ($resumo['dt_parcela'] >= date('Y-m-d')) {
                        $valores['pagarTotalI'] += $resumo['vl_parcela'];
                        $valores['pagarQtdI'] += 1;
                    }
                    break;
                case 'C':
                    $valores['valorTotalC'] += $resumo['vl_parcela'];
                    $valores['qtdTotalC'] += 1;

                    if ($resumo['pago'] == '1') {
                        $valores['pagoTotalC'] += $resumo['vl_parcela'];
                        $valores['pagoQtdC'] += 1;

                    } else if ($resumo['dt_parcela'] < date('Y-m-d')) {
                        $valores['atrasoTotalC'] += $resumo['vl_parcela'];
                        $valores['atrasoQtdC'] += 1;

                    } else if ($resumo['dt_parcela'] >= date('Y-m-d')) {
                        $valores['pagarTotalC'] += $resumo['vl_parcela'];
                        $valores['pagarQtdC'] += 1;
                    }
                    break;
                case 'Q':
                    $valores['valorTotalQ'] += $resumo['vl_parcela'];
                    $valores['qtdTotalQ'] += 1;

                    if ($valores['valorTotalQ'] == 0) {
                        $valores['valorTotalQ'] = 0;
                    }

                    if ($resumo['pago'] == '1') {
                        $valores['pagoTotalQ'] += $resumo['vl_parcela'];
                        $valores['pagoQtdQ'] += 1;

                    } else if ($resumo['dt_parcela'] < date('Y-m-d')) {
                        $valores['atrasoTotalQ'] += $resumo['vl_parcela'];
                        $valores['atrasoQtdQ'] += 1;

                    } else if ($resumo['dt_parcela'] >= date('Y-m-d')) {
                        $valores['pagarTotalQ'] += $resumo['vl_parcela'];
                        $valores['pagarQtdQ'] += 1;
                    }
                    break;
                case 'A':
                    $valores['valorTotalA'] += $resumo['vl_parcela'];
                    $valores['qtdTotalA'] += 1;

                    if ($resumo['pago'] == '1') {
                        $valores['pagoTotalA'] += $resumo['vl_parcela'];
                        $valores['pagoQtdA'] += 1;

                    } else if ($resumo['dt_parcela'] < date('Y-m-d')) {
                        $valores['atrasoTotalA'] += $resumo['vl_parcela'];
                        $valores['atrasoQtdA'] += 1;

                    } else if ($resumo['dt_parcela'] >= date('Y-m-d')) {
                        $valores['pagarTotalA'] += $resumo['vl_parcela'];
                        $valores['pagarQtdA'] += 1;
                    }
                    break;
                case 'G':
                    $valores['valorTotalG'] += $resumo['vl_parcela'];
                    $valores['qtdTotalG'] += 1;

                    if ($resumo['pago'] == '1') {
                        $valores['pagoTotalG'] += $resumo['vl_parcela'];
                        $valores['pagoQtdG'] += 1;

                    } else if ($resumo['dt_parcela'] < date('Y-m-d')) {
                        $valores['atrasoTotalG'] += $resumo['vl_parcela'];
                        $valores['atrasoQtdG'] += 1;

                    } else if ($resumo['dt_parcela'] >= date('Y-m-d')) {
                        $valores['pagarTotalG'] += $resumo['vl_parcela'];
                        $valores['pagarQtdG'] += 1;
                    }
                    break;
            }
        }

        if ($valores['qtdTotalN'] > 0) 
        {
            $valores['porcentagemPagoN'] = $valores['pagoQtdN'] > 0 ? ($valores['pagoQtdN'] / $valores['qtdTotalN']) * 100 : $valores['pagoQtdN'] = 0;
            $valores['porcentagemAtrasoN'] = $valores['atrasoQtdN'] > 0 ? ($valores['atrasoQtdN'] / $valores['qtdTotalN']) * 100 : $valores['atrasoQtdN'] = 0;
            $valores['porcentagemPagarN'] = $valores['pagarQtdN'] > 0 ? ($valores['pagarQtdN'] / $valores['qtdTotalN']) * 100 : $valores['pagarQtdN'] = 0;
        } else {
            $valores['qtdTotalN'] = 0;
            $valores['pagoQtdN'] = 0;
            $valores['atrasoQtdN'] = 0;
            $valores['pagarQtdN'] = 0;
        }

        if ($valores['qtdTotalS'] > 0) 
        {
            $valores['porcentagemPagoS'] = $valores['pagoQtdS'] > 0 ? ($valores['pagoQtdS'] / $valores['qtdTotalS']) * 100 : $valores['pagoQtdS'] = 0;
            $valores['porcentagemAtrasoS'] = $valores['atrasoQtdS'] > 0 ? ($valores['atrasoQtdS'] / $valores['qtdTotalS']) * 100 : $valores['atrasoQtdS'] = 0;
            $valores['porcentagemPagarS'] = $valores['pagarQtdS'] > 0 ? ($valores['pagarQtdS'] / $valores['qtdTotalS']) * 100 : $valores['pagarQtdS'] = 0;
        } else {
            $valores['qtdTotalS'] = 0;
            $valores['pagoQtdS'] = 0;
            $valores['atrasoQtdS'] = 0;
            $valores['pagarQtdS'] = 0;
        }

        if ($valores['qtdTotalI'] > 0) 
        {
            $valores['porcentagemPagoI'] = $valores['pagoQtdI'] > 0 ? ($valores['pagoQtdI'] / $valores['qtdTotalI']) * 100 : $valores['pagoQtdI'] = 0;
            $valores['porcentagemAtrasoI'] = $valores['atrasoQtdI'] > 0 ? ($valores['atrasoQtdI'] / $valores['qtdTotalI']) * 100 : $valores['atrasoQtdI'] = 0;
            $valores['porcentagemPagarI'] = $valores['pagarQtdI'] > 0 ? ($valores['pagarQtdI'] / $valores['qtdTotalI']) * 100 : $valores['pagarQtdI'] = 0;
        } else {
            $valores['qtdTotalI'] = 0;
            $valores['pagoQtdI'] = 0;
            $valores['atrasoQtdI'] = 0;
            $valores['pagarQtdI'] = 0;
        }

        if ($valores['qtdTotalC'] > 0) 
        {
            $valores['porcentagemPagoC'] = $valores['pagoQtdC'] > 0 ? ($valores['pagoQtdC'] / $valores['qtdTotalC']) * 100 : $valores['pagoQtdC'] = 0;
            $valores['porcentagemAtrasoC'] = $valores['atrasoQtdC'] > 0 ? ($valores['atrasoQtdC'] / $valores['qtdTotalC']) * 100 : $valores['atrasoQtdC'] = 0;
            $valores['porcentagemPagarC'] = $valores['pagarQtdC'] > 0 ? ($valores['pagarQtdC'] / $valores['qtdTotalC']) * 100 : $valores['pagarQtdC'] = 0;
        } else {
            $valores['qtdTotalC'] = 0;
            $valores['pagoQtdC'] = 0;
            $valores['atrasoQtdC'] = 0;
            $valores['pagarQtdC'] = 0;
        }

        if ($valores['qtdTotalQ'] > 0) 
        {
            $valores['porcentagemPagoQ'] = $valores['pagoQtdQ'] > 0 ? ($valores['pagoQtdQ'] / $valores['qtdTotalQ']) * 100 : $valores['pagoQtdQ'] = 0;
            $valores['porcentagemAtrasoQ'] = $valores['atrasoQtdQ'] > 0 ? ($valores['atrasoQtdQ'] / $valores['qtdTotalQ']) * 100 : $valores['atrasoQtdQ'] = 0;
            $valores['porcentagemPagarQ'] = $valores['pagarQtdQ'] > 0 ? ($valores['pagarQtdQ'] / $valores['qtdTotalQ']) * 100 : $valores['pagarQtdQ'] = 0;
        } else {
            $valores['qtdTotalQ'] = 0;
            $valores['pagoQtdQ'] = 0;
            $valores['atrasoQtdQ'] = 0;
            $valores['pagarQtdQ'] = 0;
        }

        if ($valores['qtdTotalG'] > 0) 
        {
            $valores['porcentagemPagoG'] = $valores['pagoQtdG'] > 0 ? ($valores['pagoQtdG'] / $valores['qtdTotalG']) * 100 : $valores['pagoQtdG'] = 0;
            $valores['porcentagemAtrasoG'] = $valores['atrasoQtdG'] > 0 ? ($valores['atrasoQtdG'] / $valores['qtdTotalG']) * 100 : $valores['atrasoQtdG'] = 0;
            $valores['porcentagemPagarG'] = $valores['pagarQtdG'] > 0 ? ($valores['pagarQtdG'] / $valores['qtdTotalG']) * 100 : $valores['pagarQtdG'] = 0;
        } else {
            $valores['qtdTotalG'] = 0;
            $valores['pagoQtdG'] = 0;
            $valores['atrasoQtdG'] = 0;
            $valores['pagarQtdG'] = 0;
        }

        if ($valores['qtdTotalA'] > 0) 
        {
            $valores['porcentagemPagoA'] = $valores['pagoQtdA'] > 0 ? ($valores['pagoQtdA'] / $valores['qtdTotalA']) * 100 : $valores['pagoQtdA'] = 0;
            $valores['porcentagemAtrasoA'] = $valores['atrasoQtdA'] > 0 ? ($valores['atrasoQtdA'] / $valores['qtdTotalA']) * 100 : $valores['atrasoQtdA'] = 0;
            $valores['porcentagemPagarA'] = $valores['pagarQtdA'] > 0 ? ($valores['pagarQtdA'] / $valores['qtdTotalA']) * 100 : $valores['pagarQtdA'] = 0;
        } else {
            $valores['qtdTotalA'] = 0;
            $valores['pagoQtdA'] = 0;
            $valores['atrasoQtdA'] = 0;
            $valores['pagarQtdA'] = 0;
        }

        $valores['valorTotalGeral'] = $valores['valorTotalN'] + $valores['valorTotalS'] + $valores['valorTotalI'] + $valores['valorTotalC'] +
            $valores['valorTotalQ'] + $valores['valorTotalG'] + $valores['valorTotalA'];

        $valores['valorTotalPagas'] = $valores['pagoTotalN'] + $valores['pagoTotalS'] + $valores['pagoTotalI'] + $valores['pagoTotalC'] +
            $valores['pagoTotalQ'] + $valores['pagoTotalG'] + $valores['pagoTotalA'];

        $valores['valorTotalAtrasos'] = $valores['atrasoTotalN'] + $valores['atrasoTotalS'] + $valores['atrasoTotalI'] + $valores['atrasoTotalC'] +
            $valores['atrasoTotalQ'] + $valores['atrasoTotalG'] + $valores['atrasoTotalA'];

        $valores['valorTotalPagar'] = $valores['pagarTotalN'] + $valores['pagarTotalS'] + $valores['pagarTotalI'] + $valores['pagarTotalC'] +
            $valores['pagarTotalQ'] + $valores['pagarTotalG'] + $valores['pagarTotalA'];

        $valores['qtdTotalGeral'] = $valores['qtdTotalN'] + $valores['qtdTotalS'] + $valores['qtdTotalI'] + $valores['qtdTotalC'] +
            $valores['qtdTotalQ'] + $valores['qtdTotalG'] + $valores['qtdTotalA'];

        $valores['qtdTotalPagas'] = $valores['pagoQtdN'] + $valores['pagoQtdS'] + $valores['pagoQtdI'] + $valores['pagoQtdC'] +
            $valores['pagoQtdQ'] + $valores['pagoQtdG'] + $valores['pagoQtdA'];

        $valores['qtdTotalAtrasos'] = $valores['atrasoQtdN'] + $valores['atrasoQtdS'] + $valores['atrasoQtdI'] + $valores['atrasoQtdC'] +
            $valores['atrasoQtdQ'] + $valores['atrasoQtdG'] + $valores['atrasoQtdA'];

        $valores['qtdTotalPagar'] = $valores['pagarQtdN'] + $valores['pagarQtdS'] + $valores['pagarQtdI'] + $valores['pagarQtdC'] +
            $valores['pagarQtdQ'] + $valores['pagarQtdG'] + $valores['pagarQtdA'];

        $valores['porcentagemTotalPagas'] = ($valores['qtdTotalPagas'] / $valores['qtdTotalGeral']) * 100;
        $valores['porcentagemTotalAtrasos'] = ($valores['qtdTotalAtrasos'] / $valores['qtdTotalGeral']) * 100;
        $valores['porcentagemTotalPagar'] = ($valores['qtdTotalPagar'] / $valores['qtdTotalGeral']) * 100;

        return $valores;
    }

    public function salvaRelacionamentoAction() 
    {
        $campos = array('idSituacao' => 'Selecione a situao.',
            'assunto' => 'Informe o assunto.');

        foreach ($campos AS $k => $msg) {
            if ($_POST[$k] == '') {
                $this->_helper->addMensagem($k, $msg);
            }
        } 

        if ($_POST['assunto'] && $_POST['idSituacao'])
        {
            $relacionamento = (new Relacionamento())->createRow();

            $relacionamento->idContrato = $_POST['idContrato'];
            $relacionamento->data = Helper::getInputDate($_POST['data']) ? Helper::getInputDate($_POST['data']) : date('Y-m-d');
            $relacionamento->agr_idStatus = $_POST['idSituacao'];
            $relacionamento->assunto = utf8_decode($_POST['assunto']);
            $relacionamento->usuario = Login::getUsuario()->getId();
            $relacionamento->log = Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:i:s') . ' - i';

            if ($_POST['dataRetorno'])
            {
                $relacionamento->fl_encerrado = 0;
                $relacionamento->dt_retorno = Helper::getInputDate($_POST['dataRetorno']) ? Helper::getInputDate($_POST['dataRetorno']) : null;
            } else {
                $relacionamento->fl_encerrado = 1;
                $relacionamento->dt_retorno = null;
            }
            
            $relacionamento->save();
            
            $lista = array(
                'data' => Helper::dataParaBrasil($relacionamento->data),
                'assunto' => utf8_encode($relacionamento->assunto),
                'usuario' => utf8_encode(Db_Pessoa::find($relacionamento['usuario'])->getNome())
            );

            $msg = 'Relacionamento realizado com sucesso';
        }

        //Mensagem de Erros
        if (count($this->_helper->getMensagens()) > 0) 
        {
            $msgErros = '';
            foreach ($this->_helper->getMensagens() as $msg => $a)
                $msgErros .= utf8_encode($a) . '<br>';
            echo json_encode(array('msg' => $msgErros));
        } else {
            echo json_encode(array('msg' => $msg, 'dados' => $lista));
        }

    }

    //funo para encerrar a cobrana.
    public function encerramentoAction() 
    {   
        $idCobranca = $_POST['idCobranca'];
        $idContrato = $_POST['idContrato'];
        $idSelectContrato = $_POST['idContratoSelect'];

        if ($idSelectContrato != 'undefined') 
        {
            //a partir do id do contrato busca a pessoa responsvel pelo mesmo
            $pessoa = $this->tb_contrato->fetchRow('id = ' . $idSelectContrato);
            //busca os contratos da pessoa.
            $contratos = $this->tb_contrato->fetchAll('id_pessoa = ' . $pessoa['id_pessoa'])->toArray();
            
            foreach ($contratos as $contrato) 
            {
                $lista[] = $contrato['id'];
            }
            
            $listaDeContratos = implode('","', $lista);
            //busca os contratos da pessoa que esto na tabela COBRANCA_PARCELAS.
            $contratos = $this->tb_cobrancaParcela->getAdapter()->select()
                ->from(array('cp' => TB_COBRANCA_PARCELAS), array('id_contrato'))
                ->where('id_contrato IN ("'.$listaDeContratos.'")')
                ->group('id_contrato')
                ->query()->fetchAll();
            //cria uma lista de contratos.
            foreach ($contratos as $contrato) 
            {
                $listaIdContratos[] = $contrato['id_contrato'];
            }
            
        } else {
            $listaIdContratos[] = $idContrato;
        }

        foreach ($listaIdContratos as $idContrato) 
        {
            //salvar o tipo de encerramento na tabela cobranca_parcelas na coluna tp_status, com os valores : S, F ou null.
            $parcelas = new CobrancaParcelas();
            $cobrancaParcelas = $parcelas->fetchAll($parcelas->select()
            ->where('id_contrato = ?', $idContrato)
            ->where('id_cobranca = ?', $idCobranca));
            
            foreach ($cobrancaParcelas as $parcela) 
            {
                $parcela->tp_status = ($_POST['opcaoEncerramento'] != "") ? $_POST['opcaoEncerramento'] : null;
                $parcela->dt_cobracao = date('Y-m-d');
                $parcela->id_responsavel = Login::getUsuario()->getId();
                $parcela->tp_cobranca = 'CC';
                $parcela->ds_log = Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:i:s') . ' -u';
                $parcela->save();
            }
        }
        /*
        * Consulta para verificar se ainda possui contratos as serem cobrados na cobranca selecionada.
        * Caso sim, ento o status da cobrana continua "Em andamento".
        * Caso no, ento status da cobrana muda para "Encerrado".*/
        $cobrancaStatus = $parcelas->fetchRow($parcelas->select()
        ->where('id_cobranca = ?', $idCobranca)
        ->where('tp_status is null'));
        
        if (!$cobrancaStatus) 
        {
            $cobranca = new Cobranca();
            $status = $cobranca->fetchRow($cobranca->select()
            ->where('id_cobranca = ?', $idCobranca));
            
            $status->fl_status = '0';
            $status->dt_encerramento = date('Y-m-d');
            $status->save();
            
            $idCobranca = null;
        }
        //remover primeiro contrato da lida de contratos, em caso de sucesso ou fracasso
        if ($_POST['opcaoEncerramento'] == 'S' || $_POST['opcaoEncerramento'] == 'F') 
        {
            //verifica se mais de um contrato est sendo cobrado para o mesmo cliente
            if (count($listaIdContratos) > 0) 
            {                
                foreach ($listaIdContratos as $contrato) 
                {                    
                    foreach ($_SESSION['listaDeContratos'] as $k => $lista) 
                    {
                        if ($contrato == $lista) 
                        {
                            unset($_SESSION['listaDeContratos'][$k]);
                        }
                    }
                }
                
                $_SESSION['listaDeContratos'] = array_values($_SESSION['listaDeContratos']);
            } else {
                //remove o primeiro ndice de um array, re-ordena a lista.
                array_shift($_SESSION['listaDeContratos']);
            }
            
        } else {
            //coloca o contrato no final da lista em caso de, retomar contrato
            if (count($listaIdContratos) > 0) 
            {
                /*remove os contratos (caso seja um usurio que tem mais de um contrato) da lista principal.
                E os adiciona no final da lista.*/
                foreach ($listaIdContratos as $listaContrato) 
                {                    
                    foreach ($_SESSION['listaDeContratos'] as $k => $contrato) 
                    {                        
                        if ($listaContrato == $contrato) 
                        {
                            unset($_SESSION['listaDeContratos'][$k]);
                        }
                    }
                }
                
                $_SESSION['listaDeContratos'] = array_values($_SESSION['listaDeContratos']);
                
                foreach ($listaIdContratos as $contrato) 
                {                    
                    array_push($_SESSION['listaDeContratos'], $contrato);
                }
                
            } else {
                //remove o contrato da lista principal, somente se o usurio tiver apenas um contrato.
                $id = $_SESSION['listaDeContratos'][0];
                array_shift($_SESSION['listaDeContratos']);
                array_push($_SESSION['listaDeContratos'], $id);
            }
        }
        //zera a sesso da cobrana, e salva o log no relacionamento.
        if ($_SESSION['listaDeContratos'] == null) 
        {            
            $_SESSION['idCobranca'] = null;
            
            $cobranca = $this->tb_cobranca->fetchRow('id_cobranca = ' . $_POST['idCobranca']);
            (new RelEmpreendimento())->saveContato(25, date('Y-m-d'), $cobranca['id_cobranca'],
            'Log: Cobranca Finalizada - Id Cobrana: '. $cobranca['id_cobranca']. ' - Tipo Ordenao: ' .$cobranca['tp_ordenacao']);
        }

        echo json_encode(array('idCobranca' => $idCobranca));
    }

    public function obsAction() {
        if ($this->isAjax()) {
            $contrato = new Contrato();
            $obs = $contrato->getContratoById($_POST['id_contrato']);
            $obs->obs_cobranca = utf8_decode($_POST['obs_cobranca']);
            
            $obs->save();
        }
    }

    public function criarListaDeContratos($id, $tipoOrdenacao) 
    {
        if (isset($_GET['individual'])) 
        {
            $tabela = TB_PARCELA;
        } else {
            $tabela = TB_COBRANCA_PARCELAS;
        }

        $contratos = $this->tb_cobrancaParcela->getAdapter()->select()
            ->from(array('cp' => $tabela), array('id_contrato', 'qtdParcelas'=>'COUNT(dt_parcela)'))
            ->join(array('c' => TB_CONTRATO), 'cp.id_contrato = c.id', '')
            ->join(array('p' => TB_PESSOA), 'c.id_pessoa = p.id', 'id')
            ->join(array('l' => TB_LOTES), 'c.id_lote = l.id', '');

            if (isset($_GET['individual'])) 
            {
                $contratos = $contratos->where('cp.id_contrato = '. $id)
                ->group('cp.id_contrato');
            } else {
                $contratos = $contratos->where('cp.id_cobranca = '. $id)
                ->where('cp.tp_status is null')
                ->group('cp.id_contrato');
            }

            switch ($tipoOrdenacao) 
            {
                    
                case 'A': // Aleatrio
                    $contratos = $contratos->query()->fetchAll();
                    shuffle($contratos);
                    break;
                case 'Q': // Quadra/Lote
                    $contratos = $contratos->order(array('l.quadra', 'l.lote'))->query()->fetchAll();
                    break;
                case 'C': // Cliente
                    $contratos = $contratos->order('p.nm_pessoa')->query()->fetchAll();
                    break;
                case 'M': // Vencimento de parcela
                    $contratos = $contratos->order('cp.dt_parcela')->query()->fetchAll();
                    break;
                case 'P': // Crescente de parcelas
                    $contratos = $contratos->query()->fetchAll();
                    function sortByOrder($a, $b) {
                        return $a['qtdParcelas'] >= $b['qtdParcelas'];
                    }
                    usort($contratos, 'sortByOrder');
                    break; 
                case 'D': // Decrescente de parcelas
                    $contratos = $contratos->query()->fetchAll();
                    function sortByOrder($a, $b) {
                        return $a['qtdParcelas'] <= $b['qtdParcelas'];
                    }
                    usort($contratos, 'sortByOrder');
                    break;
                default: {
                    $contratos = $contratos->query()->fetchAll();
                    break;
            }   
        }
        $idContratos = array();

        foreach ($contratos as $contrato) 
        {   
            $idContratos[] = $contrato['id_contrato'];
        }

        return $idContratos;
    }
    //Mtodo para buscar os outros contratos de uma pessoa.
    //1 busca os contratos da pessoas
    //2 se tiver mais de um contrato retorna os mesmos, caso contrario, retorna false.
    public function buscaOutrosContratos($idPessoa, $idEmpreendimento) 
    {        
        $contratos = $this->tb_contrato->getAdapter()->select()
            ->from(array('c' => TB_CONTRATO), array('id'))
            ->join(array('l' => TB_LOTES), 'c.id_lote = l.id', '')
            ->join(array('e' => TB_EMPREENDIMENTO), 'l.id_empreendimento = e.id', '')
            ->where('c.id_pessoa = ' . $idPessoa)
            ->where('e.id = ' . $idEmpreendimento)
            ->query()->fetchAll();

        foreach ($contratos as $contrato) 
        {
            $lista[] = $contrato['id'];
        }

        $lista = implode('","', $lista);
        
        if (count($contratos) > 1) 
        {
            if ($_GET['idSelectContrato'] && isset($_GET['individual'])) 
            {
                $tabela = TB_PARCELA;
            } else {
                $tabela = TB_COBRANCA_PARCELAS;
            }

            $contratosInadimplentes = $this->tb_cobrancaParcela->getAdapter()->select()
            ->from(array('c' => $tabela), array('id_contrato'))
            ->where('c.id_contrato IN ("' . $lista.'")')
            ->group('c.id_contrato')
            ->query()->fetchAll();

            if ($_GET['idSelectContrato']) 
            {
                foreach ($contratosInadimplentes as $inadimplente) 
                {
                    $listaInadimplentes[] = $inadimplente['id_contrato'];
                }
            } else {
                //organiza a lista de contratos que ser passada para o campo de Contrato
                //de acordo com a lista de contratos principal
                foreach ($_SESSION['listaDeContratos'] as $contrato) 
                {                    
                    if ($contratosInadimplentes) 
                    {                        
                        foreach ($contratosInadimplentes as $k => $inadimplente) 
                        {                            
                            if ($contrato == $inadimplente['id_contrato']) 
                            {
                                $listaInadimplentes[] = $contrato;
                                unset($contratosInadimplentes[$k]);
                            }
                        }
                    } else {
                        break;
                    }
                }
            }

            return $listaInadimplentes;
        }else {
            return 0;
        }
    }

    public function validaDataBoletoAction() 
    {
        if (isset($_POST['contratoId']) && $_POST['contratoId'] != 'null')
        {
            $idContrato = $_POST['contratoId'];
        } elseif (isset($_POST['idContratoCobrancaColetiva']) && $_POST['idContratoCobrancaColetiva'] != 'null') {
            $idContrato = $_POST['idContratoCobrancaColetiva'];
        }

        $parcela = $this->tb_parcela->getAdapter()->select()
            ->from(array('p' => TB_PARCELA), array('dt_parcela'))
            ->join(array('c' => TB_CONTRATO), 'p.id_contrato = c.id', '')
            ->join(array('b' => TB_BANCO), 'c.id_banco = b.id', array('qt_dias_permanencia'))
            ->where('p.id_parcela_contrato = "' . $_POST['parcelaId'].'"')
            ->where('p.id_contrato = "' . $idContrato .'"')
            ->query()->fetch();
        
        if ($parcela)
        {
            //concatena a quantidade de dias de permanencia com a palavra ' days'.
            $somaDatas = $parcela['qt_dias_permanencia'].' days';
            //converte o formato da data de brasileiro para americano
            $vencimentoParcela = Helper::dataParaAmericano($parcela['dt_parcela']);
            //soma a data da parcela com a quantidade de dias de permanencia.
            $data = date_create($vencimentoParcela);
            $data = date_add($data, date_interval_create_from_date_string($somaDatas));
            $data = (date_format($data, 'Y-m-d'));
            $parcela['validaBoleto'] = false;
            //verifica se a data  maior do que a data atual.
            if ($data >= date('Y-m-d')) 
            {
                $parcela['validaBoleto'] = true;
            }
        } else {
            $parcela['validaBoleto'] = false;
        }

        echo json_encode($parcela);
    }

    public function atualizarParcelasCobrancaColetiva($idContrato) 
    {   
        $cobrancaParcelas = $this->tb_parcela->getAdapter()->select()
            ->from(array('cp' => TB_COBRANCA_PARCELAS), array('id_parcela', 'nr_parcela', 'tp_parcela', 'vl_parcela', 'vl_acrescimo', 'vl_desconto', 'vl_multa', 'vl_juros', 'dt_parcela', 'dt_parcela_2avia'))
            ->where('cp.id_cobranca = "'.$_GET['id'].'"')
            ->where('cp.id_contrato = '.$idContrato)
            ->where('cp.tp_status is null')
            ->order('cp.dt_parcela')->query()->fetchAll();

        foreach ($cobrancaParcelas as $cobranca)
        {   
            $parcelas[] = $cobranca['id_parcela'];
        }
        
        $parcelas = implode('","', $parcelas);

        $cobrancaParcelasAtrasadas = $this->tb_parcela->getAdapter()->select()
            ->from(array('p' => TB_PARCELA), array('id_parcela_contrato as id_parcela', 'id_parcela as nr_parcela', 'tp_parcela', 'vl_parcela', 'acrescimo as vl_acrescimo', 'desconto as vl_desconto', 'vl_multa', 'vl_juros', 'dt_parcela', 'dt_parcela_2avia'))
            ->where('p.id_contrato = "'.$idContrato.'"')
            ->where('p.id_parcela_contrato IN ("' .$parcelas. '")')
            ->where('p.dt_parcela < "' . date('Y-m-d').'"')
            ->order('p.dt_parcela')->query()->fetchAll();

        if ($cobrancaParcelasAtrasadas)
        {
            foreach ($cobrancaParcelasAtrasadas as $k => $cobranca) 
            {
                foreach ($cobrancaParcelas as $parcela) 
                {
                    if ($parcela['id_parcela'] == $cobranca['id_parcela'] && !in_array($cobranca['tp_parcela'], array("NE", "SE", "IE", "CE", "QE", "AE", "GE", "E"))) 
                    {
                        //compara os valores das tabelas de PARCELA com COBRANCA_PARCELAS
                        $comparaParcelas = array_diff($parcela, $cobranca);
                        
                        //se houve alguma mudana entre as parcelas, a mudana  salva
                        if ($comparaParcelas)
                        {
                            //busca as colunas que tiveram alteraes
                            $chaves = array_keys($comparaParcelas);
                            $i = 0;
                            //busca a parcela em COBRANCA_PARCELAS para atualizar a mesma
                            $parcelaCobranca = (new CobrancaParcelas())->fetchRow('id_parcela = '.$cobranca['id_parcela'] . ' AND id_cobranca = ' . $_GET['id']);

                            foreach ($comparaParcelas as $valor) 
                            {
                                //seta os valores nos seus devidos campos para atualizar a tabela COBRANCA_PARCELAS.
                                $parcelaCobranca->$chaves[$i] = $valor;
                                $i++;   
                            }
    
                            $parcelaCobranca->save();
                            unset($cobrancaParcelasAtrasadas[$k]);
                            continue;
                        } else {
                            unset($cobrancaParcelasAtrasadas[$k]);
                        }
                    }
                    
                }
            }
            //busca as parcelas recm inadimplentes que no estejam em COBRANCA_PARCELAS e adicionas na mesma.
            $parcelasNovas = $this->tb_parcela->getAdapter()->select()
            ->from(array('p' => TB_PARCELA), array('id_parcela_contrato as id_parcela', 'id_parcela as nr_parcela', 'tp_parcela', 'vl_parcela', 'acrescimo as vl_acrescimo', 'desconto as vl_desconto', 'vl_multa', 'vl_juros', 'dt_parcela', 'dt_parcela_2avia','nr_tipo_parcela'))
            ->where('p.id_contrato = "'.$idContrato.'"')
            ->where('p.id_parcela_contrato NOT IN ("' .$parcelas. '")')
            ->where('p.dt_parcela < "' . date('Y-m-d').'"')
            ->where('p.pago = "0"')
            ->where('p.tp_parcela NOT IN ("NE", "SE", "IE", "CE", "QE", "AE", "GE", "E")')
            ->order('p.dt_parcela')->query()->fetchAll();

            if ($parcelasNovas)
            {   
                foreach ($parcelasNovas as $p) 
                {
                    if (!in_array($p['tp_parcela'], array("NE", "SE", "IE", "CE", "QE", "AE", "GE", "E")))
                    {
                        $cobranca = (new CobrancaParcelas())->createRow();
                        
                        $cobranca->id_parcela = $p['id_parcela'];
                        $cobranca->id_cobranca = $_GET['id'];
                        $cobranca->id_contrato = $idContrato;
                        $cobranca->nr_parcela = $p['nr_parcela'];
                        $cobranca->tp_parcela = $p['tp_parcela'];
                        $cobranca->vl_parcela = $p['vl_parcela'];
                        $cobranca->vl_acrescimo = $p['vl_acrescimo'];
                        $cobranca->vl_desconto = $p['vl_desconto'];
                        $cobranca->vl_multa = $p['vl_multa'];
                        $cobranca->vl_juros = $p['vl_juros'];
                        $cobranca->dt_parcela = $p['dt_parcela'];
                        $cobranca->nr_tipo_parcela = $p['nr_tipo_parcela'];
                        $cobranca->dt_parcela_2avia = $p['dt_parcela_2avia'] ? $p['dt_parcela_2avia'] : null;
                        $cobranca->ds_log = Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:i:s') . ' - i';
        
                        $cobranca->save();
                    }
                }
            }
            //remove a parcela da tabela COBRANCA_PARCELAS, caso a parcela em anlise tenha sido paga, excluda da tabela PARCELA ou tenha sido negociada.
            foreach ($cobrancaParcelas as $cobrancaParcela) 
            {
                $verificaSeEstaExcluida = (new Parcela())->fetchRow('id_parcela_contrato = "' . $cobrancaParcela['id_parcela'].'"');
                
                if (!$verificaSeEstaExcluida || $verificaSeEstaExcluida['pago'] == '1' || in_array($verificaSeEstaExcluida['tp_parcela'], array("NE", "SE", "IE", "CE", "QE", "AE", "GE", "E"))) 
                {
                    $excluirCobrancaParcela = new CobrancaParcelas();
                    $excluirCobrancaParcela->delete('id_parcela = ' . $cobrancaParcela['id_parcela']);
                }
            }

            $parcelasCobranca = (new CobrancaParcelas())->fetchAll('id_contrato = ' . $idContrato . ' AND id_cobranca = ' . $_GET['id'])->toArray();

            if (!$parcelasCobranca)
            {
                //remove o contrato da lista de contrato caso o mesmo tenha sido excluido da tabela COBRANCA_PARCELAS
                array_shift($_SESSION['listaDeContratos']); 
            }
        } else {
            //remove o primeiro ndice de um array, re-ordena a lista.
            array_shift($_SESSION['listaDeContratos']);
        }
    }

    public function extratoCliente ($idContrato)
    {
        //busca todos as PARCELAS que possuem o id_contrato igual ao informado no formulario. Query principal.
        $parcelas = $this->tb_parcela->getAdapter()->select()
            ->from(array('p' => TB_PARCELA), '*')
            ->joinLeft(array('ta' => TB_AGRUPADA), 'p.fm_baixa = ta.idCampo', 'descricao')
            ->where('p.id_contrato = ' . $idContrato)
            ->order('p.dt_parcela ASC')
            ->query()->fetchAll();

        //busca os nomes das pessoas e lotes relativo ao contrato selecionado
        $contrato = $this->tb_contrato->getAdapter()->select()
        ->from(array("c" => TB_CONTRATO), '*')
        ->join(array("p" => TB_PESSOA), "c.id_pessoa = p.id", 'nm_pessoa')
        ->join(array("l" => TB_LOTES), "c.id_lote = l.id", array('lote', 'quadra'))
        ->where("c.id = " . $idContrato)
        ->query()->fetch();

        //valores a serem incrementados
        $total_pago = 0;
        $total_a_pagar = 0;
        $total_desconto = 0;
        $total_multa = 0;
        $total_juros = 0;
        $total_acrescimo = 0;
        $totalPagoHeader = 0;

        $itens = array();

        foreach ($parcelas as $item) {

            if ($item['tp_parcela'] == 'S' && $contrato['inclui_sinal_contrato'] == 0) {
                continue;
            }
            if (!$item["vl_parcela"])
                $item["vl_parcela"] = 0.00;
            if (!$item["acrescimo"])
                $item["acrescimo"] = 0.00;
            if (!$item["vl_juros"])
                $item["vl_juros"] = 0.00;
            if (!$item["vl_multa"])
                $item["vl_multa"] = 0.00;
            if (!$item["desconto"])
                $item["desconto"] = 0.00;

            $tipoParcela = array('E', 'NE', 'SE', 'CE', 'IE');
            if ($item['pago'] == 1) {
                //valor do header que no possui acrescimo
                $totalPagoHeader += $item['vl_total_pago'];
                $total_pago += $item['vl_parcela'] + $item['vl_multa'] + $item['vl_juros'] - $item['desconto'];
                $total_acrescimo += $item['acrescimo'];
                $total_desconto += $item['desconto'];
                $total_juros += $item['vl_juros'];
                $total_multa += $item['vl_multa'];
            } else if (!in_array($item['tp_parcela'], $tipoParcela)) {
                $total_a_pagar += $item['vl_parcela'];
                $total_acrescimo += $item['acrescimo'];
                $total_desconto += $item['desconto'];
                $total_juros += $item['vl_juros'];
                $total_multa += $item['vl_multa'];
            }

            $saldo = ($item['vl_parcela'] + $item['vl_juros'] + $item['vl_multa'] - $item['desconto']) - $item['vl_total_pago'];
            $item['saldo'] = ($saldo < 0) ? 0 : $saldo;
            $item['dt_parcela'] = $this->_helper->getDate($item['dt_parcela']);
            $item['dt_pagamento'] = $this->_helper->getDate($item['dt_pagamento']);
            $itens[] = $item;
        }

        // testa se o valor  nulo para no ter problemas com as operaes
        if ($contrato['nr_parcela'] == null) {
            $contrato['nr_parcela'] = 0.00;
        }
        if ($contrato['nr_parcela_sinal'] == null) {
            $contrato['nr_parcela_sinal'] = 0.00;
        }
        if ($contrato['nr_parcela_entrega'] == null) {
            $contrato['nr_parcela_entrega'] = 0.00;
        }
        if ($contrato['nr_intercalada'] == null) {
            $contrato['nr_intercalada'] = 0.00;
        }
        if ($contrato['vl_parcela'] == null) {
            $contrato['vl_parcela'] = 0.00;
        }
        if ($contrato['vl_parcela_sinal'] == null) {
            $contrato['vl_parcela_sinal'] = 0.00;
        }
        if ($contrato['vl_parcela_entrega'] == null) {
            $contrato['vl_parcela_entrega'] = 0.00;
        }
        if ($contrato['vl_intercalada'] == null) {
            $contrato['vl_intercalada'] = 0.00;
        }

        $valor_inicial = $contrato['nr_parcela'] * $contrato['vl_parcela']
            + $contrato['nr_intercalada'] * $contrato['vl_intercalada']
            + $contrato['nr_parcela_entrega'] * $contrato['vl_parcela_entrega'];
        if ($contrato['inclui_sinal_contrato'] == 1) {
            $valor_inicial += $contrato['vl_sinal'];
        }

        //Busca se o contrato possui itens adicionais e os calcula para o total do valor do contrato
        $itensContrato = new ContratoItens();
        $itensContrato = $itensContrato->fetchAll('id_contrato = ' . $contrato['id']);

        if (count($itensContrato) > 0) {
            foreach ($itensContrato as $item) {
                $valor_inicial += ((float)$item['vl_parcela'] * (int)$item['qt_parcelas']);
            }
        }

        $totais['total_pago'] = number_format($total_pago, 2, ',', '.');
            $totais['total_pagar'] = number_format($total_a_pagar, 2, ',', '.');
            $totais['total_desconto'] = number_format($total_desconto, 2, ',', '.');
            $totais['total_multa'] = number_format($total_multa, 2, ',', '.');
            $totais['total_juros'] = number_format($total_juros, 2, ',', '.');
            $totais['total_acrescimo'] = number_format($total_acrescimo, 2, ',', '.');

        return ['itens' => $itens, 'totais' => $totais];
    }
}