<?php
$banco = $this->get("banco");
$empreendimento = $this->get('empreendimento');
$remessa = $this->get('remessa');
$contratos = $this->get('contratos');
?>
<?php require_once 'layout/includes/header.php'; ?>
<?php require_once 'layout/includes/menu.php'; ?>

    <div class="content">
        <div class="page-heading">
            <h1><i class="icon-plus-2"></i> Gerao
                <strong>Arquivo de Remessa</strong></h1>
        </div>
        <div class="widget">
            <div class="widget-content padding">
                <div class="modal fade mVisualizar " tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel"
                     aria-hidden="true">
                    <div class="modal-dialog modal-lg ">
                        <div class="modal-content">

                            <div class="modal-header">
                                <button type="button" class="close" data-dismiss="modal"
                                        aria-hidden="true">&times;
                                </button>
                                <h2 class="modal-title" id="myModalLabel" align="center"><i class="fa fa-eye"></i>
                                    Exibir Parcelas</h2>
                            </div>

                            <div class="modal-body tableFix">
                                <fieldset>
                                    <legend>Parcelas</legend>
                                    <div class="tabela">
                                        <table id="TabelaParcelas"
                                               class="table  table-hover table-condensed order-column"
                                               cellspacing="0" width="100%">
                                            <thead>
                                            <tr>
                                                <th width="80px">
                                                    <div align="center">Parcela</div>
                                                </th>
                                                <th width="80px">
                                                    <div align="center">Contrato</div>
                                                </th>
                                                <th width="60px">
                                                    <div align="center">N Parcela</div>
                                                </th>
                                                <th width="50px">
                                                    <div align="center">Tipo</div>
                                                </th>
                                                <th width="100px">
                                                    <div align="center">Valor</div>
                                                </th>
                                                <th width="80px">
                                                    <div align="center">Vencimento</div>
                                                </th>
                                                <th width="50px">
                                                    <div align="center">Ao</div>
                                                </th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            </tbody>
                                        </table>
                                    </div>
                                </fieldset>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-default" data-dismiss="modal" id="cancelModal">
                                    Fechar
                                </button>
                            </div>

                        </div>
                    </div>
                </div>
                <?= ($_GET["msg"] == "success") ? '<div style="width:100%" class="alert alert-success alert-dismissable">Operao realizada com sucesso.</div>'
                    : (($_GET['exception'] != '') ? '<div style="width:100%" class="alert alert-danger alert-dismissable">' . $_GET['exception'] . '</div>' : '');
                ?>
                <?php if ($this->_helper->getMensagem("erro")): ?>
                    <div style="width:100%"
                         class="alert alert-error alert-dismissable"><?= $this->_helper->getMensagem("erro"); ?></div>
                <?php endif; ?>
                <form action="" method="POST" id="form" enctype="multipart/form-data">
                    <fieldset>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-6">
                                    <label class="control-label" for="id_empreendimento">
                                        Empreendimento:
                                    </label>
                                    <select class="form-control select2 empreendimento_remessa"
                                            id="id_empreendimento" name="id_empreendimento" disabled
                                            data-placeholder="Selecione o Empreendimento">
                                        <option value="<?= $empreendimento['id_empreendimento'] ?>"
                                                selected><?= $empreendimento['nm_empreendimento'] ?></option>
                                    </select>
                                    <input type="hidden" name="id_empreendimento" value="<?= $empreendimento['id_empreendimento'] ?>">
                                </div>
                                <div class="form-group col-sm-2">
                                    <label class="control-label" for="banco_remessa">
                                        Banco:
                                    </label>
                                    <select class="form-control select2 banco_remessa" name="banco" disabled
                                            id="banco_remessa" data-placeholder="Selecione o Banco">
                                        <option value="<?= $banco['id'] ?>" selected>
                                            <?= $banco['descricao'] ?>
                                        </option>
                                    </select>
                                    <input type="hidden" name="banco" value="<?= $banco['id'] ?>">
                                </div>
                                <div class="form-group col-sm-2" hidden>
                                    <label class="control-label" for="tipo">
                                        Tipo de remessa:
                                    </label>
                                    <select class="form-control select2 tipo" name="tipo" disabled
                                            id="tipo" data-placeholder="Selecione o tipo da remessa">
                                        <option value="<?= $remessa['tipo'] ?>" selected>
                                            <?= $remessa['tipo'] ?>
                                        </option>
                                    </select>
                                    <input type="hidden" name="tipo" value="<?= $remessa['tipo'] ?>">
                                </div>
                                <div class="form-group col-sm-2">
                                    <label class="control-label" for="dtInicio">
                                        Data Inicial:
                                    </label>
                                    <input type="text" class="form-control data datepicker-input" id="dtInicio"
                                           name="dtInicio" disabled
                                           value="<?= $remessa['dtInicio']; ?>"/>
                                    <input type="hidden" name="dtInicio" value="<?= $remessa['dtInicio'] ?>">
                                </div>
                                <div class="form-group col-sm-2">
                                    <label class="control-label" for="dtFim">
                                        Data Final:
                                    </label>
                                    <input type="text" class="form-control data datepicker-input" id="dtFim"
                                           name="dtFim" disabled
                                           value="<?= $remessa['dtFim']; ?>"/>
                                    <input type="hidden" name="dtFim" value="<?= $remessa['dtFim'] ?>">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="col-sm-12">
                                    <label style="width: 100%" class="control-label">Tipos de parcelas</label>
                                    <br>
                                    <div class="checkbox">
                                        <label><input type="checkbox" name="tipos[]" id="tpParcelaN" class="icheck" value="N" checked>Normal</label>
                                        <label><input type="checkbox" name="tipos[]" id="tpParcelaS" class="icheck" value="S" checked>Sinal</label>
                                        <label><input type="checkbox" name="tipos[]" id="tpParcelaI" class="icheck" value="I" checked>Intercalada</label>
                                        <label><input type="checkbox" name="tipos[]" id="tpParcelaC" class="icheck" value="C" checked>Chave</label>
                                        <label><input type="checkbox" name="tipos[]" id="tpParcelaG" class="icheck" value="G" checked>Negociada</label>
                                        <label><input type="checkbox" name="tipos[]" id="tpParcelaQ" class="icheck" value="Q" checked>Quitada</label>
                                        <label><input type="checkbox" name="tipos[]" id="tpParcelaA" class="icheck" value="A" checked>Avulsa</label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </fieldset>
                    <div class="table-responsive" style="max-height: 300px">
                        <table id="TabelaListarRemessa"
                               class="table  table-hover table-condensed order-column"
                               cellspacing="0" width="100%">
                            <thead>
                            <tr>
                                <th width="20px">
                                    <div align="center"><input checked id="checkPrincipal" type="checkbox"></div>
                                </th>
                                <th width="40px">
                                    <div align="center">Contrato</div>
                                </th>
                                <th width="40px">
                                    <div align="center">Lote</div>
                                </th>
                                <th width="30px">
                                    <div align="center">Quadra</div>
                                </th>
                                <th width="290px">
                                    Cliente
                                </th>
                                <th style="width: 50px;">
                                    <div align="center">Aes</div>
                                </th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php foreach ($contratos as $contrato) : ?>
                                <tr>
                                    <td align="center">
                                        <input checked id="contrato_<?= $contrato['id'] ?>" class="checkBoxClass"
                                               type="checkbox" name="contratos[]"
                                               value="<?= $contrato['id'] ?>">
                                    </td>
                                    <td align="center">
                                        <?= $contrato['id'] ?>
                                    </td>
                                    <td align="center">
                                        <?= $contrato['lote'] ?>
                                    </td>
                                    <td align="center">
                                        <?= $contrato['quadra'] ?>
                                    </td>
                                    <td width="290px">
                                        <?= $contrato['nm_pessoa'] ?>
                                    </td>
                                    <td align="center">
                                        <span data-toggle="modal" data-target=".mVisualizar">
                                            <button type="button" value="<?= $contrato['id'] ?>" data-toggle="tooltip"
                                                    title="EXIBIR PARCELAS" class="btn btn-default btn-sm btnVisualizar"
                                                    style="margin-right:5px">
                                                <i class="fa fa-eye"></i>
                                            </button>
                                        </span>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                    <select id="parcelasDesvinculadas" name="vinculo[]" multiple hidden>
                    </select>
                    <input type="hidden" name="passo2" value="true">
                    <fieldset>
                        <legend>Operaes</legend>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-2">
                                    <input type="submit" class="btn btn-primary col-sm-12 fDesabilitaBtn" value="Gerar">
                                </div>
                                <div class="form-group col-sm-2">
                                    <a href="?m=<?= $_GET['m'] ?>&c=<?= $_GET['c'] ?>&a=gerarRemessa"
                                       class="btn btn-danger col-sm-12">Voltar </a>
                                </div>
                            </div>
                        </div>
                    </fieldset>
                </form>
            </div>
        </div>
    </div>
<?php require_once 'layout/includes/footer.php'; ?>