<?php 
    require_once 'layout/includes/header.php';
    require_once 'layout/includes/menu.php';

    $empreendimentos = $this->get('empreendimentos');
?>

<div class="content">
    <div class="page-heading">
        <h1><i class="fa fa-file-o"></i> Gerar
            <strong>Relatrio de Boletos</strong></h1>
    </div>
    <div class="widget">
        <div class="widget-content padding">
            <!-- MENSAGENS -->
            <div class="alert alert-danger alert-dismissable msgErros" hidden></div>

            <form action="?m=bo&c=relatorioBoleto&a=relatorio" target="_blank" method="POST" id="form">
                <fieldset>
                    <legend>Informaes do Relatrio de Boletos <span style="font-size: 10pt">(Campos com <span style="color:red">*</span> so obrigatrios)</span>
                        <span data-toggle="modal" data-target=".mVisualizar" style="font-size: 22px;" data-toggle="tooltip" data-placement="top" title="Assista ao tutorial">
                            <svg xmlns="" width="22" height="22" fill="currentColor" class="bi bi-youtube" viewBox="0 0 16 16">
                                <path d="M8.051 1.999h.089c.822.003 4.987.033 6.11.335a2.01 2.01 0 0 1 1.415 1.42c.101.38.172.883.22 1.402l.01.104.022.26.008.104c.065.914.073 1.77.074 1.957v.075c-.001.194-.01 1.108-.082 2.06l-.008.105-.009.104c-.05.572-.124 1.14-.235 1.558a2.01 2.01 0 0 1-1.415 1.42c-1.16.312-5.569.334-6.18.335h-.142c-.309 0-1.587-.006-2.927-.052l-.17-.006-.087-.004-.171-.007-.171-.007c-1.11-.049-2.167-.128-2.654-.26a2.01 2.01 0 0 1-1.415-1.419c-.111-.417-.185-.986-.235-1.558L.09 9.82l-.008-.104A31 31 0 0 1 0 7.68v-.123c.002-.215.01-.958.064-1.778l.007-.103.003-.052.008-.104.022-.26.01-.104c.048-.519.119-1.023.22-1.402a2.01 2.01 0 0 1 1.415-1.42c.487-.13 1.544-.21 2.654-.26l.17-.007.172-.006.086-.003.171-.007A100 100 0 0 1 7.858 2zM6.4 5.209v4.818l4.157-2.408z"></path>
                            </svg>
                        </span>
                    </legend>
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group col-sm-6">
                                <label class="control-label" for="idEmpreendimento">
                                    Empreendimento: <span style="color:red">*</span>
                                </label>

                                <select class="form-control select2" name="idEmpreendimento" id="idEmpreendimento" required data-placeholder="Selecione o empreendimento">
                                    <option value="">Selecione ...</option>
                                    <?php foreach ($empreendimentos as $empreendimento) : ?>
                                        <option value="<?= $empreendimento['id'] ?>"><?= $empreendimento['nm_empreendimento'] ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group col-sm-3">
                                <label for="vencimentoInicial" class="control-label">
                                    Data inicial: <span style="color:red;">*</span>
                                </label>
                                <input type="text" class="form-control data datepicker-input" name="vencimentoInicial" id="vencimentoInicial" placeholder="Informe a data inicial">
                            </div>

                            <div class="form-group col-sm-3">
                                <label for="data" class="control-label">
                                    Data final: <span style="color: red;">*</span>
                                </label>
                                <input type="text" class="form-control data datepicker-input" id="vencimentoFinal" name="vencimentoFinal" placeholder="Informe a data final">
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group col-sm-6" style="margin-right: 11px;">
                                <label class="control-label">
                                    Tipo de relatrio:
                                </label><br>
                                <div class="checkbox" style="white-space: wrap;">
                                    <label for="boletosEmitidos" style="margin-right: 11px; white-space: nowrap;">
                                        <input type="radio" class="form-control icheck" name="tpBoleto" id="boletosEmitidos" value="E" checked/>
                                        Boletos emitidos
                                    </label>
                                    <label for="boletosNaoEmitidos" style="white-space: nowrap;">
                                        <input type="radio" class="form-control icheck" name="tpBoleto" id="boletosNaoEmitidos" value="NE"/>
                                        Boletos no emitidos
                                    </label>
                                </div><br><br>
                                <div class="checkbox" style="white-space: wrap;">
                                    <label for="remessaGerada" style="white-space: nowrap;">
                                        <input type="radio" class="form-control icheck" name="tpBoleto" id="remessaGerada" value="R"/>
                                        Remessas geradas
                                    </label>
                                    <label for="remessaNaoGerada" style="white-space: nowrap;">
                                        <input type="radio" class="form-control icheck" name="tpBoleto" id="remessaNaoGerada" value="RN"/>
                                        Remessas no geradas
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-sm-12">
                            <div class="form-group col-sm-6" style="margin-right: 11px;">
                                <label class="control-label">
                                    Ordenar por:
                                </label></br>

                                <div class="checkbox">
                                    <label for="nomeCliente" style="white-space: nowrap;">
                                        <input type="radio" class="form-control icheck" name="ordem" id="cliente" value="C" checked/>
                                        Nome do cliente
                                    </label>
                                    
                                    <label for="loteQuadra" style="white-space: nowrap;">
                                        <input type="radio" class="form-control icheck" name="ordem" id="loteQuadra" value="L"/>
                                        Lote/Quadra
                                    </label>

                                    <label for="contrato" style="white-space: nowrap;">
                                        <input type="radio" class="form-control icheck" name="ordem" id="contrato" value="CO"/>
                                        Contrato
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>
                </fieldset>

                <fieldset>
                        <legend>Operaes</legend>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-2">
                                    <span class="btn btn-success col-sm-12 " id="btnVisualizar"><i class="fa fa-search" aria-hidden="true"></i> Visualizar</span>
                                </div>

                                <div class="form-group col-sm-2">
                                    <span class="btn btn-primary col-sm-12" id="btnPdf"><i class="fa fa-file-pdf-o" aria-hidden="true"></i> PDF</span>
                                </div>
                                <div name="receiver" overflow="auto" id="receiver" seamless="seamless" ></div>
                            </div>
                        </div>
                </fieldset>
            </form>
        </div>
    </div>
</div>
<div class="modal fade mVisualizar " tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel"
    aria-hidden="true">
    <div class="modal-dialog modal-lg ">
        <div class="modal-content">

            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal"
                        aria-hidden="true">&times;</button>
                <h2 class="modal-title" id="myModalLabel" align="center"><i class="fa fa-book"></i>
                    Tutorial</h2>
            </div>

            <div class="modal-body tableFix" style="max-height:600px;">
                <fieldset >
                    <legend>Relatrio de Boletos - Verificar Boletos e remessas Emitidas</legend>
                    <div class="row" style="margin-right: 0px;margin-left: 0px;">
                        <iframe width="560" height="500" src="https://www.youtube-nocookie.com/embed/tirIVk135KQ?si=fr4Xfel3KpnPSwU_" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>
                    </div>
                    <div></div>
                </fieldset>
            </div>
        </div>
    </div>
</div>
<?= require_once 'layout/includes/footer.php'; ?>