<?php
require_once 'layout/includes/header.php';
require_once 'layout/includes/menu.php';

$listaParcelas = $this->get("listaParcelas");
$api = $this->get("api");
$email = $this->get("email");
$whatsapp = $this->get("whatsapp");
$info = $listaParcelas[0];
$totalParcelas = count($listaParcelas);
if ($_POST['ordenarPor'] == 'C')
    $listaQuebrada = Parcela::ordenacaoDeBoletosPorCliente($listaParcelas);
else
    $listaQuebrada = array_chunk($listaParcelas, 50, true); 
?>
    <div class="content">
        <div class="page-heading">
            <h1><i class="icon-plus-2"></i> Gerar
                <strong>Emisso</strong></h1>
        </div>
        <div class="widget">
            <div class="widget-content padding">
                <?= ($_GET["msg"] == "success") ? '<div style="width:100%" class="alert alert-success alert-dismissable">Operao realizada com sucesso.</div>'
                    : (($_GET['exception'] != '') ? '<div style="width:100%" class="alert alert-danger alert-dismissable">' . $_GET['exception'] . '</div>' : '');
                ?>
                <?php if ($this->_helper->getMensagem("erro")): ?>
                    <div style="width:100%"
                         class="alert alert-error alert-dismissable"><?= $this->_helper->getMensagem("erro"); ?></div>
                <?php endif; ?>
                <form action="" method="POST" id="form" enctype="multipart/form-data">
                    <fieldset>
                        <legend>Emisso de <b><?= $totalParcelas?> Boletos</b></legend>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-6">
                                    <label class="control-label" for="id_empreendimento">
                                        Empreendimento:
                                    </label>
                                    <input type="text" class="form-control empreendimento_remessa"
                                           id="id_empreendimento" name="id_empreendimento" disabled
                                           data-placeholder="Selecione o Empreendimento" value="<?= $info['nm_empreendimento'] ?>">
                                </div>
                                <div class="col-sm-6">
                                    <label class="control-label col-sm-6">Tipos de Parcela:</label>
                                </div>
                                <div class="col-sm-6">
                                    <input disabled class="checkbox icheck" type="checkbox" name="tipos[]" id="tpParcelaN" value="N"
                                        <?= in_array('N',$info['tpParcelas'])?'checked':''?> >
                                    <label for="tpParcelaN" class="control-label">Normal</label>
                                    <input disabled class="checkbox icheck" type="checkbox" name="tipos[]" id="tpParcelaS" value="S"
                                        <?= in_array('S',$info['tpParcelas'])?'checked':''?>>
                                    <label for="tpParcelaS" class="control-label">Sinal</label>
                                    <input disabled class="checkbox icheck" type="checkbox" name="tipos[]" id="tpParcelaI" value="I"
                                        <?= in_array('I',$info['tpParcelas'])?'checked':''?>>
                                    <label for="tpParcelaI" class="control-label">Intercalada</label>
                                    <input disabled class="checkbox icheck" type="checkbox" name="tipos[]" id="tpParcelaC" value="C"
                                        <?= in_array('C',$info['tpParcelas'])?'checked':''?>>
                                    <label for="tpParcelaC" class="control-label">Chave</label>
                                    <input disabled class="checkbox icheck" type="checkbox" name="tipos[]" id="tpParcelaG" value="G"
                                        <?= in_array('G',$info['tpParcelas'])?'checked':''?>>
                                    <label for="tpParcelaG" class="control-label">Negociada</label>
                                    <input disabled class="checkbox icheck" type="checkbox" name="tipos[]" id="tpParcelaQ" value="Q"
                                        <?= in_array('Q',$info['tpParcelas'])?'checked':''?>>
                                    <label for="tpParcelaQ" class="control-label">Quitao</label>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-2">
                                    <label class="control-label" for="dtInicio">
                                        Data Inicial:
                                    </label>
                                    <input type="text" class="form-control data datepicker-input" id="dtInicio"
                                           name="dtInicio" disabled
                                           value="<?= $info['dtInicial'];   ?>"/>
                                </div>
                                <div class="form-group col-sm-2">
                                    <label class="control-label" for="dtFim">
                                        Data Final:
                                    </label>
                                    <input type="text" class="form-control data datepicker-input" id="dtFim"
                                           name="dtFim" disabled
                                           value="<?= $info['dtFinal']; ?>"/>
                                </div>
                                <div class="form-group col-sm-5">
                                    <label class="control-label" for="banco_remessa">
                                        Banco:
                                    </label>
                                    <input type="text" class="form-control banco_remessa" name="banco" disabled
                                           id="banco_remessa" data-placeholder="Selecione o Banco" value="<?= $info['nmBanco'].' Ag.: '.$info['agencia'].'-'.$info['agencia_dv'].' - Cc: '.$info['conta_corrente'].'-'.$info['conta_corrente_dv']?>">
                                </div>
                            </div>
                        </div>
                        <input style="display:none" id="idBanco" value="<?=$_POST['banco']?>">
                        <input style="display:none" id="idContrato" value="<?=$_POST['contrato'][0]?>">
                        <input style="display:none" id="assuntoEmail" value="<?=$email['assunto']?>">
                    </fieldset>
                    <div class="row">

                    <?php
                        foreach ($listaQuebrada as $listaParcela) :
                            $idsParcelas = '';
                            foreach($listaParcela as $parcela) :
                                if ($idsParcelas != '')
                                    $idsParcelas .= ',';
                                $idsParcelas .= $parcela['id_parcela_contrato'];?>
                            <?php endforeach;?>
                        
                        <?php 
                            $nmDominio = "";
                            $url = explode('.', $_SERVER['HTTP_HOST']);
                            if ($url[0] == 'www') {
                                $nmDominio = $url[1];
                            } else {
                                $nmDominio = $url[0];
                            }
                            $url = "?m=bo&c=emissao&a=gerarBoleto&modelo=".$info['modelo']."&idsParcelas=".$idsParcelas;
                            if($info['cd_banco'] =='133'){
                                $url = "https://".$nmDominio.".acadeone.com.br/acadelotear/?m=sc&c=layout&a=tokenCresol&modelo=".$info['modelo']."&idsParcelas=".$idsParcelas;
                            
                                $url = "https://cresolauth.governarti.com.br/auth/realms/cresol/protocol/openid-connect/auth?response_type=token&client_id=cresolApi&redirect_uri=".urlencode($url);
                            }
                        ?>
                        <div class="col-sm-3 blocoLink">
                            <a class="link" href="<?= $url?>" target="_blank">
                                <div class="widget darkblue-2 animated fadeInDown">
                                    <div class="widget-content padding height" >
                                        <div class="widget-icon" style="padding-top: 15px;">
                                            <i class="glyphicon glyphicon-barcode"></i>
                                        </div>
                                        <div class="text-box" style="padding-top: 15px;">
                                            <?php if ($_POST['ordenarPor'] == 'C'): ?>
                                                <p class="maindata"><b><span><?= $listaParcela[0]['nm_pessoa'] ?></span></b></p>
                                            <?php endif; ?>
                                            <p class="maindata"><b> <b><?= count($listaParcela)?> Boletos</span></b></b></p>
                                            <p><span style="font-size: 12px;"><b>CLIQUE AQUI PARA IMPRIMIR</b> </p>
                                        </div>
                                    </div>
                                </div>
                            </a>
                        </div>  
                        <?php endforeach; ?>
                    </div>  
                    <?php if($_POST["email"]||$_POST["whatsapp"]):?>

                        <input hidden id="idEmail" value="<?=$_POST['email']?>">
                        <input hidden id="idWhatsApp" name="idWhatsApp" value="<?=$_POST["whatsapp"]?>">
                    <div class="row">
                        <div class="col-sm-12">
                            <table class="table" id="listaEmails">
                                <thead>
                                    <tr>
                                    <th scope="col">ID Parcela</th>
                                    <th scope="col">ID Contrato</th>
                                    <th scope="col">Nome</th>
                                    <th scope="col">E-mail</th>
                                    <th scope="col">Whatsapp</th>
                                    <th scope="col">Data Agendamento</th>
                                    <th scope="col">Status</th>
                                    </tr>
                                </thead>
                                <tbody>
                                <?php 
                                foreach ($listaQuebrada as $listaParcela) :
                                    foreach($listaParcela as $parcela) :?>
                                        <tr>
                                            <th><?=$parcela['id_parcela_contrato']?></th>
                                            <th id="contrato<?=$parcela['id_parcela_contrato']?>"><?=$parcela['idContrato']?></th>
                                            <th id="quadra<?=$parcela['id_parcela_contrato']?>" style="display:none;"><?=$parcela['quadra']?></th>
                                            <th id="lote<?=$parcela['id_parcela_contrato']?>" style="display:none;"><?=$parcela['lote']?></th>
                                            <th id="nm_empreendimento<?=$parcela['id_parcela_contrato']?>" style="display:none;"><?=$parcela['nm_empreendimento']?></th>
                                            <th id="nome<?=$parcela['id_parcela_contrato']?>"><?=$parcela['nm_pessoa']?></th>
                                            <th id="email<?=$parcela['id_parcela_contrato']?>"><?=$parcela['email']?></th>
                                            <th id="celular<?=$parcela['id_parcela_contrato']?>"><?=$parcela['nr_celular']?$parcela['nr_celular']:($parcela['nr_telefone']?$parcela['nr_telefone']:"")?></th>
                                            <td id="data<?=$parcela['id_parcela_contrato']?>"><?= Helper::getDate(date('Y-m-d', strtotime('-'.($email['diasEnvio']?$email['diasEnvio']:$whatsapp['diasEnvio']).' day', strtotime($parcela["dt_parcela"]))))?></td>
                                            <td id="status<?=$parcela['id_parcela_contrato']?>">Pendente</td>
                                        </tr>
                                    <?php endforeach;?>
                                <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <?php endif;?>
                    <select id="parcelasDesvinculadas" name="vinculo[]" multiple hidden>
                    </select>
                    <input type="hidden" name="passo2" value="true">
                    <fieldset>
                        <legend>Operaes</legend>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="form-group col-sm-2">
                                    <a href="?m=<?= $_GET['m'] ?>&c=<?= $_GET['c'] ?>&a=gerar"
                                       class="btn btn-danger col-sm-12">Voltar </a>
                                </div>
                            </div>
                        </div>
                    </fieldset>
                </form>
            </div>
        </div>
    </div>
<?php require_once 'layout/includes/footer.php'; ?>