<?php

/**
 * Classe que representa o controller do arquivo de retorno bancario
 *
 * @author acade
 */
class RetornoBoletoArquivoController extends Controller
{
    private $bancos;
    private $retorno_boleto;
    private $remessa;

    public function __construct($request)
    {
        parent::__construct($request);
        $this->bancos = new Banco();
        $this->retorno_boleto = new RetornoBoletoTabela();
        $this->remessa = new RemessaBoleto();
    }

    public function indexAction()
    {
        $this->redir(array("modulo" => "bo", "controller" => "retornoBoletoArquivo", "action" => "listar"));
    }

    public function listarAction()
    {
        if ($this->isAjax()) {
            $listaItem = RetornoBoletoTabela::findLista($_POST);
            $totalItens = RetornoBoletoTabela::findLista($_POST, true);

            $lista = array();
            foreach ($listaItem as $item) {
                $acoes = '<div style="width: 90px"></div><div align="center" style="width: 100%;">';
                $acoes .= '<a target="_blank" href="' . $item['ds_arquivo_pdf'] . '" data-toggle="tooltip" title="IMPRIMIR" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-file-o"></i></a>';
                $acoes .= '<a href="' . $item['ds_arquivo'] . '" target="_blank" download data-toggle="tooltip" title="BAIXAR" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-download"></i></a>';
                $acoes .= '</div>';
                $acoes .= '</div>';

                $lista[] = array(
                    'codigo' => $item['id_retorno_boleto'],
                    'numero' => $item['nr_retorno'],
                    'criacao' => '<div hidden>' . $item['dt_criacao'] . '</div>' . Helper::getDate($item['dt_criacao']),
                    'processamento' => '<div hidden>' . $item['dt_processamento'] . '</div>' . Helper::getDate($item['dt_processamento']),
                    'cliente' =>  utf8_encode($item['nm_cliente']),
                    'agenConta' => $item['ds_conta'],
                    'banco' =>  utf8_encode($item['descricao']),
                    'arquivo' =>  Helper::quebraPalavraGrande(end(explode('/', $item['ds_arquivo'])), 20),
                    'acoes' =>  $acoes
                );
            }

            echo json_encode(array(
                'draw' => $_POST['draw'],
                'recordsTotal' => count($totalItens),
                'recordsFiltered' => count($totalItens),
                'data' => $lista
            ));

        } else {
            $this->display('listar');
        }
    }

    public function gerarAction()
    {
        $tbClienteAcade = new Db_Cliente();
        $this->set('clienteAcade', $tbClienteAcade->fetchRow()->toArray());
        $listaLayoutRem = $this->remessa->getListaRemessaBanco();
        $this->set('listaLayoutsRem', $listaLayoutRem);
        $bancosApi = $this->bancos->buscarBancosComApi();
        
        $this->set('bancosApi', $bancosApi);
        if ($this->_isPost) {
            // Procedimentos para baixar arquivo e processa-lo
            if ($_FILES["arquivo"]["name"]) {
                //Cria os diretorios para onde o arquivo vai ser gravado
                $path = explode('.', $_SERVER['HTTP_HOST']);
                if ($path[0] == 'www') {
                    $path = $path[1];
                } else {
                    $path = $path[0];
                }

                // Arquivo
                $arquivo = $_FILES['arquivo']['name'];
                $up = new Filesystem();
                $tmp = $_FILES['arquivo']['tmp_name'];
              
                $to = 'upload/retorno/'.$path;
                Helper::criaPastas($to);
                $to = $to.'/'.$arquivo;
                $rs = $up->upload($tmp, $to); 

                if (!$rs) {
                    //Remove o aquivo j processado
                    if (file_exists($to))
                        Filesystem::delete($to);
                    $this->redir(array('modulo' => 'bo', "controller" => "retornoBoletoArquivo", "action" => "gerar"), array("fail" => "No foi possvel armazenar o arquivo."));
                } else {
                    // Processando arquivo
                    $padrao = false;
                    try {
                        $arq = file($to, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
                        $padrao = strlen($arq[0]);
                        $comReg = true;

                        if ($padrao == 240 || $padrao == 400) {
                            $ret = new RetornoBoleto($to, $padrao);
                        } else {
                            //Remove o aquivo j processado
                            if (file_exists($to))
                                Filesystem::delete($to);

                            $this->redir(array('modulo' => 'bo', "controller" => "retornoBoletoArquivo", "action" => "gerar"), array("fail" => "Arquivo de retorno fora do padro."));
                            exit();
                        }
                        $cd_banco = $_POST['cd_banco'];
                        $cod_layout=$_POST['cod_layout'];
                        $retorno = $ret->processar($comReg,false,null,false,'N',$cod_layout,$cd_banco);
                        
                    } catch (Exception $e) {
                        $retorno = false;
                        $erroMsg = $e->getMessage();
                    }

                    if ($retorno) {
                        $pathArquivo = 'upload/retorno/'.$path.'/arquivo/'.date('Y').'/'.substr($retorno['header']['agencia'], -6) . '-' . $retorno['header']['dv_agencia'] . substr($retorno['header']['conta_corrente'], -8) . '-' . $retorno['header']['dv_conta'];
                        $infoRetorno = $this->retorno_boleto->getDefaultAdapter()->select()
                            ->from(array('r' => TB_RETORNO_BOLETO), '*')
                            ->where('ds_arquivo = "' . $pathArquivo.'/'.$arquivo .'"')
                            ->query()->fetchAll();
                        $AgenciaContaAtual = 'Ag: ' . substr($retorno['header']['agencia'], -6) . '-' . $retorno['header']['dv_agencia'] . ' Cc: ' . substr($retorno['header']['conta_corrente'], -8) . '-' . $retorno['header']['dv_conta'];

                        $caminhoIgual = $infoRetorno[0]['ds_arquivo'] ==  $pathArquivo.'/'.$arquivo;
                        $contaIgual = false;
                        foreach ($infoRetorno as $ret) {
                            if ($ret['ds_conta'] ==  $AgenciaContaAtual) {
                                $contaIgual = true;
                            }
                        }

                        // Se o arquivo tiver mesmo nome e no for dos bancos 237, 748 ou 104 entra na condio ou
                        // se for um dos bancos 237, 748 ou 104 e o ano que foi processado o arquivo seja igual ao ano atual, entra na condio
                        if ($infoRetorno && $contaIgual && ($caminhoIgual && !in_array($infoRetorno[0]['cd_banco'], [237,748,104]) || ($caminhoIgual && in_array($infoRetorno[0]['cd_banco'], [237,748,104]) && Helper::retornaAnoMesDia($infoRetorno[0]['dt_processamento'])['ano'] == Helper::retornaAnoMesDia(date('Y-m-d'))['ano']))) {
                            $this->redir(array('modulo' => 'bo',"controller" => "retornoBoletoArquivo","action" => "listar"), array("exception" => "O arquivo <b>" . end(explode('/', $pathArquivo.'/'.$arquivo)) . "</b> j foi processado."));
                        } elseif (!is_null($retorno['sucessos']) || !is_null($retorno['verificar']) || !is_null($retorno['erros']) || !is_null($retorno['linhasErradas'])) {
                            ini_set("memory_limit", "128M");
                            set_time_limit(0);

                            if (!is_null($retorno['verificar'])) {
                                foreach ($retorno['verificar'] as $verificar) {
                                    if ($verificar['cod_movimento'] == '06') {
                                        $verificadasComBaixa[]['id_parcela_contrato'] = $verificar['id_parcela_contrato'];
                                    }
                                }
                                if ($verificadasComBaixa) {
                                    foreach ($verificadasComBaixa as $verificadaComBaixa) {
                                        $consultaParcelasVerificadas[] = Parcela::getParcelaCompletaById($verificadaComBaixa['id_parcela_contrato']);
                                    }
                                }
                            }

                            // Realiza os procedimentos para integrar com o acadefinan
                            // criando uma array com chave concatenada de id_empreendimento|dt_credito
                            // com o valor das parcelas pagas no periodo e a data de credito
                            if ($retorno['sucessos'] && count($retorno['sucessos']) > 0 || $consultaParcelasVerificadas) {
                                $auxIntegracao = array();
                                foreach ($retorno['sucessos'] as $p) {
                                    $empreendimento = Parcela::getIntegracaoEmpreendimento($p['id_parcela_contrato']);
                                    if ($empreendimento) {
                                        if (!isset($auxIntegracao[$empreendimento['id'] . '|' . $p['dt_credito']]))
                                            $auxIntegracao[$empreendimento['id'] . '|' . $p['dt_credito']] = array(
                                                'valor' => $p['vl_total_pago'],
                                                'empreendimento' => $empreendimento,
                                                'dt_credito' => $p['dt_credito']
                                            );
                                        else {
                                            $auxIntegracao[$empreendimento['id'] . '|' . $p['dt_credito']]['valor'] += $p['vl_total_pago'];
                                        }
                                    }
                                }
                                if ($consultaParcelasVerificadas) {
                                    foreach ($consultaParcelasVerificadas as $p) {
                                        $empreendimento = Parcela::getIntegracaoEmpreendimento($p['id_parcela_contrato']);
                                        if ($empreendimento) {
                                            if (!isset($auxIntegracao[$empreendimento['id'] . '|' . $p['dt_credito']]))
                                                $auxIntegracao[$empreendimento['id'] . '|' . $p['dt_credito']] = array(
                                                    'valor' => $p['vl_total_pago'],
                                                    'empreendimento' => $empreendimento,
                                                    'dt_credito' => $p['dt_credito']
                                                );
                                            else {
                                                $auxIntegracao[$empreendimento['id'] . '|' . $p['dt_credito']]['valor'] += $p['vl_total_pago'];
                                            }
                                        }
                                    }
                                }

                                if (count($auxIntegracao) > 0) {
                                    foreach ($auxIntegracao as $conta) {
                                        //Criando uma nova linha para inserao
                                        $adapter = $this->getAdapterIntegracao();
                                        $adapter->beginTransaction();
                                        try {
                                            $data = explode('-', $conta['dt_credito']);
                                            $contaDados = array(
                                                'cd_plano_conta' => $conta['empreendimento']['cd_conta_credito'],
                                                'cd_centro_custo' => $conta['empreendimento']['cd_centro_custo'],
                                                'nr_mes_competencia' => $data[1],
                                                'nr_ano_competencia' => $data[0],
                                                'dt_documento' => $conta['dt_credito'],
                                                'nr_parcelas' => 1,
                                                'vl_total' => $conta['valor'],
                                                'tp_conta_pagar_receber' => 'R',
                                                'ds_observacao' => 'Cobranca Eletronica',
                                                'log' => (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - u')
                                            );
                                            $adapter->insert('afn006', $contaDados);
                                            $idConta = $adapter->lastInsertId('afn006');

                                            //Insero na tabela de Parcelas de Contas a Pagar
                                            $parcelaDados = array(
                                                'cd_conta_pagar_receber' => $idConta,
                                                'cd_forma_pagamento' => 1,
                                                'cd_local_pagamento' => $conta['empreendimento']['id_finan'],
                                                'nr_parcela' => 1,
                                                'vl_parcela' => $conta['valor'],
                                                'dt_vencimento' => $conta['dt_credito'],
                                                'dt_pagamento' => $conta['dt_credito'],
                                                'dt_debito' => $conta['dt_credito'],
                                                'tp_situacao' => 'P'
                                            );
                                            $adapter->insert('afn007', $parcelaDados);

                                        } catch (Exception $e) {
                                            $adapter->rollBack();
                                            $this->redir(array('modulo' => 'bo',
                                                "controller" => "retornoBoletoArquivo",
                                                "action" => "index"), array("warning" => "No foi possvel gravar as contas pela integrao com Finan."));
                                        }
                                        $adapter->commit();
                                    }
                                }

                            }

                            $db = Zend_Db_Table::getDefaultAdapter();

                            $cdBanco = abs($_POST['cd_banco']);

                            $bancoTitulo = $db->select()->from(TB_AGRUPADA)
                                ->where('idTabela = ' . Db_TabelaAgrupada::TABLE_BANCO)
                                ->where("idCampo = {$cdBanco}")
                                ->order('descricao ASC')->query()->fetchAll();

                            $this->set('bTitulo', $bancoTitulo[0]);

                            //Caminho do arquivo em PDF
                            $pathPdf = 'upload/retorno/'.$path.'/pdf/'.date('Y');
                            Helper::criaPastas($pathPdf);
                            $pathPdfName = 'file_'. date('dmYHis').'.pdf';

                            //Caminho do arquivo retorno
                            Helper::criaPastas($pathArquivo);
                            $pathArquivo .= '/' . $arquivo;
                            copy($to, $pathArquivo);

                            //Insero na tabela Retorno Boleto
                            $dadosArquivos = new RetornoBoletoTabela();
                            $dadosArquivos = $dadosArquivos->createRow();
                            $dadosArquivos->cd_banco = $retorno['header']['banco'];
                            $dadosArquivos->nr_retorno = $retorno['header']['sequencia'];
                            $dadosArquivos->dt_criacao = Helper::getInputDate($this->_helper->formataDataBoleto($retorno['header']['data_geracao_arq'])) . ' ' .$this->_helper->formataHora($retorno['header']['hora_geracao_arq']);
                            $dadosArquivos->dt_processamento = date('Y-m-d');
                            $dadosArquivos->ds_conta = $AgenciaContaAtual;
                            $dadosArquivos->nm_cliente = $retorno['header']['nome_empresa'];
                            $dadosArquivos->ds_arquivo = $pathArquivo;
                            $dadosArquivos->ds_arquivo_pdf = $pathPdf.'/'.$pathPdfName;
                            $dadosArquivos->save();

                            //Remove o aquivo j processado
                            if (file_exists($to))
                                Filesystem::delete($to);

                            $this->set('tipoRetorno', $padrao);
                            $this->set('sucessos', $retorno['sucessos']);
                            $this->set('erros', $retorno['erros']);
                            $this->set('verificar', $retorno['verificar']);
                            $this->set('linhasErradas', $retorno['linhasErradas']);
                            $this->set('codigosMovimento', $retorno['codigosMovimento']);

                            $this->display('resultadoRetornoBoleto');
                            $this->redir(array('modulo' => 'bo',"controller" => "retornoBoletoArquivo","action" => "listar"), array("msg" => "success"));
                            $this->displayMPDF(rand() . '.pdf', null, 'L', false, false, true, $pathPdf, $pathPdfName);

                        } else {
                            //Remove o aquivo j processado
                            if (file_exists($to))
                                Filesystem::delete($to);
                            $this->redir(array('modulo' => 'bo',
                                "controller" => "retornoBoletoArquivo",
                                "action" => "gerar"), array("fail" => "O arquivo no possue baixas a serem realizadas."));
                        }
                    } else {
                        //Remove o aquivo j processado
                        if (file_exists($to))
                            Filesystem::delete($to);
                        $this->redir(array('modulo' => 'bo',
                            "controller" => "retornoBoletoArquivo",
                            "action" => "gerar"), array("fail" => "Entrar em contato com suporte acade: ".$erroMsg));
                    }
                }
            } elseif ($_POST['dt_pagamento_inicial']&&$_POST['dt_pagamento_final']&&$_POST['banco_conta']) {
                $path = explode('.', $_SERVER['HTTP_HOST']);
                if ($path[0] == 'www') {
                    $path = $path[1];
                } else {
                    $path = $path[0];
                }

                $banco = $this->bancos->buscarBancosContaComId($_POST['banco_conta']);
                if($banco['cd_banco']=="748"){

                    $this->set('banco', "Sicredi / ".$banco['nr_agencia']."-".$banco['nr_agencia_dv']." / ".$banco['nr_conta']."-".$banco['nr_conta_dv']);
                    $dataInicio = new DateTime($_POST['dt_pagamento_inicial']);
                    $dataFim = new DateTime($_POST['dt_pagamento_final']);
                
                    // Incrementar um dia por vez e imprimir cada data
                    $intervalo = new DateInterval('P1D');
                    $periodo = new DatePeriod($dataInicio, $intervalo, $dataFim->modify('+1 day'));
                    $listaParcelas = [];
                    $pathArquivo = 'upload/retorno/'.$path.'/arquivo/'.date('Y').'/'.$banco['nr_agencia'] . '-' . $banco['nr_agencia_dv'] . $banco['nr_conta'] . '-' . $banco['nr_conta_dv'];
                    Helper::criaPastas($pathArquivo);
                    $pathArquivo .= '/' . time().".json";
                    //criamos o arquivo 
                    $arquivo = fopen($pathArquivo,'w'); 
                    //verificamos se foi criado 
                    if ($arquivo == false) 
                        die('No foi possvel criar o arquivo de log.'); 
                    $log = "---------- JSON 1 ----------" . PHP_EOL;

                    /*$curl = curl_init();
                    curl_setopt_array($curl, array(
                    CURLOPT_URL => 'https://api-parceiro.sicredi.com.br/auth/openapi/token',
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => '',
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_FOLLOWLOCATION => true,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_CUSTOMREQUEST => 'POST',
                    CURLOPT_POSTFIELDS => http_build_query(array('username' => $banco['pp_token'],
                    'password' => $banco['password'],
                    'scope' => 'cobranca',
                    'grant_type' => 'password')),
                    CURLOPT_HTTPHEADER => array(
                        'x-api-key: '.$banco['gerar_token'],
                        'context: COBRANCA',
                        'Content-Type: application/x-www-form-urlencoded',
                    ),
                    ));
                    
                    $server_response = curl_exec($curl);
                    $error = curl_error($curl);
                    curl_close($curl);

                    if ($error !== '') {
                        throw new Exception($error);
                        die;
                    }
                    
                    $obj = json_decode($server_response);
                    $token = $obj->{'access_token'};
                    $auth='Authorization: Bearer ' . $token;


                    $contadorJson=1;
                    foreach ($periodo as $data) {
                        $pagina = 0;
                        $hasNext = true;
                        while($hasNext){
                            $curl = curl_init();
    
                            curl_setopt_array($curl, array(
                            CURLOPT_URL => 'https://api-parceiro.sicredi.com.br/cobranca/boleto/v1/boletos/liquidados/dia?codigoBeneficiario='.$banco['cd_cedente'].'&dia='.$data->format('d/m/Y').'&pagina='.$pagina,
                            CURLOPT_RETURNTRANSFER => true,
                            CURLOPT_ENCODING => '',
                            CURLOPT_MAXREDIRS => 10,
                            CURLOPT_TIMEOUT => 0,
                            CURLOPT_FOLLOWLOCATION => true,
                            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                            CURLOPT_CUSTOMREQUEST => 'GET',
                            CURLOPT_HTTPHEADER => array(
                                'x-api-key: ' . $banco['gerar_token'],
                                'cooperativa: ' . $banco['nr_agencia'],
                                'posto: ' . $banco['carteira_variacao'],
                                'Content-Type: application/x-www-form-urlencoded',
                                $auth
                            ),
                            ));
    
                            $response = curl_exec($curl);
                            curl_close($curl);
                            
                            if ($error !== '') {
                                throw new Exception($error);
                                die;
                            }
                            $objResultado = json_decode($response,true);
                            $log .= $response; 
                            $log .= PHP_EOL."----------------------------" . PHP_EOL. PHP_EOL;

                            $pagina++;
                            if($objResultado['hasNext'] &&  $objResultado['hasNext']==true){
                                $hasNext=true;
                                $log .= "---------- JSON ".( $contadorJson)." ----------" . PHP_EOL;
                                $contadorJson++;
                            }
                            else{
                                $hasNext = false;
                            }
                            
                            foreach($objResultado['items'] as $boleto){
                               
                                $listaParcelas[]=$boleto;
                            }
                        }
                    }*/
$json = '[
    {
      "cooperativa": "2201",
      "codigoBeneficiario": "41781",
      "cooperativaPostoBeneficiario": "220111",
      "nossoNumero": "600001180",
      "seuNumero": "138314",
      "tipoCarteira": "A",
      "dataPagamento": "2024-11-22 00:00:00.0",
      "valor": 487.35,
      "valorLiquidado": 487.35,
      "jurosLiquido": 0,
      "descontoLiquido": 0,
      "multaLiquida": 0,
      "abatimentoLiquido": 0,
      "tipoLiquidacao": "COMPE"
    },
    {
      "cooperativa": "2201",
      "codigoBeneficiario": "41781",
      "cooperativaPostoBeneficiario": "220111",
      "nossoNumero": "600001199",
      "seuNumero": "138315",
      "tipoCarteira": "A",
      "dataPagamento": "2024-11-22 00:00:00.0",
      "valor": 487.35,
      "valorLiquidado": 487.35,
      "jurosLiquido": 0,
      "descontoLiquido": 0,
      "multaLiquida": 0,
      "abatimentoLiquido": 0,
      "tipoLiquidacao": "COMPE"
    },
    {
      "cooperativa": "2201",
      "codigoBeneficiario": "41781",
      "cooperativaPostoBeneficiario": "220111",
      "nossoNumero": "600001210",
      "seuNumero": "138317",
      "tipoCarteira": "A",
      "dataPagamento": "2024-11-22 00:00:00.0",
      "valor": 457.59,
      "valorLiquidado": 457.59,
      "jurosLiquido": 0,
      "descontoLiquido": 0,
      "multaLiquida": 0,
      "abatimentoLiquido": 0,
      "tipoLiquidacao": "PIX"
    },
    {
      "cooperativa": "2201",
      "codigoBeneficiario": "41781",
      "cooperativaPostoBeneficiario": "220111",
      "nossoNumero": "600001229",
      "seuNumero": "138321",
      "tipoCarteira": "A",
      "dataPagamento": "2024-11-25 00:00:00.0",
      "valor": 483.92,
      "valorLiquidado": 483.92,
      "jurosLiquido": 0,
      "descontoLiquido": 0,
      "multaLiquida": 0,
      "abatimentoLiquido": 0,
      "tipoLiquidacao": "COMPE"
    }
]';

// Decodificar JSON para um array PHP
$listaParcelas = json_decode($json, true);


                    
                   
                    fwrite($arquivo, $log);
                    fclose($arquivo);
                    //Caminho do arquivo em PDF
                    $pathPdf = 'upload/retorno/'.$path.'/pdf/'.date('Y');
                    Helper::criaPastas($pathPdf);
                    $pathPdfName = 'file_'. date('dmYHis').'.pdf';
                    $dt_pagamento = $_POST['dt_pagamento'];
                     //Gera as linhas das parcelas que retornaram com sucesso
                     $array_parcelas_ok = [];
                     $array_parcelas_erro = [];
                    //Insero na tabela Retorno Boleto
                    $dadosArquivos = new RetornoBoletoTabela();
                    $dadosArquivos = $dadosArquivos->createRow();
                    $dadosArquivos->cd_banco = $banco['cd_banco'];
                    $dadosArquivos->nr_retorno = time();
                    $dadosArquivos->dt_criacao = date("Y-m-d");
                    $dadosArquivos->dt_processamento = date('Y-m-d');
                    $dadosArquivos->ds_conta = $banco['nr_agencia'];
                    $dadosArquivos->nm_cliente = $banco['nm_cedente'];
                    $dadosArquivos->ds_arquivo_pdf = $pathPdf.'/'.$pathPdfName;
                    $dadosArquivos->ds_arquivo = $pathArquivo;
                    $dadosArquivos->ds_log = "API Sicredi, chamada de ".$_POST['dt_pagamento_inicial']. " at ".$_POST['dt_pagamento_final'];
                    $dadosArquivos->save();

                    foreach($listaParcelas as $parcela){
                        $resultadoParcela = Parcela::getParcelasById($parcela['seuNumero']);

                        if($resultadoParcela[0]&&$resultadoParcela[0]['id_contrato']){
                            $bancoContrato = Banco::findByBancoContrato($resultadoParcela[0]['id_contrato'],$_POST['banco_conta']);
                            if(isset($bancoContrato['id'])&& $resultadoParcela && ($resultadoParcela[0]['vl_parcela']==$parcela['valor']||$resultadoParcela[0]['vl_parcela_2avia']==$parcela['valor']||(round($resultadoParcela[0]['vl_parcela_2avia']+$resultadoParcela[0]['acrescimo']-$resultadoParcela[0]['desconto'],2)==$parcela['valor']))){
                                RetornoBoleto::atualizarParcelaApiIdParcelaContrato($parcela['seuNumero'],$parcela['valor'],explode(" ",$parcela['dataPagamento'])[0],$parcela['multaLiquida'],$parcela['jurosLiquido'],$parcela['descontoLiquido'],$parcela['nossoNumero'],$parcela['valorLiquidado'], $bancoContrato['id']);
                                $resultadoParcela[0]['valor_pago'] = $parcela['valorLiquidado'];
                                $resultadoParcela[0]['nosso_numero']=$parcela['nossoNumero'];
                                $resultadoParcela[0]['seuNumero']=$parcela['seuNumero'];
                                $resultadoParcela[0]['dt_pagamento']=explode(" ",$parcela['dataPagamento'])[0];
                                $resultadoParcela[0]['dt_credito']=explode(" ",$parcela['dataPagamento'])[0];
                                $resultadoParcela[0]['vl_multa']=$parcela['multaLiquida'];
                                $resultadoParcela[0]['vl_juros']=$parcela['jurosLiquido'];
                                $resultadoParcela[0]['desconto']=$parcela['descontoLiquido'];
                                $resultadoParcela[0]['vl_parcela']=$parcela['valor'];
                                $resultadoParcela[0]['vl_total_pago']=$parcela['valorLiquidado'];
                                array_push($array_parcelas_ok, $resultadoParcela);
                            }
                            else{
                                array_push($array_parcelas_erro, array(
                                    'nosso_numero'=>$parcela['nossoNumero'],
                                    'seuNumero'=>$parcela['seuNumero'],
                                    'dt_parcela'=>'-',
                                    'dt_pagamento'=>explode(" ",$parcela['dataPagamento'])[0],
                                    'dt_credito'=>explode(" ",$parcela['dataPagamento'])[0],
                                    'vl_multa'=>$parcela['multaLiquida'],
                                    'vl_juros'=>$parcela['jurosLiquido'],
                                    'desconto'=>$parcela['descontoLiquido'],
                                    'vl_parcela'=>$parcela['valor'],
                                    'vl_total_pago'=>$parcela['valorLiquidado']
                                ));
                            }
                        }
                        else{
                            array_push($array_parcelas_erro, array(
                                'nosso_numero'=>$parcela['nossoNumero'],
                                'seuNumero'=>$parcela['seuNumero'],
                                'dt_parcela'=>'-',
                                'dt_pagamento'=>explode(" ",$parcela['dt_pagamento'])[0],
                                'vl_multa'=>$parcela['multaLiquida'],
                                'vl_juros'=>$parcela['jurosLiquido'],
                                'desconto'=>$parcela['descontoLiquido'],
                                'vl_parcela'=>$parcela['valor'],
                                'vl_total_pago'=>$parcela['valorLiquidado']
                            ));
                        }
                    }   
                    
                }
                elseif($banco['cd_banco']=="077"){
                    $ch = curl_init();

                    $this->set('banco', "Inter / ".$banco['nr_agencia']."-".$banco['nr_agencia_dv']." / ".$banco['nr_conta']."-".$banco['nr_conta_dv']);
                    curl_setopt($ch, CURLOPT_URL,"https://cdpj.partners.bancointer.com.br/oauth/v2/token");
                    curl_setopt($ch, CURLOPT_POST, 1);
                    curl_setopt($ch, CURLOPT_SSLCERT, "upload/cliente/".$path."/certificado/certificado".$banco['cod_layout_api'].".crt");
                    curl_setopt($ch, CURLOPT_SSLKEY, "upload/cliente/".$path."/certificado/certificado".$banco['cod_layout_api'].".key");
                    curl_setopt($ch, CURLOPT_POSTFIELDS,
                        http_build_query(array('client_id' => $banco['pp_token'],
                            'client_secret' => $banco['password'],
                            'scope' => 'boleto-cobranca.read boleto-cobranca.write',
                            'grant_type' => 'client_credentials')));
                    curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/x-www-form-urlencoded'));

                    // Receive server response ...
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

                    $server_response = curl_exec($ch);
                    $error = curl_error($ch);
                    $errno = curl_errno($ch);

                    curl_close ($ch);

                    if ($error !== '') {
                        throw new Exception($error);
                        die;
                    }

                    if ($server_response == '') {
                        throw new Exception("Resposta vazia, provavelmente o limite de chamadas foi atingido...\n");
                        die;
                    }

                    $obj = json_decode($server_response);

                    $bearerToken=$obj->{'access_token'};

                    $auth='Authorization: Bearer ' . $bearerToken;
                    $cc='x-conta-corrente: '.$banco['nr_conta'].$banco['nr_conta_dv'];
                    $json='Content-Type: application/json';
                    $paginaAtual = 0;
                    $quantidadePagina = 1;
                    $listaParcelas = [];
                    $pathArquivo = 'upload/retorno/'.$path.'/arquivo/'.date('Y').'/'.$banco['nr_agencia'] . '-' . $banco['nr_agencia_dv'] . $banco['nr_conta'] . '-' . $banco['nr_conta_dv'];
                    Helper::criaPastas($pathArquivo);
                    $pathArquivo .= '/' . time().".json";
                    //criamos o arquivo 
                    $arquivo = fopen($pathArquivo,'w'); 
                    //verificamos se foi criado 
                    if ($arquivo == false) 
                        die('No foi possvel criar o arquivo de log.'); 
                    $log = "---------- JSON 1 ----------" . PHP_EOL;

                    while($paginaAtual < $quantidadePagina){
                        $queryString = http_build_query([
                            'dataInicial' => $_POST['dt_pagamento_inicial'],
                            'dataFinal' => $_POST['dt_pagamento_final'],
                            'filtrarDataPor'=>'SITUACAO',
                            'situacao' => 'PAGO',
                            'tipoOrdenacao' => 'ASC',
                            'itensPorPagina' => 10,
                            'paginaAtual' => $paginaAtual
                        ]);
                        
                        $ch = curl_init();
                        curl_setopt($ch, CURLOPT_URL, "https://cdpj.partners.bancointer.com.br/cobranca/v2/boletos?". $queryString);
                        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');
                        curl_setopt($ch, CURLOPT_SSLVERSION, CURL_SSLVERSION_TLSv1_2);
                        curl_setopt($ch, CURLOPT_HTTPHEADER, array($auth));
                        curl_setopt($ch, CURLOPT_SSLCERT, "upload/cliente/".$path."/certificado/certificado".$banco['cod_layout_api'].".crt");
                        curl_setopt($ch, CURLOPT_SSLKEY, "upload/cliente/".$path."/certificado/certificado".$banco['cod_layout_api'].".key");
                        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

                        $result = curl_exec($ch);
                        $error = curl_error($ch);
                        $errno = curl_errno($ch);
                        curl_close ($ch);

                        if ($error !== '') {
                            throw new Exception($error);
                            die;
                        }
                        $objResultado = json_decode($result,true);
                        $paginaAtual++;
                        $quantidadePagina = $objResultado['totalPages'];
                        foreach($objResultado['content'] as $boleto){
                            $listaParcelas[]=$boleto;
                        }
                        $log .= $result; 
                        $log .= PHP_EOL."----------------------------" . PHP_EOL. PHP_EOL;
                        if($paginaAtual < $quantidadePagina){
                            $log .= "---------- JSON ".($paginaAtual+1)." ----------" . PHP_EOL;
                        }
                    }
                    fwrite($arquivo, $log);
                    fclose($arquivo);
                    //Caminho do arquivo em PDF
                    $pathPdf = 'upload/retorno/'.$path.'/pdf/'.date('Y');
                    Helper::criaPastas($pathPdf);
                    $pathPdfName = 'file_'. date('dmYHis').'.pdf';
                    $dt_pagamento = $_POST['dt_pagamento'];
                     //Gera as linhas das parcelas que retornaram com sucesso
                     $array_parcelas_ok = [];
                     $array_parcelas_erro = [];
                     $array_parcelas_verificar = [];
                    //Insero na tabela Retorno Boleto
                    $dadosArquivos = new RetornoBoletoTabela();
                    $dadosArquivos = $dadosArquivos->createRow();
                    $dadosArquivos->cd_banco = $banco['cd_banco'];
                    $dadosArquivos->nr_retorno = time();
                    $dadosArquivos->dt_criacao = date("Y-m-d");
                    $dadosArquivos->dt_processamento = date('Y-m-d');
                    $dadosArquivos->ds_conta = $banco['nr_agencia'];
                    $dadosArquivos->nm_cliente = $banco['nm_cedente'];
                    $dadosArquivos->ds_arquivo_pdf = $pathPdf.'/'.$pathPdfName;
                    $dadosArquivos->ds_arquivo = $pathArquivo;
                    $dadosArquivos->ds_log = "API Inter, chamada de ".$_POST['dt_pagamento_inicial']. " at ".$_POST['dt_pagamento_final'];
                    $dadosArquivos->save();

                    foreach($listaParcelas as $parcela){
                        
                        if($parcela['origem'] == "CERTIFICADO"){
                            $resultadoParcela = Parcela::getParcelasById($parcela['seuNumero']);
                            
                            if(!$resultadoParcela){
                                $resultadoParcela = Parcela::getParcelasByNrBoleto(substr($parcela['nossoNumero'], -10));
                            } 
                            
                            if($resultadoParcela[0]&&$resultadoParcela[0]['id_contrato']){
                                $bancoContrato = Banco::findByBancoContrato($resultadoParcela[0]['id_contrato'],$_POST['banco_conta']);
                                if(isset($bancoContrato['id'])&&$resultadoParcela && ($resultadoParcela[0]['vl_parcela']==$parcela['valorNominal'] || $resultadoParcela[0]['vl_parcela_2avia']==$parcela['valorNominal']||(round($resultadoParcela[0]['vl_parcela_2avia']+$resultadoParcela[0]['acrescimo']-$resultadoParcela[0]['desconto'],2)==$parcela['valorNominal']))){
                                    RetornoBoleto::atualizarParcelaApiIdParcelaContrato($resultadoParcela[0]['id_parcela_contrato'],$parcela['valorNominal'],explode(" ",$parcela['dataHoraSituacao'])[0],$parcela['multa']['valor'],$parcela['mora']['valor'],$parcela['desconto1']['valor'],substr($parcela['nossoNumero'], -10),$parcela['valorTotalRecebimento'], $bancoContrato['id']);
                                    $resultadoParcela[0]['valor_pago'] = $parcela['valorTotalRecebimento']?$parcela['valorTotalRecebimento']:($parcela['valorNominal']+$parcela['multa']['valor']+$parcela['mora']['valor']-$parcela['desconto1']['valor']);

                                    $resultadoParcela[0]['dt_pagamento'] = explode(" ", $parcela['dataHoraSituacao'])[0];
                                    $resultadoParcela[0]['dt_credito'] = explode(" ", $parcela['dataHoraSituacao'])[0];
                                    $resultadoParcela[0]['vl_multa'] = $parcela['multa']['valor'];
                                    $resultadoParcela[0]['vl_juros'] = $parcela['mora']['valor'];
                                    $resultadoParcela[0]['vl_total_pago'] = $parcela['valorNominal'];

                                    array_push($array_parcelas_ok, $resultadoParcela);
                                }
                                elseif(isset($bancoContrato['id'])&&$resultadoParcela && $resultadoParcela[0]['vl_parcela']<$parcela['valorTotalRecebimento'] ){
                                    RetornoBoleto::atualizarParcelaApiIdParcelaContrato($resultadoParcela[0]['id_parcela_contrato'],$parcela['valorNominal'],explode(" ",$parcela['dataHoraSituacao'])[0],$parcela['multa']['valor'],$parcela['mora']['valor'],$parcela['desconto1']['valor'],substr($parcela['nossoNumero'], -10),$parcela['valorTotalRecebimento'], $bancoContrato['id']);
                                    $resultadoParcela[0]['valor_pago'] = $parcela['valorTotalRecebimento']?$parcela['valorTotalRecebimento']:($parcela['valorNominal']+$parcela['multa']['valor']+$parcela['mora']['valor']-$parcela['desconto1']['valor']);
                                    array_push($array_parcelas_verificar, $resultadoParcela);
                                }
                                else{
                                    array_push($array_parcelas_erro, array(
                                        'nosso_numero'=>substr($parcela['nossoNumero'], -10),
                                        'seuNumero'=>$parcela['seuNumero'],
                                        'dt_parcela'=>$parcela['dataVencimento'],
                                        'dt_pagamento'=>explode(" ",$parcela['dataHoraSituacao'])[0],
                                        'vl_multa'=>$parcela['multa']['valor'],
                                        'vl_juros'=>$parcela['mora']['valor'],
                                        'desconto'=>$parcela['desconto1']['valor'],
                                        'vl_parcela'=>$parcela['valorNominal'],
                                        'vl_total_pago'=>$parcela['valorTotalRecebimento']?$parcela['valorTotalRecebimento']:($parcela['valorNominal']+$parcela['multa']['valor']+$parcela['mora']['valor']-$parcela['desconto1']['valor'])
                                    ));
                                }
                            }
                        }
                        else{
                            array_push($array_parcelas_erro, array(
                                'nosso_numero'=>substr($parcela['nossoNumero'], -10),
                                'seuNumero'=>$parcela['seuNumero'],
                                'dt_parcela'=>$parcela['dataVencimento'],
                                'dt_pagamento'=>explode(" ",$parcela['dataHoraSituacao'])[0],
                                'vl_multa'=>$parcela['multa']['valor'],
                                'vl_juros'=>$parcela['mora']['valor'],
                                'desconto'=>$parcela['desconto1']['valor'],
                                'vl_parcela'=>$parcela['valorNominal'],
                                'vl_total_pago'=>$parcela['valorTotalRecebimento']?$parcela['valorTotalRecebimento']:($parcela['valorNominal']+$parcela['multa']['valor']+$parcela['mora']['valor']-$parcela['desconto1']['valor'])
                            ));
                        }

                    }
                }
                elseif ($banco['cd_banco'] == "274") {
                    
                    $page = 1;
                    $pathArquivo = 'upload/retorno/'.$path.'/arquivo/'.date('Y').'/'.$banco['nr_agencia'] . '-' . $banco['nr_agencia_dv'] . $banco['nr_conta'] . '-' . $banco['nr_conta_dv'];
                    Helper::criaPastas($pathArquivo);
                    $pathArquivo .= '/' . time().".json";
                    //criamos o arquivo 
                    $arquivo = fopen($pathArquivo,'w');

                    if ($arquivo == false) 
                        die('No foi possvel criar o arquivo de log.'); 
                    $log = "---------- JSON 1 ----------" . PHP_EOL;

                    while ($page != null) {
                        $curl = curl_init();

                        //BUSCA TODAS AS PARCELAS PAGAS NA DATA INFORMADA
                        curl_setopt_array($curl, [
                            CURLOPT_URL => "https://pagamentos.grafeno.digital/api/v2/charges?q[paidAtGt]=". $_POST['dt_pagamento_inicial'] ."&q[paidAtLt]=". $_POST['dt_pagamento_final'] ."&q[statusEq]=paid&p[page]=". $page,
                            CURLOPT_RETURNTRANSFER => true,
                            CURLOPT_ENCODING => "",
                            CURLOPT_MAXREDIRS => 10,
                            CURLOPT_TIMEOUT => 30,
                            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                            CURLOPT_CUSTOMREQUEST => "GET",
                            CURLOPT_HTTPHEADER => [
                              "Account-Number: " . $banco['nr_conta'] . '-' . $banco['nr_conta_dv'],
                              "Authorization: " . $banco['pp_token'],
                              "accept: application/json"
                            ],
                          ]);
                        
                        $response = curl_exec($curl);
                        curl_close($curl);

                        $dadosRetorno = json_decode($response);
                        $page = $dadosRetorno->meta->pagination->nextPage;
                        
                        foreach($dadosRetorno->data as $k => $retorno) {
                            //BUSCA O JUROS E MULTA DAS PARCELAS
                            $curl = curl_init();

                            curl_setopt_array($curl, [
                            CURLOPT_URL => "https://pagamentos.grafeno.digital/api/v2/charges/" . $dadosRetorno->data[$k]->id,
                            CURLOPT_RETURNTRANSFER => true,
                            CURLOPT_ENCODING => "",
                            CURLOPT_MAXREDIRS => 10,
                            CURLOPT_TIMEOUT => 30,
                            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                            CURLOPT_CUSTOMREQUEST => "GET",
                            CURLOPT_HTTPHEADER => [
                                "Account-Number: " . $banco['nr_conta'] . '-' . $banco['nr_conta_dv'],
                                "Authorization: " . $banco['pp_token'],
                                "accept: application/json"
                            ],
                            ]);

                            $response = curl_exec($curl);
                            curl_close($curl);
                            
                            $parcelaAPI = json_decode($response);
                            
                            $listaParcelas[] = $retorno->attributes;

                            $listaParcelas[$k]->interestType = $parcelaAPI->data->attributes->interestType;
                            $listaParcelas[$k]->interestValue = $parcelaAPI->data->attributes->interestValue;
                            $listaParcelas[$k]->applicableFine = $parcelaAPI->data->attributes->applicableFine;
                            $listaParcelas[$k]->discount->range = $parcelaAPI->data->attributes->discount->range;
                            $listaParcelas[$k]->discount->discountType = $parcelaAPI->data->attributes->discount->discountType;
                            $listaParcelas[$k]->discount->discountValue = $parcelaAPI->data->attributes->discount->discountValue;
                            $listaParcelas[$k]->receivedAt = $parcelaAPI->data->attributes->payments->data[0]->attributes->receivedAt;
                        }
                        
                        $log .= json_encode($listaParcelas);
                        $log .= PHP_EOL."----------------------------" . PHP_EOL. PHP_EOL;
                        if($page < $dadosRetorno->meta->pagination->totalPages){
                            $log .= "---------- JSON ".($page+1)." ----------" . PHP_EOL;
                        }
                    }
                    
                    fwrite($arquivo, $log);
                    fclose($arquivo);

                    $pathPdf = 'upload/retorno/'.$path.'/pdf/'.date('Y');
                    Helper::criaPastas($pathPdf);
                    $pathPdfName = 'file_'. date('dmYHis').'.pdf';
                    $dt_pagamento = $_POST['dt_pagamento'];
                    //Gera as linhas das parcelas que retornaram com sucesso
                    $array_parcelas_ok = [];
                    $array_parcelas_erro = [];
                    $array_parcelas_verificar = [];
                    //Insero na tabela Retorno Boleto
                    $dadosArquivos = new RetornoBoletoTabela();
                    $dadosArquivos = $dadosArquivos->createRow();
                    $dadosArquivos->cd_banco = $banco['cd_banco'];
                    $dadosArquivos->nr_retorno = time();
                    $dadosArquivos->dt_criacao = date("Y-m-d");
                    $dadosArquivos->dt_processamento = date('Y-m-d');
                    $dadosArquivos->ds_conta = $banco['nr_agencia'];
                    $dadosArquivos->nm_cliente = $banco['nm_cedente'];
                    $dadosArquivos->ds_arquivo_pdf = $pathPdf.'/'.$pathPdfName;
                    $dadosArquivos->ds_arquivo = $pathArquivo;
                    $dadosArquivos->ds_log = "API Grafeno, chamada de ".$_POST['dt_pagamento_inicial']. " at ".$_POST['dt_pagamento_final'];
                    $dadosArquivos->save();
                    
                    foreach($listaParcelas as $k => $parcela) {
                        
                        if(!$parcela->clientControlNumber) {
                            continue;
                        }

                        $resultadoParcela = Parcela::getParcelasById($parcela->clientControlNumber, '274');
                        
                        if (!$resultadoParcela) {
                            continue;
                        }
                        
                        if($resultadoParcela[0]&&$resultadoParcela[0]['id_contrato']){
                            $bancoContrato = Banco::findByBancoContrato($resultadoParcela[0]['id_contrato'],$_POST['banco_conta']);
                            if(isset($bancoContrato['id'])&&$resultadoParcela && ($resultadoParcela[0]['vl_parcela'] == $parcela->value || $resultadoParcela[0]['vl_parcela_2avia'] == $parcela->value||(round($resultadoParcela[0]['vl_parcela_2avia']+$resultadoParcela[0]['acrescimo']-$resultadoParcela[0]['desconto'],2)==$parcela->value))) {
                                
                                $multa = 0;
                                $juros = 0;

                                if (strtotime($resultadoParcela[0]['dt_parcela']) < strtotime($parcela->receivedAt)) {
                                    $diasAtraso = abs(strtotime($resultadoParcela[0]['dt_parcela']) - strtotime($parcela->receivedAt));
                                    $diasAtraso = round($diasAtraso / (60 * 60 * 24));
                                    
                                    if ($diasAtraso < 0)
                                        $diasAtraso = 0;

                                    /*  Alguns boletos vencidos, possuem o valor de multa ou juros zerado,
                                        apara resolver esse problema, o sistema busca os valores de multa,
                                        e juros do banco do cliente.
                                    */
                                    if ($parcela->interestValue <= 0) {
                                        $parcela->interestValue = $bancoContrato['juros'];
                                    }

                                    if ($parcela->applicableFine <= 0) {
                                        $parcela->applicableFine = $bancoContrato['multa'];
                                    }
                                    
                                    $multa = ($parcela->applicableFine / 100) * $parcela->value;
                                    $juros = (($parcela->interestValue / 100) * $parcela->value) * $diasAtraso;
                                }

                                RetornoBoleto::atualizarParcelaApiIdParcelaContratoBancoGrafeno(
                                    $parcela->clientControlNumber, 
                                    $parcela->value, 
                                    $parcela->receivedAt,
                                    $multa,
                                    $juros,
                                    $parcela->discount->discountValue,
                                    0,
                                    false,
                                    $bancoContrato['id']
                                );

                                $resultadoParcela[0]['dt_pagamento'] = $parcela->receivedAt;
                                $resultadoParcela[0]['dt_credito'] = $parcela->receivedAt;
                                $resultadoParcela[0]['vl_multa'] = $multa;
                                $resultadoParcela[0]['vl_juros'] = $juros;
                                $resultadoParcela[0]['vl_total_pago'] = $parcela->value + $juros + $multa - $parcela->discount->discountValue;

                                array_push($array_parcelas_ok, $resultadoParcela);
                            }
                        }
                    }
                }
                else{
                    //Caminho do arquivo em PDF
                    $pathPdf = 'upload/retorno/'.$path.'/pdf/'.date('Y');
                    Helper::criaPastas($pathPdf);
                    $pathPdfName = 'file_'. date('dmYHis').'.pdf';
                    $dt_pagamento = $_POST['dt_pagamento'];
                    $retorno[] = RetornoBoleto::setUpdateParcelaApi($dt_pagamento,'upload/retorno/'.$path.'/pdf/'.date('Y'),$pathPdfName);


                    //Gera as linhas das parcelas que retornaram com sucesso
                    $array_parcelas_ok = [];
                    $array_parcelas_erro = [];
                    foreach ($retorno[0]['ok'] as $item){
                        array_push($array_parcelas_ok, Parcela::getParcelasById($item)); //Adiciona no array as informaes da parcela do Foreach
                    }
                    foreach ($retorno[0]['erros'] as $item){
                        array_push($array_parcelas_erro, Parcela::getParcelasById($item)); //Adiciona no array as informaes da parcela do Foreach
                    }

                    //Integra com o Acade Finan
                    //Insere na tabela afn006 e afn007 as informaes do histrico de Parcelas Paga e parcelas recebidas.

                        foreach ($array_parcelas_ok as $conta) {

                            if (count($array_parcelas_ok) > 0) {

                            //Criando uma nova linha para inserao
                            $adapter = $this->getAdapterIntegracao();
                            //$adapter->beginTransaction();
                            try {
                                $data = explode('-', $conta[0]['dt_credito']);
                                $contaDados = array(
                                    'cd_plano_conta' => $conta[0]['cd_conta_credito'], //Este campo No aceita Null
                                    'cd_centro_custo' => $conta[0]['cd_centro_custo'],//$conta[0]['cd_centro_custo'],
                                    'nr_mes_competencia' => $data[1],  //Este campo No aceita Null
                                    'nr_ano_competencia' => $data[0],  //Este campo No aceita Null
                                    'dt_documento' => $conta[0]['dt_credito'],
                                    'nr_parcelas' => 1,
                                    'vl_total' => $conta[0]['vl_total_pago'],
                                    'tp_conta_pagar_receber' => 'R',  //Este campo No aceita Null
                                    'ds_observacao' => 'Cobranca Eletronica',
                                    'log' => (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - u')
                                );
                            
                                $adapter->insert('afn006', $contaDados);
                                $idConta = $adapter->lastInsertId('afn006');

                                //Insero na tabela de Parcelas de Contas a Pagar
                                $parcelaDados = array(
                                    'cd_conta_pagar_receber' => $idConta,
                                    'cd_forma_pagamento' => 4,
                                    'cd_local_pagamento' => $conta[0]['cd_conta_tesouraria'],
                                    'nr_parcela' => 1,
                                    'vl_parcela' => $conta[0]['vl_total_pago'],
                                    'dt_vencimento' => $conta[0]['dt_parcela'],
                                    'dt_pagamento' => $conta[0]['dt_pagamento'],
                                    'dt_debito' => $conta[0]['dt_credito'],
                                    'tp_situacao' => 'A'
                                );
                                $adapter->insert('afn007', $parcelaDados);

                            } catch (Exception $e) {
                            // $adapter->rollBack();
                                $this->redir(array('modulo' => 'bo',
                                    "controller" => "retornoBoletoArquivo",
                                    "action" => "index"), array("warning" => "No foi possvel gravar as contas pela integrao com Finan."));
                            }
                            //$adapter->commit();
                        }
                    }
                }
                
                $this->set('sucessos', $array_parcelas_ok);
                $this->set('erros', $array_parcelas_erro);
                $this->set('verificar', $array_parcelas_verificar);
                if ($banco['cd_banco'] != "274") {
                    $this->set('linhasErradas', $retorno['linhasErradas']);
                    $this->set('codigosMovimento', $retorno['codigosMovimento']); 
                }

                $this->display('resultadoRetornoBoletoAPI');
                $this->redir(array('modulo' => 'bo',"controller" => "retornoBoletoArquivo","action" => "listar"), array("msg" => "success"));
                $this->displayMPDF(rand() . '.pdf', null, 'L', false, false, true, $pathPdf, $pathPdfName);

            }else {
                $this->_helper->addMensagem("fail", "Arquivo ou Data no informado.");
            }
        }

        if ($_GET["msg"] == "ok") {
            $this->_helper->addMensagem("ok", "Operao realizada com sucesso!");
        } elseif ($_GET["msg"] == "fail") {
            $this->_helper->addMensagem("fail", "No foi possvel continuar a operao!");
        } elseif (strlen($_GET["fail"]) > 1) {
            $this->_helper->addMensagem("fail", $_GET['fail']);
        }
        $bancos = $this->bancos->getAdapter()->select()->from(TB_AGRUPADA)
            ->where('idTabela = ' . Db_TabelaAgrupada::TABLE_BANCO)
            ->order('descricao ASC')->query()->fetchAll();
        $this->set('bancos', $bancos);

        if ($this->getAdapterIntegracao()) {
            $contaMovimento = $this->getAdapterIntegracao()->select()->from('afn010')
                ->query()->fetchAll();
            $this->set('contaMovimento', $contaMovimento);
        }

        if ($banco['cd_banco'] == "274" || $banco['cd_banco'] == "748" || $banco['cd_banco'] == "077") { 

            $this->integracaoFinanAPI($array_parcelas_ok);
        }
        
        $this->display('gerar');
    }

    /**
     * Funo ajax que faz upload, verifica formatao do arquivo e retorna informaes do arquivo para tela
     */
    public function verificaRetornoAction()
    {

        //Arquivo
        $tmp = explode('.', $_FILES[0]['name']);
        $extensao = strtolower(end($tmp));
        $arquivo = date('Ymd_H_i') . '_' . current($tmp) . '.' . $extensao;
        $up = new Filesystem();
        $tmp = $_FILES[0]['tmp_name'];
        $to = DIRETORIO_DOWNLOAD . $arquivo;
        $rs = $up->upload($tmp, $to);
        if (!$rs) {
            $resultado = array('erro'=>utf8_encode('No foi possvel armazenar o arquivo.'));
        } else {
            //Processando arquivo
            $padrao = false;
            $arq = file($to, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
            $padrao = strlen($arq[0]);
            $comReg = true;
            if ($padrao == 240) {
                $ret = new RetornoBoleto($to, $padrao);
                $resultado = $ret->processar($comReg,false,null,true,'N');
                $resultado['header']['nome_empresa'] = utf8_encode($resultado['header']['nome_empresa']);
                $resultado['header']['nome_banco'] = utf8_encode($resultado['header']['nome_banco']);
                $nagencia = str_replace("0","",$resultado['header']['agencia']);
                $nconta = str_replace("0","",$resultado['header']['conta_corrente']);
                $bancoConta = new BancoConta;
                $layoutRemessa =  $bancoConta->listBancoContas($nagencia,$nconta);
                $resultado['header']['cod_layout'] = $layoutRemessa['cod_layout_ret'];
                $resultado['header']['banco'] = $layoutRemessa['cd_banco'];
                $resultado['header']['arq_layout_rem'] = Layout::getTabelaRetornoByCodBanco($layoutRemessa['cod_layout_ret']);
            } else {
                $resultado = array('erro'=>utf8_encode('Arquivo de retorno fora do padro 240.'));
            }
            //Remove o aquivo j processado
            if (file_exists($to)) {
                Filesystem::delete($to);
            }
        }
        echo json_encode($resultado);
    }

    private function integracaoFinanAPI($array_parcelas_ok) {

        if (count($array_parcelas_ok) > 0) {

            foreach ($array_parcelas_ok as $conta) {

            //Criando uma nova linha para inserao
            $adapter = $this->getAdapterIntegracao();
            $adapter->beginTransaction();
            try {
                $data = explode('-', $conta[0]['dt_credito']);
                $contaDados = array(
                    'cd_plano_conta' => $conta[0]['cd_conta_credito'], //Este campo No aceita Null
                    'cd_centro_custo' => $conta[0]['cd_centro_custo'],//$conta[0]['cd_centro_custo'],
                    'nr_mes_competencia' => $data[1],  //Este campo No aceita Null
                    'nr_ano_competencia' => $data[0],  //Este campo No aceita Null
                    'dt_documento' => $conta[0]['dt_credito'],
                    'nr_parcelas' => 1,
                    'vl_total' => $conta[0]['vl_total_pago'],
                    'tp_conta_pagar_receber' => 'R',  //Este campo No aceita Null
                    'ds_observacao' => 'Cobranca Eletronica',
                    'log' => (Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - u')
                );
                $adapter->insert('afn006', $contaDados);
                $idConta = $adapter->lastInsertId('afn006');

                //Insero na tabela de Parcelas de Contas a Pagar
                $parcelaDados = array(
                    'cd_conta_pagar_receber' => $idConta,
                    'cd_forma_pagamento' => 4,
                    'cd_local_pagamento' => $conta[0]['cd_conta_tesouraria'],
                    'nr_parcela' => 1,
                    'vl_parcela' => $conta[0]['vl_total_pago'],
                    'dt_vencimento' => $conta[0]['dt_parcela'],
                    'dt_pagamento' => $conta[0]['dt_pagamento'],
                    'dt_debito' => $conta[0]['dt_credito'],
                    'tp_situacao' => 'P'
                );
                $adapter->insert('afn007', $parcelaDados);

            } catch (Exception $e) {
                $adapter->rollBack();
                $this->redir(array('modulo' => 'bo',
                    "controller" => "retornoBoletoArquivo",
                    "action" => "index"), array("warning" => "No foi possvel gravar as contas pela integrao com Finan."));
            }
            $adapter->commit();
            }
            
        }
    }
}