<?php

class RemessaMultiBancoController extends Controller
{
    protected $tb_parcela;
    protected $tb_remessa;
    protected $tb_banco;
    protected $tb_contrato;
    protected $tb_empreendimento;

    public function __construct($request)
    {
        parent::__construct($request);

        $this->tb_parcela = new Parcela();
        $this->tb_banco = new Banco();
        $this->tb_empreendimento = new Empreendimento();
        $this->tb_contrato = new Contrato();
        $this->tb_remessa = new RemessaBoleto();
    }

    public function indexAction()
    {
        $this->redir(array("modulo" => "bo", "controller" => "remessaMultiBanco", "action" => "listar"));
    }

    public function listarAction()
    {
        if ($this->isAjax()) {
            $listaItem = $this->tb_remessa->getAdapter()->select()
                ->from(array('r' => TB_REMESSA), array('*'))
                ->join(array('e' => TB_EMPREENDIMENTO), 'e.id = r.id_empreendimento', 'nm_empreendimento')
                ->joinLeft(array('sc' => TB_AGRUPADA), 'sc.idTabela = "9" AND sc.idCampo = r.id_banco',  'descricao');
            //Exibe apenas os empreendimentos os quais o usuario tem acesso
            if ($_SESSION['usuario']) {
                try {
                    $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                    $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                    if (count($ids)) {
                        $id = implode(',', $ids);
                        $listaItem->where("e.id IN({$id})");
                    } else {
                        $listaItem->where("1");
                    }
                } catch (Exception $e) {
                }
            }
            $listaItem = $listaItem->where('r.multiBanco = "1"')
                ->order('r.dtGeracao DESC')
                ->query()->fetchAll();

            $lista = array();
            foreach ($listaItem as $item) {
                $acoes = '<div style="width: 90px"></div><div align="center" style="width: 100%;">';
                //Botao Visualizar
                $acoes .= '<span data-toggle="modal" data-target=".mVisualizar"><button type="button" value="' . $item['id'] . '" data-toggle="tooltip" title="VISUALIZAR" class="btn btn-default btn-sm btnVisualizar" style="margin-right:5px"><i class="fa fa-eye"></i> </button></span>';
                $acoes .= '<a target="_blank" href="?m=' . $this->modulo . '&c=' . $this->controller . '&a=gerarRelatorio&id=' . $item['id'] . '" data-toggle="tooltip" title="IMPRIMIR" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-file-o"></i></a>';
                //Botao Baixar
                $acoes .= '<a onClick="baixarArquivo('.$item['id'].')" href="upload/remessas/' . $item['arquivo'] . '" target="_blank" download data-toggle="tooltip" title="BAIXAR" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-download"></i></a>';
                //Titulo Cancelar
                $title = "return confirm('Tem certeza que deseja cancelar a remessa " . $item['id'] . " ?')";
                //Confirmar Envio
                $mensagem = "confirm('Tem certeza que deseja confirmar a remessa " . $item['id'] . " ?')";

                $disabledEnvia = '';
                $disabledCancelar = '';
                switch ($item['tp_status']) {
                    case 'EB':
                        $status = '<div id="status_'.$item['id'].'" class="label label-info">Enviar ao Banco</div>';
                        break;
                    case 'E':
                        $status = '<div id="status_'.$item['id'].'" class="label label-success">Enviado</div>';
                        $disabledEnvia = 'disabled';
                        break;
                    case 'C':
                        $status = '<div id="status_'.$item['id'].'" class="label label-danger">Cancelado</div>';
                        $disabledEnvia = 'disabled';
                        $disabledCancelar = 'disabled';
                        break;
                    default:
                        $status = '<div id="status_'.$item['id'].'" class="label label-warning">Pendente</div>';
                        break;
                }
                $acoes .= '<a onClick="return (' . $mensagem .')? confirmaEnvio('. $item['id'] .'):false;" href="#" data-toggle="tooltip" title="CONFIRMAR ENVIO" class="btn btn-default btn-sm ' . $disabledEnvia . '" style="margin-right:5px"><i class="fa fa-upload"></i></a>';
                $acoes .= '<a onclick="' . $title . '" href="index.php?m=' . $this->modulo . '&c=' . $this->controller . '&a=cancelar&id=' . $item['id'] . '" data-toggle="tooltip" title="CANCELAR" class="btn btn-default btn-sm ' . $disabledCancelar . '" style="margin-right:5px"><i class="fa fa-times"></i></a>';
                $acoes .= '</div>';
                $acoes .= '</div>';

                $file = explode('/', $item['arquivo']);
                $file = end($file);

                //Para ordenar por data
                $data = '<div hidden>' . $item['dtGeracao'] . '</div>' . Helper::getDate($item['dtGeracao']);

                $lista[] = array(
                    'data' => $data,
                    'codigo' => $item['id'],
                    'num_remessa' => $item['nr_remessa'],
                    'empreendimento' => utf8_encode($item['nm_empreendimento']),
                    'banco' => utf8_encode($item['descricao']),
                    'arquivo' => Helper::quebraPalavraGrande($file, 20),
                    'status' => $status,
                    'acoes' => utf8_encode($acoes)
                );
            }
            echo json_encode(array(
                'draw' => $_POST['draw'],
                'data' => $lista
            ));

        } else {
            $this->display('listar');
        }
    }

    public function gerarRemessaAction()
    {
        if ($this->_isPost && $this->validar()) {
            $this->verificarContratosAction();
        } else {
            $empreendimentos = $this->tb_empreendimento->getDefaultAdapter()->select()->distinct('e.id')
                ->from(array('e' => TB_EMPREENDIMENTO), array('empreendimento_nome' => 'nm_empreendimento', 'empreendimento_id' => 'id'))
                ->join(array('l' => TB_LOTES), 'e.id = l.id_empreendimento', array())
                ->join(array('c' => TB_CONTRATO), 'l.id = c.id_lote', array())
                ->join(array('p' => TB_PARCELA), 'c.id = p.id_contrato', array())
                ->join(array('b' => TB_BANCO), 'e.id = b.id_empreendimento', array('idBanco' => 'id'));

            //verifica se o usuario tem o perfil de usuario de empreendimento
            if ($_SESSION['usuario']) {
                try {
                    $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                    $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                    if (count($ids)) {
                        $id = implode(',', $ids);
                        $empreendimentos->where("e.id IN({$id})");
                    } else {
                        $empreendimentos->where("1");
                    }
                } catch (Exception $e) {
                }
            }

            $empreendimentos = $empreendimentos->group('e.id')->order('nm_empreendimento')->query()->fetchAll();

            $this->set('empreendimentos', $empreendimentos);
            $this->set('remessa', $_POST);
            $this->display('form');
        }
    }

    public function verificarContratosAction()
    {

        ini_set("memory_limit", "128M");
        set_time_limit(0);

        $id_empreendimento = $_POST['id_empreendimento'];
        $idBanco = $_POST['banco'];
        $empreendimento = $this->tb_empreendimento->getAdapter()->select()
            ->from(array('emp' => TB_EMPREENDIMENTO), '*')
            ->join(array('b' => TB_BANCO), 'emp.id = b.id_empreendimento', array('*'))
            ->where('emp.id = "' . $id_empreendimento . '"')
            ->where('b.id = ' . $idBanco)
            ->query()->fetch();

        if ($this->_isPost && isset($_POST['passo2'])) {
            $contratos = $_POST['contratos'];
            $banco = $this->tb_banco->getAdapter()->select()
                ->from(array('b' => TB_BANCO), '*')
                ->join(array('bc' => TB_BANCO_CONTA), 'b.id_banco_conta = bc.id_banco_conta', ['nrRemessa' => 'nr_remessa'])
                ->join(array('agr' => TB_AGRUPADA), 'idTabela = 9 AND idCampo = b.cd_banco', 'descricao')
                ->where("id_empreendimento = " . $id_empreendimento)
                ->where("id = ?", $idBanco)
                ->query()->fetch();
                
            if (!$empreendimento)
                $empreendimento = $this->tb_empreendimento->getAdapter()->select()
                    ->from(array('emp' => TB_EMPREENDIMENTO), '*')
                    ->join(array('b' => TB_BANCO), 'emp.id = b.id_empreendimento', array('*'))
                    ->where('emp.id = "' . $id_empreendimento . '"')
                    ->where('b.id = ' . $banco['id'])
                    ->query()->fetch();

            $tipoParcelas = array();
            foreach ($_POST['tipos'] as $p) {
                $tipoParcelas[] = "'" . $p . "'";
            }
            $tipoParcelas = implode(',', $tipoParcelas);
            $totalParcelas = 0;
            $auxContratos = array();

            foreach ($contratos as $k => &$contrato) {
                $parcelasContrato = $this->tb_parcela->getAdapter()->select()
                    ->from(array('p' => TB_PARCELA), array('id_parcela_contrato', 'id_contrato', 'vl_parcela', 'dt_parcela', 'increment_id', 'id_parcela', 'tp_parcela', 'vl_parcela_2avia', 'dt_parcela_2avia', 'desconto', 'acrescimo', 'nr_boleto', 'ano_boleto_emissao', 'fl_envio', 'desconto_2via', 'txid'))
                    ->join(array('c' => TB_CONTRATO), 'p.id_contrato = c.id', array('id_pessoa', 'id_lote'))
                    ->join(array('l' => TB_LOTES), 'c.id_lote = l.id', null)
                    ->join(array('b' => TB_BANCO), 'b.id_banco_conta = p.id_banco_boleto AND b.id = ' . $_POST['banco'], '')
                    ->join(array('e' => TB_EMPREENDIMENTO), 'e.id = l.id_empreendimento', null)
                    ->join(array('pe' => TB_PESSOA), 'pe.id = c.id_pessoa', array('numero_pessoa'=>'id','nm_pessoa', 'endereco', 'nr_endereco', 'nr_cep', 'nm_bairro', 'tp_pessoa','id_pessoa_api_asaas'))
                    ->joinLeft(array('pf' => TB_PESSOA_FISICA), 'pe.id = pf.id_pessoa', array('nr_cpf', 'dt_nascimento'))
                    ->joinLeft(array('pj' => TB_PESSOA_JURIDICA), 'pe.id = pj.id_pessoa', array('nr_cnpj'))
                    ->joinLeft(array('ci' => TB_CIDADE), 'pe.cd_cidade = ci.id', array('cidade' => 'nome', 'uf'))
                    ->where('c.id = ' . $contrato)
                    ->where('p.pago = "0"')
                    ->where('p.id_banco_boleto = b.id_banco_conta')
                    ->where('p.id_remessa is null')
                    ->where('p.tp_parcela IN (' . $tipoParcelas . ')')
                    ->where('dt_parcela between "' . Helper::getInputDate($_POST['dtInicio']) . '" and "' . Helper::getInputDate($_POST['dtFim']) . '" OR '
                        . 'dt_parcela_2avia between "' . Helper::getInputDate($_POST['dtInicio']) . '" and "' . Helper::getInputDate($_POST['dtFim']) . '"')
                    ->where('p.fl_envio = "1"')
                    ->order('pe.nm_pessoa')
                    ->query()->fetchAll();
                    
                //Verifica os valores das parcelas de segunda via e endereco
                $auxParcelas = array();
                $parcelasDesvinculadas = isset($_POST['vinculo'])?$_POST['vinculo']:array();
                foreach ($parcelasContrato as $parcela)
                    if (!in_array((int)$parcela['id_parcela_contrato'], $parcelasDesvinculadas)) {
                        if ($parcela['dt_parcela_2avia'])
                            $parcela['dt_parcela'] = $parcela['dt_parcela_2avia'];
                        if ((float)$parcela['vl_parcela_2avia'] > 0)
                            $parcela['vl_parcela'] = $parcela['vl_parcela_2avia'];
                        if ($parcela['nr_endereco'] != '')
                            $parcela['endereco'] = $parcela['endereco'] . ', ' . $parcela['nr_endereco'];
                        $parcela['vl_parcela'] = $parcela['vl_parcela'] - $parcela['desconto'] + $parcela['acrescimo'];
                        $auxParcelas[] = $parcela;
                    }

                if (count($parcelasContrato) > 0) {
                    $auxContratos[] = array('id' => $contrato, 'parcelas' => $auxParcelas);
                    $totalParcelas += count($auxParcelas);
                } else
                    unset($contratos[$k]);
            }
            
            $contratos = $auxContratos;
            if (count($contratos) > 0) {
                $alphaNumArr = array('A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'X', 'Z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9');
                switch ($banco['cd_banco']) {
                    case Banco::BANCO_CAIXA_ECONOMICA:
                        $remesasDoDia = $this->tb_remessa->fetchAll("dtGeracao = '" . date('Y-m-d') . "' AND id_banco = '104'");
                        $total = str_pad(count($remesasDoDia) + 1, 2, '0', STR_PAD_LEFT);
                        $primeira = $alphaNumArr[(int)substr($total, 0, -1)];
                        $segunda = (int)(($total) % 10);
                        $arquivo = 'E' . date('d') . date('m') . $primeira . $segunda . '.REM';
                        break;
                    case Banco::BANCO_SICREDI:
                        switch (date('n')) {
                            case 10:
                                $mes = 'O';
                                break;
                            case 11:
                                $mes = 'N';
                                break;
                            case 12:
                                $mes = 'D';
                                break;
                            default:
                                $mes = date('n');
                                break;
                        }

                        $lastRemessa = (new RemessaBoleto())->fetchRow('id_banco = '.$banco['cd_banco'].' AND dtGeracao = "'.date('Y-m-d').'" AND tp_status != "C"', ['id DESC']);
                        $fileExt = 'CRM';

                        if ($lastRemessa) {
                            $file = explode('/', $lastRemessa['arquivo']);
                            $file = end($file);
                            $fileCedente = substr($file, 0, 5);
                            $lastCaracterExt = substr($file, strpos($file, "RM") + 2);
                            if ($fileCedente != $empreendimento['cd_cedente']) {
                                $lastRemessa = (new RemessaBoleto())->fetchRow('id_banco = '.$banco['cd_banco'].' AND dtGeracao = "'.date('Y-m-d').'" AND tp_status != "C"', ['id DESC']);
                                if ($lastRemessa) {
                                    $lastCaracterExt = substr(explode('/', $lastRemessa['arquivo']), -1);
                                }
                            }

                            if ($lastRemessa) {
                                if (!$lastCaracterExt) {
                                    $fileExt = 'RM2';
                                } else {
                                    $fileExt = 'RM'.($lastCaracterExt+1);
                                }
                            }
                        }
                        $arquivo = $empreendimento['cd_cedente']. $mes . date('d') . '.'.$fileExt;
                        break;

                    case Banco::BANCO_BANPARA:
                        $arquivo = 'CLI_CRB_'. $empreendimento['cd_cedente'] . '_' . date('Ymd') . '_CNAB240REM.';
                        $remesasDoDia = $this->tb_remessa->fetchAll("dtGeracao = '" . date('Y-m-d') . "' AND id_banco = ". Banco::BANCO_BANPARA);
                        $arquivo .= str_pad(count($remesasDoDia) + 1, 6, '0', STR_PAD_LEFT);
                        break;

                    default:
                        $remesasDoDia = $this->tb_remessa->fetchAll("dtGeracao = '" . date('Y-m-d') . "' AND id_banco NOT IN ('".Banco::BANCO_CAIXA_ECONOMICA."','".Banco::BANCO_SICREDI."')");
                        $total = str_pad(count($remesasDoDia) + 1, 2, '0', STR_PAD_LEFT);
                        $primeira = $alphaNumArr[(int)substr($total, 0, -1)];
                        $segunda = (int)(($total) % 10);
                        $arquivo = 'CB' . date('d') . date('m') . $primeira . $segunda . '.REM';
                }
                $path = explode('.', $_SERVER['HTTP_HOST']);
                if ($path[0] == 'www') {
                    $path = $path[1];
                } else {
                    $path = $path[0];
                }
                $path = $path . '/' . date('Y') . '/' . $arquivo;
                $remessa = new RemessaBoleto();
                $remessa = $remessa->createRow();
                $remessa->id_empreendimento = $id_empreendimento;
                $remessa->dtGeracao = date('Y-m-d');
                $remessa->periodo = "de {$_POST['dtInicio']} a {$_POST['dtFim']}";
                $remessa->qtdeRegistros = $totalParcelas;
                $remessa->arquivo = $path;
                $remessa->log = Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:i:s') . ' - i';
                $remessa->tp_status = 'P';
                $remessa->nr_remessa = $banco['nrRemessa'];
                $remessa->id_banco = $banco['cd_banco'];
                $remessa->multiBanco = '1';
                $idRemessa = $remessa->save();
                if ($idRemessa) {
                    //salva nas parcelas o id da remessa
                    foreach ($contratos as $contrato) {
                        $ids_parcela_registro = '';
                        foreach ($contrato['parcelas'] as $p) {
                            $ids_parcela_registro .= $p['id_parcela'] . $p['tp_parcela'] . ",";
                            Parcela::updateRemessaById($p['id_parcela_contrato'], $idRemessa);
                            RemessaItens::addParcela($p, $idRemessa);
                        }
                        //Salva o log nos contatos realizados
                        $referencia = 'Log: Envio de remessa Nr. ' . $idRemessa . ' referente as parcelas ' . $ids_parcela_registro;
                        (new Relacionamento())->saveContato(50, date('Y-m-d'), $contrato['id'], $referencia);
                    }
                    $dados['idRemessa'] = $banco['nrRemessa'];
                    $dados['idEmpreendimento'] = $id_empreendimento;
                    $dados['cdBanco'] = $banco['cd_banco'];
                    $dados['contratos'] = $contratos;
                    $dados['tp_multa'] = $banco['tp_multa'];
                    $dados['tp_juros'] = $banco['tp_juros'];
                    //Adiciona os dados do fetch das informacoes do empreendimento
                    foreach ($empreendimento as $k => $campo) {
                        $dados[$k] = $campo;
                    }
                    //Teste para santander que possui uma geracao completamente diferente dos outros
                    if ($banco['cd_banco'] == Banco::BANCO_SANTANDER) {
                        $retorno = RemessaSantander::geraRemessa($dados, $arquivo);
                    } else
                        $retorno = RemessaInstrucao::geraRemessa($dados, $arquivo);
                    if ($retorno[1]) {
                        $this->redir(array('modulo' => 'bo', "controller" => "remessaMultiBanco", "action" => 'listar'), array("exception" => "No foi possvel gerar a remessa."));
                    } else {
                        // Incrementa o numero da remessa dao banco conta
                        $bancoConta = (new BancoConta())->fetchRow('id_banco_conta = '.$banco['id_banco_conta']);
                        $bancoConta->nr_remessa = $bancoConta['nr_remessa'] + 1;
                        $bancoConta->save();
                        $this->redir(array('modulo' => 'bo', "controller" => "remessaMultiBanco", "action" => 'listar'), array("msg" => "success"));
                    }
                } else {
                    $this->redir(array('modulo' => 'bo', "controller" => "remessaMultiBanco", "action" => 'listar'), array("exception" => "No foi possvel gerar a remessa."));
                }
            } else {
                $this->redir(array('modulo' => 'bo', "controller" => "remessaMultiBanco", "action" => 'listar'), array("exception" => "Nenhuma parcela foi selecionada para gerao."));
            }
        } else {
            $banco = $this->tb_banco->getAdapter()->select()
                ->from(array('b' => TB_BANCO), '*')
                ->join(array('agr' => TB_AGRUPADA), 'idTabela = 9 AND idCampo = cd_banco', 'descricao')
                ->where("id = ?", $idBanco)
                ->query()->fetch();

                $contratos = $this->tb_contrato->getAdapter()->select()
                ->from(array('c' => TB_CONTRATO), '*')
                ->join(array("l" => TB_LOTES), "c.id_lote = l.id", array('lote', 'quadra'))
                ->join(array("pa" => TB_PARCELA), "c.id = pa.id_contrato", '')
                ->join(array('b' => TB_BANCO), 'b.id_banco_conta = pa.id_banco_boleto AND b.id = ' . $_POST['banco'], '')
                ->join(array("p" => TB_PESSOA), "c.id_pessoa = p.id", 'nm_pessoa')
                ->where('l.id_empreendimento = ?', $_POST['id_empreendimento'])
                ->where('pa.id_remessa IS NULL')
                ->where('pa.tp_parcela NOT IN ("E","NE","SE","CE","IE")')
                ->where('pa.pago = "0"')
                ->where('pa.fl_envio = "1"')
                ->where('pa.id_banco_boleto = b.id_banco_conta')
                ->where('(pa.dt_parcela >= "' . Helper::getInputDate($_POST['dtInicio']) . '" AND pa.dt_parcela <= "' . Helper::getInputDate($_POST['dtFim']) . '") OR (pa.dt_parcela_2avia >= "' . Helper::getInputDate($_POST['dtInicio']) . '" AND pa.dt_parcela_2avia <= "' . Helper::getInputDate($_POST['dtFim']) . '")');

            if ($_POST['id_contrato'][0] != '*')
            {
                $aux = implode('","', $_POST['id_contrato']);

                $contratos = $contratos->where('c.id IN ("' . $aux . '")');
            }

            $contratos = $contratos->order('p.nm_pessoa')->group('c.id')
                ->query()->fetchAll();
            
            if (count($contratos)) {
                $this->set("action", '?m=bo&c=remessaMultiBanco&a=verificarContratos&passo2=true');
                $this->set('contratos', $contratos);
                $this->set('banco', $banco);
                $this->set('empreendimento', $empreendimento);
                $this->set('remessa', $_POST);
                $this->set('back', $this->_helper->getLink(array('m' => 'bo', 'c' => 'remessa', 'a' => 'gerarRemessa')));
                $this->display('verificarContratos');
            } else {
                $this->redir(array("modulo" => "bo", "controller" => "remessaMultiBanco", "action" => "gerarRemessa"), array('exception' => 'No foram encontrados parcelas para remessa neste perodo.'));
            }
        }
    }

    public function cancelarAction()
    {
        try {
            $remessa = $this->tb_remessa->fetchRow('id = ' . $_GET['id']);
            $remessa->tp_status = 'C';
            if ($remessa->save()) {
                $parcelas = Parcela::cancelaRemessa($_GET['id']);

                if ($parcelas)
                    $this->redir(array("modulo" => "bo", "controller" => "remessaMultiBanco"), array("msg" => "success"));
                else
                    $this->redir(array("modulo" => "bo", "controller" => "remessaMultiBanco"), array('exception' => 'No foi possvel alterar as parcelas.'));
            }
        } catch (Exception $e) {
            $this->redir(array("modulo" => "bo", "controller" => "remessaMultiBanco"), array('exception' => $e->getMessage()));
        }
    }

//Busca as parcelas do contrato selecionado para exibir os dados na tabela
    public function buscaParcelasAction()
    {
        $parcelas = Parcela::findParcelasNPagasById($_POST['contrato'], $_POST['dtInicio'], $_POST['dtFinal'], true,$_POST['banco']);
        //Busca apenas as nao pagas sem remessa considerando a segunda via emitida
        $auxParcelas = array();
        foreach ($parcelas as $p) {
            if ((float)$p['vl_parcela_2avia'] > 0) {
                $p['dt_parcela'] = Helper::getDate($p['dt_parcela_2avia']);
                $p['vl_parcela'] = $p['vl_parcela_2avia'];
            }
            $p['vl_parcela'] = $p['vl_parcela'] - $p['desconto'] + $p['acrescimo'];
            if ($p['id_remessa'] == null) {
                $auxParcelas[] = $p;
            }
        }
        echo json_encode($auxParcelas);
    }

//Busca as parcelas do contrato selecionado, gera o arquivo e baixa a remessa
    public function baixarArquivoAction()
    {
        $remessa = new RemessaBoleto();
        $remessa = $remessa->fetchRow('id = ' . $_POST['id']);
        if ($remessa->tp_status != 'C' && $remessa->tp_status != 'E')
            $remessa->tp_status = 'EB';

        echo json_encode($remessa->save());
    }

    public function confirmaEnvioAction()
    {
        $remessa = new RemessaBoleto();
        $remessa = $remessa->fetchRow('id = ' . $_POST['id']);
        if ($remessa->tp_status != 'C' && $remessa->tp_status != 'P')
            $remessa->tp_status = 'E';

        echo json_encode($remessa->save());
    }

    public function visualizarAction()
    {
        if ($this->isAjax()) {
            $item = $this->tb_remessa->getDados($_POST['cdItem']);
            echo json_encode($item);
        }
    }

    public function validar()
    {
        $campos = array('dtInicio' => 'Informe a data de incio.', 'dtFim' => 'Informe a data de fim.', 'id_empreendimento' => 'Selecione o empreendimento.', 'banco' => 'Selecione o Banco.');
        foreach ($campos AS $k => $msg) {
            if ($_POST[$k] == '') {
                $this->_helper->addMensagem($k, $msg);
            }
        }

        if (!(count($this->_helper->getMensagens()) > 0)) {
            $ini = strtotime(str_replace('/', '-', $_POST['dtInicio']));
            $fim = strtotime(str_replace('/', '-', $_POST['dtFim']));
            $hoje= Helper::getDate(date('Y-m-d'));
            $hoje= strtotime(str_replace('/', '-', $hoje));
            if ($ini > $fim) {
                $this->_helper->addMensagem('erroData', 'O perodo informado  invlido');
            }
            if($ini < $hoje){
                $this->_helper->addMensagem('erroData', 'O perodo inicial no pode ser inferior ao dia de hoje');
            }
        }

        return !(count($this->_helper->getMensagens()) > 0);
    }

    public function validar2()
    {
        $campos = array(
            'dtInicio' => 'Informe a data de incio.',
            'dtFim' => 'Informe a data de fim.',
            'id_empreendimento' => 'Selecione o empreendimento.',
            'banco' => 'Selecione o Banco.'
        );

        foreach ($campos AS $k => $msg) {
            if ($_POST[$k] == '') {
                $this->_helper->addMensagem($k, $msg);
            }
        }

        return !(count($this->_helper->getMensagens()) > 0);
    }

    /**
     * Lista em ajax dos nomes dos bancos cadastrados no empreendimento
     */
    public function bancoByEmpreendimentoAction()
    {
        $bancos = Banco::findByEmpreendimento($_POST['id_empreendimento'],false, false, true);
        $lista = array();
        foreach ($bancos as $banco) {
            $banco['nmBanco'] = Banco::findBancoNome($banco['cd_banco']);
            $lista[] = array('id' => $banco['id'],
                'text' => utf8_encode($banco['nmBanco']) . ' - Ag.: ' . $banco['agencia'] . '-' . $banco['agencia_dv'] . '  Cc: ' . $banco['conta_corrente'] . '-' . $banco['conta_corrente_dv']
            );
        }

        echo json_encode($lista);
    }

    public function contratoByBancoEmpreendimentoAction()
    {
        $contratos = Contrato::byBancoEmpreendimento($_POST['id_empreendimento'], $_POST['banco'], Contrato::CONTRATO_GERADO, true, array("nm_pessoa", "lote", "quadra", "id"), true);

        $lista = array(
            array('id' => '*', 'text' => 'Todos')
        );
        foreach ($contratos as $contrato) {
            $lista[] = array('id' => $contrato['id'], 'text' => utf8_encode($contrato['nm_pessoa']) . ' - Quadra: ' . utf8_encode($contrato['quadra']) . ' - Lote: ' . utf8_encode($contrato['lote']) . ' - Contrato: ' . utf8_encode($contrato['id']));
        }

        echo json_encode($lista);
    }

    public function gerarRelatorioAction()
    {
        $tbClienteAcade = new Db_Cliente();
        $this->set('clienteAcade', $tbClienteAcade->fetchRow()->toArray());

        $infoParcela = $this->tb_remessa->getAdapter()->select()
            ->from(array("r" => TB_REMESSA), array('*'))
            ->join(array("e" => TB_EMPREENDIMENTO), "r.id_empreendimento = e.id", array('nm_empreendimento', 'id_tipo_loteamento'))
            ->joinLeft(array('t' => TB_TIPO_LOTEAMENTO), 'e.id_tipo_loteamento = t.id_tipo_loteamento', array('*'))
            ->where('r.id = ?', $_GET['id'])
            ->query()->fetch();

        $infoCliente = $this->tb_remessa->getAdapter()->select()
            ->from(array('ri' => TB_REMESSA_ITENS), array('id_contrato', 'tp_parcela', 'nr_parcela', 'dt_parcela', 'vl_parcela'))
            ->join(array('l' => TB_LOTES), 'ri.id_lote = l.id', array('quadra', 'lote'))
            ->join(array('p' => TB_PESSOA), 'ri.id_pessoa = p.id', array('nm_pessoa'))
            ->where('ri.id_remessa = ?', $_GET['id'])
            ->order('ri.nr_parcela ASC')
            ->query()->fetchAll();

        $this->set('infoParcela', $infoParcela);
        $this->set('infoCliente', $infoCliente);

        $this->displayMPDF("gerarRelatorio.pdf");
    }

    public function contratoByEmpreendimentoAction()
    {
        $contratos = Contrato::byEmpreendimento($_POST['id_empreendimento'], Contrato::CONTRATO_TODOS, 2, array("nm_pessoa", "lote", "quadra", "id"), true);

        $lista = array();
        foreach ($contratos as $contrato) {
            if ($contrato['fl_distrato'] == '1')
                $color = 'color: red;';
            else
                $color = null;

            $lista[] = array(
                'id' => $contrato['id'],
                'text' => utf8_encode($contrato['nm_pessoa']) . ' - Quadra: ' . utf8_encode($contrato['quadra']) . ' - Lote: ' . utf8_encode($contrato['lote']) . ' - Contrato: ' . $contrato['id'],
                'estilo' => $color
            );
        }

        echo json_encode($lista);
    }
}