<?php
/**/
class RemessaController extends Controller
{
    protected $tb_parcela;
    protected $tb_remessa;
    protected $tb_banco;
    protected $tb_contrato;
    protected $tb_empreendimento;

    public function __construct($request)
    {
        parent::__construct($request);

        $this->tb_parcela = new Parcela();
        $this->tb_banco = new Banco();
        $this->tb_empreendimento = new Empreendimento();
        $this->tb_contrato = new Contrato();
        $this->tb_remessa = new RemessaBoleto();
    }

    public function indexAction()
    {
        $this->redir(array("modulo" => "bo", "controller" => "remessa", "action" => "listar"));
    }

    public function listarAction()
    {
        if ($this->isAjax()) {
            $listaItem = $this->tb_remessa->getAdapter()->select()
                ->from(array('r' => TB_REMESSA), array('*'))
                ->join(array('e' => TB_EMPREENDIMENTO), 'e.id = r.id_empreendimento', 'nm_empreendimento')
                ->joinLeft(array('sc' => TB_AGRUPADA), 'sc.idTabela = "9" AND sc.idCampo = r.id_banco',  'descricao');
            //Exibe apenas os empreendimentos os quais o usuario tem acesso
            if ($_SESSION['usuario']) {
                try {
                    $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                    $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                    if (count($ids)) {
                        $id = implode(',', $ids);
                        $listaItem->where("e.id IN({$id})");
                    } else {
                        $listaItem->where("1");
                    }
                } catch (Exception $e) {
                }
            }
            $listaItem = $listaItem->order('r.dtGeracao DESC')
                ->query()->fetchAll();

            $lista = array();
            foreach ($listaItem as $item) {
                $acoes = '<div style="width: 90px"></div><div align="center" style="width: 100%;">';
                //Botao Visualizar
                $acoes .= '<span data-toggle="modal" data-target=".mVisualizar"><button type="button" value="' . $item['id'] . '" data-toggle="tooltip" title="VISUALIZAR" class="btn btn-default btn-sm btnVisualizar" style="margin-right:5px"><i class="fa fa-eye"></i> </button></span>';
                $acoes .= '<a target="_blank" href="?m=' . $this->modulo . '&c=' . $this->controller . '&a=gerarRelatorio&id=' . $item['id'] . '" data-toggle="tooltip" title="IMPRIMIR" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-file-o"></i></a>';
                //Botao Baixar
                $acoes .= '<a onClick="baixarArquivo('.$item['id'].')" href="upload/remessas/' . $item['arquivo'] . '" target="_blank" download data-toggle="tooltip" title="BAIXAR" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-download"></i></a>';
                //Titulo Cancelar
                $title = "return confirm('Tem certeza que deseja cancelar a remessa " . $item['id'] . " ?')";
                //Confirmar Envio
                $mensagem = "confirm('Tem certeza que deseja confirmar a remessa " . $item['id'] . " ?')";

                $disabledEnvia = '';
                $disabledCancelar = '';
                switch ($item['tp_status']) {
                    case 'EB':
                        $status = '<div id="status_'.$item['id'].'" class="label label-info">Enviar ao Banco</div>';
                        $disabledBoletoapi = 'disabled';
                        break;
                    case 'API':
                        $status = '<div id="status_'.$item['id'].'" class="label label-warning">Banco Digital</div>';
                        $disabledBoletoapi = 'enabled';
                        break;
                    case 'E':
                        $status = '<div id="status_'.$item['id'].'" class="label label-success">Enviado</div>';
                        $disabledBoletoapi = 'disabled';
                        $disabledEnvia = 'disabled';
                        break;
                    case 'C':
                        $status = '<div id="status_'.$item['id'].'" class="label label-danger">Cancelado</div>';
                        $disabledEnvia = 'disabled';
                        $disabledCancelar = 'disabled';
                        $disabledBoletoapi = 'disabled';

                        break;
                    default:
                        $status = '<div id="status_'.$item['id'].'" class="label label-warning">Pendente</div>';
                        $disabledBoletoapi = 'disabled';
                        break;
                }
                $acoes .= '<a onClick="return (' . $mensagem .')? confirmaEnvio('. $item['id'] .'):false;" href="#" data-toggle="tooltip" title="CONFIRMAR ENVIO" class="btn btn-default btn-sm ' . $disabledEnvia . '" style="margin-right:5px"><i class="fa fa-upload"></i></a>';
                $acoes .= '<a target="_blank" href="index.php?m=' . $this->modulo . '&c=' . $this->controller . '&a=boletosapi&id=' . $item['id'] . '" data-toggle="tooltip" title="IMPRIMIR BOLETO" class="btn btn-default btn-sm ' . $disabledBoletoapi . '" style="margin-right:5px"><i class="fa fa-print"></i></a>';
                $acoes .= '<a onclick="' . $title . '" href="index.php?m=' . $this->modulo . '&c=' . $this->controller . '&a=cancelar&id=' . $item['id'] . '" data-toggle="tooltip" title="CANCELAR" class="btn btn-default btn-sm ' . $disabledCancelar . '" style="margin-right:5px"><i class="fa fa-times"></i></a>';
                $acoes .= '</div>';
                $acoes .= '</div>';

                $file = explode('/', $item['arquivo']);
                $file = end($file);

                //Para ordenar por data
                $data = '<div hidden>' . $item['dtGeracao'] . '</div>' . Helper::getDate($item['dtGeracao']);

                $lista[] = array(
                    'data' => $data,
                    'codigo' => $item['id'],
                    'num_remessa' => $item['nr_remessa'],
                    'empreendimento' => utf8_encode($item['nm_empreendimento']),
                    'banco' => utf8_encode($item['descricao']),
                    'arquivo' => Helper::quebraPalavraGrande($file, 20),
                    'status' => $status,
                    'acoes' => utf8_encode($acoes)
                );
            }
            echo json_encode(array(
                'draw' => $_POST['draw'],
                'data' => $lista
            ));

        } else {
            $this->display('listar');
        }
    }

    public function gerarRemessaAction()
    {
        if (!Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'gerarRemessa')) {
            $this->redir(array('modulo' => 'bo', 'controller' => 'remessa', 'action' => 'listar'), array('msgErros' => 'fail', 'exception' => 'Voc no tem permisso para acessar essa funcionalidade.'));
        }

        if ($this->_isPost && $this->validar()) {
            $this->verificarContratosAction();
        } else {
            $empreendimentos = $this->tb_empreendimento->getDefaultAdapter()->select()->distinct('e.id')
                ->from(array('e' => TB_EMPREENDIMENTO), array('empreendimento_nome' => 'nm_empreendimento', 'empreendimento_id' => 'id'))
                ->join(array('l' => TB_LOTES), 'e.id = l.id_empreendimento', array())
                ->join(array('c' => TB_CONTRATO), 'l.id = c.id_lote', array())
                ->join(array('p' => TB_PARCELA), 'c.id = p.id_contrato', array())
                ->join(array('b' => TB_BANCO), 'e.id = b.id_empreendimento', array('idBanco' => 'id'));

            //verifica se o usuario tem o perfil de usuario de empreendimento
            if ($_SESSION['usuario']) {
                try {
                    $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                    $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                    if (count($ids)) {
                        $id = implode(',', $ids);
                        $empreendimentos->where("e.id IN({$id})");
                    } else {
                        $empreendimentos->where("1");
                    }
                } catch (Exception $e) {
                }
            }

            $empreendimentos = $empreendimentos->group('e.id')->order('nm_empreendimento')->query()->fetchAll();
            
            $hostCliente = explode('.', $_SERVER['HTTP_HOST']);
            if ($hostCliente[0] == 'www') {
                $hostCliente = $hostCliente[1];
            } else {
                $hostCliente = $hostCliente[0];
            }
            
            $this->set('cliente', $hostCliente);
            $this->set('empreendimentos', $empreendimentos);
            $this->set('remessa', $_POST);
            $this->display('form');
        }
    }

    public function verificarContratosAction()
    {

        ini_set("memory_limit", "128M");
        set_time_limit(0);

        $id_empreendimento = $_POST['id_empreendimento'];
        $idBanco = $_POST['banco'];
        $tipo_remessa = $_POST['tipo'];
        $dados['tipo_remessa'] = $_POST['tipo'];
        
        $empreendimento = $this->tb_empreendimento->getAdapter()->select()
            ->from(array('emp' => TB_EMPREENDIMENTO), '*')
            ->join(array('b' => TB_BANCO), 'emp.id = b.id_empreendimento', array('*'))
            ->where('emp.id = "' . $id_empreendimento . '"')
            ->where('b.id = ' . $idBanco)
            ->query()->fetch();
        if ($this->_isPost && isset($_POST['passo2'])) {
            
            $contratos = $_POST['contratos'];
            $banco = $this->tb_banco->getAdapter()->select()
                ->from(array('b' => TB_BANCO), '*')
                ->join(array('bc' => TB_BANCO_CONTA), 'b.id_banco_conta = bc.id_banco_conta', array('nrRemessa' => 'nr_remessa' ,'cod_layout_rem','cod_layout_ret','cod_layout_api'))
                ->join(array('agr' => TB_AGRUPADA), 'idTabela = 9 AND idCampo = b.cd_banco', 'descricao')
                ->where("id_empreendimento = " . $id_empreendimento)
                ->where("id = ?", $idBanco)
                ->query()->fetch();
            if (!$empreendimento)
                $empreendimento = $this->tb_empreendimento->getAdapter()->select()
                    ->from(array('emp' => TB_EMPREENDIMENTO), '*')
                    ->join(array('b' => TB_BANCO), 'emp.id = b.id_empreendimento', array('*'))
                    ->where('emp.id = "' . $id_empreendimento . '"')
                    ->where('b.id = ' . $banco['id'])
                    ->query()->fetch();

            $tipoParcelas = array();
            foreach ($_POST['tipos'] as $p) {
                $tipoParcelas[] = "'" . $p . "'";
            }
            $tipoParcelas = implode(',', $tipoParcelas);
            $totalParcelas = 0;
            $auxContratos = array();

            foreach ($contratos as $k => &$contrato) {
                $parcelasContrato = $this->tb_parcela->getAdapter()->select()
                    ->from(array('p' => TB_PARCELA), array('id_parcela_contrato', 'id_contrato', 'vl_parcela', 'dt_parcela', 'increment_id', 'id_parcela', 'tp_parcela', 'vl_parcela_2avia', 'dt_parcela_2avia', 'desconto', 'acrescimo', 'nr_boleto', 'ano_boleto_emissao', 'fl_envio', 'desconto_2via', 'txid'))
                    ->join(array('c' => TB_CONTRATO), 'p.id_contrato = c.id', array('id_pessoa', 'id_lote'))
                    ->join(array('l' => TB_LOTES), 'c.id_lote = l.id', null)
                    ->join(array('e' => TB_EMPREENDIMENTO), 'e.id = l.id_empreendimento', null)
                    ->join(array('pe' => TB_PESSOA), 'pe.id = c.id_pessoa', array('numero_pessoa'=>'id','nm_pessoa', 'endereco', 'nr_endereco', 'nr_cep', 'nm_bairro', 'tp_pessoa','id_pessoa_api_asaas'))
                    ->joinLeft(array('pf' => TB_PESSOA_FISICA), 'pe.id = pf.id_pessoa', array('nr_cpf', 'dt_nascimento'))
                    ->joinLeft(array('pj' => TB_PESSOA_JURIDICA), 'pe.id = pj.id_pessoa', array('nr_cnpj'))
                    ->joinLeft(array('ci' => TB_CIDADE), 'pe.cd_cidade = ci.id', array('cidade' => 'nome', 'uf'))
                    ->joinLeft(array('b' => TB_BANCO), 'b.id_banco_conta = p.id_banco_boleto AND b.id = ' . $_POST['banco'], '')
                    ->where('c.id = ' . $contrato)
                    ->where('p.pago = "0"')
                    ->where('p.id_banco_boleto = b.id_banco_conta or p.id_banco_boleto is null')
                    ->where('p.id_remessa is null')
                    ->where('p.tp_parcela IN (' . $tipoParcelas . ')')
                    ->where('dt_parcela between "' . Helper::getInputDate($_POST['dtInicio']) . '" and "' . Helper::getInputDate($_POST['dtFim']) . '" OR '
                        . 'dt_parcela_2avia between "' . Helper::getInputDate($_POST['dtInicio']) . '" and "' . Helper::getInputDate($_POST['dtFim']) . '"')
                    ->where('p.fl_envio = "1"')
                    ->order('pe.nm_pessoa')
                    ->query()->fetchAll();
                //Verifica os valores das parcelas de segunda via e endereco
                $auxParcelas = array();
                $parcelasDesvinculadas = isset($_POST['vinculo'])?$_POST['vinculo']:array();

                foreach ($parcelasContrato as $j => $parcela) {
                    if (!in_array((int)$parcela['id_parcela_contrato'], $parcelasDesvinculadas)) {
                        if ($parcela['dt_parcela_2avia'])
                            $parcela['dt_parcela'] = $parcela['dt_parcela_2avia'];
                        if ((float)$parcela['vl_parcela_2avia'] > 0)
                            $parcela['vl_parcela'] = $parcela['vl_parcela_2avia'];
                        if ($parcela['nr_endereco'] != '')
                            $parcela['endereco'] = $parcela['endereco'] . ', ' . $parcela['nr_endereco'];
                        $parcela['vl_parcela'] = $parcela['vl_parcela'] - $parcela['desconto'] + $parcela['acrescimo'];
                        $auxParcelas[] = $parcela;
                    }
                }

                if (count($parcelasContrato) > 0) {
                    $auxContratos[] = array('id' => $contrato, 'parcelas' => $auxParcelas);
                    $totalParcelas += count($auxParcelas);
                } else
                    unset($contratos[$k]);
            }

            $contratos = $auxContratos;

            if ($banco['cd_banco'] == '741' || $banco['cd_banco'] == '748')
            {
                foreach ($contratos as $k => $contrato) {

                    foreach ($contrato['parcelas'] as $j => $parcela) {

                        if ($parcela['nr_boleto'] == null) {
                            unset($contratos[$k]['parcelas'][$j]);
                        }
                    }

                    if ($contratos[$k]['parcelas'] == null) {
                        unset($contratos[$k]);
                    }
                }
            }

            if (count($contratos) > 0) {
                $alphaNumArr = array('A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'X', 'Z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9');
                $msgLog = '';

                switch ($banco['cd_banco']) {
                    case Banco::BANCO_CAIXA_ECONOMICA:
                        $remesasDoDia = $this->tb_remessa->fetchAll("dtGeracao = '" . date('Y-m-d') . "' AND id_banco = '104'");
                        $total = str_pad(count($remesasDoDia) + 1, 2, '0', STR_PAD_LEFT);
                        $primeira = $alphaNumArr[(int)substr($total, 0, -1)];
                        $segunda = (int)(($total) % 10);
                        $arquivo = 'E' . date('d') . date('m') . $primeira . $segunda . '.REM';
                        $msgLog = 'Remessa gerada - Banco Caixa | ';
                        break;
                    case Banco::BANCO_SICREDI:
                        switch (date('n')) {
                            case 10:
                                $mes = 'O';
                                break;
                            case 11:
                                $mes = 'N';
                                break;
                            case 12:
                                $mes = 'D';
                                break;
                            default:
                                $mes = date('n');
                                break;
                        }
                        
                        $lastRemessa = $this->tb_remessa->getAdapter()->select()
                            ->from(['r' => TB_REMESSA], '*')
                            ->join(['b' => TB_BANCO], 'r.id_banco = b.cd_banco', ['idCedente' => 'cd_cedente'])
                            ->where('b.cd_cedente = "' . $empreendimento['cd_cedente'] . '"')
                            // ->where('r.id_empreendimento = "' . $empreendimento['id_empreendimento'] . '"')
                            ->where('r.id_banco = "' . $banco['cd_banco'] . '"')
                            ->where('r.dtGeracao = "' . date('Y-m-d') . '"')
                            ->where('r.tp_status != "C"')
                            ->order('r.id DESC')
                            ->query()->fetch();
                            
                        $fileExt = '001';
                        
                        if ($lastRemessa) {

                            $file = explode('/', $lastRemessa['arquivo']);
                            $file = end($file);
                            $lastCaracterExt = substr($file, strpos($file, ".") + 1);
                            
                            if (substr($lastCaracterExt, -2, 1) == 'R' || substr($lastCaracterExt, -2, 1) == 'M') {
                                $lastCaracterExt = 0;
                            }

                            $lastCaracterExt++;
                            $fileExt = str_pad($lastCaracterExt, 3, '0', STR_PAD_LEFT);
                        }

                        $arquivo = $empreendimento['cd_cedente']. $mes . date('d') . '.'.$fileExt;
                        $msgLog = 'Remessa gerada - Banco Sicredi | ';
                        break;

                    case Banco::BANCO_BANPARA:
                        $arquivo = 'CLI_CRB_'. $empreendimento['cd_cedente'] . '_' . date('Ymd') . '_CNAB240REM.';
                        $remesasDoDia = $this->tb_remessa->fetchAll("dtGeracao = '" . date('Y-m-d') . "' AND id_banco = ". Banco::BANCO_BANPARA);
                        $arquivo .= str_pad(count($remesasDoDia) + 1, 6, '0', STR_PAD_LEFT);
                        $msgLog = 'Remessa gerada - Banco Banpara | ';
                        break;

                    case Banco::BANCO_RIBEIRAO_PRETO:
                        $remesasDoDia = $this->tb_remessa->fetchRow("dtGeracao = '" . date('Y-m-d') . "' AND id_banco = ". Banco::BANCO_RIBEIRAO_PRETO, 'id DESC');
                        $extensaoArquivo = explode('.', $remesasDoDia['arquivo'])[1];
                        $extensaoArquivo = Helper::limit($extensaoArquivo + 1, 3, "zeros");
                        $contaCorrente = substr($empreendimento['conta_corrente'], 5, 4);
                        $arquivo = 'C2'. $contaCorrente . '2' . date('dm') . '.' . $extensaoArquivo;
                        $msgLog = 'Remessa gerada - Banco Ribeiro Preto | ';
                        break;

                    default:
                        $remesasDoDia = $this->tb_remessa->fetchAll("dtGeracao = '" . date('Y-m-d') . "' AND id_banco NOT IN ('".Banco::BANCO_CAIXA_ECONOMICA."','".Banco::BANCO_SICREDI."')");
                        $total = str_pad(count($remesasDoDia) + 1, 2, '0', STR_PAD_LEFT);
                        $primeira = $alphaNumArr[(int)substr($total, 0, -1)];
                        $segunda = (int)(($total) % 10);
                        $arquivo = 'CB' . date('d') . date('m') . $primeira . $segunda . '.REM';
                        $msgLog = 'Remessa gerada - ' . Banco::buscaNomeBanco($banco['cd_banco']) . ' | ';
                }
                $path = explode('.', $_SERVER['HTTP_HOST']);
                if ($path[0] == 'www') {
                    $path = $path[1];
                } else {
                    $path = $path[0];
                }
                $path = $path . '/' . date('Y') . '/' . $arquivo;
                $remessa = new RemessaBoleto();
                $remessa = $remessa->createRow();
                $remessa->id_empreendimento = $id_empreendimento;
                $remessa->dtGeracao = date('Y-m-d');
                $remessa->periodo = "de {$_POST['dtInicio']} a {$_POST['dtFim']}";
                $remessa->qtdeRegistros = $totalParcelas;
                $remessa->arquivo = $path;
                $remessa->log = $msgLog . Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:i:s') . ' - i';
                $remessa->tp_status = 'P';
                $remessa->nr_remessa = $banco['nrRemessa'];
                $remessa->id_banco = $banco['cd_banco'];
                $remessa->id_banco_conta = $banco['id_banco_conta'];
                //Seta o tipo da remessa como API (Banco Digital) ou n?o
                if($banco['cod_layout_api']){
                    $remessa->tp_status = 'API';
                }else{
                    $remessa->tp_status = 'P';
                }
                $remessa->tipo = $tipo_remessa;
                $idRemessa = $remessa->save();
                if ($idRemessa) {
                    //salva nas parcelas o id da remessa
                    foreach ($contratos as $contrato) {
                        $ids_parcela_registro = '';
                        foreach ($contrato['parcelas'] as $p) {
                            $ids_parcela_registro .= $p['id_parcela'] . $p['tp_parcela'] . ",";
                            Parcela::updateRemessaById($p['id_parcela_contrato'], $idRemessa);
                            RemessaItens::addParcela($p, $idRemessa);
                        }
                        //Salva o log nos contatos realizados
                        $referencia = 'Log: Envio de remessa Nr. ' . $idRemessa . ' referente as parcelas ' . $ids_parcela_registro;
                        (new Relacionamento())->saveContato(50, date('Y-m-d'), $contrato['id'], $referencia);
                    }
                    $dados['idRemessa'] = $banco['nrRemessa'];
                    $dados['idEmpreendimento'] = $id_empreendimento;
                    $dados['tipo_remessa'] = $tipo_remessa;
                    $dados['cdBanco'] = $banco['cd_banco'];
                    $dados['cod_layout'] = $banco['cod_layout'];
                    $dados['contratos'] = $contratos;
                    $dados['tp_multa'] = $banco['tp_multa'];
                    $dados['tp_juros'] = $banco['tp_juros'];

                  if ($banco['cd_banco'] == '748' && $banco['chave_pix']) {
                        $dados['chavePix'] = $banco['chave_pix'];
                    }

                    //Insere no array $dados o cdigo do Layout do Arquivo de Remessa, Retornou e API.
                    $dados['cod_layout_rem'] = $banco['cod_layout_rem'];
                    $dados['cod_layout_ret'] = $banco['cod_layout_ret'];
                    $dados['cod_layout_api'] = $banco['cod_layout_api'];
                    //Adiciona os dados do fetch das informacoes do empreendimento
                    foreach ($empreendimento as $k => $campo) {
                        $dados[$k] = $campo;
                    }
                    /* Teste para saber se  pra gerar o Boleto via API ou Via arquivo de Remessa.
                                         * Se existir cdigo da API,  porque  para processar a requisio de boleto via API
                                         * Caso no tenha cdigo da API cadastrada na tabela BANCO_CONTA executa a emisso de arquivo de REMESSA.
                                         */
                                        
                    if ($dados['cod_layout_api']){

                        /*
                         *  Vai no servidor da API e gera o boleto.
                         * Chama a funo que conecta ao servidor da API
                         * Desenvolvido por Jonathan Luiz - Outubro de 2021
                         */

                        //Pega os dados do Layout da Api
                        $tabelaLayout = new Layout();
                        $listaLayout = $tabelaLayout->getTabelaById($dados['cod_layout_api']);

                        //Seta o endereoo da API
                        $uri = $listaLayout['url_api'];
                        $uriparam = $listaLayout['uri_param'];
                        $urilistar = $listaLayout['url_api_listar'];
                        $req_cliente_id = $listaLayout['req_cliente_id'];

                        //Seta o tipo de Header que ser enviado.
                        $tipo_header = $listaLayout['tipo_header'];
                        $tipo_layout = $listaLayout['tipo_layout'];
                        $gerar_token = $listaLayout['gerar_token'];
                        $gerar_cliente = $listaLayout['gerar_cliente'];
                        $pp_token = $listaLayout['pp_token'];
                        $password = $listaLayout['password'];

                        $dados_layout_itens = LayoutItens::getLayouItenstById($dados['cod_layout_api'], '1');
                        $dados_body = explode(";", $dados_layout_itens[0]['conteudo']); //Pega a linha conte?do e quebra a express?o regular
                        //Para cada Parcela ele gera um boleto diferente
                        for($i=0;count($dados['contratos'][0]['parcelas'])>$i;$i++) {

                            //Verifica se o Layout da API necessita de registrar o cliente na plataforma antes de gerar os boletos
                            //Se sim, realiza o cadastro do cliente antes buscando na tabela Layout o endere?o de gera??o do cliente

                            if (($dados['contratos'][0]['parcelas'][$i]['id_pessoa_asaas']) && ($req_cliente_id === '1')) {
                                $cliente_id = $dados['contratos'][0]['parcelas'][$i]['id_pessoa_api_asaas'];
                            } elseif (!($dados['contratos'][0]['parcelas'][$i]['id_pessoa_asaas']) && ($req_cliente_id === '1')) {
                                $cliente = API::geraCliente($uri, $uriparam, $dados['contratos'][0]['parcelas'][$i],
                                    $tipo_header, $gerar_token, $pp_token, $password, $dados_body, $req_cliente_id, $gerar_cliente);
                                $clientes = json_decode($cliente, true);


                                //Pega o id do Cliente gerado - Caso do Banco ASAAS
                                if ($clientes['id']) {
                                    $id_pessoa = $dados['contratos'][0]['parcelas'][$i]['numero_pessoa'];
                                    $cliente_array = explode('_', $clientes['id']);
                                    $cliente_id = $cliente_array[1];
                                    $table = Zend_Db_Table::getDefaultAdapter()
                                        ->update(TB_PESSOA, ['id_pessoa_api_asaas' => $cliente_id], 'id =' . $id_pessoa);
                                }

                            }

                            //Gera os boletos com as informa??es do Cliente j? geradas.
                            //
                            $boleto = API::geraBoletos($uri, $uriparam, $dados['contratos'][0]['parcelas'][$i],
                                $tipo_header, $gerar_token, $pp_token, $password, $dados_body, $cliente_id, $gerar_cliente);

                            $boletos = json_decode($boleto, true);
                            //Imprime erro natela caso haja algum.
                            if ($boletos['error']) {
                                $data = array_chunk($boletos, 1, false);
                                $data1 = array_chunk($data[0][0], 1, false);
                                if (count($data1) > 1) {

                                    foreach ($data1 as $item) {
                                        if ($item[0][0][0]) {
                                            var_dump(utf8_decode($item[0][0]));
                                            exit;
                                            var_export(utf8_decode($item[0][0][0]));
                                        } else {
                                            var_export(utf8_decode($item[0]));
                                        }
                                        echo '<br>';
                                    }
                                } else {

                                    if ($data1[0][0][0]) {
                                        var_dump(utf8_decode($data1[0][0][0]));
                                        echo '<br>';
                                        var_dump(utf8_decode($data1[0][0]));
                                        echo '<br>';
                                        var_dump(utf8_decode($data1[0]));
                                        exit;
                                        var_export(utf8_decode($data1[0][0][0]));
                                    } else {
                                        var_dump(utf8_decode($data1[0][0]));
                                        echo '<br>';
                                        var_dump(utf8_decode($data1[0]));
                                        exit;
                                        var_export(utf8_decode($data1[0][0]));
                                    }

                                    echo '<br>';
                                }
                            }

                            if ($tipo_layout === 'APIASAAS') {
                                $id_parcela_contrato = $dados['contratos'][0]['parcelas'][$i]['id_parcela_contrato'];
                                $id_boleto = explode('_', $boletos['id']);
                                $cod_barras = $boletos['bankSlipUrl'];
                                $nossonumero = $boletos['nossoNumero'];
                                $data_vencimento = $boletos['dueDate'];

                                if ($id_boleto[1]) {
                                    $auxTabela = $this->tb_parcela->getAdapter();
                                    $auxTabela->update(array('tp' => TB_PARCELA), array('nosso_numero' => $nossonumero, 'cod_layout_api' => $dados['cod_layout_api'], 'dt_parcela' => $data_vencimento, 'cod_barras' => '' . $cod_barras . '', 'fl_envio' => '1', 'cod_boleto_api' => $id_boleto[1]), 'id_parcela_contrato = ' . $id_parcela_contrato);
                                }

                            } else {

                                foreach ($boletos as $key => $value) {
                                    $lista[$key] = $value;

                                }
                                //Quebra o array em arrays menores. Nmero 100000  o mximo de parcelas
                                $data = array_chunk($lista['data'], 1, false);

                                //Pega o nmero do Boleto que vem no array
                                // Quebra esse array pegando somente o numero do boleto
                                $array_num = array_keys($data[0]);

                                //Atualiza a tabela Parcelas com o Status do Boleto.
                                $id_parcela_contrato = $dados['contratos'][0]['parcelas'][$i]['id_parcela_contrato'];

                                $id_boleto = $data[0][0]['boleto_id'];
                                $cod_barras = $data[0][0]['codigo_barras'];
                                $nossonumero = $data[0][0]['nosso_numero'];

                                //Remove os pontos e espaos da linha digitvel do boleto
                                $linha_digitavel = $data[0][0]['linha_digitavel'];
                                $linha_digitavel = str_replace('.', '', $linha_digitavel);
                                $linha_digitavel = str_replace(' ', '', $linha_digitavel);

                                $vencimento = $data[0][0]['vencimento'];
                                $data_pag = $data[0][0]['data_pagamento'];

                                //Atualiza a tabela de Parcelas com os dados do boleto.
                                //Atualiza com os dados do cdigo do boleto na api e atualiza o cdigo no cadastro da conta a qual layout ela se refere
                                if ($id_boleto) {
                                    $auxTabela = $this->tb_parcela->getAdapter();
                                    $auxTabela->update(array('tp' => TB_PARCELA), array('nosso_numero' => $nossonumero, 'cod_layout_api' => $dados['cod_layout_api'], 'linha_digitavel' => $linha_digitavel, 'cod_barras' => $cod_barras, 'fl_envio' => '1', 'cod_boleto_api' => $id_boleto), 'id_parcela_contrato = ' . $id_parcela_contrato);
                                }
                            }
                        }
                    } else {
                        $tipo_remessa = $dados['tipo_remessa'];
                        //Teste para santander que possui uma geracao completamente diferente dos outros
                        if ($banco['cd_banco'] == Banco::BANCO_SANTANDER) {
                            $retorno = RemessaSantander::geraRemessa($dados, $arquivo,false,$tipo_remessa);
                        } elseif ($banco['cod_layout_rem']) {
                            //Envia os dados para ser gerado o arquivo de Remessa
                            $retorno = RemessaInstrucaoAutomatica::geraRemessa($dados, $arquivo);
                        } else {
                            //Envia os dados para ser gerado o arquivo de Remessa
                            if (!$_SESSION['emissor']) {
                                $_SESSION['emissor'] = 2;    
                            }
                            $retorno = RemessaInstrucao::geraRemessa($dados, $arquivo,false,$tipo_remessa, $_SESSION['emissor']);
                            $_SESSION['emissor'] = null;
                        } }

                    if ($retorno[1]) {
                        $this->redir(array('modulo' => 'bo', "controller" => "remessa", "action" => 'listar'), array("exception" => "No foi possvel gerar a remessa."));
                    } else {
                        // Incrementa o numero da remessa dao banco conta
                        $bancoConta = (new BancoConta())->fetchRow('id_banco_conta = '.$banco['id_banco_conta']);
                        $bancoConta->nr_remessa = $bancoConta['nr_remessa'] + 1;
                        $bancoConta->save();
                        $this->redir(array('modulo' => 'bo', "controller" => "remessa", "action" => 'listar'), array("msg" => "success"));
                    }
                } else {
                    $this->redir(array('modulo' => 'bo', "controller" => "remessa", "action" => 'listar'), array("exception" => "No foi possvel gerar a remessa."));
                }
            } else {
                $this->redir(array('modulo' => 'bo', "controller" => "remessa", "action" => 'listar'), array("exception" => "Nenhuma parcela foi selecionada para gerao."));
            }
        } else {
            $_SESSION['emissor'] = $_POST['emissor'];
            $banco = $this->tb_banco->getAdapter()->select()
                ->from(array('b' => TB_BANCO), '*')
                ->join(array('agr' => TB_AGRUPADA), 'idTabela = 9 AND idCampo = cd_banco', 'descricao')
                ->where("id = ?", $idBanco)
                ->query()->fetch();
            
            $contratos = $this->tb_contrato->getAdapter()->select()
                ->from(array('c' => TB_CONTRATO), '*')
                ->join(array("l" => TB_LOTES), "c.id_lote = l.id", array('lote', 'quadra'))
                ->join(array("pa" => TB_PARCELA), "c.id = pa.id_contrato", '')
                ->join(array("p" => TB_PESSOA), "c.id_pessoa = p.id", 'nm_pessoa')
                ->join(array('b' => TB_BANCO), 'b.id = c.id_banco AND b.id = ' . $_POST['banco'], '')
                ->join(array('agr' => TB_AGRUPADA), 'agr.idTabela = 9 AND agr.idCampo = b.cd_banco', '')
                ->where('l.id_empreendimento = ?', $_POST['id_empreendimento'])
                ->where('pa.id_remessa IS NULL')
                ->where('pa.tp_parcela NOT IN ("E","NE","SE","CE","IE")')
                ->where('pa.pago = "0"')
                ->where('pa.fl_envio = "1"')
                ->where('pa.id_banco_boleto = b.id_banco_conta or pa.id_banco_boleto is null')
                ->where('(pa.dt_parcela >= "' . Helper::getInputDate($_POST['dtInicio']) . '" AND pa.dt_parcela <= "' . Helper::getInputDate($_POST['dtFim']) . '") OR (pa.dt_parcela_2avia >= "' . Helper::getInputDate($_POST['dtInicio']) . '" AND pa.dt_parcela_2avia <= "' . Helper::getInputDate($_POST['dtFim']) . '")');

            if ($_POST['id_contrato'][0] != '*')
            {
                $aux = implode('","', $_POST['id_contrato']);

                $contratos = $contratos->where('c.id IN ("' . $aux . '")');
            }

            $contratos = $contratos->order('p.nm_pessoa')->group('c.id')
                ->query()->fetchAll();
            //variavel criada para verificar se o banco Ribeiro Preto possui parcelas sem nr_boleto.
            $contemNrBoletoNulo = false;

            if ($banco['cd_banco'] == '741')
            {
                foreach ($contratos as $contrato)
                {
                    $parcelasRibeirao = $this->tb_parcela->getAdapter()->select()
                        ->from(array('p' => TB_PARCELA), array('id_parcela_contrato', 'id_contrato', 'vl_parcela', 'dt_parcela', 'increment_id', 'id_parcela', 'tp_parcela', 'vl_parcela_2avia', 'dt_parcela_2avia', 'desconto', 'acrescimo', 'nr_boleto', 'ano_boleto_emissao', 'fl_envio'))
                        ->join(array('c' => TB_CONTRATO), 'p.id_contrato = c.id', array('id_pessoa', 'id_lote', 'id'))
                        ->where('c.id = ' . $contrato['id'])
                        ->where('p.pago = "0"')
                        ->where('p.id_remessa is null')
                        ->where('p.tp_parcela IN ("N","S","I","C","G","Q","A")')
                        ->where('dt_parcela between "' . Helper::getInputDate($_POST['dtInicio']) . '" and "' . Helper::getInputDate($_POST['dtFim']) . '" OR '
                            . 'dt_parcela_2avia between "' . Helper::getInputDate($_POST['dtInicio']) . '" and "' . Helper::getInputDate($_POST['dtFim']) . '"')
                        ->where('p.fl_envio = "1"')
                        ->query()->fetchAll();

                    foreach ($parcelasRibeirao as $j => $parcela)
                    {
                        //Caso o banco seja Ribeiro Preto ou Sicredi e as colunas nr_boleto seja nula e fl_envio seja 1,
                        //a parcela  removida da lista de parcelas e o sistema continua sua operao na prxima parcela.
                        if ($parcela['nr_boleto'] == null && $parcela['fl_envio'] == '1')
                        {
                            unset($parcelasRibeirao[$j]);
                            continue;
                        }
                    }
                }

                if (count($parcelasRibeirao) < 1)
                    $contemNrBoletoNulo = true;
            }

            if (count($contratos) && $contemNrBoletoNulo == false) {
                $this->set("action", '?m=bo&c=remessa&a=verificarContratos&passo2=true');
                $this->set('contratos', $contratos);
                $this->set('banco', $banco);
                $this->set('empreendimento', $empreendimento);
                $this->set('tipo', $tipo_remessa);
                $this->set('remessa', $_POST);
                $this->set('back', $this->_helper->getLink(array('m' => 'bo', 'c' => 'remessa', 'a' => 'gerarRemessa')));
                $this->display('verificarContratos');
            } else {
                $this->redir(array("modulo" => "bo", "controller" => "remessa", "action" => "gerarRemessa"), array('exception' => 'No foram encontrados parcelas para remessa neste perodo.'));
            }
        }
    }

    public function boletosapiAction()
    {
        $boleto_link = Zend_Db_Table::getDefaultAdapter()
            ->select()->from(TB_PARCELA)->where('id_remessa = '.$_GET['id'])->query()->fetchAll();
        $this->set("boleto_link", $boleto_link);
        $this->display("gerarboleto");
    }

    public function cancelarAction()
    {
        try {
            $remessa = $this->tb_remessa->fetchRow('id = ' . $_GET['id']);
            $remessa->tp_status = 'C';
            if ($remessa->save()) {
                $parcelas = Parcela::cancelaRemessa($_GET['id']);

                if ($parcelas)
                    $this->redir(array("modulo" => "bo", "controller" => "remessa"), array("msg" => "success"));
                else
                    $this->redir(array("modulo" => "bo", "controller" => "remessa"), array('exception' => 'No foi possvel alterar as parcelas.'));
            }
        } catch (Exception $e) {
            $this->redir(array("modulo" => "bo", "controller" => "remessa"), array('exception' => $e->getMessage()));
        }
    }

//Busca as parcelas do contrato selecionado para exibir os dados na tabela
    public function buscaParcelasAction()
    {
        $parcelas = Parcela::findParcelasNPagasById($_POST['contrato'], $_POST['dtInicio'], $_POST['dtFinal'], true,$_POST['banco']);

        //Busca apenas as nao pagas sem remessa considerando a segunda via emitida
        $auxParcelas = array();
        foreach ($parcelas as $p) {
            if ((float)$p['vl_parcela_2avia'] > 0) {
                $p['dt_parcela'] = Helper::getDate($p['dt_parcela_2avia']);
                $p['vl_parcela'] = $p['vl_parcela_2avia'];
            }
            $p['vl_parcela'] = $p['vl_parcela'] - $p['desconto'] + $p['acrescimo'];
            if ($p['id_remessa'] == null) {
                $auxParcelas[] = $p;
            }
        }
        echo json_encode($auxParcelas);
    }

//Busca as parcelas do contrato selecionado, gera o arquivo e baixa a remessa
    public function baixarArquivoAction()
    {
        $remessa = new RemessaBoleto();
        $remessa = $remessa->fetchRow('id = ' . $_POST['id']);
        if ($remessa->tp_status != 'C' && $remessa->tp_status != 'E')
            $remessa->tp_status = 'EB';

        echo json_encode($remessa->save());
    }

    public function confirmaEnvioAction()
    {
        $remessa = new RemessaBoleto();
        $remessa = $remessa->fetchRow('id = ' . $_POST['id']);
        if ($remessa->tp_status != 'C' && $remessa->tp_status != 'P')
            $remessa->tp_status = 'E';

        echo json_encode($remessa->save());
    }

    public function visualizarAction()
    {
        if ($this->isAjax()) {
            $item = $this->tb_remessa->getDados($_POST['cdItem']);
            echo json_encode($item);
        }
    }

    public function validar()
    {
        $campos = array('dtInicio' => 'Informe a data de incio.', 'dtFim' => 'Informe a data de fim.', 'id_empreendimento' => 'Selecione o empreendimento.', 'banco' => 'Selecione o Banco.');
        foreach ($campos AS $k => $msg) {
            if ($_POST[$k] == '') {
                $this->_helper->addMensagem($k, $msg);
            }
        }

        if (!(count($this->_helper->getMensagens()) > 0)) {
            $ini = strtotime(str_replace('/', '-', $_POST['dtInicio']));
            $fim = strtotime(str_replace('/', '-', $_POST['dtFim']));
            $hoje= Helper::getDate(date('Y-m-d'));
            $hoje= strtotime(str_replace('/', '-', $hoje));
            if ($ini > $fim) {
                $this->_helper->addMensagem('erroData', 'O perodo informado  invlido');
            }
            if($ini < $hoje){
                $this->_helper->addMensagem('erroData', 'O perodo inicial no pode ser inferior ao dia de hoje');
            }
        }

        return !(count($this->_helper->getMensagens()) > 0);
    }

    public function validar2()
    {
        $campos = array(
            'dtInicio' => 'Informe a data de incio.',
            'dtFim' => 'Informe a data de fim.',
            'id_empreendimento' => 'Selecione o empreendimento.',
            'banco' => 'Selecione o Banco.'
        );

        foreach ($campos AS $k => $msg) {
            if ($_POST[$k] == '') {
                $this->_helper->addMensagem($k, $msg);
            }
        }

        return !(count($this->_helper->getMensagens()) > 0);
    }

    /**
     * Lista em ajax dos nomes dos bancos cadastrados no empreendimento
     */
    public function bancoByEmpreendimentoAction()
    {
        $bancos = Banco::findByEmpreendimento($_POST['id_empreendimento'],true, false, true);
        $lista = array();
        foreach ($bancos as $banco) {
            $banco['nmBanco'] = Banco::findBancoNome($banco['cd_banco']);
            $lista[] = array('id' => $banco['id'],
                'text' => utf8_encode($banco['nmBanco']) . ' - Ag.: ' . $banco['agencia'] . '-' . $banco['agencia_dv'] . '  Cc: ' . $banco['conta_corrente'] . '-' . $banco['conta_corrente_dv']
            );
        }

        echo json_encode($lista);
    }

    public function contratoByBancoEmpreendimentoAction()
    {
        $contratos = Contrato::byBancoEmpreendimento($_POST['id_empreendimento'], $_POST['banco'], Contrato::CONTRATO_GERADO, true, array("nm_pessoa", "lote", "quadra", "id"), true);

        $lista = array(
            array('id' => '*', 'text' => 'Todos')
        );
        foreach ($contratos as $contrato) {
            $lista[] = array('id' => $contrato['id'], 'text' => utf8_encode($contrato['nm_pessoa']) . ' - Quadra: ' . utf8_encode($contrato['quadra']) . ' - Lote: ' . utf8_encode($contrato['lote']) . ' - Contrato: ' . utf8_encode($contrato['id']));
        }

        echo json_encode($lista);
    }

    public function gerarRelatorioAction()
    {
        $tbClienteAcade = new Db_Cliente();
        $this->set('clienteAcade', $tbClienteAcade->fetchRow()->toArray());

        $infoParcela = $this->tb_remessa->getAdapter()->select()
            ->from(array("r" => TB_REMESSA), array('*'))
            ->join(array("e" => TB_EMPREENDIMENTO), "r.id_empreendimento = e.id", array('nm_empreendimento', 'id_tipo_loteamento'))
            ->joinLeft(array('t' => TB_TIPO_LOTEAMENTO), 'e.id_tipo_loteamento = t.id_tipo_loteamento', array('*'))
            ->where('r.id = ?', $_GET['id'])
            ->query()->fetch();

        $infoCliente = $this->tb_remessa->getAdapter()->select()
            ->from(array('ri' => TB_REMESSA_ITENS), array('id_contrato', 'tp_parcela', 'nr_parcela', 'dt_parcela', 'vl_parcela'))
            ->join(array('l' => TB_LOTES), 'ri.id_lote = l.id', array('quadra', 'lote'))
            ->join(array('p' => TB_PESSOA), 'ri.id_pessoa = p.id', array('nm_pessoa'))
            ->where('ri.id_remessa = ?', $_GET['id'])
            ->order('ri.nr_parcela ASC')
            ->query()->fetchAll();

        $this->set('infoParcela', $infoParcela);
        $this->set('infoCliente', $infoCliente);

        $this->displayMPDF("gerarRelatorio.pdf");
    }
}