<?php

class RelatorioBoletoController extends Controller
{
    protected $tbEmpreendimento;

    public function __construct ($request)
    {
        parent::__construct($request);

        $this->tbEmpreendimento = new Empreendimento();
    }

    public function indexAction ()
    {
        $empreendimentos = (new Empreendimento())->getDefaultAdapter()->select()
            ->from(array('e' => TB_EMPREENDIMENTO), array('e.nm_empreendimento', 'e.id'));

        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $empreendimentos->where("e.id IN({$id})");
                } else {
                    $empreendimentos->where("1");
                }
            } catch (Exception $e) {

            }
        }

        $empreendimentos = $empreendimentos->order('nm_empreendimento')->query()->fetchAll();

        $this->set('empreendimentos', $empreendimentos);

        $this->display('index');
    }

    public function relatorio ($idEmpreendimento, $dtInicial, $dtFinal, $tpBoleto, $ordem)
    {
        $dados = $this->tbEmpreendimento->getDefaultAdapter()->select()
            ->from(array('e' => TB_EMPREENDIMENTO), '')
            ->join(array('l' => TB_LOTES), 'l.id_empreendimento = e.id', array('quadra', 'lote'))
            ->join(array('c' => TB_CONTRATO), 'c.id_lote = l.id', 'id')
            ->join(array('p' => TB_PARCELA), 'p.id_contrato = c.id', array('id_parcela', 'tp_parcela', 'dt_parcela', 'vl_parcela','nr_tipo_parcela'))
            ->join(array('pe' => TB_PESSOA), 'c.id_pessoa = pe.id', 'nm_pessoa');

        if ($tpBoleto == 'R')
        {
            $dados = $dados->join(array('r' => TB_REMESSA), 'p.id_remessa = r.id', array('nr_remessa', 'dtGeracao'));
        }

        if ($tpBoleto == 'E')
        {
            $dados = $dados->joinLeft(array('r' => TB_REMESSA), 'p.id_remessa = r.id', array('nr_remessa', 'dtGeracao'));
        }

        switch ($tpBoleto)
        {
            case 'R':
                $dados = $dados->where('p.id_remessa is not null');
                break;
            case 'RN':
                $dados = $dados->where('p.id_remessa is null');
                break;
            case 'E':
                $dados = $dados->where('p.fl_envio = "1"');
                break;
            case 'NE':
                $dados = $dados->where('p.fl_envio = "0" AND p.pago = "0"');
                break;
        }

        $dados = $dados->where('e.id = "' . $idEmpreendimento . '"')
                    ->where('p.dt_parcela BETWEEN "' . Helper::dataParaAmericano($dtInicial) . '" AND "' . Helper::dataParaAmericano($dtFinal) . '"');
                    
        switch ($ordem)
        {
            case 'C':
                $ordem = array('pe.nm_pessoa', 'p.dt_parcela');
                break;
            case 'L':
                $ordem = array('l.quadra', 'l.lote', 'p.dt_parcela');
                break;
            case 'CO':
                $ordem = array('c.id', 'p.dt_parcela');
                break;
        }    

        $parcelas['parcelas'] = $dados->order($ordem)->query()->fetchAll();

        //DADOS DO CLIENTE PARA O CABEALHO
        $empreendimento = (new Empreendimento())->fetchRow('id = ' . $idEmpreendimento);
        $dadosCliente = new Db_Cliente();
        $dadosCliente = $dadosCliente->fetchRow()->toArray();

        $parcelas['empreendimento'] = $empreendimento->toArray();
        $parcelas['cliente'] = $dadosCliente;

        return $parcelas;
    }

    public function relatorioAction ()
    {
        if (!$this->validarDados())
        {
            $dados = $this->relatorio($_POST['idEmpreendimento'], $_POST['vencimentoInicial'], $_POST['vencimentoFinal'], $_POST['tpBoleto'], $_POST['ordem']);
    
            $this->set('dados', $dados);
            $this->displayMPDF('Relatorio_' . time() . '.pdf');
        } else {
            echo json_encode(false);
        }
    }

    public function visualizarAction ()
    {
        if (!$this->validarDados())
        {
            $dados = $this->relatorio($_POST['idEmpreendimento'], $_POST['vencimentoInicial'], $_POST['vencimentoFinal'], $_POST['tpBoleto'], $_POST['ordem']);
            
            $this->set('dados', $dados);
            echo $this->display('relatorio');
        } else {
            echo json_encode(false);
        }
    }

    public function validarDados ()
    {
        $campos = array('idEmpreendimento' => 'O empreendimento  obrigatrio.', 
            'vencimentoInicial' => 'A data de vencimento inicial  obrigatria.',
            'vencimentoFinal' => 'A data de vencimento final  obrigatria.');

        foreach ($campos as $k => $msg)
        {
            if ($_POST[$k] == '')
            {
                $this->_helper->addMensagem($k, $msg);
            }
        }
        //Mensagem de Erros
        if (count($this->_helper->getMensagens()) > 0)
        {
            $msgErros = '';

            foreach ($this->_helper->getMensagens() as $msg => $a)
                $msgErros .= utf8_encode($a) . '<br>';

            return true;
        } 

        return false;
    }
}