<?php

/**
 * Classe que representa o controller do arquivo de retorno bancario
 *
 * @author acade
 */
class ParcelasMigradasController extends Controller
{
    private $bancos;

    public function __construct($request)
    {
        parent::__construct($request);
        $this->bancos = new Banco();
    }

    public function indexAction()
    {
        $this->redir(array('modulo' => 'bo', 'controller' => 'parcelasMigradas', 'action' => 'listar'));
    }

    public function listarAction()
    {
        if ($this->_isPost)
        {
            $parcelasMigradas = (new ParcelaMigrada)->buscaTodasParcelasMigradas();
            $lista = [];

            $path = explode('.', $_SERVER['HTTP_HOST']);
            if ($path[0] == 'www') {
                $path = $path[1];
            } else {
                $path = $path[0];
            }

            foreach ($parcelasMigradas as $migrada)
            {
                $acoes = '<div style="width: 90px"></div><div align="center" style="width: 100%;">';
                $acoes .= '<a target="_blank" href="' . $migrada['arquivo_pdf'] . '" data-toggle="tooltip" title="IMPRIMIR" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-file-o"></i></a>';
                $acoes .= '<a href="upload/cliente/' . $path . '/'. 'migradas/' . $migrada['arquivo'] . '" target="_blank" download data-toggle="tooltip" title="BAIXAR" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-download"></i></a>';
                $acoes .= '</div>';
                $acoes .= '</div>';
                
                if($migrada['nr_retorno'] == NULL){
                    $migrada['nr_retorno'] = '-';
                }
                if($migrada['dt_criacao'] == NULL){
                    $migrada['dt_criacao'] = '-';
                }else{
                    $migrada['dt_criacao'] = Helper::getDate($migrada['dt_criacao']);
                }

                $lista[] = array(
                    'codigo' => $migrada['id'],
                    'numero' => $migrada['nr_retorno'],
                    'criacao' =>  $migrada['dt_criacao'],
                    'processamento' =>  Helper::getDate($migrada['dt_geracao']),
                    'cliente' => utf8_encode($migrada['nm_cliente']),
                    'agenConta' => 'Ag: ' . $migrada['agencia'] . '-' . $migrada['agencia_dv'] . 'Cc: ' . $migrada['conta_corrente']. '-' . $migrada['conta_corrente_dv'],
                    'banco' => utf8_encode($migrada['nmBanco']),
                    'arquivo' =>  $migrada['arquivo'],
                    'acoes' =>  $acoes
                );
            }

            echo json_encode(array(
                'draw' => $_POST['draw'],
                'recordsTotal' => count($parcelasMigradas),
                'recordsFiltered' => count($parcelasMigradas),
                'data' => $lista));
        } else {
            $this->display('listar');
        }
    }

    public function gerarAction()
    {
        if (!$this->_isPost)
        {
            //Verifica se o usurio possui finan
            if (Db_Cliente::getCliente()['fl_acade_finan'] == '1') {
                
                $bancos = (new Banco())->getDefaultAdapter()->select()
                    ->from(array('b' => TB_BANCO), array('id', 'conta_corrente', 'conta_corrente_dv', 'agencia', 'agencia_dv'))
                    ->join(array('ta' => TB_AGRUPADA), 'b.cd_banco = ta.idCampo AND ta.idTabela = "9"', array('nomeBanco' => 'descricao'))
                    ->join(array('e' => TB_EMPREENDIMENTO), 'b.id_empreendimento = e.id', '');
            
                if ($_SESSION['usuario']) 
                {
                    try {
                        $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                        $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                        
                        if (count($ids)) 
                        {
                            $id = implode(',', $ids);
                            $bancos->where("e.id IN({$id})");
                        } else {
                            $bancos->where("1");
                        }
                    } catch (Exception $e) {
                    }
                }
        
                $bancos = $bancos->group('b.id_banco_conta')->query()->fetchAll();
                
                $this->set('bancos', $bancos);
            }
        }

        if ($this->_isPost) {
            // Procedimentos para baixar arquivo e processa-lo
            if ($_FILES["arquivo"]["name"]) {
                // Arquivo
                $path = explode('.', $_SERVER['HTTP_HOST']);
                if ($path[0] == 'www') {
                    $path = $path[1];
                } else {
                    $path = $path[0];
                }

                $tmp = explode('.', $_FILES['arquivo']['name']);
                $extensao = strtolower(end($tmp));
                $arquivo = $tmp[0] . '.' . $extensao;
                $up = new Filesystem();
                $tmp = $_FILES['arquivo']['tmp_name'];

                $to = 'upload/cliente/' . $path . '/migradas';
                Helper::criaPastas($to);
                $to .= "/".$arquivo;
                $rs = $up->upload($tmp, $to); 
                if (!$rs) {
                    //Remove o aquivo j processado
                    if (file_exists($to))
                        Filesystem::delete($to);
                    $this->redir(array('modulo' => 'bo', "controller" => "ParcelasMigradas", "action" => "index"), array("fail" => "No foi possvel armazenar o arquivo."));
                    exit();
                }

                // Processando arquivo
                $padrao = false;
                try {
                    $arq = file($to, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
                    $padrao = strlen($arq[0]);
                    $comReg = true;
                    $migradas = true;
                    if ($padrao == 240 || $padrao == 400) {
                        $ret = new RetornoBoleto($to, $padrao);
                    } else {
                        //Remove o aquivo j processado
                        if (file_exists($to))
                        Filesystem::delete($to);

                        $this->redir(array('modulo' => 'bo', "controller" => "parcelasMigradas", "action" => "index"), array("fail" => "Arquivo de retorno fora do padro."));
                        exit();
                    }
                    
                    $retorno = $ret->processar($comReg,$migradas, null, false, 'M', $_POST['bancoMigrada']);
                } catch (Exception $e) {
                    $retorno = false;
                }
                
                if ($retorno) {
                    
                    if (!is_null($retorno['sucessos']) || !is_null($retorno['verificar']) || !is_null($retorno['erros']) || !is_null($retorno['linhasErradas'])) {
                        // Realiza os procedimentos para integrar com o acadefinan
                        // criando uma array com chave concatenada de id_empreendimento|dt_credito
                        // com o valor das parcelas pagas no periodo e a data de credito
                        if (count($retorno['sucessos']) > 0) {
                            $auxIntegracao = array();
                            foreach ($retorno['sucessos'] as $p) {
                                $empreendimento = Parcela::getIntegracaoEmpreendimento($p['id_parcela_contrato']);
                                if ($empreendimento) {
                                    if (!isset($auxIntegracao[$empreendimento['id'] . '|' . $p['dt_credito']]))
                                        $auxIntegracao[$empreendimento['id'] . '|' . $p['dt_credito']] = array(
                                            'valor' => $p['vl_total_pago'],
                                            'empreendimento' => $empreendimento,
                                            'dt_credito' => $p['dt_credito']
                                        );
                                    else {
                                        $auxIntegracao[$empreendimento['id'] . '|' . $p['dt_credito']]['valor'] += $p['vl_total_pago'];
                                    }
                                }
                            }

                            if (count($auxIntegracao) > 0) {
                                foreach ($auxIntegracao as $conta) {
                                    //Criando uma nova linha para inserao
                                    $adapter = $this->getAdapterIntegracao();
                                    $adapter->beginTransaction();
                                    try {
                                        $data = explode('-', $conta['dt_credito']);
                                        $contaDados = array(
                                            'cd_plano_conta' => $conta['empreendimento']['cd_conta_credito'],
                                            'cd_centro_custo' => $conta['empreendimento']['cd_centro_custo'],
                                            'nr_mes_competencia' => $data[1],
                                            'nr_ano_competencia' => $data[0],
                                            'dt_documento' => $conta['dt_credito'],
                                            'nr_parcelas' => 1,
                                            'vl_total' => $conta['valor'],
                                            'tp_conta_pagar_receber' => 'R'
                                        );
                                        $adapter->insert('afn006', $contaDados);
                                        $idConta = $adapter->lastInsertId('afn006');

                                        //Insero na tabela de Parcelas de Contas a Pagar
                                        $parcelaDados = array(
                                            'cd_conta_pagar_receber' => $idConta,
                                            'cd_forma_pagamento' => 1,
                                            'cd_local_pagamento' => $conta['empreendimento']['id_finan'],
                                            'nr_parcela' => 1,
                                            'vl_parcela' => $conta['valor'],
                                            'dt_vencimento' => $conta['dt_credito'],
                                            'dt_pagamento' => $conta['dt_credito'],
                                            'dt_debito' => $conta['dt_credito'],
                                            'tp_situacao' => 'P'
                                        );
                                        $adapter->insert('afn007', $parcelaDados);
                                    } catch (Exception $e) {
                                        $adapter->rollBack();
                                        $this->redir(array('modulo' => 'bo',"controller" => "parcelasMigradas",
                                            "action" => "index"), array("warning" => "No foi possvel gravar as contas pela integrao com Finan."));
                                    }
                                    $adapter->commit();
                                }
                            }
                        }

                        $db = Zend_Db_Table::getDefaultAdapter();

                        $cdBanco = abs($_POST['cd_banco']);

                        $bancoTitulo = $db->select()->from(TB_AGRUPADA)
                            ->where('idTabela = ' . Db_TabelaAgrupada::TABLE_BANCO)
                            ->where("idCampo = {$cdBanco}")
                            ->order('descricao ASC')->query()->fetchAll();

                        $this->set('bTitulo', $bancoTitulo[0]);

                        ini_set("memory_limit", "128M");
                        set_time_limit(0);
                        
                        //Cria os diretorios para onde o arquivo vai ser gravado
                        $path = explode('.', $_SERVER['HTTP_HOST']);
                        if ($path[0] == 'www') {
                            $path = $path[1];
                        } else {
                            $path = $path[0];
                        }
                        //Caminho do arquivo em PDF
                        $pathPdf = 'upload/migradas/'.$path.'/pdf/'.date('Y');
                        Helper::criaPastas($pathPdf);
                        $pathPdfName = 'file_'. date('dmYHis').'.pdf';
                        $pathArquivo = 'upload/migradas/'.$path.'/pdf/'.date('Y');
                        //Caminho do arquivo retorno
                        Helper::criaPastas($pathArquivo);
                        $pathArquivo .= '/' . $pathPdfName;
                        copy($to, $pathArquivo);

                        $dadosMigradas = [
                            'cliente' => $retorno['header']['nome_empresa'],
                            'banco' => intval($retorno['header']['banco']),
                            'contaCorrente' => $retorno['header']['conta_corrente'],
                            'contaCorrenteDv' => $retorno['header']['dv_conta'],
                            'agencia' => $retorno['header']['agencia'],
                            'agenciaDv' => $retorno['header']['dv_agencia'],
                            'arquivo' => $arquivo,
                            'arquivoPdf' => $pathPdf . '/' . $pathPdfName,
                            'sequencia' => $retorno['header']['sequencia'],
                            'dt_criacao' => Helper::getInputDate($this->_helper->formataDataBoleto($retorno['header']['data_geracao_arq'])),
                        ];
                        //Salva as informaoes das parcelas migradas na tabela PARCELA_MIGRADA
                        (new ParcelaMigrada)->salvaParcelasMigradas($dadosMigradas);

                        $this->set('tipoRetorno', $padrao);
                        $this->set('sucessos', $retorno['sucessos']);
                        $this->set('erros', $retorno['erros']);
                        $this->set('verificar', $retorno['verificar']);
                        $this->set('linhasErradas', $retorno['linhasErradas']);
                        $this->set('codigosMovimento', $retorno['codigosMovimento']);

                        $this->display('resultadoParcelasMigradas');
                        $this->redir(array('modulo' => 'bo',"controller" => "parcelasMigradas","action" => "listar"), array("msg" => "success"));
                        $this->displayMPDF(rand() . '.pdf', null, 'L', false, false, true, $pathPdf, $pathPdfName);
                        
                    } else {
                        $this->redir(array('modulo' => 'bo',
                            "controller" => "parcelasMigradas",
                            "action" => "index"), array("fail" => "O arquivo no possue baixas a serem realizadas."));
                    }
                } else {
                    unlink($to);
                    $this->redir(array('modulo' => 'bo', "controller" => "parcelasMigradas","action" => "index"), array("fail" => "No foi possvel processar o arquivo."));
                }
            } else {
                $this->_helper->addMensagem("fail", "Arquivo no informado.");
            }
        }

        if ($_GET["msg"] == "ok") {
            $this->_helper->addMensagem("ok", "Operao realizada com sucesso!");
        } elseif
        ($_GET["msg"] == "fail"
        ) {
            $this->_helper->addMensagem("fail", "No foi possvel continuar a operao!");
        } elseif (strlen($_GET["fail"]) > 1) {
            $this->_helper->addMensagem("fail", $_GET['fail']);
        }

        $this->display('gerar');
    }
    /**
     * Funo ajax que faz upload, verifica formatao do arquivo e retorna informaes do arquivo para tela
     */
    public function verificaRetornoAction()
    {
        //Arquivo
        $tmp = explode('.', $_FILES[0]['name']);
        $extensao = strtolower(end($tmp));
        $arquivo = date('Ymd_H_i') . '_' . current($tmp) . '.' . $extensao;
        $up = new Filesystem();
        $tmp = $_FILES[0]['tmp_name'];
        $to = DIRETORIO_DOWNLOAD . $arquivo;
        $rs = $up->upload($tmp, $to);
        if (!$rs) {
            $resultado = array('erro'=>utf8_encode('No foi possvel armazenar o arquivo.'));
        } else {
            //Processando arquivo
            $padrao = false;
            $arq = file($to, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
            $padrao = strlen($arq[0]);
            $comReg = true;
            $migradas = true;
            if ($padrao == 240) {
                $ret = new RetornoBoleto($to, $padrao);
                $idBanco = ($_GET['banco'] == 'undefined') ? null : $_GET['banco'];
                $resultado = $ret->processar($comReg, $migradas, null, true, 'M', $idBanco);
            } else {
                $resultado = array('erro'=>utf8_encode('Arquivo de retorno fora do padro 240.'));
            }
            //Remove o aquivo j processado
            if (file_exists($to)) {
                Filesystem::delete($to);
            }
        }
        
        echo json_encode($resultado);
    }
}