<?php

class EmissaoController extends Controller
{
    private $contrato;
    private $tb_empreendimento;
    private $pessoa;
    private $tb_comunicacao_email;
    private $tb_lote;
    private $tb_banco_conta;

    public function __construct($request)
    {
        parent::__construct($request);

        $this->contrato = New Contrato();
        $this->tb_empreendimento = New Empreendimento();
        $this->tb_lote = New Lote();
        $this->pessoa = New Pessoa();
        $this->tb_banco_conta = New BancoConta();

        $this->tb_comunicacao_email = new ComunicacaoEmail();
    }

    public function indexAction()
    {
        $this->redir(array('modulo' => 'bo', 'controller' => 'emissao', 'action' => 'gerar'));
    }

    public function gerarAction()
    {
        //criando uma Sesso para a Opo de endereo no verso.
        $opcaoVerso = $_POST['opcao'];
        $_SESSION['opcaoVerso'] = $opcaoVerso;

        if ($_GET["msg"] == "OK") {
            $this->_helper->addMensagem("ok", "Operao realizada com sucesso!");
        } elseif ($_GET["msg"] == "FAIL") {
            $this->_helper->addMensagem("fail", "Erro! No foi possvel continuar a operao!");
        }

        $empreendimentos = (new Empreendimento())->getDefaultAdapter()->select()
            ->from(array('e' => TB_EMPREENDIMENTO), array('e.nm_empreendimento', 'e.id'));

        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $empreendimentos->where("e.id IN({$id})");
                } else {
                    $empreendimentos->where("1");
                }
            } catch (Exception $e) {

            }
        }

        $empreendimentos = $empreendimentos->order('nm_empreendimento')->query()->fetchAll();

        $this->set('empreendimentos', $empreendimentos);
        $this->set('back', $this->_helper->getLink(array('m' => 'bo', 'c' => 'emissao', 'a' => 'index')));

        if ($this->_isPost) {

            $contrato = implode('","', $_POST['contrato']);
            $banco = $_POST['banco'];
            $empreendimento = $_POST['empreendimento'];

            $tipos = '(';
            foreach ($_POST['tipos'] as $tipo) {
                $tipos .= "'$tipo',";
            }
            $tipos = substr($tipos, 0, -1) . ")";

            //registrar Envio
            $dataA = Helper::getInputDate($_POST['dataA']);
            $dataB = Helper::getInputDate($_POST['dataB']);

            $listaParcelas = (new Parcela())->findParcelasBoletos($empreendimento,$contrato,$banco,$tipos,$dataA,$dataB);
            
            if(!$listaParcelas){
                $this->_helper->addMensagem('danger', 'No foi encontrado nenhuma parcela neste periodo.');
                $this->display('gerar');
            } else {
                $listaParcelas[0]['dtInicial'] = $_POST['dataA'];
                $listaParcelas[0]['dtFinal'] = $_POST['dataB'];
                $listaParcelas[0]['tpParcelas'] = $_POST['tipos'];
                $listaParcelas[0]['modelo'] = $_POST['modelo'];
                $this->set('listaParcelas', $listaParcelas);

                if($_POST['email']){
                    
                    $this->set('email', $this->tb_comunicacao_email->getById($_POST['email']));
                }
                if($_POST['whatsapp']){
                    
                    $this->set('whatsapp', $this->tb_comunicacao_email->getById($_POST['whatsapp']));
                }
                //Verifica se o tipo da conta do Banco  api ou arquivo de remessa
                //Se for api, gera os boletos usando a api.
                $agencia = $listaParcelas[0]['agencia'];
                $conta = $listaParcelas[0]['conta_corrente'];
                $contaapi = $this->tb_banco_conta->listBancoContas($agencia,$conta);

                $this->set('api', $contaapi['cod_layout_api']);

                $this->display('verificarContratos');
            }

        } elseif ($this->_isGet) {
            $this->display('gerar');
        }
    }

    public function gerarBoletoAction($id=null)
    {
        $clienteAcade = new Db_Cliente();

        $clienteAcadeone = $clienteAcade->fetchRow();

        if($id){
            $idsParcelas = $id;
        }
        else{
            $idsParcelas = $_GET['idsParcelas'];
        }
        if(!$idsParcelas)
            $this->redir(array('modulo' => 'bo', 'controller' => 'emissao', 'action' => 'listar'), array('exception'=>'No foi encontrado nenhuma parcela'));

        $tbParcela = new Parcela();
        $listaParcelas = $tbParcela->findParcelasBoletos(null,null,null,null,null,null,$idsParcelas);     
        $contatoTexto = '';
        $idContrato = '';
       // $tipo_api = $_GET['api'];
        $dados = array();
        $qtdeMaximaParc = count($listaParcelas);
        $i = 1;

        $db = Zend_Db_Table::getDefaultAdapter();
        $db->beginTransaction();
        $fl_boleto = false;
        $aviso="";
        try {
            $fl_boleto = (new BancoConta())->fetchRow('id_banco_conta = ' . $listaParcelas[0]['id_banco_conta'])->fl_boleto;       
            
            $bearerToken = "";
            if($listaParcelas[0]['cd_banco'] == '077'){
                $path = explode('.', $_SERVER['HTTP_HOST']);
                if ($path[0] == 'www') {
                    $path = $path[1];
                } else {
                    $path = $path[0];
                }
                $ch = curl_init();

                curl_setopt($ch, CURLOPT_URL,"https://cdpj.partners.bancointer.com.br/oauth/v2/token");
                curl_setopt($ch, CURLOPT_POST, 1);
                curl_setopt($ch, CURLOPT_SSLCERT, "upload/cliente/".$path."/certificado/certificado".$listaParcelas[0]['cod_layout_api'].".crt");
                curl_setopt($ch, CURLOPT_SSLKEY, "upload/cliente/".$path."/certificado/certificado".$listaParcelas[0]['cod_layout_api'].".key");
                curl_setopt($ch, CURLOPT_POSTFIELDS,
                    http_build_query(array('client_id' => $listaParcelas[0]['pp_token'],
                        'client_secret' => $listaParcelas[0]['password'],
                        'scope' => 'boleto-cobranca.read boleto-cobranca.write',
                        'grant_type' => 'client_credentials')));
                curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/x-www-form-urlencoded'));

                // Receive server response ...
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

                $server_response = curl_exec($ch);
                $error = curl_error($ch);
                $errno = curl_errno($ch);

                curl_close ($ch);

                if ($error !== '') {
                    throw new Exception($error);
                    die;
                }

                if ($server_response == '') {
                    throw new Exception("Resposta vazia, provavelmente o limite de chamadas foi atingido...\n");
                    die;
                }

                $obj = json_decode($server_response);

                $bearerToken=$obj->{'access_token'};
            }
            elseif($listaParcelas[0]['cd_banco'] == '136'){
                $curl = curl_init();

                curl_setopt_array($curl, array(
                CURLOPT_URL => 'https://api.e-unicred.com.br/oauth2/v2/grant-token',//'https://api.e-unicred.com.br/homolog/oauth2/v2/grant-token',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_POSTFIELDS =>json_encode(array("nomeUsuario"=> $listaParcelas[0]['pp_token'], "senha"=>$listaParcelas[0]['password'])),
                CURLOPT_HTTPHEADER => array(
                    'apiKey: '.$listaParcelas[0]['gerar_token'],
                    'Content-Type: application/json'
                ),
                ));

                $response = curl_exec($curl);

                curl_close($curl);
                $autenticacao = json_decode($response);
                if(!$autenticacao->accessToken){
                    echo "falha na autenticao ".$response;
                    //die;
                }

                $bearerToken=$autenticacao->accessToken;

            }

            foreach ($listaParcelas as $parcela) {
                
                if ($contatoTexto != '') {
                    $contatoTexto .= ', ';
                } else {
                    $idContrato = $parcela['idContrato'];
                }
                $contatoTexto .= $parcela['id_parcela'] . '-' . $parcela['tp_parcela'];
                //Salva em relacionamento a variavel com todas parcelas emitidas do contrato
                if ($idContrato != $parcela['idContrato'] || $qtdeMaximaParc == $i) {
                    $referencia = 'Log: Boletos Gerados referente a(s) parcela(s) ' . $contatoTexto;
                    (new Relacionamento())->saveContato(23, date('Y-m-d'), $idContrato, $referencia);
                    $contatoTexto = '';
                }
                //Verificando a quantidade de parcelas do contrato
                $nrParcelas = $tbParcela->getQtdeParcelas($parcela['idContrato'], $parcela['id_negociacao'], $parcela['id_renegociacao']);
                //Seta quantidade de parcelas de acordo com o tipo
                switch ($parcela['tp_parcela']) {
                    case 'N':
                        $parcela['nrParcelas'] = ($parcela['id_renegociacao']) ? $nrParcelas['QtdeRenegociada'] : $nrParcelas['QtdeNormal'];
                        break;
                    case 'S':
                        $parcela['nrParcelas'] = $nrParcelas['QtdeSinal'];
                        break;
                    case 'I':
                        $parcela['nrParcelas'] = $nrParcelas['QtdeIntercalada'];
                        break;
                    case 'C':
                        $parcela['nrParcelas'] = $nrParcelas['QtdeChave'];
                        break;
                    case 'G':
                        $parcela['nrParcelas'] = $nrParcelas['QtdeNegociada'];
                        break;
                    case 'Q':
                        $parcela['nrParcelas'] = $nrParcelas['QtdeQuitadas'];
                        break;
                    case 'A':
                        $parcela['nrParcelas'] = $nrParcelas['QtdeAvulsas'];
                        break;
                }
                $objParcela = $tbParcela->fetchRow('id_parcela_contrato = ' . $parcela['id_parcela_contrato']);

                if($parcela['cd_banco'] == '077' ){//inter
                    if($parcela['fl_envio'] !='1'||$parcela['linha_digitavel']== NULL ){
                        $arrayInter = array(
                            "seuNumero" => $parcela['id_parcela_contrato'],
                            "valorNominal" => $parcela['vl_parcela'],
                            "valorAbatimento" => $parcela['desconto'],
                            "dataVencimento" => $parcela['dt_parcela'],
                            "numDiasAgenda" => $parcela['nr_dias_permanencia'],
                            "atualizarPagador" => false,
                            "pagador" => array(
                                "cpfCnpj" => $parcela['nr_cnpj']?preg_replace("/[^0-9]/", "", $parcela['nr_cnpj']): preg_replace("/[^0-9]/", "", $parcela['nr_cpf']),
                                "tipoPessoa" => $parcela['nr_cnpj']?"JURIDICA":"FISICA",
                                "nome" => utf8_encode($parcela['nm_pessoa']),
                                "endereco" => utf8_encode($parcela['cliEndereco']),
                                "cidade" => utf8_encode($parcela['cliCidade']),
                                "uf" => $parcela['cliUf'],
                                "cep" => preg_replace("/[^0-9]/", "", $parcela['cliCep']),
                                "email" => $parcela['email'],
                                "ddd" => substr(preg_replace("/[^0-9]/", "", $parcela['nr_celular']),0,2),
                                "telefone" => substr(preg_replace("/[^0-9]/", "", $parcela['nr_celular']),2,9),
                                "numero" => utf8_encode($parcela['cliNrEndereco']),
                                "complemento" => utf8_encode($parcela['cliComplemento']),
                                "bairro" => utf8_encode($parcela['cliBairro']),
                            ),
                            "mensagem" => array(
                                "linha1" => utf8_encode($parcela['msg_boleto']),
                                "linha2" => utf8_encode($parcela['msg_adicional'])
                            ),
                            "beneficiarioFinal"=>array(
                                "cpfCnpj" => $parcela['cnpj_cedente']?preg_replace("/[^0-9]/", "", $parcela['cnpj_cedente']): preg_replace("/[^0-9]/", "", $parcela['cpf_cedente']),
                                "tipoPessoa" => $parcela['cnpj_cedente']?"JURIDICA":"FISICA",
                                "cpfCnpj" => preg_replace("/[^0-9]/", "", $parcela['cnpj_cedente']),
                                "tipoPessoa" => "JURIDICA",
                                "nome" => utf8_encode($parcela['nm_cedente']),
                                "endereco" => utf8_encode($parcela['cedEndereco']),
                                "cidade" => utf8_encode($parcela['cedCidade']),
                                "uf" => $parcela['cedUf'],
                                "cep" => preg_replace("/[^0-9]/", "", $parcela['cedCep']),
                                "email" => $parcela['cedEmail'],
                                "ddd" => substr(preg_replace("/[^0-9]/", "", $parcela['cedTelefone']),0,2),
                                "telefone" => substr(preg_replace("/[^0-9]/", "", $parcela['cedTelefone']),2,9),
                                "numero" => utf8_encode($parcela['cedNrEndereco']),
                                "complemento" => utf8_encode($parcela['cedComplemento']),
                                "bairro" => utf8_encode($parcela['cedBairro']),
                            )
                        );

                        if($parcela['desconto'] && floatval($parcela['desconto'])){

                            $arrayInter["desconto1"] = array(
                                "codigoDesconto" => "VALORFIXODATAINFORMADA",
                                "taxa" => 0,
                                "valor" => $parcela['desconto'],
                                "data" => $parcela['dt_parcela']
                            );
                        }
                        if($parcela['multa']&& floatval($parcela['multa'])){

                            $arrayInter["multa"] = array(
                                "codigoMulta" => "PERCENTUAL",
                                "taxa" => $parcela['multa'],
                                "valor" => 0,
                                "data" => date('Y-m-d', strtotime($parcela['dt_parcela'] . ' +1 day'))
                            );
                        }
                        $jurosFormatado = number_format($parcela['vl_parcela']*($parcela['juros']/100), 2, '.', '');
                        if($parcela['juros']&&($jurosFormatado!="0.00")){

                            $arrayInter["mora"] = array(
                                "codigoMora" => "VALORDIA",
                                "taxa" => 0,
                                "valor" =>  $jurosFormatado,
                                "data" => date('Y-m-d', strtotime($parcela['dt_parcela'] . ' +1 day'))
                            );
                        }
                        else{
                            $arrayInter["mora"] = array(
                                "codigoMora" => "ISENTO",
                                "taxa" => 0,
                                "valor" => 0
                            );
                        }

                        $path = explode('.', $_SERVER['HTTP_HOST']);
                        if ($path[0] == 'www') {
                            $path = $path[1];
                        } else {
                            $path = $path[0];
                        }
                        if($_GET['debug']=="1"){
                            var_dump($arrayInter);die;
                        }
                        $auth='Authorization: Bearer ' . $bearerToken;
                        $cc='x-conta-corrente: '.$parcela['conta_corrente'].$parcela['conta_corrente_dv'];
                        $json='Content-Type: application/json';
                        $data = json_encode($arrayInter);
                        $ch = curl_init();
                        curl_setopt($ch, CURLOPT_URL, "https://cdpj.partners.bancointer.com.br/cobranca/v2/boletos");
                        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
                        curl_setopt($ch, CURLOPT_SSLVERSION, CURL_SSLVERSION_TLSv1_2);
                        curl_setopt($ch, CURLOPT_HTTPHEADER, array($auth,$cc,$json));
                        curl_setopt($ch, CURLOPT_SSLCERT, "upload/cliente/".$path."/certificado/certificado".$parcela['cod_layout_api'].".crt");
                        curl_setopt($ch, CURLOPT_SSLKEY, "upload/cliente/".$path."/certificado/certificado".$parcela['cod_layout_api'].".key");
                        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
                        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

                        $result = curl_exec($ch);
                        $error = curl_error($ch);
                        $errno = curl_errno($ch);
                        curl_close ($ch);

                        if ($error !== '') {
                            throw new Exception($error);
                            die;
                        }
                        $objResultado = json_decode($result);
                        if($objResultado->nossoNumero){
                            $parcela['nr_boleto'] = substr($objResultado->nossoNumero, -10);
                            $parcela['cod_barras'] = $objResultado->codigoBarras;
                            $parcela['linha_digitavel'] = $objResultado->linhaDigitavel;  
                            $objParcela->nr_boleto = substr($objResultado->nossoNumero, -10);
                            $objParcela->nosso_numero = substr($objResultado->nossoNumero, -10);
                            $objParcela->cod_barras = $objResultado->codigoBarras;
                            $objParcela->linha_digitavel = $objResultado->linhaDigitavel;
                            $objParcela->fl_envio = 1;
                            $objParcela->id_banco_boleto = $parcela['id_banco_conta'];
                            $objParcela->log = 'Boleto 1 via gerado - Banco Inter - ' . Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - i';
                            $objParcela->save();
                        }
                        else{
                            print $result;die;
                        }
                    }
                    $dados[] = Parcela::toDados($parcela);
                }
                elseif($parcela['cd_banco'] == '133'){//cresol
                    if($parcela['fl_envio'] !='1'||$parcela['linha_digitavel']== NULL){
                        $arrayCresol = array(
                            "valorNominal" => $parcela['vl_parcela'],
                            "idEspecie" =>2,
                            "numeroDocumento"=>$parcela['id_parcela_contrato'],
                            "dtVencimento" => $parcela['dt_parcela'],
                            "dtDocumento" => gmdate('Y-m-d'),
                            "docPagador" => $parcela['nr_cnpj']?preg_replace("/[^0-9]/", "", $parcela['nr_cnpj']): preg_replace("/[^0-9]/", "", $parcela['nr_cpf']),
                            "tipoPagador" => $parcela['nr_cnpj']?"1":"0",
                            "pagadorNome" => utf8_encode($parcela['nm_pessoa']),
                            "pagadorEndereco" => utf8_encode($parcela['cliEndereco']),
                            "pagadorCidade" => utf8_encode($parcela['cliCidade']),
                            "pagadorUf" => $parcela['cliUf'],
                            "pagadorCep" => preg_replace("/[^0-9]/", "", $parcela['cliCep']),
                            "pagadorEnderecoNumero" => utf8_encode($parcela['cliNrEndereco']),
                            "pagadorBairro" => utf8_encode($parcela['cliBairro']),
                                
                        );

                        if($parcela['desconto']){

                            $arrayCresol["valorDesconto"] =  $parcela['desconto'];

                            $arrayCresol["dtLimiteDesconto"] = $parcela['dt_parcela'];
                        }
                        if($parcela['multa']){
                            $arrayCresol["cdTipoMulta"] = "VALOR_PERCENTUAL";
                            $arrayCresol["valorMulta"] = $parcela['multa'];
                        }
                        else{
                            $arrayCresol["cdTipoMulta"] = "ISENTO";
                        }
                        $jurosFormatado = number_format($parcela['vl_parcela']*($parcela['juros']/100), 2, '.', '');
                        if($parcela['juros']&&($jurosFormatado!="0.00")){

                            $arrayCresol["cdTipoJuros"] = "VALOR_FIXO";
                            $arrayCresol["valorJuros"] =  $jurosFormatado;
                        }
                        else{
                            $arrayCresol["cdTipoJuros"] =  "ISENTO";
                        }

                        if($_GET['debug']=="1"){
                            var_dump($arrayCresol);die;
                        }
                        $path = explode('.', $_SERVER['HTTP_HOST']);
                        if ($path[0] == 'www') {
                            $path = $path[1];
                        } else {
                            $path = $path[0];
                        }
                        $ch = curl_init();

                        $bearerToken=$_GET['tokenCresol'];

                        $auth='Authorization: Bearer ' . $bearerToken;
                        $json='Content-Type: application/json';
                        $data = json_encode([$arrayCresol]);


                        $curl = curl_init();
                        
                        curl_setopt_array($curl, array(
                          CURLOPT_URL => 'https://cresolapi.governarti.com.br/titulos',
                          CURLOPT_RETURNTRANSFER => true,
                          CURLOPT_ENCODING => '',
                          CURLOPT_MAXREDIRS => 10,
                          CURLOPT_TIMEOUT => 0,
                          CURLOPT_FOLLOWLOCATION => true,
                          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                          CURLOPT_CUSTOMREQUEST => 'POST',
                          CURLOPT_POSTFIELDS =>$data,
                          CURLOPT_HTTPHEADER => array(
                            'Content-Type: application/json',
                            'Authorization: Bearer '. $bearerToken
                          ),
                        ));
                                                
                        $result = curl_exec($curl);
                        $error = curl_error($curl);
                        $errno = curl_errno($curl);

                        curl_close($curl);
                        

                        if ($error !== '') {
                            throw new Exception($error);
                            die;
                        }
                        $objResultado = json_decode($result);
                        if(isset($objResultado[0]) && $objResultado[0]->nossoNumero){
                            $parcela['nr_boleto'] = $objResultado[0]->nossoNumero;
                            $parcela['cod_barras'] = $objResultado[0]->codigoBarras;
                            $parcela['linha_digitavel'] = $objResultado[0]->linhaDigitavel;  
                            $objParcela->nr_boleto = $objResultado[0]->nossoNumero;
                            $objParcela->nosso_numero = $objResultado[0]->nossoNumero;
                            $objParcela->cod_barras = $objResultado[0]->codigoBarras;
                            $objParcela->linha_digitavel = $objResultado[0]->linhaDigitavel;
                            $objParcela->fl_envio = 1;
                            $objParcela->id_banco_boleto = $parcela['id_banco_conta'];
                            $objParcela->log = 'Boleto 1 via gerado - Banco Cresol - ' . Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - i';
                            $objParcela->save();
                        }
                        else{
                            print $result;
                        }
                    }
                    $dados[] = Parcela::toDados($parcela);
                }
                elseif($parcela['cd_banco'] == '136' && $parcela['cod_layout_api']){ //Banco Unicred
                    if($parcela['fl_envio'] !='1'||$parcela['linha_digitavel']== NULL){
                        $arrayUnicred = array(
                            "beneficiarioVariacaoCarteira"=>$parcela['nr_carteira'],
                            "seuNumero" => $parcela['id_parcela_contrato'],
                            "valor" => $parcela['vl_parcela'],
                            "codigoBeneficiario" => $parcela['cd_cedente'],
                            "vencimento" => $parcela['dt_parcela'], 
                            "indicacaoTituloDescontavel" => false,
                            "enviaBoletoEmail" => false,
                            "pagador" => array(
                                "nomeRazaoSocial" => utf8_encode(substr($parcela['nm_pessoa'],0,40)),
                                "tipoPessoa" => $parcela['nr_cnpj']?"J":"F",
                                "tipoDocumento"=> $parcela['nr_cnpj']?"CNPJ":"CPF",
                                "numeroDocumento" => $parcela['nr_cnpj']?preg_replace("/[^0-9]/", "", $parcela['nr_cnpj']): preg_replace("/[^0-9]/", "", $parcela['nr_cpf']),
                                "nomeFantasia"=> utf8_encode(substr($parcela['nm_pessoa'],0,40)),
                                "endereco"=>array(
                                    "cep" => preg_replace("/[^0-9]/", "", $parcela['cliCep']),
                                    "cidade" => $parcela['cliCidade'],
                                    "logradouro" => utf8_encode($parcela['cliEndereco']),
                                    "uf" => $parcela['cliUf'],
                                )
                            ),
                            "mensagensFichaCompensacao" => array(
                              utf8_encode($parcela['msg_boleto']),
                              utf8_encode($parcela['msg_adicional'])
                            ),
                        );
                        
                        if($parcela['desconto']&& floatval($parcela['desconto'])){
                            $arrayUnicred["desconto"] = array(
                                "indicador" => "1",
                                "valor" => $parcela['desconto'],
                                "dataLimite" => $parcela['dt_parcela']
                            );
                        }

                        $jurosFormatadoMulta = number_format($parcela['vl_parcela'], 2, '.', '');
                        if($parcela['multa']){
                            $arrayUnicred['multa']["codigo"] = "2"; 
                            $arrayUnicred['multa']["valor"] = $parcela['multa']; 
                            $arrayUnicred['multa']["dataInicio"] = date('Y-m-d', strtotime($parcela['dt_parcela'] . ' +1 day'));
                        }
        
                        if($parcela['juros']){
                            $arrayUnicred['juros']["codigo"] = "2"; 
                            $arrayUnicred['juros']["valor"] = $parcela['juros']; 
                            $arrayUnicred['juros']["dataInicio"] = date('Y-m-d', strtotime($parcela['dt_parcela'] . ' +1 day'));
                        }

                        if($_GET['debug']=="1"){
                            var_dump($arrayUnicred);die;
                        }
                        $path = explode('.', $_SERVER['HTTP_HOST']);
                        if ($path[0] == 'www') {
                            $path = $path[1];
                        } else {
                            $path = $path[0];
                        }

                        $curl = curl_init();

                        curl_setopt_array($curl, array(
                        CURLOPT_URL => 'https://api.e-unicred.com.br/cobranca/v2/beneficiarios/'.$parcela['req_cliente_id'].'/titulos',//'https://api.e-unicred.com.br/homolog/cobranca/v2/beneficiarios/'.$parcela['req_cliente_id'].'/titulos',
                        CURLOPT_RETURNTRANSFER => true,
                        CURLOPT_ENCODING => '',
                        CURLOPT_MAXREDIRS => 10,
                        CURLOPT_TIMEOUT => 0,
                        CURLOPT_FOLLOWLOCATION => true,
                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                        CURLOPT_CUSTOMREQUEST => 'POST',
                        CURLOPT_POSTFIELDS =>json_encode($arrayUnicred),
                        CURLOPT_HTTPHEADER => array(
                            'apiKey: '.$parcela['gerar_token'],
                            'cooperativa: '.$parcela['nr_cooperativa'],
                            'Content-Type: application/json',
                            'Authorization: Bearer '.$bearerToken,
                        ),
                        ));

                        $response = curl_exec($curl);
                        
                        $httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
                        curl_close($curl);
                        $resposta = json_decode($response);
                        if($resposta->message){
                            echo ($response);
                            die;
                        }
                        elseif($httpCode==200){
                            $id_boleto = $response;
                            $aviso = $aviso . "Registrando o boleto ".$parcela['id_parcela_contrato'].", logo o boleto estar disponvel nas notificaes.\n";
                            $parcela['nr_boleto'] = null;
                            $parcela['cod_barras'] = null;
                            $parcela['linha_digitavel'] = null; 
                            $parcela['qrCode'] = null;
                            $parcela['cod_boleto_api'] = $id_boleto;
                            $objParcela->nosso_numero = null;
                            $objParcela->nr_boleto = null;
                            $objParcela->cod_barras = null;
                            $objParcela->linha_digitavel = null;
                            $objParcela->fl_envio = 1;
                            $objParcela->id_banco_boleto = $parcela['id_banco_conta'];
                            $objParcela->qrCode = null;
                            $objParcela->cod_boleto_api = $id_boleto;
                        }
                        else{
                            echo $response; die;
                        }
                    }
                    if($parcela['vl_parcela_2avia']){
                        $parcela['vl_parcela'] = $parcela['vl_parcela_2avia'];

                    }
                    $objParcela->visualizado = "1";
                    $objParcela->log = 'Boleto 1 via gerado - Banco Unicredi - ' . Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - i';
                    $objParcela->save();
                    $dados[] = Parcela::toDados($parcela);
                    
                }
                elseif($parcela['cd_banco'] == '748' && $parcela['cod_layout_api']){ //Banco Sicredi
                    if($parcela['fl_envio'] !='1'||$parcela['linha_digitavel']== NULL){
                        $arraySicredi = array(
                            "codigoBeneficiario" => $parcela['cd_cedente'],
                            "dataVencimento" => $parcela['dt_parcela'], 
                            "especieDocumento" => "DUPLICATA_MERCANTIL_INDICACAO",
                            "pagador" => array(
                            "cep" => preg_replace("/[^0-9]/", "", $parcela['cliCep']),
                            "cidade" => $parcela['cliCidade'],
                            "documento" => $parcela['nr_cnpj']?preg_replace("/[^0-9]/", "", $parcela['nr_cnpj']): preg_replace("/[^0-9]/", "", $parcela['nr_cpf']),
                            "nome" => $parcela['nm_pessoa'],
                            "tipoPessoa" => $parcela['nr_cnpj']?"PESSOA_JURIDICA":"PESSOA_FISICA",
                            "endereco" => utf8_encode($parcela['cliEndereco']),
                            "uf" => $parcela['cliUf'],
                            ),
                            "tipoCobranca" => "HIBRIDO",
                            "seuNumero" => $parcela['id_parcela_contrato'],
                            "valor" => $parcela['vl_parcela']
                        );
                        
                        if($parcela['vl_desc_normal'] > 0 && $parcela['vl_desc_normal'] != null){
                            $arraySicredi += array(
                                "tipoDesconto" => "VALOR",
                                "valorDesconto1" => number_format(($parcela['vl_desc_normal'] / 100) * $parcela['vl_parcela'], 2, '.', ''),
                                "dataDesconto1" => $parcela['dt_parcela']
                            );
                        }

                        $jurosFormatadoMulta = number_format($parcela['multa'], 2, '.', '');
                        $jurosFormatado = number_format($parcela['vl_parcela']*$parcela['juros'], 2, '.', '');

                        if($parcela['juros']&&($jurosFormatado!="0.00")){
                            if($parcela['tp_multa']=="P"){
                                $arraySicredi["tipoJuros"] = "PERCENTUAL";
                                $arraySicredi["juros"] =  number_format($parcela['juros'], 2, '.', '');;
                            }
                            else if($parcela['tp_multa']=="V"){
                                $arraySicredi["tipoJuros"] = "VALOR";
                                $arraySicredi["juros"] = $jurosFormatado;
                            }
                        }

                        if($parcela['multa']&& ($jurosFormatado!="0.00")){
                            $arraySicredi["multa"] = $jurosFormatadoMulta;
                        }
                        
                        $arraySicredi['mensagens'] = array(
                            utf8_encode($parcela['msg_boleto']) ? utf8_encode($parcela['msg_boleto']) : null,
                            utf8_encode($parcela['msg_adicional']) ? utf8_encode($parcela['msg_adicional']) : null
                        );
                        
                        if($_GET['debug']=="1"){
                            var_dump($arraySicredi);die;
                        }
                        $path = explode('.', $_SERVER['HTTP_HOST']);
                        if ($path[0] == 'www') {
                            $path = $path[1];
                        } else {
                            $path = $path[0];
                        }

                        $curl = curl_init();

                        curl_setopt_array($curl, array(
                        CURLOPT_URL => 'https://api-parceiro.sicredi.com.br/auth/openapi/token',
                        CURLOPT_RETURNTRANSFER => true,
                        CURLOPT_ENCODING => '',
                        CURLOPT_MAXREDIRS => 10,
                        CURLOPT_TIMEOUT => 0,
                        CURLOPT_FOLLOWLOCATION => true,
                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                        CURLOPT_CUSTOMREQUEST => 'POST',
                        CURLOPT_POSTFIELDS => http_build_query(array('username' => $parcela['pp_token'],
                        'password' => $parcela['password'],
                        'scope' => 'cobranca',
                        'grant_type' => 'password')),
                        CURLOPT_HTTPHEADER => array(
                            'x-api-key: '.$parcela['gerar_token'],
                            'context: COBRANCA',
                            'Content-Type: application/x-www-form-urlencoded',
                        ),
                        ));
                        
                        $server_response = curl_exec($curl);

                        $result = curl_exec($curl);
                        $error = curl_error($curl);
                        curl_close($curl);

                        if ($error !== '') {
                            throw new Exception($error);
                            die;
                        }
                        
                        $obj = json_decode($server_response);
                        if(!isset($obj->{'access_token'})){
                            echo "Autenticao:<br>";
                            echo $server_response; die;
                        }
                        $token = $obj->{'access_token'};
                        $auth='Authorization: Bearer ' . $token;
                        $curl = curl_init();
                        $data = json_encode($arraySicredi);

                        curl_setopt_array($curl, array(
                        CURLOPT_URL => 'https://api-parceiro.sicredi.com.br/cobranca/boleto/v1/boletos',
                        CURLOPT_RETURNTRANSFER => true,
                        CURLOPT_ENCODING => '',
                        CURLOPT_MAXREDIRS => 10,
                        CURLOPT_TIMEOUT => 0,
                        CURLOPT_FOLLOWLOCATION => true,
                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                        CURLOPT_CUSTOMREQUEST => 'POST',
                        CURLOPT_POSTFIELDS => $data,
                        CURLOPT_HTTPHEADER => array(
                            'x-api-key: ' . $parcela['gerar_token'],
                            'cooperativa: ' . $parcela['agencia'],
                            'posto: ' . $parcela['carteira_variacao'],
                            'codigoBeneficiario: ' . $parcela['cd_cedente'],
                            'Content-Type: application/json',
                            $auth
                        ),
                        ));

                        $response = curl_exec($curl);
                        curl_close($curl);
                        
                        if ($error !== '') {
                            throw new Exception($error);
                            die;
                        }

                        $objResultado = json_decode($response);
                        
                        if(!isset($objResultado->nossoNumero)){
                            echo "Emisso:<br>";
                            echo $response; die;
                        }
                        if($objResultado->nossoNumero){
                            $parcela['nr_boleto'] = $objResultado->nossoNumero;
                            $parcela['cod_barras'] = $objResultado->codigoBarras;
                            $parcela['linha_digitavel'] = $objResultado->linhaDigitavel; 
                            $parcela['id_banco_boleto'] = $parcela['id_banco_conta'];
                            $parcela['qrCode'] = $objResultado->qrCode;
                            $parcela['txid'] = $objResultado->txid;

                            $objParcela->nr_boleto = $objResultado->nossoNumero;
                            $objParcela->cod_barras = $objResultado->codigoBarras;
                            $objParcela->linha_digitavel = $objResultado->linhaDigitavel;
                            $objParcela->fl_envio = 1;
                            $objParcela->id_banco_boleto = $parcela['id_banco_conta'];
                            $objParcela->qrCode = $objResultado->qrCode;
                            $objParcela->txid = $objResultado->txid;
                            $objParcela->log = 'Boleto 1 via gerado - Banco Sicredi API - ' . Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - i';
                            $objParcela->save();
                        }
                    }
                    $dados[] = Parcela::toDados($parcela);
                }
                elseif ($parcela['cd_banco'] == '274') { //Banco Grafeno
                    
                    //Realiza a cobrana do boleto, somente se no foi gerado e se no tiver o id do boleto
                    if ($parcela['fl_envio'] == '0' && !$parcela['cod_boleto_api']) {
                        
                        $boleto = ['paymentMethod' => 'boleto'];

                        $boleto['boletoDetails'] = ['yourNumber' => $parcela['id_parcela_contrato']];

                        if ($parcela['desconto'] > 0) {
    
                            $boleto['discount'] = [
                                    'range' => $parcela['dt_parcela'],
                                    'discountType' => 'fixed',
                                    'discountValue' => $parcela['desconto']
                            ];
                        }
    
                        $boleto['payer'] = [
                                'address' => [
                                    'street' => utf8_encode($parcela['cliEndereco']),
                                    'neighborhood' => utf8_encode($parcela['cliBairro']),
                                    'number' => $parcela['cliNrEndereco'],
                                    'state' => utf8_encode($parcela['cliUf']),
                                    'city' => utf8_encode($parcela['cliCidade']),
                                    'zipCode' => $parcela['cliCep'],
                                    'complement' => utf8_encode($parcela['cliComplemento']),
                                    'country' => 'Brasil'
                                ],
                                'phone' => [
                                    'number' => $parcela['nr_celular']
                                ],
                                'name' => utf8_encode($parcela['nm_pessoa']),
                                'documentNumber' => $parcela['nr_cpf'] ? $parcela['nr_cpf'] : $parcela['nr_cnpj'],
                                'email' => $parcela['email']
                        ];

                        $boleto += ['dueDate' => $parcela['dt_parcela'],
                                    'value' => $parcela['vl_parcela'],
                                    'interestType' => 'percentage',
                                    'interestValue' => $parcela['jurosMensal'],
                                    'applicableFine' => $parcela['multa'],
                                    'clientControlNumber' => $parcela['id_parcela_contrato']
                                ];
                        
                        $boleto['charge'] = ['value' => $parcela['vl_parcela']];
                        
                        if($_GET['debug']=="1"){
                            var_dump($boleto);die;
                        }
                        $curl = curl_init();
    
                        curl_setopt_array($curl, [
                        CURLOPT_URL => "https://pagamentos.grafeno.digital/api/v2/charges",
                        CURLOPT_RETURNTRANSFER => true,
                        CURLOPT_ENCODING => "",
                        CURLOPT_MAXREDIRS => 10,
                        CURLOPT_TIMEOUT => 30,
                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                        CURLOPT_CUSTOMREQUEST => "POST",
                        CURLOPT_POSTFIELDS => json_encode($boleto),
                        CURLOPT_HTTPHEADER => [
                            "Account-Number: " . $parcela['conta_corrente'] . '-' . $parcela['conta_corrente_dv'],
                            "Authorization: " . $parcela['pp_token'],
                            "accept: application/json",
                            "content-type: application/json"
                        ],
                        ]);
    
                        $response = curl_exec($curl);
                        $objResultado = json_decode($response);
                        
                        if($objResultado->data&&$objResultado->data->id){

                            $parcela['nr_boleto'] = $objResultado->data->attributes->boleto->data->attributes->ourNumber;
                            $parcela['cod_boleto_api'] = $objResultado->data->id;
                            $parcela['fl_envio'] = 1;
                            
                            $objParcela->nr_boleto = substr($objResultado->data->attributes->boleto->data->attributes->ourNumber, -10);
                            $objParcela->nosso_numero = $objResultado->data->attributes->boleto->data->attributes->ourNumber;
                            $objParcela->cod_boleto_api = $objResultado->data->id;
                            $objParcela->id_banco_boleto = $parcela['id_banco_conta'];
                            $objParcela->fl_envio = 1;
                        }
                        else{
                            echo $response; die;
                        }
                        curl_close($curl);

                        //guarda o valor mais recente do nr_boleto
                        $ultimoNrBoleto = 0;

                        //espera 5 segundos para que d tempo da api do banco gerar a linha digitvel e cdigo de barras.
                        for($load = 0;$load<10;$load++){
                            sleep(5);
                        
                            //busca os dados do boleto de acordo com o id retornado pelo banco
                            $curl = curl_init();
        
                            curl_setopt_array($curl, [
                            CURLOPT_URL => "https://pagamentos.grafeno.digital/api/v2/charges/".$parcela['cod_boleto_api'],
                            CURLOPT_RETURNTRANSFER => true,
                            CURLOPT_ENCODING => "",
                            CURLOPT_MAXREDIRS => 10,
                            CURLOPT_TIMEOUT => 30,
                            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                            CURLOPT_CUSTOMREQUEST => "GET",
                            CURLOPT_HTTPHEADER => [
                                "Account-Number: " . $parcela['conta_corrente'] . '-' . $parcela['conta_corrente_dv'],
                                "Authorization: " . $parcela['pp_token'],
                                "accept: application/json"
                            ],
                            ]);
        
                            $response = curl_exec($curl);
                            $dadosBoleto = json_decode($response);
                            
                            curl_close($curl);
                            if($dadosBoleto && $dadosBoleto->data && $dadosBoleto->data->attributes && $dadosBoleto->data->attributes->boleto && $dadosBoleto->data->attributes->boleto->data && $dadosBoleto->data->attributes->boleto->data->attributes && $dadosBoleto->data->attributes->boleto->data->attributes->lineCode){
                                $parcela['nr_boleto'] = $dadosBoleto->data->attributes->boleto->data->attributes->ourNumber;
                                $parcela['nosso_numero'] = $dadosBoleto->data->attributes->boleto->data->attributes->ourNumber;
                                $parcela['cod_barras'] = $dadosBoleto->data->attributes->boleto->data->attributes->barCode;
                                $parcela['linha_digitavel'] = $dadosBoleto->data->attributes->boleto->data->attributes->lineCode;

                                $objParcela->nosso_numero = $dadosBoleto->data->attributes->boleto->data->attributes->ourNumber;
                                $objParcela->nr_boleto = substr($dadosBoleto->data->attributes->boleto->data->attributes->ourNumber, -10);
                                $objParcela->cod_barras = $dadosBoleto->data->attributes->boleto->data->attributes->barCode;
                                $objParcela->linha_digitavel = $dadosBoleto->data->attributes->boleto->data->attributes->lineCode;
                                $objParcela->id_banco_boleto = $parcela['id_banco_conta'];
                                $objParcela->fl_envio = 1;
                                $objParcela->log = 'Boleto 1 via gerado - Banco Grafeno - ' . Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - i';
                                $objParcela->save();
                                $ultimoNrBoleto = substr($dadosBoleto->data->attributes->boleto->data->attributes->ourNumber, -10);
                                break;
                            }
                        }

                        //salva o nr_boleto mais recente na tabela BANCO_CONTA
                        if ($ultimoNrBoleto > 0) {
                            $bancoConta = (new BancoConta())->fetchRow('id_banco_conta = ' . $parcela['id_banco_conta']);
    
                            $bancoConta->nr_boleto = $ultimoNrBoleto;
                            $bancoConta->save();
                        }
                    }
                    $dados[] = Parcela::toDados($parcela);
                }
                else{
                    
                    /**
                     * condio criada para caso o cliente gere um boleto para um banco digital,
                     * e depois gere o mesmo boleto s que dessa vez para um banco que no seja digital,
                     * o sistema reseta os campos referentes a API, para que na hora de ler o cdigo
                     * de barras no aparea os dados do banco digital
                     */
                    if ($parcela['cod_boleto_api']) {
                        $parcela['cod_barras'] = null;
                        $parcela['linha_digitavel'] = null;
                        $parcela['cod_boleto_api'] = null;
                        $objParcela->cod_barras = null;
                        $objParcela->linha_digitavel = null;
                        $objParcela->cod_boleto_api = null;
                    }

                    //Se for SICREDI e se o cliente estiver gerando segunda via, o id_banco_boleto, recebe o valor null.
                    if ($parcela['cd_banco'] == '748' && $objParcela['fl_envio'] == '1') {
                        $objParcela->id_banco_boleto = null;
                    }
                    
                    /**
                     * A condio: $parcela['id_banco_boleto'] != $parcela['id_banco_conta']
                     * foi feita pois ao trocar o contrato de banco id_parcela_contrato para nr_boleto
                     * ao emitir o boleto no novo banco, o sistema no estava gerando o nr_boleto
                     */
                    if ($objParcela['fl_envio'] == '0' || $parcela['id_banco_boleto'] != $parcela['id_banco_conta']) {
                        //Se for SICREDI ou RIBEIRO PRETO (por enquanto) faz este processo com nr_boleto
                        if ($parcela['cd_banco'] == '748' || $parcela['cd_banco'] == '741') {

                            $bancoConta = (new BancoConta())->fetchRow('id_banco_conta = ' . $parcela['id_banco_conta']);

                            $nrBoletoIncremento = $bancoConta['nr_boleto'] + 1;

                            $bancoConta->nr_boleto = $nrBoletoIncremento;
                            $bancoConta->save();

                            $objParcela->nr_boleto = $nrBoletoIncremento;
                            // $objParcela->id_banco_boleto = $parcela['id_banco'];
                            $objParcela->id_banco_boleto = null;

                            $parcela['nr_boleto'] = $nrBoletoIncremento;

                        } elseif($fl_boleto=='2' && $parcela['id_banco']){
                            $bancoConta = (new BancoConta())->fetchRow('id_banco_conta = '.$parcela['id_banco_conta']);
                            
                            if( $bancoConta['nr_boleto']!="0000000000"){
                                $nrBoletoIncremento = $bancoConta['nr_boleto'] + 1;
                                $bancoConta->nr_boleto = $nrBoletoIncremento;
                                $bancoConta->save();
                                
                                $objParcela->nr_boleto = $nrBoletoIncremento;
                                
                                $parcela['nr_boleto'] = $nrBoletoIncremento;
                            }
                            else{
                                $proximoNr = new Parcela();
                                $nrBoletoIncremento = $proximoNr->proximoNrBoletoBanco($parcela['id_banco']);
                                $bancoConta->nr_boleto = $nrBoletoIncremento;
                                $bancoConta->save();
                                $objParcela->nr_boleto = $nrBoletoIncremento;
                                $parcela['nr_boleto'] = $nrBoletoIncremento;
                            }
                        } elseif ($fl_boleto == '1' && $parcela['cd_banco'] != '748' && $parcela['cd_banco'] != '741') {
                            
                            $bancos = (new Banco)->findBancoByIdBancoConta($parcela['id_banco_conta']);

                            $bancoConta = (new BancoConta())->fetchRow('id_banco_conta = ' . $parcela['id_banco_conta']);
                            
                            $idsLivresParcela = (new Parcela)->buscaNrBoletosAvulsosParcela($parcela['id_banco_conta'], $bancos);
                            $idsLivresParcelaHistorico = (new ParcelaHistorico)->buscaNrBoletosAvulsosParcelaHistorico($parcela['id_banco_conta'], $bancos);
                            
                            if ($idsLivresParcela == null && $idsLivresParcelaHistorico != null) {
                                $idsLivres = $idsLivresParcelaHistorico;
                            } elseif ($idsLivresParcela != null && $idsLivresParcelaHistorico == null) {
                                $idsLivres = $idsLivresParcela;
                            } elseif ($idsLivresParcela == null && $idsLivresParcelaHistorico == null) {
                                $idsLivres = null;
                            } else {
                                $idsLivres = array_intersect($idsLivresParcela, $idsLivresParcelaHistorico);
                            }
                            
                            if ($idsLivres) {
                                $objParcela->nr_boleto = $idsLivres[array_keys($idsLivres)[0]];
                                unset($idsLivres[array_keys($idsLivres)[0]]);
                            } else {
                            
                                $maxNrBoleto = (new Parcela)->getMaxNrBoletoParcelaEparcelaHistorico($bancos);
                                $nrBoletoIncremento = (int)$maxNrBoleto + 1;
                                
                                if (!$maxNrBoleto) {
                                    $nrBoletoIncremento = (int)$bancoConta['nr_boleto'] + 1;
                                }

                                $objParcela->nr_boleto = $nrBoletoIncremento;
                            }
                            
                            $parcela['nr_boleto'] = $objParcela->nr_boleto;
                            $bancoConta->nr_boleto = $objParcela->nr_boleto;
                            $bancoConta->save();
                        }

                        if (!$objParcela->ano_boleto_emissao) {
                            $objParcela->ano_boleto_emissao = (int)date('y');
                        }

                        /**
                         * Essa condio foi feita para caso o banco do cliente seja id_parcela_contrato
                         * e j tenha um nr_boleto na parcela que ser emitida, no boleto gerado aparece
                         * com o nr_boleto no campo de nosso nmero e no id_parcela_contrato
                         */
                        if($fl_boleto == '0' && $parcela['cd_banco'] != '748') {
                            $objParcela->nr_boleto = null;
                            $parcela['nr_boleto'] = null;
                        }

                        $objParcela->fl_envio = 1;
                    }
                    
                    $objParcela->id_banco_boleto = $parcela['id_banco_conta'];
                    $objParcela->log = 'Boleto 1 via gerado - ' .Banco::buscaNomeBanco($parcela['cd_banco']). ' | ' . Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - i';
                    $objParcela->save();
                    
                    $dados[] = Parcela::toDados($parcela);
                    $i++;
                }
            }

            $db->commit();
        } catch (Exception $e) {
            $db->rollBack();
            $this->redir(array('modulo' => 'bo', 'controller' => 'emissao', 'action' => 'gerar'), array('exception' => 'Contate o suporte da Acade. Erro: '.$e->getMessage()));
        }

        // Condio que traz as informaes de Cliente e Empreendimento no verso do documento.
        if($_SESSION['opcaoVerso'] == 'S'){

            $cidade = new Db_Cidade();

            $this->set("clienteAcadeone", $clienteAcadeone);
            $clienteAcadeoneCidade = $cidade->find($clienteAcadeone['cd_municipio']);
            $this->set("clienteAcadeoneCidade", $clienteAcadeoneCidade);
        }

        $this->set('listaParcelas', $dados);
        if($aviso){
            echo '
            <html>
<head>
<meta charset="UTF-8">
<title>Redirecionamento</title>
<script type="text/javascript">
    window.location.href = `?m=bo&c=emissao&a=gerar&alerta='.$aviso.'`;
</script>
</head>
<body>
    <p>Esta pgina ser redirecionada para <a href="?m=bo&c=emissao&a=gerar&alerta='.$aviso.'">emisso</a>.</p>
</body>
</html>';
            die;

        }else{
            $this->display('boleto');
        }
    }
    public function boletoAction()
    {
        $tbParcela = new Parcela();
        $banco = new Banco();
        $Comunicacao = new Comunicacao();
        $Comunicacao= $Comunicacao->fetchRow('id_parcela_contrato= "'.$_GET['idParcela'].'" and id_contrato='.$_GET['idContrato']);
        if($Comunicacao){
            $Comunicacao->lido = date("Y-m-d H:i:s");
            $Comunicacao->save();
            $clienteAcade = new Db_Cliente();

            $clienteAcadeone = $clienteAcade->fetchRow();
    
            $idsParcelas = $Comunicacao->id_parcela_contrato;
 
            $tbParcela = new Parcela();
            $listaParcelas = $tbParcela->findParcelasBoletos(null,null,null,null,null,null,$idsParcelas);
            if(!$listaParcelas){
                $listaParcelas = $tbParcela->findParcelasBoletos(null,null,null,null,null,null,$idsParcelas,true);
            }
            if($listaParcelas[0]['id_banco_boleto']){
                $banco = new Banco();

                //Banco multi
                $banco = $banco->getAdapter()->select()
                    ->from(array('b' => TB_BANCO), array('id_banco' => 'id', 'cd_banco','multa','juros','msg_boleto','msg_adicional','agencia','agencia_dv','conta_corrente','conta_corrente_dv','cd_cedente','cnpj_cedente','cpf_cedente','nm_cedente','carteira','especie_documento','carteira_variacao','tp_juros','tp_multa', 'id_banco_conta'))
                    ->join(array('ta' => TB_AGRUPADA), 'ta.idTabela = 9 AND ta.idCampo = b.cd_banco', array('nmBanco'=>'descricao'))
                    ->where("id_banco_conta = {$listaParcelas[0]['id_banco_boleto']}")->query()->fetch();

                if(!$banco){
                    $banco = new Banco();
                    $banco = $banco->getAdapter()->select()
                    ->from(array('b' => TB_BANCO), array('id_banco' => 'id', 'cd_banco','multa','juros','msg_boleto','msg_adicional','agencia','agencia_dv','conta_corrente','conta_corrente_dv','cd_cedente','cnpj_cedente','cpf_cedente','nm_cedente','carteira','especie_documento','carteira_variacao','tp_juros','tp_multa', 'id_banco_conta'))
                    ->join(array('ta' => TB_AGRUPADA), 'ta.idTabela = 9 AND ta.idCampo = b.cd_banco', array('nmBanco'=>'descricao'))
                    ->where("id = {$listaParcelas[0]['id_banco_boleto']}")->query()->fetch();
                }
                    $bancoColumns = array('id_banco', 'cd_banco','multa','juros','msg_boleto','msg_adicional','agencia','agencia_dv','conta_corrente','conta_corrente_dv','cd_cedente','cnpj_cedente','cpf_cedente','nm_cedente','carteira','especie_documento','carteira_variacao','tp_juros','tp_multa', 'id_banco_conta', 'nmBanco');
                foreach ($listaParcelas as $key => $parcela) {
                    foreach ($bancoColumns as $coluna) {
                        $listaParcelas[$key][$coluna] = $banco[$coluna];
                    }
                }
            }
            //$dados[] = Parcela::toDados($listaParcelas[0]);
            //$this->set('listaParcelas',$dados);
                    
            $this->set('parcela', $listaParcelas[0]);
       
            $this->display('boletoComunicacao');
        }
        else{
            echo "Agendamento no encontrado";
        }
        
        
    }
    public function visualizarEmailAction()
    {
        $Comunicacao = new Comunicacao();
        $Comunicacao= $Comunicacao->fetchRow('id_parcela_contrato= "'.$_GET['idParcela'].'" and id_contrato='.$_GET['idContrato']);
        if($Comunicacao&&!isset($_GET['admin'])){
            $Comunicacao->lido = date("Y-m-d H:i:s");
            $Comunicacao->save();
            header("Content-Type: image/jpeg");
            echo file_get_contents(getcwd()."/public/images/acade_logomarca2.jpg");
        }
        else{
            echo "Agendamento no encontrado";
        }
    }
    public function validarAction()
    {
        if (!count($_POST['tipos'])) {
            $this->_helper->addMensagem('tipos', 'Selecione pelo menos um tipo de parcela');
            return false;
        }
        $campos = array('dataA' => 'Informe a data de incio.',
            'dataB' => 'Informe a data de fim.',
            'banco' => 'Selecione o banco.',
            'empreendimento' => 'Selecione o empreendimento.',
            'contrato' => 'Selecione o contrato.');

        foreach ($campos AS $k => $msg) {
            if ($_POST[$k] == '') {
                $this->_helper->addMensagem($k, $msg);
            }
        }
        if (!(count($this->_helper->getMensagens()) > 0)) {
            $ini = strtotime(str_replace('/', '-', $_POST['dataA']));
            $fim = strtotime(str_replace('/', '-', $_POST['dataB']));
            if ($ini > $fim) {
                $this->_helper->addMensagem('erroData', 'O perodo informado  invlido');
            }
        }
        //Verificando de tem parcelas no perodo solicidado.
        if ($this->_isPost && !count($this->_helper->getMensagens()) > 0) {
            
            $contrato = implode('","', $_POST['contrato']);
            $banco = $_POST['banco'];
            $empreendimento = $_POST['empreendimento'];

            $tipos = '(';
            foreach ($_POST['tipos'] as $tipo) {
                $tipos .= "'$tipo',";
            }

            $tipos = substr($tipos, 0, -1) . ")";
            //registrar Envio
            $dataA = Helper::getInputDate($_POST['dataA']);
            $dataB = Helper::getInputDate($_POST['dataB']);

            $listaParcelas = (new Parcela())->findParcelasBoletos($empreendimento, $contrato, $banco, $tipos, $dataA, $dataB);

            if (!$listaParcelas) {
                $msg = "No foi encontrado nenhuma parcela neste periodo.";
                $this->_helper->addMensagem('danger', $msg);
            }
        }
        //Mensagem de Erros
        if (count($this->_helper->getMensagens()) > 0) {
            $msgErros = '';
            foreach ($this->_helper->getMensagens() as $msg => $a)
                $msgErros .= utf8_encode($a) . '<br>';
            echo json_encode(array('msgErros' => $msgErros));
        } else {
            echo json_encode(true);
        }
    }
    /**
     * Lista em ajax dos nomes dos bancos cadastrados no empreendimento
     */
    public function bancoByEmpreendimentoAction()
    {
        $bancos = Banco::findByEmpreendimento($_POST['id_empreendimento'],true, false, false, true);
        $lista = [];
        if($bancos)
            foreach ($bancos as $banco) {
                $banco['nmBanco'] = Banco::findBancoNome($banco['cd_banco']);
                $lista[] = array(
                    'id' => $banco['id'],
                    'text' => utf8_encode($banco['nmBanco']) . ' - Ag.: ' . $banco['agencia'] . '-' . $banco['agencia_dv'] . '  Cc: ' . $banco['conta_corrente'] . '-' . $banco['conta_corrente_dv']
                );
            }

        echo json_encode($lista);
    }

    public function contratoByBancoEmpreendimentoAction()
    {
        $contratos = Contrato::byBancoEmpreendimento($_POST['id_empreendimento'], $_POST['banco'], Contrato::CONTRATO_GERADO, true, array("nm_pessoa", "lote", "quadra", "id"), true, true);

        $lista = [];
        if($contratos) {
            foreach ($contratos as $contrato) {
                $lista[] = array('id' => $contrato['id'], 'text' => utf8_encode($contrato['nm_pessoa']) . ' - Quadra: ' . utf8_encode($contrato['quadra']) . ' - Lote: ' . utf8_encode($contrato['lote']) . ' - Contrato: ' . utf8_encode($contrato['id']));
            }
        }
        echo json_encode($lista);
    }
}