<?php


class Boleto2aViaMultiController extends Controller
{
    private $empreendimentos;
    private $parcela;
    private $parcela2Via;

    public function __construct($request)
    {
        parent::__construct($request);
        $this->empreendimentos = new Empreendimento();
        $this->parcela = new Parcela();
        $this->parcela2Via = new Parcela2Via();
        $this->set("subtitulo", "Boleto 2 Via Multi");
        $this->set('nomeTela', "Boleto 2 Via Multi");
    }

    public function indexAction()
    {
        $empreendimentos = $this->empreendimentos->getDefaultAdapter()->select()
            ->from(array('e' => TB_EMPREENDIMENTO), array('e.nm_empreendimento', 'e.id'));

        //verifica se o usuario tem o perfil de usuario de empreendimento
        if ($_SESSION['usuario']) {
            try {
                $instanceUsuarioEmpreendimento = new Usuario_Empreendimento();
                $ids = $instanceUsuarioEmpreendimento->listaEmpreendimentosRepresentante($_SESSION['usuario']);
                if (count($ids)) {
                    $id = implode(',', $ids);
                    $empreendimentos->where("e.id IN({$id})");
                } else {
                    $empreendimentos->where("1");
                }
            } catch (Exception $e) {

            }
        }
        $empreendimentos = $empreendimentos->order('nm_empreendimento')->query()->fetchAll();

        //Criada condio para verificar se perfil tem permisso
        $alterarDados = (Db_Perfil::perfilPermissao(Login::getUsuario()->getPerfilId(), 'gerarBoleto2ViaMultiBanco') || Login::getUsuario()->getSuper() == 1);
        $this->set('alterarDados', $alterarDados);

        $this->set('empreendimentos', $empreendimentos);

        $this->display('index');
    }

    public function gerarAction()
    {
        $clienteAcade = new Db_Cliente();

        $fl_boleto = false;
        $clienteAcadeone = $clienteAcade->fetchRow();
        if ($this->_isPost || isset($_REQUEST['2aViaCobranca'])) {
            $parcelaId = $_REQUEST['parcelaContrato'];

            $parcela = $this->parcela->getAdapter()->select()
                ->from(['p' => TB_PARCELA], ['*'])
                ->join(['c' => TB_CONTRATO], 'c.id = p.id_contrato', ['idBancoContrato' => 'id_banco'])
                ->join(['b' => TB_BANCO], 'c.id_banco = b.id', ['cd_banco','id_banco_conta'])
                ->where('id_parcela_contrato = ?', $parcelaId)
                ->query()->fetch();
            
            $bancoDados = new Banco();

            //Banco multi
            $bancoDados = $bancoDados->getAdapter()->select()
            ->from(array('b' => TB_BANCO), array('id_banco' => 'id', 'cd_banco','multa','juros','msg_boleto','msg_adicional','agencia','agencia_dv','conta_corrente','conta_corrente_dv','cd_cedente','cnpj_cedente','cpf_cedente','nm_cedente','carteira','especie_documento','carteira_variacao','tp_juros','tp_multa', 'id_banco_conta'))
            ->join(array('bc' => TB_BANCO_CONTA), 'b.id_banco_conta = bc.id_banco_conta', 'cod_layout_api')
            ->joinLeft(array('la' => TB_LAYOUT), 'bc.cod_layout_api = la.id',array('pp_token','password','gerar_token','req_cliente_id'))
            ->join(array('ta' => TB_AGRUPADA), 'ta.idTabela = 9 AND ta.idCampo = b.cd_banco', array('nmBanco'=>'descricao'))
            ->where("b.id = {$_POST['banco']}")->query()->fetch();

            $bancoColumns = array('id_banco', 'cd_banco','multa','juros','msg_boleto','msg_adicional','agencia','agencia_dv','conta_corrente','conta_corrente_dv','cd_cedente','cnpj_cedente','cpf_cedente','nm_cedente','carteira','especie_documento','carteira_variacao','tp_juros','tp_multa', 'id_banco_conta', 'nmBanco', 'cod_layout_api', 'pp_token','password','gerar_token','req_cliente_id');

            foreach ($bancoColumns as $coluna) {
                $parcela[$coluna] = $bancoDados[$coluna];
            }
            $parcela['cd_banco'] = $bancoDados['cd_banco'];
            $parcela['id_banco_conta'] = $bancoDados['id_banco_conta'];
            $parcela['idBancoContrato'] = $_POST['banco'];
            
            $dataVencimento = Helper::getInputDate($_REQUEST['dataVencimento']);
            //Alterado condio de data verificao, para ser feita at a data atual do servidor!
            if (strtotime($dataVencimento) < strtotime(date("Y-m-d"))) {
                $this->_helper->addMensagem('fail', 'A nova data de vencimento no pode ser inferior a data atual.');
                $this->indexAction();
            }

            if (!$parcela) {
                $this->indexAction();
                $this->_helper->addMensagem('fail', 'J foi gerado 2 Via da parcela');
            } /*elseif ($parcela['fl_envio'] == '0') {
                //Testa se as parcelas para segunda via j foram impressas na primeira via
                $this->_helper->addMensagem('fail', 'No  permitido emitir segunda via sem que a primeira tenha sido impressa anteriormente.');
                $this->indexAction();
            } */else {

                try {
                    $db = Zend_Db_Table::getDefaultAdapter();
                    $db->beginTransaction();
                    $ultimoNr = $parcela['nr_boleto'];                                                               
                    $ultimoCodigoBarra = $parcela['cod_barras'];       
                    $ultimoLinhadigitavel = $parcela['linha_digitavel'];                                              
                    $fl_boleto = (new BancoConta())->fetchRow('id_banco_conta = ' . $parcela['id_banco_conta']);
                    $tbParcela = new Parcela();
                    $listagemParcelas = $tbParcela->findParcelasBoletos(null,null,null,null,null,null,$parcela['id_parcela_contrato']);
                    $parc = $listagemParcelas[0];
                    $msgBoleto = '';

                    foreach ($bancoColumns as $coluna) {
                        $parc[$coluna] = $bancoDados[$coluna];
                    }
                    
                    switch ($_SERVER['REQUEST_METHOD']) {

                        case 'GET' :
                            $acrescimo = $this->_helper->filters($_GET['acrescimo'], 'money');
                            $desconto = $this->_helper->filters($_GET['desconto'], 'money');
                            //$valorParcela = $this->_helper->filters($_GET['valor_atual'], 'money');
                            if(($_GET['vl_juros2Boleto']) || ($_GET['vl_multa2Boleto']) || ($_GET['desconto']) || ($_GET['acrescimo'])) {
                                $valorParcela = $this->_helper->filters($_GET['valor_atual'], 'money');
                            }else{
                                $valorParcela = $this->_helper->filters($_GET['vlTitulo'], 'money');
                            }
                            break;

                        case 'POST' :
                            $acrescimo = $this->_helper->filters($_POST['acrescimo'], 'money');
                            $desconto = $this->_helper->filters($_POST['desconto'], 'money');
                           // $valorParcela = $this->_helper->filters($_POST['valor_atual'], 'money');
                            if(($_POST['vl_juros2Boleto']) || ($_POST['vl_multa2Boleto']) || ($_POST['desconto']) || ($_POST['acrescimo'])) {
                                $valorParcela = $this->_helper->filters($_POST['valor_atual'], 'money'); 
                            }else{
                                $valorParcela = $this->_helper->filters($_POST['vlTitulo'], 'money');
                            }
                            break;
                    }

                    if ($parcela['cd_banco'] == '748' && $parc['cod_layout_api'] == null || $parcela['cd_banco'] == '741') {

                        $bancoConta = (new BancoConta())->fetchRow('id_banco_conta = '.$parcela['id_banco_conta']);
                        $nrBoletoIncremento = $bancoConta['nr_boleto'] + 1;
                        $bancoConta->nr_boleto = $nrBoletoIncremento;
                        $bancoConta->save();

                        if ($parcela['idBancoContrato'] != $parcela['id_banco_boleto']) {
                            $parcelaAtual = (new Parcela())->fetchRow('id_parcela_contrato = '.$parcela['id_parcela_contrato']);
                            $parcelaAtual->id_banco_boleto = null;
                            $parcelaAtual->ano_boleto_emissao = (int)date('y');
                            $parcelaAtual->save();
                        }

                        $msgBoleto = 'Emisso 2 via Multibanco - ' .Banco::buscaNomeBanco($parcela['cd_banco']). ' | ';
                    }
                    elseif ($fl_boleto->fl_boleto == '1' && $parcela['fl_envio'] == '1' && $parcela['dt_parcela_2avia'] != null) {

                        $bancos = (new Banco)->findBancoByIdBancoConta($parcela['id_banco_conta']);

                        $idsLivresParcela = (new Parcela)->buscaNrBoletosAvulsosParcela($parcela['id_banco_conta'], $bancos);
                        $idsLivresParcelaHistorico = (new ParcelaHistorico)->buscaNrBoletosAvulsosParcelaHistorico($parcela['id_banco_conta'], $bancos);
                        $idsLivresParcela2Via = (new Parcela2Via)->buscaNrBoletosAvulsosParcela2Via($parcela['id_banco_conta'], $bancos);

                        if ($idsLivresParcela == null && $idsLivresParcelaHistorico != null && $idsLivresParcela2Via == null) {
                            $idsLivres = $idsLivresParcelaHistorico;
                        } elseif ($idsLivresParcela != null && $idsLivresParcelaHistorico == null && $idsLivresParcela2Via == null) {
                            $idsLivres = $idsLivresParcela;
                        } elseif ($idsLivresParcela == null && $idsLivresParcelaHistorico == null && $idsLivresParcela2Via == null) {
                            $idsLivres = null;
                        } elseif ($idsLivresParcela == null && $idsLivresParcelaHistorico == null && $idsLivresParcela2Via != null) {
                            $idsLivres = $idsLivresParcela2Via;
                        } elseif ($idsLivresParcela != null && $idsLivresParcelaHistorico != null && $idsLivresParcela2Via == null) {
                            $idsLivres = array_intersect($idsLivresParcela, $idsLivresParcelaHistorico);
                        } elseif ($idsLivresParcela != null && $idsLivresParcelaHistorico == null && $idsLivresParcela2Via != null) {
                            $idsLivres = array_intersect($idsLivresParcela, $idsLivresParcela2Via);
                        } elseif ($idsLivresParcela == null && $idsLivresParcelaHistorico != null && $idsLivresParcela2Via != null) {
                            $idsLivres = array_intersect($idsLivresParcelaHistorico, $idsLivresParcela2Via);
                        } else {
                            $idsLivres = array_intersect($idsLivresParcela, $idsLivresParcelaHistorico, $idsLivresParcela2Via);
                        }
                        
                        $bancoConta = (new BancoConta())->fetchRow('id_banco_conta = ' . $parcela['id_banco_conta']);
                        
                        if ($idsLivres) {
                            
                            if (isset($idsLivres[array_keys($idsLivres)[0]])) {
                                $parcela['nr_boleto'] = $idsLivres[array_keys($idsLivres)[0]];
                                unset($idsLivres[array_keys($idsLivres)[0]]);
                            } elseif (isset($idsLivres)) {
                                $parcela['nr_boleto'] = $idsLivres;
                            }
                        } else {
                            
                            $maxNrBoleto = (new Parcela)->getMaxNrBoletoParcelaEparcelaHistorico($bancos);
                            $nrBoletoIncremento = (int)$maxNrBoleto + 1;
                            
                            if (!$maxNrBoleto) {
                                $nrBoletoIncremento = (int)$bancoConta['nr_boleto'] + 1;
                            }

                            $parcela['nr_boleto'] = $nrBoletoIncremento;
                        }

                        $bancoConta->nr_boleto = $parcela['nr_boleto'];
                        $bancoConta->save();

                        $msgBoleto = 'Emisso 2 via Multibanco - ' .Banco::buscaNomeBanco($parcela['cd_banco']). ' | ';
                    }
                    elseif($fl_boleto->fl_boleto=='2' && $parcela['idBancoContrato']){
                        
                        $proximoNr = new Parcela();

                        $bancoConta = (new BancoConta())->fetchRow('id_banco_conta = '.$parcela['id_banco_conta']);
                        if( $bancoConta['nr_boleto']!="0000000000"){
                            $nrBoletoIncremento = $bancoConta['nr_boleto'] + 1;

                            $bancoConta->nr_boleto = $nrBoletoIncremento;
                            $bancoConta->save();
    
                            $parcela['nr_boleto'] = $nrBoletoIncremento;
                        }
                        else{
                            $proximoNr = new Parcela();
                            $nrBoletoIncremento = $proximoNr->proximoNrBoletoBanco($parcela['id_banco']);
                            $bancoConta->nr_boleto = $nrBoletoIncremento;
                            $bancoConta->save();
                            $parcela['nr_boleto'] = $nrBoletoIncremento;
                        }

                        $msgBoleto = 'Emisso 2 via Multibanco - ' .Banco::buscaNomeBanco($parcela['cd_banco']). ' | ';
                    }
                    
                    if ($fl_boleto->cod_layout_api == null) {
                        /**
                         * condio criada para caso o cliente gere um boleto para um banco digital,
                         * e depois gere o mesmo boleto s que dessa vez para um banco que no seja digital,
                         * o sistema reseta os campos referentes a API, para que na hora de ler o cdigo
                         * de barras no aparea os dados do banco digital
                         */
                        $parcela['cod_barras'] = null;
                        $parcela['linha_digitavel'] = null;
                        $parcela['cod_boleto_api'] = null;
                    }

                    /**
                     * Variveis que faz a atualizaoo da data original para a mesma data da 2Via.
                     **/
                    $contrato = $_POST['contrato_emp'];
                    $tpParcela = $parcela['tp_parcela'];
                    $idParcela = $parcela['id_parcela'];
                    //Seta a remessa como null para reemisso
                    $newParcela = $this->parcela->createRow();
                    $newParcela->id_parcela = $parcela['id_parcela'];
                    $newParcela->id_contrato = $parcela['id_contrato'];
                    // $newParcela->id_banco = $parcela['idBancoContrato'];
                    $newParcela->id_banco = null;
                    $newParcela->id_banco_boleto = $parcela['id_banco_conta'];
                    $newParcela->acrescimo = $acrescimo;
                    $newParcela->desconto = $desconto;
                    $newParcela->vl_parcela = $parcela['vl_parcela'];
                    //altera o valor da parcela acrescentando os juros
                    $newParcela->vl_parcela_2avia = $valorParcela;
                    $newParcela->dt_parcela = $parcela['dt_parcela'];
                    $newParcela->dt_parcela_2avia = $dataVencimento;
                    $newParcela->id_remessa = null;
                    $newParcela->tp_parcela = $parcela['tp_parcela'];
                    $newParcela->fl_reajustavel = $parcela['fl_reajustavel'];
                    $newParcela->pago = $parcela['pago'];
                    $newParcela->id_negociacao = $parcela['id_negociacao'];
                    $newParcela->id_renegociacao = $parcela['id_renegociacao'];
                    $newParcela->id_parcela_contrato_antigo = null;
                    $newParcela->fl_quitado = $parcela['fl_quitado'];
                    $newParcela->fl_envio = 1;
                    $newParcela->fl_reajustavel = $parcela['fl_reajustavel'];
                    $newParcela->obs = $parcela['obs'];
                    $newParcela->nr_boleto = $parcela['nr_boleto'];
                    $newParcela->ano_boleto_emissao = (int)date('y');
                    if($parc['cd_banco'] == '274') {
                        $newParcela->nr_boleto = substr($parcela['nr_boleto'], -10);
                        $newParcela->nosso_numero = $parcela['nr_boleto'];
                    }
                    $newParcela->cod_barras = $parcela['cod_barras'];
                    $newParcela->linha_digitavel = $parcela['linha_digitavel'];
                    $newParcela->qrCode = $parcela['qrCode'];
                    $newParcela->txid = $parcela['txid'];
                    $newParcela->cod_boleto_api = $parcela['cod_boleto_api'];
                    if ($fl_boleto->fl_boleto == '0') {
                        $newParcela->nr_boleto = null;
                    }

                    $newParcela->nr_tipo_parcela = $parcela['nr_tipo_parcela'];                                         
                    if ($parcela['cd_banco'] == '748' || $parcela['cd_banco'] == '741') {
                        $newParcela->nr_boleto = $nrBoletoIncremento;
                    }

                    //Guarda os dados na tabela de parcela 2a via
                    $parcelaBackup = $this->parcela2Via->createRow();
                    $parcelaBackup->id_parcela_contrato = $parcela['id_parcela_contrato'];
                    $parcelaBackup->id_parcela = $parcela['id_parcela'];
                    $parcelaBackup->id_contrato = $parcela['id_contrato'];
                    $parcelaBackup->id_banco = $parcela['id_banco'];
                    $parcelaBackup->id_banco_boleto = $parcela['id_banco_boleto'];
                    $parcelaBackup->acrescimo = $this->_helper->filters($parcela['acrescimo'],'money');
                    $parcelaBackup->desconto = $this->_helper->filters($parcela['desconto'],'money');
                    $parcelaBackup->desconto_2via = $this->_helper->filters($parcela['desconto_2via'],'money');
                    $parcelaBackup->vl_parcela = $parcela['vl_parcela'];
                    $parcelaBackup->vl_parcela_2avia = $parcela['vl_parcela_2avia'];
                    $parcelaBackup->dt_parcela = $parcela['dt_parcela'];
                    $parcelaBackup->dt_parcela_2avia = $parcela['dt_parcela_2avia'];
                    $parcelaBackup->dt_reajuste = $parcela['dt_reajuste'];
                    $parcelaBackup->vl_indice = $parcela['vl_indice'];
                    $parcelaBackup->id_remessa = $parcela['id_remessa'];
                    $parcelaBackup->tp_parcela = $parcela['tp_parcela'];
                    $parcelaBackup->fl_reajustavel = $parcela['fl_reajustavel'];
                    $parcelaBackup->pago = $parcela['pago'];
                    $parcelaBackup->tp_baixa = $parcela['tp_baixa'];
                    $parcelaBackup->fm_baixa = $parcela['fm_baixa'];
                    $parcelaBackup->id_negociacao = $parcela['id_negociacao'];
                    $parcelaBackup->id_renegociacao = $parcela['id_renegociacao'];
                    $parcelaBackup->id_parcela_contrato_antigo = $parcela['id_parcela_contrato_antigo'];
                    $parcelaBackup->fl_quitado = $parcela['fl_quitado'];
                    $parcelaBackup->fl_envio = $parcela['fl_envio'];
                    $parcelaBackup->fl_reajustavel = $parcela['fl_reajustavel'];
                    $parcelaBackup->obs = $parcela['obs'];
                    $parcelaBackup->obs_parcela = $parcela['obs_parcela'];
                    $parcelaBackup->nr_boleto = $ultimoNr;
                    $parcelaBackup->ano_boleto_emissao = $parcela['ano_boleto_emissao'];
                    if ($parcela['cd_banco'] == '748'|| $parcela['cd_banco'] == '741') {
                        $parcelaBackup->nr_boleto = $parcela['nr_boleto'];
                    }
                    if($parc['cd_banco'] == '274') {
                        $parcelaBackup->nr_boleto = substr($parcela['nr_boleto'], -10);
                        $parcelaBackup->nosso_numero = $parcela['nosso_numero'];
                    }
                    
                    $parcelaBackup->nr_tipo_parcela = $parcela['nr_tipo_parcela'];
                    $parcelaBackup->cod_barras = $ultimoCodigoBarra;
                    $parcelaBackup->linha_digitavel = $ultimoLinhadigitavel;
                    $parcelaBackup->cod_layout_api = $parcela['cod_layout_api'];
                    $parcelaBackup->txid = $parcela['txid'];
                    $parcelaBackup->qrCode = $parcela['qrCode'];
                    $parcelaBackup->cod_boleto_api = $parcela['cod_boleto_api'];
                    
                    //Apaga a parcela anterior
                    $this->parcela->delete('id_parcela_contrato = '.$parcela['id_parcela_contrato']);

                    if($_POST['dataOriginal'] == 'S'){
                        $newParcela->dt_parcela = Helper::dataParaAmericano($_POST['dataVencimento']);
                    }
                    $novo_id_parcela = $newParcela->save();
                    if($parc['cd_banco'] == '077'){//inter
                        $arrayInter = array(
                            "seuNumero" => $novo_id_parcela,
                            "valorNominal" => $valorParcela + $acrescimo - $desconto,
                            "valorAbatimento" => $desconto,
                            "dataVencimento" => $dataVencimento,
                            "numDiasAgenda" => $parc['nr_dias_permanencia'],
                            "atualizarPagador" => false,
                            "pagador" => array(
                                "cpfCnpj" => $parc['nr_cnpj']?preg_replace("/[^0-9]/", "", $parc['nr_cnpj']): preg_replace("/[^0-9]/", "", $parc['nr_cpf']),
                                "tipoPessoa" => $parc['nr_cnpj']?"JURIDICA":"FISICA",
                                "nome" => utf8_encode($parc['nm_pessoa']),
                                "endereco" => utf8_encode($parc['cliEndereco']),
                                "cidade" => utf8_encode($parc['cliCidade']),
                                "uf" => $parc['cliUf'],
                                "cep" => preg_replace("/[^0-9]/", "", $parc['cliCep']),
                                "email" => $parc['email'],
                                "ddd" => substr(preg_replace("/[^0-9]/", "", $parc['nr_celular']),0,2),
                                "telefone" => substr(preg_replace("/[^0-9]/", "", $parc['nr_celular']),2,9),
                                "numero" => utf8_encode($parc['cliNrEndereco']),
                                "complemento" => utf8_encode($parc['cliComplemento']),
                                "bairro" => utf8_encode($parc['cliBairro']),
                            ),
                            "mensagem" => array(
                                "linha1" => utf8_encode($parc['msg_boleto']),
                                "linha2" => utf8_encode($parc['msg_adicional'])
                            ),
                            "beneficiarioFinal"=>array(
                                "cpfCnpj" => $parc['cnpj_cedente']?preg_replace("/[^0-9]/", "", $parc['cnpj_cedente']): preg_replace("/[^0-9]/", "", $parc['cpf_cedente']),
                                "tipoPessoa" => $parc['cnpj_cedente']?"JURIDICA":"FISICA",
                                "cpfCnpj" => preg_replace("/[^0-9]/", "", $parc['cnpj_cedente']),
                                "tipoPessoa" => "JURIDICA",
                                "nome" => utf8_encode($parc['nm_cedente']),
                                "endereco" => utf8_encode($parc['cedEndereco']),
                                "cidade" => utf8_encode($parc['cedCidade']),
                                "uf" => $parc['cedUf'],
                                "cep" => preg_replace("/[^0-9]/", "", $parc['cedCep']),
                                "email" => $parc['cedEmail'],
                                "ddd" => substr(preg_replace("/[^0-9]/", "", $parc['cedTelefone']),0,2),
                                "telefone" => substr(preg_replace("/[^0-9]/", "", $parc['cedTelefone']),2,9),
                                "numero" => utf8_encode($parc['cedNrEndereco']),
                                "complemento" => utf8_encode($parc['cedComplemento']),
                                "bairro" => utf8_encode($parc['cedBairro']),
                            )
                        );

                        /*if($desconto && floatval($desconto)){

                            $arrayInter["desconto1"] = array(
                                "codigoDesconto" => "VALORFIXODATAINFORMADA",
                                "taxa" => 0,
                                "valor" => $desconto,
                                "data" => $dataVencimento
                            );
                        }*/
                        if($parc['multa']&& floatval($parc['multa'])){

                            $arrayInter["multa"] = array(
                                "codigoMulta" => "PERCENTUAL",
                                "taxa" => $parc['multa'],
                                "valor" => 0,
                                "data" => date('Y-m-d', strtotime($dataVencimento . ' +1 day'))
                            );
                        }
                        $jurosFormatado = number_format($valorParcela*($parc['juros']/100), 2, '.', '');
                        if($parc['juros']&&($jurosFormatado!="0.00")){

                            $arrayInter["mora"] = array(
                                "codigoMora" => "VALORDIA",
                                "taxa" => 0,
                                "valor" =>  $jurosFormatado,
                                "data" => date('Y-m-d', strtotime($dataVencimento . ' +1 day'))
                            );
                        }
                        else{
                            $arrayInter["mora"] = array(
                                "codigoMora" => "ISENTO",
                                "taxa" => 0,
                                "valor" => 0
                            );
                        }

                        $path = explode('.', $_SERVER['HTTP_HOST']);
                        if ($path[0] == 'www') {
                            $path = $path[1];
                        } else {
                            $path = $path[0];
                        }
                        $ch = curl_init();

                        curl_setopt($ch, CURLOPT_URL,"https://cdpj.partners.bancointer.com.br/oauth/v2/token");
                        curl_setopt($ch, CURLOPT_POST, 1);
                        curl_setopt($ch, CURLOPT_SSLCERT, "upload/cliente/".$path."/certificado/certificado".$parc['cod_layout_api'].".crt");
                        curl_setopt($ch, CURLOPT_SSLKEY, "upload/cliente/".$path."/certificado/certificado".$parc['cod_layout_api'].".key");
                        curl_setopt($ch, CURLOPT_POSTFIELDS,
                            http_build_query(array('client_id' => $parc['pp_token'],
                                'client_secret' => $parc['password'],
                                'scope' => 'boleto-cobranca.read boleto-cobranca.write',
                                'grant_type' => 'client_credentials')));
                        curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/x-www-form-urlencoded'));

                        // Receive server response ...
                        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

                        $server_response = curl_exec($ch);
                        $error = curl_error($ch);
                        $errno = curl_errno($ch);

                        curl_close ($ch);

                        if ($error !== '') {
                            throw new Exception($error);
                            die;
                        }

                        if ($server_response == '') {
                            throw new Exception("Resposta vazia, provavelmente o limite de chamadas foi atingido...\n");
                            die;
                        }

                        $obj = json_decode($server_response);

                        $bearerToken=$obj->{'access_token'};

                        $auth='Authorization: Bearer ' . $bearerToken;
                        $cc='x-conta-corrente: '.$parc['conta_corrente'].$parc['conta_corrente_dv'];
                        $json='Content-Type: application/json';
                        $data = json_encode($arrayInter);
                        $ch = curl_init();
                        curl_setopt($ch, CURLOPT_URL, "https://cdpj.partners.bancointer.com.br/cobranca/v2/boletos");
                        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
                        curl_setopt($ch, CURLOPT_SSLVERSION, CURL_SSLVERSION_TLSv1_2);
                        curl_setopt($ch, CURLOPT_HTTPHEADER, array($auth,$cc,$json));
                        curl_setopt($ch, CURLOPT_SSLCERT, "upload/cliente/".$path."/certificado/certificado".$parc['cod_layout_api'].".crt");
                        curl_setopt($ch, CURLOPT_SSLKEY, "upload/cliente/".$path."/certificado/certificado".$parc['cod_layout_api'].".key");
                        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
                        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

                        $result = curl_exec($ch);
                        $error = curl_error($ch);
                        $errno = curl_errno($ch);
                        curl_close ($ch);

                        if ($error !== '') {
                            throw new Exception($error);
                            die;
                        }
                        $objResultado = json_decode($result);
                        if($objResultado->nossoNumero){
                            $parcela['nr_boleto'] = substr($objResultado->nossoNumero, -10);
                            $parcela['cod_barras'] = $objResultado->codigoBarras;
                            $parcela['linha_digitavel'] = $objResultado->linhaDigitavel;  
                            
                            $newParcela->nr_boleto = substr($objResultado->nossoNumero, -10);
                            $newParcela->cod_barras = $objResultado->codigoBarras;
                            $newParcela->linha_digitavel = $objResultado->linhaDigitavel;  
                        }
                        else{
                            print $result;die;
                        }

                        $msgBoleto = 'Emisso 2 via Multibanco - Banco Inter API | ';
                    }
                    elseif($parc['cd_banco'] == '133'){//cresol
                        if(!$_GET['tokenCresol']){
                            $nmDominio = "";
                            $url = explode('.', $_SERVER['HTTP_HOST']);
                            if ($url[0] == 'www') {
                                $nmDominio = $url[1];
                            } else {
                                $nmDominio = $url[0];
                            }
                            $urlRedirecionamento = "https://".$nmDominio.".acadeone.com.br/acadelotear/?m=sc&c=layout&a=tokenCresol&controller=boleto2aVia&".http_build_query($_POST);
                        
                            $url = "https://cresolauth.governarti.com.br/auth/realms/cresol/protocol/openid-connect/auth?response_type=token&client_id=cresolApi&redirect_uri=".urlencode($urlRedirecionamento );
                        
                            header("Location: ".$url);
                            die();
                        }
                        $arrayCresol = array(
                            "valorNominal" => $valorParcela + $acrescimo - $desconto,
                            "idEspecie" =>2,
                            "numeroDocumento"=>$novo_id_parcela,
                            "dtVencimento" => $dataVencimento,
                            "dtDocumento" => gmdate('Y-m-d'),
                            "docPagador" => $parc['nr_cnpj']?preg_replace("/[^0-9]/", "", $parc['nr_cnpj']): preg_replace("/[^0-9]/", "", $parc['nr_cpf']),
                            "tipoPagador" => $parc['nr_cnpj']?"1":"0",
                            "pagadorNome" => utf8_encode($parc['nm_pessoa']),
                            "pagadorEndereco" => utf8_encode($parc['cliEndereco']),
                            "pagadorCidade" => utf8_encode($parc['cliCidade']),
                            "pagadorUf" => $parc['cliUf'],
                            "pagadorCep" => preg_replace("/[^0-9]/", "", $parc['cliCep']),
                            "pagadorEnderecoNumero" => utf8_encode($parc['cliNrEndereco']),
                            "pagadorBairro" => utf8_encode($parc['cliBairro']),
                                
                        );
                        /*if($desconto){

                            $arrayCresol["valorDesconto"] =  $desconto;

                            $arrayCresol["dtLimiteDesconto"] = $dataVencimento;
                        }*/
                        if($parc['multa']){
                            $arrayCresol["cdTipoMulta"] = "VALOR_PERCENTUAL";
                            $arrayCresol["valorMulta"] = $parc['multa'];
                        }
                        else{
                            $arrayCresol["cdTipoMulta"] = "ISENTO";
                        }
                        $jurosFormatado = number_format($valorParcela*($parc['juros']/100), 2, '.', '');
                        if($parc['juros']&&($jurosFormatado!="0.00")){

                            $arrayCresol["cdTipoJuros"] = "VALOR_FIXO";
                            $arrayCresol["valorJuros"] =  $jurosFormatado;
                        }
                        else{
                            $arrayCresol["cdTipoJuros"] =  "ISENTO";
                        }

                        $path = explode('.', $_SERVER['HTTP_HOST']);
                        if ($path[0] == 'www') {
                            $path = $path[1];
                        } else {
                            $path = $path[0];
                        }
                        $ch = curl_init();

                        $bearerToken=$_GET['tokenCresol'];

                        $auth='Authorization: Bearer ' . $bearerToken;
                        $json='Content-Type: application/json';
                        $data = json_encode([$arrayCresol]);


                        $curl = curl_init();
                        
                        curl_setopt_array($curl, array(
                            CURLOPT_URL => 'https://cresolapi.governarti.com.br/titulos',
                            CURLOPT_RETURNTRANSFER => true,
                            CURLOPT_ENCODING => '',
                            CURLOPT_MAXREDIRS => 10,
                            CURLOPT_TIMEOUT => 0,
                            CURLOPT_FOLLOWLOCATION => true,
                            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                            CURLOPT_CUSTOMREQUEST => 'POST',
                            CURLOPT_POSTFIELDS =>$data,
                            CURLOPT_HTTPHEADER => array(
                            'Content-Type: application/json',
                            'Authorization: Bearer '. $bearerToken
                            ),
                        ));
                                                
                        $result = curl_exec($curl);
                        $error = curl_error($curl);
                        $errno = curl_errno($curl);

                        curl_close($curl);
                        

                        if ($error !== '') {
                            throw new Exception($error);
                            die;
                        }
                        $objResultado = json_decode($result);
                        if(isset($objResultado[0]) && $objResultado[0]->nossoNumero){
                            $parcela['nr_boleto'] = $objResultado[0]->nossoNumero;
                            $parcela['cod_barras'] = $objResultado[0]->codigoBarras;
                            $parcela['linha_digitavel'] = $objResultado[0]->linhaDigitavel;  
                            
                            $newParcela->nr_boleto = $objResultado[0]->nossoNumero;
                            $newParcela->cod_barras = $objResultado[0]->codigoBarras;
                            $newParcela->linha_digitavel = $objResultado[0]->linhaDigitavel; 
                        }
                        else{
                            print $result;die;
                        }

                        $msgBoleto = 'Emisso 2 via Multibanco - Banco Cresol API | ';
                    }
                    elseif($parc['cd_banco'] == '136' && $parc['cod_layout_api']){ //Banco Unicred
                        $curl = curl_init();

                        curl_setopt_array($curl, array(
                        CURLOPT_URL => 'https://api.e-unicred.com.br/oauth2/v2/grant-token',
                        CURLOPT_RETURNTRANSFER => true,
                        CURLOPT_ENCODING => '',
                        CURLOPT_MAXREDIRS => 10,
                        CURLOPT_TIMEOUT => 0,
                        CURLOPT_FOLLOWLOCATION => true,
                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                        CURLOPT_POSTFIELDS =>json_encode(array("nomeUsuario"=> $parc['pp_token'], "senha"=>$parc['password'])),
                        CURLOPT_HTTPHEADER => array(
                            'apiKey: '.$parc['gerar_token'],
                            'Content-Type: application/json'
                        ),
                        ));

                        $response = curl_exec($curl);

                        curl_close($curl);
                        $autenticacao = json_decode($response);
                        if(!$autenticacao->accessToken){
                            echo "falha na autenticao ".$response;
                            die;
                        }

                        $bearerToken=$autenticacao->accessToken;

                        $arrayUnicred = array(
                            "beneficiarioVariacaoCarteira"=>$parc['nr_carteira'],
                            "seuNumero" => $novo_id_parcela,
                            "valor" => $valorParcela + $acrescimo - $desconto,
                            "codigoBeneficiario" => $parc['cd_cedente'],
                            "vencimento" => $parc['dt_parcela'], 
                            "indicacaoTituloDescontavel" => false,
                            "enviaBoletoEmail" => false,
                            "pagador" => array(
                                "nomeRazaoSocial" => utf8_encode(substr($parc['nm_pessoa'],0,40)),
                                "tipoPessoa" => $parc['nr_cnpj']?"J":"F",
                                "tipoDocumento"=> $parc['nr_cnpj']?"CNPJ":"CPF",
                                "numeroDocumento" => $parc['nr_cnpj']?preg_replace("/[^0-9]/", "", $parc['nr_cnpj']): preg_replace("/[^0-9]/", "", $parc['nr_cpf']),
                                "nomeFantasia"=> utf8_encode(substr($parc['nm_pessoa'],0,40)),
                                "endereco"=>array(
                                    "cep" => preg_replace("/[^0-9]/", "", $parc['cliCep']),
                                    "cidade" => $parc['cliCidade'],
                                    "logradouro" => utf8_encode($parc['cliEndereco']),
                                    "uf" => $parc['cliUf'],
                                )
                            ),
                            "mensagensFichaCompensacao" => array(
                                utf8_encode($parc['msg_boleto']),
                                utf8_encode($parc['msg_adicional'])
                            ),
                        );
                        
                        /*if($parcela['desconto']){
                            $arrayUnicred["desconto"] = array(
                                "indicador" => "1",
                                "valor" => $parc['desconto'],
                                "dataLimite" => $parc['dt_parcela']
                            );
                        }*/

                        $jurosFormatadoMulta = number_format($parc['vl_parcela'], 2, '.', '');
                        if($parc['multa']){
                            $arrayUnicred['multa']["codigo"] = "2"; 
                            $arrayUnicred['multa']["valor"] = $parc['multa']; 
                            $arrayUnicred['multa']["dataInicio"] = date('Y-m-d', strtotime($parc['dt_parcela'] . ' +1 day'));
                        }
        
                        if($parcela['juros']){
                            $arrayUnicred['juros']["codigo"] = "2"; 
                            $arrayUnicred['juros']["valor"] = $parc['juros']; 
                            $arrayUnicred['juros']["dataInicio"] = date('Y-m-d', strtotime($parc['dt_parcela'] . ' +1 day'));
                        }

                        $path = explode('.', $_SERVER['HTTP_HOST']);
                        if ($path[0] == 'www') {
                            $path = $path[1];
                        } else {
                            $path = $path[0];
                        }

                        $curl = curl_init();

                        curl_setopt_array($curl, array(
                        CURLOPT_URL => 'https://api.e-unicred.com.br/cobranca/v2/beneficiarios/'.$parc['req_cliente_id'].'/titulos',
                        CURLOPT_RETURNTRANSFER => true,
                        CURLOPT_ENCODING => '',
                        CURLOPT_MAXREDIRS => 10,
                        CURLOPT_TIMEOUT => 0,
                        CURLOPT_FOLLOWLOCATION => true,
                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                        CURLOPT_CUSTOMREQUEST => 'POST',
                        CURLOPT_POSTFIELDS =>json_encode($arrayUnicred),
                        CURLOPT_HTTPHEADER => array(
                            'apiKey: '.$parc['gerar_token'],
                            'cooperativa: '.$parc['nr_cooperativa'],
                            'Content-Type: application/json',
                            'Authorization: Bearer '.$bearerToken,
                        ),
                        ));

                        $response = curl_exec($curl);
                        curl_close($curl);
                        $resposta = json_decode($response);
                        if($resposta->message){
                            echo ($response);
                            die;
                        }
                        else{
                            $id_boleto = $response;
                            for($load = 0;$load<10;$load++){

                                sleep(6);
                                $curl = curl_init();

                                curl_setopt_array($curl, array(
                                CURLOPT_URL => 'https://api.e-unicred.com.br/cobranca/v2/beneficiarios/'.$parc['req_cliente_id'].'/titulos/'.$id_boleto.'/status',
                                CURLOPT_RETURNTRANSFER => true,
                                CURLOPT_ENCODING => '',
                                CURLOPT_MAXREDIRS => 10,
                                CURLOPT_TIMEOUT => 0,
                                CURLOPT_FOLLOWLOCATION => true,
                                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                                CURLOPT_CUSTOMREQUEST => 'GET',
                                CURLOPT_HTTPHEADER => array(
                                    'apiKey: '.$parc['gerar_token'],
                                    'cooperativa: '.$parc['nr_cooperativa'],
                                    'Authorization: Bearer '.$bearerToken,
                                ),
                                ));

                                $response = curl_exec($curl);
                                curl_close($curl);
                                $objResultado = json_decode($response);
                                if($objResultado->nossoNumero){
                                    $parcela['nr_boleto'] = $objResultado->nossoNumero;
                                    $parcela['cod_barras'] = $objResultado->codBarras;
                                    $parcela['linha_digitavel'] = $objResultado->linhaDigitavel; 
                                    $parcela['qrCode'] = $objResultado->qrCodePix;
                                    $parcela['cod_boleto_api'] = $id_boleto;

                                    $newParcela->nr_boleto = $objResultado->nossoNumero;
                                    $newParcela->cod_barras = $objResultado->codBarras;
                                    $newParcela->linha_digitavel = $objResultado->linhaDigitavel; 
                                    $newParcela->qrCode = $objResultado->qrCodePix;
                                    $newParcela->cod_boleto_api = $id_boleto;
                                    break;
                                }
                            }
                        }

                        $msgBoleto = 'Emisso 2 via Multibanco - Banco Unicredi API | ';
                    }
                    elseif($parc['cd_banco'] == '748' && $parc['cod_layout_api']){ //Banco Sicredi
                        $arraySicredi = array(
                            "codigoBeneficiario" => $parc['cd_cedente'],
                            "dataVencimento" => $dataVencimento, 
                            "especieDocumento" => "DUPLICATA_MERCANTIL_INDICACAO",
                            "pagador" => array(
                            "cep" => preg_replace("/[^0-9]/", "", $parc['cliCep']),
                            "cidade" => $parc['cliCidade'],
                            "documento" => $parc['nr_cnpj']?preg_replace("/[^0-9]/", "", $parc['nr_cnpj']): preg_replace("/[^0-9]/", "", $parc['nr_cpf']),
                            "nome" => $parc['nm_pessoa'],
                            "tipoPessoa" => $parc['nr_cnpj']?"PESSOA_JURIDICA":"PESSOA_FISICA",
                            "endereco" => utf8_encode($parc['cliEndereco']),
                            "uf" => $parc['cliUf'],
                            ),
                            "tipoCobranca" => "HIBRIDO",
                            "seuNumero" => $novo_id_parcela,
                            "valor" => $valorParcela + $acrescimo - $desconto,
                            "mensagem" => array(
                                "mens 1" => utf8_encode($parc['msg_boleto']),
                                "mens 2" => utf8_encode($parc['msg_adicional'])
                            ),
                        );
                        
                        /*if($desconto){
                            $arraySicredi["desconto1"] = array(
                                "tipoDesconto" => "VALOR",
                                "taxa" => 0,
                                "valor" => $desconto,
                                "data" => $dataVencimento
                            );
                        }*/

                        $jurosFormatadoMulta = number_format($parc['multa'], 2, '.', '');
                        $jurosFormatado = number_format($valorParcela*$parc['juros'], 2, '.', '');

                        if($parc['multa']&& ($jurosFormatado!="0.00")){
                            $arraySicredi["multa"] = $jurosFormatadoMulta;
                        }
                        if($parc['juros']&&($jurosFormatado!="0.00")){
                            if($parc['tp_multa']=="P"){
                                $arraySicredi["tipoJuros"] = "PERCENTUAL";
                                $arraySicredi["juros"] =number_format($parc['juros'], 2, '.', '');;

                            }
                            else if($parc['tp_multa']=="V"){
                                $arraySicredi["tipoJuros"] = "VALOR";
                                $arraySicredi["juros"] = $jurosFormatado;

                            }

                        }
                        $path = explode('.', $_SERVER['HTTP_HOST']);
                        if ($path[0] == 'www') {
                            $path = $path[1];
                        } else {
                            $path = $path[0];
                        }

                        $curl = curl_init();

                        curl_setopt_array($curl, array(
                        CURLOPT_URL => 'https://api-parceiro.sicredi.com.br/auth/openapi/token',
                        CURLOPT_RETURNTRANSFER => true,
                        CURLOPT_ENCODING => '',
                        CURLOPT_MAXREDIRS => 10,
                        CURLOPT_TIMEOUT => 0,
                        CURLOPT_FOLLOWLOCATION => true,
                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                        CURLOPT_CUSTOMREQUEST => 'POST',
                        CURLOPT_POSTFIELDS => http_build_query(array('username' => $parc['pp_token'],
                        'password' => $parc['password'],
                        'scope' => 'cobranca',
                        'grant_type' => 'password')),
                        CURLOPT_HTTPHEADER => array(
                            'x-api-key: '.$parc['gerar_token'],
                            'context: COBRANCA',
                            'Content-Type: application/x-www-form-urlencoded',
                        ),
                        ));
                        
                        $server_response = curl_exec($curl);

                        $result = curl_exec($curl);
                        $error = curl_error($curl);
                        curl_close($curl);

                        if ($error !== '') {
                            throw new Exception($error);
                            die;
                        }
                        
                        $obj = json_decode($server_response);
                        
                        if(!isset($obj->{'access_token'})){
                            echo "Autenticao:<br>";
                            echo $server_response; die;
                        }
                        $token = $obj->{'access_token'};
                        $auth='Authorization: Bearer ' . $token;
                        $curl = curl_init();
                        $data = json_encode($arraySicredi);

                        curl_setopt_array($curl, array(
                        CURLOPT_URL => 'https://api-parceiro.sicredi.com.br/cobranca/boleto/v1/boletos',
                        CURLOPT_RETURNTRANSFER => true,
                        CURLOPT_ENCODING => '',
                        CURLOPT_MAXREDIRS => 10,
                        CURLOPT_TIMEOUT => 0,
                        CURLOPT_FOLLOWLOCATION => true,
                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                        CURLOPT_CUSTOMREQUEST => 'POST',
                        CURLOPT_POSTFIELDS => $data,
                        CURLOPT_HTTPHEADER => array(
                            'x-api-key: ' . $parc['gerar_token'],
                            'cooperativa: ' . $parc['agencia'],
                            'posto: ' . $parc['carteira_variacao'],
                            'codigoBeneficiario: ' . $parc['cd_cedente'],
                            'Content-Type: application/json',
                            $auth
                        ),
                        ));

                        $response = curl_exec($curl);
                        curl_close($curl);
                        
                        if ($error !== '') {
                            throw new Exception($error);
                            die;
                        }

                        $objResultado = json_decode($response);
                        
                        if(!isset($objResultado->nossoNumero)){
                            echo "Emisso:<br>";
                            echo $response; die;
                        }
                        if($objResultado->nossoNumero){
                            $parcela['nr_boleto'] = $objResultado->nossoNumero;
                            $parcela['cod_barras'] = $objResultado->codigoBarras;
                            $parcela['linha_digitavel'] = $objResultado->linhaDigitavel; 
                            $parcela['id_banco_boleto'] = $parc['id_banco_conta'];
                            $parcela['qrCode'] = $objResultado->qrCode;
                            $parcela['txid'] = $objResultado->txid;
                            
                            
                            $newParcela->nr_boleto = $objResultado->nossoNumero;
                            $newParcela->cod_barras = $objResultado->codigoBarras;
                            $newParcela->linha_digitavel = $objResultado->linhaDigitavel; 
                            
                            $newParcela->id_banco_boleto = $parc['id_banco_conta'];
                            $newParcela->qrCode =$objResultado->qrCode;
                            $newParcela->txid = $objResultado->txid;
                        }

                        $msgBoleto = 'Emisso 2 via Multibanco - Banco Sicredi API | ';
                    }
                    
                    elseif($parc['cd_banco'] == '274') {
                        
                        if(!$parc['pp_token']) {
                            
                            $codLayout = (new BancoConta())->select()
                                ->from(['bc' => TB_BANCO_CONTA], 'bc.cod_layout_api')
                                ->where('bc.id_banco_conta = ' . $bancoDados['id_banco_conta'])
                                ->query()->fetch();

                            $token = (new Layout())->select()->from(['l' => TB_LAYOUT], 'pp_token')->where('l.id = ' . $codLayout['cod_layout_api'])->query()->fetch();
                            $parc['pp_token'] = $token['pp_token'];
                        }

                        $boleto = ['paymentMethod' => 'boleto'];

                        $boleto['boletoDetails'] = ['yourNumber' => $novo_id_parcela];
    
                        /*if ($parc['desconto']) {
    
                            $boleto['discount'] = [
                                    'range' => $parc['dt_parcela'],
                                    'discountType' => 'fixed',
                                    'discountValue' => $parc['desconto']
                            ];
                        }*/
    
                        $boleto['payer'] = [
                                'address' => [
                                    'street' => utf8_encode($parc['cliEndereco']),
                                    'neighborhood' => utf8_encode($parc['cliBairro']),
                                    'number' => $parc['cliNrEndereco'],
                                    'state' => utf8_encode($parc['cliUf']),
                                    'city' => utf8_encode($parc['cliCidade']),
                                    'zipCode' => $parc['cliCep'],
                                    'complement' => utf8_encode($parc['cliComplemento']),
                                    'country' => 'Brasil'
                                ],
                                'phone' => [
                                    'number' => $parc['nr_celular']
                                ],
                                'name' => utf8_encode($parc['nm_pessoa']),
                                'documentNumber' => $parc['nr_cpf'] ? $parc['nr_cpf'] : $parc['nr_cnpj'],
                                'email' => $parc['email']
                        ];
    
                        $boleto += ['dueDate' => Helper::dataParaAmericano($_POST['dataVencimento']),
                                    'value' => Helper::getInputMoney($_POST['valor_atual']) + Helper::getInputMoney($_POST['acrescimo']) - Helper::getInputMoney($_POST['desconto']),
                                    'interestType' => 'percentage',
                                    'interestValue' => $parc['jurosMensal'],
                                    'applicableFine' => $parc['multa'],
                                    'clientControlNumber' => $novo_id_parcela
                                ];

                        $boleto['charge'] = ['value' => Helper::getInputMoney($_POST['valor_atual']) + Helper::getInputMoney($_POST['acrescimo']) - Helper::getInputMoney($_POST['desconto'])];
                        
                        $curl = curl_init();
    
                        curl_setopt_array($curl, [
                        CURLOPT_URL => "https://pagamentos.grafeno.digital/api/v2/charges",
                        CURLOPT_RETURNTRANSFER => true,
                        CURLOPT_ENCODING => "",
                        CURLOPT_MAXREDIRS => 10,
                        CURLOPT_TIMEOUT => 30,
                        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                        CURLOPT_CUSTOMREQUEST => "POST",
                        CURLOPT_POSTFIELDS => json_encode($boleto),
                        CURLOPT_HTTPHEADER => [
                            "Account-Number: " . $parc['conta_corrente'] . '-' . $parc['conta_corrente_dv'],
                            "Authorization: " . $parc['pp_token'],
                            "accept: application/json",
                            "content-type: application/json"
                        ],
                        ]);
                        
                        $response = curl_exec($curl);
                        $objResultado = json_decode($response);
                        $ultimoNrBoleto = 0;

                        if($objResultado->data&&$objResultado->data->id){
                            $parcela['nr_boleto'] = $objResultado->data->attributes->boleto->data->attributes->ourNumber;
                            $parcela['cod_boleto_api'] = $objResultado->data->id;
                            $parcela['fl_envio'] = 1;
                            
                            $newParcela->nr_boleto = substr($objResultado->data->attributes->boleto->data->attributes->ourNumber, -10);
                            $newParcela->cod_boleto_api = $objResultado->data->id;
                            $newParcela->fl_envio = 1;
                            $ultimoNrBoleto = substr($objResultado->data->attributes->boleto->data->attributes->ourNumber, -10);
                        }
                        else{
                            echo $response; die;
                        }

                        //salva o nr_boleto mais recente na tabela BANCO_CONTA
                        if ($ultimoNrBoleto > 0) {
                            $bancoConta = (new BancoConta())->fetchRow('id_banco_conta = ' . $bancoDados['id_banco_conta']);

                            $bancoConta->nr_boleto = $ultimoNrBoleto;
                            $bancoConta->save();
                        }

                        curl_close($curl);
                        

                        //espera 5 segundos para que d tempo da api do banco gerar a linha digitvel e cdigo de barras.
                        for($load = 0;$load<10;$load++){
                            sleep(5);
                        
                            //busca os dados do boleto de acordo com o id retornado pelo banco
                            $curl = curl_init();
        
                            curl_setopt_array($curl, [
                            CURLOPT_URL => "https://pagamentos.grafeno.digital/api/v2/charges/".$parcela['cod_boleto_api'],
                            CURLOPT_RETURNTRANSFER => true,
                            CURLOPT_ENCODING => "",
                            CURLOPT_MAXREDIRS => 10,
                            CURLOPT_TIMEOUT => 30,
                            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                            CURLOPT_CUSTOMREQUEST => "GET",
                            CURLOPT_HTTPHEADER => [
                                "Account-Number: " . $parcela['conta_corrente'] . '-' . $parcela['conta_corrente_dv'],
                                "Authorization: " . $parcela['pp_token'],
                                "accept: application/json"
                            ],
                            ]);
        
                            $response = curl_exec($curl);
                            $dadosBoleto = json_decode($response);
                            curl_close($curl);
                            if($dadosBoleto && $dadosBoleto->data && $dadosBoleto->data->attributes && $dadosBoleto->data->attributes->boleto && $dadosBoleto->data->attributes->boleto->data && $dadosBoleto->data->attributes->boleto->data->attributes && $dadosBoleto->data->attributes->boleto->data->attributes->lineCode){
                                $parcela['nr_boleto'] = $dadosBoleto->data->attributes->boleto->data->attributes->ourNumber;
                                $parcela['nosso_numero'] = $dadosBoleto->data->attributes->boleto->data->attributes->ourNumber;
                                $parcela['cod_barras'] = $dadosBoleto->data->attributes->boleto->data->attributes->barCode;
                                $parcela['linha_digitavel'] =  $dadosBoleto->data->attributes->boleto->data->attributes->lineCode;
                                $newParcela->nr_boleto = substr($dadosBoleto->data->attributes->boleto->data->attributes->ourNumber, -10);
                                $newParcela->nosso_numero = $dadosBoleto->data->attributes->boleto->data->attributes->ourNumber;
                                $newParcela->cod_barras = $dadosBoleto->data->attributes->boleto->data->attributes->barCode;
                                $newParcela->linha_digitavel = $dadosBoleto->data->attributes->boleto->data->attributes->lineCode;
                                
                                break;
                            }
                        }

                        $msgBoleto = 'Emisso 2 via Multibanco - Banco Grafeno API | ';
                    }

                    $newParcela->log = ($msgBoleto . Login::getUsuario()->getLogin() . ' - ' . date('d/m/Y H:m:s') . ' - u');
                    $parcelaBackup->log = $parcela['log'];

                    $newParcela->save();
                    $parcelaBackup->save();

                    $this->set('parcela', $newParcela);

                    if ($parcela['id_parcela_contrato'])
                    {
                        //a partir do id antigo da parcela atualiza-se a parcela na tabela COBRANCA_PARCELA
                        $parcelasCobranca = new CobrancaParcelas();
                        $cobrancas = $parcelasCobranca->fetchAll($parcelasCobranca->select()
                            ->where('id_parcela = ?', $parcela['id_parcela_contrato']));
    
                        if ($cobrancas)
                        {
                            foreach ($cobrancas as $cobranca)
                            {
                                $cobranca->id_parcela = $newParcela['id_parcela_contrato'];
                                $cobranca->save();
                            }
                        }
                    }

                    //Antes de redirecionar grava o resultado no log dos contatos realizados como Boleto 2a Via.
                    $contato = new Relacionamento();
                    $lastContato = $contato->fetchAll('idContrato =' . $newParcela['id_contrato'])->toArray();
                    $lastContato = array_pop($lastContato);
                    // condio se a data origial for alterada. informaes do log, na tabela Contrato.
                    if($_POST['dataOriginal'] == 'S'){
                        $referencia = 'Log: Boleto 2 via Gerado referente  parcela ' . $newParcela->id_parcela . '-' . $newParcela->tp_parcela . 
                        ' para Vencimento ' . Helper::getDate($newParcela->dt_parcela_2avia).', Alterado tambm a data de vencimento original de '. 
                          Helper::getDate($newParcela->dt_parcela) .' para '. Helper::getDate($newParcela->dt_parcela_2avia) . ', '.$bancoDados['nmBanco'].
                          ' - '.$bancoDados['agencia'].'-'.$bancoDados['agencia_dv'].' - '.$bancoDados['conta_corrente'].'-'.$bancoDados['conta_corrente_dv'];
                    }else{
                        $referencia = 'Log: Boleto 2 via Gerado referente  parcela ' . $newParcela->id_parcela . '-' . $newParcela->tp_parcela . 
                        ' para Vencimento ' . Helper::getDate($newParcela->dt_parcela_2avia). ', '.$bancoDados['nmBanco'].
                          ' - '.$bancoDados['agencia'].'-'.$bancoDados['agencia_dv'].' - '.$bancoDados['conta_corrente'].'-'.$bancoDados['conta_corrente_dv'];
                    }
                    
                    //Testa se a referencia  a mesma para evitar duplicidade
                    if ($lastContato['assunto'] != $referencia)
                        (new Relacionamento())->saveContato(63, date('Y-m-d'), $newParcela['id_contrato'], $referencia);

                    $db->commit();

                    $idEmail = $_POST['email'] ;
                    $idWhatsApp = $_POST['whatsapp'];
                    if ($idEmail || $idWhatsApp) {
                        $path = explode('.', $_SERVER['HTTP_HOST']);
                        if ($path[0] == 'www') {
                            $path = $path[1];
                        } else {
                            $path = $path[0];
                        }
                        $url = "https://'.$path.'.acadeone.com.br/acadelotear/?m=comunicacao&c=agendamento&a=agendarParcela";
                    
                        $data = [
                            'contrato' => $_POST['contrato_emp'],
                            'id_parcela' => $novo_id_parcela,
                            'idWhatsApp' => $idWhatsApp,
                            'idEmail' => $idEmail
                        ];
                    
                        $options = [
                            CURLOPT_URL => $url,
                            CURLOPT_POST => true,
                            CURLOPT_POSTFIELDS => http_build_query($data),
                            CURLOPT_RETURNTRANSFER => true
                        ];
                    
                        $ch = curl_init();
                        curl_setopt_array($ch, $options);
                        $response = curl_exec($ch);
                        curl_close($ch);
                        
                    }
                    $this->display('boleto');
                } catch (Exception $e) {
                    $db->rollBack();
                    $this->redir(array('modulo' => 'bo', 'controller' => 'boleto2aVia', 'action' => 'index'), array('exception' => 'Contate o suporte da Acade. Erro: '.$e->getMessage()));
                }
            }
        } elseif ($this->_isGet) {
            $this->indexAction();
        }
    }

    public function reimprimirAction()
    {
        $parcela = $this->parcela->fetchRow($this->parcela->select()
            ->from(array('par' => TB_PARCELA), array('*'))
            ->where('id_parcela_contrato = "'. $_GET['idParcela'].'"'));
        
        $this->set('parcela', $parcela);
        $this->display('boleto');
    }

    public function validarAction()
    {
        $campos = array('dataVencimento' => 'Informe a nova data de vencimento.',
            'parcelaContrato' => 'Selecione a parcela.',
            'empreendimento' => 'Selecione o empreendimento.',
            'contrato_emp' => 'Selecione o contrato.');

        foreach ($campos AS $k => $msg) {
            if ($_POST[$k] == '') {
                $this->_helper->addMensagem($k, $msg);
            }
        }

        if ($this->_isPost){
            $parcelaId = $_POST['parcelaContrato'];
            $parcela = $this->parcela->fetchRow($this->parcela->select()
                ->from(array('par' => TB_PARCELA), array('*'))
                ->where('id_parcela_contrato = ?', $parcelaId));

            if (!$parcela) {
                $this->_helper->addMensagem('danger', "J foi gerado 2 Via da parcela");
            } /*elseif ($parcela->fl_envio == '0') {
                $this->_helper->addMensagem('danger', "No  permitido emitir segunda via sem que a primeira tenha sido impressa anteriormente.");
            }*/

            $dataVencimento = Helper::getInputDate($_POST['dataVencimento']);
            //Alterado condio de data verificao, para ser feita at a data atual do servidor!
            if (strtotime($dataVencimento) < strtotime(date("Y-m-d"))) {
                $this->_helper->addMensagem('danger', "A nova data de vencimento no pode ser inferior a data atual.");
            }
        }
        //Mensagem de Erros
        if (count($this->_helper->getMensagens()) > 0) {
            $msgErros = '';
            foreach ($this->_helper->getMensagens() as $msg => $a)
                $msgErros .= utf8_encode($a) . '<br>';
            echo json_encode(array('msgErros' => $msgErros));
        } else {
            echo json_encode(true);
        }
    }

    public function loteClienteByEmpreendimentoAction()
    {
        $contratos = Contrato::byEmpreendimento($_POST['id_empreendimento'], Contrato::CONTRATO_TODOS, 0, array("nm_pessoa", "lote", "quadra", "id"), true);

        $lista = array();
        foreach ($contratos as $contrato) {
            $lista[] = array('id' => $contrato['id'], 'text' => utf8_encode($contrato['nm_pessoa']) . ' - Quadra: ' . utf8_encode($contrato['quadra']) . ' - Lote: ' . utf8_encode($contrato['lote']) . ' - Contrato: ' . utf8_encode($contrato['id']));
        }

        echo json_encode($lista);
    }

    public function bancoByEmpAction()
    {
        $banco = Banco::findByEmpreendimento($_POST['empreendimento'], false, false, false, true);

        foreach ($banco as $b) {
            $b['nmBanco'] = Banco::findBancoNome($b['cd_banco']);

            $lista[] = array(
                'id' => $b['id'],
                //se este texto for alterado o método parcelaByIdAction() controller AjaxController linhas 310 à 314, também devem ser adaptadas de acordo com as alterações feitas na linha de código abaixo.
                'text' => utf8_encode($b['nmBanco']) . ' - Ag.: ' . $b['agencia'] . '-' . $b['agencia_dv'] . '  Cc: ' . $b['conta_corrente'] . '-' . $b['conta_corrente_dv'],
                'cd_banco' => $b['cd_banco'],
                'multa' => $b['multa'],
                'juros' => $b['juros'],
                'tp_multa' => $b['tp_multa'],
                'tp_juros' => $b['tp_juros'],
                'flAtivo' => $b['fl_ativo_boleto']
            );
        }

        echo json_encode($lista);
    }

    public function findBancoAction() {
        $banco = new Banco();
        $banco = $banco->fetchRow("id = {$_POST['banco']}")->toArray();
        $lista[] = array(
            'id' => $banco['id'],
            //se este texto for alterado o método parcelaByIdAction() controller AjaxController linhas 310 à 314, também devem ser adaptadas de acordo com as alterações feitas na linha de código abaixo.
            'text' => utf8_encode($banco['nmBanco']) . ' - Ag.: ' . $banco['agencia'] . '-' . $banco['agencia_dv'] . '  Cc: ' . $banco['conta_corrente'] . '-' . $banco['conta_corrente_dv'],
            'multa' => $banco['multa'],
            'juros' => $banco['juros'],
            'tp_multa' => $banco['tp_multa'],
            'tp_juros' => $banco['tp_juros'],
            'flAtivo' => $banco['fl_ativo_boleto']
        );
        echo json_encode($lista);
    }

    public function parcelaByContrato2ViaAction()
    {
        //Adicionado condio para verificar se existe parcelas
        $banco = Banco::findByContrato($_POST['contrato']);
        $parcelas = $this->parcela->parcelaByContrato($_POST['contrato'], false, false, '("S","N","I","C","G","Q","A")');
        $lista['parcelas'] = [];
        if ($parcelas) {
            foreach ($parcelas as $parcela) {
                $lista['parcelas'][] = array('id' => $parcela['id_parcela_contrato'], 'text' => 'Parcela: ' . $parcela['id_parcela']
                    . $parcela['tp_parcela'] . ' - Data de Venc.: ' . Helper::getDate($parcela['dt_parcela']));
            }
        }
        $lista['fl_ativo'] = $banco['fl_ativo_boleto'];

        echo json_encode($lista);
    }
} 