<?php

class PessoaJuridicaController extends Controller
{
    private $cliente;
    private $pessoa;
    private $cidades;
    private $sexos;
    private $estCivis;
    private $docs;
    private $regCasamento;

    public function __construct($request)
    {
        parent::__construct($request);
        header("Access-Control-Allow-Origin: *");
        header("Access-Control-Allow-Headers: *");
        header('Content-Type: application/json; charset=utf-8');
        $this->pessoa = new Pessoa();
        $this->docs = new Documento();
        $this->cidades = new Db_Cidade();
        $this->sexos = new Db_TabelaAgrupada();
        $this->estCivis = new Db_TabelaAgrupada();
        $this->regCasamento = new Db_TabelaAgrupada();

        $dbCliente = new Db_Cliente();
        $cliente = $dbCliente->fetchRow();
        if($cliente->tokenApi!=Helper::getHeader("Token-Acade")){ 
            header("HTTP/1.1 403 Forbidden");
            echo (json_encode(array("msg" => utf8_encode("Erro. Falha na autenticao, entre em contato com o suporte para obter um token vlido."))));
            die;
        }

    }

    public function indexAction()
    {
        $totalItens = Pessoa_Juridica::findLista($_GET, true);
        $listaItem = Pessoa_Juridica::findLista($_GET);

        $lista = array();
        foreach ($listaItem as $item) {
            $acoes = '<div style="width: 90px"></div><div align="center" style="width: 100%;">';
            $acoes .= '<a href="index.php?m=' . $this->modulo . '&c=' . $this->controller . '&a=editar&id=' . $item['id'] . '" data-toggle="tooltip" title="EDITAR" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-edit"></i></a>';
            $acoes .= '</div>';
            $acoes .= '</div>';

            $lista[] = array(
                'id' => utf8_encode($item['id']),
                'nm_pessoa' => utf8_encode($item['nm_pessoa']),
                'nr_cnpj' => utf8_encode($item['nr_cnpj'])
            );
        }
        echo json_encode(array(
            'draw' => $_POST['draw']? $_POST['draw']:1,
            'recordsTotal' => count($totalItens),
            'recordsFiltered' => count($totalItens),
            'data' => $lista
        ));
    }

    public function adicionarAction()
    {
        $validar = $this->validar($_POST["nr_cnpj"]);
        if ($_POST && $validar ) {
            //insero em pessoa
            $pessoas = new Pessoa();
            $p = $pessoas->createRow();

            $p->nm_pessoa = utf8_decode($_POST["nm_pessoa"]);
            $p->nr_telefone = $_POST["nr_telefone"];
            $p->nr_celular = $_POST["nr_celular"];
            $p->nr_fax = $_POST["nr_fax"];
            $p->email = $_POST["email"];
            $p->nr_recado = $_POST["nr_recado"];
            $p->nr_cep = $_POST["nr_cep"];
            $p->endereco = utf8_decode($_POST["endereco"]);
            $p->nr_endereco = $_POST["nr_endereco"];
            $p->ds_complemento = utf8_decode($_POST["ds_complemento"]);
            $p->nm_bairro = utf8_decode($_POST["nm_bairro"]);
            $p->ds_observacao = utf8_decode($_POST["ds_observacao"]);
            $p->cd_cidade = $_POST["cd_cidade"];
            $p->tp_pessoa = "J";
            $p->dt_cadastro = date("Y-m-d H:i:s");

            //pessoa jurdica
            $pjs = new Pessoa_Juridica();
            $pj = $pjs->createRow();
            $pj->nr_cnpj = $_POST["nr_cnpj"];
            $pj->nm_fantasia = utf8_decode($_POST["nm_fantasia"]);
            $pj->nr_inscricao_municipal = $_POST["nr_inscricao_municipal"];
            $pj->nr_inscricao_estadual = $_POST["nr_inscricao_estadual"];
            $p->log = ('API - ' . date('d/m/Y H:i:s') . ' - i');

            $id = $p->save();
            $pj->id_pessoa = $id;
            $pj->save();

            //representantes
            $count = count($_POST["representantes"]);
            if ($count > 0) {
                $reps = new Representante();
                for ($i = 0; $i < $count; $i++) {
                    $rep = $reps->createRow();
                    $rep->id_pessoa = $_POST["representantes"][$i];
                    $rep->id_pessoa_juridica = $id;
                    $rep->save();
                }
            }

            echo (json_encode(array("msg" => "success", "idPessoa"=>$id)));
            die;
        }else {
            echo (json_encode(array("msg" => "Erro. ".$validar)));
            die;
        }
        
    }

    private function validar($cnpj)
    {

        //checa se o CNPJ  vlido
        if ($cnpj)
            if ($this->_helper->validaCNPJ($cnpj)) {
                //checa se est duplicado
                $pjs = new Pessoa_Juridica();
                $_p = $pjs->fetchRow("nr_cnpj = '{$cnpj}'");

                if (($_p["id_pessoa"])) {
                    $id = $_GET['id'];
                    if ((!$id) || (($id) && ($_p["id_pessoa"] != $id))) {
                        return "CNPJ j cadastrado";
                    }
                }
            } else {
                return "CNPJ invalido";
            }


        $campos = array("nm_pessoa", "nm_fantasia", "nr_cnpj", 'representantes');
        foreach ($campos as $cp) {
            if ($_POST[$cp] == "") {
                switch ($cp) {
                    case "nm_pessoa" :
                        $msg = "O campo Razo Social  obrigatrio.";
                        break;
                    case "nm_fantasia" :
                        $msg = "O campo Nome Fantasia  obrigatrio.";
                        break;
                    case "nr_cnpj" :
                        $msg = "O campo CNPJ  obrigatrio.";
                        break;
                }
                return $msg;

            }
        }
        if (!count($_POST['representantes'])) {
            $msg = "A pessoa juridica necessita de representates.";
            return $msg;
        } else {
            $proprioRepresentante = false;
            foreach ($_POST['representantes'] as $representante) {
                if($representante == $_GET['id']) {
                    $proprioRepresentante = true;
                }
            }
            if ($proprioRepresentante) {
                return "O representante no pode ser a prpria pessoa jurdica.";
            }
        }

        return true;
    }

    public function procurarPessoaJuridicaPorCnpjAction()
    {
        echo json_encode($this->pessoas->findPessoaJuridicaByCnpj($_GET['cnpj'], ($_GET['id']) ? $_GET['id'] : null));
    }
    public function procurarCidadeAction()
    {
        $tbCidade = new Cidade();
        $list = $tbCidade->select()
            ->from(array('c' => TB_CIDADE), array('nome', 'uf', 'id'))
            ->where("c.nome LIKE ?", utf8_decode($_GET['nome']) . '%')->order('c.nome')
            ->query()->fetchAll();
        $response = array();
        foreach ($list as $lt) {
            $response[] = array(
                'text' => utf8_encode($lt['nome']) . ' - ' . $lt['uf'],
                'id' => $lt['id']
            );
        }
        echo json_encode($response);
    }
    /*
     * Busca e exibe em formato json os dados necessarios para o modal de informacoes de lotes
     */
    public function procurarRepresentantesAction()
    {
        $dados = array();

        //Buscando a lista de lotes para exibir na tela
        $lista = Pessoa::findPessoaByNome(utf8_decode($_GET['nome']));

        if ($lista) foreach ($lista as $pessoa) {
            $nrCpfCnpj = ($pessoa['nr_cnpj']) ? $pessoa['nr_cnpj'] : $pessoa['nr_cpf'];
            $dados[] = array('text' => utf8_encode($pessoa['nm_pessoa']) . ' (' . $nrCpfCnpj . ')', 'value' => $pessoa['idPessoa']);
        }
        echo json_encode($dados);
    }

}
