<?php

class PessoaFisicaController extends Controller
{
    private $cliente;
    private $pessoa;
    private $cidades;
    private $sexos;
    private $estCivis;
    private $docs;
    private $regCasamento;

    public function __construct($request)
    {
        parent::__construct($request);

        header("Access-Control-Allow-Origin: *");
        header("Access-Control-Allow-Headers: *");
        header('Content-Type: application/json; charset=utf-8');
        $this->pessoa = new Pessoa();
        $this->docs = new Documento();
        $this->cidades = new Db_Cidade();
        $this->sexos = new Db_TabelaAgrupada();
        $this->estCivis = new Db_TabelaAgrupada();
        $this->regCasamento = new Db_TabelaAgrupada();

        $dbCliente = new Db_Cliente();
        $cliente = $dbCliente->fetchRow();
        if($cliente->tokenApi!=Helper::getHeader("Token-Acade")){ 
            header("HTTP/1.1 403 Forbidden");
            echo (json_encode(array("msg" => utf8_encode("Erro. Falha na autenticao, entre em contato com o suporte para obter um token vlido."))));
            die;
        }
    }
    public function indexAction()
    {
        $totalItens = Pessoa_Fisica::findLista($_GET, true);
        $listaItem = Pessoa_Fisica::findLista($_GET);

        $lista = array();
        foreach ($listaItem as $item) {
            $acoes = '<div style="width: 90px"></div><div align="center" style="width: 100%;">';
            $acoes .= '<a href="index.php?m=' . $this->modulo . '&c=' . $this->controller . '&a=editar&id=' . $item['id'] . '" data-toggle="tooltip" 
            title="EDITAR" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-edit"></i></a>';

            $acoes .= '</div>';
            $acoes .= '</div>';

            $lista[] = array(
                'id' => utf8_encode($item['id']),
                'nm_pessoa' => utf8_encode($item['nm_pessoa']),
                'nr_cpf' => utf8_encode($item['nr_cpf']),
                'endereco' => utf8_encode($item['endereco']),
                'nm_bairro' => utf8_encode($item['nm_bairro']),
                'ds_complemento' => utf8_encode($item['ds_complemento'])
            );
        }
        echo json_encode(array(
            'draw' => $_POST['draw']? $_POST['draw']:1,
            'recordsTotal' => count($totalItens),
            'recordsFiltered' => count($totalItens),
            'data' => $lista
        ));
    }

    public function adicionarAction()
    {
        if ($this->_isPost) {
            //insercao em pessoa
            $pessoas = new Pessoa();
            $p = $pessoas->createRow();

            $p->nm_pessoa = utf8_decode($_POST["nm_pessoa"]);
            $p->email = $_POST["email"];
            $p->nr_telefone = $_POST["nr_telefone"];
            $p->nr_celular = $_POST["nr_celular"];
            $p->nr_fax = $_POST["nr_fax"];
            $p->nr_recado = $_POST["nr_recado"];
            $p->nr_cep = $_POST["nr_cep"];
            $p->endereco = utf8_decode($_POST["endereco"]);
            $p->nr_endereco = $_POST["nr_endereco"];
            $p->ds_complemento = utf8_decode($_POST["ds_complemento"]);
            $p->nm_bairro = utf8_decode($_POST["nm_bairro"]);
            $p->ds_observacao = utf8_decode($_POST["ds_observacao"]);
            $p->cd_cidade = ($_POST["cd_cidade"] ? $_POST["cd_cidade"] : null);
            $p->nm_cd_internacional = $_POST["nm_cd_internacional"];
            $p->tp_pessoa = "F";
            $p->dt_cadastro = date("Y-m-d H:i:s");

            //pessoa fsica
            $pfs = new Pessoa_Fisica();
            $pf = $pfs->createRow();
            $pf->nr_cpf = $_POST["nr_cpf"];
            $pf->dt_nascimento = $this->_helper->filters($_POST["dt_nascimento"], 'date');
            $pf->nr_rg = $this->_helper->filters($_POST["nr_rg"]);
            $pf->cd_documento = $this->_helper->filters($_POST["tpDocumento"]);
            $pf->nm_profissao = $this->_helper->filters(utf8_decode($_POST["nm_profissao"]));
            $pf->tp_nacionalidade = $this->_helper->filters(utf8_decode($_POST["tpNacionalidade"]));
            if ($_POST['tpNacionalidade'] == 'B')
                $pf->nm_nacionalidade = $this->_helper->filters('Brasileira');
            else
                $pf->nm_nacionalidade = $this->_helper->filters(utf8_decode($_POST["nm_nacionalidade"]));
            $pf->cd_cidade_nasc = $this->_helper->filters($_POST["cidade_nasc"]);
            $pf->est_civil = $this->_helper->filters($_POST["est_civil"]);
            $pf->reg_casamento = $this->_helper->filters($_POST["reg_casamento"]);
            $pf->nm_pai = $this->_helper->filters(utf8_decode($_POST["nm_pai"]));
            $pf->sexo = $this->_helper->filters($_POST["sexo"]);
            $pf->nm_mae = $this->_helper->filters(utf8_decode($_POST["nm_mae"]));


            if (($_POST["est_civil"] == 'CAS' || $_POST["est_civil"] == 'UNE') && ($_POST["nrCpfConjuge"] ||
                    $_POST["nrRgConjuge"] || $_POST["dtNascimentoConjuge"] || $_POST["nmProfissaoConjuge"] ||
                    $_POST["nmNacionalidadeConjuge"] || $_POST["nrTelefoneConjuge"] || $_POST["nrCepConjuge"] ||
                    $_POST["enderecoConjuge"] || $_POST["nmBairroConjuge"])) {

                $pessoaConjuge = new Pessoa();
                $pessoaFisicaConjuge = new Pessoa_Fisica();

                //Se o conjuge ja esta cadastrado, ele sera pesquisado para modificar os dados do mesmo, caso nao, sera inserido
                if ($_POST["idConjuge"]) {
                    $pC = $pessoaConjuge->fetchRow('id = ' . $_POST["idConjuge"]);
                    $pfC = $pessoaFisicaConjuge->fetchRow('id_pessoa = ' . $_POST["idConjuge"]);
                } else {
                    $pC = $pessoaConjuge->createRow();
                    $pfC = $pessoaFisicaConjuge->createRow();
                }

                $pC->nm_pessoa = ($_POST["nmConjuge"]) ? utf8_decode($_POST["nmConjuge"]) : null;
                $pC->nr_telefone = ($_POST["nrTelefoneConjuge"]) ? $_POST["nrTelefoneConjuge"] : null;
                $pC->tp_pessoa = 'F';

                $pC->nr_cep = ($_POST["utilizarEnderecoConjuge"] == 1) ? $_POST["nr_cep"] : $_POST["nrCepConjuge"];
                $pC->endereco = ($_POST["utilizarEnderecoConjuge"] == 1) ? utf8_decode($_POST["endereco"]) : utf8_decode($_POST["enderecoConjuge"]);
                $pC->nr_endereco = ($_POST["utilizarEnderecoConjuge"] == 1) ? $_POST["nr_endereco"] : $_POST["nr_enderecoConjuge"];
                $pC->ds_complemento = ($_POST["utilizarEnderecoConjuge"] == 1) ? utf8_decode($_POST["ds_complemento"] ): utf8_decode($_POST["ds_complementoConjuge"]);
                $pC->nm_bairro = ($_POST["utilizarEnderecoConjuge"] == 1) ? utf8_decode($_POST["nm_bairro"]) : utf8_decode($_POST["nmBairroConjuge"]);
                $pC->cd_cidade = ($_POST["utilizarEnderecoConjuge"] == 1) ? ($_POST["cd_cidade"] ? $_POST["cd_cidade"] : null) : $_POST["cd_cidade"];

                $pfC->nr_cpf = ($_POST["nrCpfConjuge"]) ? $_POST["nrCpfConjuge"] : null;
                $pfC->tp_nacionalidade = $this->_helper->filters($_POST["tpNacionalidadeConjuge"]);
                if ($_POST['tpNacionalidadeConjuge'] == 'B')
                    $pfC->nm_nacionalidade = $this->_helper->filters('Brasileira');
                else
                    $pfC->nm_nacionalidade = ($_POST["nmNacionalidadeConjuge"]) ? utf8_decode($_POST["nmNacionalidadeConjuge"]) : null;
                $pfC->nr_rg = ($_POST["nrRgConjuge"]) ? $_POST["nrRgConjuge"] : null;
                $pfC->cd_documento = ($_POST["tpDocumentoConjuge"]) ? $_POST["tpDocumentoConjuge"] : null;
                $pfC->dt_nascimento = ($_POST["dtNascimentoConjuge"]) ? $this->_helper->getInputDate($_POST["dtNascimentoConjuge"]) : null;
                $pfC->cd_cidade_nasc = ($_POST['cidade_nascConjuge']) ? $this->_helper->filters($_POST["cidade_nascConjuge"]) : null;
                $pfC->nm_profissao = ($_POST["nmProfissaoConjuge"]) ? utf8_decode($_POST["nmProfissaoConjuge"]) : null;
                $pfC->sexo = ($_POST["sexoConjuge"]) ? $_POST["sexoConjuge"] : null;

                if ($_POST["nrCpfConjuge"]) {
                    $arrayCpf[] = array('cpf' => $_POST["nrCpfConjuge"], 'campo' => 'nrCpfConjuge', 'id' => $_POST["idConjuge"]);
                }
            }

            $arrayCpf[] = array('cpf' => $_POST["nr_cpf"], 'campo' => 'cpf');

            $validar = $this->validar($arrayCpf);
            if ($validar==true) {
                $p->log = ('API - ' . date('d/m/Y H:i:s') . ' - i');
                $id = $p->save();

                if (($_POST["est_civil"] == 'CAS' || $_POST["est_civil"] == 'UNE') && ($_POST["nrCpfConjuge"] ||
                        $_POST["nrRgConjuge"] || $_POST["dtNascimentoConjuge"] || $_POST["nmProfissaoConjuge"] ||
                        $_POST["nmNacionalidadeConjuge"] || $_POST["nrTelefoneConjuge"] || $_POST["nrCepConjuge"] ||
                        $_POST["enderecoConjuge"] || $_POST["nmBairroConjuge"])) {

                    //salva a pessoa do conjuge
                    $idPessoaConjuge = $pC->save();

                    //salva a pessoa fisica do conjuge
                    $pfC->id_pessoa = $idPessoaConjuge;

                    if ($_POST["est_civil"] == 'CAS')
                        $pfC->est_civil = 'CAS';
                    if ($_POST["est_civil"] == 'UNE')
                        $pfC->est_civil = 'UNE';
                    $pfC->save();

                    $pf->cd_conjuge = $idPessoaConjuge;
                }

                $pf->id_pessoa = $id;
                $idPessoaFisica = $pf->save();

                if (($_POST["est_civil"] == 'CAS' || $_POST["est_civil"] == 'UNE') && ($_POST["nrCpfConjuge"] ||
                        $_POST["nrRgConjuge"] || $_POST["dtNascimentoConjuge"] || $_POST["nmProfissaoConjuge"] ||
                        $_POST["nmNacionalidadeConjuge"] || $_POST["nrTelefoneConjuge"] || $_POST["nrCepConjuge"] ||
                        $_POST["enderecoConjuge"] || $_POST["nmBairroConjuge"])) {
                    $pfC = $pessoaFisicaConjuge->fetchRow('id_pessoa = ' . $idPessoaConjuge);
                    $pfC->cd_conjuge = $idPessoaFisica;
                    $pfC->save();
                }   
                echo (json_encode(array("msg" => "success", "idPessoa"=>$id)));
                die;
            } else {
                echo (json_encode(array("msg" => "Erro. ".$validar)));
                die;
            }
        }

    }

    public function referenciasAction()
    {
        $referencias = [];
        $sexos = Db_TabelaAgrupada::findByTabelaId(Db_TabelaAgrupada::TABLE_SEXO);
        foreach($sexos as $sexo){
            $referencias["sexos"][]=array("id"=>$sexo['idCampo'],"text"=>$sexo['descricao']);
        }
        $estCivis = Db_TabelaAgrupada::findByTabelaId(Db_TabelaAgrupada::TABLE_ESTADO_CIVIL);
        foreach($estCivis as $estCivil){
            $referencias["estCivis"][]=array("id"=>$estCivil['idCampo'],"text"=>$estCivil['descricao']);
        }
        $regCasamentos = Db_TabelaAgrupada::findByTabelaId(Db_TabelaAgrupada::TABLE_REGIME_CASAMENTO);
        foreach($regCasamentos as $regCasamento){
            $referencias["regCasamento"][]=array("id"=>$regCasamento['idCampo'],"text"=>$regCasamento['descricao']);
        }
        $tipoArquivos= Db_TabelaAgrupada::findByTabelaId(Db_TabelaAgrupada::TABLE_TIPO_ARQUIVO);
        foreach($tipoArquivos as $tipoArquivo){
            $referencias["tipoArquivos"][]=array("id"=>$tipoArquivo['idCampo'],"text"=>$tipoArquivo['descricao']);
        }

        array_walk_recursive($referencias, function (&$val) {
            if (is_string($val)) {
                $val = mb_convert_encoding($val, 'UTF-8', 'ISO-8859-1');
            }
        });
        echo json_encode($referencias);
    }
    public function procurarCidadeAction()
    {
        $tbCidade = new Cidade();
        $list = $tbCidade->select()
            ->from(array('c' => TB_CIDADE), array('nome', 'uf', 'id'))
            ->where("c.nome LIKE ?", utf8_decode($_GET['nome']) . '%')->order('c.nome')
            ->query()->fetchAll();
        $response = array();
        foreach ($list as $lt) {
            $response[] = array(
                'text' => utf8_encode($lt['nome']) . ' - ' . $lt['uf'],
                'id' => $lt['id']
            );
        }
        echo json_encode($response);
    }

    private function validar($arrayCpf)
    {
        //checa se o CPF esta valido no caso de ser brasileiro
        if ($_POST['tpNacionalidade'] == 'B') {
            if ($arrayCpf) {
                foreach ($arrayCpf as $cpf) {
                    if ($this->_helper->validaCPF($cpf['cpf'])) {
                        if (!isset($_POST['hiddenCpf']) || $cpf['cpf'] != $_POST['hiddenCpf']) {
                            $pessoa = $this->pessoa->findPessoaFisicaByCpf($cpf['cpf'], $cpf['id']);
                            if ($pessoa) {
                               return "CPF j cadastrado";
                            }
                        }
                    } else {
                        return "CPF invalido";
                    }
                }
            }
            if (!isset($_POST['nr_cpf']) || $_POST["nr_cpf"] == '') {
                $msg = "O campo CPF  obrigatrio.";
                return $msg;
            }
        }

        if ($_POST["nrCpfConjuge"]) {
            if ($_POST["nr_cpf"] == $_POST["nrCpfConjuge"]) {
                return "CPF no pode ser igual ao do conjuge";
            }
        }

        $campos = array("nm_pessoa", "nr_rg", "est_civil", "tpDocumento");

        if (($_POST["est_civil"] == 'CAS' || $_POST["est_civil"] == 'UNE') && ($_POST["nrCpfConjuge"] ||
                $_POST["nrRgConjuge"] || $_POST["dtNascimentoConjuge"] || $_POST["nmProfissaoConjuge"] ||
                $_POST["nmNacionalidadeConjuge"] || $_POST["nrTelefoneConjuge"] || $_POST["nrCepConjuge"] ||
                $_POST["enderecoConjuge"] || $_POST["nmBairroConjuge"])) {
            array_push($campos, 'nmConjuge');
            if (!isset($_POST['tpNacionalidadeConjuge']) || $_POST['tpNacionalidadeConjuge'] != 'E')
                array_push($campos, 'nrCpfConjuge');
            array_push($campos, 'sexoConjuge');
        }

        if (!$_POST["nm_nacionalidade"] && $_POST['tpNacionalidade'] == 'E') {
            return "O campo Nacionalidade  obrigatrio.";
        }

        foreach ($campos as $cp) {
            if ($_POST [$cp] == "") {
                switch ($cp) {
                    case "nm_pessoa" :
                        $msg = "O campo Nome  obrigatrio.";
                        break;
                    case "nr_rg" :
                        $msg = "O campo Documento  obrigatrio.";
                        break;
                    case "est_civil" :
                        $msg = "Selecionar o Estado Civil  obrigatrio.";
                        break;
                    case "sexo":
                        $msg = "Sexo  obrigatrio.";
                        break;
                    case "nmConjuge" :
                        $msg = "O campo Nome Cnjuge  obrigatrio.";
                        break;
                    case "nrCpfConjuge" :
                        $msg = "O campo CPF Cnjuge  obrigatrio.";
                        break;
                    case "sexoConjuge" :
                        $msg = "O campo Sexo Cnjuge  obrigatrio.";
                        break;
                    case "tpDocumento" :
                        $msg = "Selecionar tipo de Documento.";
                        break;
                }
                return $msg;
            }
        }

        return true;
    }

    public function procurarPessoaFisicaPorCpfAction()
    {
        $cpfExistente = ($this->pessoa->findPessoaFisicaByCpf($_GET['cpf'], ($_GET['id']) ? $_GET['id'] : null))?true:false;
        echo json_encode($cpfExistente);
    }
}
