<?php

class ContratoController extends Controller
{
    private $cliente;
    private $sinal;
    private $contrato;
    private $contratoHistorico;
    private $parcelasHistorico;
    private $parcelas;
    private $corretor;
    private $empreendimento;
    private $pessoa;
    private $pessoasEnvolvidas;
    private $itensContrato;
    private $tb_cliente;
    private $tb_contrato;
    private $tb_docusign;
    private $tb_docusignVinculo;
    private $tb_docusignCadastro;
    private $reservaLote;
    public function __construct($request)
    {
        parent::__construct($request);


        header("Access-Control-Allow-Origin: *");
        header("Access-Control-Allow-Headers: *");
        header('Content-Type: application/json; charset=utf-8');
        $dbCliente = new Db_Cliente();
        $cliente = $dbCliente->fetchRow();
        if($cliente->tokenApi!=Helper::getHeader("Token-Acade")){ 
            header("HTTP/1.1 403 Forbidden");
            echo (json_encode(array("msg" => utf8_encode("Erro. Falha na autenticao, entre em contato com o suporte para obter um token vlido."))));
            die;
        }


        $this->tb_cliente = new Db_Cliente();
        $this->tb_contrato = new Contrato();
        $this->contrato = new Contrato();
        $this->contratoHistorico = new ContratoHistorico();
        $this->parcelasHistorico = new ParcelaHistorico();
        $this->parcelas = new Parcela();
        $this->empreendimento = new Empreendimento();
        $this->corretor = new Corretor_Empreendimento();
        $this->sinal = new Sinal();
        $this->pessoa = new Pessoa();
        $this->pessoasEnvolvidas = new ContratoPessoa();
        $this->itensContrato = new ContratoItens();
        $this->reservaLote = new ReservaLote();
        $this->tb_docusign = new DocusignEventos();
        $this->tb_docusignVinculo = new DocusignVinculo();
        $this->tb_docusignCadastro = new DocusignCadastro();
    }
    public function indexAction(){
        $_POST['aprovar'] = $_GET['aprovar'];
        $listaItem = Contrato::findLista($_GET,false,$_GET['length'],$_GET['start']);
        $totalItens = Contrato::findLista($_GET, true);

        //Faz uma consulta e trs os Outros Compradores envolvidos e atribui a um array.
        $listarPessoasEnvolvidas = array();
        foreach ($listaItem as $k => $pessoa) {
            $pessoas_envolvidas = $this->pessoasEnvolvidas->getDefaultAdapter()->select()
                ->from(array('c' => TB_CONTRATO), array('c.id', 'c.id_pessoa', 'c.nr_proposta', 'c.porcentagem_participacao_contrato'))
                ->joinLeft(array('cp' => TB_CONTRATO_PESSOA), 'c.id = cp.id_contrato', array('id_pessoa', 'porcentagem_participacao_contrato'))
                ->joinLeft(array('p' => TB_PESSOA), 'cp.id_pessoa = p.id', array('nm_pessoa'))
                ->where('c.id =' . $pessoa['id'])
                ->query()->fetchAll();

            foreach ($pessoas_envolvidas as $p_envolvidas) {
                if ($pessoa['id'] == $p_envolvidas['id']) {
                    $listarPessoasEnvolvidas[] = $p_envolvidas['nm_pessoa'];
                }
            }
            $listaItem[$k]['pessoasEnvolvidas'] = $listarPessoasEnvolvidas;
            $listarPessoasEnvolvidas = array();
        }
        
        $lista = array();
        foreach ($listaItem as $item) {
            $acoes = '<div style="width: 90px"></div><div align="center" style="width: 100%;">';
            $acoes .= '<a href="?m=' . $this->modulo . '&c=' . $this->controller . '&a=editar&id=' . $item['id'] . '" data-toggle="tooltip" title="EDITAR" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-edit"></i></a>';
            $title = "return confirm('Tem certeza que deseja excluir o contrato " . $item['id'] . " em nome de " . $item['nm_empreendimento'] . " do Lote " . $item['lote'] . "?')";
            $acoes .= '<a onclick="' . $title . '"  href="?m=' . $this->modulo . '&c=' . $this->controller . '&a=deletar&id=' . $item['id'] . '" data-toggle="tooltip" title="EXCLUIR" class="btn btn-default btn-sm" style="margin-right:5px"><i class="fa fa-times"></i></a>';
            $acoes .= '</div>';
            $acoes .= '</div>';

            //Para ordenar por data
            $data = $item['dt_contrato'] ;

            $cor = '';
            if ($item['fl_aprovar_contrato'] == 0) {
                $cor = 'style="color:blue;"';
            }
            //Criado variavel p, para realizar verificacao de nr_proposta.
            //Caso tenha vai o numero senao vai vazio
            $p = ''; 
            if ($item['nr_proposta'] == null) {
                $p = '';
            } else {;
                $p = utf8_encode($item['nr_proposta']);
            }

            // Tratando as informaes de Pessoas envolvidas ->
            if (isset($item['nm_pessoa'])) {
                $cliente = utf8_encode($item['nm_pessoa']);
            }

            if ($item['pessoasEnvolvidas'][0] == null) {
                $outros = '';
            } else {
                $outros = ' / ' . utf8_encode(implode(' / ', $item['pessoasEnvolvidas']));
            }

            $lista[] = array(
                'contrato' => $item['id'],
                'proposta' => $p,
                'empreendimento' =>  utf8_encode($item['nm_empreendimento']) ,
                'quadra' =>  utf8_encode($item['quadra']),
                'lote' =>  utf8_encode($item['lote']) ,
                'pessoa' =>  $cliente . $outros,
                'data' =>  $data 
            );
        }
        echo json_encode(array(
            'draw' => $_GET['draw'],
            'data' => $lista,
            'recordsFiltered' =>$totalItens[0]['contador'],
            'recordsTotal'=>$totalItens[0]['contador']
        ));
    }
    public function validar()
    {
        $campos = array(
            'empreendimento' => 'O campo empreendimento  obrigatrio.',
            'cliente' => 'O campo cliente  obrigatrio.',
            'banco' => 'O campo banco  obrigatrio.',
            'corretor' => 'O campo corretor  obrigatrio.',
            'idIndice' => 'O campo ndice  obrigatrio.',
            'lote' => 'O campo lote  obrigatrio.'
        );

        if ($_POST['vl_parcela'] || $_POST['qtd_parcela'] || $_POST['dt_primeira']) {
            $campos = array_merge($campos, array(
                'vl_parcela' => 'Se for preenchido valores de parcelas normais o campo Valor  obrigatrio.',
                'qtd_parcela' => 'Se for preenchido valores de parcelas normais o campo Qtde  obrigatrio.',
                'dt_primeira' => 'Se for preenchido valores de parcelas normais o campo Data  obrigatrio.'
            ));
        }

        if ($_POST['vlSinal'] || $_POST['qtdSinal']) {
            $campos = array_merge($campos, array(
                'vlSinal' => 'Se for preenchido valores de parcela sinal o campo Valor  obrigatrio.',
                'qtdSinal' => 'Se for preenchido valores de parcela sinal o campo Qtde  obrigatrio.'
            ));
        }
        if ($_POST['intercalada'] || $_POST['qtd_parcela_intercalada'] || $_POST['frequencia'] || $_POST['data_intercalada']) {
            $campos = array_merge($campos, array(
                'intercalada' => 'Se for preenchido valores de parcelas intercaladas o campo Valor  obrigatrio.',
                'qtd_parcela_intercalada' => 'Se for preenchido valores de parcelas intercaladas o campo Qtde  obrigatrio.',
                'frequencia' => 'Se for preenchido valores de parcelas intercaladas o campo Frequencia  obrigatrio.',
                'data_intercalada' => 'Se for preenchido valores de parcelas intercaladas o campo Data  obrigatrio.'
            ));
        }

        if ($_POST['vl_chaves'] || $_POST['qtd_parcela_chaves'] || $_POST['dt_chaves']) {
            $campos = array_merge($campos, array(
                'vl_chaves' => 'Se for preenchido valores de parcelas chave o campo Valor  obrigatrio.',
                'qtd_parcela_chaves' => 'Se for preenchido valores de parcelas chave o campo Qtde  obrigatrio.',
                'dt_chaves' => 'Se for preenchido valores de parcelas chave o campo Data  obrigatrio.'
            ));
        }

        //var_dump($campos);die;
        $erro = "";
        foreach ($campos as $campo => $msg){
            if ($_POST[$campo] == ''){
                $erro = $erro . " '".$campo."': ". $msg;
            }
        }

                //echo $msg ;die;
        if($erro){
            echo (json_encode(array("msg" => "Erro. ".utf8_encode( $erro))));die;
        }
    }
    public function erro($p,$erro){
        
        echo (json_encode(array("msg" => "Erro. ".utf8_encode("'". $p."': ".$erro))));die;
    }
    public function validarAction($qtdParcNormal = null, $dtParcNormal = null, $qtdParcInterc = null, $dtParcInterc = null, $qtdFrequencia = null, $coincidir = null)
    {
        //Verificando se as datas das parcelas estao corretas
        if ($qtdParcNormal && $dtParcNormal && $qtdParcInterc && $dtParcInterc && $qtdFrequencia == 1 && $coincidir == 0) {
            $listaParcNormal = Contrato::getParcelas($dtParcNormal, $qtdParcNormal);
            $listaParcInterc = Contrato::getParcelas($dtParcInterc, $qtdParcInterc);
            $primeiraParcNormal = strtotime(current($listaParcNormal));
            $ultimaParcNormal = strtotime(end($listaParcNormal));
            $primeiraParcInterc = strtotime(current($listaParcInterc));
            $ultimaParcInterc = strtotime(end($listaParcInterc));
            if ($primeiraParcInterc < $primeiraParcNormal && $primeiraParcNormal <= $ultimaParcInterc) {
                $this->erro('dt_primeira', 'A primeira data das parcelas normais no pode ser menor ou igual a ultima data das parcelas intercaladas, quando a frequencia  1 e a opo de no coincidir parcelas estiver marcada.');
            } else if ($primeiraParcNormal < $primeiraParcInterc && $primeiraParcInterc <= $ultimaParcNormal) {
                $this->erro('intercalada', 'A primeira data das parcelas intercaladas no pode ser menor ou igual a ultima data das parcelas normais, quando a frequencia  1 e a opo de no coincidir parcelas estiver marcada.');
            } else if ($primeiraParcNormal == $primeiraParcInterc) {
                $this->erro('dt_primeira', 'As primeiras datas das parcelas intercaladas e normais no podem ser iguais, quando a frequencia  1 e a opo de no coincidir parcelas estiver marcada.');
            }
        }

        $validar = explode('/', $dtParcNormal);
        if($dtParcNormal && $validar[2] < 1900){
            $this->erro('dt_primeira', 'A data da primeira parcela normal no pode ser inferior a 1900.');
        }
        $validar = explode('/', $dtParcInterc);
        if($dtParcInterc && $validar[2] < 1900){
            $this->erro('dt_primeira', 'A data da primeira parcela intercalada no pode ser inferior a 1900.');
        }
        $validar = explode('/', $_POST['data']);
        if($validar[2] < 1900){
            $this->erro('dt_contrato', 'A data do contrato no pode ser inferior a 1900.');
        }
        if ($this->isAjax()) {
            $_POST = $_POST['formData'];
        }

        if (count($_POST) && is_array($_POST)) {
            $campos = $_POST;

            foreach ($campos as $ind => $campo) {

                if ($_POST[$ind] == "") {
                    switch ($ind) {
                        case 'empreendimento':
                            $msg = "Selecione algum empreendimento.";
                            $this->erro($ind, $msg);
                            break;
                        case 'banco':
                            $msg = "Selecione algum Banco.";
                            $this->erro($ind, $msg);
                            break;
                        case 'lote':
                            $msg = "Selecione algum lote.";
                            $this->erro($ind, $msg);
                            break;
                        case 'cliente':
                            $msg = "Digite o nome do comprador responsavel.";
                            $this->erro($ind, $msg);
                            break;
                        case 'corretor':
                            $msg = "Selecione algum corretor.";
                            $this->erro($ind, $msg);
                            break;
                    }
                }
                if ($_POST['desconto_tp_normal'] != 'S' && ($_POST['valor_desconto_normal'] == '' || $_POST['valor_desconto_normal'] <= 0)) {
                    $this->erro('desconto_tp_normal', 'O campo <b>Desconto</b> das Parcelas Normais deve ser preenchido se selecionado Em Valor/Em Porcentagem');
                }
                if ($_POST['desconto_tp_sinal'] != 'S' && ($_POST['valor_desconto_sinal'] == '' || $_POST['valor_desconto_sinal'] <= 0)) {
                    $this->erro('desconto_tp_sinal', 'O campo <b>Desconto</b> das Parcelas Sinais deve ser preenchido se selecionado Em Valor/Em Porcentagem');
                }
                if ($_POST['desconto_tp_intercalada'] != 'S' && ($_POST['valor_desconto_intercalada'] == '' || $_POST['valor_desconto_intercalada'] <= 0)) {
                    $this->erro('desconto_tp_intercalada', 'O campo <b>Desconto</b> das Parcelas Intercaladas deve ser preenchido se selecionado Em Valor/Em Porcentagem');
                }
                if ($_POST['desconto_tp_chave'] != 'S' && ($_POST['valor_desconto_chave'] == '' || $_POST['valor_desconto_chave'] <= 0)) {
                    $this->erro('desconto_tp_chave', 'O campo <b>Desconto</b> das Parcelas Chaves deve ser preenchido se selecionado Em Valor/Em Porcentagem');
                }

                if ($_POST['vl_parcela'] || $_POST['qtd_parcela'] || $_POST['dt_primeira']) {
                    if ($_POST['vl_parcela'] == '')
                        $this->erro('vl_parcela', 'Se for preenchido valores de parcelas normais o campo Valor  obrigatrio.');
                    if ($_POST['qtd_parcela'] == '')
                        $this->erro('qtd_parcela', 'Se for preenchido valores de parcelas normais o campo Qtde  obrigatrio.');
                    if ($_POST['dt_primeira'] == '')
                        $this->erro('dt_primeira', 'Se for preenchido valores de parcelas normais o campo Data  obrigatrio.');
                }

                if ($_POST['vlSinal'] || $_POST['qtdSinal']) {
                    if ($_POST['vlSinal'] == '')
                        $this->erro('vlSinal','Se for preenchido valores de parcela sinal o campo Valor  obrigatrio.');
                    if ($_POST['qtdSinal'] == '')
                        $this->erro('qtdSinal', 'Se for preenchido valores de parcela sinal o campo Qtde  obrigatrio.');
                }

                if ($_POST[$ind]) {
                    switch ($ind) {
                        case 'intercalada':
                            $_POST['qtd_parcela_intercalada'] = (strlen(trim($_POST['qtd_parcela_intercalada'])) != 0 ? (int)$_POST['qtd_parcela_intercalada'] : NULL);
                            $_POST['frequencia'] = (strlen(trim($_POST['frequencia'])) != 0 ? (int)$_POST['frequencia'] : NULL);
                            $_POST['qtd_parcela'] = (int)$_POST['qtd_parcela'];
                            if ($_POST['qtd_parcela_intercalada'] === 0 || $_POST['frequencia'] === 0) {
                                $msg = "A quantidade de parcela e a frequencia tem que ser numrico e maior que 0 (zero).";
                                $this->erro($ind, $msg);
                            }
                            break;

                        case 'sinal':
                            $_POST['qtd_parcela_sinal'] = (strlen(trim($_POST['qtd_parcela_sinal'])) != 0 ? (int)$_POST['qtd_parcela_sinal'] : NULL);
                            $_POST['qtd_parcela'] = (int)$_POST['qtd_parcela'];
                            if ($_POST['qtd_parcela_sinal'] === 0) {
                                $msg = "A quantidade de parcela tem que ser numrico e maior que 0 (zero).";
                                $this->erro($ind, $msg);
                            }
                            if ($_POST['qtd_parcela_sinal'] && !$_POST['id']) {
                                //compara se a soma das parcelas bate com o total do sinal
                                $sinal = Helper::getInputMoney($_POST['sinal']);

                                $valor = 0;
                                for ($i = 1; $i <= $_POST['qtd_parcela_sinal']; $i++) {
                                    $valor += Helper::getInputMoney($_POST['valor_' . $i]);
                                }

                                if ((string)$valor != (string)$sinal) {
                                    $msg = "A soma dos valores parcelados do sinal no confere com o valor total do sinal.";
                                    $this->erro($ind, $msg);
                                }
                                $msg = "Verifique as datas das parcelas de n: ";
                                for ($i = 1; $i <= $_POST['qtd_parcela_sinal']; $i++) {
                                    $data = explode("/", $_POST["data_$i"]);
                                    $d = $data[0];
                                    $m = $data[1];
                                    $y = $data[2];

                                    if (!checkdate($m, $d, $y)) {
                                        $msg = $msg . "$i,";
                                    }
                                }
                                $msg = rtrim($msg, ",");
                                if ($msg <> "Verifique as datas das parcelas de n: ")
                                    $this->erro($ind, $msg);
                            }
                            break;

                        case 'vl_chaves':
                            $_POST['qtd_parcela_chaves'] = (strlen(trim($_POST['qtd_parcela_chaves'])) != 0 ? (int)$_POST['qtd_parcela_chaves'] : NULL);
                            $_POST['qtd_parcela'] = (int)$_POST['qtd_parcela'];
                            if ($_POST['vl_chaves'] && $_POST['qtd_parcela_chaves'] > 0 && $_POST['vl_parcela'] && $_POST['qtd_parcela'] > 0) {
                                $msg = 'A quantidade de parcela de chaves tem que ser menor ou igual a quantidade de parcela do valor normal.';
                                $_POST['qtd_parcela_chaves'] > $_POST['qtd_parcela'] ? $this->erro($ind, $msg) : '';
                            } elseif ($_POST['qtd_parcela_chaves'] === 0) {
                                $msg = "A quantidade de parcela tem que ser numericos e maior que 0 (zero).";
                                $this->erro($ind, $msg);
                            }
                            break;

                        case 'dt_primeira':
                            if ($_POST['dt_primeira'] && (strtotime(Helper::getInputDate($_POST['dt_primeira'])) < strtotime(Helper::getInputDate($_POST['data'])))) {

                                $msg = "A data da 1; parcela tem que ser maior ou igual a data de contrato.";

                                $this->erro($ind, $msg);
                            }
                            break;
                    }
                }
            }
        }

        if ($this->isAjax()) {
            echo json_encode(array((!count($this->_helper->getMensagens()) > 0), $this->_helper->getMensagens()));
            return false;
        } else {
            return !(count($this->_helper->getMensagens()) > 0);
        }
    }
    public function adicionarAction()
    {
        try{
            if ($this->_isPost && !$this->validar()) {
                //recolhe os dados do POST para as variaveis
                $empreendimento = $_POST['empreendimento'];
                $banco = $_POST['banco'];
                $lote = $_POST['lote'];
                $cliente = $_POST['cliente'];
                $corretor = $_POST['corretor'];
                $pessoas_envolvidas = $_POST['pessoas_envolvidas'];
                $nr_proposta = $_POST['nrProposta'];
                $data_contrato = $_POST['data'];
                $dt_primeira = $_POST['dt_primeira'];
                $max_parcela = $_POST['max_parcela'];
                $qtd_parcela = (int)$_POST['qtd_parcela'];
                $valor = $_POST['vl_parcela'];
                $sinal = $_POST['vl_sinal'];
                $fl_sinal = ($_POST['sinal_agregado'] == '1') ? 1 : 0;
                $dt_sinal = $_POST['dt_sinal'];
                $desconto = Helper::getInputMoney($_POST['desconto']);
                $participacao = $_POST['participacao']; 
                $outrosCompradores = $_POST['listaIndices'];
                //Verifica se a % de participao  menor que 100
                $somaParticipacao = $_POST['participacao']? $_POST['participacao']: 0;
                    foreach ($outrosCompradores as $dados) {
                        $indice = explode('_', $dados);
                        $somaParticipacao += $this->_helper->filters($indice[2], 'money');
                    }
                    if($somaParticipacao>100){
                        echo (json_encode(array("msg" => utf8_encode("Erro. A soma das participaes no pode ser superior a 100."))));
                    }elseif($outrosCompradores && $somaParticipacao<100){
                        echo (json_encode(array("msg" =>  utf8_encode("Erro. A soma das participaes no pode ser inferior a 100."))));
                    }

                //verifica se a data de reajuste esta em branco e insere null no banco se sim
                $dt_reajuste = $_POST['dt_reajuste'];
                if ($dt_reajuste == '')
                    $dt_reajuste = null;

                //verifica se a data de reajuste mensal esta em branco e insere null no banco se sim
                $dt_reajuste_mensal = $_POST['dt_reajuste_mensal'];
                if ($dt_reajuste_mensal == '')
                    $dt_reajuste_mensal = null;
                
                //verifica se a data de reajuste intercalada esta em branco e insere null no banco se sim
                $dt_reajuste_intercalada = $_POST['dt_reajuste_intercalada'];
                if ($dt_reajuste_intercalada == '')
                    $dt_reajuste_intercalada = null;
                
                //verifica se a data de reajuste chave esta em branco e insere null no banco se sim
                $dt_reajuste_chave = $_POST['dt_reajuste_chave'];
                if ($dt_reajuste_chave == '')
                    $dt_reajuste_chave = null;

                $qtd_parcela_intercalada = (int)$_POST['qtd_parcela_intercalada'];
                $intercalada = $this->_helper->getInputMoney($_POST['intercalada']);

                if ($intercalada && $qtd_parcela_intercalada && !empty($_POST['data_intercalada'])) {
                    $dt_intercalada = $_POST['data_intercalada'];
                } elseif ($intercalada && $qtd_parcela_intercalada && empty($_POST['data_intercalada'])) {
                    $dt_intercalada = $_POST['dt_primeira'];
                } else {
                    $dt_intercalada = null;
                }

                $frequencia = $_POST['frequencia'];
                $nr_chave = ($_POST['qtd_parcela_chaves']) ? $_POST['qtd_parcela_chaves'] : null;
                $vl_chave = ($_POST['vl_chaves']) ? $_POST['vl_chaves'] : null;
                $dt_chave = ($_POST['dt_chaves']) ? $_POST['dt_chaves'] : null;
                $coincidir = $_POST['coincidir'];
                $obs = $_POST['obs'];

                $contrato = $this->contrato->createRow();
                $contrato->id_banco = $banco;
                $contrato->id_lote = $lote;
                $contrato->id_corretor = $corretor;
                $contrato->nr_proposta = $this->_helper->filters($nr_proposta);
                $contrato->dt_contrato = $this->_helper->getInputDate($data_contrato);
                $contrato->fl_fm_pagamento = $_POST['tp_pagamento'];
                $contrato->fl_aprovar_contrato = 1;
                $contrato->fl_frequencia = $_POST['fl_frequencia'];
                if ($_POST['desconto_tp_normal'] == 'S') {
                    $contrato->vl_desc_normal = null;
                } else {
                    $contrato->vl_desc_normal = $this->_helper->filters($_POST['valor_desconto_normal'], 'money');
                }
                if ($_POST['desconto_tp_intercalada'] == 'S') {
                    $contrato->vl_desc_intercalada = null;
                } else {
                    $contrato->vl_desc_intercalada = $this->_helper->filters($_POST['valor_desconto_intercalada'], 'money');
                }
                if ($_POST['desconto_tp_chave'] == 'S') {
                    $contrato->vl_desc_chave = null;
                } else {
                    $contrato->vl_desc_chave = $this->_helper->filters($_POST['valor_desconto_chave'], 'money');
                }
                if ($_POST['desconto_tp_sinal'] == 'S') {
                    $contrato->vl_desc_sinal = null;
                } else {
                    $contrato->vl_desc_sinal = $this->_helper->filters($_POST['valor_desconto_sinal'], 'money');
                }
                //salva as flags
                $contrato->fl_desc_normal = $this->_helper->filters($_POST['desconto_tp_normal']);
                $contrato->fl_desc_intercalada = $this->_helper->filters($_POST['desconto_tp_intercalada']);
                $contrato->fl_desc_chave = $this->_helper->filters($_POST['desconto_tp_chave']);
                $contrato->fl_desc_sinal = $this->_helper->filters($_POST['desconto_tp_sinal']);

                if ($intercalada == '' && $qtd_parcela_intercalada == '' && $frequencia == '' && $dt_intercalada == '') {
                    $contrato->fl_coinc_intercalada = '0';
                } else {
                    $contrato->fl_coinc_intercalada = $coincidir;
                }

                //Verifica as parcelas sinal com valor maior que zero
                $qtd_parcela_sinal = 0;
                $vl_sinal = 0;
                if (is_array($sinal))
                    foreach ($sinal as $k => $parcela) {
                        if ((float)$parcela > 0)
                            $qtd_parcela_sinal++;
                        $vl_sinal += $this->_helper->filters($parcela, 'money');
                    }

                $contrato->nr_parcela = $this->_helper->filters($qtd_parcela);
                $contrato->desconto = $this->_helper->filters($desconto);
                $contrato->vl_parcela = $this->_helper->filters($valor, 'money');
                $contrato->nr_parcela_sinal = $this->_helper->filters($qtd_parcela_sinal);
                $contrato->vl_sinal = $this->_helper->filters($vl_sinal);
                $contrato->inclui_sinal_contrato = $this->_helper->filters($_POST['incluiSinalContrato']);
                $contrato->fl_reajustavel_mensais = isset($_POST['fl_reajustavel_mensais']) ? 1 : 0;
                $contrato->fl_reajustavel_intercaladas = isset($_POST['fl_reajustavel_intercaladas']) ? 1 : 0;
                $contrato->fl_reajustavel_chaves = isset($_POST['fl_reajustavel_chaves']) ? 1 : 0;
                if ($dt_sinal[0])
                    $contrato->dt_sinal = $this->_helper->filters($dt_sinal[0], 'date');
                $contrato->nr_intercalada = $this->_helper->filters($qtd_parcela_intercalada);
                $contrato->vl_intercalada = $this->_helper->filters($intercalada);
                $contrato->fr_intercalada = $this->_helper->filters($frequencia);
                $contrato->dt_primeira_parcela = $this->_helper->filters($dt_primeira, 'date');
                $contrato->dt_reajuste = $this->_helper->filters($dt_reajuste, 'date');
                $contrato->dt_reajuste_mensal = $this->_helper->filters($dt_reajuste_mensal, 'date');
                $contrato->dt_reajuste_intercalada = $this->_helper->filters($dt_reajuste_intercalada, 'date');
                $contrato->dt_reajuste_chave = $this->_helper->filters($dt_reajuste_chave, 'date');
                $contrato->dt_intercalada = $this->_helper->filters($dt_intercalada, 'date');

                //Valores da Tabela Price
                if ($_POST['tp_parcelamento'] == 'P') {
                    $contrato->vl_divida = $this->_helper->filters($_POST['vlDivida'], 'money');
                    $contrato->nr_meses_financiamento = $this->_helper->filters($_POST['qtMeses']);
                    $contrato->tx_juros = $this->_helper->filters($_POST['txJuros'], 'money');
                }

                //Valores da Tabela Sacoc
                if ($_POST['tp_parcelamento'] == 'S') {
                    $contrato->vl_divida_sacoc = $this->_helper->filters($_POST['vlrDivida'], 'money');
                    $contrato->nr_meses_financiamento_sacoc = $this->_helper->filters($_POST['qtdMeses']);
                    $contrato->tx_juros_sacoc = $this->_helper->filters($_POST['txsJuros'], 'money');
                }


                $contrato->obs = $obs;
                $contrato->id_pessoa = $cliente;
                $contrato->fl_sinal_agregado = $fl_sinal;
                $contrato->vl_parcela_entrega = $this->_helper->filters($vl_chave, 'money');
                $contrato->nr_parcela_entrega = $this->_helper->filters($nr_chave);
                $contrato->dt_parcela_entrega = $this->_helper->filters($dt_chave, 'date');
                $contrato->id_indice = $this->_helper->filters($_POST['idIndice']);
                $contrato->ds_intermediacao_imobiliaria = $this->_helper->filters($_POST['dsIntermediacaoImobiliaria']);
                $contrato->porcentagem_participacao_contrato = $this->_helper->filters($participacao, 'money'); 
                $contrato->log =  ('API - ' . date('d/m/Y H:m:s') . ' - i');

                //Verifica se existem parcelas de tipos adicionais para setar o flag de itens de contrato
                if (count($_POST['qtd_parcela_adicional']) > 0 || count($_POST['qtd_intercalada_adicional']) > 0 || count($_POST['qtd_chave_adicional']) > 0) {
                    $contrato->fl_itens_contrato = 1;
                }

                //impede que usuario tente cadastar duas vezes o mesmo lote (com refresh na pagina)
                if ($this->validarAction(
                    $qtd_parcela,
                    $dt_primeira,
                    $qtd_parcela_intercalada,
                    $dt_intercalada,
                    $frequencia,
                    $coincidir
                )) {

                    //bloco para testar se o lote ja possui contrato imediatamente antes de salvar
                    $contratoCad = $this->contrato->fetchRow("id_lote = $lote and fl_distrato = '0'");
                    $infLote = Lote::loteById($lote);
                    if(!$infLote){
                        
                        echo (json_encode(array("msg" => utf8_encode("Erro. Lote no localizado"))));die;
                    }
                    if (!$contratoCad['id']) {

                        $idContrato = $contrato->save();
                        //PARCELAS SINAL
                        if ($qtd_parcela_sinal > 0)
                            foreach ($sinal as $k => $parcela) {
                                $rowSinal = $this->sinal->createRow();

                                $rowSinal->valor = $this->_helper->filters($parcela, 'money');
                                $rowSinal->dtVencimento = $this->_helper->filters($dt_sinal[$k], 'date');
                                $rowSinal->parcela = $k + 1;
                                $rowSinal->idContrato = $contrato->id;
                                $rowSinal->save();
                            }

                        /*
                        * Adiciona as pessoas envolvidas na tabela CONTRATO_PESSOA
                        * Precisar ser executado apos o save() pois necessita do Id do contrato
                        */
                        if (isset($outrosCompradores)) {

                            $pessoasEnvolvidas = new ContratoPessoa();
                            //Cadastra todos indices que no possuirem contratos associados
                            foreach ($outrosCompradores as $dados) {
                                $indice = explode('_', $dados);

                                $outroComprador = $pessoasEnvolvidas->createRow();
                                    $outroComprador->id_contrato =  $idContrato;
                                    $outroComprador->id_pessoa =  $indice[3];
                                    $outroComprador->porcentagem_participacao_contrato =   $this->_helper->filters($indice[2], 'money');
                                    $outroComprador->save();
                            }
                        } 

                        //Verifica se existem parcelas de tipos adicionais mensais
                        if (count($_POST['qtd_parcela_adicional']) > 0) {
                            foreach ($_POST['qtd_parcela_adicional'] as $k => $qtd_adicional) {
                                if ((float)$_POST['vl_parcela_adicional'][$k] > 0) {
                                    $itemContrato = new ContratoItens();
                                    $itemContrato = $itemContrato->createRow();
                                    $itemContrato->id_contrato = $idContrato;
                                    $itemContrato->tp_parcela = 'N';
                                    $itemContrato->vl_parcela = $this->_helper->filters($_POST['vl_parcela_adicional'][$k], 'money');
                                    $itemContrato->qt_parcelas = $qtd_adicional;
                                    $itemContrato->fl_reajustavel = isset($_POST['reajustavel_parcela'][$k]) ? '1' : '0';
                                    $itemContrato->ds_log = ('API - ' . date('d/m/Y H:m:s') . ' - i');

                                    $itemContrato->save();
                                }
                            }
                        }

                        //Verifica se existem parcelas de tipos adicionais intercaladas
                        if (count($_POST['qtd_intercalada_adicional']) > 0) {
                            foreach ($_POST['qtd_intercalada_adicional'] as $k => $qtd_adicional) {
                                if ((float)$_POST['vl_intercalada_adicional'][$k] > 0) {
                                    $itemContrato = new ContratoItens();
                                    $itemContrato = $itemContrato->createRow();
                                    $itemContrato->id_contrato = $idContrato;
                                    $itemContrato->tp_parcela = 'I';
                                    $itemContrato->vl_parcela = $this->_helper->filters($_POST['vl_intercalada_adicional'][$k], 'money');
                                    $itemContrato->dt_parcela = $this->_helper->filters($_POST['dt_intercalada_adicional'][$k], 'date');
                                    $itemContrato->nr_frequencia = $this->_helper->filters($_POST['fr_intercalada_adicional'][$k]);
                                    $itemContrato->qt_parcelas = $qtd_adicional;
                                    $itemContrato->fl_reajustavel = isset($_POST['reajustavel_intercalada'][$k]) ? '1' : '0';
                                    $itemContrato->ds_log = ('API - ' . date('d/m/Y H:m:s') . ' - i');

                                    $itemContrato->save();
                                }
                            }
                        }

                        //Verifica se existem parcelas de tipos adicionais chaves
                        if (count($_POST['qtd_chave_adicional']) > 0) {
                            foreach ($_POST['qtd_chave_adicional'] as $k => $qtd_adicional) {
                                if ((float)$_POST['vl_chave_adicional'][$k] > 0) {
                                    $itemContrato = new ContratoItens();
                                    $itemContrato = $itemContrato->createRow();
                                    $itemContrato->id_contrato = $idContrato;
                                    $itemContrato->tp_parcela = 'C';
                                    $itemContrato->vl_parcela = $this->_helper->filters($_POST['vl_chave_adicional'][$k], 'money');
                                    $itemContrato->qt_parcelas = $qtd_adicional;
                                    $itemContrato->fl_reajustavel = isset($_POST['reajustavel_chave'][$k]) ? '1' : '0';
                                    $itemContrato->ds_log =  ('API - ' . date('d/m/Y H:m:s') . ' - i');

                                    $itemContrato->save();
                                }
                            }
                        }

                        //Busca os dados de lote e pessoa para gravar no log
                        $loteDados = Lote::loteById($lote);
                        $pessoaDados = Pessoa::findById($cliente);

                        //Grava a operacao no log de contatos realizados com o lote e quadra do contrato
                        (new Relacionamento())->saveContato(54, date('Y-m-d'), $idContrato, 'Log: Contrato Cadastrado - Qd: ' .
                            $loteDados['quadra'] . ' Lt: ' . $loteDados['lote'] . ' Cliente: ' . $pessoaDados['nm_pessoa']);
                        //Verifica se existem reservas do lote para serem canceladas
                        $reserva = $this->reservaLote->fetchRow('cod_lote = ' . $this->_helper->filters($_POST['lote']) . ' AND reservado = 1');

                        if ($reserva) {
                            $reserva->reservado = 0;
                            $reserva->save();
                        }

                        echo (json_encode(array("msg" => "Sucesso.","contrato"=>$idContrato)));die;
                    } else {
                        
                        echo (json_encode(array("msg" => "Erro. O lote ja possui contrato")));die;
                    }
                } else {

                    //mostra o formulario do mesma forma que estava anteriormente com as mensagens de erro
                    $contrato->dt_contrato = $this->_helper->getDate($contrato->dt_contrato, false);
                    $contrato->vl_parcela = $this->_helper->getMoney($contrato->vl_parcela);
                    $contrato->desconto = $this->_helper->getMoney($contrato->desconto);
                    $contrato->vl_sinal = $this->_helper->getMoney($contrato->vl_sinal);
                    $contrato->vl_intercalada = $this->_helper->getMoney($contrato->vl_intercalada);
                    $contrato->dt_primeira_parcela = $this->_helper->getDate($contrato->dt_primeira_parcela, false);
                    $contrato->dt_reajuste = $this->_helper->getDate($contrato->dt_reajuste, false);
                    $contrato->dt_reajuste_mensal = $this->_helper->getDate($contrato->dt_reajuste_mensal, false);
                    $contrato->dt_reajuste_intercalada = $this->_helper->getDate($contrato->dt_reajuste_intercalada, false);
                    $contrato->dt_reajuste_chave = $this->_helper->getDate($contrato->dt_reajuste_chave, false);
                    $contrato->dt_fim_empreendimento = $this->_helper->getDate($contrato->dt_fim_empreendimento, false);
                    $contrato->vl_parcela_entrega = $this->_helper->getMoney($contrato->vl_parcela_entrega);


                    if ($empreendimento) {
                        $this->set('emp', $empreendimento);

                        $corretores = new Corretor_Empreendimento();
                        $corretores = $corretores->getAdapter()->select()
                            ->from(array('ce' => TB_CORRETOR_EMPREENDIMENTO), '')
                            ->join(array('p' => TB_PESSOA), 'ce.id_corretor = p.id', array('id', 'nm_pessoa'))
                            ->where('ce.id_empreendimento = ' . $empreendimento)
                            ->order('nm_pessoa')->query()->fetchAll();

                        $this->set('corretores', $corretores);

                        //Lote
                        $lotes = new Lote();
                        $tb_contratos = new Contrato();
                        $contratos = $tb_contratos->getAdapter()->select()->from(TB_CONTRATO, 'id_lote')->where("fl_distrato = '0'")->query()->fetchAll();

                        if ($contratos != null) {
                            $this->set('lotes', $lotes->fetchAll($lotes->select()->order(array('quadra ASC', 'lote ASC'))->where('id_empreendimento = ?', $empreendimento)->where('id NOT IN(?)', $contratos), array('id_empreendimento', 'id_lote')));
                        } else {
                            $this->set('lotes', $lotes->fetchAll($lotes->select()->order(array('quadra ASC', 'lote ASC'))->where('id_empreendimento = ?', $empreendimento), array('id_empreendimento', 'id_lote')));
                        }

                        //Banco
                        $banco = new Banco();
                        $this->set('bancos', $banco->fetchAll($banco->select()->where('id_empreendimento = ?', $empreendimento))->toArray());
                    }

                    //responsavel
                    if ($contrato->id_pessoa)
                        $this->set('pessoa', $this->pessoa->find($contrato->id_pessoa)->current()->toArray());

                    //pessoas envolvidas
                    if ($pessoas_envolvidas) {
                        foreach ($pessoas_envolvidas as &$pessoa) {
                            $pessoa = $this->pessoa->findFisicaById($pessoa);
                        }
                        $this->set('pessoas_envolvidas', $pessoas_envolvidas);
                    }

                    unset($lotes, $contratos, $bancos, $corretores);

                    //monta o sinal no retorno
                    $sinal = array();
                    for ($i = 1; $i <= $qtd_parcela_sinal; $i++) {
                        $sinal[$i]['valor'] = $this->_helper->filters($_POST["valor_$i"], 'money');
                        $sinal[$i]['dtVencimento'] = $this->_helper->filters($_POST["data_$i"], 'date');
                        $sinal[$i]['parcela'] = $i;
                        $sinal[$i]['idContrato'] = '';
                    }
                    $contrato = $contrato->toArray();
                    $contrato['liberarSinal'] = true;
                    $contrato['sinal'] = $sinal;

                    $this->set('contrato', $contrato);
                    echo (json_encode(array("msg" => "success", "contrato"=>$contrato)));die;

                }
            }
        }
        catch (Exception $e) {
            
            echo (json_encode(array("msg" => "Erro. ".$e)));die;
        }
    }
    public function indicesPorEmpreendimentoAction()
    {
        $tbIndiceEmprendimento = new IndiceEmpreendimento();
        foreach ($tbIndiceEmprendimento->getIndiceEmpreendimento($_GET['id_empreendimento']) as $indiceEmpreendimento) {
            $caracterSoma = Helper::getNomePeriodo($indiceEmpreendimento['fl_periodo']) != ''?' +':'';
            $indiceAdicional = ($indiceEmpreendimento['indice_adicional'] != '0')?$caracterSoma.str_replace('.',',',number_format($indiceEmpreendimento['indice_adicional'], 2)).'%':'';
            $residuo = ($indiceEmpreendimento['fl_residuo'] == '1')?' - Com Resduo ':' - Sem Resduo ';
            $lista[] = array(
                'id' => $indiceEmpreendimento['id_indice_empreendimento'],
                'text' => utf8_encode($indiceEmpreendimento['descricao'] . ' ' . Helper::getNomePeriodo($indiceEmpreendimento['fl_periodo']) . ' ' . $indiceAdicional . ' ' . Helper::getNomePeriodo($indiceEmpreendimento['fl_periodo_adc']) . $residuo)
            );
        }
        echo json_encode($lista);
    }

    public function lotePorEmpreendimentoAction()
    {
        $reservaLotes = new ReservaLote();
        $lotes = new Lote();
        $tb_contratos = new Contrato();
        $contratos = $tb_contratos->getAdapter()->select()->from(TB_CONTRATO, 'id_lote')->where("fl_distrato = '0'")->query()->fetchAll();
        $reserva = $reservaLotes->getAdapter()->select()->from(TB_RESERVA_LOTE, 'cod_lote')->where('reservado = "1"')->query()->fetchAll();

        if ($contratos != null) {
            $lotes = $lotes->getAdapter()->select()
                ->from(array('l' => TB_LOTES), '*')
                ->joinLeft(array('rel' => TB_RESERVA_LOTE), 'rel.cod_lote = l.id', '')
                ->where('l.reservado = "0"')
                ->where('l.id_empreendimento = ?', $_GET['id_empreendimento'])
                ->where('l.id NOT IN(?)', $contratos);

            if ($reserva) {
                $lotes = $lotes->where('l.id NOT IN(?)', $reserva);
            }

            $lotes = $lotes->group(array("id"))->order(array('quadra ASC', 'lote ASC', 'rel.id DESC'))
                ->query()->fetchAll();
        } else {
            $lotes = $lotes->getAdapter()->select()
                ->from(array('l' => TB_LOTES), '*')
                ->joinLeft(array('rl' => TB_RESERVA_LOTE), 'rl.cod_lote = l.id', '')
                ->where('l.reservado = "0"')
                ->where('l.id_empreendimento = ?', $_GET['id_empreendimento']);

            if ($reserva) {
                $lotes = $lotes->where('l.id NOT IN(?)', $reserva);
            }

            $lotes = $lotes->order(array('quadra ASC', 'lote ASC'))
                ->query()->fetchAll();
        }

        $lista = array();
        foreach ($lotes as $lote) {
            $lista[] = array('id' => $lote['id'], 'text' => utf8_encode('Quadra: ' . $lote['quadra'] . ' - Lote: ' . $lote['lote']));
        }

        echo json_encode($lista);
    }

    public function bancoPorEmpreendimentoAction()
    {
        $bancos = new Banco();
        $bancos = $bancos->getAdapter()->select()
            ->from(array('b' => TB_BANCO), '*')
            ->join(array('bc' => TB_BANCO_CONTA), 'b.id_banco_conta = bc.id_banco_conta', array(''))
            ->where('b.id_empreendimento = ' . $_GET['id_empreendimento'])
            ->where('bc.fl_ativo = 1')
            ->where('bc.fl_ativo_banco = 1')
            ->query()->fetchAll();
        $lista = array();
        foreach ($bancos as &$banco) {
            $banco['nmBanco'] = Banco::findBancoNome($banco['cd_banco']);
            $lista[] = array('id' => $banco['id'], 'text' => utf8_encode($banco['nmBanco']) . ' - Ag.: ' . $banco['agencia'] . '-' . $banco['agencia_dv'] . '  Cc.: ' . $banco['conta_corrente'] . '-' . $banco['conta_corrente_dv']);
        }

        echo json_encode($lista);
    }
    public function empreendimentosAction()
    {
        $lista = array();
        $tbEmpreendimento = new Empreendimento();
        $empreendimentos=$tbEmpreendimento->getEmpreendimentos();
        foreach ($empreendimentos as &$empreendimento) {
            $lista[] = array('id' => $empreendimento['id'], 'text' => utf8_encode($empreendimento['nm_empreendimento']));
        }

        echo json_encode($lista);
    }
    public function corretorPorEmpreendimentoAction()
    {
        $corretores = new Corretor_Empreendimento();
        $corretores = $corretores->getAdapter()->select()
            ->from(array('ce' => TB_CORRETOR_EMPREENDIMENTO), '')
            ->join(array('p' => TB_PESSOA), 'ce.id_corretor = p.id', array('id', 'nm_pessoa'))
            ->where('ce.id_empreendimento = ' . $_GET['id_empreendimento'])
            ->where("fl_ativo != '0'")
            ->order('nm_pessoa')->query()->fetchAll();

        $lista = array();
        foreach ($corretores as &$corretor) {
            $corretor['nm_pessoa'] = utf8_encode($corretor['nm_pessoa']);
            $lista[] = array('id' => $corretor['id'], 'text' => $corretor['nm_pessoa']);
        }
        echo json_encode($lista);
    }

}
