<?php
$transferencia = $this->get('transferencia');
$receptor = $this->get('receptor');
$outros = $this->get('outros');
$cedente = $this->get('cedente');
$parceria = $this->get('parceria');
$outrosCompradores = $this->get('outrosCompradores');
$loteOrigem = $this->get('loteOrigem');
$loteDestino = $this->get('loteDestino');
$contrato = $this->get('contrato');
$reajuste = $this->get('reajuste');
$empreendimento = $this->get('empreendimento');
$empreendimentoInfo = $this->get('empreendimentoInfo');
$cedenteConjuge = $this->get('cedenteConjuge');
$outrosCompradoresConjuge = $this->get('outrosCompradoresConjuge');
$pessoas = new Pessoa();
$tipoLoteamento = $this->get('tipoLoteamento');

$arrData = explode("-", $transferencia['dt_transferencia']);
$dia = $arrData[2];
$mes = $arrData[1];
$ano = $arrData[0];

$arrDataAss = explode("-", $contrato['dt_contrato']);
$diaAss = $arrDataAss[2];
$mesAss = $arrDataAss[1];
$anoAss = $arrDataAss[0];

$cidadeEmpreedimento = array();
if ($cidadeEmpreedimento = Db_Cidade::find($empreendimento['cd_cidade']))
    $cidadeEmpreedimento = $cidadeEmpreedimento->toArray();

$str = '<b> 1.1. VENDEDORA / OUTORGANTE: </b>';

foreach ($parceria as $k => $parc) {

    $pessoa = $pessoas->find($parc['id_pessoa'])->current()->toArray();

    $cidade = array();
    if ($cidade = Db_Cidade::find($pessoa['cd_cidade']))
        $cidade = $cidade->toArray();

    $pfs = new Pessoa_Fisica();
    $pjs = new Pessoa_Juridica();

    if ($pessoa['tp_pessoa'] == 'F') {
        $pf = $pfs->fetchRow('id_pessoa = ' . $pessoa['id']);
        $pessoa['nr_cpf'] = $pf->nr_cpf;
    } else {
        $pj = $pjs->fetchRow('id_pessoa = ' . $pessoa['id']);
        $pessoa['nr_cnpj'] = $pj->nr_cnpj;
    }

    $cpfCnpj = ($pessoa['tp_pessoa'] == 'F') ? "CPF/MF sob n {$pessoa['nr_cpf']}" : "CNPJ/MF {$pessoa['nr_cnpj']}";
    $str .= (($k > 0) ? '. ' : '') . Helper::str2Upper($pessoa['nm_pessoa']) . ',
            com sede no(a) ' . $pessoa['endereco'] . (($pessoa['nr_endereco']) ? ', ' . $pessoa['nr_endereco'] : '') . (($pessoa['ds_complemento']) ? ', ' . $pessoa['ds_complemento'] : '') . ' - ' . $pessoa['nm_bairro'] . ' - ' . $cidade['nome'] . ' / ' . $cidade['uf'] . ',
            CEP: ' . $pessoa['nr_cep'] . ', ' . $cpfCnpj;

    if ($cedente['tp_pessoa'] == 'F') {
        $strCedente = $cedente['nm_pessoa'] . ', ' . $cedente['nm_nacionalidade'] . ', ';
        if ($est_civil = Db_TabelaAgrupada::find( Db_TabelaAgrupada::TABLE_ESTADO_CIVIL, $cedente['est_civil'] )) {
            $strCedente .= $est_civil->getDescricao() . ', ';
        }
        $strCedente .= $cedente['nm_profissao'] . ', portador da Cdula de Identidade n' . $cedente['nr_rg'] . ', CPF: ' . $cedente['nr_cpf'];
        $strCedente .= ', residente domiciliado em ' . $cedente['nome'] . ' / ' . $cedente['uf'] . ', no(a) ' . $cedente['endereco'] . (($cedente['nr_endereco']) ? ', ' . $cedente['nr_endereco'] : '');
        $strCedente .= (($cedente['ds_complemento']) ? ', ' . $cedente['ds_complemento'] : '') . ', ' . $cedente['nm_bairro'] . ', CEP: ' . $cedente['nr_cep'];        
        $strCedente .= (($cedente['est_civil'] != 'SOL' && $cedenteConjuge['nr_cpf'] != '') ? ', conjuge ' . $cedenteConjuge['nm_pessoa'] . ', ' . $cedenteConjuge['nm_nacionalidade'] . ',  portador da Cdula de Identidade n ' . $cedenteConjuge['nr_rg'] . ', CPF: ' . $cedenteConjuge['nr_cpf']:'');
        $strCedente .= (($outrosCompradores != '')?'':'.');    
    } else {
        $strCedente = Helper::str2Upper($cedente['nm_pessoa']) . ', com sede no(a) ' . $cedente['endereco'] . (($cedente['nr_endereco']) ? ', ' . $cedente['nr_endereco'] : '') . (($cedente['ds_complemento']) ? ', ' . $cedente['ds_complemento'] : '') . ' - ' . $cedente['nm_bairro'] . ' - ' . $cedente['nome'] . ' / ' . $cedente['uf'] . ',
            CEP: ' . $cedente['nr_cep'] . ', CNPJ/MF ' . $cedente['nr_cnpj'] . (($outrosCompradores != '')?'':'.');
    }
    if ($outrosCompradores) {
        foreach ($outrosCompradores as $key => $outroComprador) {
            if ($outroComprador['tp_pessoa'] == 'F') {
                $strCedente .= ' e, ' . $outroComprador['nm_pessoa'] . ', ' . $outroComprador['nm_nacionalidade'] . ', ';
                if ($est_civil = Db_TabelaAgrupada::find(Db_TabelaAgrupada::TABLE_ESTADO_CIVIL, $outroComprador['est_civil'])) {
                    $strCedente .= $est_civil->getDescricao() . ', ';
                }
                $strCedente .= $outroComprador['nm_profissao'] . ', portador da Cdula de Identidade n' . $outroComprador['nr_rg'] . ', CPF: ' . $outroComprador['nr_cpf'];
                $strCedente .= ', residente domiciliado em ' . $outroComprador['nome'] . ' / ' . $outroComprador['uf'] . ', no(a) ' . $outroComprador['endereco'] . (($outroComprador['nr_endereco']) ? ', ' . $outroComprador['nr_endereco'] : '');
                $strCedente .= (($outroComprador['ds_complemento']) ? ', ' . $outroComprador['ds_complemento'] : '') . ', ' . $outroComprador['nm_bairro'] . ', CEP: ' . $outroComprador['nr_cep'];
                $strCedente .= (($outroComprador['est_civil'] != 'SOL' && $cedenteConjuge['nr_cpf'] != '') ? ', conjuge ' . $outrosCompradoresConjuge[$key]['nm_pessoa'] . ', ' . $outrosCompradoresConjuge[$key]['nm_nacionalidade'] . ',  portador da Cdula de Identidade n ' . $outrosCompradoresConjuge[$key]['nr_rg'] . ', CPF: ' . $outrosCompradoresConjuge[$key]['nr_cpf'] : '');
                $strCedente .= ((end($outrosCompradores) == $outroComprador) ? '.' : '');
            } else {
                $strCedente .= ' e, ' . Helper::str2Upper($outroComprador['nm_pessoa']) . ', com sede no(a) ' . $outroComprador['endereco'] . (($outroComprador['nr_endereco']) ? ', ' . $outroComprador['nr_endereco'] : '') . (($outroComprador['ds_complemento']) ? ', ' . $outroComprador['ds_complemento'] : '') . ' - ' . $outroComprador['nm_bairro'] . ' - ' . $outroComprador['nome'] . ' / ' . $outroComprador['uf'] . ',
                CEP: ' . $outroComprador['nr_cep'] . ', CNPJ/MF ' . $outroComprador['nr_cnpj'];
                $strCedente .= ((end($outrosCompradores) == $outroComprador) ? '.' : '');
            }
        }
    }

}
?>
<style type="text/css">
    div.espaco {
        margin-top: 100px;
    }

    body {
        font-family: arial;
        font-size: 12px; 
    }

    div {
        font-size: 12px; 
    }

    h2 {
        text-align: center;
        font-size: 12px; 
    }

    table tr td.h3 {
        font-size: 12px; 
    }

    h4 {
        font-size: 12px; 
    }

    table {
        width: 100%;
        font-size: 12px; 
    }

    .grid {
        border-collapse: collapse;
        width: 700px;
    }

    .grid tr td {
        border: 2px solid #000000;
    }

    .table_bordas {
        border-collapse: collapse;
        width: 730px;
    }

    .table_bordas tr td {
        border: 1px solid #000000;
        font-size: 12px; 
    }
</style>
<page backtop="10mm" backbottom="10mm">
    <table>
        <tr>
            <td style="width:730px;" align="center">
                <strong style="font-size:14px;"> 
                    CONTRATO PARTICULAR DE COMPRA E VENDA DE IMVEL
                    <br/>
                    NO EDIFICADO(LOTE) EM <?= strtoupper($tipoLoteamento['ds_tipo_loteamento']) ?>
                </strong>
            </td>
        </tr>
        <tr>
            <td style="width:730px;margin-top: 20px;" align="center"><strong style="font-size:14px; ">ADITIVO
                    CONTRATUAL</strong>
            </td>
        </tr>
    </table>
    <table border="1" style="background-color: #CCCCCC; margin-top: 20px;">
        <tr>
            <td style="border:1px solid #000000;width:730px;padding:5px;"><strong style="font-size:12px; ">1.
                    PARTES:</strong>
            </td>

        </tr>
    </table>
    <table class="table_bordas dados">
        <tr>
            <td width="695" style="padding-left: 15px; padding-right: 15px;">
                <p style="text-align:justify; "><?= $str . ', neste ato representada(s) pelo(s) seu(s) bastante procurador(es), que assina(m) o presente ADITIVO CONTRATUAL. '; ?></p>

                <p style="text-align:justify; ">
                    <b>1.2. COMPRADOR(A) / OUTORGADO(A): </b> <?= $strCedente; ?>
                </p>
            </td>
        </tr>
    </table>
    <table border="1" style="background-color: #CCCCCC; margin-top: 20px;">
        <tr>
            <td style="border:1px solid #000000;width:730px;padding:5px;"><strong style="font-size:12px; ">2. DO
                    CONTRATO ADITADO:</strong>
            </td>
        </tr>
    </table>
    <table class="table_bordas dados">
        <tr>
            <td width="695" style="padding-left: 15px; padding-right: 15px;">
                <p style="text-align:justify; ">
                    <b>2.1. CONTRATO ADITADO:</b> CONTRATO PARTICULAR DE PROMESSA DE COMPRA E VENDA DE
                    IMVEL RESIDENCIAL NO EDIFICADO(LOTE) EM <?= strtoupper($tipoLoteamento['ds_tipo_loteamento']) ?>, N <b> <?= $contrato['id'] ?></b>,
                    ASSINADO EM
                    <b><?= $diaAss . " de " . strtolower(Helper::getMes(str_pad($mesAss, 2, '0', STR_PAD_LEFT))) . " de $anoAss"; ?></b>
                </p>
            </td>
        </tr>
    </table>
    <table border="1" style="background-color: #CCCCCC; margin-top: 20px;">
        <tr>
            <td style="border:1px solid #000000;width:730px;padding:5px;"><strong style="font-size:12px; ">3. IMVEL
                    (LOTE):</strong></td>
        </tr>
    </table>
    <table class="table_bordas dados">
        <tr>
            <td width="695" style="padding-left: 15px; padding-right: 15px;">
                <p style="text-align:justify; "><b>3.1.
                <?= strtoupper($tipoLoteamento['ds_tipo_loteamento']) ?>:</b> <?= Helper::str2Upper($empreendimento['nm_empreendimento']); ?></p>

                <?php if (($contrato['dt_parcela_entrega'] != '0000-00-00') && $contrato['dt_parcela_entrega']): ?>
                    <p style="text-align:justify; "><b>3.2. DATA DA
                            ENTREGA:</b> <?= Helper::getDate($contrato['dt_parcela_entrega']); ?></p>
                <?php endif; ?>
            </td>
        </tr>
    </table>
    <table border="1" style="background-color: #CCCCCC; margin-top: 20px;">
        <tr>
            <td style="border:1px solid #000000;width:730px;padding:5px;"><strong style="font-size:12px; ">4.
                    OBJETO:</strong>
            </td>
        </tr>
    </table>
    <table class="table_bordas dados">
        <tr>
            <td width="695" style="padding-left: 15px; padding-right: 15px;">
                <p style="text-align:justify; ">
                    <b>4.1</b> Visa o presente instrumento, com a inequvoca anuncia da
                    VENDEDORA/OUTORGANTE,
                    a transferncia de lote do(a) COMPRADOR(A)/OUTORGADO(A) nos termos expostos abaixo.
                </p>

                <p style="text-align:justify;"><b>LOTE ORIGEM : </b><br>
                    3.2<b><?= ($empreendimentoInfo['ds_subgrupo'] != '') ? $empreendimentoInfo['ds_subgrupo']:''?></b><?= $loteOrigem['lote'] ?>
                    <b><?= ($empreendimentoInfo['ds_grupo'] != '') ? $empreendimentoInfo['ds_grupo']:''?></b> <?= $loteOrigem['quadra'] ?>
                    e <b>REA PRIVADA DE</b> <?= number_format($loteOrigem['area'], 2, ',', '.') . " m"; ?>
                    <br>
                    3.3<b>LIMITES E CONFRONTAES:</b>
                    <?php if ($loteOrigem['ds_geral'] == ''): ?>
                        Frente <?= $loteOrigem['conf_frente']; ?> (<?= $loteOrigem['frente']; ?> m) -
                        LD. <?= $loteOrigem['conf_direita']; ?> (<?= $loteOrigem['direita']; ?> m) -
                        LE. <?= $loteOrigem['conf_esquerda']; ?> (<?= $loteOrigem['esquerda']; ?> m)
                        e fundos com <?= $loteOrigem['conf_fundo']; ?> (<?= $loteOrigem['fundo']; ?>
                        m)
                    <?php else:
                        echo $loteOrigem['ds_geral'];
                    endif;
                    ?>
                </p>

                <p style="text-align:justify; "><b>LOTE DESTINO </b><br>
                    3.2<b><?= ($empreendimentoInfo['ds_subgrupo'] != '') ? $empreendimentoInfo['ds_subgrupo']:''?>, <?= $loteDestino['lote'] ?></b>
                    <b><?= ($empreendimentoInfo['ds_grupo'] != '') ? $empreendimentoInfo['ds_grupo']:''?></b> <?= $loteDestino['quadra'] ?>
                    e <b>REA PRIVADA DE</b> <?= number_format($loteDestino['area'], 2, ',', '.') . " m"; ?>
                    <br>
                    3.3 <b>LIMITES E CONFRONTAES:</b>
                    <?php if ($loteDestino['ds_geral'] == ''): ?>
                        Frente <?= $loteDestino['conf_frente']; ?> (<?= $loteDestino['frente']; ?> m) -
                        LD. <?= $loteDestino['conf_direita']; ?> (<?= $loteDestino['direita']; ?> m) -
                        LE. <?= $loteDestino['conf_esquerda']; ?> (<?= $loteDestino['esquerda']; ?> m)
                        e fundos com <?= $loteDestino['conf_fundo']; ?> (<?= $loteDestino['fundo']; ?> m)
                    <?php else:
                        echo $loteDestino['ds_geral'];
                    endif;
                    ?>
                </p>

                <?php if ($transferencia['obs']) : ?>
                    <p>
                        <b>4.2</b> <?= $transferencia['obs'] ?>
                    </p>
                <?php endif; ?>
            </td>
        </tr>
    </table>
    <table border="1" style="background-color: #CCCCCC; margin-top: 20px;">
        <tr>
            <td style="border:1px solid #000000;width:730px;padding:5px;"><strong style="font-size:12px; ">5.
                    RATIFICAO:</strong>
            </td>
        </tr>
    </table>
    <table class="table_bordas dados">
        <tr>
            <td width="695" style="padding-left: 15px; padding-right: 15px;">
                <p style="text-align:justify; ">
                    <b>5.1.</b> Ratificam-se e mantm-se inalteradas todas as demais clusulas, itens e subitens
                    estipulados no
                    CONTRATO ADITADO que no tenham sido modificados pelo presente aditivo.
                </p>
            </td>
        </tr>
    </table>

</page>
<page backtop="10mm" backbottom="10mm">
    <table border="1" style="background-color: #CCCCCC; margin-top: 20px;">
        <tr>
            <td style="border:1px solid #000000;width:730px;padding:5px;"><strong style="font-size:12px; ">6.
                    FORO:</strong>
            </td>
        </tr>
    </table>
    <table class="table_bordas dados">
        <tr>
            <td width="695" style="padding-left: 15px; padding-right: 15px;">
                <p style="text-align:justify; ">
                    <b>6.1.</b> O foro da Comarca
                    de <?= $cidadeEmpreedimento['nome'] . '/' . $cidadeEmpreedimento['uf'] ?>  o competente
                    para dirimir todas as questes decorrentes do presente aditivo.
                </p>
            </td>
        </tr>
    </table>
    <table>
        <tr>
            <td width="695">
                <p style="text-align:justify; ">
                    Este aditivo  firmado em 03 (trs) vias de igual teor e forma, na presena das testemunhas
                    abaixo.
                </p>

                <p style="text-align:justify; ">
                    <?= $cidadeEmpreedimento['nome'] . ", $dia de " . strtolower(Helper::getMes(str_pad($mes, 2, '0', STR_PAD_LEFT))) . " de $ano."; ?>            </p>
            </td>
        </tr>
    </table>

    <table style="padding-top: 0px; margin-top: 0px">

        <!-- VENDEDORES -->
        <?php if ($empreendimento['fl_assinatura'] == 'PE') : ?>
            <?php
            $assinaturas = $this->get('assinatura');
            $listaAssinaturas = array_chunk($assinaturas, 2);

            foreach ($listaAssinaturas as $assinaturas) : ?>
                <tr>
                    <?php foreach ($assinaturas as $ass): ?>
                        <td style="padding-top: 30px;width:350px;">__________________________________________________
                        </td>
                    <?php endforeach; ?>
                </tr>
                <tr>
                    <?php foreach ($assinaturas as $ass) : ?>
                        <td align="center" style="font-size: 12px ;width:350px;">
                            <b>VENDEDOR:</b>
                            <?php
                            $id = $ass['id_pessoa'];
                            $pes = $pessoas->find($id)->current();
                            $pf = $pfs->find($id)->current();
                            if ($pf) {
                                echo '<br />' . $pes['nm_pessoa'] . '<br /> CPF/MF:' . $pf['nr_cpf'];
                            } else {
                                $pj = $pjs->find($id)->current();
                                echo '<br />' . $pes['nm_pessoa'] . '<br /> CNPJ/MF:' . $pj['nr_cnpj'];
                            }
                            ?>
                        </td>
                    <?php endforeach; ?>
                </tr>
            <?php endforeach; ?>
        <?php elseif ($empreendimento['fl_assinatura'] == 'E') : ?>
            <tr>
                <td style="padding-top: 30px;width:350px;">__________________________________________________
                </td>
            </tr>
            <tr>
                <td align="center" style="font-size: 12px;width:350px; ">
                    <b>VENDEDOR:</b><br>
                    <?=($empreendimento['nm_empreendimento']) ?>
                </td>
            </tr>
        <?php elseif ($empreendimento['fl_assinatura'] == 'PI') : ?>
            <?php
            $parceria = $this->get('parceria');
            $listaAssinaturas = array_chunk($parceria, 2);

            foreach ($listaAssinaturas as $assinaturas) : ?>
                <tr>
                    <?php foreach ($assinaturas as $ass): ?>
                        <td style="padding-top: 30px;width:350px;">__________________________________________________
                        </td>
                    <?php endforeach; ?>
                </tr>
                <tr>
                    <?php foreach ($assinaturas as $ass) : ?>
                        <td align="center" style="font-size: 12px;width:350px; ">
                            <b>VENDEDOR:</b>
                            <?php
                            $id = $ass['id_pessoa'];
                            $pes = $pessoas->find($id)->current();
                            $pf = $pfs->find($id)->current();
                            if ($pf) {
                                echo '<br />' . $pes['nm_pessoa'] . '<br /> CPF/MF:' . $pf['nr_cpf'];
                            } else {
                                $pj = $pjs->find($id)->current();
                                echo '<br />' . $pes['nm_pessoa'] . '<br /> CNPJ/MF:' . $pj['nr_cnpj'];
                            }
                            ?>
                        </td>
                    <?php endforeach; ?>
                </tr>
            <?php endforeach; ?>
        <?php endif; ?>
    </table>

    <!-- CESSIONARIO -->

    <table style="padding-top: 0px; margin-top: 0px">
        <tr>
            <td style="padding-top: 20px;width:350px;">__________________________________________________</td>
            <?php if ($cedente['est_civil'] == 'CAS') {?>
                <td style="padding-top: 20px;width:350px;">__________________________________________________</td>
            <?php } ?>
        </tr>
        <tr>
            <td align="center" style="font-size: 12px; width:350px;">
                <b>COMPRADOR(A)</b><br/><?=($cedente['nm_pessoa']); ?></td>

            <?php if ($cedente['est_civil'] == 'CAS') {?>
                <td align="center" style="font-size: 12px ;width:350px;">
                    <b>COMPRADOR(A) CNJUGE</b><br/><?=($cedenteConjuge['nm_pessoa']); ?></td>
            <?php } ?>
        </tr>
    </table>

    <!-- Outros Compradores -->
    <?php if ($outrosCompradores) :
        foreach ($outrosCompradores as $key => $outroComprador) : ?>
    <table style="padding-top: 0px; margin-top: 0px">
        <tr>
            <td style="padding-top: 20px;width:350px;">__________________________________________________</td>
            <?php if ($outroComprador['est_civil'] == 'CAS') {?>
                <td style="padding-top: 20px;width:350px;">__________________________________________________</td>
            <?php } ?>
        </tr>
        <tr>
            <td align="center" style="font-size: 12px; width:350px;">
                <b>COMPRADOR(A)</b><br/><?=($outroComprador['nm_pessoa']); ?></td>

            <?php if ($outroComprador['est_civil'] == 'CAS') {?>
                <td align="center" style="font-size: 12px; width:350px;">
                    <b>COMPRADOR(A) CNJUGE</b><br/><?=($outrosCompradoresConjuge[$key]['nm_pessoa']); ?></td>
            <?php } ?>
        </tr>
    </table>
    <?php endforeach; 
        endif; ?>

    <!-- TESTEMUNHAS -->
    <table>
        <tr>
            <td style="padding-top: 20px;width:350px;">__________________________________________________</td>
            <td style="padding-top: 20px;width:350px;">__________________________________________________</td>
        </tr>
        <tr>
            <td align="center" style="font-size: 12px; width:350px;">
                <b>TESTEMUNHA 1</b></td>
            <td align="center" style="font-size: 12px; width:350px;">
                <b>TESTEMUNHA 2</b></td>
        </tr>
    </table>

</page>