<?php
$transferencia = $this->get('transferencia');
$receptor = $this->get('receptor');
$receptorConjuge = $this->get('receptorConjuge');
$outros = $this->get('outros');
$cedente = $this->get('cedente');
$cedenteConjuge = $this->get('cedenteConjuge');
$relacionados = $this->get('relacionados');
$parceria = $this->get('parceria');
$lote = $this->get('lote');
$contrato = $this->get('contrato');
$contratoItens = $this->get('contratoItens');
$empreendimento = $this->get('empreendimento');
$listaAssinaturas = $this->get('listaAssinaturas');
$empreendimentoInfo = $this->get('empreendimentoInfo');
$socioInfo = $this->get('socioInfo');
$parcelas = $this->get('parcelas');
$pessoas = new Pessoa();

$arrData = explode("-", $transferencia['data']);
$dia = $arrData[2];
$mes = $arrData[1];
$ano = $arrData[0];

$arrDataAss = explode("-", $contrato['dt_contrato']);
$diaAss = $arrDataAss[2];
$mesAss = $arrDataAss[1];
$anoAss = $arrDataAss[0];

$cidadeEmpreedimento = array();
if ($cidadeEmpreedimento = Db_Cidade::find($empreendimento['cd_cidade']))
    $cidadeEmpreedimento = $cidadeEmpreedimento->toArray();

$str = '<b> 1.1. VENDEDORA / OUTORGANTE: </b>';
foreach ($parceria as $k => $parc) {

    $pessoa = $pessoas->find($parc['id_pessoa'])->current()->toArray();

    $cidade = array();
    if ($cidade = Db_Cidade::find($pessoa['cd_cidade']))
        $cidade = $cidade->toArray();

    $pfs = new Pessoa_Fisica();
    $pjs = new Pessoa_Juridica();

    if ($pessoa['tp_pessoa'] == 'F') {
        $pf = $pfs->fetchRow('id_pessoa = ' . $pessoa['id']);
        $pessoa['nr_cpf'] = $pf->nr_cpf;
    } else {
        $pj = $pjs->fetchRow('id_pessoa = ' . $pessoa['id']);
        $pessoa['nr_cnpj'] = $pj->nr_cnpj;
    }

    $cpfCnpj = ($pessoa['tp_pessoa'] == 'F') ? "CPF/MF sob n {$pessoa['nr_cpf']}" : "CNPJ/MF {$pessoa['nr_cnpj']}";
    $str .= (($k > 0) ? '. ' : '') . Helper::str2Upper($pessoa['nm_pessoa']) . ',
            com sede no(a) ' . $pessoa['endereco'] . (($pessoa['nr_endereco']) ? ', ' . $pessoa['nr_endereco'] : '') . (($pessoa['ds_complemento']) ? ', ' . $pessoa['ds_complemento'] : '') . ' - ' . $pessoa['nm_bairro'] . ' - ' . $cidade['nome'] . ' / ' . $cidade['uf'] . ',
            CEP: ' . $pessoa['nr_cep'] . ', ' . $cpfCnpj;
}

//CEDENTE
if ($cedente['tp_pessoa'] == 'J') {
    $strCedente = Helper::str2Upper($cedente['nm_pessoa']) . ', com sede no(a) ' . $cedente['endereco'] . (($cedente['nr_endereco']) ? ', ' . $cedente['nr_endereco'] : '') . (($cedente['ds_complemento']) ? ', ' . $cedente['ds_complemento'] : '') . ' - ' . $cedente['nm_bairro'] . ' - ' . $cedente['nome'] . ' / ' . $cedente['uf'] . ',
            CEP: ' . $cedente['nr_cep'] . ', CNPJ/MF ' . $cedente['nr_cnpj'] . ' , telefone: ' . $cedente['nr_telefone'] . ' , email ' . $cedente['email'];
} else {
    $strCedente = $cedente['nm_pessoa'] . ', ' . $cedente['nm_nacionalidade'] . ', ';
    if ($est_civil = Db_TabelaAgrupada::find(Db_TabelaAgrupada::TABLE_ESTADO_CIVIL, $cedente['est_civil']))
        $strCedente .= $est_civil->getDescricao() . ', ';
    if ($est_civil = Db_TabelaAgrupada::find(Db_TabelaAgrupada::TABLE_REGIME_CASAMENTO, $cedente['reg_casamento']))
        $strCedente .= $est_civil->getDescricao() . ', ';
    $strCedente .= $cedente['nm_profissao'] . ', portador da Cdula de Identidade n' . $cedente['nr_rg'] . ', CPF: ' . $cedente['nr_cpf'] .
        ', residente domiciliado em ' . $cedente['nome'] . ' / ' . $cedente['uf'] . ', no(a) ' . $cedente['endereco'] . (($cedente['nr_endereco']) ? ', ' . $cedente['nr_endereco'] : '') . (($cedente['ds_complemento']) ? ', ' . $cedente['ds_complemento'] : '') . ', ' . $cedente['nm_bairro'] . ', CEP: ' . $cedente['nr_cep'] . ' , telefone: ' . $cedente['nr_telefone'] . ' , email ' . $cedente['email'];
}
if (count($relacionados) > 0) {
    foreach ($relacionados as $c) {
        if ($c['tp_pessoa'] == 'J') {
            $strCedente .= ', ' . Helper::str2Upper($c['nm_pessoa']) . ', com sede no(a) ' . $c['endereco'] . (($c['nr_endereco']) ? ', ' . $c['nr_endereco'] : '') . (($c['ds_complemento']) ? ', ' . $c['ds_complemento'] : '') . ' - ' . $c['nm_bairro'] . ' - ' . $c['nome'] . ' / ' . $c['uf'] . ',
            CEP: ' . $c['nr_cep'] . ', CNPJ/MF ' . $c['nr_cnpj'] . ' , telefone: ' . $cedente['nr_telefone'] . ' , email ' . $cedente['email'];
        } else {
            $strCedente .= ', ' . $c['nm_pessoa'] . ', ' . $c['nm_nacionalidade'] . ', ';
            if ($est_civil = Db_TabelaAgrupada::find(Db_TabelaAgrupada::TABLE_ESTADO_CIVIL, $c['est_civil']))
                $strCedente .= $est_civil->getDescricao() . ', ';
            if ($est_civil = Db_TabelaAgrupada::find(Db_TabelaAgrupada::TABLE_REGIME_CASAMENTO, $c['reg_casamento']))
                $strCedente .= $est_civil->getDescricao() . ', ';
            $strCedente .= $c['nm_profissao'] . ', portador da Cdula de Identidade n' . $c['nr_rg'] . ', CPF: ' . $c['nr_cpf'] .
                ', residente domiciliado em ' . $c['nome'] . ' / ' . $c['uf'] . ', no(a) ' . $c['endereco'] . (($c['nr_endereco']) ? ', ' . $c['nr_endereco'] : '') . (($c['ds_complemento']) ? ', ' . $c['ds_complemento'] : '') . ', ' . $c['nm_bairro'] . ', CEP: ' . $c['nr_cep'] . ' , telefone: ' . $cedente['nr_telefone'] . ' , email ' . $cedente['email'] ;
        }
    }
}
$strCedente .= '. ';

//Cedente Conjuge
if ($cedenteConjuge) {
    $strCedente .= ', conjuge '.$cedenteConjuge['nm_pessoa'] . ', ' . $cedenteConjuge['nm_nacionalidade'] . ', ';
    if ($est_civil = Db_TabelaAgrupada::find(Db_TabelaAgrupada::TABLE_ESTADO_CIVIL, $cedenteConjuge['est_civil']))
        $strCedente .= $est_civil->getDescricao() . ', ';
    if ($est_civil = Db_TabelaAgrupada::find(Db_TabelaAgrupada::TABLE_REGIME_CASAMENTO, $cedenteConjuge['reg_casamento']))
        $strCedente .= $est_civil->getDescricao() . ', ';
    $strCedente .= $cedenteConjuge['nm_profissao'] . ', portador da Cdula de Identidade n' . $cedenteConjuge['nr_rg'] . ', CPF: ' . $cedenteConjuge['nr_cpf'] .
        ', residente domiciliado em ' . $cedenteConjuge['nome'] . ' / ' . $cedenteConjuge['uf'] . ', no(a) ' . $cedenteConjuge['endereco'] . (($cedenteConjuge['nr_endereco']) ? ', ' . $cedenteConjuge['nr_endereco'] : '') . (($cedenteConjuge['ds_complemento']) ? ', ' . $cedenteConjuge['ds_complemento'] : '') . ', ' . $cedenteConjuge['nm_bairro'] . ', CEP: ' . $cedenteConjuge['nr_cep'];
    $strCedente .= '.';
}

foreach($socioInfo as $socio){
    if($strSocio == null){
        if ($socio['tp_pessoa'] == 'J') {
            $strSocio = Helper::str2Upper($socio['nm_pessoa']) . ', com sede no(a) ' . $socio['endereco'] . (($socio['nr_endereco']) ? ', ' . $socio['nr_endereco'] : '') . (($socio['ds_complemento']) ? ', ' . $socio['ds_complemento'] : '') . ' - ' . $socio['nm_bairro'] . ' - ' . $socio['nome'] . ' / ' . $socio['uf'] . ',
                    CEP: ' . $socio['nr_cep'] . ', CNPJ/MF ' . $socio['nr_cnpj'];
        } else {
            $strSocio = $socio['nm_pessoa'] . ', ' . $socio['nm_nacionalidade'] . ', ';
            if ($est_civil = Db_TabelaAgrupada::find(Db_TabelaAgrupada::TABLE_ESTADO_CIVIL, $socio['est_civil']))
                $strSocio .= $est_civil->getDescricao() . ', ';
            if ($est_civil = Db_TabelaAgrupada::find(Db_TabelaAgrupada::TABLE_REGIME_CASAMENTO, $socio['reg_casamento']))
                $strSocio .= $est_civil->getDescricao() . ', ';
            $strSocio .= $socio['nm_profissao'] . ', portador da Cdula de Identidade n' . $socio['nr_rg'] . ', CPF: ' . $socio['nr_cpf'] .
                ', residente domiciliado em ' . $socio['nome'] . ' / ' . $socio['uf'] . ', no(a) ' . $socio['endereco'] . (($socio['nr_endereco']) ? ', ' . $socio['nr_endereco'] : '') . (($socio['ds_complemento']) ? ', ' . $socio['ds_complemento'] : '') . ', ' . $socio['nm_bairro'] . ', CEP: ' . $socio['nr_cep'];
        }
    }else{
        if ($socio['tp_pessoa'] == 'J') {
            $strSocio .= ', ' . Helper::str2Upper($socio['nm_pessoa']) . ', com sede no(a) ' . $socio['endereco'] . (($socio['nr_endereco']) ? ', ' . $socio['nr_endereco'] : '') . (($socio['ds_complemento']) ? ', ' . $socio['ds_complemento'] : '') . ' - ' . $socio['nm_bairro'] . ' - ' . $socio['nome'] . ' / ' . $socio['uf'] . ',
            CEP: ' . $socio['nr_cep'] . ', CNPJ/MF ' . $socio['nr_cnpj'];
        } else {
            $strSocio .= ', ' . $socio['nm_pessoa'] . ', ' . $socio['nm_nacionalidade'] . ', ';
            if ($est_civil = Db_TabelaAgrupada::find(Db_TabelaAgrupada::TABLE_ESTADO_CIVIL, $socio['est_civil']))
                $strSocio .= $est_civil->getDescricao() . ', ';
            if ($est_civil = Db_TabelaAgrupada::find(Db_TabelaAgrupada::TABLE_REGIME_CASAMENTO, $socio['reg_casamento']))
                $strSocio .= $est_civil->getDescricao() . ', ';
            $strSocio .= $socio['nm_profissao'] . ', portador da Cdula de Identidade n' . $socio['nr_rg'] . ', CPF: ' . $socio['nr_cpf'] .
                ', residente domiciliado em ' . $socio['nome'] . ' / ' . $socio['uf'] . ', no(a) ' . $socio['endereco'] . (($socio['nr_endereco']) ? ', ' . $socio['nr_endereco'] : '') . (($socio['ds_complemento']) ? ', ' . $socio['ds_complemento'] : '') . ', ' . $socio['nm_bairro'] . ', CEP: ' . $socio['nr_cep'];
        }
    }
}

//CESSIONARIO
if ($receptor['tp_pessoa'] == 'F' || $receptor['tp_pessoa'] == 'C') {
    $strCessionario = $receptor['nm_pessoa'] . ', ' . $receptor['nm_nacionalidade'] . ', ';
    if ($est_civil = Db_TabelaAgrupada::find(Db_TabelaAgrupada::TABLE_ESTADO_CIVIL, $receptor['est_civil']))
        $strCessionario .= $est_civil->getDescricao() . ', ';
    if ($est_civil = Db_TabelaAgrupada::find(Db_TabelaAgrupada::TABLE_REGIME_CASAMENTO, $receptor['reg_casamento']))
        $strCessionario .= $est_civil->getDescricao() . ', ';
    $strCessionario .= $receptor['nm_profissao'] . ', portador da Cdula de Identidade n' . $receptor['nr_rg'] . ', CPF: ' . $receptor['nr_cpf'] .
        ', residente domiciliado em ' . $receptor['nome'] . ' / ' . $receptor['uf'] . ', no(a) ' . $receptor['endereco'] . (($receptor['nr_endereco']) ? ', ' . $receptor['nr_endereco'] : '') . (($receptor['ds_complemento']) ? ', ' . $receptor['ds_complemento'] : '') . ', ' . $receptor['nm_bairro'] . ', CEP: ' . $receptor['nr_cep'] . ' , telefone: ' . $receptor['nr_telefone'] . ' , email ' . $receptor['email'];
} elseif ($receptor['tp_pessoa'] == 'J') {
    $strCessionario = Helper::str2Upper($receptor['nm_pessoa']) . ', com sede no(a) ' . $receptor['endereco'] . (($receptor['nr_endereco']) ? ', ' . $receptor['nr_endereco'] : '') . (($receptor['ds_complemento']) ? ', ' . $receptor['ds_complemento'] : '') . ' - ' . $receptor['nm_bairro'] . ' - ' . $receptor['nome'] . ' / ' . $receptor['uf'] . ',
            CEP: ' . $receptor['nr_cep'] . ', CNPJ/MF ' . $receptor['nr_cnpj'] . ' , telefone: ' . $receptor['nr_telefone'] . ' , email ' . $receptor['email'];
}
//Cessionario Conjuge
if ($receptorConjuge) {
    $strCessionario .= ', conjuge '.$receptorConjuge['nm_pessoa'] . ', ' . $receptorConjuge['nm_nacionalidade'] . ', ';
    if ($est_civil = Db_TabelaAgrupada::find(Db_TabelaAgrupada::TABLE_ESTADO_CIVIL, $receptorConjuge['est_civil']))
        $strCessionario .= $est_civil->getDescricao() . ', ';
    if ($est_civil = Db_TabelaAgrupada::find(Db_TabelaAgrupada::TABLE_REGIME_CASAMENTO, $receptorConjuge['reg_casamento']))
        $strCessionario .= $est_civil->getDescricao() . ', ';
    $strCessionario .= $receptorConjuge['nm_profissao'] . ', portador da Cdula de Identidade n' . $receptorConjuge['nr_rg'] . ', CPF: ' . $receptorConjuge['nr_cpf'] .
        ', residente domiciliado em ' . $receptorConjuge['nome'] . ' / ' . $receptorConjuge['uf'] . ', no(a) ' . $receptorConjuge['endereco'] . (($receptorConjuge['nr_endereco']) ? ', ' . $receptorConjuge['nr_endereco'] : '') . (($receptorConjuge['ds_complemento']) ? ', ' . $receptorConjuge['ds_complemento'] : '') . ', ' . $receptorConjuge['nm_bairro'] . ', CEP: ' . $receptorConjuge['nr_cep'];
}
if (count($outros) > 0)
    foreach ($outros as $k => $c) {
        if ($c['tp_pessoa'] == 'F') {
            $strCessionario .= ', ' . $c['nm_pessoa'] . ', ' . $c['nm_nacionalidade'] . ', ';
            if ($est_civil = Db_TabelaAgrupada::find(Db_TabelaAgrupada::TABLE_ESTADO_CIVIL, $c['est_civil']))
                $strCessionario .= $est_civil->getDescricao() . ', ';
            if ($est_civil = Db_TabelaAgrupada::find(Db_TabelaAgrupada::TABLE_REGIME_CASAMENTO, $c['reg_casamento']))
                $strCessionario .= $est_civil->getDescricao() . ', ';
            $strCessionario .= $c['nm_profissao'] . ', portador da Cdula de Identidade n' . $c['nr_rg'] . ', CPF: ' . $c['nr_cpf'] .
                ', residente domiciliado em ' . $c['nome'] . ' / ' . $c['uf'] . ', no(a) ' . $c['endereco'] . (($c['nr_endereco']) ? ', ' . $c['nr_endereco'] : '') . (($c['ds_complemento']) ? ', ' . $c['ds_complemento'] : '') . ', ' . $c['nm_bairro'] . ', CEP: ' . $c['nr_cep'];
        } elseif ($c['tp_pessoa'] == 'J') {
            $strCessionario .= ', ' . Helper::str2Upper($c['nm_pessoa']) . ', com sede no(a) ' . $c['endereco'] . (($c['nr_endereco']) ? ', ' . $c['nr_endereco'] : '') . (($c['ds_complemento']) ? ', ' . $c['ds_complemento'] : '') . ' - ' . $c['nm_bairro'] . ' - ' . $c['nome'] . ' / ' . $c['uf'] . ',
            CEP: ' . $c['nr_cep'] . ', CNPJ/MF ' . $c['nr_cnpj'];
        }
    }
$strCessionario .= '.';
?>
<style type="text/css">
    body {
        font-family: arial;
        font-size: 12px; 
    }

    div {
        font-size: 12px; 
    }

    h2 {
        text-align: center;
        font-size: 12px; 
    }

    table tr td.h3 {
        font-size: 12px; 
    }

    h4 {
        font-size: 12px; 
    }

    table {
        width: 100%;
        font-size: 12px; 
    }

    .grid {
        border-collapse: collapse;
        width: 700px;
    }

    .grid tr td {
        border: 2px solid #000000;
    }

    .table_bordas {
        border-collapse: collapse;
        width: 730px;
    }

    .table_bordas tr td {
        border: 1px solid #000000;
        font-size: 12px; 
    }
</style>
<page backtop="10mm" backbottom="10mm">
    <page_header></page_header>
    <page_footer></page_footer>

    <table>
        <tr align="center">
            <td>
            <?php
                $clienteAcade = $this->get("clienteAcade");

                $dsEndLogomarca = $clienteAcade['ds_end_logomarca'];
                $dsEmpreendimentoPathLogo = $empreendimento['ds_path_logo'];

                if ($dsEmpreendimentoPathLogo && file_exists($dsEmpreendimentoPathLogo)){
                    echo '<img src="'.$dsEmpreendimentoPathLogo.'" alt="'.$empreendimento['empreendimento'].'" width="120">';
                }
                elseif ($dsEndLogomarca && file_exists($dsEndLogomarca)) {
                    echo '<img src="'.$dsEndLogomarca.'" alt="'.$clienteAcade['nm_fantasia'].'" width="120">';
                } else {
                    echo '<img style="float: left; " src="'.LOGOMARCA_DEFAULT.'" alt="LogoPadrao" width="120">';
                }
            ?>
            </td>
            <td align="center"><strong style="font-size:14px; ">CONTRATO PARTICULAR DE COMPRA E
                VENDA DE
                IMVEL <?= 'RESIDENCIAL' ?>
                <br/>
                NO EDIFICADO(LOTE) EM LOTEAMENTO<br/><br/></strong>
                <strong style="font-size:14px; ">ADITIVO
                CONTRATUAL</strong>
            </td>
        </tr>
    </table>
    <table border="1" style="background-color: #CCCCCC; margin-top:5px;">
        <tr>
            <td style="border:1px solid #000000;width:730px;padding:5px;"><strong style="font-size:12px; ">1.
                    PARTES:</strong>
            </td>

        </tr>
    </table>
    <table class="table_bordas dados">
        <tr>
            <td width="695" style="padding-left: 15px; padding-right: 15px;">
                <p style="text-align:justify; "><?= $str . ', neste ato representada(s) pelo(s)seu(s) scio(s), '; ?> <?= $strSocio; ?><?= ', que assina(m) o presente ADITIVO CONTRATUAL.' ?></p>

                <p style="text-align:justify; ">
                    <b>1.2. CEDENTE: </b> <?= $strCedente; ?>
                </p>

                <p style="text-align:justify; ">
                    <b>1.3. CESSIONRIO(A): </b> <?= $strCessionario; ?>
                </p>
            </td>
        </tr>
    </table>
    <table border="1" style="background-color: #CCCCCC;margin-top:5px;">
        <tr>
            <td style="border:1px solid #000000;width:730px;padding:5px;"><strong style="font-size:12px; ">2. DO
                    CONTRATO ADITADO:</strong>
            </td>
        </tr>
    </table>
    <table class="table_bordas dados">
        <tr>
            <td width="695" style="padding-left: 15px; padding-right: 15px;">
                <p style="text-align:justify; ">
                    <b>2.1. CONTRATO ADITADO:</b> CONTRATO PARTICULAR DE PROMESSA DE COMPRA E VENDA DE
                    IMVEL <?= 'RESIDENCIAL' ?>
                    NO EDIFICADO(LOTE) EM LOTEAMENTO, N
                    <b> <?= $contrato['id'] ?></b>,
                    ASSINADO EM
                    <b><?= $diaAss . " de " . strtolower(Helper::getMes(str_pad($mesAss, 2, '0', STR_PAD_LEFT))) . " de $anoAss"; ?></b>
                </p>
            </td>
        </tr>
    </table>
    <table border="1" style="background-color: #CCCCCC;margin-top:5px;">
        <tr>
            <td style="border:1px solid #000000;width:730px;padding:5px;"><strong style="font-size:12px; ">3. IMVEL
                    (LOTE):</strong></td>
        </tr>
    </table>
    <table class="table_bordas dados">
        <tr>
            <td width="695" style="padding-left: 15px; padding-right: 15px;">
                <p style="text-align:justify; "><b>3.1.
                        LOTEAMENTO:</b> <?= Helper::str2Upper($empreendimento['nm_empreendimento']); ?></p>

                <p style="text-align:justify; "><b>3.2.
                        <b><?= ($empreendimentoInfo['ds_subgrupo'] != '') ? $empreendimentoInfo['ds_subgrupo']:''?></b> <?= $lote['lote']?>
                            <b><?= ($empreendimentoInfo['ds_grupo'] != '') ? $empreendimentoInfo['ds_grupo']:''?></b> <?= $lote['quadra'] ?>
                            e <b>REA PRIVADA DE</b> <?= number_format($lote['area'], 2, ',', '.') . " m"; ?></b></p>

                <p style="text-align:justify; "><b>3.3. LIMITES E CONFRONTAES:</b>
                    <?php if($lote['ds_geral'] == ''): ?>
                        Frente <strong><?= $lote['conf_frente']; ?>
                            (<?= $lote['frente']; ?> m)</strong> - LD. <strong><?= $lote['conf_direita']; ?>
                            (<?= $lote['direita']; ?> m)</strong> - LE. <strong><?= $lote['conf_esquerda']; ?>
                            (<?= $lote['esquerda']; ?> m)</strong> e fundos com <strong><?= $lote['conf_fundo']; ?>
                            (<?= $lote['fundo']; ?> m)</strong>
                    <?php else:
                        echo $lote['ds_geral'];
                    endif; ?></p>
                <?php if (($empreendimento['dt_conclusao'] != '0000-00-00') && $empreendimento['dt_conclusao']): ?>
                    <p style="text-align:justify; "><b>3.4. DATA DA
                            ENTREGA:</b> <?= Helper::getDate($empreendimento['dt_conclusao']); ?></p>
                <?php endif; ?>
            </td>
        </tr>
    </table>
    <table border="1" style="background-color: #CCCCCC;margin-top:5px;">
        <tr>
            <td style="border:1px solid #000000;width:730px;padding:5px;"><strong style="font-size:12px; ">4.
                    OBJETO:</strong>
            </td>
        </tr>
    </table>
    <table class="table_bordas dados">
        <tr>
            <td width="695" style="padding-left: 15px; padding-right: 15px;">
                <p style="text-align:justify; ">
                    <b>4.1</b> Visa o presente instrumento, com a inequvoca anuncia da
                    VENDEDORA/OUTORGANTE,
                    a cesso da posio contratual do(a) COMPRADOR(A)/OUTORGADO(A), doravante tratado por
                    CEDENTE, para o(a) CESSIONRIO(A) nos termos expostos abaixo.</p>
            </td>
        </tr>
    </table>
    <table border="1" style="background-color: #CCCCCC;margin-top:5px;">
        <tr>
            <td style="border:1px solid #000000;width:730px;padding:5px;"><strong style="font-size:12px; ">5.
                    CLUSULAS:</strong>
            </td>
        </tr>
    </table>
    <table class="table_bordas dados">
        <tr>
            <td width="695" style="padding-left: 15px; padding-right: 15px;">
                <p style="text-align:justify; ">
                    <b>5.1.</b> O(A) CEDENTE transfere ao(a) CESSIONRIO(A), sem qualquer reserva, sua posio
                    contratual original de
                    COMPRADOR(A) / OUTORGADO(A), declarando expressamente que, com a assinatura deste
                    instrumento,
                    nada mais tem a exigir ou a receber da VENDEDORA / OUTORGANTE em relao ao
                    CONTRATO ADITADO.
                </p>

                <p style="text-align:justify; ">
                    <b>5.2.</b> O(A) CESSIONRIO(A), consequentemente, assume todos os direitos e obrigaes
                    relativos  posio contratual ora transferida estipulados no CONTRATO ADITADO cujo objeto  a
                    promessa de
                    compra e venda do IMVEL (LOTE) acima identificado.
                </p>

                <?php if ($transferencia['obs']) : ?>
                    <p style="text-align:justify; ">
                        <b>5.3</b> <?= $transferencia['obs'] ?>
                    </p>
                <?php endif; ?>

            </td>
        </tr>
    </table>
</page>
<page backtop="10mm" backbottom="10mm">
    <table border="1" style="background-color: #CCCCCC; margin-top:5px;">
        <tr>
            <td style="border:1px solid #000000;width:730px;padding:5px;"><strong style="font-size:12px; ">6. SALDO
                    DEVEDOR DO PREO - QUADRO RESUMO - FORMA DE PAGAMENTO:</strong>
            </td>
        </tr>
    </table>
    <table class="table_bordas dados">
        <tr>
            <td style="padding-left: 15px; padding-right: 15px;width: 695px">
                <p style="text-align:justify; "><b>6.1.</b> O(A) CESSIONRIO(A) reconhece, aceita e assume o SALDO
                    DEVEDOR DO PREO no valor abaixo apontado, obrigando-se a pag-lo nos termos estipulados:</p>

                <p>
                <table class="table_bordas dados">
                    <tr>
                        <td style="font-weight: bold">Valor Inicial</td>
                        <td colspan="4" align="left">
                            <?php
                            $total = 0;
                            $total += ($contrato['vl_sinal'] > 0) ? $contrato['vl_sinal'] : 0;
                            $total += ($contrato['vl_parcela'] > 0) ? $contrato['nr_parcela'] * $contrato['vl_parcela'] : 0;
                            $total += ($contrato['vl_intercalada'] > 0) ? $contrato['vl_intercalada'] * $contrato['nr_intercalada'] : 0;
                            $total += ($contrato['vl_parcela_entrega'] > 0) ? $contrato['vl_parcela_entrega'] * $contrato['nr_parcela_entrega'] : 0;
                            foreach($contratoItens as $ctrItens){
                                $total += ($ctrItens['vl_parcela'] > 0) ? $ctrItens['vl_parcela'] * $ctrItens['qt_parcelas'] : 0;
                            }
                            echo "&nbsp; R$ " . number_format($total, 2, ',', '.');
                            ?>
                        </td>
                    </tr>
                    <tr>
                        <td style="font-weight: bold">Saldo Devedor</td>
                        <td colspan="4" align="left">
                            <?php
                            $total = 0;
                            $total += ($transferencia['totalSinal'] > 0) ? $transferencia['vlSinal'] * $transferencia['totalSinal'] : 0;
                            $total += ($transferencia['totalNormal'] > 0) ? $transferencia['vlNormal'] * $transferencia['totalNormal'] : 0;
                            $total += ($transferencia['totalIntercalada'] > 0) ? $transferencia['vlIntercalada'] * $transferencia['totalIntercalada'] : 0;
                            $total += ($transferencia['totalEntrega'] > 0) ? $transferencia['vlEntrega'] * $transferencia['totalEntrega'] : 0;
                            $total += ($transferencia['totalNegociada'] > 0) ? $transferencia['vlNegociada'] * $transferencia['totalNegociada'] : 0;
                            echo "&nbsp; R$ " . number_format($total, 2, ',', '.');
                            ?>
                        </td>
                    </tr>
                    <?php if($clienteAcade['incluirPago'] == 'S'): ?>
                    <tr>
                        <td style="font-weight: bold">Total Pago</td>
                        <td colspan="4" align="left">
                            <?php
                            $total = 0;
                            foreach($parcelas as $parcela){
                                $total += $parcela['vl_total_pago'];
                            }
                            echo "&nbsp; R$ " . number_format($total, 2, ',', '.');
                            ?>
                        </td>
                    </tr>
                    <?php endif ?>
                    <tr>
                        <td align="center" bgcolor="#cccccc" style="font-weight: bold">PARCELAS</td>
                        <td align="center" width="90" bgcolor="#cccccc" style="font-weight: bold">QUANTIDADE</td>
                        <td align="center" width="110" bgcolor="#cccccc" style="font-weight: bold">VALOR (R$)</td>
                        <td align="center" width="110" bgcolor="#cccccc" style="font-weight: bold">VENCIMENTO</td>
                        <td align="center" width="300" bgcolor="#cccccc"  style="font-weight: bold">
                            COMPLEMENTO
                        </td>
                    </tr>
                    <tr>
                        <td style="font-weight: bold">Sinal</td>
                        <?php if ($transferencia['totalSinal'] > 0): ?>
                            <td align="center"><?= $transferencia['totalSinal']; ?></td>
                            <td align="center"><?= number_format($transferencia['vlSinal'], 2, ',', '.'); ?></td>
                            <td align="center"><?= Helper::getDate($transferencia['dtSinal']); ?></td>
                            <td align="center" colspan="2"><?= $transferencia['compSinal']; ?></td>
                        <?php else: ?>
                            <td align="center"> x-x</td>
                            <td align="center"> x-x</td>
                            <td align="center"> x-x</td>
                            <td align="center" colspan="2">x-x</td>
                        <?php endif; ?>
                    </tr>
                    <tr>
                        <td style="font-weight: bold">Mensais</td>
                        <?php if ($transferencia['totalNormal'] > 0): ?>
                            <td align="center"><?= $transferencia['totalNormal']; ?></td>
                            <td align="center"><?= number_format($transferencia['vlNormal'], 2, ',', '.'); ?></td>
                            <td align="center"><?= Helper::getDate($transferencia['dtNormal']); ?></td>
                            <td align="center" colspan="2"><?= $transferencia['compNormal']; ?></td>
                        <?php else: ?>
                            <td align="center"> x-x</td>
                            <td align="center"> x-x</td>
                            <td align="center"> x-x</td>
                            <td align="center" colspan="2">x-x</td>
                        <?php endif; ?>
                    </tr>
                    <tr>
                        <td style="font-weight: bold">Intermedirias</td>
                        <?php if ($transferencia['totalIntercalada'] > 0): ?>
                            <td align="center"><?= $transferencia['totalIntercalada']; ?></td>
                            <td align="center"><?= number_format($transferencia['vlIntercalada'], 2, ',', '.'); ?></td>
                            <td align="center"><?= Helper::getDate($transferencia['dtIntercalada']); ?></td>
                            <td align="center" colspan="2"><?= $transferencia['compIntercalada']; ?></td>
                        <?php else: ?>
                            <td align="center"> x-x</td>
                            <td align="center"> x-x</td>
                            <td align="center"> x-x</td>
                            <td align="center" colspan="2">x-x</td>
                        <?php endif; ?>
                    </tr>
                    <tr>
                        <td style="font-weight: bold">Entrega</td>
                        <?php if ($transferencia['totalEntrega'] > 0): ?>
                            <td align="center"><?= $transferencia['totalEntrega']; ?></td>
                            <td align="center"><?= number_format($transferencia['vlEntrega'], 2, ',', '.'); ?></td>
                            <td align="center"><?= Helper::getDate($transferencia['dtEntrega']); ?></td>
                            <td align="center" colspan="2"><?= $transferencia['compEntrega']; ?></td>
                        <?php else: ?>
                            <td align="center"> x-x</td>
                            <td align="center"> x-x</td>
                            <td align="center"> x-x</td>
                            <td align="center"> x-x</td>
                        <?php endif; ?>
                    </tr>
                    <tr>
                        <td style="font-weight: bold">Negociada</td>
                        <?php if ($transferencia['totalNegociada'] > 0): ?>
                            <td align="center"><?= $transferencia['totalNegociada']; ?></td>
                            <td align="center"><?= number_format($transferencia['vlNegociada'], 2, ',', '.'); ?></td>
                            <td align="center"><?= Helper::getDate($transferencia['dtNegociada']); ?></td>
                            <td align="center"></td>
                        <?php else: ?>
                            <td align="center"> x-x</td>
                            <td align="center"> x-x</td>
                            <td align="center"> x-x</td>
                            <td align="center">x-x</td>
                        <?php endif; ?>
                    </tr>
                    <tr>
                        <td align="center" bgcolor="#cccccc" colspan="2" style="font-weight: bold">ndice de
                            correo monetria
                        </td>
                        <td align="center" colspan="3">
                            <?= ($contrato['dt_reajuste'] == null) ? 'Sem reajuste' : $this->get("indiceReajuste"); ?>
                        </td>
                    </tr>
                </table>
                </p>
            </td>
        </tr>
    </table>
    <table border="1" style="background-color: #CCCCCC; margin-top:5px;">
        <tr>
            <td style="border:1px solid #000000;width:730px;padding:5px;"><strong style="font-size:12px; ">7. REGRAS
                    GERAIS:</strong>
            </td>
        </tr>
    </table>
    <table class="table_bordas dados">
        <tr>
            <td width="695" style="padding-left: 15px; padding-right: 15px;">
                <p style="text-align:justify;">
                    <b>7.1.</b> O presente instrumento  valido para aditar e modificar o CONTRATO ADITADO, o qual,
                    sem soluo de continuidade, passa a ser de cumprimento obrigatrio do(a) CESSIONRIO(A),
                    que assume, desta forma, o compromisso de fielmente cumprir os termos do CONTRATO ADITADO que
                    no foram modificados pelo presente instrumento, bem como os estipulados neste aditivo,
                    ressaltando-se que a forma e periodicidade da atualizao das parcelas desde a data de celebrao
                    do CONTRATO ADITADO permanecem inalteradas.<br>
                    <b>7.2.</b> O(A) CESSIONRIO(A) declara conhecer e aceitar todas as clusulas, termos, condies
                    e obrigaes estipuladas no CONTRATO ADITADO, especialmente os referentes aos pagamentos das parcelas, de
                    todo e qualquer tributo que lhe seja cobrado, das respectivas despesas condominiais e/ou de concessionrias de servios
                    pblicos, bem como dos encargos referentes  lavratura e registro da escritura definitiva da unidade
                    imobiliria perante os rgos pblicos ou escriturrios competentes.<br>
                    <b>7.3.</b> O(A) CESSIONRIO(A) recebe, neste ato, cpia das CLUSULAS GERAIS, servindo o
                    presente instrumento assinado como comprovao do recebimento do referido documento.<br>
                    <b>7.4.</b> O(A) CESSIONRIO(A), por assumir a condio de COMPRADOR(A) /OUTORGADO(A), sempre que
                    exigido,  o responsvel pelo pagamento dos impostos incidentes na transao de compra de imvel,
                    inclusive o IMPOSTO DE TRANSMISSO DE BENS IMVEIS (ITBI).
                </p>
            </td>
        </tr>
    </table>
    <table border="1" style="background-color: #CCCCCC; margin-top:5px;">
        <tr>
            <td style="border:1px solid #000000;width:730px;padding:5px;"><strong style="font-size:12px; ">8.
                    RATIFICAO:</strong>
            </td>
        </tr>
    </table>
    <table class="table_bordas dados">
        <tr>
            <td width="695" style="padding-left: 15px; padding-right: 15px;">
                <p style="text-align:justify; ">
                    <b>8.1.</b> Ratificam-se e mantm-se inalteradas todas as demais clusulas, itens e subitens
                    estipulados no
                    CONTRATO ADITADO que no tenham sido modificados pelo presente aditivo.
                </p>
            </td>
        </tr>
    </table>
    <table border="1" style="background-color: #CCCCCC; margin-top:5px;">
        <tr>
            <td style="border:1px solid #000000;width:730px;padding:5px;"><strong style="font-size:12px; ">9.
                    FORO:</strong>
            </td>
        </tr>
    </table>
    <table class="table_bordas dados">
        <tr>
            <td width="695" style="padding-left: 15px; padding-right: 15px;">
                <p style="text-align:justify; ">
                    <b>9.1.</b> O foro da Comarca
                    de <?= $cidadeEmpreedimento['nome'] . '/' . $cidadeEmpreedimento['uf'] ?>  o competente
                    para dirimir todas as questes decorrentes do presente aditivo.
                </p>
            </td>
        </tr>
    </table>
    <table style="padding-bottom: 0px; margin-bottom: 0px">
        <tr>
            <td width="695">
                <p style="text-align:justify; ">
                    Este aditivo  firmado em 03 (trs) vias de igual teor e forma, na presena das testemunhas
                    abaixo.
                </p>

                <p style="text-align:justify; ">
                    <?= $cidadeEmpreedimento['nome'] . ", $dia de " . strtolower(Helper::getMes(str_pad($mes, 2, '0', STR_PAD_LEFT))) . " de $ano."; ?>            </p>
            </td>
        </tr>
    </table>

    <!-- VENDEDORES -->
    <?php if ($empreendimento['fl_assinatura'] == 'PE') : ?>
        <?php
        $assinaturas = $this->get('assinatura');
        //Transforma em vrios arrays com at 2 indices em cada
        $listAssinaturas = array_chunk($assinaturas, 2);
        $i = 1;
        ?>
        <?php foreach ($listAssinaturas as $assinaturas) : ?>
            <table style="padding-top: 0px; margin-top: 0px;border-collapse: collapse;">
                <tr>
                    <?php foreach ($assinaturas as $ass): ?>
                        <td style="padding-top: 5px;width:350px;border-collapse: collapse;">__________________________________________________
                        </td>
                    <?php endforeach; ?>
                </tr>
                <tr>
                    <?php foreach ($assinaturas as $ass) : ?>
                        <td align="center" style="font-size: 12px; width:350px;border-collapse: collapse;">
                            <b>VENDEDOR:</b>
                            <?php
                            $id = $ass['id_pessoa'];
                            $pes = $pessoas->find($id)->current();
                            $pf = $pfs->find($id)->current();
                            if ($pf) {
                                echo '<br />' . $pes['nm_pessoa'] . '<br /> CPF/MF:' . $pf['nr_cpf'];
                            } else {
                                $pj = $pjs->find($id)->current();
                                echo '<br />' . $pes['nm_pessoa'] . '<br /> CNPJ/MF:' . $pj['nr_cnpj'];
                            }
                            ?>
                        </td>
                    <?php endforeach; ?>
                </tr>
            </table>
            <!-- Quebra pagina caso tenha mais que 4 assinaturas -->
            <?= ($i == 4) ? '</page><page>' : '' ?>
            <?php $i++; ?>
        <?php endforeach; ?>
    <?php elseif ($empreendimento['fl_assinatura'] == 'E') : ?>
        <table style="padding-top: 0px; margin-top: 0px;border-collapse: collapse;">
            <tr>
                <td style="padding-top: 5px;width:350px;border-collapse: collapse;">__________________________________________________
                </td>
            </tr>
            <tr>
                <td align="center" style="font-size: 12px; width:350px;border-collapse: collapse;">
                    <b>VENDEDOR:</b><br>
                    <?= ($empreendimento['nm_empreendimento']) ?>
                </td>
            </tr>
        </table>
    <?php elseif ($empreendimento['fl_assinatura'] == 'PI') : ?>
        <?php
        $parceria = $this->get('parceria');
        //Transforma em vrios arrays com at 2 indices em cada
        $listAssinaturas = array_chunk($parceria, 2);
        $i = 1;
        ?>
        <?php foreach ($listAssinaturas as $assinaturas) : ?>
            <table style="padding-top: 0px; margin-top: 0px;border-collapse: collapse;">
                <tr>
                    <?php foreach ($assinaturas as $ass): ?>
                        <td style="padding-top: 5px;width:350px;border-collapse: collapse;">__________________________________________________
                        </td>
                    <?php endforeach; ?>
                </tr>
                <tr>
                    <?php foreach ($assinaturas as $ass) : ?>
                        <td align="center" style="font-size: 12px; width:350px;border-collapse: collapse;">
                            <b>VENDEDOR:</b>
                            <?php
                            $id = $ass['id_pessoa'];
                            $pes = $pessoas->find($id)->current();
                            $pf = $pfs->find($id)->current();
                            if ($pf) {
                                echo '<br />' . $pes['nm_pessoa'];
                            } else {
                                $pj = $pjs->find($id)->current();
                                echo '<br />' . $pes['nm_pessoa'];
                            }
                            ?>
                        </td>
                    <?php endforeach; ?>
                </tr>
            </table>
            <!-- Quebra pagina caso tenha mais que 4 assinaturas -->
            <?= ($i == 4) ? '</page><page>' : '' ?>
            <?php $i++; ?>
        <?php endforeach; ?>
    <?php endif;

    ?>

    <?php
    if ($listaAssinaturas) {
        $listaAssinaturas = array_chunk($listaAssinaturas, 2);
    }
    ?>
    <?php foreach ($listaAssinaturas as $assinaturas): ?>
        <table style="padding-top: 0px; margin-top: 0px;border-collapse: collapse;">
            <tr>
                <?php foreach ($assinaturas as $assinatura): ?>
                    <td style="padding-top: 28px;width:350px;border-collapse: collapse;">__________________________________________________
                    </td>
                <?php endforeach; ?>
            </tr>
            <tr>
                <?php foreach ($assinaturas as $assinatura) : ?>
                    <td align="center" style="font-size: 12px; width:350px;border-collapse: collapse;">
                        <b><?= $assinatura['tipo']?></b><br/><?= $assinatura['nome']?>
                    </td>
                <?php endforeach; ?>
            </tr>
        </table>
    <?php endforeach; ?>

    <!-- TESTEMUNHAS -->
    <table>
        <tr>
            <td style="padding-top: 28px;width:350px;border-collapse: collapse;">__________________________________________________</td>
            <td style="padding-top: 28px;width:350px;border-collapse: collapse;">__________________________________________________</td>
        </tr>
        <tr>
            <td align="center" style="font-size: 12px; width:350px;border-collapse: collapse;">
                <b>TESTEMUNHA 1</b></td>
            <td align="center" style="font-size: 12px; width:350px;border-collapse: collapse;">
                <b>TESTEMUNHA 2</b></td>
        </tr>
    </table>

</page>