<?php require_once 'layout/includes/header.php'; ?>
<?php require_once 'layout/includes/menu.php'; ?>
<?php
$listaEmpreendimento = $this->get('empreendimentos');
$dados = $this->get('param');
?>
    <div class="content">
            <div class="page-heading">
                <?= $this->getHeader('','Transferncia Titularidade'); ?>
            </div>
            <div class="widget">
                <div class="widget-content padding">
                    <!-- MENSAGENS -->
                    <?= ($_GET["msg"] == "success") ? '<div style="width:100%" class="alert alert-success alert-dismissable">Operao realizada com sucesso.</div>'
                        : (($_GET['exception'] != '') ? '<div style="width:100%" class="alert alert-danger alert-dismissable">' . $_GET['exception'] . '</div>' : '');
                    ?>
                    <?php if (count($this->_helper->getMensagens()) > 0): ?>
                        <div class="alert alert-danger alert-dismissable">
                            <?php foreach ($this->_helper->getMensagens() as $message): ?>
                                <?= $message ?><br>
                            <?php endforeach; ?>
                        </div>
                    <?php endif; ?>
                    <form action="" method="POST" id="form">
                        <fieldset>
                            <legend>Informaes da Transferncia de Titularidade <span style=" font-size: 10pt">(Campos com <span style=" color: red">*</span> so obrigatrios)</span>
                                <span data-toggle="modal" data-target=".mVisualizar" style="font-size: 22px;" data-toggle="tooltip" data-placement="top" title="Assista ao tutorial">
                                    <svg xmlns="" width="22" height="22" fill="currentColor" class="bi bi-youtube" viewBox="0 0 16 16">
                                        <path d="M8.051 1.999h.089c.822.003 4.987.033 6.11.335a2.01 2.01 0 0 1 1.415 1.42c.101.38.172.883.22 1.402l.01.104.022.26.008.104c.065.914.073 1.77.074 1.957v.075c-.001.194-.01 1.108-.082 2.06l-.008.105-.009.104c-.05.572-.124 1.14-.235 1.558a2.01 2.01 0 0 1-1.415 1.42c-1.16.312-5.569.334-6.18.335h-.142c-.309 0-1.587-.006-2.927-.052l-.17-.006-.087-.004-.171-.007-.171-.007c-1.11-.049-2.167-.128-2.654-.26a2.01 2.01 0 0 1-1.415-1.419c-.111-.417-.185-.986-.235-1.558L.09 9.82l-.008-.104A31 31 0 0 1 0 7.68v-.123c.002-.215.01-.958.064-1.778l.007-.103.003-.052.008-.104.022-.26.01-.104c.048-.519.119-1.023.22-1.402a2.01 2.01 0 0 1 1.415-1.42c.487-.13 1.544-.21 2.654-.26l.17-.007.172-.006.086-.003.171-.007A100 100 0 0 1 7.858 2zM6.4 5.209v4.818l4.157-2.408z"></path>
                                    </svg>
                                </span>
                            </legend>
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="form-group col-sm-6">
                                        <label class="control-label" for="id_empreendimento">
                                            Empreendimento:<span class="require" style="color: red">*</span>
                                        </label>
                                        <select class="form-control select2 empreendimento_transferencia"
                                                id="id_empreendimento" name="id_empreendimento" required="required"
                                                data-placeholder="Selecione o empreendimento">
                                            <option value=""></option>
                                            <?php foreach ($listaEmpreendimento as $k => $empreendimento) : ?>
                                                <option
                                                        value="<?= $empreendimento['id']; ?>"<?php if ($dados['idEmpreendimento'] == $empreendimento['id']): ?> selected<?php endif; ?>>
                                                    <?= $empreendimento['nm_empreendimento']; ?>
                                                </option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="form-group col-sm-6">
                                        <label class="control-label" for="id_contrato">
                                            Contrato cedente:<span class="require" style="color: red">*</span>
                                        </label>
                                        <select class="form-control select2 contrato_cedente" name="id_contrato"
                                                id="id_contrato" data-placeholder="Selecione o cedente" required="required">
                                        </select>
                                        <input id="idCedente" type="hidden">
                                    </div>
                                    <div class="form-group col-sm-6" id="divCedentes" hidden="hidden">
                                        <label class="control-label" for="id_contrato">
                                            Outros cedentes:
                                        </label>
                                        <ul id="pessoas_envolvidas">
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="form-group col-sm-9">
                                        <label for="idReceptor" class="control-label">Cessionrio:
                                            <span class="text-danger" title="Este campo  obrigatrio.">*</span>
                                        </label>
                                        <select class="form-control select2BigData clientesTransferencia"
                                                data-placeholder="Digite o nome do cessionrio" name="idReceptor"
                                                id="idReceptor"
                                                required="required">
                                            <option value=""></option>
                                        </select>
                                    </div>
                                    <div class="form-group col-sm-3" id="participacaocomprador" <?= (!$pessoas_envolvidas)?'hidden':''?>>
                                    <label class="control-label" for="valor_participacao"> % de participao:<span class="require" style="color: red">*</span></label>
                                    <input type="text" class="form-control money participacao" id="participacao" 
                                           name="participacao" value="<?= $contrato['porcentagem_participacao_contrato']?$contrato['porcentagem_participacao_contrato']:"10000"?>"
                                           placeholder="Digite o valor da participacao">
                                    </div>

                                </div>
                            </div>
                            <!-- Outros compradores -->
                            <div class="row" id="rowOutrosPadrao"> 
                                <div class="col-sm-12">
                                    <div class="form-group col-sm-6">
                                        <label for="outrosCompradores" class="control-label">Outros cessionrios:
                                            <span class="text-danger" title="O cliente j? foi selecionado." id="msgCompradores" hidden="hidden">O cliente s pode ser selecionado uma vez.</span>
                                        </label>
                                        <select class="form-control clientesContrato" name="pessoas_envolvidas[]"
                                                id="outrosCompradores" <?= $gerado ?>>
                                            <option value=""></option>
                                            <?php if (isset($pessoas_envolvidas)): ?>
                                            <option selected
                                                    value="<?= $pessoas_envolvidas['id'] ?>"><?= $pessoas_envolvidas['nm_pessoa'] ?></option>
                                            <?php endif; ?>
                                        </select>
                                    </div>
                                    <div class="form-group col-sm-4" >
                                        <label class="control-label" for="valor_participacaoOutros"> % de participao:</label>
                                        <input type="text" class="form-control money participacaoOutros" id="participacaoOutros" 
                                            name="participacaoOutros" value="<?= $pessoas_envolvidas['porcentagem_participacao_contrato']?>"
                                            placeholder="Digite o valor da participacao">
                                    </div>
                                    <div class="form-group col-sm-2">
                                        <label class="control-label"></label>
                                        <span class="input-group-btn">
                                                <button class="btn btn-primary tipo_parcela_add" type="button" id="adicionarOutros"
                                                        data-toggle="tooltip" <?= $gerado ?> title="ADICIONAR">
                                            <span class="glyphicon glyphicon-plus-sign" aria-hidden="true">
                                                </button>
                                            </span>
                                    </div>
                                </div>
                            </div>
                            <!-- Tabela de outros compradores -->
                            <div class="row" id="divTabelaIndices" <?= (!$pessoas_envolvidas)?'hidden':''?>>
                                <div class="col-sm-12">
                                    <div class="col-sm-7 form-group">
                                        <div class="table-responsive">
                                            <table class="table  table-hover table-condensed order-column"
                                                cellspacing="0" width="100%">
                                                <thead>
                                                <tr>
                                                    <th>Comprador</th>
                                                    <th>% de participao</th>
                                                    <th>Aes</th>
                                                </tr>
                                                </thead>
                                                <tbody id="tableIndices">
                                                <?php
                                                $contador = 1;
                                                if(is_array($pessoas_envolvidas)):
                                                    foreach($pessoas_envolvidas as $pessoas):
                                                    ?>
                                                        <tr id="indice<?= $contador?>">
                                                            <td id="outrasPessoas" value="<?= $pessoas['id']; ?>"><?= $pessoas['nm_pessoa']?></td>
                                                            <td> <?= $pessoas['porcentagem_participacao_contrato']?></td>
                                                            <td>
                                                                <div align="center" style="width: 100%;">
                                                                    <button data-toggle="tooltip" title="REMOVER" class="btn btn-default btn-xs remIndice"  type="button" id="btnPessoa_<?= $pessoas['id']; ?>" value="<?= ($contrato['fl_gerado'] != 1)?$contador:''?>">
                                                                        <i class="fa fa-times"></i>
                                                                    </button>
                                                                </div>
                                                            </td>
                                                            <input type="hidden" name="listaIndices[]" class="listaIndices" value="<?= $contador . '_' .
                                                            $pessoas['nm_pessoa'] . '_' . str_replace('.',',',$pessoas['porcentagem_participacao_contrato']) . '_' .
                                                            $pessoas['id']?>" />
                                                        </tr>
                                                    <?php $contador++; endforeach;
                                                    endif; ?>
                                                <input type="hidden" name="contador" id="contador" value="<?= $contador ?>"/>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="form-group col-sm-3">
                                        <label class="control-label" for="data">
                                            Data:<span class="require" style="color: red">*</span>
                                        </label>
                                        <input type="text" class="form-control data datepicker-input" id="data"
                                               name="data" onchange="attParcela();" value="<?= date('d/m/Y'); ?>"/>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="form-group col-sm-12">
                                        <label class="control-label" for="dsObs">
                                            Observao:
                                        </label>
                                        <textarea class="form-control" name="obs" id="dsObs" cols="50"
                                                  rows="5"></textarea>
                                    </div>
                                </div>
                            </div>
                            <h3>Dados das Parcelas</h3>
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="col-sm-6">
                                        <table class="table">
                                            <thead style="background-color: #cccccc">
                                            <tr>
                                                <td align="center">Tipo de parcela</td>
                                                <td align="center">Quantidade</td>
                                            </tr>
                                            </thead>
                                            <tbody id="listaParcelas" style="background-color: #DDDDDD">
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </fieldset>

                        <fieldset>
                            <legend>Operaes</legend>
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="form-group col-sm-2">
                                        <input type="submit" class="btn btn-primary col-sm-12 fDesabilitaBtn" value="Salvar">
                                    </div>
                                    <div class="form-group col-sm-2">
                                        <a href="?m=<?= $_GET['m'] ?>&c=<?= ($_GET['c']); ?>&a=listar"
                                           class="btn btn-danger col-sm-12">Cancelar </a>
                                    </div>
                                </div>
                            </div>
                        </fieldset>
                    </form>

                </div>
        </div>
    </div>
<div class="modal fade mVisualizar " tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel"
    aria-hidden="true">
    <div class="modal-dialog modal-lg ">
        <div class="modal-content">

            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal"
                        aria-hidden="true">&times;</button>
                <h2 class="modal-title" id="myModalLabel" align="center"><i class="fa fa-book"></i>
                    Tutorial</h2>
            </div>

            <div class="modal-body tableFix" style="max-height:600px;">
                <fieldset >
                    <legend>Transferncia Titularidade - Cadastro, Edio, Excluso e Emisso</legend>
                    <div class="row" style="margin-right: 0px;margin-left: 0px;">
                        <iframe width="560" height="500" src="https://www.youtube-nocookie.com/embed/1Zp0UpPCr8g?si=tjy2AlfAzUN07E2g" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>                        
                    </div>
                    <div></div>
                </fieldset>
            </div>
        </div>
    </div>
</div>
<?php require_once 'layout/includes/footer.php'; ?>