<?php
require_once 'layout/includes/header.php';
require_once 'layout/includes/menu.php';
$listaEmpreendimento = $this->get('empreendimentos');
$listaUsuario = $this->get('usuarios');
?>

<div class="content">
        <div class="page-heading">
            <?= $this->getHeader(); ?>
        </div>
        <div class="widget">
            <div class="widget-content padding">
                <div class="modal fade mVisualizar " tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel"
                     aria-hidden="true">
                    <div class="modal-dialog modal-lg ">
                        <div class="modal-content">

                            <div class="modal-header">
                                <button type="button" class="close" data-dismiss="modal"
                                        aria-hidden="true">&times;</button>
                                <h2 class="modal-title" id="myModalLabel" align="center"><i class="fa fa-eye"></i>
                                    Visualizar</h2>
                            </div>

                            <div class="modal-body tableFix">
                                <fieldset>
                                    <legend>Informaes do Processo</legend>
                                    <div class="row">
                                        <div class="form-group col-sm-8">
                                            <label for="cliente" class="control-label">Cliente: <strong><span
                                                        id="cliente"></span></strong></label>
                                        </div>
                                        <div class="form-group col-sm-4">
                                            <label for="tipo" class="control-label">Tipo: <strong><span
                                                        id="tipo"></span></strong></label>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="form-group col-sm-4">
                                            <label for="quadra" class="control-label">Quadra: <strong><span
                                                        id="quadra"></span></strong></label>
                                        </div>
                                        <div class="form-group col-sm-4">
                                            <label for="lote" class="control-label">Lote: <strong><span
                                                        id="lote"></span></strong></label>
                                        </div>
                                        <div class="form-group col-sm-4">
                                            <label for="contrato" class="control-label">Contrato: <strong><span
                                                        id="contrato"></span></strong></label>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="form-group col-sm-4">
                                            <label for="dtNotificacao" class="control-label">Data de notificao:
                                                <strong><span id="dtNotificacao"></span></strong></label>
                                        </div>
                                        <div class="form-group col-sm-4">
                                            <label for="dtAudiencia" class="control-label">Data da audincia:
                                                <strong><span id="dtAudiencia"></span></strong></label>
                                        </div>
                                        <div class="form-group col-sm-4">
                                            <label for="tpAudiencia" class="control-label">Audincia: <strong><span
                                                        id="tpAudiencia"></span></strong></label>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="form-group col-sm-6">
                                            <label for="processo" class="control-label">Processo: <strong><span
                                                        id="processo"></span></strong></label>
                                        </div>
                                        <div class="form-group col-sm-6">
                                            <label for="local" class="control-label">Local: <strong><span
                                                        id="local"></span></strong></label>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="form-group col-sm-12">
                                            <label for="resumo" class="control-label">Resumo do processo: <br>
                                                <strong><span id="resumo"></span></strong></label>
                                        </div>
                                    </div>
                                </fieldset>
                            </div>
                            <div class="modal-footer">
                                <a id="btnEditarRegistro" class="btn btn-danger">Editar registro</a>
                                <button type="button" class="btn btn-default" data-dismiss="modal" id="cancelModal">
                                    Fechar
                                </button>
                            </div>

                        </div>
                    </div>
                </div>
                <?= ($_GET["msg"] == "ok") ? '<div class="alert alert-success alert-dismissable">Operao realizada com sucesso.</div>'
                    : (($_GET['exception'] != '') ? '<div class="alert alert-danger alert-dismissable">' . $_GET['exception'] . '</div>' : '');
                ?>
                <?php if ($this->_helper->getMensagem("erro")): ?>
                    <div
                         class="alert alert-danger alert-dismissable"><?= $this->_helper->getMensagem("erro"); ?></div>
                <?php endif; ?>

                <?php if (isset($_GET["idEmpreendimento"])): ?>
                    <input type="hidden" id="keepIdEmpreendimento" value="<?= $_GET["idEmpreendimento"]; ?>">
                <?php endif; ?>

                <div class="row">
                    <div class="form-group col-sm-6">
                        <label class="control-label" for="id_empreendimento">
                            Empreendimento:
                        </label>
                        <select class="form-control select2 empreendimento_crm"
                                data-placeholder="Escolha o empreendimento" id="id_empreendimento"
                                name="id_empreendimento">
                            <option value="">Selecione ...</option>
                            <?php foreach ($listaEmpreendimento as $empreendimento) : ?>
                                <option <?= (isset($_GET["idEmpreendimento"]) && $empreendimento['id'] == $_GET["idEmpreendimento"]) ? 'selected' : '' ?>
                                    value="<?= $empreendimento['id']; ?>">
                                    <?= $empreendimento['nm_empreendimento']; ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div>
                <div class="table-responsive">
                    <table id="TabelaListar"
                           class="table  table-hover table-condensed order-column"
                           cellspacing="0" width="100%">

                        <div class="btnAdicionar">
                            <a class="btn btn-success" href="?m=adm&amp;c=juridico&amp;a=adicionar">
                                <i class="fa fa-plus-circle"></i> Adicionar</a>
                        </div>
                        <div class="radioAprovados">
                            <select id="tipoContrato" class="form-control input-sm" name="tipoContrato" style="margin: -5px 10px;  height: 35px;">
                                <option value="0">Todos</option>
                                <option value="1">Ativos</option>
                                <option value="2">Distratados</option>
                            </select>
                        </div>
                        <thead>
                        <tr>
                            <th width="30%">Cliente</th>
                            <th>Qd</th>
                            <th>Lt</th>
                            <th>
                                <div align="center">Contrato</div>
                            </th>
                            <th>
                                <div align="center">Notificao</div>
                            </th>
                            <th>
                                <div align="center">Audincia</div>
                            </th>
                            <th>
                                <div style="width:100px" align="center">Local</div>
                            </th>
                            <th style="width: 210px;">
                                <div align="center">Aes</div>
                            </th>
                        </tr>
                        </thead>
                    </table>
                </div>
        </div>
    </div>
</div>
<?php require_once 'layout/includes/footer.php'; ?>
